/** @preserve Eloquence WEBDLG v2
 (C) Copyright Marxmeier Software AG, 2020-2025
 Version: 2.0.20
 $Id: 00-load.js,v 28.89 2025/07/09 09:18:17 mike Exp $
*//*======================================================================
   WEBDLG v2 namespace
========================================================================*/

var eq = {};

/*========================================================================
   Load main thread script or handle page redirection.
========================================================================*/

(function() {
   // Check page URL for query string app= parameter.
   var wl = window.location, url = wl.href, app, ws, r, q, re, sc;
   try {
      app = /[?&]app=([^&#]+)/i.exec(url)[1];
   } catch (e) {}
   if (app) {
      // Query string app= parameter specified, override application.
      (ws = window.sessionStorage).setItem('eq-webdlg.app', app);
      // Initialize user agent tag and session id.
      ws.removeItem('eq-webdlg.uat');
      ws.removeItem('eq-webdlg.sid');
      // Reload page wo/ query string app= parameter.
      eq.redirected = true;
      if (q = (r = /^([^?#]+)([?][^#]*)?(#.*)?$/.exec(url))[2])
         if (q.match(re = new RegExp('([?&])app=[^&#]*', 'i'))) {
            q = q.replace(re, '');
            if (q.length && q.charAt(0) === '&')
               q = q.replace('&', '?');
         }
      url = r[1];
      if (q)
         url += q;
      if (r[3])
         url += r[3];
      wl.replace(url);
   }
   else {
      // Load eq-webdlg-ui.js script.
      try {
         // Obtain script base URI from script URI.
         url = document.querySelector('script#eq-webdlg').src;
         sc = document.createElement('SCRIPT');
         sc.src = /^([^?#]+\/)[^/?#]+/.exec(url)[1] + "eq-webdlg-ui.js";
         sc.defer = true;
         document.head.appendChild(sc);
      }
      catch (e) {
         throw new Error("WEBDLG: <script id=\"eq-webdlg\"> not found");
      }
   }
})();

/*========================================================================
   Plugin declaration interface.
========================================================================*/

eq.plugin = function(name, decl) {
   var m = this.plugin.m;
   if (m === undefined)
      m = this.plugin.m = new Map();
   m.set(name, decl);
};

/*========================================================================
   Strings registration.
========================================================================*/

eq.strings = function(strings, locale) {
   var m = this.strings.m, lv, l;
   if (m === undefined)
      m = this.strings.m = new Map();
   if (locale) {
      if ((lv = locale.split('-')).length > 1 && !m.has(l = lv[0]))
         m.set(l, strings);
      m.set(locale, strings);
   }
   else
      m.set('default', strings);
};

