# @(#) eloqwebd2.app - B.08.40 ($Revision: 29.7 $)
#
# The purpose of this file is to configure the applications
# the eloqwebd2 server can start. It is installed in the location:
# C:\Program Files\Eloquence\8.4\etc\eloqwebd2.app
#
# This file is read at eloqwebd2 startup.
# Changes are automatically detected and honored.
#
# Format:
#
# The section names are not case sensitive. String values can be
# enclosed in double quotes to protect leading or trailing spaces.
# Everything after a hash (#) character is considered a comment.
#
# Each application definition is a separate section. The section
# header in square brackets specifies the application identifier
# (app_id) used in the HTML document which invokes the application.
#
# A [default] section may be specified to define configuration items
# which are common to all applications.
#
# The following configuration items are recognized for each section:
#
# [app_id]
#
# Title     Specifies the application display title. HTML formatting may
#           be used, the title then needs to begin with: <html>
#           If not configured, the application identifier (app_id) is used.
#
# GroupList Comma- or space-separated list of group names, used to enable
#           or reject access to the application based on group membership.
#
#           If configured, the eloqsd server login must be a member of
#           at least one of the listed groups, otherwise access to the
#           application is denied.
#
#           Group membership is managed by the eloqsd server.
#
#           Please note that this requires eloqsd patch PE83-2206290 or newer.
#
# Allow
# Deny      Used to enable or reject access to the application based
#           on the client network address.
#
#           Allow/Deny argument syntax:
#           { All | hostname | ip-address [/{addrbits|netmask]} }
#
#           Multiple Allow/Deny entries are recognized and combined.
#
#           hostname is the name of a host or network that is resolved
#           into one or more ip addresses.
#
#           ip-address is either an IPv4 or IPv6 address.
#
#           * An IPv6 address, enclosed in square brackets, such
#           as [::1]. The addrbits option may be used to specify
#           the number of relevant bits in the IP address.
#
#           * An IPv4 address, such as 127.0.0.1. The addrbits option
#           may be used to specify the number of relevant bits in the
#           IP address. The netmask option allows to specify an IPv4
#           network mask, such as 255.255.255.0.
#
#           If neither Allow nor Deny are configured, access to
#           the application is enabled from all network addresses
#           (implied Allow=All).
#
#           If Allow and/or Deny are configured, access to the
#           application is denied unless specifically allowed
#           (implied Deny=All).
#
# Server    Specifies the address to connect the eloqsd server which
#           is used to start the application.
#
#           A host name or IP address may be specified, optionally
#           followed by a colon and a service name or port number.
#           An IPv6 address must be specified in square brackets.
#
#           The default is: localhost:eloqsd
#
#           For example:
#              hcluster2-eloq.foo.com:8100
#              192.168.22.33:eloqsd
#              [fe80::225:b3ff:fecf:362]:8100
#
# TLS       If nonzero, the eloqsd and DLG communication is secured
#           with TLS-encryption. This requires that the eloqsd server
#           is configured for TLS-encrypted communication.
#
# Command   Specifies the command line to start the application.
#
#           Command line arguments are separated with spaces. If an
#           argument contains space characters it must be enclosed
#           in single or double quotes.
#
#           Token resolving:
#
#           $remoteaddr - client (web browser) IP address
#           $remotename - client (web browser) host name
#           $remoteport - client (web browser) TCP port number
#           $login      - eloqsd login used to start the application
#           $session    - session serial number
#           $uri        - WebSocket request URI (without query string)
#
#           $(VARIABLENAME) - value of an environment variable,
#           including any variable specified with the Environment
#           configuration and any application argument passed as
#           environment variable (see below).
#
#           $http(HEADERNAME) - value of a WebSocket request header.
#           HEADERNAME is case-insensitive.
#
#           Multiple Command entries are recognized. The command
#           line is formed by concatenating the Command entries
#           in the specified order.
#
# Login     Specifies the eloqsd server login required to start
#           the application. Token resolving is applied as explained
#           in the Command section above. If not configured, login
#           credentials are requested by the client (web browser).
#
# Password  Specifies the eloqsd server password required to start
#           the application. This is not used if Login is not set.
#           Token resolving is applied as explained in the Command
#           section above. If not configured, login credentials are
#           requested by the client (web browser).
#
# LoginDomain  Specifies an optional string used to mark related
#           applications where a successful interactive login is
#           cached (see LoginCacheMax and LoginCacheTimeout in the
#           eloqwebd2.cfg configuration file).
#
#           The interactive login dialog contains a Save Login option
#           which is checked by default when the application has a
#           non-empty LoginDomain configured (depends on the SaveLogin
#           configuration, see below). When this option is checked and
#           the user logs in, the login name and password are cached
#           for this LoginDomain (if set) and server address.
#
#           The default is: not set (LoginDomain not specified)
#
# SaveLogin  If Login and Password are set and SaveLogin is configured
#           and nonzero, the login name and password are cached for this
#           LoginDomain (if set) and server address when the application
#           has started successfully.
#
#           If Login and/or Password are not set, SaveLogin specifies how
#           the Save Login option of the interactive login dialog is set:
#
#           SaveLogin not configured
#              The Save Login option is checked when the application
#              has a non-empty LoginDomain configured.
#
#           SaveLogin configured and nonzero
#              The Save Login option is checked.
#
#           SaveLogin configured and zero
#              The Save Login option is not checked.
#
#           The default is: not configured (SaveLogin has no effect)
#
# StartDir  Used to set the current directory where an application
#           is started. Token resolving is applied as explained in
#           the Command section above.
#
#           The default is: not set (start directory unspecified)
#
# Environment  Specifies an environment variable to be passed to
#           the application. Token resolving is applied as explained
#           in the Command section above.
#           Multiple Environment entries are recognized and combined.
#
# ArgEnvAccept
# ArgAtomAccept  Comma- or space-separated list specifying which
#           URL query string arguments are accepted to be passed
#           to the application.
#
#           ArgEnvAccept lists the argument names which are allowed
#           to be passed as environment variables.
#
#           ArgAtomAccept lists the argument names which are allowed
#           to be passed as atoms in the System object.
#
#           Please note that the argument name comparison is case
#           sensitive.
#
# ArgEnvPrefix
# ArgAtomPrefix  Allows to specify a name prefix for any argument
#           passed to the application.
#
#           ArgEnvPrefix specifies a prefix for arguments passed as
#           environment variables.
#
#           ArgAtomPrefix specifies a prefix for arguments passed as
#           atoms in the System object.
#
# PluginURL  Specifies a JavaScript or CSS plugin URL to inject into
#           the HTML document when the application is started.
#
#           This allows to use a default HTML document and to add
#           custom JavaScript and/or CSS based on the application,
#           for example: PluginURL = /path/to/eq-strings.js
#
#           Multiple PluginURL entries are recognized and injected
#           in the specified order.
#
# CssClass  Comma- or space-separated list specifying CSS class names
#           which are set on the <html> document element while the
#           application is active. This allows to style a document
#           based on a specific application.
#
# DlgIdleTimeout  Specifies the maximum time in seconds an application
#           may be idle. The application is terminated if it does not
#           get any user input for longer than the specified time.
#
#           A suffix may be optionally appended:
#
#              m - minutes (60 seconds)
#              h - hours   (3600 seconds)
#              d - days    (86400 seconds)
#              w - weeks   (604800 seconds)
#
#           If set to zero the application never times out.
#
#           The default is: 1h (one hour, 3600 seconds)
#
#           The Application.expires attribute may be used to
#           programmatically set or query this configuration.
#
# DlgQuitStatus  Specifies a DLG status to be returned to the program
#           before the application is terminated due to inactivity or
#           after the web browser window or tab has been closed.
#
#           This allows the application to gracefully quit. If it is
#           currently waiting in DLG DO or POPUP BOX, this status is
#           returned, i.e., typically an Eloquence ON ERROR handler is
#           called. The DLG connection remains active. The application
#           is then expected to quit as soon as possible.
#
#           The specified status must be at least 650. To distinguish
#           this from other error conditions it is possible to specify
#           an undefined Eloquence error code, for example: 688
#
#           This takes precedence over the DlgQuitRule configuration
#           (see below). If neither DlgQuitStatus nor DlgQuitRule are
#           set, the DLG connection is closed and the application
#           receives DLG status 684.
#
#           The default is: 0
#
#           The Application.quitstatus attribute may be used to
#           programmatically set or query this configuration.
#
# DlgQuitRule  Specifies a rule value to be returned to the program
#           before the application is terminated due to inactivity or
#           after the web browser window or tab has been closed.
#
#           This allows the application to gracefully quit. If it is
#           currently waiting in DLG DO, this rule is returned. If it
#           is currently waiting in POPUP BOX, button -1 is returned.
#           The DLG connection remains active. The application is then
#           expected to quit as soon as possible.
#
#           The DlgQuitStatus configuration takes precedence (see above).
#           If neither DlgQuitStatus nor DlgQuitRule are set, the DLG
#           connection is closed and the application receives DLG status 684.
#
#           The default is: 0
#
#           The Application.quitrule attribute may be used to
#           programmatically set or query this configuration.
#
# DlgQuitTimeout  When DlgQuitStatus or DlgQuitRule are set (see above)
#           this specifies an additional timeout in seconds to allow the
#           application to gracefully quit.
#
#           The default is: 5 (seconds)
#
#           The Application.quittimeout attribute may be used to
#           programmatically set or query this configuration.
#
# Driver    Specifies the driver type reported to the program.
#           The default is: WEB2
#
# Locale    Specifies the application locale which defines international
#           settings such as numeric and date formats. If not set, the
#           user's browser locale is used.
#
#           To set a specific application locale, an IETF BCP 47 language
#           tag must be used, for example:
#              en-US - English (United States)
#              en-GB - English (United Kingdom)
#              fr-FR - French (France)
#              de-DE - German (Germany)
#
#           The default is: not set (use browser locale)
#
# DefaultFontFace  Specifies the Dialog default font family name.
# DefaultFontSize  Specifies the Dialog default font size.
#
#           These default font properties are used if a Dialog does not
#           have the fontface/fontsize/fontstyle attributes set.
#           The Dialog raster calculation is based on the Dialog font.
#
#           DefaultFontSize allows to specify a unit, for example: 16px
#           If no unit is specified, pt (point) is assumed.
#
#           The default is: not set (use browser font)
#
# FontSizeFactor  Factor to increase or reduce the Dialog and object
#           font sizes (decimal number, for example 0.9 to reduce to
#           90% of the font size set for a Dialog or object).
#
#           This might help to adjust the Dialog appearance for
#           applications originally written for JDLG because the
#           browser might render certain fonts differently than
#           Java. For example, Java might render a font with 12pt
#           size although an object has fontsize=13 set, while
#           the browser renders the font with 13pt size. In such
#           a case, setting FontSizeFactor=0.923 will reduce the
#           font size from 13pt to 12pt, to achieve a Dialog
#           appearance in the browser similar to JDLG.
#
#           Please note: This factor is not applied to calculate
#           the Dialog raster.
#
#           The default is: not set (use font sizes as specified)
#
# IgnoreDialogFont  If set to a nonzero value, any Dialog font attributes
#           set by the application are ignored, instead the default font
#           is used (see above). If the default font is not configured
#           the browser font is used.
#
#           This might help to achieve a unified Dialog appearance
#           for applications originally written for JDLG, by using
#           the same font attributes for all Dialogs even if different
#           Dialog font attributes are set.
#
#           Please note: This only applies to the Dialog font attributes,
#           child objects are not affected.
#
#           The default is: 0 (use Dialog font attributes as specified)
#
# BaseURL   Specifies the global base URL.
#
# HelpBaseURL  Specifies the global base URL for the help system.
#
# LogoIcon  URL to specify the application logo/icon. If a relative
#           URL is set, the global or application-specific base URL
#           is prepended. If not set, the Eloquence icon is used.
#
#           The default is: not set (use Eloquence icon)
#
# Atom.NAME Sets an atom named NAME in the System object. Token resolving
#           is applied as explained in the Command section above.
#
# Layout    Specifies how Dialogs are displayed. Supported modes are:
#
#           Layout = dialog
#
#              Dialog windows are used. All visible Dialogs are displayed,
#              the active Dialog is topmost.
#
#           Layout = inline
#
#              The active Dialog is displayed inline in the HTML document
#              at the top/left position in the Dialog container element.
#              No other Dialogs are displayed.
#
#           Layout = inline max
#
#              The inline Dialog is maximized so that it covers the entire
#              container element.
#
#           Layout = inline dialog
#           Layout = inline max dialog
#
#              If multiple Dialogs are visible, Dialog windows are used
#              except for the Dialog at the bottom which is displayed inline
#              (and maximized if the 'max' keyword is specified).
#
#           The default is: dialog
#
#           Please note that individual Dialogs can override the
#           specified layout mode:
#
#           1) A Dialog is always inline if resizepolicy="inline" is set.
#
#           2) A Dialog is always inline if the x/y/w/h attributes
#              are not set, or if they are all set to zero.
#
#           3) A Dialog is always inline if the xauto/yauto attributes
#              are set to a value other than 1.
#              The xauto/yauto modes 0 and -1 may be used if the Dialog
#              position in the container element should be different
#              from top/left.
#
# EnableMaximize  Specifies the default to enable or disable the Dialog
#           auto-maximize function. This default may be overridden via
#           the System.enablemaximize and the Application.enablemaximize
#           and the Dialog.enablemaximize attributes.
#
#           If set to a nonzero value, the session's auto-maximize status
#           is adjusted when a Dialog is maximized or normalized. When a
#           new Dialog is opened or made visible and the Dialog.maximized
#           attribute was not explicitly set, the Dialog is maximized or
#           normalized according to the session's auto-maximize status,
#           and the Dialog.maximized attribute is adjusted. This allows
#           the user to control whether an application's Dialogs should
#           appear maximized or not.
#
#           If set to zero, the Dialog.maximized attribute is used when a
#           new Dialog is opened or made visible. Maximizing or normalizing
#           a Dialog does not affect the session's auto-maximize status.
#
#           The default is: 1 (auto-maximize function enabled)
#
# NotifyBusy  If set to a nonzero value, a beep notification will be issued
#           on any mouse or key event that is dropped while a Dialog is not
#           interactive, i.e., currently outside DLG DO. May be overridden
#           via the System.notifybusy attribute.
#
#           The default is: 1 (beep notification enabled)
#
# TypeAhead  If set to a nonzero value, the typeahead function is
#           enabled. The typeahead function prevents characters from
#           being lost if they are typed while the Dialog is not
#           interactive, i.e., currently outside DLG DO.
#
#           The default is: 1 (typeahead function enabled)
#
# PrinterName  Specifies the value returned by the Application printername
#           and printers attributes. This is a JDLG compatibility option,
#           applications originally written for JDLG might use this to display
#           a printer selection.
#
#           The default is: PDF
#
# StrictMode  If set to a nonzero value, strict attribute value checking
#           is enabled. By default, JDLG behavior is applied where setting
#           attribute values is loosely checked. For example, setting the
#           ListBox.topitem attribute out-of-range is accepted by JDLG
#           but results in DLG STATUS 660 if StrictMode is set.
#
#           The default is: 0 (JDLG-compatible value checking enabled)
#
# PopupPosition  Specifies the position of popup windows (login dialog,
#           message dialog, POPUP BOX). The position is specified by the
#           top/left/center keywords which may be combined, separated
#           with a space character, for example:
#              top left   - vertical top and horizontal left position
#              top center - vertical top position, horizontally centered
#              top        - same as above
#           Optionally, the popup dialog type may be specified if not all
#           types should be affected. Possible types (may be combined):
#              login   - login dialog
#              message - message dialog
#              box     - POPUP BOX
#           For example, if the login and message dialogs should be displayed
#           at the vertical top position and horizontally centered, but the
#           POPUP BOX should use the default (centered both horizontally and
#           vertically):
#              login message top
#
#           The default is: center (all popup dialog types centered both
#           horizontally and vertically)
#
# WindowFeatures.NAME  Allows to configure how new web browser windows/tabs
#           are opened, applied when Application.browser is invoked, and
#           when Application.start/System.start are used to start secondary
#           sessions, and when help URLs are opened.
#
#           The specified value is passed to the JavaScript Window.open()
#           method as windowFeatures argument, see also:
#           https://developer.mozilla.org/en-US/docs/Web/API/Window/open
#
#           NAME defines which window/tab class is affected:
#              DOC     - affects windows/tabs opened via Application.browser
#              HELP    - affects help windows/tabs
#              PRINTER - affects webprint windows/tabs
#
#           For example, to define that help URLs should open in a separate
#           browser window having a specific size:
#
#              WindowFeatures.HELP = popup,width=800,height=600
#
#           If NAME is set to an application identifier (app_id) it affects
#           Application.start/System.start for this application, such as:
#
#              WindowFeatures.MENU = popup,width=600,height=450
#
#           Coordinate values may be specified as a percentage, for example:
#
#              WindowFeatures.NAME = popup,width=30%,height=50%
#
#           The percentage values refer to the available screen dimensions.
#           Optionally, minimum and/or maximum values may be specified:
#
#              width=600<30% width=800>30% width=600<800>30%
#
#           The examples above specify a minimum value, a maximum value,
#           and both minimum and maximum values. They calculate a 30%
#           width and, if neccesary, clamp the result to a minimum of 600
#           and/or to a maximum of 800.
#
#           Please note: Application.start/System.start may be invoked with
#           specific window/tab features which take precedence. For example,
#           to open an application in a separate browser window:
#
#              DLG SET "Application.start[popup]",App$
#
#           Application.browser allows to specify a target, such as:
#
#              DLG SET "Application.browser[forms]",Form_url$
#
#           Setting WindowFeatures.FORMS would allow to configure features
#           for this window/tab class.
#
#           The Application.windowfeature[name] attribute may be used to
#           programmatically set or query this configuration.
#
# ShowStartErrors  If set to a nonzero value, a possible application start
#           error message (for example 'authorization failed: bad password')
#           is displayed to the user. This can be disabled by setting
#           ShowStartErrors to zero.
#
#           The default is: 1 (error messages are displayed)
#
# WarnLeavingPage  If set to 1, the user is warned before leaving the page
#           (e.g., when trying to close the web browser window or tab),
#           to prevent unintentional program termination.
#
#           The warning is issued if the user tries to leave the page while
#           the program is not interactive, i.e., currently outside DLG DO,
#           or when the current Dialog's rule attribute value is zero
#           (i.e., the current Dialog does not display the close symbol in
#           its title bar).
#
#           Please note: The warning is implicitly disabled during application
#           development and debugging, i.e., when a DLG listener is used to
#           start an application.
#
#           If set to 2, the warning is always enabled while an application
#           is active, regardless whether or not the current Dialog has the
#           close symbol, and during application development and debugging.
#
#           The default is: 1 (warning is enabled)
#
# DlgPort   Comma- or space-separated list specifying DLG listen ports or
#           port ranges, for example: DlgPort = 8011, 8012-8015
#
#           If configured, this allows application development and debugging
#           using the interactive eloq/eloqcore or the Eloquence IDE.
#
#           Port 8011 is the default DLG port. For example, JDLG by default
#           accepts new DLG connections on port 8011. A port range may be
#           useful for a development team where each developer would use
#           a separate port.
#
#           The DLG listener is opened by invoking a configured application
#           with the port number appended, separated by a : colon, such as:
#           http://SERVER.NAME/APPLICATION:8011
#
#           This loads the specified application configuration but ignores
#           the Server, TLS, Command, Login, Password, LoginDomain, StartDir,
#           Environment, ArgEnvAccept, ArgEnvPrefix items, they are irrelevant
#           because the application is not started, instead a DLG listener
#           is opened.
#
#           The HTML document displays a message to indicate that the listener
#           has been opened. The program or the IDE debug session may then be
#           started. To establish the DLG connection, the -dlg ADDRESS command
#           line option or the  DLG SET ".driver","ADDRESS" instruction may be
#           used. ADDRESS should specify the host name or IP address of the
#           system running the eloqwebd2 server (not the user's PC).
#           If a port different from 8011 is used it needs to be appended,
#           separated by a : colon.
#
#           The listener is closed after DlgConnectTimeout seconds if no DLG
#           connection is established (no program or debug session connects).
#           See: eloqwebd2.cfg [Limits] DlgConnectTimeout, default: 1 minute.
#
#           For example, assumed an Eloquence IDE debug session where the
#           program is started via eloqsd, and eloqsd on the same system
#           with eloqwebd2, using DLG port 8015, the command line should
#           contain: -dlg localhost:8015
#
# AllowDlg
# DenyDlg   Used to enable or reject access to the application based
#           on the client network address when a DLG listener should
#           be opened, allowing to restrict DlgPort access, for example
#           to grant access to the development team only.
#
#           The argument syntax is identical to Allow/Deny (see above).


# The example configuration below starts the EXAMPLE,APP program, using
# the local eloqsd server interactively requesting the login credentials.
# It expires if there is no user input for more than 10 minutes.

#[EXAMPLE]
#Command = EXAMPLE,APP
#Environment = HOME=C:\Users\$login
#DlgIdleTimeout = 10m

# The example configuration below starts the Eloquence dbutil program
# using the local eloqsd server. This requires a configured [dbutil]
# section in the eloqsd.app configuration.

#[DBUTIL]
#Command = dbutil
#Driver = JDLG

