/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.api;

import com.eloquence.api.EqOvrCaret;
import com.eloquence.services.jdlg.controls.ESystem;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class EqTextField
extends JTextField {
    protected Caret insCaret = this.getCaret();
    protected Caret ovrCaret;
    protected static Keymap sharedKeymap;
    protected static final String keymapName = "InsOvrMap";
    public static final String toggleInsOvrAction = "toggle-ins-ovr";
    protected static final Action[] defaultActions;
    protected static JTextComponent.KeyBinding[] bindings;

    public EqTextField() {
        this(null, null, 0);
    }

    public EqTextField(String string) {
        this(null, string, 0);
    }

    public EqTextField(int n) {
        this(null, null, n);
    }

    public EqTextField(String string, int n) {
        this(null, string, n);
    }

    public EqTextField(Document document, String string, int n) {
        super(document, string, n);
        if (EqTextField.isOverwrite()) {
            this.checkOverwriteCaret();
            super.setCaret(this.ovrCaret);
        }
    }

    public void setKeymap(Keymap keymap) {
        if (keymap == null) {
            super.setKeymap(null);
            sharedKeymap = null;
            return;
        }
        if (this.getKeymap() == null) {
            if (sharedKeymap == null) {
                EqTextField.removeKeymap(keymapName);
                sharedKeymap = EqTextField.addKeymap(keymapName, keymap);
                EqTextField.loadKeymap(sharedKeymap, bindings, defaultActions);
            }
            keymap = sharedKeymap;
        }
        super.setKeymap(keymap);
    }

    public void replaceSelection(String string) {
        Document document;
        if (EqTextField.isOverwrite() && (document = this.getDocument()) != null && this.getSelectionStart() == this.getSelectionEnd()) {
            int n;
            int n2 = this.getCaretPosition();
            int n3 = document.getLength() - n2;
            if (n3 > (n = string.length())) {
                n3 = n;
            }
            try {
                document.remove(n2, n3);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.replaceSelection(string);
    }

    public static void setOverwrite(boolean bl) {
        ESystem.getObject().setOverwrite(bl);
    }

    public static boolean isOverwrite() {
        return ESystem.getObject().isOverwrite();
    }

    public void setCaret(Caret caret) {
        this.insCaret = caret;
        super.setCaret(caret);
    }

    private void checkOverwriteCaret() {
        if (this.ovrCaret == null) {
            this.ovrCaret = new EqOvrCaret();
            if (this.insCaret != null) {
                this.ovrCaret.setBlinkRate(this.insCaret.getBlinkRate());
            }
        }
    }

    public void setOverwriteCaret(Caret caret) {
        this.ovrCaret = caret;
    }

    public Caret getOverwriteCaret() {
        this.checkOverwriteCaret();
        return this.ovrCaret;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004) {
            this.selectCaret();
        }
        super.processFocusEvent(focusEvent);
    }

    protected void selectCaret() {
        Caret caret;
        if (EqTextField.isOverwrite()) {
            this.checkOverwriteCaret();
            caret = this.ovrCaret;
        } else {
            caret = this.insCaret;
        }
        Caret caret2 = this.getCaret();
        if (caret != caret2) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            this.select(0, 0);
            int n3 = caret2.getMark();
            int n4 = caret2.getDot();
            caret2.setVisible(false);
            super.setCaret(caret);
            caret.setDot(n3);
            caret.moveDot(n4);
            caret.setVisible(true);
            this.select(n, n2);
        }
    }

    static {
        defaultActions = new Action[]{new ToggleInsOvrAction()};
        bindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 0), toggleInsOvrAction)};
    }

    public static class ToggleInsOvrAction
    extends TextAction {
        ToggleInsOvrAction() {
            super(EqTextField.toggleInsOvrAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EqTextField.setOverwrite(!EqTextField.isOverwrite());
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof EqTextField) {
                EqTextField eqTextField = (EqTextField)jTextComponent;
                eqTextField.selectCaret();
            }
        }
    }
}

