/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.Application;

import com.eloquence.services.Application.ImagePanel;
import com.eloquence.services.Application.Redist;
import com.eloquence.services.Application.Version;
import com.eloquence.services.tools.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class AboutDialog
extends JDialog {
    static ImagePanel imagePanel = null;
    GridBagConstraints gbc = null;
    GridBagLayout layoutManager = new GridBagLayout();
    JButton leaveButton = new JButton();

    public static void setImage(Image image) {
        imagePanel = new ImagePanel(108, 64);
        imagePanel.setImage(image);
    }

    public AboutDialog(Frame frame) {
        super(frame);
        this.initDialog();
    }

    private final void initAllRightsReserved() {
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(1, 11, 5, 11);
        JLabel jLabel = new JLabel("All rights reserved.");
        jLabel.setForeground(Color.black);
        this.getContentPane().add((Component)jLabel, this.gbc);
    }

    private final void initCopyright() {
        this.gbc.insets = new Insets(11, 11, 0, 11);
        JLabel jLabel = new JLabel("Copyright \u00a9 2002-2025 Marxmeier Software AG.");
        jLabel.setForeground(Color.black);
        this.getContentPane().add((Component)jLabel, this.gbc);
    }

    private final void initCorrectConstraintsAfterImagePanel() {
        this.gbc.gridy = Redist.Version != null ? 4 : 3;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 2;
        this.gbc.gridheight = 1;
    }

    private final void initDialog() {
        this.initDialogInternals();
        this.initProductLabel();
        this.initModuleLabel();
        this.initVersionLabel();
        this.initRedistributionVersionLabel();
        this.initImagePanel();
        this.initCorrectConstraintsAfterImagePanel();
        this.initCopyright();
        this.initAllRightsReserved();
        this.initRedistributionCopyright();
        this.initJavaVersionLabel();
        this.initLeaveButton();
    }

    private final void initDialogInternals() {
        this.setTitle(Strings.get("aboutjdlg.title"));
        this.getContentPane().setLayout(this.layoutManager);
        this.gbc = new GridBagConstraints();
    }

    private final void initImagePanel() {
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(11, 11, 5, 11);
        imagePanel.setMinimumSize(new Dimension(150, 150));
        imagePanel.setPreferredSize(new Dimension(150, 150));
        this.getContentPane().add((Component)imagePanel, this.gbc);
    }

    private final void initLeaveButton() {
        ++this.gbc.gridy;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(11, 11, 11, 11);
        Strings.setButtonText(this.leaveButton, "aboutjdlg.dismiss");
        this.leaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.leaveButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.leaveButton, this.gbc);
    }

    private final void initModuleLabel() {
        ++this.gbc.gridy;
        JLabel jLabel = new JLabel("Java(tm) based Dialog Server");
        jLabel.setForeground(Color.black);
        this.getContentPane().add((Component)jLabel, this.gbc);
    }

    private final void initProductLabel() {
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 11, 5, 11);
        JLabel jLabel = new JLabel("Eloquence JDLG");
        jLabel.setForeground(Color.black);
        this.getContentPane().add((Component)jLabel, this.gbc);
    }

    private final void initRedistributionCopyright() {
        if (Redist.Copyright != null) {
            ++this.gbc.gridy;
            this.gbc.insets = new Insets(5, 11, 5, 11);
            JLabel jLabel = new JLabel(Redist.Copyright);
            jLabel.setForeground(Color.black);
            this.getContentPane().add((Component)jLabel, this.gbc);
        }
    }

    private final void initRedistributionVersionLabel() {
        if (Redist.Version != null) {
            ++this.gbc.gridy;
            this.gbc.insets = new Insets(1, 11, 5, 11);
            JLabel jLabel = new JLabel(Redist.Version);
            jLabel.setForeground(Color.black);
            this.getContentPane().add((Component)jLabel, this.gbc);
            this.gbc.gridheight = 4;
        } else {
            this.gbc.gridheight = 3;
        }
    }

    private final void initVersionLabel() {
        if (Redist.Version != null) {
            this.gbc.insets = new Insets(5, 11, 0, 11);
        }
        ++this.gbc.gridy;
        JLabel jLabel = new JLabel(Version.Version);
        jLabel.setForeground(Color.black);
        this.getContentPane().add((Component)jLabel, this.gbc);
    }

    private final void initJavaVersionLabel() {
        String string = System.getProperty("java.vendor");
        String string2 = System.getProperty("java.version");
        String string3 = (string != null ? string + " " : "") + (string2 != null ? "Java version " + string2 : "unknown Java version") + (string != null ? "" : " (unknown vendor)");
        ++this.gbc.gridy;
        JLabel jLabel = new JLabel(string3);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(0, font.getSize2D() - 1.0f));
        jLabel.setForeground(Color.black);
        this.getContentPane().add((Component)jLabel, this.gbc);
    }

    private void leaveButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

