/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.Application;

import com.eloquence.services.Application.ActiveDialogListener;
import com.eloquence.services.jdlg.controls.EWindow;
import com.eloquence.services.protocols.dlg.Dlg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ActiveDialogList {
    static List entries = null;
    static Set listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertActiveDialog(Dlg dlg, EWindow eWindow) {
        if (dlg == null) {
            return;
        }
        if (ActiveDialogList.tryToReplaceWindowInList(dlg, eWindow)) {
            return;
        }
        List list = entries;
        synchronized (list) {
            if (eWindow != null) {
                entries.add(0, new Entry(dlg, eWindow));
                ActiveDialogList.notifyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryToReplaceWindowInList(Dlg dlg, EWindow eWindow) {
        List list = entries;
        synchronized (list) {
            Entry entry = null;
            for (int i = 0; i < entries.size(); ++i) {
                entry = (Entry)entries.get(i);
                if (entry.session != dlg) continue;
                if (entry.window == eWindow) {
                    return true;
                }
                entries.remove(i);
                if (eWindow != null) {
                    entry.window = eWindow;
                    entries.add(0, entry);
                }
                ActiveDialogList.notifyListeners();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getPresentationOfEntries() {
        List list = entries;
        synchronized (list) {
            if (entries.size() == 1) {
                String[] stringArray = new String[]{" " + ((Entry)ActiveDialogList.entries.get((int)0)).window.getTitle() + " "};
                return stringArray;
            }
            if (entries.size() > 0) {
                String[] stringArray = new String[entries.size()];
                Entry entry = null;
                StringTokenizer stringTokenizer = null;
                for (int i = 0; i < entries.size(); ++i) {
                    entry = (Entry)entries.get(i);
                    stringTokenizer = new StringTokenizer(entry.session.getName(), ":");
                    stringArray[i] = " " + entry.window.getTitle() + " - " + stringTokenizer.nextToken() + " ";
                }
                return stringArray;
            }
        }
        return null;
    }

    public static void setToFront(String string, boolean bl) {
        for (int i = 0; i < entries.size(); ++i) {
            String string2;
            Entry entry = (Entry)entries.get(i);
            if (bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(entry.session.getName(), ":");
                string2 = " " + entry.window.getTitle() + " - " + stringTokenizer.nextToken() + " ";
            } else {
                string2 = entry.window.getTitle();
            }
            if (!string.equals(string2)) continue;
            entry.window.windowToFront(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTitleByThread(Thread thread) {
        List list = entries;
        synchronized (list) {
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                if (entry.session != thread) continue;
                return entry.window.getTitle();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyDialogs(Thread thread, String string, String string2, boolean bl) {
        List list = entries;
        synchronized (list) {
            for (int i = 0; i < entries.size(); ++i) {
                Entry entry = (Entry)entries.get(i);
                if (entry.session == thread) continue;
                entry.window.onNotify(string, string2, bl);
            }
        }
    }

    public static void addListener(ActiveDialogListener activeDialogListener) {
        listeners.add(activeDialogListener);
    }

    public static void removeListener(ActiveDialogListener activeDialogListener) {
        listeners.remove(activeDialogListener);
    }

    public static void notifyListeners() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((ActiveDialogListener)iterator.next()).update();
        }
    }

    static {
        entries = new ArrayList();
        listeners = null;
        listeners = new HashSet();
    }

    static class Entry {
        Dlg session = null;
        EWindow window = null;

        public Entry(Dlg dlg, EWindow eWindow) {
            this.session = dlg;
            this.window = eWindow;
        }
    }
}

