/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.Application;

import com.eloquence.services.Application.ActiveDialogList;
import com.eloquence.services.Application.ActiveDialogListener;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.tools.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ActiveDialogView
extends JFrame
implements ActiveDialogListener,
MouseListener,
KeyListener {
    private String[] entries = null;
    protected JList list = null;
    protected JScrollPane sp = null;

    public ActiveDialogView() {
        super(Strings.get("activedialogs.title"));
        this.setDefaultCloseOperation(1);
        try {
            this.setIconImage(this.getToolkit().getImage(StartUp.getLogoIconUrl()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JButton jButton = new JButton();
        Strings.setButtonText(jButton, "activedialogs.dismiss");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActiveDialogView.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        this.list = new JList();
        this.sp = new JScrollPane();
        this.sp.getViewport().setView(this.list);
        this.list.addMouseListener(this);
        this.list.addKeyListener(this);
        container.add((Component)this.sp, "Center");
        this.update();
        this.setSize(240, 160);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void update() {
        this.entries = ActiveDialogList.getPresentationOfEntries();
        if (this.entries == null) {
            this.entries = new String[1];
            this.entries[0] = "";
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ActiveDialogView.this.list.setListData(ActiveDialogView.this.entries);
                if (ActiveDialogView.this.list.getModel().getSize() > 0) {
                    ActiveDialogView.this.list.setSelectedIndex(0);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

