/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.Application;

import com.eloquence.services.Application.StartUp;
import java.awt.Color;
import java.net.URI;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;

public final class ConfigurableTheme {
    private ConfigurableSubTheme theme;
    private static String primary1 = "primary1";
    private static String primary2 = "primary2";
    private static String primary3 = "primary3";
    private static String secondary1 = "secondary1";
    private static String secondary2 = "secondary2";
    private static String secondary3 = "secondary3";
    private static String controlTextFont = "controlTextFont";
    private static String systemTextFont = "systemTextFont";
    private static String userTextFont = "userTextFont";
    private static String menuTextFont = "menuTextFont";
    private static String windowTitleFont = "windowTitleFont";
    private static String subTextFont = "subTextFont";
    private static String white = "white";
    private static String black = "black";
    private static String focusColor = "focusColor";
    private static String desktopColor = "desktopColor";
    private static String control = "control";
    private static String controlShadow = "controlShadow";
    private static String controlDarkShadow = "controlDarkShadow";
    private static String controlInfo = "controlInfo";
    private static String controlHighlight = "controlHighlight";
    private static String controlDisabled = "controlDisabled";
    private static String primaryControl = "primaryControl";
    private static String primaryControlShadow = "primaryControlShadow";
    private static String primaryControlDarkShadow = "primaryControlDarkShadow";
    private static String primaryControlInfo = "primaryControlInfo";
    private static String primaryControlHighlight = "primaryControlHighlight";
    private static String systemTextColor = "systemTextColor";
    private static String controlTextColor = "controlTextColor";
    private static String inactiveControlTextColor = "inactiveControlTextColor";
    private static String inactiveSystemTextColor = "inactiveSystemTextColor";
    private static String userTextColor = "userTextColor";
    private static String textHighlightColor = "textHighlightColor";
    private static String highlightedTextColor = "highlightedTextColor";
    private static String windowBackground = "windowBackground";
    private static String windowTitleBackground = "windowTitleBackground";
    private static String windowTitleForeground = "windowTitleForeground";
    private static String windowTitleInactiveBackground = "windowTitleInactiveBackground";
    private static String windowTitleInactiveForeground = "windowTitleInactiveForeground";
    private static String menuBackground = "menuBackground";
    private static String menuForeground = "menuForeground";
    private static String menuSelectedBackground = "menuSelectedBackground";
    private static String menuSelectedForeground = "menuSelectedForeground";
    private static String menuDisabledForeground = "menuDisabledForeground";
    private static String separatorBackground = "separatorBackground";
    private static String separatorForeground = "separatorForeground";
    private static String acceleratorForeground = "acceleratorForeground";
    private static String acceleratorSelectedForeground = "acceleratorSelectedForeground";

    public ConfigurableTheme(String string) throws Throwable {
        if (string != null && string.length() > 0) {
            if (string.equalsIgnoreCase("default") || string.equalsIgnoreCase("steel")) {
                this.theme = new ConfigurableSteelTheme();
            } else if (string.equalsIgnoreCase("ocean")) {
                this.theme = new ConfigurableOceanTheme();
            } else {
                throw new Exception("unknown theme class '" + string + "'");
            }
            ConfigurableTheme.canInstallTheme((MetalTheme)((Object)this.theme));
        } else {
            this.theme = ConfigurableTheme.canInstallTheme(null) ? new ConfigurableSteelTheme() : new ConfigurableDefaultTheme();
        }
    }

    public static boolean canInstallTheme(MetalTheme metalTheme) throws Throwable {
        String string = null;
        try {
            String string2 = UIManager.getLookAndFeel().getClass().getName();
            String string3 = UIManager.getCrossPlatformLookAndFeelClassName();
            if (string2.equals(string3)) {
                return true;
            }
            if (metalTheme != null) {
                string = "look-and-feel is '" + string2 + "', must be '" + string3 + "'";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (metalTheme != null) {
            throw new Exception(string != null ? string : "look-and-feel is not configured");
        }
        return false;
    }

    public static void installTheme(MetalTheme metalTheme) throws Throwable {
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        UIManager.setLookAndFeel(UIManager.getLookAndFeel());
    }

    public void installTheme() throws Throwable {
        if (this.theme instanceof MetalTheme) {
            ConfigurableTheme.installTheme((MetalTheme)((Object)this.theme));
        }
    }

    public static void installTheme(String string) throws Throwable {
        DefaultMetalTheme defaultMetalTheme;
        if (string.equalsIgnoreCase("default") || string.equalsIgnoreCase("steel")) {
            defaultMetalTheme = new DefaultMetalTheme();
        } else if (string.equalsIgnoreCase("ocean")) {
            defaultMetalTheme = new OceanTheme();
        } else {
            throw new Exception("unknown theme class '" + string + "'");
        }
        ConfigurableTheme.canInstallTheme(defaultMetalTheme);
        ConfigurableTheme.installTheme(defaultMetalTheme);
    }

    private static Object decodeResource(String string) throws Throwable {
        int n = string.indexOf(40);
        if (n >= 0) {
            int n2 = string.indexOf(41, n + 1);
            if (n2 >= 0) {
                int n3 = string.indexOf(35, n2 + 1);
                if (n3 >= 0 && string.substring(n2 + 1, n3).trim().length() > 0 || n3 == -1 && string.substring(n2 + 1).trim().length() > 0) {
                    throw new Exception("syntax error");
                }
                String string2 = string.substring(0, n).trim();
                string = string.substring(n + 1, n2);
                if (string2.equalsIgnoreCase("color")) {
                    return ConfigurableTheme.decodeColor(string);
                }
                if (string2.equalsIgnoreCase("font")) {
                    return ConfigurableTheme.decodeFont(string);
                }
                if (string2.equalsIgnoreCase("boolean")) {
                    return ConfigurableTheme.decodeBoolean(string);
                }
                if (string2.equalsIgnoreCase("border")) {
                    return ConfigurableTheme.decodeBorder(string);
                }
                if (string2.equalsIgnoreCase("character")) {
                    return ConfigurableTheme.decodeCharacter(string);
                }
                if (string2.equalsIgnoreCase("dimension")) {
                    return ConfigurableTheme.decodeDimension(string);
                }
                if (string2.equalsIgnoreCase("icon")) {
                    return ConfigurableTheme.decodeIcon(string);
                }
                if (string2.equalsIgnoreCase("insets")) {
                    return ConfigurableTheme.decodeInsets(string);
                }
                if (string2.equalsIgnoreCase("integer")) {
                    return ConfigurableTheme.decodeInteger(string);
                }
                if (string2.equalsIgnoreCase("string")) {
                    return string;
                }
                throw new Exception("'" + string2 + "' not recognized");
            }
            throw new Exception("missing ')'");
        }
        return null;
    }

    private static ColorUIResource decodeColorResource(String string) throws Throwable {
        Object object = ConfigurableTheme.decodeResource(string);
        if (object == null) {
            return ConfigurableTheme.decodeColor(string);
        }
        if (object instanceof ColorUIResource) {
            return (ColorUIResource)object;
        }
        throw new Exception("color value expected");
    }

    private static ColorUIResource decodeColor(String string) throws Throwable {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (!stringTokenizer.hasMoreTokens() && n >= 0 && n < 256 && n2 >= 0 && n2 < 256 && n3 >= 0 && n3 < 256) {
                return new ColorUIResource(n, n2, n3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception("unexpected color value");
    }

    private static FontUIResource decodeFontResource(String string) throws Throwable {
        Object object = ConfigurableTheme.decodeResource(string);
        if (object == null) {
            return ConfigurableTheme.decodeFont(string);
        }
        if (object instanceof FontUIResource) {
            return (FontUIResource)object;
        }
        throw new Exception("font value expected");
    }

    private static FontUIResource decodeFont(String string) throws Throwable {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer.nextToken().trim();
            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n2 = 0;
            if (string4.equalsIgnoreCase("plain")) {
                n2 = 0;
            } else if (string4.equalsIgnoreCase("bold")) {
                n2 = 1;
            } else if (string4.equalsIgnoreCase("italic")) {
                n2 = 2;
            } else {
                string2 = "'" + string4 + "' not recognized";
            }
            if (string2 == null && !stringTokenizer.hasMoreTokens() && n > 0) {
                return new FontUIResource(string3, n2, n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception(string2 != null ? string2 : "unexpected font value");
    }

    private static Boolean decodeBoolean(String string) throws Throwable {
        if ((string = string.trim()).equalsIgnoreCase("false")) {
            return new Boolean(false);
        }
        if (string.equalsIgnoreCase("true")) {
            return new Boolean(true);
        }
        throw new Exception("unexpected boolean value");
    }

    private static Border decodeBorder(String string) throws Throwable {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            String string3 = stringTokenizer.nextToken().trim();
            Border border = null;
            if (string3.equalsIgnoreCase("bevel")) {
                border = ConfigurableTheme.decodeBevelBorder(stringTokenizer);
            } else if (string3.equalsIgnoreCase("empty")) {
                border = ConfigurableTheme.decodeEmptyBorder(stringTokenizer);
            } else if (string3.equalsIgnoreCase("etched")) {
                border = ConfigurableTheme.decodeEtchedBorder(stringTokenizer);
            } else if (string3.equalsIgnoreCase("line")) {
                border = ConfigurableTheme.decodeLineBorder(stringTokenizer);
            } else {
                string2 = "'" + string3 + "' not recognized";
            }
            if (string2 == null) {
                if (stringTokenizer.hasMoreTokens() && border != null) {
                    border = ConfigurableTheme.decodeCompoundBorder(border, stringTokenizer);
                }
                if (!stringTokenizer.hasMoreTokens() && border != null) {
                    return border;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception(string2 != null ? string2 : "unexpected border value");
    }

    private static Border decodeBevelBorder(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().trim();
        int n = 0;
        if (string.equalsIgnoreCase("lowered")) {
            n = 1;
        } else if (string.equalsIgnoreCase("raised")) {
            n = 0;
        } else {
            return null;
        }
        return new BorderUIResource.BevelBorderUIResource(n);
    }

    private static Border decodeEmptyBorder(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            return new BorderUIResource.EmptyBorderUIResource(n, n2, n3, n4);
        }
        return null;
    }

    private static Border decodeEtchedBorder(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().trim();
        int n = 0;
        if (string.equalsIgnoreCase("lowered")) {
            n = 1;
        } else if (string.equalsIgnoreCase("raised")) {
            n = 0;
        } else {
            return null;
        }
        return new BorderUIResource.EtchedBorderUIResource(n);
    }

    private static Border decodeLineBorder(StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
        if (n >= 0 && n < 256 && n2 >= 0 && n2 < 256 && n3 >= 0 && n3 < 256 && n4 >= 0) {
            return new BorderUIResource.LineBorderUIResource(new Color(n, n2, n3), n4);
        }
        return null;
    }

    private static Border decodeCompoundBorder(Border border, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            return new BorderUIResource.CompoundBorderUIResource(border, new BorderUIResource.EmptyBorderUIResource(n, n2, n3, n4));
        }
        return null;
    }

    private static Character decodeCharacter(String string) throws Throwable {
        if ((string = string.trim()).length() == 1) {
            return new Character(string.charAt(0));
        }
        throw new Exception("unexpected character value");
    }

    private static DimensionUIResource decodeDimension(String string) throws Throwable {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (!stringTokenizer.hasMoreTokens() && n >= 0 && n2 >= 0) {
                return new DimensionUIResource(n, n2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception("unexpected dimension value");
    }

    private static IconUIResource decodeIcon(String string) throws Throwable {
        try {
            URI uRI = StartUp.uriFromString(string.trim());
            if (uRI.isAbsolute()) {
                return new IconUIResource(new ImageIcon(uRI.toURL()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception("unexpected icon value");
    }

    private static InsetsUIResource decodeInsets(String string) throws Throwable {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
            if (!stringTokenizer.hasMoreTokens() && n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
                return new InsetsUIResource(n, n2, n3, n4);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception("unexpected insets value");
    }

    private static Integer decodeInteger(String string) throws Throwable {
        try {
            return Integer.valueOf(string.trim());
        }
        catch (Throwable throwable) {
            throw new Exception("unexpected integer value");
        }
    }

    public void setResource(String string, String string2) throws Throwable {
        if (string.equalsIgnoreCase(primary1)) {
            this.theme.setPrimary1(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primary2)) {
            this.theme.setPrimary2(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primary3)) {
            this.theme.setPrimary3(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(secondary1)) {
            this.theme.setSecondary1(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(secondary2)) {
            this.theme.setSecondary2(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(secondary3)) {
            this.theme.setSecondary3(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlTextFont)) {
            this.theme.setControlTextFont(ConfigurableTheme.decodeFontResource(string2));
        } else if (string.equalsIgnoreCase(systemTextFont)) {
            this.theme.setSystemTextFont(ConfigurableTheme.decodeFontResource(string2));
        } else if (string.equalsIgnoreCase(userTextFont)) {
            this.theme.setUserTextFont(ConfigurableTheme.decodeFontResource(string2));
        } else if (string.equalsIgnoreCase(menuTextFont)) {
            this.theme.setMenuTextFont(ConfigurableTheme.decodeFontResource(string2));
        } else if (string.equalsIgnoreCase(windowTitleFont)) {
            this.theme.setWindowTitleFont(ConfigurableTheme.decodeFontResource(string2));
        } else if (string.equalsIgnoreCase(subTextFont)) {
            this.theme.setSubTextFont(ConfigurableTheme.decodeFontResource(string2));
        } else if (string.equalsIgnoreCase(white)) {
            this.theme.setWhite(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(black)) {
            this.theme.setBlack(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(focusColor)) {
            this.theme.setFocusColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(desktopColor)) {
            this.theme.setDesktopColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(control)) {
            this.theme.setControl(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlShadow)) {
            this.theme.setControlShadow(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlDarkShadow)) {
            this.theme.setControlDarkShadow(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlInfo)) {
            this.theme.setControlInfo(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlHighlight)) {
            this.theme.setControlHighlight(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlDisabled)) {
            this.theme.setControlDisabled(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primaryControl)) {
            this.theme.setPrimaryControl(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primaryControlShadow)) {
            this.theme.setPrimaryControlShadow(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primaryControlDarkShadow)) {
            this.theme.setPrimaryControlDarkShadow(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primaryControlInfo)) {
            this.theme.setPrimaryControlInfo(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(primaryControlHighlight)) {
            this.theme.setPrimaryControlHighlight(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(systemTextColor)) {
            this.theme.setSystemTextColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(controlTextColor)) {
            this.theme.setControlTextColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(inactiveControlTextColor)) {
            this.theme.setInactiveControlTextColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(inactiveSystemTextColor)) {
            this.theme.setInactiveSystemTextColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(userTextColor)) {
            this.theme.setUserTextColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(textHighlightColor)) {
            this.theme.setTextHighlightColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(highlightedTextColor)) {
            this.theme.setHighlightedTextColor(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(windowBackground)) {
            this.theme.setWindowBackground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(windowTitleBackground)) {
            this.theme.setWindowTitleBackground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(windowTitleForeground)) {
            this.theme.setWindowTitleForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(windowTitleInactiveBackground)) {
            this.theme.setWindowTitleInactiveBackground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(windowTitleInactiveForeground)) {
            this.theme.setWindowTitleInactiveForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(menuBackground)) {
            this.theme.setMenuBackground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(menuForeground)) {
            this.theme.setMenuForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(menuSelectedBackground)) {
            this.theme.setMenuSelectedBackground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(menuSelectedForeground)) {
            this.theme.setMenuSelectedForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(menuDisabledForeground)) {
            this.theme.setMenuDisabledForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(separatorBackground)) {
            this.theme.setSeparatorBackground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(separatorForeground)) {
            this.theme.setSeparatorForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(acceleratorForeground)) {
            this.theme.setAcceleratorForeground(ConfigurableTheme.decodeColorResource(string2));
        } else if (string.equalsIgnoreCase(acceleratorSelectedForeground)) {
            this.theme.setAcceleratorSelectedForeground(ConfigurableTheme.decodeColorResource(string2));
        } else {
            Object object = ConfigurableTheme.decodeResource(string2);
            if (object == null) {
                throw new Exception("syntax error");
            }
            this.theme.putDefault(string, object);
        }
    }

    private static final class ConfigurableOceanTheme
    extends OceanTheme
    implements ConfigurableSubTheme {
        private ColorUIResource primary1 = null;
        private ColorUIResource primary2 = null;
        private ColorUIResource primary3 = null;
        private ColorUIResource secondary1 = null;
        private ColorUIResource secondary2 = null;
        private ColorUIResource secondary3 = null;
        private FontUIResource controlTextFont = null;
        private FontUIResource systemTextFont = null;
        private FontUIResource userTextFont = null;
        private FontUIResource menuTextFont = null;
        private FontUIResource windowTitleFont = null;
        private FontUIResource subTextFont = null;
        private ColorUIResource white = null;
        private ColorUIResource black = null;
        private ColorUIResource focusColor = null;
        private ColorUIResource desktopColor = null;
        private ColorUIResource control = null;
        private ColorUIResource controlShadow = null;
        private ColorUIResource controlDarkShadow = null;
        private ColorUIResource controlInfo = null;
        private ColorUIResource controlHighlight = null;
        private ColorUIResource controlDisabled = null;
        private ColorUIResource primaryControl = null;
        private ColorUIResource primaryControlShadow = null;
        private ColorUIResource primaryControlDarkShadow = null;
        private ColorUIResource primaryControlInfo = null;
        private ColorUIResource primaryControlHighlight = null;
        private ColorUIResource systemTextColor = null;
        private ColorUIResource controlTextColor = null;
        private ColorUIResource inactiveControlTextColor = null;
        private ColorUIResource inactiveSystemTextColor = null;
        private ColorUIResource userTextColor = null;
        private ColorUIResource textHighlightColor = null;
        private ColorUIResource highlightedTextColor = null;
        private ColorUIResource windowBackground = null;
        private ColorUIResource windowTitleBackground = null;
        private ColorUIResource windowTitleForeground = null;
        private ColorUIResource windowTitleInactiveBackground = null;
        private ColorUIResource windowTitleInactiveForeground = null;
        private ColorUIResource menuBackground = null;
        private ColorUIResource menuForeground = null;
        private ColorUIResource menuSelectedBackground = null;
        private ColorUIResource menuSelectedForeground = null;
        private ColorUIResource menuDisabledForeground = null;
        private ColorUIResource separatorBackground = null;
        private ColorUIResource separatorForeground = null;
        private ColorUIResource acceleratorForeground = null;
        private ColorUIResource acceleratorSelectedForeground = null;
        private Hashtable defaults = null;

        private ConfigurableOceanTheme() {
        }

        public String getName() {
            return "JdlgOcean";
        }

        public void setPrimary1(ColorUIResource colorUIResource) {
            this.primary1 = colorUIResource;
        }

        protected ColorUIResource getPrimary1() {
            return this.primary1 != null ? this.primary1 : super.getPrimary1();
        }

        public void setPrimary2(ColorUIResource colorUIResource) {
            this.primary2 = colorUIResource;
        }

        protected ColorUIResource getPrimary2() {
            return this.primary2 != null ? this.primary2 : super.getPrimary2();
        }

        public void setPrimary3(ColorUIResource colorUIResource) {
            this.primary3 = colorUIResource;
        }

        protected ColorUIResource getPrimary3() {
            return this.primary3 != null ? this.primary3 : super.getPrimary3();
        }

        public void setSecondary1(ColorUIResource colorUIResource) {
            this.secondary1 = colorUIResource;
        }

        protected ColorUIResource getSecondary1() {
            return this.secondary1 != null ? this.secondary1 : super.getSecondary1();
        }

        public void setSecondary2(ColorUIResource colorUIResource) {
            this.secondary2 = colorUIResource;
        }

        protected ColorUIResource getSecondary2() {
            return this.secondary2 != null ? this.secondary2 : super.getSecondary2();
        }

        public void setSecondary3(ColorUIResource colorUIResource) {
            this.secondary3 = colorUIResource;
        }

        protected ColorUIResource getSecondary3() {
            return this.secondary3 != null ? this.secondary3 : super.getSecondary3();
        }

        public void setControlTextFont(FontUIResource fontUIResource) {
            this.controlTextFont = fontUIResource;
        }

        public FontUIResource getControlTextFont() {
            return this.controlTextFont != null ? this.controlTextFont : super.getControlTextFont();
        }

        public void setSystemTextFont(FontUIResource fontUIResource) {
            this.systemTextFont = fontUIResource;
        }

        public FontUIResource getSystemTextFont() {
            return this.systemTextFont != null ? this.systemTextFont : super.getSystemTextFont();
        }

        public void setUserTextFont(FontUIResource fontUIResource) {
            this.userTextFont = fontUIResource;
        }

        public FontUIResource getUserTextFont() {
            return this.userTextFont != null ? this.userTextFont : super.getUserTextFont();
        }

        public void setMenuTextFont(FontUIResource fontUIResource) {
            this.menuTextFont = fontUIResource;
        }

        public FontUIResource getMenuTextFont() {
            return this.menuTextFont != null ? this.menuTextFont : super.getMenuTextFont();
        }

        public void setWindowTitleFont(FontUIResource fontUIResource) {
            this.windowTitleFont = fontUIResource;
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont != null ? this.windowTitleFont : super.getWindowTitleFont();
        }

        public void setSubTextFont(FontUIResource fontUIResource) {
            this.subTextFont = fontUIResource;
        }

        public FontUIResource getSubTextFont() {
            return this.subTextFont != null ? this.subTextFont : super.getSubTextFont();
        }

        public void setWhite(ColorUIResource colorUIResource) {
            this.white = colorUIResource;
        }

        protected ColorUIResource getWhite() {
            return this.white != null ? this.white : super.getWhite();
        }

        public void setBlack(ColorUIResource colorUIResource) {
            this.black = colorUIResource;
        }

        protected ColorUIResource getBlack() {
            return this.black != null ? this.black : super.getBlack();
        }

        public void setFocusColor(ColorUIResource colorUIResource) {
            this.focusColor = colorUIResource;
        }

        public ColorUIResource getFocusColor() {
            return this.focusColor != null ? this.focusColor : super.getFocusColor();
        }

        public void setDesktopColor(ColorUIResource colorUIResource) {
            this.desktopColor = colorUIResource;
        }

        public ColorUIResource getDesktopColor() {
            return this.desktopColor != null ? this.desktopColor : super.getDesktopColor();
        }

        public void setControl(ColorUIResource colorUIResource) {
            this.control = colorUIResource;
        }

        public ColorUIResource getControl() {
            return this.control != null ? this.control : super.getControl();
        }

        public void setControlShadow(ColorUIResource colorUIResource) {
            this.controlShadow = colorUIResource;
        }

        public ColorUIResource getControlShadow() {
            return this.controlShadow != null ? this.controlShadow : super.getControlShadow();
        }

        public void setControlDarkShadow(ColorUIResource colorUIResource) {
            this.controlDarkShadow = colorUIResource;
        }

        public ColorUIResource getControlDarkShadow() {
            return this.controlDarkShadow != null ? this.controlDarkShadow : super.getControlDarkShadow();
        }

        public void setControlInfo(ColorUIResource colorUIResource) {
            this.controlInfo = colorUIResource;
        }

        public ColorUIResource getControlInfo() {
            return this.controlInfo != null ? this.controlInfo : super.getControlInfo();
        }

        public void setControlHighlight(ColorUIResource colorUIResource) {
            this.controlHighlight = colorUIResource;
        }

        public ColorUIResource getControlHighlight() {
            return this.controlHighlight != null ? this.controlHighlight : super.getControlHighlight();
        }

        public void setControlDisabled(ColorUIResource colorUIResource) {
            this.controlDisabled = colorUIResource;
        }

        public ColorUIResource getControlDisabled() {
            return this.controlDisabled != null ? this.controlDisabled : super.getControlDisabled();
        }

        public void setPrimaryControl(ColorUIResource colorUIResource) {
            this.primaryControl = colorUIResource;
        }

        public ColorUIResource getPrimaryControl() {
            return this.primaryControl != null ? this.primaryControl : super.getPrimaryControl();
        }

        public void setPrimaryControlShadow(ColorUIResource colorUIResource) {
            this.primaryControlShadow = colorUIResource;
        }

        public ColorUIResource getPrimaryControlShadow() {
            return this.primaryControlShadow != null ? this.primaryControlShadow : super.getPrimaryControlShadow();
        }

        public void setPrimaryControlDarkShadow(ColorUIResource colorUIResource) {
            this.primaryControlDarkShadow = colorUIResource;
        }

        public ColorUIResource getPrimaryControlDarkShadow() {
            return this.primaryControlDarkShadow != null ? this.primaryControlDarkShadow : super.getPrimaryControlDarkShadow();
        }

        public void setPrimaryControlInfo(ColorUIResource colorUIResource) {
            this.primaryControlInfo = colorUIResource;
        }

        public ColorUIResource getPrimaryControlInfo() {
            return this.primaryControlInfo != null ? this.primaryControlInfo : super.getPrimaryControlInfo();
        }

        public void setPrimaryControlHighlight(ColorUIResource colorUIResource) {
            this.primaryControlHighlight = colorUIResource;
        }

        public ColorUIResource getPrimaryControlHighlight() {
            return this.primaryControlHighlight != null ? this.primaryControlHighlight : super.getPrimaryControlHighlight();
        }

        public void setSystemTextColor(ColorUIResource colorUIResource) {
            this.systemTextColor = colorUIResource;
        }

        public ColorUIResource getSystemTextColor() {
            return this.systemTextColor != null ? this.systemTextColor : super.getSystemTextColor();
        }

        public void setControlTextColor(ColorUIResource colorUIResource) {
            this.controlTextColor = colorUIResource;
        }

        public ColorUIResource getControlTextColor() {
            return this.controlTextColor != null ? this.controlTextColor : super.getControlTextColor();
        }

        public void setInactiveControlTextColor(ColorUIResource colorUIResource) {
            this.inactiveControlTextColor = colorUIResource;
        }

        public ColorUIResource getInactiveControlTextColor() {
            return this.inactiveControlTextColor != null ? this.inactiveControlTextColor : super.getInactiveControlTextColor();
        }

        public void setInactiveSystemTextColor(ColorUIResource colorUIResource) {
            this.inactiveSystemTextColor = colorUIResource;
        }

        public ColorUIResource getInactiveSystemTextColor() {
            return this.inactiveSystemTextColor != null ? this.inactiveSystemTextColor : super.getInactiveSystemTextColor();
        }

        public void setUserTextColor(ColorUIResource colorUIResource) {
            this.userTextColor = colorUIResource;
        }

        public ColorUIResource getUserTextColor() {
            return this.userTextColor != null ? this.userTextColor : super.getUserTextColor();
        }

        public void setTextHighlightColor(ColorUIResource colorUIResource) {
            this.textHighlightColor = colorUIResource;
        }

        public ColorUIResource getTextHighlightColor() {
            return this.textHighlightColor != null ? this.textHighlightColor : super.getTextHighlightColor();
        }

        public void setHighlightedTextColor(ColorUIResource colorUIResource) {
            this.highlightedTextColor = colorUIResource;
        }

        public ColorUIResource getHighlightedTextColor() {
            return this.highlightedTextColor != null ? this.highlightedTextColor : super.getHighlightedTextColor();
        }

        public void setWindowBackground(ColorUIResource colorUIResource) {
            this.windowBackground = colorUIResource;
        }

        public ColorUIResource getWindowBackground() {
            return this.windowBackground != null ? this.windowBackground : super.getWindowBackground();
        }

        public void setWindowTitleBackground(ColorUIResource colorUIResource) {
            this.windowTitleBackground = colorUIResource;
        }

        public ColorUIResource getWindowTitleBackground() {
            return this.windowTitleBackground != null ? this.windowTitleBackground : super.getWindowTitleBackground();
        }

        public void setWindowTitleForeground(ColorUIResource colorUIResource) {
            this.windowTitleForeground = colorUIResource;
        }

        public ColorUIResource getWindowTitleForeground() {
            return this.windowTitleForeground != null ? this.windowTitleForeground : super.getWindowTitleForeground();
        }

        public void setWindowTitleInactiveBackground(ColorUIResource colorUIResource) {
            this.windowTitleInactiveBackground = colorUIResource;
        }

        public ColorUIResource getWindowTitleInactiveBackground() {
            return this.windowTitleInactiveBackground != null ? this.windowTitleInactiveBackground : super.getWindowTitleInactiveBackground();
        }

        public void setWindowTitleInactiveForeground(ColorUIResource colorUIResource) {
            this.windowTitleInactiveForeground = colorUIResource;
        }

        public ColorUIResource getWindowTitleInactiveForeground() {
            return this.windowTitleInactiveForeground != null ? this.windowTitleInactiveForeground : super.getWindowTitleInactiveForeground();
        }

        public void setMenuBackground(ColorUIResource colorUIResource) {
            this.menuBackground = colorUIResource;
        }

        public ColorUIResource getMenuBackground() {
            return this.menuBackground != null ? this.menuBackground : super.getMenuBackground();
        }

        public void setMenuForeground(ColorUIResource colorUIResource) {
            this.menuForeground = colorUIResource;
        }

        public ColorUIResource getMenuForeground() {
            return this.menuForeground != null ? this.menuForeground : super.getMenuForeground();
        }

        public void setMenuSelectedBackground(ColorUIResource colorUIResource) {
            this.menuSelectedBackground = colorUIResource;
        }

        public ColorUIResource getMenuSelectedBackground() {
            return this.menuSelectedBackground != null ? this.menuSelectedBackground : super.getMenuSelectedBackground();
        }

        public void setMenuSelectedForeground(ColorUIResource colorUIResource) {
            this.menuSelectedForeground = colorUIResource;
        }

        public ColorUIResource getMenuSelectedForeground() {
            return this.menuSelectedForeground != null ? this.menuSelectedForeground : super.getMenuSelectedForeground();
        }

        public void setMenuDisabledForeground(ColorUIResource colorUIResource) {
            this.menuDisabledForeground = colorUIResource;
        }

        public ColorUIResource getMenuDisabledForeground() {
            return this.menuDisabledForeground != null ? this.menuDisabledForeground : super.getMenuDisabledForeground();
        }

        public void setSeparatorBackground(ColorUIResource colorUIResource) {
            this.separatorBackground = colorUIResource;
        }

        public ColorUIResource getSeparatorBackground() {
            return this.separatorBackground != null ? this.separatorBackground : super.getSeparatorBackground();
        }

        public void setSeparatorForeground(ColorUIResource colorUIResource) {
            this.separatorForeground = colorUIResource;
        }

        public ColorUIResource getSeparatorForeground() {
            return this.separatorForeground != null ? this.separatorForeground : super.getSeparatorForeground();
        }

        public void setAcceleratorForeground(ColorUIResource colorUIResource) {
            this.acceleratorForeground = colorUIResource;
        }

        public ColorUIResource getAcceleratorForeground() {
            return this.acceleratorForeground != null ? this.acceleratorForeground : super.getAcceleratorForeground();
        }

        public void setAcceleratorSelectedForeground(ColorUIResource colorUIResource) {
            this.acceleratorSelectedForeground = colorUIResource;
        }

        public ColorUIResource getAcceleratorSelectedForeground() {
            return this.acceleratorSelectedForeground != null ? this.acceleratorSelectedForeground : super.getAcceleratorSelectedForeground();
        }

        public void putDefault(String string, Object object) {
            if (this.defaults == null) {
                this.defaults = new Hashtable();
            }
            this.defaults.put(string, object);
        }

        public void addCustomEntriesToTable(UIDefaults uIDefaults) {
            super.addCustomEntriesToTable(uIDefaults);
            if (this.defaults != null) {
                uIDefaults.putAll(this.defaults);
                this.defaults = null;
            }
        }
    }

    private static final class ConfigurableSteelTheme
    extends DefaultMetalTheme
    implements ConfigurableSubTheme {
        private ColorUIResource primary1 = null;
        private ColorUIResource primary2 = null;
        private ColorUIResource primary3 = null;
        private ColorUIResource secondary1 = null;
        private ColorUIResource secondary2 = null;
        private ColorUIResource secondary3 = null;
        private FontUIResource controlTextFont = null;
        private FontUIResource systemTextFont = null;
        private FontUIResource userTextFont = null;
        private FontUIResource menuTextFont = null;
        private FontUIResource windowTitleFont = null;
        private FontUIResource subTextFont = null;
        private ColorUIResource white = null;
        private ColorUIResource black = null;
        private ColorUIResource focusColor = null;
        private ColorUIResource desktopColor = null;
        private ColorUIResource control = null;
        private ColorUIResource controlShadow = null;
        private ColorUIResource controlDarkShadow = null;
        private ColorUIResource controlInfo = null;
        private ColorUIResource controlHighlight = null;
        private ColorUIResource controlDisabled = null;
        private ColorUIResource primaryControl = null;
        private ColorUIResource primaryControlShadow = null;
        private ColorUIResource primaryControlDarkShadow = null;
        private ColorUIResource primaryControlInfo = null;
        private ColorUIResource primaryControlHighlight = null;
        private ColorUIResource systemTextColor = null;
        private ColorUIResource controlTextColor = null;
        private ColorUIResource inactiveControlTextColor = null;
        private ColorUIResource inactiveSystemTextColor = null;
        private ColorUIResource userTextColor = null;
        private ColorUIResource textHighlightColor = null;
        private ColorUIResource highlightedTextColor = null;
        private ColorUIResource windowBackground = null;
        private ColorUIResource windowTitleBackground = null;
        private ColorUIResource windowTitleForeground = null;
        private ColorUIResource windowTitleInactiveBackground = null;
        private ColorUIResource windowTitleInactiveForeground = null;
        private ColorUIResource menuBackground = null;
        private ColorUIResource menuForeground = null;
        private ColorUIResource menuSelectedBackground = null;
        private ColorUIResource menuSelectedForeground = null;
        private ColorUIResource menuDisabledForeground = null;
        private ColorUIResource separatorBackground = null;
        private ColorUIResource separatorForeground = null;
        private ColorUIResource acceleratorForeground = null;
        private ColorUIResource acceleratorSelectedForeground = null;
        private Hashtable defaults = null;

        private ConfigurableSteelTheme() {
        }

        public String getName() {
            return "JdlgSteel";
        }

        public void setPrimary1(ColorUIResource colorUIResource) {
            this.primary1 = colorUIResource;
        }

        protected ColorUIResource getPrimary1() {
            return this.primary1 != null ? this.primary1 : super.getPrimary1();
        }

        public void setPrimary2(ColorUIResource colorUIResource) {
            this.primary2 = colorUIResource;
        }

        protected ColorUIResource getPrimary2() {
            return this.primary2 != null ? this.primary2 : super.getPrimary2();
        }

        public void setPrimary3(ColorUIResource colorUIResource) {
            this.primary3 = colorUIResource;
        }

        protected ColorUIResource getPrimary3() {
            return this.primary3 != null ? this.primary3 : super.getPrimary3();
        }

        public void setSecondary1(ColorUIResource colorUIResource) {
            this.secondary1 = colorUIResource;
        }

        protected ColorUIResource getSecondary1() {
            return this.secondary1 != null ? this.secondary1 : super.getSecondary1();
        }

        public void setSecondary2(ColorUIResource colorUIResource) {
            this.secondary2 = colorUIResource;
        }

        protected ColorUIResource getSecondary2() {
            return this.secondary2 != null ? this.secondary2 : super.getSecondary2();
        }

        public void setSecondary3(ColorUIResource colorUIResource) {
            this.secondary3 = colorUIResource;
        }

        protected ColorUIResource getSecondary3() {
            return this.secondary3 != null ? this.secondary3 : super.getSecondary3();
        }

        public void setControlTextFont(FontUIResource fontUIResource) {
            this.controlTextFont = fontUIResource;
        }

        public FontUIResource getControlTextFont() {
            return this.controlTextFont != null ? this.controlTextFont : super.getControlTextFont();
        }

        public void setSystemTextFont(FontUIResource fontUIResource) {
            this.systemTextFont = fontUIResource;
        }

        public FontUIResource getSystemTextFont() {
            return this.systemTextFont != null ? this.systemTextFont : super.getSystemTextFont();
        }

        public void setUserTextFont(FontUIResource fontUIResource) {
            this.userTextFont = fontUIResource;
        }

        public FontUIResource getUserTextFont() {
            return this.userTextFont != null ? this.userTextFont : super.getUserTextFont();
        }

        public void setMenuTextFont(FontUIResource fontUIResource) {
            this.menuTextFont = fontUIResource;
        }

        public FontUIResource getMenuTextFont() {
            return this.menuTextFont != null ? this.menuTextFont : super.getMenuTextFont();
        }

        public void setWindowTitleFont(FontUIResource fontUIResource) {
            this.windowTitleFont = fontUIResource;
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont != null ? this.windowTitleFont : super.getWindowTitleFont();
        }

        public void setSubTextFont(FontUIResource fontUIResource) {
            this.subTextFont = fontUIResource;
        }

        public FontUIResource getSubTextFont() {
            return this.subTextFont != null ? this.subTextFont : super.getSubTextFont();
        }

        public void setWhite(ColorUIResource colorUIResource) {
            this.white = colorUIResource;
        }

        protected ColorUIResource getWhite() {
            return this.white != null ? this.white : super.getWhite();
        }

        public void setBlack(ColorUIResource colorUIResource) {
            this.black = colorUIResource;
        }

        protected ColorUIResource getBlack() {
            return this.black != null ? this.black : super.getBlack();
        }

        public void setFocusColor(ColorUIResource colorUIResource) {
            this.focusColor = colorUIResource;
        }

        public ColorUIResource getFocusColor() {
            return this.focusColor != null ? this.focusColor : super.getFocusColor();
        }

        public void setDesktopColor(ColorUIResource colorUIResource) {
            this.desktopColor = colorUIResource;
        }

        public ColorUIResource getDesktopColor() {
            return this.desktopColor != null ? this.desktopColor : super.getDesktopColor();
        }

        public void setControl(ColorUIResource colorUIResource) {
            this.control = colorUIResource;
        }

        public ColorUIResource getControl() {
            return this.control != null ? this.control : super.getControl();
        }

        public void setControlShadow(ColorUIResource colorUIResource) {
            this.controlShadow = colorUIResource;
        }

        public ColorUIResource getControlShadow() {
            return this.controlShadow != null ? this.controlShadow : super.getControlShadow();
        }

        public void setControlDarkShadow(ColorUIResource colorUIResource) {
            this.controlDarkShadow = colorUIResource;
        }

        public ColorUIResource getControlDarkShadow() {
            return this.controlDarkShadow != null ? this.controlDarkShadow : super.getControlDarkShadow();
        }

        public void setControlInfo(ColorUIResource colorUIResource) {
            this.controlInfo = colorUIResource;
        }

        public ColorUIResource getControlInfo() {
            return this.controlInfo != null ? this.controlInfo : super.getControlInfo();
        }

        public void setControlHighlight(ColorUIResource colorUIResource) {
            this.controlHighlight = colorUIResource;
        }

        public ColorUIResource getControlHighlight() {
            return this.controlHighlight != null ? this.controlHighlight : super.getControlHighlight();
        }

        public void setControlDisabled(ColorUIResource colorUIResource) {
            this.controlDisabled = colorUIResource;
        }

        public ColorUIResource getControlDisabled() {
            return this.controlDisabled != null ? this.controlDisabled : super.getControlDisabled();
        }

        public void setPrimaryControl(ColorUIResource colorUIResource) {
            this.primaryControl = colorUIResource;
        }

        public ColorUIResource getPrimaryControl() {
            return this.primaryControl != null ? this.primaryControl : super.getPrimaryControl();
        }

        public void setPrimaryControlShadow(ColorUIResource colorUIResource) {
            this.primaryControlShadow = colorUIResource;
        }

        public ColorUIResource getPrimaryControlShadow() {
            return this.primaryControlShadow != null ? this.primaryControlShadow : super.getPrimaryControlShadow();
        }

        public void setPrimaryControlDarkShadow(ColorUIResource colorUIResource) {
            this.primaryControlDarkShadow = colorUIResource;
        }

        public ColorUIResource getPrimaryControlDarkShadow() {
            return this.primaryControlDarkShadow != null ? this.primaryControlDarkShadow : super.getPrimaryControlDarkShadow();
        }

        public void setPrimaryControlInfo(ColorUIResource colorUIResource) {
            this.primaryControlInfo = colorUIResource;
        }

        public ColorUIResource getPrimaryControlInfo() {
            return this.primaryControlInfo != null ? this.primaryControlInfo : super.getPrimaryControlInfo();
        }

        public void setPrimaryControlHighlight(ColorUIResource colorUIResource) {
            this.primaryControlHighlight = colorUIResource;
        }

        public ColorUIResource getPrimaryControlHighlight() {
            return this.primaryControlHighlight != null ? this.primaryControlHighlight : super.getPrimaryControlHighlight();
        }

        public void setSystemTextColor(ColorUIResource colorUIResource) {
            this.systemTextColor = colorUIResource;
        }

        public ColorUIResource getSystemTextColor() {
            return this.systemTextColor != null ? this.systemTextColor : super.getSystemTextColor();
        }

        public void setControlTextColor(ColorUIResource colorUIResource) {
            this.controlTextColor = colorUIResource;
        }

        public ColorUIResource getControlTextColor() {
            return this.controlTextColor != null ? this.controlTextColor : super.getControlTextColor();
        }

        public void setInactiveControlTextColor(ColorUIResource colorUIResource) {
            this.inactiveControlTextColor = colorUIResource;
        }

        public ColorUIResource getInactiveControlTextColor() {
            return this.inactiveControlTextColor != null ? this.inactiveControlTextColor : super.getInactiveControlTextColor();
        }

        public void setInactiveSystemTextColor(ColorUIResource colorUIResource) {
            this.inactiveSystemTextColor = colorUIResource;
        }

        public ColorUIResource getInactiveSystemTextColor() {
            return this.inactiveSystemTextColor != null ? this.inactiveSystemTextColor : super.getInactiveSystemTextColor();
        }

        public void setUserTextColor(ColorUIResource colorUIResource) {
            this.userTextColor = colorUIResource;
        }

        public ColorUIResource getUserTextColor() {
            return this.userTextColor != null ? this.userTextColor : super.getUserTextColor();
        }

        public void setTextHighlightColor(ColorUIResource colorUIResource) {
            this.textHighlightColor = colorUIResource;
        }

        public ColorUIResource getTextHighlightColor() {
            return this.textHighlightColor != null ? this.textHighlightColor : super.getTextHighlightColor();
        }

        public void setHighlightedTextColor(ColorUIResource colorUIResource) {
            this.highlightedTextColor = colorUIResource;
        }

        public ColorUIResource getHighlightedTextColor() {
            return this.highlightedTextColor != null ? this.highlightedTextColor : super.getHighlightedTextColor();
        }

        public void setWindowBackground(ColorUIResource colorUIResource) {
            this.windowBackground = colorUIResource;
        }

        public ColorUIResource getWindowBackground() {
            return this.windowBackground != null ? this.windowBackground : super.getWindowBackground();
        }

        public void setWindowTitleBackground(ColorUIResource colorUIResource) {
            this.windowTitleBackground = colorUIResource;
        }

        public ColorUIResource getWindowTitleBackground() {
            return this.windowTitleBackground != null ? this.windowTitleBackground : super.getWindowTitleBackground();
        }

        public void setWindowTitleForeground(ColorUIResource colorUIResource) {
            this.windowTitleForeground = colorUIResource;
        }

        public ColorUIResource getWindowTitleForeground() {
            return this.windowTitleForeground != null ? this.windowTitleForeground : super.getWindowTitleForeground();
        }

        public void setWindowTitleInactiveBackground(ColorUIResource colorUIResource) {
            this.windowTitleInactiveBackground = colorUIResource;
        }

        public ColorUIResource getWindowTitleInactiveBackground() {
            return this.windowTitleInactiveBackground != null ? this.windowTitleInactiveBackground : super.getWindowTitleInactiveBackground();
        }

        public void setWindowTitleInactiveForeground(ColorUIResource colorUIResource) {
            this.windowTitleInactiveForeground = colorUIResource;
        }

        public ColorUIResource getWindowTitleInactiveForeground() {
            return this.windowTitleInactiveForeground != null ? this.windowTitleInactiveForeground : super.getWindowTitleInactiveForeground();
        }

        public void setMenuBackground(ColorUIResource colorUIResource) {
            this.menuBackground = colorUIResource;
        }

        public ColorUIResource getMenuBackground() {
            return this.menuBackground != null ? this.menuBackground : super.getMenuBackground();
        }

        public void setMenuForeground(ColorUIResource colorUIResource) {
            this.menuForeground = colorUIResource;
        }

        public ColorUIResource getMenuForeground() {
            return this.menuForeground != null ? this.menuForeground : super.getMenuForeground();
        }

        public void setMenuSelectedBackground(ColorUIResource colorUIResource) {
            this.menuSelectedBackground = colorUIResource;
        }

        public ColorUIResource getMenuSelectedBackground() {
            return this.menuSelectedBackground != null ? this.menuSelectedBackground : super.getMenuSelectedBackground();
        }

        public void setMenuSelectedForeground(ColorUIResource colorUIResource) {
            this.menuSelectedForeground = colorUIResource;
        }

        public ColorUIResource getMenuSelectedForeground() {
            return this.menuSelectedForeground != null ? this.menuSelectedForeground : super.getMenuSelectedForeground();
        }

        public void setMenuDisabledForeground(ColorUIResource colorUIResource) {
            this.menuDisabledForeground = colorUIResource;
        }

        public ColorUIResource getMenuDisabledForeground() {
            return this.menuDisabledForeground != null ? this.menuDisabledForeground : super.getMenuDisabledForeground();
        }

        public void setSeparatorBackground(ColorUIResource colorUIResource) {
            this.separatorBackground = colorUIResource;
        }

        public ColorUIResource getSeparatorBackground() {
            return this.separatorBackground != null ? this.separatorBackground : super.getSeparatorBackground();
        }

        public void setSeparatorForeground(ColorUIResource colorUIResource) {
            this.separatorForeground = colorUIResource;
        }

        public ColorUIResource getSeparatorForeground() {
            return this.separatorForeground != null ? this.separatorForeground : super.getSeparatorForeground();
        }

        public void setAcceleratorForeground(ColorUIResource colorUIResource) {
            this.acceleratorForeground = colorUIResource;
        }

        public ColorUIResource getAcceleratorForeground() {
            return this.acceleratorForeground != null ? this.acceleratorForeground : super.getAcceleratorForeground();
        }

        public void setAcceleratorSelectedForeground(ColorUIResource colorUIResource) {
            this.acceleratorSelectedForeground = colorUIResource;
        }

        public ColorUIResource getAcceleratorSelectedForeground() {
            return this.acceleratorSelectedForeground != null ? this.acceleratorSelectedForeground : super.getAcceleratorSelectedForeground();
        }

        public void putDefault(String string, Object object) {
            if (this.defaults == null) {
                this.defaults = new Hashtable();
            }
            this.defaults.put(string, object);
        }

        public void addCustomEntriesToTable(UIDefaults uIDefaults) {
            super.addCustomEntriesToTable(uIDefaults);
            if (this.defaults != null) {
                uIDefaults.putAll(this.defaults);
                this.defaults = null;
            }
        }
    }

    private static final class ConfigurableDefaultTheme
    implements ConfigurableSubTheme {
        private boolean cannotSetMessageIssued = false;

        private ConfigurableDefaultTheme() {
        }

        public void putDefault(String string, Object object) {
            UIManager.put(string, object);
        }

        private void cannotSet(String string) {
            if (!this.cannotSetMessageIssued) {
                this.cannotSetMessageIssued = true;
                String string2 = "Note: Cannot set Metal theme values because look-and-feel is ";
                try {
                    string2 = string2 + "'" + UIManager.getLookAndFeel().getClass().getName() + "'.";
                }
                catch (Throwable throwable) {
                    string2 = string2 + "not configured.";
                }
                System.err.println(string2);
            }
            System.err.println("Cannot set Metal theme value '" + string + "'.");
        }

        public void setPrimary1(ColorUIResource colorUIResource) {
            this.cannotSet(primary1);
        }

        public void setPrimary2(ColorUIResource colorUIResource) {
            this.cannotSet(primary2);
        }

        public void setPrimary3(ColorUIResource colorUIResource) {
            this.cannotSet(primary3);
        }

        public void setSecondary1(ColorUIResource colorUIResource) {
            this.cannotSet(secondary1);
        }

        public void setSecondary2(ColorUIResource colorUIResource) {
            this.cannotSet(secondary2);
        }

        public void setSecondary3(ColorUIResource colorUIResource) {
            this.cannotSet(secondary3);
        }

        public void setControlTextFont(FontUIResource fontUIResource) {
            this.cannotSet(controlTextFont);
        }

        public void setSystemTextFont(FontUIResource fontUIResource) {
            this.cannotSet(systemTextFont);
        }

        public void setUserTextFont(FontUIResource fontUIResource) {
            this.cannotSet(userTextFont);
        }

        public void setMenuTextFont(FontUIResource fontUIResource) {
            this.cannotSet(menuTextFont);
        }

        public void setWindowTitleFont(FontUIResource fontUIResource) {
            this.cannotSet(windowTitleFont);
        }

        public void setSubTextFont(FontUIResource fontUIResource) {
            this.cannotSet(subTextFont);
        }

        public void setWhite(ColorUIResource colorUIResource) {
            this.cannotSet(white);
        }

        public void setBlack(ColorUIResource colorUIResource) {
            this.cannotSet(black);
        }

        public void setFocusColor(ColorUIResource colorUIResource) {
            this.cannotSet(focusColor);
        }

        public void setDesktopColor(ColorUIResource colorUIResource) {
            this.cannotSet(desktopColor);
        }

        public void setControl(ColorUIResource colorUIResource) {
            this.cannotSet(control);
        }

        public void setControlShadow(ColorUIResource colorUIResource) {
            this.cannotSet(controlShadow);
        }

        public void setControlDarkShadow(ColorUIResource colorUIResource) {
            this.cannotSet(controlDarkShadow);
        }

        public void setControlInfo(ColorUIResource colorUIResource) {
            this.cannotSet(controlInfo);
        }

        public void setControlHighlight(ColorUIResource colorUIResource) {
            this.cannotSet(controlHighlight);
        }

        public void setControlDisabled(ColorUIResource colorUIResource) {
            this.cannotSet(controlDisabled);
        }

        public void setPrimaryControl(ColorUIResource colorUIResource) {
            this.cannotSet(primaryControl);
        }

        public void setPrimaryControlShadow(ColorUIResource colorUIResource) {
            this.cannotSet(primaryControlShadow);
        }

        public void setPrimaryControlDarkShadow(ColorUIResource colorUIResource) {
            this.cannotSet(primaryControlDarkShadow);
        }

        public void setPrimaryControlInfo(ColorUIResource colorUIResource) {
            this.cannotSet(primaryControlInfo);
        }

        public void setPrimaryControlHighlight(ColorUIResource colorUIResource) {
            this.cannotSet(primaryControlHighlight);
        }

        public void setSystemTextColor(ColorUIResource colorUIResource) {
            this.cannotSet(systemTextColor);
        }

        public void setControlTextColor(ColorUIResource colorUIResource) {
            this.cannotSet(controlTextColor);
        }

        public void setInactiveControlTextColor(ColorUIResource colorUIResource) {
            this.cannotSet(inactiveControlTextColor);
        }

        public void setInactiveSystemTextColor(ColorUIResource colorUIResource) {
            this.cannotSet(inactiveSystemTextColor);
        }

        public void setUserTextColor(ColorUIResource colorUIResource) {
            this.cannotSet(userTextColor);
        }

        public void setTextHighlightColor(ColorUIResource colorUIResource) {
            this.cannotSet(textHighlightColor);
        }

        public void setHighlightedTextColor(ColorUIResource colorUIResource) {
            this.cannotSet(highlightedTextColor);
        }

        public void setWindowBackground(ColorUIResource colorUIResource) {
            this.cannotSet(windowBackground);
        }

        public void setWindowTitleBackground(ColorUIResource colorUIResource) {
            this.cannotSet(windowTitleBackground);
        }

        public void setWindowTitleForeground(ColorUIResource colorUIResource) {
            this.cannotSet(windowTitleForeground);
        }

        public void setWindowTitleInactiveBackground(ColorUIResource colorUIResource) {
            this.cannotSet(windowTitleInactiveBackground);
        }

        public void setWindowTitleInactiveForeground(ColorUIResource colorUIResource) {
            this.cannotSet(windowTitleInactiveForeground);
        }

        public void setMenuBackground(ColorUIResource colorUIResource) {
            this.cannotSet(menuBackground);
        }

        public void setMenuForeground(ColorUIResource colorUIResource) {
            this.cannotSet(menuForeground);
        }

        public void setMenuSelectedBackground(ColorUIResource colorUIResource) {
            this.cannotSet(menuSelectedBackground);
        }

        public void setMenuSelectedForeground(ColorUIResource colorUIResource) {
            this.cannotSet(menuSelectedForeground);
        }

        public void setMenuDisabledForeground(ColorUIResource colorUIResource) {
            this.cannotSet(menuDisabledForeground);
        }

        public void setSeparatorBackground(ColorUIResource colorUIResource) {
            this.cannotSet(separatorBackground);
        }

        public void setSeparatorForeground(ColorUIResource colorUIResource) {
            this.cannotSet(separatorForeground);
        }

        public void setAcceleratorForeground(ColorUIResource colorUIResource) {
            this.cannotSet(acceleratorForeground);
        }

        public void setAcceleratorSelectedForeground(ColorUIResource colorUIResource) {
            this.cannotSet(acceleratorSelectedForeground);
        }
    }

    private static interface ConfigurableSubTheme {
        public void setPrimary1(ColorUIResource var1);

        public void setPrimary2(ColorUIResource var1);

        public void setPrimary3(ColorUIResource var1);

        public void setSecondary1(ColorUIResource var1);

        public void setSecondary2(ColorUIResource var1);

        public void setSecondary3(ColorUIResource var1);

        public void setControlTextFont(FontUIResource var1);

        public void setSystemTextFont(FontUIResource var1);

        public void setUserTextFont(FontUIResource var1);

        public void setMenuTextFont(FontUIResource var1);

        public void setWindowTitleFont(FontUIResource var1);

        public void setSubTextFont(FontUIResource var1);

        public void setWhite(ColorUIResource var1);

        public void setBlack(ColorUIResource var1);

        public void setFocusColor(ColorUIResource var1);

        public void setDesktopColor(ColorUIResource var1);

        public void setControl(ColorUIResource var1);

        public void setControlShadow(ColorUIResource var1);

        public void setControlDarkShadow(ColorUIResource var1);

        public void setControlInfo(ColorUIResource var1);

        public void setControlHighlight(ColorUIResource var1);

        public void setControlDisabled(ColorUIResource var1);

        public void setPrimaryControl(ColorUIResource var1);

        public void setPrimaryControlShadow(ColorUIResource var1);

        public void setPrimaryControlDarkShadow(ColorUIResource var1);

        public void setPrimaryControlInfo(ColorUIResource var1);

        public void setPrimaryControlHighlight(ColorUIResource var1);

        public void setSystemTextColor(ColorUIResource var1);

        public void setControlTextColor(ColorUIResource var1);

        public void setInactiveControlTextColor(ColorUIResource var1);

        public void setInactiveSystemTextColor(ColorUIResource var1);

        public void setUserTextColor(ColorUIResource var1);

        public void setTextHighlightColor(ColorUIResource var1);

        public void setHighlightedTextColor(ColorUIResource var1);

        public void setWindowBackground(ColorUIResource var1);

        public void setWindowTitleBackground(ColorUIResource var1);

        public void setWindowTitleForeground(ColorUIResource var1);

        public void setWindowTitleInactiveBackground(ColorUIResource var1);

        public void setWindowTitleInactiveForeground(ColorUIResource var1);

        public void setMenuBackground(ColorUIResource var1);

        public void setMenuForeground(ColorUIResource var1);

        public void setMenuSelectedBackground(ColorUIResource var1);

        public void setMenuSelectedForeground(ColorUIResource var1);

        public void setMenuDisabledForeground(ColorUIResource var1);

        public void setSeparatorBackground(ColorUIResource var1);

        public void setSeparatorForeground(ColorUIResource var1);

        public void setAcceleratorForeground(ColorUIResource var1);

        public void setAcceleratorSelectedForeground(ColorUIResource var1);

        public void putDefault(String var1, Object var2);
    }
}

