/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg;

import com.eloquence.services.Application.ActiveDialogList;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.EApplication;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.jdlg.controls.EMenu;
import com.eloquence.services.jdlg.controls.EPopupBox;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.jdlg.controls.eqhelppath;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.SafeRunnable;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class ControlsManager {
    private static final int systemDialogsOffset = 3;
    boolean isDisposed = false;
    private CreateControl createControl = new CreateControl();
    private ActivateDialog activateDialog = new ActivateDialog();
    private WaitListener waiting = new WaitListener();
    private EMenu contextMenuCtrl = null;
    private EMenu contextMenuTmpl = null;
    private RuleManager ruleManager = new RuleManager();
    private DeleteControl deleteControl = new DeleteControl();
    private static final Pattern splitPath = Pattern.compile("\\.");
    private static final Pattern wildcardPattern = Pattern.compile("[*?]");
    private Matcher isWildcard = null;
    private EDialog toplevelCurrentDialog = null;
    private LinkedList Dialogs = new LinkedList();
    private EDialog lastUsedDialog = null;
    private Dlg session;
    private EApplication app;
    private Map ControlAccessCache = new TreeMap();
    private Integer semaphore = new Integer(0);
    private boolean notified = false;
    private CurrentDialogLock currentDialogLock = new CurrentDialogLock();

    public ControlsManager(Dlg dlg, final String string, final HashMap hashMap) {
        this.session = dlg;
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                ESystem eSystem = ESystem.getObject();
                ControlsManager.this.Dialogs.add(eSystem);
                ControlsManager.this.ControlAccessCache.put(eSystem.getId().toLowerCase(), eSystem);
                ControlsManager.this.app = new EApplication(string);
                ControlsManager.this.app.setControlsManager(ControlsManager.this);
                ControlsManager.this.Dialogs.add(ControlsManager.this.app);
                ControlsManager.this.ControlAccessCache.put(ControlsManager.this.app.getId().toLowerCase(), ControlsManager.this.app);
                if (hashMap != null) {
                    ControlsManager.this.app.setAtomMap(hashMap);
                }
                eqhelppath eqhelppath2 = new eqhelppath();
                ControlsManager.this.Dialogs.add(eqhelppath2);
                ControlsManager.this.ControlAccessCache.put(eqhelppath2.getId().toLowerCase(), eqhelppath2);
                eqhelppath2.setEApplication(ControlsManager.this.app);
            }
        });
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.activateDialog = null;
            this.waiting = null;
            this.contextMenuCtrl = null;
            this.contextMenuTmpl = null;
            if (this.ruleManager != null) {
                this.ruleManager.dispose();
                this.ruleManager = null;
            }
            this.deleteControl = null;
            this.isWildcard = null;
            this.toplevelCurrentDialog = null;
            if (this.Dialogs != null) {
                this.Dialogs.clear();
                this.Dialogs = null;
            }
            this.lastUsedDialog = null;
            this.session = null;
            if (this.app != null) {
                this.app.dispose();
                this.app = null;
            }
            if (this.ControlAccessCache != null) {
                this.ControlAccessCache.clear();
                this.ControlAccessCache = null;
            }
            this.semaphore = null;
            this.currentDialogLock = null;
        }
    }

    public Dlg getSession() {
        return this.session;
    }

    public void handleNew(Dlg.Rq.NEW nEW, Dlg.Rs.STATUS sTATUS) {
        if (nEW.path.length() == 0) {
            sTATUS.status = 7;
            return;
        }
        if (nEW.classnm.length() == 0) {
            sTATUS.status = 11;
            return;
        }
        if ((nEW.classnm.equalsIgnoreCase("system") || nEW.classnm.equalsIgnoreCase("application")) && nEW.path.indexOf(46) == -1) {
            sTATUS.status = 0;
            return;
        }
        if (nEW.path.equalsIgnoreCase("system") || nEW.path.equalsIgnoreCase("application")) {
            sTATUS.status = 6;
            return;
        }
        AbstractControl abstractControl = this.createControl.exec(nEW, sTATUS);
        if (abstractControl != null) {
            if (sTATUS.status == 0) {
                this.recursivePutControlIntoCache(abstractControl);
            } else {
                abstractControl.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePopupBox(Dlg.Rq.POPUP pOPUP, Dlg.Rs.POPUP pOPUP2) throws InterruptedException {
        EPopupBox ePopupBox = new EPopupBox();
        ePopupBox.setControlsManager(this);
        ePopupBox.setEApplication(this.app);
        ePopupBox.setX(pOPUP.x);
        ePopupBox.setY(pOPUP.y);
        ePopupBox.setTitle(pOPUP.title);
        ePopupBox.setDefaultButtonNo(pOPUP.def_btn);
        ePopupBox.setButtonsTexts(pOPUP.btn);
        ePopupBox.setBodyTextLines(pOPUP.text);
        this.activateDialog.exec(null, null);
        ActiveDialogList.insertActiveDialog(this.session, ePopupBox);
        ePopupBox.eloq2swing(true);
        Integer n = this.semaphore;
        synchronized (n) {
            try {
                int n2 = this.app.getKeepaliveInternal();
                this.notified = false;
                while (!this.notified) {
                    if (n2 > 0) {
                        this.semaphore.wait((n2 + 1) * 1000);
                        if (this.notified) continue;
                        this.session.sendNopResponse();
                        continue;
                    }
                    this.semaphore.wait();
                }
                pOPUP2.status = 0;
                pOPUP2.btn = ePopupBox.getSelectedButtonNo();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                pOPUP2.status = 1;
            }
        }
        ePopupBox.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continuePopupBoxOperation() {
        if (this.semaphore == null) {
            return;
        }
        Integer n = this.semaphore;
        synchronized (n) {
            try {
                ActiveDialogList.insertActiveDialog(this.session, null);
                this.notified = true;
                this.semaphore.notifyAll();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public void handleHelp(Dlg.Rq.HELP hELP, Dlg.Rs.STATUS sTATUS) {
        sTATUS.status = 0;
        this.app.executeHelpRequest(hELP.tag, AbstractControl.isAbsoluteURL(hELP.tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDo(Dlg.Rq.DO dO, Dlg.Rs.DO dO2) throws InterruptedException {
        AbstractControl abstractControl = this.getControlFromCache(dO.path);
        if (abstractControl == null) {
            dO2.status = 7;
            return;
        }
        EDialog eDialog = abstractControl.getDialog();
        if (eDialog == null) {
            dO2.status = 7;
            return;
        }
        if (abstractControl != eDialog) {
            this.ruleManager.forceFocus(abstractControl);
        }
        if (this.ruleManager.processRule(dO2)) {
            return;
        }
        if (eDialog.processPendingNotification() && this.ruleManager.processRule(dO2)) {
            return;
        }
        Integer n = this.semaphore;
        synchronized (n) {
            this.notified = false;
        }
        this.waiting.stop();
        this.activateDialog.exec(eDialog, null);
        ActiveDialogList.insertActiveDialog(this.session, eDialog);
        this.initCurrentDialogLock();
        eDialog.eloq2swingRoot(true);
        try {
            n = this.semaphore;
            synchronized (n) {
                int n2 = this.app.getKeepaliveInternal();
                while (!this.notified) {
                    if (n2 > 0) {
                        this.semaphore.wait((n2 + 1) * 1000);
                        if (this.notified) continue;
                        this.session.sendNopResponse();
                        continue;
                    }
                    this.semaphore.wait();
                }
            }
            this.synchronizeCurrentDialog();
            if (!this.ruleManager.processRule(dO2)) {
                throw new RuntimeException("BUG: no rule");
            }
            this.activateDialog.exec(eDialog, dO2);
            this.waiting.start(eDialog);
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            dO2.status = 1;
        }
    }

    public int getMouseEventModifiers() {
        return this.ruleManager.mouseEventModifiers;
    }

    public int getMouseEventButton() {
        return this.ruleManager.mouseEventButton;
    }

    public int getMouseEventClickCount() {
        return this.ruleManager.mouseEventClickCount;
    }

    public void setContextMenu(EMenu eMenu, EMenu eMenu2) {
        this.contextMenuCtrl = eMenu;
        this.contextMenuTmpl = eMenu2;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStop(Dlg.Rq.STOP sTOP, Dlg.Rs.STATUS sTATUS) {
        List list;
        ActiveDialogList.insertActiveDialog(this.session, null);
        while (true) {
            LinkedList linkedList = this.Dialogs;
            synchronized (linkedList) {
                if (this.Dialogs.size() == 0) {
                    break;
                }
                list = (EDialog)this.Dialogs.get(0);
            }
            this.deleteControl.exec((AbstractControl)((Object)list));
        }
        list = this.Dialogs;
        synchronized (list) {
            this.Dialogs.clear();
        }
        sTATUS.status = 0;
    }

    public void handleDraw(Dlg.Rq.DRAW dRAW, Dlg.Rs.STATUS sTATUS) {
        AbstractControl abstractControl = this.getControlFromCache(dRAW.path);
        while (abstractControl != null) {
            AbstractControlContainer abstractControlContainer = abstractControl.getParent();
            if (abstractControlContainer == null && abstractControl instanceof EDialog) {
                EDialog eDialog = (EDialog)abstractControl;
                ActiveDialogList.insertActiveDialog(this.session, eDialog);
                this.initCurrentDialogLock();
                eDialog.eloq2swingRoot(false);
                this.synchronizeCurrentDialog();
                sTATUS.status = 0;
                return;
            }
            abstractControl = abstractControlContainer;
        }
        sTATUS.status = 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelete(Dlg.Rq.DEL dEL, Dlg.Rs.STATUS sTATUS) {
        if (dEL.path.indexOf(46) == -1) {
            EDialog eDialog = null;
            LinkedList linkedList = this.Dialogs;
            synchronized (linkedList) {
                int n = this.Dialogs.size();
                ListIterator listIterator = this.Dialogs.listIterator(n);
                while (listIterator.hasPrevious() && --n >= 3) {
                    EDialog eDialog2 = (EDialog)listIterator.previous();
                    if (!eDialog2.getId().equalsIgnoreCase(dEL.path)) continue;
                    eDialog = eDialog2;
                    break;
                }
            }
            sTATUS.status = eDialog != null ? this.deleteControl.exec(eDialog) : 7;
            return;
        }
        AbstractControl abstractControl = this.getControlFromCache(dEL.path);
        sTATUS.status = abstractControl != null ? this.deleteControl.exec(abstractControl) : 7;
    }

    private int wildcardIndex(String string) {
        if (this.isWildcard == null) {
            this.isWildcard = wildcardPattern.matcher(string);
        } else {
            this.isWildcard.reset(string);
        }
        if (this.isWildcard.find()) {
            return this.isWildcard.start();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wildcardGetSetAttributeValue(String string, int n, Dlg.Rq.GET gET, Dlg.Rs.GET gET2, Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(46, n3)) >= 0 && n2 <= n) {
            n4 = n2;
            ++n5;
            n3 = n2 + 1;
        }
        if (n5 > 0) {
            String[] stringArray = splitPath.split(string.substring(n4 + 1).toLowerCase());
            string = string.substring(0, n4);
            if (n5 == 1) {
                EDialog eDialog = null;
                LinkedList linkedList = this.Dialogs;
                synchronized (linkedList) {
                    ListIterator listIterator = this.Dialogs.listIterator(this.Dialogs.size());
                    while (listIterator.hasPrevious()) {
                        EDialog eDialog2 = (EDialog)listIterator.previous();
                        if (!eDialog2.getId().equalsIgnoreCase(string)) continue;
                        eDialog = eDialog2;
                        break;
                    }
                }
                if (eDialog != null) {
                    return eDialog.wildcardGetSetAttributeValue(stringArray, 0, false, gET, gET2, sET, sTATUS);
                }
            } else {
                AbstractControl abstractControl = this.getControlFromCache(string);
                if (abstractControl != null) {
                    return abstractControl.wildcardGetSetAttributeValue(stringArray, 0, false, gET, gET2, sET, sTATUS);
                }
            }
        }
        return 7;
    }

    private int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        if (gET.path != null) {
            int n = this.wildcardIndex(gET.path);
            if (n >= 0) {
                int n2 = this.wildcardGetSetAttributeValue(gET.path, n, gET, gET2, null, null);
                if (gET2.attrMode != 1) {
                    gET2.cacheMode = 0;
                    gET2.attrMode = 0;
                }
                return n2;
            }
            AbstractControl abstractControl = this.getControlFromCache(gET.path);
            if (abstractControl == null) {
                return 7;
            }
            return abstractControl.getAttributeValue(gET, gET2);
        }
        if (gET.attr.equals("first")) {
            return this.getToplevelFirst(gET2);
        }
        if (gET.attr.equals("next")) {
            return this.getToplevelNext(gET2);
        }
        return 8;
    }

    public void handleGet(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        gET2.status = this.getAttributeValue(gET, gET2);
    }

    private int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) {
        if (sET.path != null) {
            int n = this.wildcardIndex(sET.path);
            if (n >= 0) {
                this.wildcardGetSetAttributeValue(sET.path, n, null, null, sET, sTATUS);
                sTATUS.cacheMode = 0;
                return 0;
            }
            AbstractControl abstractControl = this.getControlFromCache(sET.path);
            if (abstractControl == null) {
                return 7;
            }
            try {
                return abstractControl.setAttributeValue(sET, sTATUS);
            }
            catch (Dlg.Status status) {
                return status.getStatus();
            }
        }
        return 8;
    }

    public void handleSet(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) {
        sTATUS.status = this.setAttributeValue(sET, sTATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewControl(Dlg.Rq.NEW nEW, Dlg.Rs.STATUS sTATUS, AbstractControl abstractControl, boolean bl) {
        int n = nEW.path.lastIndexOf(46);
        if (abstractControl instanceof EDialog) {
            if (n != -1) {
                sTATUS.status = 9;
                return;
            }
            EDialog eDialog = null;
            LinkedList linkedList = this.Dialogs;
            synchronized (linkedList) {
                ListIterator listIterator = this.Dialogs.listIterator();
                while (listIterator.hasNext()) {
                    EDialog eDialog2 = (EDialog)listIterator.next();
                    if (!eDialog2.getId().equalsIgnoreCase(nEW.path)) continue;
                    sTATUS.status = 6;
                    return;
                }
                eDialog = (EDialog)abstractControl;
                eDialog.setId(nEW.path);
                if (!bl) {
                    eDialog.setControlsManager(this);
                    eDialog.setEApplication(this.app);
                }
                this.Dialogs.add(eDialog);
            }
            sTATUS.status = 0;
            return;
        }
        if (n < 1) {
            sTATUS.status = 7;
            return;
        }
        AbstractControl abstractControl2 = this.getControlFromCache(nEW.path.substring(0, n));
        if (abstractControl2 == null) {
            sTATUS.status = 7;
            return;
        }
        if (!(abstractControl2 instanceof AbstractControlContainer)) {
            sTATUS.status = 9;
            return;
        }
        String string = nEW.path.substring(n + 1);
        if (string.length() == 0) {
            sTATUS.status = 7;
            return;
        }
        AbstractControlContainer abstractControlContainer = (AbstractControlContainer)abstractControl2;
        if (abstractControlContainer.hasControl(string)) {
            sTATUS.status = 6;
            return;
        }
        sTATUS.status = abstractControl.setParent(abstractControlContainer);
        if (sTATUS.status == 0) {
            String string2 = bl ? abstractControl.getId() : null;
            abstractControl.setId(string);
            abstractControlContainer.setModified();
            if (abstractControlContainer.add(abstractControl)) {
                if (string2 != null) {
                    abstractControlContainer.onRenameChild(abstractControl, string2);
                }
            } else {
                sTATUS.status = 1;
            }
        }
    }

    private AbstractControl cloneControl(Dlg.Rq.NEW nEW, Dlg.Rs.STATUS sTATUS) {
        AbstractControl abstractControl = this.getControlFromCache(nEW.classnm);
        if (abstractControl == null) {
            sTATUS.status = 11;
            return null;
        }
        AbstractControl abstractControl2 = (AbstractControl)abstractControl.clone();
        if (abstractControl2 == null) {
            sTATUS.status = 5;
            return null;
        }
        abstractControl2.postConstruction();
        this.addNewControl(nEW, sTATUS, abstractControl2, true);
        return abstractControl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renameControl(AbstractControl abstractControl, String string) {
        String string2 = abstractControl.getId();
        AbstractControlContainer abstractControlContainer = abstractControl.getParent();
        if (abstractControlContainer != null) {
            if (abstractControlContainer.hasControl(string)) {
                return 6;
            }
        } else {
            LinkedList linkedList = this.Dialogs;
            synchronized (linkedList) {
                ListIterator listIterator = this.Dialogs.listIterator();
                while (listIterator.hasNext()) {
                    EDialog eDialog = (EDialog)listIterator.next();
                    if (!eDialog.getId().equalsIgnoreCase(string)) continue;
                    return 6;
                }
            }
        }
        this.recursiveRemoveControlFromCache(abstractControl);
        abstractControl.setId(string);
        this.recursivePutControlIntoCache(abstractControl);
        if (abstractControlContainer != null) {
            abstractControlContainer.onRenameChild(abstractControl, string2);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getToplevelFirst(Dlg.Rs.GET gET) {
        LinkedList linkedList = this.Dialogs;
        synchronized (linkedList) {
            this.toplevelCurrentDialog = this.Dialogs.size() > 3 ? (EDialog)this.Dialogs.get(3) : null;
        }
        if (this.toplevelCurrentDialog != null) {
            gET.setValueString(this.app.return_ID(this.toplevelCurrentDialog.getId()));
        } else {
            gET.setValueString("");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getToplevelNext(Dlg.Rs.GET gET) {
        if (this.toplevelCurrentDialog == null) {
            return this.getToplevelFirst(gET);
        }
        try {
            EDialog eDialog = null;
            LinkedList linkedList = this.Dialogs;
            synchronized (linkedList) {
                int n = this.Dialogs.indexOf(this.toplevelCurrentDialog);
                eDialog = (EDialog)this.Dialogs.get(++n);
            }
            if (eDialog != null) {
                this.toplevelCurrentDialog = eDialog;
                gET.setValueString(this.app.return_ID(this.toplevelCurrentDialog.getId()));
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        gET.setValueString("");
        return 0;
    }

    public AbstractControl getControlFromCache(String string) {
        Map map = this.ControlAccessCache;
        synchronized (map) {
            try {
                return (AbstractControl)this.ControlAccessCache.get(string.toLowerCase());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursivePutControlIntoCache(AbstractControl abstractControl) {
        Object object = this.ControlAccessCache;
        synchronized (object) {
            try {
                this.ControlAccessCache.put(abstractControl.getPath().toLowerCase(), abstractControl);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (abstractControl instanceof AbstractControlContainer) {
            object = (AbstractControlContainer)abstractControl;
            ListIterator listIterator = ((AbstractControlContainer)object).children.listIterator();
            while (listIterator.hasNext()) {
                AbstractControl abstractControl2 = (AbstractControl)listIterator.next();
                this.recursivePutControlIntoCache(abstractControl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveRemoveControlFromCache(AbstractControl abstractControl) {
        Object object;
        Object object2;
        if (abstractControl instanceof AbstractControlContainer) {
            object2 = (AbstractControlContainer)abstractControl;
            object = ((AbstractControlContainer)object2).children.listIterator();
            while (object.hasNext()) {
                AbstractControl abstractControl2 = (AbstractControl)object.next();
                this.recursiveRemoveControlFromCache(abstractControl2);
            }
        }
        if ((object2 = abstractControl.getPath()) != null) {
            object = this.ControlAccessCache;
            synchronized (object) {
                try {
                    this.ControlAccessCache.remove(((String)object2).toLowerCase());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDialogs() {
        LinkedList linkedList = this.Dialogs;
        synchronized (linkedList) {
            return this.Dialogs.size() > 3;
        }
    }

    public EDialog getLastUsedDialog() {
        return this.lastUsedDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockCurrentDialog(int n) {
        if (n < 0 || n > 1) {
            throw new RuntimeException("BUG: lockCurrentDialog what=" + n);
        }
        int n2 = 1 << n;
        CurrentDialogLock currentDialogLock = this.currentDialogLock;
        synchronized (currentDialogLock) {
            this.currentDialogLock.bits |= n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCurrentDialog(int n) {
        if (n < 0 || n > 1) {
            throw new RuntimeException("BUG: unlockCurrentDialog what=" + n);
        }
        int n2 = ~(1 << n);
        CurrentDialogLock currentDialogLock = this.currentDialogLock;
        synchronized (currentDialogLock) {
            if ((this.currentDialogLock.bits &= n2) == 0) {
                try {
                    this.currentDialogLock.notifyAll();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCurrentDialogLock() {
        CurrentDialogLock currentDialogLock = this.currentDialogLock;
        synchronized (currentDialogLock) {
            this.currentDialogLock.bits = 0;
            try {
                this.currentDialogLock.notifyAll();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeCurrentDialog() {
        CurrentDialogLock currentDialogLock = this.currentDialogLock;
        synchronized (currentDialogLock) {
            if (this.currentDialogLock.bits != 0) {
                try {
                    this.currentDialogLock.wait(1000L);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    static final class CurrentDialogLock {
        private static final int maxBit = 1;
        public int bits = 0;

        CurrentDialogLock() {
        }
    }

    final class DeleteControl
    implements Runnable {
        private AbstractControl c;

        DeleteControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int exec(AbstractControl abstractControl) {
            block9: {
                this.c = abstractControl;
                ControlsManager.this.recursiveRemoveControlFromCache(abstractControl);
                try {
                    if (abstractControl instanceof EDialog) {
                        boolean bl;
                        EDialog eDialog = (EDialog)abstractControl;
                        if (ControlsManager.this.lastUsedDialog == eDialog) {
                            ControlsManager.this.lastUsedDialog = null;
                        }
                        LinkedList linkedList = ControlsManager.this.Dialogs;
                        synchronized (linkedList) {
                            bl = ControlsManager.this.Dialogs.remove(eDialog);
                        }
                        if (bl) {
                            SwingUtilities.invokeAndWait(this);
                            this.c = null;
                            return 0;
                        }
                        break block9;
                    }
                    AbstractControlContainer abstractControlContainer = abstractControl.getParent();
                    if (abstractControlContainer != null && abstractControlContainer.remove(abstractControl)) {
                        SwingUtilities.invokeAndWait(this);
                        this.c = null;
                        return 0;
                    }
                }
                catch (Throwable throwable) {
                    this.c = null;
                    throw new RuntimeException(throwable);
                }
            }
            this.c = null;
            return 1;
        }

        public void run() {
            this.c.checkout(ControlsManager.this.ruleManager);
            if (this.c instanceof EDialog) {
                ((EDialog)this.c).getFrame().setVisible(false);
            }
            this.c.dispose();
        }
    }

    public final class RuleManager {
        private static final int overrideOff = 0;
        private static final int overrideOn = 1;
        private static final int overrideForced = 2;
        private AbstractControl topMostWindow = null;
        private AbstractControl focusedControl = null;
        private AbstractControl overrideControl = null;
        private AbstractControl lastRmbControl = null;
        private int overrideMode = 0;
        private boolean overrideEnabled = false;
        private boolean softFocus = false;
        private AbstractControl lastTopDialog = null;
        private LinkedList ruleControls = new LinkedList();
        private Point rmbPoint = new Point(0, 0);
        private int mouseEventModifiers = 0;
        private int mouseEventButton = 0;
        private int mouseEventClickCount = 0;
        private Point refPos = null;
        private Dimension refSize = null;
        private boolean refSizeValid = false;
        private double popupBoxScaleFactor = 1.0;

        private void dispose() {
            this.topMostWindow = null;
            this.focusedControl = null;
            this.overrideControl = null;
            this.lastRmbControl = null;
            this.lastTopDialog = null;
            if (this.ruleControls != null) {
                this.ruleControls.clear();
                this.ruleControls = null;
            }
            this.rmbPoint = null;
            this.refPos = null;
            this.refSize = null;
        }

        public void setLastRmbControl(AbstractControl abstractControl, int n, int n2) {
            this.lastRmbControl = abstractControl;
            this.rmbPoint.x = n;
            this.rmbPoint.y = n2;
        }

        public AbstractControl getLastRmbControl(Point point) {
            point.x = this.rmbPoint.x;
            point.y = this.rmbPoint.y;
            return this.lastRmbControl;
        }

        public Point getRefPoint() {
            if (!ControlsManager.this.app.useSessionRefPoint()) {
                return null;
            }
            return ControlsManager.this.app.getSessionRefPoint();
        }

        public void setRefPoint(Point point) {
            if (point != null) {
                ControlsManager.this.app.setSessionRefPoint(point);
            }
        }

        public Point getRefPos() {
            return this.refPos != null && ControlsManager.this.app.useSessionRefPoint() ? this.refPos : null;
        }

        public void setRefPos(Point point) {
            if (point != null) {
                if (this.refPos == null) {
                    this.refPos = new Point(point);
                } else {
                    this.refPos.x = point.x;
                    this.refPos.y = point.y;
                }
            }
        }

        public Dimension getRefSize() {
            return this.refSizeValid && this.refSize != null && ControlsManager.this.app.useSessionRefPoint() ? this.refSize : null;
        }

        public void setRefSize(Dimension dimension) {
            if (dimension != null) {
                if (this.refSize == null) {
                    this.refSize = new Dimension(dimension);
                } else {
                    this.refSize.width = dimension.width;
                    this.refSize.height = dimension.height;
                }
                this.refSizeValid = true;
            } else {
                this.refSizeValid = false;
            }
        }

        public double getPopupBoxScaleFactor() {
            return this.popupBoxScaleFactor;
        }

        public void setPopupBoxScaleFactor(double d) {
            this.popupBoxScaleFactor = d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestTopMostWindow(AbstractControl abstractControl) {
            this.topMostWindow = abstractControl;
            if (abstractControl instanceof EDialog) {
                LinkedList linkedList = ControlsManager.this.Dialogs;
                synchronized (linkedList) {
                    int n = ControlsManager.this.Dialogs.size();
                    boolean bl = true;
                    ListIterator listIterator = ControlsManager.this.Dialogs.listIterator(n);
                    while (listIterator.hasPrevious() && --n >= 3) {
                        EDialog eDialog = (EDialog)listIterator.previous();
                        if (eDialog == abstractControl) {
                            if (bl) break;
                            listIterator.remove();
                            ControlsManager.this.Dialogs.add(eDialog);
                            break;
                        }
                        bl = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EDialog getTopDialog(boolean bl) {
            EDialog eDialog = null;
            LinkedList linkedList = ControlsManager.this.Dialogs;
            synchronized (linkedList) {
                int n = ControlsManager.this.Dialogs.size();
                ListIterator listIterator = ControlsManager.this.Dialogs.listIterator(n);
                while (listIterator.hasPrevious() && --n >= 3) {
                    EDialog eDialog2 = (EDialog)listIterator.previous();
                    if (bl && !eDialog2.isVisible()) continue;
                    eDialog = eDialog2;
                    break;
                }
            }
            return eDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAllDialogs(EDialog eDialog, String string, String string2) {
            LinkedList linkedList = ControlsManager.this.Dialogs;
            synchronized (linkedList) {
                int n = ControlsManager.this.Dialogs.size();
                ListIterator listIterator = ControlsManager.this.Dialogs.listIterator(n);
                while (listIterator.hasPrevious() && --n >= 3) {
                    EDialog eDialog2 = (EDialog)listIterator.previous();
                    if (eDialog2 == eDialog) continue;
                    eDialog2.setNotification(string, string2, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateTopVisibleDialog() {
            EDialog eDialog = null;
            LinkedList linkedList = ControlsManager.this.Dialogs;
            synchronized (linkedList) {
                int n = ControlsManager.this.Dialogs.size();
                boolean bl = true;
                ListIterator listIterator = ControlsManager.this.Dialogs.listIterator(n);
                while (listIterator.hasPrevious() && --n >= 3) {
                    EDialog eDialog2 = (EDialog)listIterator.previous();
                    if (eDialog2.isVisible()) {
                        if (!bl) {
                            listIterator.remove();
                            ControlsManager.this.Dialogs.add(eDialog2);
                        }
                        eDialog = eDialog2;
                        break;
                    }
                    bl = false;
                }
            }
            if (eDialog != null) {
                eDialog.setSessionReference(this);
            }
        }

        public void setTopDialog(AbstractControl abstractControl) {
            this.lastTopDialog = abstractControl;
        }

        public boolean isTopDialog(EDialog eDialog) {
            return eDialog == this.lastTopDialog;
        }

        public void validateTopMostWindow() {
            if (this.topMostWindow != null && this.topMostWindow != this.lastTopDialog) {
                if (this.lastTopDialog instanceof EDialog) {
                    ((EDialog)this.lastTopDialog).setStatus(1);
                }
                this.lastTopDialog = this.topMostWindow;
                if (this.topMostWindow instanceof EDialog) {
                    ((EDialog)this.topMostWindow).setStatus(0);
                }
                this.topMostWindow.windowToFront(false);
            }
        }

        public void checkoutControl(AbstractControl abstractControl) {
            if (this.focusedControl == abstractControl) {
                this.focusedControl = null;
            }
            if (this.overrideControl == abstractControl) {
                this.overrideControl = null;
                this.overrideEnabled = false;
                this.overrideMode = 0;
            }
            if (this.topMostWindow == abstractControl) {
                this.topMostWindow = null;
            }
            if (this.lastTopDialog == abstractControl) {
                this.lastTopDialog = null;
            }
        }

        public void resetStack() {
            this.ruleControls.clear();
            this.overrideControl = null;
            this.overrideEnabled = false;
            this.overrideMode = 0;
            this.softFocus = false;
            this.mouseEventModifiers = 0;
            this.mouseEventButton = 0;
            this.mouseEventClickCount = 0;
        }

        public boolean restoreFocus(AbstractControlContainer abstractControlContainer) {
            try {
                AbstractControl abstractControl = this.focusedControl;
                if (this.focusedControl == null || !this.focusedControl.isChildOf(abstractControlContainer)) {
                    this.focusedControl = abstractControlContainer.getLastFocus();
                    if (this.focusedControl == null) {
                        this.focusedControl = abstractControlContainer.getNextFocusControl(false);
                    }
                }
                if (!this.focusedControl.isFocusable(false)) {
                    this.focusedControl = this.focusedControl.getNextFocusControl(false);
                }
                if (!this.softFocus) {
                    this.focusedControl.requestFocusInWindow(this.focusedControl.getFocusPeer());
                } else {
                    this.softFocus = false;
                }
                this.focusedControl.focusReceived(abstractControl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.focusedControl != null) {
                ESystem.typeAhead.processPendingEvents(this.focusedControl);
            }
            return true;
        }

        public boolean requestFocus(AbstractControl abstractControl, boolean bl) {
            if (abstractControl == this.focusedControl && abstractControl.getNextFocusControl(false) != abstractControl) {
                return true;
            }
            if (!abstractControl.isFocusable(false)) {
                return false;
            }
            if (this.focusedControl != null) {
                this.focusedControl.focusLost(abstractControl);
            }
            abstractControl.focusReceived(this.focusedControl);
            this.focusedControl = abstractControl;
            this.softFocus = bl;
            return true;
        }

        public boolean requestFocus(AbstractControl abstractControl) {
            return this.requestFocus(abstractControl, false);
        }

        public void forceFocus(AbstractControl abstractControl, boolean bl) {
            if (abstractControl != null) {
                if (this.focusedControl != null) {
                    this.focusedControl.focusLost(abstractControl);
                }
                abstractControl.focusReceived(this.focusedControl);
                this.softFocus = bl;
                this.focusedControl = abstractControl;
            }
        }

        public void forceFocus(AbstractControl abstractControl) {
            this.forceFocus(abstractControl, false);
        }

        public AbstractControl getFocus() {
            return this.focusedControl;
        }

        public boolean requestNextFocus() {
            if (this.focusedControl == null) {
                return false;
            }
            if (!this.requestFocus(this.focusedControl.getNextFocusControl(true))) {
                return false;
            }
            this.focusedControl.onTabFocus(true);
            this.focusedControl.requestFocusInWindow(this.focusedControl.getFocusPeer());
            return true;
        }

        public boolean requestPrevFocus() {
            if (this.focusedControl == null) {
                return false;
            }
            if (!this.requestFocus(this.focusedControl.getPrevFocusControl(true))) {
                return false;
            }
            this.focusedControl.onTabFocus(false);
            this.focusedControl.requestFocusInWindow(this.focusedControl.getFocusPeer());
            return true;
        }

        public boolean prepareOverride(AbstractControl abstractControl) {
            return this.prepareOverride(abstractControl, null);
        }

        public boolean prepareOverride(AbstractControl abstractControl, MouseEvent mouseEvent) {
            if (this.ruleControls.size() >= 2) {
                this.wakeDoOperation();
                return false;
            }
            this.overrideControl = abstractControl;
            this.overrideMode = abstractControl instanceof RuleOverride ? 1 : 2;
            if (mouseEvent != null) {
                this.mouseEventModifiers = mouseEvent.getModifiersEx();
                this.mouseEventButton = 0;
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.mouseEventButton |= 1;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.mouseEventButton |= 2;
                }
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    this.mouseEventButton |= 4;
                }
                this.mouseEventClickCount = mouseEvent.getClickCount();
            } else {
                this.mouseEventModifiers = 0;
                this.mouseEventButton = 0;
                this.mouseEventClickCount = 0;
            }
            this.overrideEnabled = true;
            return true;
        }

        public AbstractControl modifyOverride(AbstractControl abstractControl) {
            AbstractControl abstractControl2 = this.overrideControl;
            if (this.overrideEnabled && abstractControl != null && this.overrideControl != null) {
                this.overrideControl = abstractControl;
            }
            return abstractControl2;
        }

        public boolean forceOverride() {
            AbstractControl abstractControl = this.getFocus();
            if (!this.overrideEnabled || this.overrideControl == null || abstractControl == null || !abstractControl.fireRuleOnLosingFocus() || this.ruleControls.size() > 0) {
                return false;
            }
            this.ruleControls.addLast(abstractControl);
            this.overrideMode = 2;
            return true;
        }

        public void cancelOverride() {
            this.cancelOverride(true);
        }

        public boolean cancelOverride(boolean bl) {
            this.overrideEnabled = false;
            this.overrideMode = 0;
            this.overrideControl = null;
            this.mouseEventModifiers = 0;
            this.mouseEventButton = 0;
            this.mouseEventClickCount = 0;
            if (this.ruleControls.size() > 0) {
                if (bl) {
                    this.wakeDoOperation();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeDoOperation() {
            Object object;
            ListIterator listIterator = this.ruleControls.listIterator();
            while (listIterator.hasNext()) {
                object = (AbstractControl)listIterator.next();
                ((AbstractControl)object).ruleFired();
            }
            object = ControlsManager.this.semaphore;
            synchronized (object) {
                try {
                    ControlsManager.this.notified = true;
                    ControlsManager.this.semaphore.notifyAll();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }

        public boolean fireRule(AbstractControl abstractControl) {
            return this.fireRule(abstractControl, true);
        }

        public boolean fireRule(AbstractControl abstractControl, boolean bl) {
            if (bl && abstractControl.getRule() == -1) {
                AbstractControl abstractControl2 = abstractControl;
                if (this.ruleControls.size() > 0) {
                    abstractControl2 = (AbstractControl)this.ruleControls.removeFirst();
                }
                abstractControl2.executeHelpRequest();
                abstractControl.ruleProcessed();
                return true;
            }
            boolean bl2 = false;
            if (abstractControl.notifyRule()) {
                if (this.ruleControls.size() < 2) {
                    this.ruleControls.addLast(abstractControl);
                } else {
                    abstractControl.ruleProcessed();
                    Toolkit.getDefaultToolkit().beep();
                }
                if (!this.overrideEnabled || abstractControl == this.overrideControl) {
                    this.wakeDoOperation();
                }
                bl2 = true;
            }
            this.overrideEnabled = false;
            return bl2;
        }

        public void fireUnconditionalRule(AbstractControl abstractControl) {
            if (this.ruleControls.size() < 2) {
                this.ruleControls.addLast(abstractControl);
            } else {
                abstractControl.ruleProcessed();
                Toolkit.getDefaultToolkit().beep();
            }
            if (!this.overrideEnabled || abstractControl == this.overrideControl) {
                this.wakeDoOperation();
            }
            this.overrideEnabled = false;
        }

        private void ctrlProcessRule(AbstractControl abstractControl, Dlg.Rs.DO dO, boolean bl, boolean bl2) {
            abstractControl.processRule(dO, bl, bl2);
            if (bl && dO.path == null && Debug.isLog(2, 1)) {
                Debug.log(2, 1, "BUG: path == null");
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                for (int i = 2; i < stackTraceElementArray.length; ++i) {
                    String string = stackTraceElementArray[i].toString();
                    if (!string.startsWith("com.eloquence.")) continue;
                    Debug.log(2, 1, "  at " + string);
                }
            }
        }

        private boolean processRule(Dlg.Rs.DO dO) {
            if (this.ruleControls.size() == 0) {
                return false;
            }
            AbstractControl abstractControl = (AbstractControl)this.ruleControls.getLast();
            if (this.ruleControls.size() > 1 && (this.overrideMode == 2 || this.overrideMode == 1 && abstractControl instanceof RuleOverride && ((RuleOverride)((Object)abstractControl)).getRuleOverride() != 0)) {
                abstractControl = (AbstractControl)this.ruleControls.removeFirst();
                this.ctrlProcessRule(abstractControl, dO, true, false);
                abstractControl = (AbstractControl)this.ruleControls.removeFirst();
                this.ctrlProcessRule(abstractControl, dO, false, true);
                abstractControl.ruleProcessed();
            } else {
                abstractControl = (AbstractControl)this.ruleControls.removeFirst();
                this.ctrlProcessRule(abstractControl, dO, true, true);
                abstractControl.ruleProcessed();
            }
            this.overrideMode = 0;
            this.overrideControl = null;
            dO.status = 0;
            return true;
        }

        public int rulesPending() {
            return this.ruleControls.size();
        }
    }

    public static interface RuleOverride {
        public int getRuleOverride();

        public void setRuleOverride(int var1);
    }

    private class WaitListener
    extends Timer
    implements ActionListener {
        private EDialog dialog;

        public WaitListener() {
            super(500, null);
            this.dialog = null;
            this.setRepeats(false);
            this.addActionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(EDialog eDialog) {
            WaitListener waitListener = this;
            synchronized (waitListener) {
                this.dialog = eDialog;
                super.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            WaitListener waitListener = this;
            synchronized (waitListener) {
                this.dialog = null;
                super.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            EDialog eDialog = null;
            WaitListener waitListener = this;
            synchronized (waitListener) {
                if (this.dialog != null) {
                    eDialog = this.dialog;
                }
            }
            if (eDialog != null) {
                eDialog.setStatus(1);
            }
        }
    }

    final class ActivateDialog
    implements Runnable {
        private EDialog dialog;
        private Dlg.Rs.DO rs;

        ActivateDialog() {
        }

        public void exec(EDialog eDialog, Dlg.Rs.DO dO) {
            this.dialog = eDialog;
            this.rs = dO;
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (Throwable throwable) {
                this.dialog = null;
                this.rs = null;
                throw new RuntimeException(throwable);
            }
            this.dialog = null;
            this.rs = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = ControlsManager.this.Dialogs;
            synchronized (linkedList) {
                int n = ControlsManager.this.Dialogs.size();
                ListIterator listIterator = ControlsManager.this.Dialogs.listIterator(n);
                while (listIterator.hasPrevious() && --n >= 3) {
                    boolean bl;
                    EDialog eDialog = (EDialog)listIterator.previous();
                    boolean bl2 = bl = this.rs == null && eDialog == this.dialog;
                    if (bl) {
                        ControlsManager.this.lastUsedDialog = eDialog;
                        ControlsManager.this.ruleManager.mouseEventModifiers = 0;
                        ControlsManager.this.ruleManager.mouseEventButton = 0;
                        ControlsManager.this.ruleManager.mouseEventClickCount = 0;
                        eDialog.setStatus(0);
                        eDialog.setInDlgDo(true);
                    } else if (this.rs == null) {
                        eDialog.setStatus(1);
                        if (this.dialog != null) {
                            eDialog.cancelPendingNotification();
                        }
                    }
                    eDialog.allowEvents(bl);
                }
            }
            if (this.dialog != null && this.rs != null) {
                this.dialog.setInDlgDo(false);
                if (ControlsManager.this.contextMenuCtrl != null && ControlsManager.this.contextMenuTmpl != null) {
                    ControlsManager.this.contextMenuCtrl.swing2eloq(null);
                    ControlsManager.this.contextMenuCtrl.copyState(ControlsManager.this.contextMenuTmpl);
                    ControlsManager.this.contextMenuCtrl = null;
                }
                if (!this.rs.canCache()) {
                    this.rs = null;
                }
                ControlsManager.this.app.swing2eloq(this.rs);
                this.dialog.swing2eloq(this.rs);
            }
        }
    }

    final class CreateControl
    implements Runnable {
        Dlg.Rq.NEW rq;
        Dlg.Rs.STATUS rs;
        private AbstractControl ctrl;

        CreateControl() {
        }

        public AbstractControl exec(Dlg.Rq.NEW nEW, Dlg.Rs.STATUS sTATUS) {
            this.rq = nEW;
            this.rs = sTATUS;
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (Throwable throwable) {
                this.rq = null;
                this.rs = null;
                this.ctrl = null;
                throw new RuntimeException(throwable);
            }
            AbstractControl abstractControl = this.ctrl;
            this.ctrl = null;
            return abstractControl;
        }

        public void run() {
            this.ctrl = AbstractControl.createControl(this.rq.classnm);
            if (this.ctrl != null) {
                ControlsManager.this.addNewControl(this.rq, this.rs, this.ctrl, false);
            } else {
                this.ctrl = ControlsManager.this.cloneControl(this.rq, this.rs);
            }
        }
    }
}

