/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.FontReference;
import com.eloquence.services.tools.Glob;
import com.eloquence.services.tools.Scaling;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public abstract class AbstractControlContainer
extends AbstractControl
implements List {
    private static HashMap attributeList = new HashMap();
    private static final int TITLE_ATTR_ID = 0;
    private static final int BORDER_ATTR_ID = 1;
    private static final int FILE_ATTR_ID = 2;
    private static final int HSB_ATTR_ID = 3;
    private static final int VSB_ATTR_ID = 4;
    private static final int CX_ATTR_ID = 5;
    private static final int CY_ATTR_ID = 6;
    protected boolean layoutChanged = true;
    private Dimension layoutSize = null;
    protected AbstractControl lastFocus = null;
    public static final String TITLE_ATTR_NAME = "title";
    public static final String BORDER_ATTR_NAME = "border";
    protected String title = "";
    protected int border = 1;
    public List children = new ArrayList();
    private ButtonGroup group = null;

    protected void finalize() throws Throwable {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractControlContainer abstractControlContainer = this;
        synchronized (abstractControlContainer) {
            if (!this.isDisposed) {
                while (this.children.size() > 0) {
                    ((AbstractControl)this.children.get(0)).dispose();
                }
                this.children.clear();
                if (this.peer instanceof Container) {
                    ((Container)this.peer).removeAll();
                }
                if (this.group != null) {
                    Enumeration<AbstractButton> enumeration = this.group.getElements();
                    while (enumeration.hasMoreElements()) {
                        AbstractButton abstractButton = enumeration.nextElement();
                        this.group.remove(abstractButton);
                    }
                    this.group = null;
                }
                super.dispose();
            }
        }
    }

    public void checkout(ControlsManager.RuleManager ruleManager) {
        super.checkout(ruleManager);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.checkout(ruleManager);
        }
    }

    public void cloneAttributes(AbstractControlContainer abstractControlContainer) {
        super.cloneAttributes(abstractControlContainer);
        abstractControlContainer.setTitle(this.getTitle());
        abstractControlContainer.setBorder(this.getBorder());
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.parent = abstractControlContainer;
            AbstractControl abstractControl2 = (AbstractControl)abstractControl.clone();
            abstractControl.parent = this;
            abstractControl2.postConstruction();
            abstractControlContainer.add(abstractControl2);
        }
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setTitle(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setBorder(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getTitle());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getBorder());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public int wildcardGetSetAttributeValue(String[] stringArray, int n, boolean bl, Dlg.Rq.GET gET, Dlg.Rs.GET gET2, Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) {
        int n2 = stringArray.length;
        int n3 = 7;
        if (n2 == 0 || n > n2) {
            return n3;
        }
        while (n < n2 && stringArray[n].equals("*")) {
            bl = true;
            ++n;
        }
        if (!bl && n == n2) {
            return n3;
        }
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            if (bl && n == n2) {
                if (gET2 != null) {
                    return abstractControl.getAttributeValue(gET, gET2);
                }
                try {
                    n3 = abstractControl.setAttributeValue(sET, sTATUS);
                }
                catch (Dlg.Status status) {
                    n3 = status.getStatus();
                }
            } else if (Glob.match(stringArray[n], abstractControl.getId().toLowerCase())) {
                if (n == n2 - 1) {
                    if (gET2 != null) {
                        return abstractControl.getAttributeValue(gET, gET2);
                    }
                    try {
                        n3 = abstractControl.setAttributeValue(sET, sTATUS);
                    }
                    catch (Dlg.Status status) {
                        n3 = status.getStatus();
                    }
                } else {
                    n3 = abstractControl.wildcardGetSetAttributeValue(stringArray, n + 1, false, gET, gET2, sET, sTATUS);
                    if (gET2 != null && n3 != 7) {
                        return n3;
                    }
                }
            }
            if (!bl) continue;
            n3 = abstractControl.wildcardGetSetAttributeValue(stringArray, n, true, gET, gET2, sET, sTATUS);
            if (gET2 == null || n3 == 7) continue;
            return n3;
        }
        return n3;
    }

    public void eloq2swing(boolean bl) {
        super.eloq2swing(bl);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.eloq2swing(bl);
        }
        if (this.dragDropInstalled()) {
            this.disableDropChildren();
        } else if (this.dragDropRemoved()) {
            this.enableDropChildren();
        }
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        super.swing2eloq(dO);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.swing2eloq(dO);
        }
    }

    protected void executeHelpRequest(String string, boolean bl) {
        if (this.parent != null) {
            if (bl) {
                this.parent.executeHelpRequest(string, true);
            } else {
                this.parent.executeHelpRequest(this.getHelp() + string, false);
            }
        }
    }

    public void setContextControl(AbstractControl abstractControl) {
        super.setContextControl(abstractControl);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl2 = (AbstractControl)listIterator.next();
            abstractControl2.setContextControl(abstractControl);
        }
    }

    public void updateFont() {
        super.updateFont();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.updateFont();
        }
    }

    public void setLayoutChanged() {
        this.layoutChanged = true;
        super.setLayoutChanged();
    }

    public boolean beginDrag() {
        super.beginDrag();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.beginDrag();
        }
        return true;
    }

    public void endDrag() {
        super.endDrag();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.endDrag();
        }
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.useMarginTop()) {
            n4 = dimension2.height / 2;
            n3 = this.useMarginBottom() ? n4 : 0;
        } else {
            n4 = 0;
            n3 = this.useMarginBottom() ? dimension2.height / 2 : 0;
        }
        if (this.useMarginLeft()) {
            n2 = dimension2.width / 2;
            n = this.useMarginRight() ? n2 : 0;
        } else {
            n2 = 0;
            n = this.useMarginRight() ? dimension2.width / 2 : 0;
        }
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            Dimension dimension3;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            if (!abstractControl.visible || !abstractControl.layoutAsChild()) continue;
            switch (abstractControl.xauto) {
                case -1: {
                    n9 = abstractControl.getXright();
                    n9 = abstractControl.useRasterPos ? (n9 *= dimension2.width) : (int)Math.round((double)n9 * scaling.x);
                    n8 = abstractControl.getWidth();
                    n8 = abstractControl.useRasterSize ? (n8 *= dimension2.width) : (int)Math.round((double)n8 * scaling.x);
                    n7 = dimension.width - n2 - n - n9 - n8;
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    abstractControl.xPos = abstractControl.useRasterPos ? (int)Math.round((double)n7 / (double)dimension2.width) : (int)Math.round((double)n7 / scaling.x);
                    n7 += n2;
                    break;
                }
                case 0: {
                    n7 = abstractControl.getX();
                    int n10 = abstractControl.getXright();
                    if (abstractControl.useRasterPos) {
                        n7 *= dimension2.width;
                        n10 *= dimension2.width;
                    } else {
                        n7 = (int)Math.round((double)n7 * scaling.x);
                        n10 = (int)Math.round((double)n10 * scaling.x);
                    }
                    n8 = dimension.width - n7 - n10;
                    n7 += n2;
                    if ((n8 -= n2 + n) < 0) {
                        n8 = 0;
                    }
                    if (abstractControl.useRasterSize) {
                        if (n8 > 0 && n8 < dimension2.width) {
                            n8 = dimension2.width;
                        }
                        abstractControl.width = (int)Math.round((double)n8 / (double)dimension2.width);
                        break;
                    }
                    abstractControl.width = (int)Math.round((double)n8 / scaling.x);
                    break;
                }
                default: {
                    n7 = abstractControl.getX();
                    n7 = abstractControl.useRasterPos ? (n7 *= dimension2.width) : (int)Math.round((double)n7 * scaling.x);
                    n8 = abstractControl.getWidth();
                    n8 = abstractControl.useRasterSize ? (n8 *= dimension2.width) : (int)Math.round((double)n8 * scaling.x);
                    n7 += n2;
                }
            }
            switch (abstractControl.yauto) {
                case -1: {
                    n9 = abstractControl.getYbottom();
                    n9 = abstractControl.useRasterPos ? (n9 *= dimension2.height) : (int)Math.round((double)n9 * scaling.y);
                    n6 = abstractControl.getHeight();
                    n6 = abstractControl.useRasterSize ? (n6 *= dimension2.height) : (int)Math.round((double)n6 * scaling.y);
                    n5 = dimension.height - n4 - n3 - n9 - n6;
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    abstractControl.yPos = abstractControl.useRasterPos ? (int)Math.round((double)n5 / (double)dimension2.height) : (int)Math.round((double)n5 / scaling.y);
                    n5 += n4;
                    break;
                }
                case 0: {
                    n5 = abstractControl.getY();
                    n9 = abstractControl.getYbottom();
                    if (abstractControl.useRasterPos) {
                        n5 *= dimension2.height;
                        n9 *= dimension2.height;
                    } else {
                        n5 = (int)Math.round((double)n5 * scaling.y);
                        n9 = (int)Math.round((double)n9 * scaling.y);
                    }
                    n6 = dimension.height - n5 - n9;
                    n5 += n4;
                    if ((n6 -= n4 + n3) < 0) {
                        n6 = 0;
                    }
                    if (abstractControl.useRasterSize) {
                        if (n6 > 0 && n6 < dimension2.height) {
                            n6 = dimension2.height;
                        }
                        abstractControl.height = (int)Math.round((double)n6 / (double)dimension2.height);
                        break;
                    }
                    abstractControl.height = (int)Math.round((double)n6 / scaling.y);
                    break;
                }
                default: {
                    n5 = abstractControl.getY();
                    n5 = abstractControl.useRasterPos ? (n5 *= dimension2.height) : (int)Math.round((double)n5 * scaling.y);
                    n6 = abstractControl.getHeight();
                    n6 = abstractControl.useRasterSize ? (n6 *= dimension2.height) : (int)Math.round((double)n6 * scaling.y);
                    n5 += n4;
                }
            }
            Component component = abstractControl.getPeer();
            Point point = component.getLocation();
            if (point.x != n7 || point.y != n5) {
                component.setLocation(n7, n5);
            }
            if (this.layoutSize == null) {
                this.layoutSize = new Dimension(n8, n6);
            } else {
                this.layoutSize.width = n8;
                this.layoutSize.height = n6;
            }
            if (!abstractControl.layout(this.layoutSize, dimension2, scaling)) {
                dimension3 = component.getSize();
                if (dimension3.width == this.layoutSize.width && dimension3.height == this.layoutSize.height) continue;
                component.setSize(this.layoutSize);
                continue;
            }
            if (abstractControl.xauto != -1 && abstractControl.yauto != -1) continue;
            dimension3 = component.getSize();
            if (dimension3.width == n8 && dimension3.height == n6) continue;
            if (abstractControl.xauto == -1) {
                n7 += n8 - dimension3.width;
            }
            if (abstractControl.yauto == -1) {
                n5 += n6 - dimension3.height;
            }
            point = component.getLocation();
            if (point.x == n7 && point.y == n5) continue;
            if (point.x != n7) {
                abstractControl.xPos = abstractControl.useRasterPos ? (int)Math.round((double)n7 - (double)n2 / (double)dimension2.width) : (int)Math.round((double)n7 - (double)n2 / scaling.x);
            }
            if (point.y != n5) {
                abstractControl.yPos = abstractControl.useRasterPos ? (int)Math.round((double)n5 - (double)n4 / (double)dimension2.height) : (int)Math.round((double)n5 - (double)n4 / scaling.y);
            }
            component.setLocation(n7, n5);
        }
        return false;
    }

    public void setFontReference(FontReference fontReference) {
        super.setFontReference(fontReference);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.setFontReference(this.fontReferenceCloned ? this.fontReference : fontReference);
        }
    }

    public void setFgc(int n) {
        super.setFgc(n);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.setFgc(n);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.isModified = true;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBorder(int n) {
        this.border = n;
        this.isModified = true;
    }

    public int getBorder() {
        return this.border;
    }

    public AbstractControl findNextFocusControl(AbstractControl abstractControl, boolean bl, boolean bl2) {
        ListIterator listIterator;
        if (abstractControl != null) {
            int n = this.children.indexOf(abstractControl);
            if (n == -1) {
                throw new RuntimeException("not found: '" + abstractControl.getClass().getName() + "' (" + abstractControl.getPath() + ") in: '" + this.getClass().getName() + "' (" + this.getPath() + ")");
            }
            listIterator = this.children.listIterator(n + 1);
        } else {
            listIterator = this.children.listIterator();
        }
        while (listIterator.hasNext()) {
            AbstractControl abstractControl2 = (AbstractControl)listIterator.next();
            if (abstractControl2.isFocusable(bl)) {
                return abstractControl2;
            }
            AbstractControl abstractControl3 = abstractControl2.findNextFocusControl(bl, false);
            if (abstractControl3 == null) continue;
            return abstractControl3;
        }
        return bl2 && this.parent != null ? this.parent.ascendNextFocusControl(this, bl) : null;
    }

    public AbstractControl ascendNextFocusControl(AbstractControl abstractControl, boolean bl) {
        return this.findNextFocusControl(abstractControl, bl, true);
    }

    public AbstractControl findPrevFocusControl(AbstractControl abstractControl, boolean bl, boolean bl2) {
        ListIterator listIterator;
        if (abstractControl != null) {
            int n = this.children.indexOf(abstractControl);
            if (n == -1) {
                throw new RuntimeException("not found: '" + abstractControl.getClass().getName() + "' (" + abstractControl.getPath() + ") in: '" + this.getClass().getName() + "' (" + this.getPath() + ")");
            }
            listIterator = this.children.listIterator(n);
        } else {
            listIterator = this.children.listIterator(this.children.size());
        }
        while (listIterator.hasPrevious()) {
            AbstractControl abstractControl2 = (AbstractControl)listIterator.previous();
            AbstractControl abstractControl3 = abstractControl2.findPrevFocusControl(bl, false);
            if (abstractControl3 != null) {
                return abstractControl3;
            }
            if (!abstractControl2.isFocusable(bl)) continue;
            return abstractControl2;
        }
        return bl2 && this.parent != null ? this.parent.ascendPrevFocusControl(this, bl) : null;
    }

    public AbstractControl ascendPrevFocusControl(AbstractControl abstractControl, boolean bl) {
        return this.findPrevFocusControl(abstractControl, bl, true);
    }

    public void childFocusChain(AbstractControl abstractControl, AbstractControl abstractControl2) {
        if (this.parent != null) {
            this.parent.childFocusChain(this, abstractControl2);
        }
        this.lastFocus = abstractControl2;
    }

    public void childRemoveChain(AbstractControl abstractControl) {
        if (abstractControl == this.lastFocus) {
            this.lastFocus = null;
        }
        if (this.parent != null) {
            this.parent.childRemoveChain(abstractControl);
        }
    }

    public AbstractControl getLastFocus() {
        return this.lastFocus;
    }

    public void setFocus(int n) {
        this.lastFocus = this.getNextFocusControl(false);
        super.setFocus(n);
    }

    public boolean hasControl(String string) {
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            if (!abstractControl.getId().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String getFirst() {
        try {
            AbstractControl abstractControl = (AbstractControl)this.children.get(0);
            return abstractControl.getPath();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    public ButtonGroup getBoxGroup() {
        if (this.group == null) {
            this.group = new ButtonGroup();
        }
        return this.group;
    }

    public void setModified() {
        super.setModified();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.setModified();
        }
    }

    public void setSensitive(int n) {
        super.setSensitive(n);
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.setModified();
        }
    }

    public int size() {
        return this.children.size();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean contains(Object object) {
        return this.children.contains(object);
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public Object[] toArray() {
        return this.children.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.children.toArray(objectArray);
    }

    public Container getContainerPeer() {
        return (Container)this.peer;
    }

    public boolean add(Object object) {
        AbstractControl abstractControl = (AbstractControl)object;
        Component component = abstractControl.getPeer();
        this.getContainerPeer().add(component, object);
        abstractControl.setFontReference(this.fontReference);
        this.setLayoutChanged();
        return this.children.add(object);
    }

    public boolean remove(Object object) {
        Component component = ((AbstractControl)object).getPeer();
        if (object instanceof AbstractControl) {
            this.childRemoveChain((AbstractControl)object);
        }
        if (this.getContainerPeer() != null && component != null) {
            this.getContainerPeer().remove(component);
        }
        this.setLayoutChanged();
        this.isModified = true;
        return this.children != null ? this.children.remove(object) : true;
    }

    public boolean containsAll(Collection collection) {
        return this.children.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.children.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.children.addAll(n, collection);
    }

    public boolean removeAll(Collection collection) {
        return this.children.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.children.retainAll(collection);
    }

    public void clear() {
        this.children.clear();
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        return this.children.get(n);
    }

    public Object set(int n, Object object) {
        return this.children.set(n, object);
    }

    public void add(int n, Object object) {
        this.children.add(n, object);
    }

    public Object remove(int n) {
        return this.children.remove(n);
    }

    public int indexOf(Object object) {
        return this.children.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.children.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.children.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.children.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.children.subList(n, n2);
    }

    public void onRenameChild(AbstractControl abstractControl, String string) {
    }

    protected void clearRootControl() {
        super.clearRootControl();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.clearRootControl();
        }
    }

    public void beforeUpdateUI() {
        super.beforeUpdateUI();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.beforeUpdateUI();
        }
    }

    public void afterUpdateUI() {
        super.afterUpdateUI();
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            abstractControl.afterUpdateUI();
        }
    }

    static {
        attributeList.put(TITLE_ATTR_NAME, new Integer(0));
        attributeList.put(BORDER_ATTR_NAME, new Integer(1));
        attributeList.put("file", new Integer(2));
        attributeList.put("hsb", new Integer(3));
        attributeList.put("vsb", new Integer(4));
        attributeList.put("cx", new Integer(5));
        attributeList.put("cy", new Integer(6));
    }
}

