/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Scaling;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JComponent;

public abstract class AbstractTextControl
extends AbstractControl {
    public static final String TEXT_ATTR_NAME = "text";
    protected String text = "";
    private static final int TEXT_ATTR_ID = 0;
    private static HashMap attributeList = new HashMap();

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
            this.text = null;
        }
    }

    protected void cloneAttributes(AbstractTextControl abstractTextControl) {
        super.cloneAttributes(abstractTextControl);
        abstractTextControl.setText(this.getText());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setText(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getText());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        super.eloq2swing(bl);
        this.eloq2swingText();
    }

    public void eloq2swingText() {
    }

    public int getWidth() {
        if (this.isWidthSet()) {
            return super.getWidth();
        }
        Scaling scaling = this.getScaling();
        Insets insets = ((JComponent)this.peer).getInsets();
        Dimension dimension = this.calcExtraSpace(scaling);
        int n = this.fontReference.getStringWidth(this, this.text) + insets.left + insets.right + dimension.width + 1;
        if (this.useRasterSize) {
            Dimension dimension2 = this.getLayoutGrid();
            return (int)Math.ceil((double)n / (double)dimension2.width);
        }
        return (int)Math.round((double)n / scaling.x);
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        if (this.isWidthSet()) {
            return false;
        }
        Insets insets = ((JComponent)this.peer).getInsets();
        Dimension dimension3 = this.calcExtraSpace(scaling);
        int n = this.fontReference.getStringWidth(this, this.text) + insets.left + insets.right + dimension3.width + 1;
        int n2 = this.getHeight();
        n2 = this.useRasterSize ? (n2 *= dimension2.height) : (int)Math.round((double)n2 * scaling.y);
        Dimension dimension4 = this.peer.getSize();
        if (dimension4.width != n || dimension4.height != n2) {
            this.peer.setSize(n, n2);
        }
        return true;
    }

    public void setText(String string) {
        this.text = string;
        this.isModified = true;
        if (!this.isWidthSet()) {
            this.setLayoutChanged();
        }
    }

    public String getText() {
        return this.text;
    }

    static {
        attributeList.put(TEXT_ATTR_NAME, new Integer(0));
    }
}

