/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.UnifiedData;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.sessions.Session;
import com.eloquence.services.tools.FontReference;
import com.eloquence.services.tools.RawPrinter;
import com.eloquence.services.tools.RawPrinterPipeLp;
import com.eloquence.services.tools.RawPrinterWin32;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class EApplication
extends EDialog {
    private RawPrinter printer = null;
    private static final String APPNAME_ATTR_NAME = "name";
    private String appName = null;
    private static final String ATOM_ATTR_NAME = "atom";
    private static final String ATOMS_ATTR_NAME = "atoms";
    private HashMap atomMap = null;
    private static final String STARTATOM_ATTR_NAME = "startatom";
    private static final String STARTATOMS_ATTR_NAME = "startatoms";
    private HashMap startAtomMap = null;
    public String defaultIcon = null;
    private static final String CLASS_ATTR_NAME = "Application";
    private static final String RETURN_LCASE_ATTR_NAME = "returnlcase";
    private boolean returnLcase_ID = false;
    private boolean returnLcase_CLASS = false;
    private boolean returnLcaseSet = false;
    private static final String BASEURL_ATTR_NAME = "baseurl";
    private String baseurl = "";
    private static final String HELPBASEURL_ATTR_NAME = "helpbaseurl";
    private String helpBaseUrl = "";
    private static final String BROWSER_ATTR_NAME = "browser";
    private static final String ACTIVE_ON_TOP_ATTR_NAME = "activeontop";
    private boolean activeOnTop = true;
    private static final String IPADDRESS_ATTR_NAME = "ipaddress";
    private static final String DNSNAME_ATTR_NAME = "dnsname";
    private static final String SERIAL_ATTR_NAME = "serial";
    private static int serialIdentifier = 0;
    private static final String ENABLE_REFERENCE_ATTR_NAME = "enablereference";
    private static final String REFERENCEPOINT_ATTR_NAME = "referencepoint";
    private boolean enableReference = false;
    private boolean enableReferenceSet = false;
    private static final String REFERENCEX_ATTR_NAME = "referencex";
    private static final String REFERENCEY_ATTR_NAME = "referencey";
    private Point refPoint = null;
    private static final String ENABLE_SCALEFACTOR_ATTR_NAME = "enablescalefactor";
    private static final String DIALOGSCALING_ATTR_NAME = "dialogscaling";
    private boolean enableScaleFactor = false;
    private boolean enableScaleFactorSet = false;
    private static final String SCALEFACTOR_ATTR_NAME = "scalefactor";
    private double sessionScale = 1.0;
    private boolean downscaleMessage = false;
    private boolean upscaleMessage = false;
    private static final String ENABLE_MAXIMIZE_ATTR_NAME = "enablemaximize";
    private boolean enableMaximize = false;
    private boolean enableMaximizeSet = false;
    private static final String MAXIMIZE_ATTR_NAME = "maximize";
    private boolean maximize = false;
    private static final String ENABLE_SNAP_ATTR_NAME = "enablesnap";
    private boolean enableSnap = false;
    private boolean enableSnapSet = false;
    private static final String SNAP_ADJUST_SIZE_ATTR_NAME = "snapadjustsize";
    private boolean snapAdjustSize = false;
    private boolean snapAdjustSizeSet = false;
    private static final String SNAP_ATTR_NAME = "snap";
    public static final int SNAP_LEFT_TOP = 1;
    public static final int SNAP_LEFT_BOTTOM = 2;
    public static final int SNAP_RIGHT_TOP = 4;
    public static final int SNAP_RIGHT_BOTTOM = 8;
    private int snap = 0;
    private static final String OPENPRINTER_ATTR_NAME = "openprinter";
    private static final String CLOSEPRINTER_ATTR_NAME = "closeprinter";
    private static final String PRINT_ATTR_NAME = "print";
    private static final String PRINTERNAME_ATTR_NAME = "printername";
    private static final String PRINTERLASTERROR_ATTR_NAME = "printerlasterror";
    private static final String PRINTERS_ATTR_NAME = "printers";
    private static final String KEEPALIVE_ATTR_NAME = "keepalive";
    private int keepalive = -1;
    private boolean keepaliveEnabled = false;
    private static final String CLIPBOARDCONTEXTMENU_ATTR_NAME = "clipboardcontextmenu";
    private String clipboardContextMenu = null;
    private static final String MOUSEMODKEYS_ATTR_NAME = "mousemodkeys";
    private static final String MOUSEBUTTON_ATTR_NAME = "mousebutton";
    private static final String MOUSECLICKCOUNT_ATTR_NAME = "mouseclickcount";
    private static final String DIALOG_W_OVERLAP_ATTR_NAME = "dialog_w_overlap";
    private int dialogWOverlap = 0;
    private boolean dialogWOverlapSet = false;
    private static final String DIALOG_H_OVERLAP_ATTR_NAME = "dialog_h_overlap";
    private int dialogHOverlap = 0;
    private boolean dialogHOverlapSet = false;
    private static final String DIALOG_SCROLL_ATTR_NAME = "dialog_scroll";
    private boolean dialogScroll = false;
    private boolean dialogScrollSet = false;
    private static final String LASTNOTIFY_ATTR_NAME = "lastnotify";
    private String lastNotify = null;
    private ControlsManager cmgr = null;
    private static HashMap attributeList = new HashMap();
    private static final int CLASS_ATTR_ID = 0;
    private static final int RETURN_LCASE_ATTR_ID = 1;
    private static final int BASEURL_ATTR_ID = 2;
    private static final int HELPBASEURL_ATTR_ID = 3;
    private static final int BROWSER_ATTR_ID = 4;
    private static final int ACTIVE_ON_TOP_ATTR_ID = 5;
    private static final int IPADDRESS_ATTR_ID = 6;
    private static final int DNSNAME_ATTR_ID = 7;
    private static final int SERIAL_ATTR_ID = 8;
    private static final int ENABLE_REFERENCE_ATTR_ID = 9;
    private static final int REFERENCEX_ATTR_ID = 10;
    private static final int REFERENCEY_ATTR_ID = 11;
    private static final int ENABLE_SCALEFACTOR_ATTR_ID = 12;
    private static final int SCALEFACTOR_ATTR_ID = 13;
    private static final int ENABLE_MAXIMIZE_ATTR_ID = 14;
    private static final int MAXIMIZE_ATTR_ID = 15;
    private static final int ENABLE_SNAP_ATTR_ID = 16;
    private static final int SNAP_ADJUST_SIZE_ATTR_ID = 17;
    private static final int SNAP_ATTR_ID = 18;
    private static final int OPENPRINTER_ATTR_ID = 19;
    private static final int CLOSEPRINTER_ATTR_ID = 20;
    private static final int PRINT_ATTR_ID = 21;
    private static final int PRINTERNAME_ATTR_ID = 22;
    private static final int PRINTERLASTERROR_ATTR_ID = 23;
    private static final int PRINTERS_ATTR_ID = 24;
    private static final int KEEPALIVE_ATTR_ID = 25;
    private static final int CLIPBOARDCONTEXTMENU_ATTR_ID = 26;
    private static final int MOUSEMODKEYS_ATTR_ID = 27;
    private static final int MOUSEBUTTON_ATTR_ID = 28;
    private static final int MOUSECLICKCOUNT_ATTR_ID = 29;
    private static final int ATOM_ATTR_ID = 30;
    private static final int ATOMS_ATTR_ID = 31;
    private static final int START_ATTR_ID = 32;
    private static final int STARTATOM_ATTR_ID = 33;
    private static final int STARTATOMS_ATTR_ID = 34;
    private static final int DIALOG_W_OVERLAP_ATTR_ID = 35;
    private static final int DIALOG_H_OVERLAP_ATTR_ID = 36;
    private static final int DIALOG_SCROLL_ATTR_ID = 37;
    private static final int APPNAME_ATTR_ID = 38;
    private static final int LASTNOTIFY_ATTR_ID = 39;

    public EApplication(String string) {
        this.setId("application");
        this.initializeOurFontAttributes();
        this.appName = string;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
            if (this.atomMap != null) {
                this.atomMap.clear();
                this.atomMap = null;
            }
            if (this.startAtomMap != null) {
                this.startAtomMap.clear();
                this.startAtomMap = null;
            }
            this.cmgr = null;
            this.printer = null;
            this.defaultIcon = null;
            this.baseurl = null;
            this.helpBaseUrl = null;
            this.refPoint = null;
            this.clipboardContextMenu = null;
        }
    }

    public Object clone() {
        return null;
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        if (dO != null) {
            if (this.cacheGeneration != dO.cacheGeneration) {
                this.cacheGeneration = dO.cacheGeneration;
                this.cacheId = 0;
            }
            dO.cache((AbstractControl)this, MOUSEMODKEYS_ATTR_NAME, 0, this.getMouseModKeys());
            dO.cache((AbstractControl)this, MOUSEBUTTON_ATTR_NAME, 0, this.getMouseButton());
            dO.cache((AbstractControl)this, MOUSECLICKCOUNT_ATTR_NAME, 0, this.getMouseClickCount());
        }
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 30: {
                        if (sET.v_type == 1) {
                            this.setAtom(sET.index, sET.getValueInt());
                            break;
                        }
                        this.setAtom(sET.index, sET.getValueString());
                        break;
                    }
                    case 4: {
                        this.setBrowser(sET.getValueString());
                        break;
                    }
                    case 32: {
                        this.setStart(sET.getValueString());
                        break;
                    }
                    case 33: {
                        if (sET.v_type == 1) {
                            this.setStartAtom(sET.index, sET.getValueInt());
                            break;
                        }
                        this.setStartAtom(sET.index, sET.getValueString());
                        break;
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 1: {
                    this.setReturnLcase(sET.getValueInt());
                    break;
                }
                case 2: {
                    this.setBaseurl(sET.getValueString());
                    break;
                }
                case 3: {
                    this.setHelpBaseUrl(sET.getValueString());
                    break;
                }
                case 4: {
                    this.setBrowser(sET.getValueString());
                    break;
                }
                case 5: {
                    this.setActiveOnTop(sET.getValueInt());
                    break;
                }
                case 8: {
                    this.setSerial(sET.getValueInt());
                    break;
                }
                case 9: {
                    this.setEnableReference(sET.getValueInt());
                    break;
                }
                case 10: {
                    this.setReferenceX(sET.getValueInt());
                    break;
                }
                case 11: {
                    this.setReferenceY(sET.getValueInt());
                    break;
                }
                case 12: {
                    this.setEnableScaleFactor(sET.getValueInt());
                    break;
                }
                case 13: {
                    if (sET.v_type == 1) {
                        this.setSessionScale(sET.getValueInt());
                        break;
                    }
                    this.setSessionScale(sET.getValueString());
                    break;
                }
                case 14: {
                    this.setEnableMaximize(sET.getValueInt());
                    break;
                }
                case 15: {
                    this.setMaximize(sET.getValueInt());
                    break;
                }
                case 16: {
                    this.setEnableSnap(sET.getValueInt());
                    break;
                }
                case 17: {
                    this.setSnapAdjustSize(sET.getValueInt());
                    break;
                }
                case 18: {
                    this.setSnap(sET.getValueInt());
                    break;
                }
                case 19: {
                    return this.setOpenPrinter(sET.getValueString());
                }
                case 20: {
                    return this.setClosePrinter();
                }
                case 22: {
                    this.setPrinterName(sET.getValueString());
                    break;
                }
                case 21: {
                    return this.setPrint(sET);
                }
                case 25: {
                    this.setKeepalive(sET.getValueInt());
                    break;
                }
                case 26: {
                    this.setClipboardContextMenu(sET.getValueString());
                    break;
                }
                case 35: {
                    this.setDialogWOverlap(sET.getValueInt());
                    break;
                }
                case 36: {
                    this.setDialogHOverlap(sET.getValueInt());
                    break;
                }
                case 37: {
                    this.setDialogScroll(sET.getValueInt());
                    break;
                }
                case 32: {
                    this.setStart(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 30: {
                        UnifiedData unifiedData = this.getAtom(gET.index);
                        if (unifiedData.isStringData()) {
                            gET2.setValueString(unifiedData.getStringData());
                            break;
                        }
                        gET2.setValueInt(unifiedData.getIntData());
                        break;
                    }
                    case 33: {
                        UnifiedData unifiedData = this.getStartAtom(gET.index);
                        if (unifiedData.isStringData()) {
                            gET2.setValueString(unifiedData.getStringData());
                            break;
                        }
                        gET2.setValueInt(unifiedData.getIntData());
                        break;
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 31: {
                    gET2.setValueString(this.getAtoms());
                    break;
                }
                case 34: {
                    gET2.setValueString(this.getStartAtoms());
                    break;
                }
                case 38: {
                    gET2.setValueString(this.getAppName());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getReturnLcase());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getBaseurl());
                    break;
                }
                case 3: {
                    gET2.setValueString(this.getHelpBaseUrl());
                    break;
                }
                case 5: {
                    gET2.setValueInt(this.getActiveOnTop());
                    break;
                }
                case 6: {
                    gET2.setValueString(this.getIPAddress());
                    break;
                }
                case 7: {
                    gET2.setValueString(this.getDNSName());
                    break;
                }
                case 8: {
                    gET2.setValueInt(this.getSerial());
                    break;
                }
                case 9: {
                    gET2.setValueInt(this.getEnableReferenceAttr());
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getReferenceX());
                    break;
                }
                case 11: {
                    gET2.setValueInt(this.getReferenceY());
                    break;
                }
                case 12: {
                    gET2.setValueInt(this.getEnableScaleFactorAttr());
                    break;
                }
                case 13: {
                    gET2.setValueInt(this.getSessionScale());
                    break;
                }
                case 14: {
                    gET2.setValueInt(this.getEnableMaximizeAttr());
                    break;
                }
                case 15: {
                    gET2.setValueInt(this.getMaximizeAttr());
                    break;
                }
                case 16: {
                    gET2.setValueInt(this.getEnableSnapAttr());
                    break;
                }
                case 17: {
                    gET2.setValueInt(this.getSnapAdjustSizeAttr());
                    break;
                }
                case 18: {
                    gET2.setValueInt(this.getSnap());
                    break;
                }
                case 22: {
                    gET2.setValueString(this.getPrinterName());
                    break;
                }
                case 23: {
                    gET2.setValueString(this.getPrinterLastError());
                    break;
                }
                case 24: {
                    gET2.setValueString(this.getPrinters());
                    break;
                }
                case 25: {
                    gET2.setValueInt(this.getKeepalive());
                    break;
                }
                case 26: {
                    gET2.setValueString(this.getClipboardContextMenu());
                    break;
                }
                case 27: {
                    gET2.setValueInt(this.getMouseModKeys());
                    break;
                }
                case 28: {
                    gET2.setValueInt(this.getMouseButton());
                    break;
                }
                case 29: {
                    gET2.setValueInt(this.getMouseClickCount());
                    break;
                }
                case 35: {
                    gET2.setValueInt(this.getDialogWOverlap());
                    break;
                }
                case 36: {
                    gET2.setValueInt(this.getDialogHOverlap());
                    break;
                }
                case 37: {
                    gET2.setValueInt(this.getDialogScroll());
                    break;
                }
                case 39: {
                    gET2.setValueString(this.getLastNotify());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
    }

    private void initializeOurFontAttributes() {
        this.fontface = StartUp.getDefaultFont().getName();
        this.fontsize = StartUp.getDefaultFont().getSize();
        this.fontstyle = FontReference.styleName(StartUp.getDefaultFont().getStyle());
    }

    private void initPrinter() {
        this.printer = StartUp.running_on_windows ? new RawPrinterWin32() : new RawPrinterPipeLp();
    }

    public void executeHelpRequest(String string, boolean bl) {
        String string2 = null;
        if (!bl) {
            string2 = this.getHelpBaseUrl() + string;
            if (!AbstractControl.isAbsoluteURL(string2)) {
                string2 = ESystem.getObject().getHelpBaseURL() + string2;
            }
        } else {
            string2 = string;
        }
        ESystem.getObject().executeBrowserRequest(string2);
    }

    public void executeHelpRequest() {
        throw new IllegalAccessError("EApplication.executeHelpRequest()");
    }

    private String getAppName() {
        return this.appName != null ? this.appName : "";
    }

    private void setAtom(String string, String string2) {
        if (string2.length() != 0) {
            if (this.atomMap == null) {
                this.atomMap = new HashMap();
            }
            this.atomMap.put(string, new UnifiedData(string2));
        } else if (this.atomMap != null) {
            this.atomMap.remove(string);
            if (this.atomMap.isEmpty()) {
                this.atomMap = null;
            }
        }
    }

    private void setAtom(String string, int n) {
        if (this.atomMap == null) {
            this.atomMap = new HashMap();
        }
        this.atomMap.put(string, new UnifiedData(n));
    }

    private UnifiedData getAtom(String string) {
        Object var2_2 = this.atomMap != null ? this.atomMap.get(string) : null;
        return var2_2 != null ? (UnifiedData)var2_2 : new UnifiedData("");
    }

    public void setAtomMap(HashMap hashMap) {
        if (this.atomMap == null) {
            this.atomMap = new HashMap();
        } else {
            this.atomMap.clear();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            UnifiedData unifiedData = (UnifiedData)entry.getValue();
            this.atomMap.put(entry.getKey(), unifiedData.isStringData() ? new UnifiedData(unifiedData.getStringData()) : new UnifiedData(unifiedData.getIntData()));
        }
    }

    private String getAtoms() {
        Set set;
        StringBuilder stringBuilder = new StringBuilder();
        Set set2 = set = this.atomMap != null ? this.atomMap.keySet() : null;
        if (set != null && set.size() != 0) {
            ArrayList arrayList = new ArrayList(set);
            Collections.sort(arrayList);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append((String)listIterator.next());
            }
        }
        return stringBuilder.toString();
    }

    private static HashMap cloneAtoms(HashMap hashMap) {
        if (hashMap != null && hashMap.size() != 0) {
            HashMap hashMap2 = new HashMap();
            for (Map.Entry entry : hashMap.entrySet()) {
                UnifiedData unifiedData = (UnifiedData)entry.getValue();
                hashMap2.put(entry.getKey(), unifiedData.isStringData() ? new UnifiedData(unifiedData.getStringData()) : new UnifiedData(unifiedData.getIntData()));
            }
            return hashMap2;
        }
        return null;
    }

    private int setStart(String string) {
        HashMap hashMap = EApplication.cloneAtoms(this.startAtomMap);
        return Session.startByKey(string, hashMap) ? 0 : 11;
    }

    private void setStartAtom(String string, String string2) {
        if (string2.length() != 0) {
            if (this.startAtomMap == null) {
                this.startAtomMap = new HashMap();
            }
            this.startAtomMap.put(string, new UnifiedData(string2));
        } else if (this.startAtomMap != null) {
            this.startAtomMap.remove(string);
            if (this.startAtomMap.isEmpty()) {
                this.startAtomMap = null;
            }
        }
    }

    private void setStartAtom(String string, int n) {
        if (this.startAtomMap == null) {
            this.startAtomMap = new HashMap();
        }
        this.startAtomMap.put(string, new UnifiedData(n));
    }

    private UnifiedData getStartAtom(String string) {
        Object var2_2 = this.startAtomMap != null ? this.startAtomMap.get(string) : null;
        return var2_2 != null ? (UnifiedData)var2_2 : new UnifiedData("");
    }

    private String getStartAtoms() {
        Set set;
        StringBuilder stringBuilder = new StringBuilder();
        Set set2 = set = this.startAtomMap != null ? this.startAtomMap.keySet() : null;
        if (set != null && set.size() != 0) {
            ArrayList arrayList = new ArrayList(set);
            Collections.sort(arrayList);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append((String)listIterator.next());
            }
        }
        return stringBuilder.toString();
    }

    public void setLogoicon(String string) {
        this.defaultIcon = string.length() > 0 ? string : null;
    }

    public String getLogoicon() {
        if (this.defaultIcon != null) {
            return this.defaultIcon;
        }
        return super.getLogoicon();
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    private void setReturnLcase(int n) {
        this.returnLcase_ID = (n & 1) != 0;
        this.returnLcase_CLASS = (n & 2) != 0;
        this.returnLcaseSet = true;
    }

    private int getReturnLcase() {
        if (!this.returnLcaseSet) {
            this.setReturnLcase(ESystem.getObject().getReturnLcase());
        }
        return (this.returnLcase_ID ? 1 : 0) | (this.returnLcase_CLASS ? 2 : 0);
    }

    public String return_ID(String string) {
        if (!this.returnLcaseSet) {
            this.setReturnLcase(ESystem.getObject().getReturnLcase());
        }
        return string != null && this.returnLcase_ID ? string.toLowerCase() : string;
    }

    public String return_CLASS(String string) {
        if (!this.returnLcaseSet) {
            this.setReturnLcase(ESystem.getObject().getReturnLcase());
        }
        return string != null && this.returnLcase_CLASS ? string.toLowerCase() : string;
    }

    public void setBaseurl(String string) {
        this.baseurl = string;
    }

    public String getBaseurl() {
        if (AbstractControl.isAbsoluteURL(this.baseurl)) {
            if (this.baseurl != null) {
                return this.baseurl;
            }
            return "";
        }
        return ESystem.getObject().getBaseURL() + this.baseurl;
    }

    private void setHelpBaseUrl(String string) {
        this.helpBaseUrl = string;
    }

    private String getHelpBaseUrl() {
        return this.helpBaseUrl;
    }

    private void setBrowser(String string) {
        String string2 = null;
        if (!AbstractControl.isAbsoluteURL(string)) {
            string2 = this.baseurl + string;
            if (!AbstractControl.isAbsoluteURL(string2)) {
                string2 = ESystem.getObject().getBaseURL() + string2;
            }
        } else {
            string2 = string;
        }
        ESystem.getObject().executeBrowserRequest(string2);
    }

    private void setActiveOnTop(int n) {
        this.activeOnTop = n != 0;
    }

    private int getActiveOnTop() {
        return this.activeOnTop ? 1 : 0;
    }

    private String getIPAddress() {
        return this.cmgr.getSession().getLocalHostAddress();
    }

    private String getDNSName() {
        return this.cmgr.getSession().getLocalHostName();
    }

    private void setSerial(int n) {
        if (n > serialIdentifier) {
            serialIdentifier = n;
        }
    }

    private int getSerial() {
        return serialIdentifier++;
    }

    public EApplication getEApplication() {
        return this;
    }

    private void setEnableReference(int n) {
        this.enableReference = n != 0;
        this.enableReferenceSet = true;
    }

    public boolean getEnableReference() {
        if (!this.enableReferenceSet) {
            this.enableReference = ESystem.getObject().getEnableReference();
            this.enableReferenceSet = true;
        }
        return this.enableReference;
    }

    private int getEnableReferenceAttr() {
        return this.getEnableReference() ? 1 : 0;
    }

    private void setReferenceX(int n) {
        if (this.refPoint == null) {
            this.refPoint = new Point(n, 0);
        } else {
            this.refPoint.x = n;
        }
    }

    private int getReferenceX() {
        return this.refPoint != null ? this.refPoint.x : 0;
    }

    private void setReferenceY(int n) {
        if (this.refPoint == null) {
            this.refPoint = new Point(0, n);
        } else {
            this.refPoint.y = n;
        }
    }

    private int getReferenceY() {
        return this.refPoint != null ? this.refPoint.y : 0;
    }

    public void setSessionRefPoint(Point point) {
        if (this.refPoint == null) {
            this.refPoint = new Point(point);
        } else {
            this.refPoint.x = point.x;
            this.refPoint.y = point.y;
        }
    }

    public Point getSessionRefPoint() {
        if (this.refPoint == null) {
            this.refPoint = new Point(0, 0);
        }
        return this.refPoint;
    }

    public boolean useSessionRefPoint() {
        return this.getEnableReference();
    }

    private void setEnableScaleFactor(int n) {
        this.enableScaleFactor = n != 0;
        this.enableScaleFactorSet = true;
    }

    public boolean getEnableScaleFactor() {
        if (!this.enableScaleFactorSet) {
            this.enableScaleFactor = ESystem.getObject().getEnableScaleFactor();
            this.enableScaleFactorSet = true;
        }
        return this.enableScaleFactor;
    }

    private int getEnableScaleFactorAttr() {
        return this.getEnableScaleFactor() ? 1 : 0;
    }

    private double validateSessionScale(double d) {
        if (d < 0.1) {
            if (!this.upscaleMessage) {
                this.upscaleMessage = true;
                System.err.println("Window scale factor below 10% - corrected");
            }
            d = 0.1;
        }
        if (d > 10.0) {
            if (!this.downscaleMessage) {
                this.downscaleMessage = true;
                System.err.println("Window scale factor above 1000% - corrected");
            }
            d = 10.0;
        }
        return d;
    }

    private void setSessionScale(String string) {
        this.sessionScale = this.validateSessionScale(new Double(string));
    }

    private void setSessionScale(int n) {
        this.sessionScale = this.validateSessionScale(new Double(n) / 100.0);
    }

    private int getSessionScale() {
        return (int)Math.round(this.sessionScale * 100.0);
    }

    public void setSessionScaleFactor(double d) {
        this.sessionScale = d;
    }

    public double getSessionScaleFactor() {
        return this.getEnableScaleFactor() ? this.sessionScale : 1.0;
    }

    private void setEnableMaximize(int n) {
        this.enableMaximize = n != 0;
        this.enableMaximizeSet = true;
    }

    public boolean getEnableMaximize() {
        if (!this.enableMaximizeSet) {
            this.enableMaximize = ESystem.getObject().getEnableMaximize();
            this.enableMaximizeSet = true;
        }
        return this.enableMaximize;
    }

    private int getEnableMaximizeAttr() {
        return this.getEnableMaximize() ? 1 : 0;
    }

    public void setMaximize(boolean bl) {
        this.maximize = bl;
    }

    private void setMaximize(int n) {
        this.maximize = n != 0;
    }

    public boolean getMaximize() {
        return this.maximize;
    }

    private int getMaximizeAttr() {
        return this.maximize ? 1 : 0;
    }

    private void setEnableSnap(int n) {
        this.enableSnap = n != 0;
        this.enableSnapSet = true;
    }

    public boolean getEnableSnap() {
        if (!this.enableSnapSet) {
            this.enableSnap = ESystem.getObject().getEnableSnap();
            this.enableSnapSet = true;
        }
        return this.enableSnap;
    }

    private int getEnableSnapAttr() {
        return this.getEnableSnap() ? 1 : 0;
    }

    private void setSnapAdjustSize(int n) {
        this.snapAdjustSize = n != 0;
        this.snapAdjustSizeSet = true;
    }

    public boolean getSnapAdjustSize() {
        if (!this.snapAdjustSizeSet) {
            this.snapAdjustSize = ESystem.getObject().getSnapAdjustSize();
            this.snapAdjustSizeSet = true;
        }
        return this.snapAdjustSize;
    }

    private int getSnapAdjustSizeAttr() {
        return this.getSnapAdjustSize() ? 1 : 0;
    }

    public void setSnap(int n) {
        this.snap = n;
    }

    public int getSnap() {
        return this.snap;
    }

    private int setOpenPrinter(String string) {
        if (this.printer == null) {
            this.initPrinter();
        }
        if (!this.printer.open(string)) {
            return 11;
        }
        return 0;
    }

    private int setClosePrinter() {
        if (this.printer == null) {
            this.initPrinter();
        }
        if (!this.printer.close()) {
            return 11;
        }
        return 0;
    }

    private int setPrint(Dlg.Rq.SET sET) {
        if (this.printer == null) {
            this.initPrinter();
        }
        if (sET.v_type == 3 && this.printer.print(sET.v_bv, sET.v_bv_off, sET.v_bv_len)) {
            return 0;
        }
        return 11;
    }

    private String getPrinterName() {
        if (this.printer == null) {
            this.initPrinter();
        }
        return this.printer.printerName();
    }

    private void setPrinterName(String string) {
        if (this.printer == null) {
            this.initPrinter();
        }
        this.printer.setPrinterName(string);
    }

    private String getPrinterLastError() {
        if (this.printer == null) {
            this.initPrinter();
        }
        return this.printer.lastError();
    }

    private String getPrinters() {
        if (this.printer == null) {
            this.initPrinter();
        }
        return this.printer.printers();
    }

    private void setKeepalive(int n) {
        this.keepalive = n > 0 ? n : 0;
    }

    private int getKeepalive() {
        this.keepaliveEnabled = true;
        return this.getKeepaliveSub();
    }

    private int getKeepaliveSub() {
        if (this.keepalive >= 0) {
            return this.keepalive;
        }
        return ESystem.getObject().getKeepalive();
    }

    public int getKeepaliveInternal() {
        if (!this.keepaliveEnabled) {
            return 0;
        }
        return this.getKeepaliveSub();
    }

    public void setClipboardContextMenu(String string) {
        this.clipboardContextMenu = string;
    }

    public String getClipboardContextMenu() {
        if (this.clipboardContextMenu != null) {
            return this.clipboardContextMenu;
        }
        return ESystem.getObject().getClipboardContextMenu();
    }

    private int getMouseModKeys() {
        int n = this.cmgr.getMouseEventModifiers();
        int n2 = 0;
        if ((n & 0x40) != 0) {
            n2 |= 1;
        }
        if ((n & 0x80) != 0) {
            n2 |= 2;
        }
        if ((n & 0x100) != 0) {
            n2 |= 4;
        }
        if ((n & 0x200) != 0) {
            n2 |= 8;
        }
        if ((n & 0x2000) != 0) {
            n2 |= 0x10;
        }
        return n2;
    }

    private int getMouseButton() {
        return this.cmgr.getMouseEventButton();
    }

    private int getMouseClickCount() {
        return this.cmgr.getMouseEventClickCount();
    }

    private void setDialogWOverlap(int n) {
        this.dialogWOverlap = n;
        this.dialogWOverlapSet = true;
    }

    public int getDialogWOverlap() {
        if (this.dialogWOverlapSet) {
            return this.dialogWOverlap;
        }
        return ESystem.getObject().getDialogWOverlap();
    }

    private void setDialogHOverlap(int n) {
        this.dialogHOverlap = n;
        this.dialogHOverlapSet = true;
    }

    public int getDialogHOverlap() {
        if (this.dialogHOverlapSet) {
            return this.dialogHOverlap;
        }
        return ESystem.getObject().getDialogHOverlap();
    }

    private void setDialogScroll(int n) {
        this.dialogScroll = n != 0;
        this.dialogScrollSet = true;
    }

    private int getDialogScroll() {
        return this.dialogScroll() ? 1 : 0;
    }

    public boolean dialogScroll() {
        if (this.dialogScrollSet) {
            return this.dialogScroll;
        }
        return ESystem.getObject().dialogScroll();
    }

    private String getLastNotify() {
        return this.lastNotify != null ? this.lastNotify : "";
    }

    public void setLastNotify(String string) {
        this.lastNotify = string;
    }

    public void setControlsManager(ControlsManager controlsManager) {
        this.cmgr = controlsManager;
    }

    static {
        attributeList.put(CLASS_ATTR_NAME, new Integer(0));
        attributeList.put(RETURN_LCASE_ATTR_NAME, new Integer(1));
        attributeList.put(BASEURL_ATTR_NAME, new Integer(2));
        attributeList.put(HELPBASEURL_ATTR_NAME, new Integer(3));
        attributeList.put(BROWSER_ATTR_NAME, new Integer(4));
        attributeList.put(ACTIVE_ON_TOP_ATTR_NAME, new Integer(5));
        attributeList.put(IPADDRESS_ATTR_NAME, new Integer(6));
        attributeList.put(DNSNAME_ATTR_NAME, new Integer(7));
        attributeList.put(SERIAL_ATTR_NAME, new Integer(8));
        attributeList.put(ENABLE_REFERENCE_ATTR_NAME, new Integer(9));
        attributeList.put(REFERENCEPOINT_ATTR_NAME, new Integer(9));
        attributeList.put(REFERENCEX_ATTR_NAME, new Integer(10));
        attributeList.put(REFERENCEY_ATTR_NAME, new Integer(11));
        attributeList.put(ENABLE_SCALEFACTOR_ATTR_NAME, new Integer(12));
        attributeList.put(DIALOGSCALING_ATTR_NAME, new Integer(12));
        attributeList.put(SCALEFACTOR_ATTR_NAME, new Integer(13));
        attributeList.put(ENABLE_MAXIMIZE_ATTR_NAME, new Integer(14));
        attributeList.put(MAXIMIZE_ATTR_NAME, new Integer(15));
        attributeList.put(ENABLE_SNAP_ATTR_NAME, new Integer(16));
        attributeList.put(SNAP_ADJUST_SIZE_ATTR_NAME, new Integer(17));
        attributeList.put(SNAP_ATTR_NAME, new Integer(18));
        attributeList.put(OPENPRINTER_ATTR_NAME, new Integer(19));
        attributeList.put(CLOSEPRINTER_ATTR_NAME, new Integer(20));
        attributeList.put(PRINT_ATTR_NAME, new Integer(21));
        attributeList.put(PRINTERNAME_ATTR_NAME, new Integer(22));
        attributeList.put(PRINTERLASTERROR_ATTR_NAME, new Integer(23));
        attributeList.put(PRINTERS_ATTR_NAME, new Integer(24));
        attributeList.put(KEEPALIVE_ATTR_NAME, new Integer(25));
        attributeList.put(CLIPBOARDCONTEXTMENU_ATTR_NAME, new Integer(26));
        attributeList.put(MOUSEMODKEYS_ATTR_NAME, new Integer(27));
        attributeList.put(MOUSEBUTTON_ATTR_NAME, new Integer(28));
        attributeList.put(MOUSECLICKCOUNT_ATTR_NAME, new Integer(29));
        attributeList.put(ATOM_ATTR_NAME, new Integer(30));
        attributeList.put(ATOMS_ATTR_NAME, new Integer(31));
        attributeList.put("start", new Integer(32));
        attributeList.put(STARTATOM_ATTR_NAME, new Integer(33));
        attributeList.put(STARTATOMS_ATTR_NAME, new Integer(34));
        attributeList.put(DIALOG_W_OVERLAP_ATTR_NAME, new Integer(35));
        attributeList.put(DIALOG_H_OVERLAP_ATTR_NAME, new Integer(36));
        attributeList.put(DIALOG_SCROLL_ATTR_NAME, new Integer(37));
        attributeList.put(APPNAME_ATTR_NAME, new Integer(38));
        attributeList.put(LASTNOTIFY_ATTR_NAME, new Integer(39));
    }
}

