/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractCheckButton;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class ECheckBox
extends AbstractCheckButton
implements ItemListener {
    private boolean itemToggled = false;
    public static final String CLASS_ATTR_NAME = "CheckBox";

    public ECheckBox() {
        EJCheckBox eJCheckBox = new EJCheckBox();
        eJCheckBox.addItemListener(this);
        eJCheckBox.addActionListener(this);
        eJCheckBox.addKeyListener(this);
        eJCheckBox.setOpaque(false);
        eJCheckBox.setFont(StartUp.getDefaultFont());
        eJCheckBox.setFocusTraversalKeysEnabled(false);
        this.peer = eJCheckBox;
        this.setSensitive(1);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            EJCheckBox eJCheckBox = (EJCheckBox)this.peer;
            eJCheckBox.removeItemListener(this);
            eJCheckBox.removeKeyListener(this);
            eJCheckBox.removeMouseListener(this);
            super.dispose();
        }
    }

    public Object clone() {
        ECheckBox eCheckBox = new ECheckBox();
        this.cloneAttributes(eCheckBox);
        return eCheckBox;
    }

    public void eloq2swingText() {
        EJCheckBox eJCheckBox = (EJCheckBox)this.peer;
        if (!this.text.equals(eJCheckBox.getText())) {
            try {
                eJCheckBox.setText(this.text);
            }
            catch (Throwable throwable) {
                System.err.println("'" + this.getPath() + "' " + throwable + ": CheckBox = \"" + this.text + "\"");
                eJCheckBox.setText(HtmlTool.text(this.text));
            }
        }
        eJCheckBox.setOpaque(this.bgc != null);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.itemToggled = true;
    }

    public Dimension calcExtraSpace(Scaling scaling) {
        return this.initExtraSpace(17, 0);
    }

    public boolean fireButtonRule() {
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (ruleManager.getFocus() != this) {
            if (this.isFocusable(false)) {
                ruleManager.prepareOverride(this);
                ruleManager.requestFocus(this);
            } else if (this.ruleOverride) {
                ruleManager.forceOverride();
            }
        }
        if (!this.itemToggled) {
            EJCheckBox eJCheckBox;
            eJCheckBox.setSelected(!(eJCheckBox = (EJCheckBox)this.peer).isSelected());
        }
        this.itemToggled = false;
        if (this.getRule() != 0) {
            ruleManager.fireRule(this);
            return true;
        }
        ruleManager.cancelOverride();
        return false;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setActive(int n) {
        super.setActive(n);
        ((EJCheckBox)this.peer).setSelected(n != 0);
        this.itemToggled = false;
    }

    public boolean isActive() {
        return ((EJCheckBox)this.peer).isSelected();
    }

    class EJCheckBox
    extends JCheckBox {
        EJCheckBox() {
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!ECheckBox.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

