/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.DragDropHandler;
import com.eloquence.api.EqTextArea;
import com.eloquence.api.EqTextField;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.jdlg.controls.EJScrollPane;
import com.eloquence.services.jdlg.controls.EJScrollPaneListener;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.jdlg.controls.TextComponentClipboardManager;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.FontReference;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class EEditText
extends AbstractControl
implements DocumentListener,
CaretListener,
ActionListener,
EJScrollPaneListener {
    private EJScrollPane scrollPane = null;
    private TextComponentClipboardManager clipboardManager = null;
    private boolean mouseDown = false;
    private static int layoutEditExpandWidth = -1;
    private static final int SCROLLBARVISIBLE_TIMEOUT = 5;
    private Timer horizontalScrollBarVisibleTimer = null;
    private Timer verticalScrollBarVisibleTimer = null;
    public static final String CLASS_ATTR_NAME = "EditText";
    private static final String CONTENT_ATTR_NAME = "content";
    private static final String LINE_BUF_ATTR_NAME = "line_buf";
    private String content = "";
    private boolean contentSet = false;
    private boolean contentCached = false;
    private boolean contentModified = false;
    private Point tmpPos = null;
    private boolean ignoreDocumentUpdate = false;
    private static final String LENGTH_ATTR_NAME = "length";
    private static final String EDITABLE_ATTR_NAME = "editable";
    private boolean editable = true;
    private static final String MULTILINE_ATTR_NAME = "multiline";
    private boolean multiline = false;
    private static final String BORDER_ATTR_NAME = "border";
    private static final String ALIGN_ATTR_NAME = "align";
    private static final String LEFT_STR = "left";
    private static final String CENTER_STR = "center";
    private static final String RIGHT_STR = "right";
    private int align = 2;
    private static final String MAXCHARS_ATTR_NAME = "maxchars";
    private int maxchars = 0;
    private static final String MAXLINES_ATTR_NAME = "maxlines";
    private int maxlines = 0;
    private static final String VHEIGHT_ATTR_NAME = "vheight";
    private static final String VWIDTH_ATTR_NAME = "vwidth";
    private static final String CX_ATTR_NAME = "cx";
    private static final String CY_ATTR_NAME = "cy";
    private int cx = 0;
    private int cy = 0;
    private boolean caretModified = false;
    private static final String LINE_ATTR_NAME = "line";
    private static final String CLEAR_ATTR_NAME = "clear";
    private static final String ADD_ATTR_NAME = "add";
    private static final String INS_ATTR_NAME = "ins";
    private static final String DELLN_ATTR_NAME = "delln";
    private static final String ISPASSWORD_ATTR_NAME = "ispassword";
    private boolean passwordField = false;
    private static final String FITFONT_ATTR_NAME = "fitfont";
    private int fitFont = 0;
    private static final String LINEWRAP_ATTR_NAME = "linewrap";
    private static final String LINEWRAP_NONE_STR = "none";
    private static final String LINEWRAP_SOFT_STR = "soft";
    private static final String LINEWRAP_HARD_STR = "hard";
    private static final int LINEWRAP_NONE = 0;
    private static final int LINEWRAP_SOFT = 1;
    private static final int LINEWRAP_HARD = 2;
    private int lineWrap = 0;
    private boolean lineWrapHard = false;
    private static final String WRAPMODE_ATTR_NAME = "wrapmode";
    private static final String WRAPMODE_WORD_STR = "word";
    private static final String WRAPMODE_CHAR_STR = "char";
    private static final int WRAPMODE_WORD = 0;
    private static final int WRAPMODE_CHAR = 1;
    private int wrapMode = 0;
    private static final String AUTOTAB_ATTR_NAME = "autotab";
    private static final int AUTOTAB_FORWARD = 1;
    private static final int AUTOTAB_BACKWARD = 2;
    private static final int AUTOTAB_IGNORE_RULE = 4;
    private int autoTabMode = 0;
    private boolean autoTabIgnoreRule = false;
    private static final int AUTOTAB_TIMEOUT = 20;
    private Timer autoTabTimer = null;
    private int autoTabScheduledMode = 0;
    private static final String TC_RULE_ATTR_NAME = "tcrule";
    private static final String TC_DELAY_ATTR_NAME = "tcdelay";
    private static final String TC_MINCHARS_ATTR_NAME = "tcminchars";
    private int textChangedRule = 0;
    private int textChangedDelay = 500;
    private int textChangedMinChars = 1;
    private boolean textChangedHasTimer = false;
    private static final String TITLE_ATTR_NAME = "title";
    private static final String HSB_ATTR_NAME = "hsb";
    private static final String VSB_ATTR_NAME = "vsb";
    private static final String DRAG_CONTENT_ATTR_NAME = "dragcontent";
    private static final String DROP_CX_ATTR_NAME = "dropcx";
    private static final String DROP_CY_ATTR_NAME = "dropcy";
    private String dragContent = null;
    private int dropCx = -1;
    private int dropCy = -1;
    private int dragSaveSelectionStart = 0;
    private int dragSaveSelectionEnd = 0;
    private static final int LENGTH_ATTR_ID = 0;
    private static final int CONTENT_ATTR_ID = 1;
    private static final int LINE_ATTR_ID = 2;
    private static final int EDITABLE_ATTR_ID = 3;
    private static final int MULTILINE_ATTR_ID = 4;
    private static final int BORDER_ATTR_ID = 5;
    private static final int TITLE_ATTR_ID = 6;
    private static final int HSB_ATTR_ID = 7;
    private static final int VSB_ATTR_ID = 8;
    private static final int MAXCHARS_ATTR_ID = 9;
    private static final int MAXLINES_ATTR_ID = 10;
    private static final int VHEIGHT_ATTR_ID = 11;
    private static final int VWIDTH_ATTR_ID = 12;
    private static final int CX_ATTR_ID = 13;
    private static final int CY_ATTR_ID = 14;
    private static final int CLEAR_ATTR_ID = 15;
    private static final int ADD_ATTR_ID = 16;
    private static final int INS_ATTR_ID = 17;
    private static final int DELLN_ATTR_ID = 18;
    private static final int ISPASSWORD_ATTR_ID = 19;
    private static final int ALIGN_ATTR_ID = 20;
    private static final int FITFONT_ATTR_ID = 21;
    private static final int LINEWRAP_ATTR_ID = 22;
    private static final int WRAPMODE_ATTR_ID = 23;
    private static final int AUTOTAB_ATTR_ID = 24;
    private static final int DRAG_CONTENT_ATTR_ID = 25;
    private static final int DROP_CX_ATTR_ID = 26;
    private static final int DROP_CY_ATTR_ID = 27;
    private static final int TC_RULE_ATTR_ID = 28;
    private static final int TC_DELAY_ATTR_ID = 29;
    private static final int TC_MINCHARS_ATTR_ID = 30;
    private static HashMap attributeList = new HashMap();

    public EEditText() {
        EJTextField eJTextField = this.createEJTextField();
        eJTextField.setFont(StartUp.getDefaultFont());
        this.peer = eJTextField;
        this.setSensitive(1);
        this.bgc = Color.white;
        this.clipboardManager = new TextComponentClipboardManager(eJTextField);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.disposePeer();
            super.dispose();
            this.content = null;
            this.clipboardManager = null;
            this.horizontalScrollBarVisibleTimer = null;
            this.verticalScrollBarVisibleTimer = null;
            this.autoTabTimer = null;
            this.dragContent = null;
        }
    }

    private void disposePeer() {
        if (this.peer instanceof JTextField) {
            JTextField jTextField = (JTextField)this.peer;
            EPlainDocument ePlainDocument = (EPlainDocument)jTextField.getDocument();
            jTextField.removeKeyListener(this);
            jTextField.removeMouseListener(this);
            jTextField.removeCaretListener(this);
            ePlainDocument.removeDocumentListener(this);
        } else if (this.peer instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)this.peer;
            EPlainDocument ePlainDocument = (EPlainDocument)jTextArea.getDocument();
            jTextArea.removeKeyListener(this);
            jTextArea.removeMouseListener(this);
            jTextArea.removeCaretListener(this);
            ePlainDocument.removeDocumentListener(this);
        }
        if (this.scrollPane != null) {
            this.scrollPane.setControl(null);
            this.scrollPane = null;
        }
    }

    public Object clone() {
        EEditText eEditText = new EEditText();
        this.cloneAttributes(eEditText);
        return eEditText;
    }

    public void cloneAttributes(EEditText eEditText) {
        eEditText.setContent(this.getContent());
        eEditText.setEditable(this.getEditable());
        eEditText.setMultiline(this.getMultiline());
        eEditText.setBorder(this.getBorder());
        eEditText.setMaxchars(this.getMaxchars());
        eEditText.setMaxlines(this.getMaxlines());
        eEditText.setAlign(this.getAlign());
        eEditText.setCx(this.getCx());
        eEditText.setCy(this.getCy());
        eEditText.setFitFont(this.getFitFont());
        eEditText.setLineWrap(this.getLineWrap());
        eEditText.setWrapMode(this.getWrapMode());
        eEditText.setAutoTab(this.getAutoTab());
        eEditText.setTextChangedRule(this.getTextChangedRule());
        eEditText.setTextChangedDelay(this.getTextChangedDelay());
        eEditText.setTextChangedMinChars(this.getTextChangedMinChars());
        super.cloneAttributes(eEditText);
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 2: {
                        sTATUS.attrMode = 5;
                        return this.setLine(sET.getValueString(), this.getInt(sET.index));
                    }
                }
                return 8;
            }
            switch (n) {
                case 1: {
                    this.setContent(sET.getValueString());
                    sTATUS.attrMode = 5;
                    if (!this.contentCached) break;
                    sTATUS.cacheMode = 1;
                    break;
                }
                case 2: {
                    sTATUS.attrMode = 5;
                    return this.setLine(sET.getValueString(), 0);
                }
                case 3: {
                    this.setEditable(sET.getValueInt());
                    break;
                }
                case 4: {
                    this.setMultiline(sET.getValueInt());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 5: {
                    this.setBorder(sET.getValueInt());
                    break;
                }
                case 9: {
                    this.setMaxchars(sET.getValueInt());
                    break;
                }
                case 10: {
                    this.setMaxlines(sET.getValueInt());
                    break;
                }
                case 13: {
                    this.setCx(sET.getValueInt());
                    break;
                }
                case 14: {
                    this.setCy(sET.getValueInt());
                    break;
                }
                case 15: {
                    this.setClear();
                    sTATUS.attrMode = 5;
                    break;
                }
                case 16: {
                    this.setAdd(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 17: {
                    this.setIns(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 18: {
                    this.setDelln(sET.getValueInt());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 19: {
                    this.setIsPassword(sET.getValueInt());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 20: {
                    this.setAlign(sET.getValueString());
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 21: {
                    return this.setFitFont(sET.getValueInt());
                }
                case 22: {
                    return this.setLineWrap(sET.getValueString());
                }
                case 23: {
                    return this.setWrapMode(sET.getValueString());
                }
                case 24: {
                    return this.setAutoTab(sET.getValueInt());
                }
                case 28: {
                    this.setTextChangedRule(sET.getValueInt());
                    break;
                }
                case 29: {
                    this.setTextChangedDelay(sET.getValueInt());
                    break;
                }
                case 30: {
                    this.setTextChangedMinChars(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 2: {
                        if (gET2.setValueString(this.getLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 0: {
                    gET2.setValueInt(this.getLength());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getContent());
                    if (this.peer instanceof EJTextField) {
                        gET2.cacheMode = 1;
                        this.contentCached = true;
                        break;
                    }
                    this.contentCached = false;
                    break;
                }
                case 2: {
                    if (gET2.setValueString(this.getLine(0))) break;
                    return 11;
                }
                case 3: {
                    gET2.setValueInt(this.getEditable());
                    break;
                }
                case 4: {
                    gET2.setValueInt(this.getMultiline());
                    break;
                }
                case 5: {
                    gET2.setValueInt(this.getBorder());
                    break;
                }
                case 6: {
                    gET2.setValueString("");
                    break;
                }
                case 7: {
                    gET2.setValueInt(1);
                    break;
                }
                case 8: {
                    gET2.setValueInt(1);
                    break;
                }
                case 9: {
                    gET2.setValueInt(this.getMaxchars());
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getMaxlines());
                    break;
                }
                case 11: {
                    gET2.setValueInt(this.getVheight());
                    break;
                }
                case 12: {
                    gET2.setValueInt(this.getVwidth());
                    break;
                }
                case 13: {
                    gET2.setValueInt(this.getCx());
                    break;
                }
                case 14: {
                    gET2.setValueInt(this.getCy());
                    break;
                }
                case 19: {
                    gET2.setValueInt(this.getIsPassword());
                    break;
                }
                case 20: {
                    gET2.setValueString(this.getAlign());
                    break;
                }
                case 21: {
                    gET2.setValueInt(this.getFitFont());
                    break;
                }
                case 22: {
                    gET2.setValueString(this.getLineWrap());
                    break;
                }
                case 23: {
                    gET2.setValueString(this.getWrapMode());
                    break;
                }
                case 24: {
                    gET2.setValueInt(this.getAutoTab());
                    break;
                }
                case 25: {
                    gET2.setValueString(this.getDragContent());
                    break;
                }
                case 26: {
                    gET2.setValueInt(this.getDropCx());
                    break;
                }
                case 27: {
                    gET2.setValueInt(this.getDropCy());
                    break;
                }
                case 28: {
                    gET2.setValueInt(this.getTextChangedRule());
                    break;
                }
                case 29: {
                    gET2.setValueInt(this.getTextChangedDelay());
                    break;
                }
                case 30: {
                    gET2.setValueInt(this.getTextChangedMinChars());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        Rectangle rectangle;
        Serializable serializable;
        if (bl) {
            this.dragContent = null;
            this.dropCy = -1;
            this.dropCx = -1;
        }
        this.textChangedHasTimer = false;
        layoutEditExpandWidth = -1;
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        this.ignoreDocumentUpdate = true;
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        boolean bl2 = ruleManager != null && ruleManager.getFocus() == this;
        JTextComponent jTextComponent = (JTextComponent)this.peer;
        if (this.multiline) {
            if (!(this.peer instanceof JTextArea)) {
                this.updateContent(jTextComponent);
                this.contentSet = true;
                serializable = jTextComponent.getFont();
                rectangle = this.peer.getBounds(null);
                Container container = this.parent.getContainerPeer();
                int n = this.containerIndex(container, this.peer);
                container.remove(n);
                EJTextArea eJTextArea = new EJTextArea();
                eJTextArea.addMouseListener(this);
                eJTextArea.addKeyListener(this);
                eJTextArea.addCaretListener(this);
                EPlainDocument ePlainDocument = new EPlainDocument();
                eJTextArea.setDocument(ePlainDocument);
                ePlainDocument.addDocumentListener(this);
                eJTextArea.setEditable(true);
                eJTextArea.setCursor(Cursor.getPredefinedCursor(2));
                eJTextArea.setFocusTraversalKeysEnabled(false);
                this.disposePeer();
                this.peer.setVisible(false);
                this.peer = eJTextArea;
                this.peer.setFont((Font)serializable);
                this.scrollPane = new EJScrollPane(this.peer);
                this.scrollPane.setBounds(rectangle);
                this.scrollPane.setControl(this);
                container.add(this.scrollPane, this, n);
                container.invalidate();
                this.clipboardManager.setTextComponent(eJTextArea);
            }
            if (this.scrollPane.isVisible() != this.visible) {
                this.scrollPane.setVisible(this.visible);
            }
        } else {
            if (this.passwordField && !(this.peer instanceof JPasswordField)) {
                this.updateContent(jTextComponent);
                this.contentSet = true;
                serializable = jTextComponent.getFont();
                rectangle = this.scrollPane != null ? this.scrollPane.getBounds(null) : this.peer.getBounds(null);
                Container container = this.parent.getContainerPeer();
                int n = this.containerIndex(container, this.scrollPane != null ? this.scrollPane : this.peer);
                container.remove(n);
                EJPasswordField eJPasswordField = new EJPasswordField();
                eJPasswordField.setColumns(this.getWidth());
                eJPasswordField.addMouseListener(this);
                eJPasswordField.addKeyListener(this);
                eJPasswordField.addCaretListener(this);
                EPlainDocument ePlainDocument = new EPlainDocument();
                eJPasswordField.setDocument(ePlainDocument);
                ePlainDocument.addDocumentListener(this);
                eJPasswordField.setEditable(true);
                eJPasswordField.setCursor(Cursor.getPredefinedCursor(2));
                eJPasswordField.setFocusTraversalKeysEnabled(false);
                this.disposePeer();
                this.peer.setVisible(false);
                this.peer = eJPasswordField;
                eJPasswordField.setFont((Font)serializable);
                container.add(this.peer, this, n);
                this.peer.setBounds(rectangle);
                container.invalidate();
                this.clipboardManager.setTextComponent(eJPasswordField);
            } else if (!this.passwordField && !(this.peer instanceof EJTextField)) {
                this.updateContent(jTextComponent);
                this.contentSet = true;
                serializable = jTextComponent.getFont();
                rectangle = this.scrollPane != null ? this.scrollPane.getBounds(null) : this.peer.getBounds(null);
                Container container = this.parent.getContainerPeer();
                int n = this.containerIndex(container, this.scrollPane != null ? this.scrollPane : this.peer);
                container.remove(n);
                EJTextField eJTextField = this.createEJTextField();
                this.disposePeer();
                this.peer.setVisible(false);
                this.peer = eJTextField;
                eJTextField.setFont((Font)serializable);
                container.add(this.peer, this, n);
                this.peer.setBounds(rectangle);
                container.invalidate();
                this.clipboardManager.setTextComponent(eJTextField);
            }
            if (this.scrollPane != null) {
                this.scrollPane.setControl(null);
                this.scrollPane = null;
            }
        }
        jTextComponent = (JTextComponent)this.peer;
        if (this.contentSet) {
            jTextComponent.setText(this.content);
        }
        if (jTextComponent.isEditable() != this.editable) {
            jTextComponent.setEditable(this.editable);
            jTextComponent.setCursor(Cursor.getPredefinedCursor(this.editable ? 2 : 0));
        }
        if (jTextComponent instanceof JTextField && ((JTextField)(serializable = (JTextField)jTextComponent)).getHorizontalAlignment() != this.align) {
            ((JTextField)serializable).setHorizontalAlignment(this.align);
        }
        if (jTextComponent instanceof JTextArea) {
            serializable = (JTextArea)jTextComponent;
            if (this.lineWrap != 0) {
                boolean bl3;
                if (!((JTextArea)serializable).getLineWrap()) {
                    ((JTextArea)serializable).setLineWrap(true);
                }
                this.lineWrapHard = this.lineWrap == 2;
                boolean bl4 = bl3 = this.wrapMode == 0;
                if (((JTextArea)serializable).getWrapStyleWord() != bl3) {
                    ((JTextArea)serializable).setWrapStyleWord(bl3);
                }
            } else if (((JTextArea)serializable).getLineWrap()) {
                ((JTextArea)serializable).setLineWrap(false);
            }
        }
        if (bl2 && this.editable) {
            if (this.focusColor != null) {
                this.overrideBackground = true;
                this.peer.setBackground(this.focusColor);
            }
            this.requestFocusInWindow(this.peer);
        } else {
            this.overrideBackground = false;
        }
        super.eloq2swing(bl);
        if (this.contentSet) {
            this.contentSet = false;
            if (!(!bl2 || !this.editable || jTextComponent instanceof JTextArea || jTextComponent instanceof EqTextField && EqTextField.isOverwrite())) {
                jTextComponent.selectAll();
            } else {
                jTextComponent.select(0, 0);
                jTextComponent.setCaretPosition(0);
            }
            this.caretModified = false;
        }
        this.ignoreDocumentUpdate = false;
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        super.swing2eloq(dO);
        if (dO != null) {
            if (this.peer instanceof EJTextField) {
                if (this.contentModified) {
                    this.updateContent(null);
                    dO.cache((AbstractControl)this, CONTENT_ATTR_NAME, 0, this.content);
                    this.contentCached = true;
                }
            } else if (this.contentCached) {
                dO.uncache(this, CONTENT_ATTR_NAME);
                this.contentCached = false;
            }
        }
    }

    private final int containerIndex(Container container, Component component) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (component != container.getComponent(i)) continue;
            return i;
        }
        throw new RuntimeException("not found: '" + this.getPath() + "'");
    }

    private final EJTextField createEJTextField() {
        EJTextField eJTextField = new EJTextField();
        eJTextField.addMouseListener(this);
        eJTextField.addKeyListener(this);
        eJTextField.addCaretListener(this);
        EPlainDocument ePlainDocument = new EPlainDocument();
        eJTextField.setDocument(ePlainDocument);
        ePlainDocument.addDocumentListener(this);
        eJTextField.setEditable(true);
        eJTextField.setCursor(Cursor.getPredefinedCursor(2));
        eJTextField.setFocusTraversalKeysEnabled(false);
        return eJTextField;
    }

    public void focusReceived(AbstractControl abstractControl) {
        if (abstractControl != this) {
            this.clipboardManager.resetUndoBuffer();
            if (!this.mouseDown) {
                JTextComponent jTextComponent = (JTextComponent)this.peer;
                if (!(jTextComponent instanceof JTextArea || jTextComponent instanceof EqTextField && EqTextField.isOverwrite())) {
                    jTextComponent.selectAll();
                } else {
                    jTextComponent.select(0, 0);
                    jTextComponent.setCaretPosition(0);
                }
                this.caretModified = true;
            }
        }
        if (this.focusColor != null) {
            this.overrideBackground = true;
            this.peer.setBackground(this.focusColor);
        }
        super.focusReceived(abstractControl);
    }

    public void focusLost(AbstractControl abstractControl) {
        JTextComponent jTextComponent;
        this.mouseDown = false;
        if (this.peer != null) {
            jTextComponent = (JTextComponent)this.peer;
            this.updateCxCy(jTextComponent);
        } else {
            jTextComponent = null;
        }
        boolean bl = false;
        if (abstractControl != this) {
            if (jTextComponent != null) {
                jTextComponent.select(0, 0);
                jTextComponent.setCaretPosition(0);
                this.caretModified = false;
            }
        } else if (this.mouseDown) {
            bl = true;
        }
        if (this.peer != null) {
            this.peer.setBackground(this.bgc);
        }
        this.overrideBackground = false;
        if (this.autoTabIgnoreRule) {
            this.autoTabIgnoreRule = false;
        } else if (this.getRule() != 0 && this.isInDlgDo() && !bl) {
            this.getRuleManager().fireRule(this);
        }
        super.focusLost(abstractControl);
        EDialog eDialog = this.getDialog();
        if (eDialog != null) {
            eDialog.cancelRuleTimer(this);
        }
    }

    public boolean fireRuleOnLosingFocus() {
        return this.getRule() != 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        String string;
        if (this.isNativeRightMouseButtonEvent(mouseEvent) && !this.isRightMouseButtonEvent(mouseEvent) && this.peer.hasFocus() && TextComponentClipboardManager.isContextMenuConfigured(string = this.getClipboardContextMenu())) {
            mouseEvent.consume();
            this.clipboardManager.showContextMenu(string, mouseEvent.getPoint());
            return;
        }
        if (this.processRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        this.mouseDown = true;
        this.getRuleManager().requestFocus(this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.consumeRightMouseButtonEvent(mouseEvent)) {
            this.mouseDown = false;
        }
    }

    protected boolean doContextMenu(AbstractControl abstractControl, MouseEvent mouseEvent) {
        String string;
        if (this.contextMenu.length() == 0 && this.peer.hasFocus() && TextComponentClipboardManager.isContextMenuConfigured(string = this.getClipboardContextMenu())) {
            this.clipboardManager.showContextMenu(string, mouseEvent.getPoint());
            return true;
        }
        return super.doContextMenu(abstractControl, mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.consumeInputEvent(keyEvent)) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (this.multiline || this.parent.checkForFunctionKey(keyEvent)) break;
                this.getRuleManager().requestNextFocus();
                break;
            }
            case 38: 
            case 40: 
            case 224: 
            case 225: {
                if (this.multiline) break;
                super.keyPressed(keyEvent);
                break;
            }
            case 90: {
                if (!(!keyEvent.isMetaDown() && !keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isAltGraphDown() || keyEvent.isShiftDown())) {
                    keyEvent.consume();
                    this.clipboardManager.undo();
                    break;
                }
                super.keyPressed(keyEvent);
                break;
            }
            case 8: {
                if (this.autoTabAction(2)) {
                    keyEvent.consume();
                    break;
                }
                super.keyPressed(keyEvent);
                break;
            }
            case 37: 
            case 226: {
                if (this.autoTabOnKey(2)) {
                    keyEvent.consume();
                    break;
                }
                super.keyPressed(keyEvent);
                break;
            }
            case 39: 
            case 227: {
                if (this.autoTabOnKey(1)) {
                    keyEvent.consume();
                    break;
                }
                super.keyPressed(keyEvent);
                break;
            }
            default: {
                super.keyPressed(keyEvent);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.consumeInputEvent(keyEvent)) {
            return;
        }
        super.keyTyped(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.consumeInputEvent(keyEvent)) {
            return;
        }
        super.keyReleased(keyEvent);
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        boolean bl = false;
        if (this.scrollPane != null) {
            this.scrollPane.fixedWidth = 0;
            this.scrollPane.fixedHeight = 0;
        }
        if (this.useRasterSize || this.fitFont != 0) {
            Object object;
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.xauto != 0) {
                int n8 = n = (this.fitFont & 1) != 0 ? 1 : 0;
                if (this.useRasterSize || n != 0) {
                    Object object2 = object = n != 0 ? this.fontReference : this.getDialogFont();
                    if (object != null) {
                        Insets insets = ((JTextComponent)this.peer).getInsets();
                        n2 = insets.left + insets.right;
                        n3 = insets.top + insets.bottom;
                        if (this.scrollPane != null) {
                            insets = this.scrollPane.getInsets();
                            n2 += insets.left + insets.right;
                            n3 += insets.top + insets.bottom;
                            if (n != 0) {
                                JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
                                if (jScrollBar != null && jScrollBar.isVisible()) {
                                    n4 = jScrollBar.getSize().width;
                                }
                                if ((jScrollBar = this.scrollPane.getHorizontalScrollBar()) != null && jScrollBar.isVisible()) {
                                    n5 = jScrollBar.getSize().height;
                                }
                            }
                        }
                        bl2 = true;
                        if (dimension2 == null) {
                            dimension2 = this.getLayoutGrid();
                        }
                        if (layoutEditExpandWidth == -1) {
                            int n9 = layoutEditExpandWidth = StartUp.getEditExpandWidth() ? 1 : 0;
                        }
                        if (n != 0 || layoutEditExpandWidth == 1) {
                            int n10 = ((FontReference)object).getCharWidth(this, 'X');
                            int n11 = n10 * dimension.width / dimension2.width + n10 / 2 + n2 + n4;
                            if (n != 0 || n11 > dimension.width) {
                                n6 = n11;
                                n7 = dimension.height;
                                bl3 = true;
                                if (n != 0 && this.scrollPane != null) {
                                    this.scrollPane.fixedWidth = n11 - n4;
                                }
                            }
                        }
                    }
                }
            }
            if (this.yauto != 0 && (this.fitFont & 2) != 0 && this.fontReference != null) {
                if (!bl2) {
                    Insets insets = ((JTextComponent)this.peer).getInsets();
                    n3 = insets.top + insets.bottom;
                    if (this.scrollPane != null) {
                        insets = this.scrollPane.getInsets();
                        n3 += insets.top + insets.bottom;
                        object = this.scrollPane.getHorizontalScrollBar();
                        if (object != null && ((Component)object).isVisible()) {
                            n5 = ((Component)object).getSize().height;
                        }
                    }
                }
                if (dimension2 == null) {
                    dimension2 = this.getLayoutGrid();
                }
                n = this.fontReference.getHeight(this.getFontScaling());
                n7 = n * dimension.height / dimension2.height + n3 + n5;
                if (!bl3) {
                    n6 = dimension.width;
                    bl3 = true;
                }
                if (this.scrollPane != null) {
                    this.scrollPane.fixedHeight = n7 - n5;
                }
            }
            if (bl3) {
                if (this.scrollPane != null) {
                    Dimension dimension3 = this.scrollPane.getSize();
                    if (dimension3.width != n6 || dimension3.height != n7) {
                        this.scrollPane.setSize(n6, n7);
                    }
                } else {
                    Dimension dimension4 = this.peer.getSize();
                    if (dimension4.width != n6 || dimension4.height != n7) {
                        this.peer.setSize(n6, n7);
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public void horizontalScrollBarVisible(JScrollBar jScrollBar, boolean bl) {
        if (this.scrollPane != null) {
            if (this.scrollPane.fixedHeight > 0) {
                Dimension dimension = this.scrollPane.getSize();
                if (dimension.width > 0 && dimension.height > 0) {
                    int n;
                    if (bl) {
                        if (this.horizontalScrollBarVisibleTimer != null) {
                            return;
                        }
                        int n2 = jScrollBar.getSize().height;
                        if (n2 <= 0) {
                            return;
                        }
                        n = this.scrollPane.fixedHeight + n2;
                    } else {
                        n = this.scrollPane.fixedHeight;
                    }
                    if (dimension.height != n) {
                        this.scrollPane.setSize(dimension.width, n);
                        this.startHorizontalScrollBarVisibleTimer();
                    }
                    return;
                }
            }
            this.scrollPane.fixedHeight = 0;
        }
    }

    public void verticalScrollBarVisible(JScrollBar jScrollBar, boolean bl) {
        if (this.scrollPane != null) {
            if (this.scrollPane.fixedWidth > 0) {
                Dimension dimension = this.scrollPane.getSize();
                if (dimension.width > 0 && dimension.height > 0) {
                    int n;
                    if (bl) {
                        if (this.verticalScrollBarVisibleTimer != null) {
                            return;
                        }
                        int n2 = jScrollBar.getSize().width;
                        if (n2 <= 0) {
                            return;
                        }
                        n = this.scrollPane.fixedWidth + n2;
                    } else {
                        n = this.scrollPane.fixedWidth;
                    }
                    if (dimension.width != n) {
                        this.scrollPane.setSize(n, dimension.height);
                        this.startVerticalScrollBarVisibleTimer();
                    }
                    return;
                }
            }
            this.scrollPane.fixedWidth = 0;
        }
    }

    private final void scrollToCaret() {
        if (this.peer instanceof JTextArea) {
            int n;
            int n2;
            Cloneable cloneable;
            JTextArea jTextArea = (JTextArea)this.peer;
            Caret caret = jTextArea.getCaret();
            if (caret instanceof Rectangle) {
                cloneable = (Rectangle)((Object)caret);
                n2 = cloneable.width;
                n = cloneable.height;
            } else if (this.fontReference != null) {
                n2 = this.fontReference.getCharWidth(this, 'X');
                n = this.fontReference.getHeight(this.getFontScaling());
            } else {
                n2 = 5;
                n = 10;
            }
            cloneable = caret.getMagicCaretPosition();
            if (cloneable != null) {
                jTextArea.scrollRectToVisible(new Rectangle(((Point)cloneable).x, ((Point)cloneable).y, n2, n));
            }
        }
    }

    private final void startHorizontalScrollBarVisibleTimer() {
        if (this.horizontalScrollBarVisibleTimer != null) {
            this.horizontalScrollBarVisibleTimer.restart();
        } else {
            this.horizontalScrollBarVisibleTimer = new Timer(5, new HorizontalScrollBarVisibleTimer());
            this.horizontalScrollBarVisibleTimer.setRepeats(false);
            this.horizontalScrollBarVisibleTimer.start();
        }
    }

    private final void startVerticalScrollBarVisibleTimer() {
        if (this.verticalScrollBarVisibleTimer != null) {
            this.verticalScrollBarVisibleTimer.restart();
        } else {
            this.verticalScrollBarVisibleTimer = new Timer(5, new VerticalScrollBarVisibleTimer());
            this.verticalScrollBarVisibleTimer.setRepeats(false);
            this.verticalScrollBarVisibleTimer.start();
        }
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setContent(String string) {
        string = this.filterASCIIHighlightChars(string);
        if (this.contentModified || !this.content.equals(string)) {
            this.content = string;
            this.contentModified = false;
        }
        this.contentSet = true;
        this.isModified = true;
    }

    public String getContent() {
        this.updateContent(null);
        return this.content;
    }

    private void updateContent(JTextComponent jTextComponent) {
        if (this.contentModified) {
            this.contentModified = false;
            if (jTextComponent == null) {
                jTextComponent = (JTextComponent)this.peer;
            }
            this.content = jTextComponent.getText();
            if (this.lineWrapHard && jTextComponent instanceof JTextArea) {
                int n;
                Rectangle rectangle;
                if (!((JTextArea)jTextComponent).getLineWrap()) {
                    return;
                }
                try {
                    rectangle = jTextComponent.modelToView(0);
                    if (rectangle.isEmpty()) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                int n2 = this.content.length();
                int n3 = 0;
                int n4 = 0;
                int n5 = rectangle.y;
                boolean bl = true;
                do {
                    n5 += rectangle.height;
                    if (this.tmpPos == null) {
                        this.tmpPos = new Point(rectangle.x, n5);
                    } else {
                        this.tmpPos.x = rectangle.x;
                        this.tmpPos.y = n5;
                    }
                    n = jTextComponent.viewToModel(this.tmpPos);
                    if (n < 0) {
                        return;
                    }
                    if (n == n4) break;
                    if (!bl) {
                        ++n3;
                    }
                    n3 += n - n4;
                    boolean bl2 = bl = this.content.charAt(n - 1) == '\n';
                } while ((n4 = n) < n2);
                if (n3 > n2) {
                    int n6;
                    StringBuilder stringBuilder = new StringBuilder(n3);
                    n4 = 0;
                    n5 = rectangle.y;
                    bl = true;
                    do {
                        n5 += rectangle.height;
                        if (this.tmpPos == null) {
                            this.tmpPos = new Point(rectangle.x, n5);
                        } else {
                            this.tmpPos.x = rectangle.x;
                            this.tmpPos.y = n5;
                        }
                        n6 = jTextComponent.viewToModel(this.tmpPos);
                        if (n6 < 0) {
                            return;
                        }
                        if (n6 == n4) break;
                        if (!bl) {
                            stringBuilder.append('\n');
                        }
                        stringBuilder.append(this.content.substring(n4, n6));
                        boolean bl3 = bl = this.content.charAt(n6 - 1) == '\n';
                    } while ((n4 = n6) < n2);
                    this.content = stringBuilder.toString();
                }
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        EDialog eDialog;
        this.contentModified = true;
        if (!this.ignoreDocumentUpdate && (eDialog = this.getDialog()) != null && eDialog.eventsAllowed()) {
            this.autoTabOnDocumentUpdate(1);
            this.textChangedOnDocumentUpdate(eDialog, false);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        EDialog eDialog;
        this.contentModified = true;
        if (!this.ignoreDocumentUpdate && (eDialog = this.getDialog()) != null && eDialog.eventsAllowed()) {
            this.textChangedOnDocumentUpdate(eDialog, true);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public int getLength() {
        this.updateContent(null);
        return this.content.length();
    }

    public void setEditable(int n) {
        this.editable = n != 0;
        this.isModified = true;
    }

    public int getEditable() {
        return this.editable ? 1 : 0;
    }

    public void setMultiline(int n) {
        this.multiline = n != 0;
        this.isModified = true;
    }

    public int getMultiline() {
        return this.multiline ? 1 : 0;
    }

    public void setBorder(int n) {
    }

    public int getBorder() {
        return 0;
    }

    public void setAlign(String string) {
        this.align = string.equalsIgnoreCase(CENTER_STR) ? 0 : (string.equalsIgnoreCase(RIGHT_STR) ? 4 : 2);
        this.isModified = true;
    }

    public String getAlign() {
        switch (this.align) {
            case 0: {
                return CENTER_STR;
            }
            case 4: {
                return RIGHT_STR;
            }
        }
        return LEFT_STR;
    }

    public void setMaxchars(int n) {
        this.maxchars = n;
        this.isModified = true;
    }

    public int getMaxchars() {
        return this.maxchars;
    }

    public void setMaxlines(int n) {
        this.maxlines = n;
        this.isModified = true;
    }

    public int getMaxlines() {
        return this.maxlines;
    }

    public int getVheight() {
        int n;
        this.updateContent(null);
        int n2 = this.content.length();
        if (n2 == 0) {
            return 0;
        }
        if (!this.multiline) {
            return 1;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n = this.content.indexOf(10, n3)) >= 0) {
            ++n4;
            n3 = n + 1;
        }
        if (n3 < n2) {
            ++n4;
        }
        return n4;
    }

    public int getVwidth() {
        int n;
        int n2;
        this.updateContent(null);
        int n3 = this.content.length();
        if (!this.multiline) {
            return n3;
        }
        int n4 = 0;
        int n5 = 0;
        while ((n2 = this.content.indexOf(10, n4)) >= 0) {
            n = n2 - n4;
            if (n > n5) {
                n5 = n;
            }
            n4 = n2 + 1;
        }
        if (n4 < n3 && (n = n3 - n4) > n5) {
            n5 = n;
        }
        return n5;
    }

    public int setCx(int n) {
        if (n < 0) {
            return 11;
        }
        this.cx = n;
        this.caretModified = false;
        return 0;
    }

    public int getCx() {
        this.updateCxCy(null);
        return this.cx;
    }

    public int setCy(int n) {
        if (n < 0) {
            return 11;
        }
        this.cy = n;
        this.caretModified = false;
        return 0;
    }

    public int getCy() {
        this.updateCxCy(null);
        return this.cy;
    }

    private void updateCxCy(JTextComponent jTextComponent) {
        block16: {
            block17: {
                int n;
                int n2;
                block15: {
                    Rectangle rectangle;
                    Rectangle rectangle2;
                    block18: {
                        if (!this.caretModified) break block16;
                        this.caretModified = false;
                        if (jTextComponent == null) {
                            jTextComponent = (JTextComponent)this.peer;
                        }
                        if (!(jTextComponent instanceof JTextArea)) break block17;
                        this.cy = 0;
                        this.cx = 0;
                        if (!this.lineWrapHard || !((JTextArea)jTextComponent).getLineWrap()) break block15;
                        n2 = jTextComponent.getCaretPosition();
                        if (n2 <= 0) {
                            return;
                        }
                        try {
                            rectangle2 = jTextComponent.modelToView(0);
                            rectangle = jTextComponent.modelToView(n2);
                            if (rectangle2.isEmpty()) break block15;
                            if (rectangle.isEmpty()) {
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                        break block15;
                        if (rectangle.x <= rectangle2.x) break block18;
                        if (this.tmpPos == null) {
                            this.tmpPos = new Point(rectangle2.x, rectangle.y);
                        } else {
                            this.tmpPos.x = rectangle2.x;
                            this.tmpPos.y = rectangle.y;
                        }
                        int n3 = jTextComponent.viewToModel(this.tmpPos);
                        if (n3 < 0 || n2 <= n3) break block15;
                        this.cx = n2 - n3;
                    }
                    if (rectangle.y > rectangle2.y) {
                        this.cy = (rectangle.y - rectangle2.y) / rectangle.height;
                    }
                    return;
                }
                this.updateContent(jTextComponent);
                n2 = jTextComponent.getCaretPosition();
                int n4 = 0;
                while ((n = this.content.indexOf(10, n4)) >= 0) {
                    if (n2 <= n) {
                        this.cx = n2 - n4;
                        break;
                    }
                    ++this.cy;
                    n4 = n + 1;
                }
                if (n == -1) {
                    n = this.content.length();
                    this.cx = n2 <= n ? n2 - n4 : n - n4;
                }
                break block16;
            }
            this.cx = jTextComponent.getCaretPosition();
            this.cy = 0;
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.caretModified = true;
    }

    public int setLine(String string, int n) {
        if (!this.multiline) {
            this.setContent(string);
        } else {
            String string2;
            int n2;
            n = n > 0 ? --n : this.getCy();
            this.updateContent(null);
            int n3 = 0;
            while ((n2 = this.content.indexOf(10, n3)) >= 0 && n-- != 0) {
                n3 = n2 + 1;
            }
            int n4 = (string = this.filterASCIIHighlightChars(string)).indexOf(10);
            if (n4 >= 0) {
                string = n4 > 0 ? string.substring(0, n4) : "";
            }
            String string3 = string2 = n3 > 0 ? this.content.substring(0, n3).concat(string) : string;
            if (n2 >= 0) {
                string2 = string2.concat(this.content.substring(n2));
            } else if (!string2.endsWith("\n")) {
                string2 = string2.concat("\n");
            }
            this.content = string2;
            this.contentModified = false;
            this.contentSet = true;
            this.isModified = true;
        }
        return 0;
    }

    public String getLine(int n) {
        int n2;
        boolean bl;
        if (n > 0) {
            --n;
            bl = true;
        } else {
            n = this.getCy();
            bl = false;
        }
        this.updateContent(null);
        int n3 = 0;
        while ((n2 = this.content.indexOf(10, n3)) >= 0 && n-- != 0) {
            n3 = n2 + 1;
        }
        if (n2 == -1 && n != 0) {
            return bl ? null : "";
        }
        return n2 >= 0 ? this.content.substring(n3, n2) : this.content.substring(n3);
    }

    public void setClear() {
        this.content = "";
        this.contentModified = false;
        this.contentSet = true;
        this.cy = 0;
        this.cx = 0;
        this.caretModified = false;
        this.isModified = true;
    }

    public void setAdd(String string) {
        if (!this.multiline) {
            this.setContent(string);
        } else {
            this.updateContent(null);
            string = this.filterASCIIHighlightChars(string);
            if (!string.endsWith("\n")) {
                string = string.concat("\n");
            }
            if (this.content.length() > 0 && !this.content.endsWith("\n")) {
                this.content = this.content.concat("\n");
            }
            this.content = this.content.concat(string);
            this.contentModified = false;
            this.contentSet = true;
            this.isModified = true;
        }
    }

    public int setIns(String string) {
        String string2;
        int n;
        int n2;
        int n3;
        this.updateContent(null);
        int n4 = 0;
        if (!this.multiline) {
            n3 = 0;
            n2 = this.content.length();
        } else {
            n = n3 = this.getCy();
            while ((n2 = this.content.indexOf(10, n4)) >= 0 && n-- != 0) {
                n4 = n2 + 1;
            }
            if (n2 == -1) {
                n2 = this.content.length();
            }
        }
        n = this.getCx();
        if ((n4 += n) > n2) {
            n4 = n2;
        }
        string = this.filterASCIIHighlightChars(string);
        String string3 = string2 = n4 > 0 ? this.content.substring(0, n4).concat(string) : string;
        if (n4 < this.content.length()) {
            string2 = string2.concat(this.content.substring(n4));
        } else if (this.multiline && !string2.endsWith("\n")) {
            string2 = string2.concat("\n");
        }
        this.content = string2;
        this.contentModified = false;
        this.contentSet = true;
        n4 = 0;
        while ((n2 = string.indexOf(10, n4)) >= 0) {
            n = 0;
            ++n3;
            n4 = n2 + 1;
        }
        this.setCx(n + string.length() - n4);
        this.setCy(n3);
        this.isModified = true;
        return 0;
    }

    public void setDelln(int n) {
        if (!this.multiline) {
            this.setClear();
            return;
        }
        if (n > 0) {
            int n2;
            this.updateContent(null);
            int n3 = this.getCy();
            int n4 = 0;
            int n5 = -1;
            int n6 = -1;
            while ((n2 = this.content.indexOf(10, n4)) >= 0) {
                if (n5 == -1 && n3-- == 0) {
                    n5 = n4;
                }
                n4 = n2 + 1;
                if (n5 < 0 || --n != 0) continue;
                n6 = n4;
                break;
            }
            if (n5 == -1 && n3 == 0) {
                n5 = n4;
            }
            if (n5 >= 0) {
                String string;
                String string2 = string = n5 > 0 ? this.content.substring(0, n5) : "";
                if (n6 >= 0 && n6 < this.content.length()) {
                    string = string.concat(this.content.substring(n6));
                }
                this.content = string;
                this.contentModified = false;
            }
            this.contentSet = true;
            this.isModified = true;
        }
    }

    public void setIsPassword(int n) {
        this.passwordField = n != 0;
        this.isModified = true;
    }

    public int getIsPassword() {
        if (this.passwordField && !this.multiline) {
            return 1;
        }
        return 0;
    }

    public int setFitFont(int n) {
        if (n < 0 || n > 3) {
            return 11;
        }
        this.fitFont = n;
        return 0;
    }

    public int getFitFont() {
        return this.fitFont;
    }

    public int setLineWrap(String string) {
        if (string.equalsIgnoreCase(LINEWRAP_NONE_STR)) {
            this.lineWrap = 0;
        } else if (string.equalsIgnoreCase(LINEWRAP_SOFT_STR)) {
            this.lineWrap = 1;
        } else if (string.equalsIgnoreCase(LINEWRAP_HARD_STR)) {
            this.lineWrap = 2;
        } else {
            return 11;
        }
        this.isModified = true;
        return 0;
    }

    public String getLineWrap() {
        switch (this.lineWrap) {
            case 1: {
                return LINEWRAP_SOFT_STR;
            }
            case 2: {
                return LINEWRAP_HARD_STR;
            }
        }
        return LINEWRAP_NONE_STR;
    }

    public int setWrapMode(String string) {
        if (string.equalsIgnoreCase(WRAPMODE_WORD_STR)) {
            this.wrapMode = 0;
        } else if (string.equalsIgnoreCase(WRAPMODE_CHAR_STR)) {
            this.wrapMode = 1;
        } else {
            return 11;
        }
        this.isModified = true;
        return 0;
    }

    public String getWrapMode() {
        switch (this.wrapMode) {
            case 1: {
                return WRAPMODE_CHAR_STR;
            }
        }
        return WRAPMODE_WORD_STR;
    }

    public int setAutoTab(int n) {
        if ((n & 0xFFFFFFF8) != 0) {
            return 11;
        }
        this.autoTabMode = n;
        return 0;
    }

    public int getAutoTab() {
        return this.autoTabMode;
    }

    private final boolean autoTabAction(int n) {
        this.stopAutoTabTimer();
        if ((this.autoTabMode & n) != 0) {
            JTextComponent jTextComponent = (JTextComponent)this.peer;
            if (!(jTextComponent instanceof JTextField)) {
                return false;
            }
            switch (n) {
                case 2: {
                    if (jTextComponent.getText().length() != 0) break;
                    if ((this.autoTabMode & 4) != 0) {
                        this.autoTabIgnoreRule = true;
                    }
                    this.getRuleManager().requestPrevFocus();
                    return true;
                }
                default: {
                    if (this.maxchars <= 0 || jTextComponent.getText().length() < this.maxchars) break;
                    if ((this.autoTabMode & 4) != 0) {
                        this.autoTabIgnoreRule = true;
                    }
                    this.getRuleManager().requestNextFocus();
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean autoTabOnKey(int n) {
        this.stopAutoTabTimer();
        if ((this.autoTabMode & n) != 0) {
            JTextComponent jTextComponent = (JTextComponent)this.peer;
            if (!(jTextComponent instanceof JTextField)) {
                return false;
            }
            switch (n) {
                case 2: {
                    if (jTextComponent.getCaretPosition() != 0) break;
                    if ((this.autoTabMode & 4) != 0) {
                        this.autoTabIgnoreRule = true;
                    }
                    this.getRuleManager().requestPrevFocus();
                    return true;
                }
                default: {
                    int n2 = jTextComponent.getCaretPosition();
                    if (n2 <= 0 || n2 != jTextComponent.getText().length()) break;
                    if ((this.autoTabMode & 4) != 0) {
                        this.autoTabIgnoreRule = true;
                    }
                    this.getRuleManager().requestNextFocus();
                    return true;
                }
            }
        }
        return false;
    }

    private final void autoTabOnDocumentUpdate(int n) {
        this.stopAutoTabTimer();
        if ((this.autoTabMode & n) != 0) {
            JTextComponent jTextComponent = (JTextComponent)this.peer;
            if (!(jTextComponent instanceof JTextField)) {
                return;
            }
            switch (n) {
                case 2: {
                    if (jTextComponent.getText().length() != 0) break;
                    this.startAutoTabTimer(n);
                    break;
                }
                default: {
                    if (this.maxchars <= 0 || jTextComponent.getText().length() < this.maxchars) break;
                    this.startAutoTabTimer(n);
                }
            }
        }
    }

    private final void startAutoTabTimer(int n) {
        this.autoTabScheduledMode = n;
        if (this.autoTabTimer != null) {
            this.autoTabTimer.restart();
        } else {
            this.autoTabTimer = new Timer(20, new AutoTabTimer());
            this.autoTabTimer.setRepeats(false);
            this.autoTabTimer.start();
        }
    }

    private final void stopAutoTabTimer() {
        this.autoTabScheduledMode = 0;
        if (this.autoTabTimer != null) {
            this.autoTabTimer.stop();
        }
    }

    private void setTextChangedRule(int n) {
        this.textChangedRule = n;
    }

    private int getTextChangedRule() {
        return this.textChangedRule;
    }

    private void setTextChangedDelay(int n) {
        this.textChangedDelay = n;
    }

    private int getTextChangedDelay() {
        return this.textChangedDelay;
    }

    private void setTextChangedMinChars(int n) {
        this.textChangedMinChars = n;
    }

    private int getTextChangedMinChars() {
        return this.textChangedMinChars;
    }

    private void textChangedOnDocumentUpdate(EDialog eDialog, boolean bl) {
        JTextComponent jTextComponent;
        if (this.textChangedRule != 0 && (jTextComponent = (JTextComponent)this.peer) instanceof JTextField && (bl || jTextComponent.getText().length() >= this.textChangedMinChars)) {
            eDialog.startRuleTimer(this, this.textChangedRule, this.textChangedDelay);
            this.textChangedHasTimer = true;
            return;
        }
        if (this.textChangedHasTimer) {
            eDialog.cancelRuleTimer(this);
            this.textChangedHasTimer = false;
        }
    }

    public Component getPeer() {
        if (this.multiline && this.scrollPane != null) {
            return this.scrollPane;
        }
        return this.peer;
    }

    public Component getFocusPeer() {
        return this.peer;
    }

    public boolean isFocusable(boolean bl) {
        return this.editable && super.isFocusable(bl);
    }

    public boolean acceptTypeAhead(ESystem.TypeAheadItem typeAheadItem) {
        Object object;
        boolean bl;
        StringBuilder stringBuilder = typeAheadItem.chars;
        int n = typeAheadItem.termChar;
        boolean bl2 = false;
        boolean bl3 = bl = n == 10;
        if (bl && this.multiline) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append('\n');
            n = 0;
            bl = false;
            bl2 = true;
        }
        if (stringBuilder != null) {
            object = (JTextComponent)this.peer;
            ((JTextComponent)object).replaceSelection(stringBuilder.toString());
        }
        if (bl) {
            object = this.getDialog();
            if (object == null || ((EDialog)object).getCr() == 0) {
                this.typeAheadNextFocus();
                return true;
            }
        } else if (n == 9) {
            this.typeAheadNextFocus();
            return true;
        }
        if (bl2) {
            ESystem.typeAhead.processPendingEvents(this);
        }
        return n == 0;
    }

    private final String getDragContent() {
        return this.dragContent != null ? this.dragContent : "";
    }

    private final int getDropCx() {
        return this.dropCx;
    }

    private final int getDropCy() {
        return this.dropCy;
    }

    public void enableDragDrop() {
        this.setDragDropHandler(new DragDrop());
    }

    static {
        attributeList.put(LENGTH_ATTR_NAME, new Integer(0));
        attributeList.put(CONTENT_ATTR_NAME, new Integer(1));
        attributeList.put(LINE_BUF_ATTR_NAME, new Integer(1));
        attributeList.put(LINE_ATTR_NAME, new Integer(2));
        attributeList.put(EDITABLE_ATTR_NAME, new Integer(3));
        attributeList.put(MULTILINE_ATTR_NAME, new Integer(4));
        attributeList.put(BORDER_ATTR_NAME, new Integer(5));
        attributeList.put(TITLE_ATTR_NAME, new Integer(6));
        attributeList.put(LENGTH_ATTR_NAME, new Integer(0));
        attributeList.put(HSB_ATTR_NAME, new Integer(7));
        attributeList.put(VSB_ATTR_NAME, new Integer(8));
        attributeList.put(MAXCHARS_ATTR_NAME, new Integer(9));
        attributeList.put(MAXLINES_ATTR_NAME, new Integer(10));
        attributeList.put(VHEIGHT_ATTR_NAME, new Integer(11));
        attributeList.put(VWIDTH_ATTR_NAME, new Integer(12));
        attributeList.put(CX_ATTR_NAME, new Integer(13));
        attributeList.put(CY_ATTR_NAME, new Integer(14));
        attributeList.put(CLEAR_ATTR_NAME, new Integer(15));
        attributeList.put(ADD_ATTR_NAME, new Integer(16));
        attributeList.put(INS_ATTR_NAME, new Integer(17));
        attributeList.put(DELLN_ATTR_NAME, new Integer(18));
        attributeList.put(ISPASSWORD_ATTR_NAME, new Integer(19));
        attributeList.put(ALIGN_ATTR_NAME, new Integer(20));
        attributeList.put(FITFONT_ATTR_NAME, new Integer(21));
        attributeList.put(LINEWRAP_ATTR_NAME, new Integer(22));
        attributeList.put(WRAPMODE_ATTR_NAME, new Integer(23));
        attributeList.put(AUTOTAB_ATTR_NAME, new Integer(24));
        attributeList.put(DRAG_CONTENT_ATTR_NAME, new Integer(25));
        attributeList.put(DROP_CX_ATTR_NAME, new Integer(26));
        attributeList.put(DROP_CY_ATTR_NAME, new Integer(27));
        attributeList.put(TC_RULE_ATTR_NAME, new Integer(28));
        attributeList.put(TC_DELAY_ATTR_NAME, new Integer(29));
        attributeList.put(TC_MINCHARS_ATTR_NAME, new Integer(30));
    }

    class EPlainDocument
    extends PlainDocument {
        private Point tmpPos = null;

        EPlainDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            block55: {
                int n2;
                int n3;
                int n4;
                block54: {
                    Object object;
                    boolean bl;
                    block56: {
                        if (string == null) {
                            super.insertString(n, string, attributeSet);
                            return;
                        }
                        n4 = EEditText.this.maxchars;
                        n3 = this.getLength();
                        n2 = string.length();
                        JTextComponent jTextComponent = (JTextComponent)EEditText.this.peer;
                        if (!(jTextComponent instanceof JTextArea)) break block54;
                        boolean bl2 = false;
                        if (n4 < 1 || n4 >= n3 + n2) {
                            bl2 = true;
                        } else if (n4 > n3) {
                            string = string.substring(0, n4 - n3);
                            n2 = n4 - n3;
                            bl2 = true;
                        }
                        if (!bl2) break block55;
                        n4 = EEditText.this.maxlines;
                        if (n4 < 1) {
                            super.insertString(n, string, attributeSet);
                            return;
                        }
                        bl = false;
                        if (EEditText.this.lineWrapHard && ((JTextArea)(object = (JTextArea)jTextComponent)).getLineWrap()) {
                            View view;
                            FontMetrics fontMetrics;
                            Font font;
                            Rectangle rectangle = ((Component)object).getBounds();
                            Insets insets = ((JComponent)object).getInsets();
                            int n5 = rectangle.width - insets.left - insets.right;
                            if (n5 > 0 && (font = ((Component)object).getFont()) != null && (fontMetrics = ((JComponent)object).getFontMetrics(font)) != null && (view = ((JTextComponent)object).getUI().getRootView((JTextComponent)object)) != null && view.getViewCount() != 0 && (view = view.getView(0)) instanceof TabExpander) {
                                int n6;
                                char[] cArray;
                                block53: {
                                    int n7;
                                    char[] cArray2;
                                    int n8;
                                    char[] cArray3;
                                    boolean bl3;
                                    TabExpander tabExpander = (TabExpander)((Object)view);
                                    try {
                                        rectangle = jTextComponent.modelToView(0);
                                        if (rectangle.isEmpty()) {
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {}
                                    break block56;
                                    bl = true;
                                    int n9 = 0;
                                    int n10 = 0;
                                    int n11 = rectangle.y;
                                    boolean bl4 = bl3 = n < n3;
                                    while (true) {
                                        if (n9 > 0 && this.getText(n9 - 1, 1).equals("\n")) {
                                            n10 = n9;
                                        }
                                        n11 += rectangle.height;
                                        if (this.tmpPos == null) {
                                            this.tmpPos = new Point(rectangle.x, n11);
                                        } else {
                                            this.tmpPos.x = rectangle.x;
                                            this.tmpPos.y = n11;
                                        }
                                        int n12 = jTextComponent.viewToModel(this.tmpPos);
                                        if (n12 < 0) {
                                            super.insertString(n, string, attributeSet);
                                            return;
                                        }
                                        if (n12 == n9 || (!bl3 ? n12 >= n3 : n < n12)) break;
                                        if (n4-- < 1) {
                                            return;
                                        }
                                        n9 = n12;
                                    }
                                    if (bl3) {
                                        cArray3 = this.getText(n, n3 - n).toCharArray();
                                        n8 = n3 - n;
                                    } else {
                                        cArray3 = null;
                                        n8 = 0;
                                        if (n3 > 0 && this.getText(n3 - 1, 1).equals("\n")) {
                                            if (--n4 < 1) {
                                                return;
                                            }
                                            n9 = n10 = n3;
                                        }
                                    }
                                    if (n > n9) {
                                        cArray2 = this.getText(n9, n - n9).toCharArray();
                                        n7 = n - n9;
                                    } else {
                                        cArray2 = null;
                                        n7 = 0;
                                    }
                                    char[] cArray4 = null;
                                    cArray = string.toCharArray();
                                    n6 = n2;
                                    boolean bl5 = ((JTextArea)object).getWrapStyleWord();
                                    Segment segment = null;
                                    while (true) {
                                        int n13 = n4;
                                        int n14 = n7 + n6 + n8;
                                        if (cArray4 == null) {
                                            cArray4 = new char[n14 + 1];
                                            if (cArray2 != null) {
                                                System.arraycopy(cArray2, 0, cArray4, 0, n7);
                                            }
                                            System.arraycopy(cArray, 0, cArray4, n7, n6);
                                        }
                                        if (cArray3 != null) {
                                            System.arraycopy(cArray3, 0, cArray4, n7 + n6, n8);
                                        }
                                        if (n14 == 0 || cArray4[n14 - 1] != '\n') {
                                            cArray4[n14] = 10;
                                        }
                                        boolean bl6 = false;
                                        if (segment != null) {
                                            segment.offset = 0;
                                        }
                                        int n15 = 0;
                                        while (true) {
                                            int n16;
                                            for (n16 = n15; n16 < n14 && cArray4[n16] != '\n'; ++n16) {
                                            }
                                            if (n16 > n15) {
                                                if (segment == null) {
                                                    segment = new Segment(cArray4, 0, 0);
                                                } else if (segment.offset == 0) {
                                                    segment.array = cArray4;
                                                }
                                                segment.offset = n15;
                                                segment.count = n16 - n15 + 1;
                                                while (segment.count > 1) {
                                                    int n17;
                                                    if (bl5) {
                                                        for (n17 = Utilities.getBreakLocation(segment, fontMetrics, 0, n5, tabExpander, n10 + n15); n17 > 0 && fontMetrics.charsWidth(cArray4, segment.offset, n17) > n5; --n17) {
                                                        }
                                                    } else {
                                                        n17 = Utilities.getTabbedTextOffset(segment, fontMetrics, 0, n5, tabExpander, n10 + n15, false);
                                                        if (n17 < segment.count) {
                                                            while (n17 > 0 && fontMetrics.charsWidth(cArray4, segment.offset, n17 + 1) > n5) {
                                                                --n17;
                                                            }
                                                        }
                                                    }
                                                    if (--n13 < 0) {
                                                        bl6 = true;
                                                        break;
                                                    }
                                                    segment.offset += n17;
                                                    segment.count -= n17;
                                                }
                                                if (bl6) {
                                                    break;
                                                }
                                            } else if (--n13 < 0) {
                                                bl6 = true;
                                                break;
                                            }
                                            if (n16 >= n14) break;
                                            n15 = n16 + 1;
                                        }
                                        if (!bl6) break block53;
                                        if (n6 <= 1) break;
                                        --n6;
                                    }
                                    return;
                                }
                                if (n6 < n2) {
                                    super.insertString(n, String.copyValueOf(cArray, 0, n6), attributeSet);
                                    return;
                                }
                            }
                        }
                    }
                    if (!bl) {
                        int n18;
                        object = this.getText(0, n3);
                        int n19 = 0;
                        while ((n18 = ((String)object).indexOf(10, n19)) >= 0) {
                            if (--n4 < 1) {
                                return;
                            }
                            n19 = n18 + 1;
                        }
                        n19 = 0;
                        while ((n18 = string.indexOf(10, n19)) >= 0) {
                            if (--n4 < 1) {
                                super.insertString(n, string.substring(0, n18), attributeSet);
                                return;
                            }
                            n19 = n18 + 1;
                        }
                    }
                    super.insertString(n, string, attributeSet);
                    break block55;
                }
                if (n4 < 1 || n4 >= n3 + n2) {
                    super.insertString(n, string, attributeSet);
                } else if (n4 > n3) {
                    super.insertString(n, string.substring(0, n4 - n3), attributeSet);
                }
            }
        }
    }

    class EJPasswordField
    extends JPasswordField {
        EJPasswordField() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EEditText.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }

    class EJTextArea
    extends EqTextArea {
        EJTextArea() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EEditText.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }

    class EJTextField
    extends EqTextField {
        EJTextField() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EEditText.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }

    private final class DragDrop
    implements DragDropHandler {
        private DragDrop() {
        }

        public void enableDrag(boolean bl) {
            ((JTextComponent)this.getDragComponent()).setDragEnabled(bl);
        }

        public JComponent getDragComponent() {
            return (JComponent)EEditText.this.peer;
        }

        public void beginDrag() {
            JTextComponent jTextComponent = (JTextComponent)EEditText.this.peer;
            EEditText.this.dragSaveSelectionStart = jTextComponent.getSelectionStart();
            EEditText.this.dragSaveSelectionEnd = jTextComponent.getSelectionEnd();
        }

        public void dragStarting(InputEvent inputEvent) {
            EEditText.this.dragContent = ((JTextComponent)EEditText.this.peer).getSelectedText();
        }

        public void dragFinished(int n) {
        }

        public void dragCanceled() {
            EEditText.this.dragContent = null;
        }

        public void endDrag() {
            JTextComponent jTextComponent = (JTextComponent)EEditText.this.peer;
            if (EEditText.this.dragSaveSelectionStart != EEditText.this.dragSaveSelectionEnd) {
                jTextComponent.select(EEditText.this.dragSaveSelectionStart, EEditText.this.dragSaveSelectionEnd);
                try {
                    jTextComponent.scrollRectToVisible(jTextComponent.modelToView(EEditText.this.dragSaveSelectionStart).union(jTextComponent.modelToView(EEditText.this.dragSaveSelectionEnd)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public boolean acceptDrop(TransferHandler.TransferSupport transferSupport) {
            return true;
        }

        public boolean dropped(TransferHandler.TransferSupport transferSupport) {
            JTextComponent.DropLocation dropLocation = (JTextComponent.DropLocation)transferSupport.getDropLocation();
            EEditText.this.dropCx = dropLocation.getIndex();
            EEditText.this.dropCy = 0;
            if (EEditText.this.multiline) {
                int n;
                int n2;
                EEditText.this.updateContent(null);
                int n3 = 0;
                while ((n2 = EEditText.this.content.indexOf(10, n3)) >= 0 && (n = n2 - n3) < EEditText.this.dropCx) {
                    EEditText.this.dropCx = EEditText.this.dropCx - (n + 1);
                    EEditText.this.dropCy++;
                    n3 = n2 + 1;
                }
            }
            return true;
        }
    }

    private final class AutoTabTimer
    implements ActionListener {
        private AutoTabTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EEditText.this.autoTabTimer != null) {
                int n = EEditText.this.autoTabScheduledMode;
                EEditText.this.autoTabScheduledMode = 0;
                EEditText.this.autoTabAction(n);
            }
        }
    }

    private final class VerticalScrollBarVisibleTimer
    implements ActionListener {
        private VerticalScrollBarVisibleTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EEditText.this.verticalScrollBarVisibleTimer != null) {
                EEditText.this.verticalScrollBarVisibleTimer = null;
                EEditText.this.scrollToCaret();
            }
        }
    }

    private final class HorizontalScrollBarVisibleTimer
    implements ActionListener {
        private HorizontalScrollBarVisibleTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EEditText.this.horizontalScrollBarVisibleTimer != null) {
                EEditText.this.horizontalScrollBarVisibleTimer = null;
                EEditText.this.scrollToCaret();
            }
        }
    }
}

