/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.DragDropHandler;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EJScrollPane;
import com.eloquence.services.protocols.dlg.Dlg;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class EHTMLViewer
extends AbstractControl
implements KeyListener,
MouseListener,
HyperlinkListener {
    private static HashMap attributeList = new HashMap();
    private static final int CONTENT_ATTR_ID = 0;
    private static final int URL_ATTR_ID = 1;
    private static final int MIMETYPE_ATTR_ID = 2;
    private static final int ADD_ATTR_ID = 3;
    private static final int CLEAR_ATTR_ID = 4;
    private static final int LASTLINKFRAGMENT_ATTR_ID = 5;
    private static final int RULEDEFAULT_ATTR_ID = 6;
    private static final int BORDER_ATTR_ID = 7;
    private static final int DRAG_CONTENT_ATTR_ID = 8;
    private static final int DROP_CX_ATTR_ID = 9;
    private static final int DROP_CY_ATTR_ID = 10;
    private static final int DROP_ELEMENT_ATTR_ID = 11;
    public static final String CLASS_ATTR_NAME = "HTMLView";
    public static final String CONTENT_ATTR_NAME = "content";
    public static final String MIMETYPE_ATTR_NAME = "mimetype";
    protected String mime_type = "text/html";
    public static final String ADD_ATTR_NAME = "add";
    protected String content = "";
    public static final String CLEAR_ATTR_NAME = "clear";
    public static final String URL_ATTR_NAME = "url";
    protected String surl = "";
    protected URL url = null;
    public static final String LASTLINKFRAGMENT_ATTR_NAME = "lastlinkfragment";
    public static final String RULEDEFAULT_ATTR_NAME = "rule";
    int ruleDefault = 0;
    public static final String BORDER_ATTR_NAME = "border";
    private int border = 2;
    private int effectiveBorder = 2;
    private Border borderHtmlCtrl = null;
    private Border borderHtmlCtrlEmpty = null;
    private Border borderScrollPane = null;
    private Border borderScrollPaneEmpty = null;
    private static final String DRAG_CONTENT_ATTR_NAME = "dragcontent";
    private static final String DROP_CX_ATTR_NAME = "dropcx";
    private static final String DROP_CY_ATTR_NAME = "dropcy";
    private static final String DROP_ELEMENT_ATTR_NAME = "dropelement";
    private String dragContent = null;
    private String dropElement = null;
    private int dropCx = -1;
    private int dropCy = -1;
    private int dragSaveSelectionStart = 0;
    private int dragSaveSelectionEnd = 0;
    public static final int RULE_HANDLING_ERROR = 0;
    public static final int RULE_HANDLING_DEFAULT = 1;
    public static final int RULE_HANDLING_SPECIAL = 2;
    protected static Set allowed_mimetypes = null;
    protected String lastLinkFragment = "";
    protected EJScrollPane sp = null;
    protected EJEditorPane htmlCtrl = new EJEditorPane();
    protected int lastCursor = 0;
    protected int specialized_rule = 0;
    protected int rule_handling = 0;
    static final int asyncPrio = 1;
    private boolean contentModified = false;
    private boolean inClone = false;

    public EHTMLViewer() {
        this.htmlCtrl.setEditable(false);
        this.htmlCtrl.addKeyListener(this);
        this.htmlCtrl.addMouseListener(this);
        this.htmlCtrl.addHyperlinkListener(this);
        this.htmlCtrl.setContentType("text/html");
        this.htmlCtrl.setFocusTraversalKeysEnabled(false);
        this.sp = new EJScrollPane(this.htmlCtrl, this);
        this.sp.setControl(this);
        this.peer = this.sp;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            if (this.sp != null) {
                this.sp.setControl(null);
                this.sp = null;
            }
            if (this.htmlCtrl != null) {
                this.htmlCtrl.removeKeyListener(this);
                this.htmlCtrl.removeMouseListener(this);
                this.htmlCtrl.removeHyperlinkListener(this);
            }
            super.dispose();
            this.content = null;
            this.mime_type = null;
            this.surl = null;
            this.url = null;
            this.borderHtmlCtrl = null;
            this.borderHtmlCtrlEmpty = null;
            this.borderScrollPane = null;
            this.borderScrollPaneEmpty = null;
        }
    }

    public Object clone() {
        EHTMLViewer eHTMLViewer = new EHTMLViewer();
        this.cloneAttributes(eHTMLViewer);
        return eHTMLViewer;
    }

    public void cloneAttributes(EHTMLViewer eHTMLViewer) {
        eHTMLViewer.inClone = true;
        super.cloneAttributes(eHTMLViewer);
        eHTMLViewer.setContent(this.getContent());
        eHTMLViewer.setUrl(this.getUrl());
        eHTMLViewer.setMimeType(this.getMimeType());
        eHTMLViewer.setRuleDefault(this.getRuleDefault());
        eHTMLViewer.setBorder(this.getBorder());
        eHTMLViewer.inClone = false;
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setContent(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setUrl(sET.getValueString());
                    break;
                }
                case 2: {
                    this.setMimeType(sET.getValueString());
                    break;
                }
                case 3: {
                    this.setAdd(sET.getValueString());
                    break;
                }
                case 4: {
                    this.setClear();
                    break;
                }
                case 6: {
                    this.setRuleDefault(sET.getValueInt());
                    break;
                }
                case 7: {
                    this.setBorder(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getContent());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getUrl());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getMimeType());
                    break;
                }
                case 5: {
                    gET2.setValueString(this.getLastLinkFragment());
                    break;
                }
                case 6: {
                    gET2.setValueInt(this.getRuleDefault());
                    break;
                }
                case 7: {
                    gET2.setValueInt(this.getBorder());
                    break;
                }
                case 8: {
                    gET2.setValueString(this.getDragContent());
                    break;
                }
                case 9: {
                    gET2.setValueInt(this.getDropCx());
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getDropCy());
                    break;
                }
                case 11: {
                    gET2.setValueString(this.getDropElement());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        if (bl) {
            this.dragContent = null;
            this.dropElement = null;
            this.dropCy = -1;
            this.dropCx = -1;
        }
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        if (this.parent != null && this.parent.isInDlgDo()) {
            this.lastLinkFragment = "";
        }
        if (this.border != this.effectiveBorder) {
            if (this.border > 1) {
                if (this.effectiveBorder != 2) {
                    if (this.borderHtmlCtrl != null) {
                        this.htmlCtrl.setBorder(this.borderHtmlCtrl);
                    }
                    if (this.borderScrollPane != null) {
                        this.sp.setBorder(this.borderScrollPane);
                    }
                    this.effectiveBorder = 2;
                }
            } else {
                if (this.borderHtmlCtrl == null) {
                    this.borderHtmlCtrl = this.htmlCtrl.getBorder();
                }
                if (this.borderHtmlCtrlEmpty == null) {
                    this.borderHtmlCtrlEmpty = BorderFactory.createEmptyBorder();
                }
                if (this.border < 1) {
                    if (this.borderScrollPane == null) {
                        this.borderScrollPane = this.sp.getBorder();
                    }
                    if (this.borderScrollPaneEmpty == null) {
                        this.borderScrollPaneEmpty = BorderFactory.createEmptyBorder();
                    }
                    if (this.effectiveBorder != 0) {
                        this.htmlCtrl.setBorder(this.borderHtmlCtrlEmpty);
                        this.sp.setBorder(this.borderScrollPaneEmpty);
                        this.effectiveBorder = 0;
                    }
                } else if (this.effectiveBorder != 1) {
                    this.htmlCtrl.setBorder(this.borderHtmlCtrlEmpty);
                    if (this.borderScrollPane != null) {
                        this.sp.setBorder(this.borderScrollPane);
                    }
                    this.effectiveBorder = 1;
                }
            }
        }
        if (this.contentModified) {
            try {
                if (this.content.length() == 0) {
                    if (this.url != null && this.surl.length() > 0) {
                        this.htmlCtrl.setContentType("text/plain");
                        this.htmlCtrl.setText("");
                        Thread thread = new Thread(StartUp.systemThreadGroup, new Runnable(){

                            public void run() {
                                try {
                                    Thread.sleep(100L);
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            try {
                                                ((AbstractDocument)EHTMLViewer.this.htmlCtrl.getDocument()).setAsynchronousLoadPriority(1);
                                                EHTMLViewer.this.htmlCtrl.setPage(EHTMLViewer.this.url);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                    } else if (this.url == null) {
                        this.htmlCtrl.setContentType("text/html");
                        this.htmlCtrl.setText("");
                    }
                } else if (!this.content.equals(this.htmlCtrl.getText())) {
                    this.htmlCtrl.setContentType(this.mime_type);
                    this.htmlCtrl.setText(this.content);
                    this.htmlCtrl.setCaretPosition(0);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.contentModified = false;
        }
        super.eloq2swing(bl);
    }

    protected boolean handleEloqSchema(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getURL() != null) {
            return false;
        }
        if (this.parseEloqSchema(hyperlinkEvent.getDescription())) {
            switch (this.rule_handling) {
                case 1: {
                    this.rule = this.ruleDefault;
                    this.getRuleManager().fireRule(this);
                    break;
                }
                case 2: {
                    this.rule = this.specialized_rule;
                    this.getRuleManager().fireRule(this);
                    break;
                }
                default: {
                    throw new Error("unexpected rule_handling (" + this.rule_handling + ")");
                }
            }
        }
        return true;
    }

    protected boolean parseEloqSchema(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/", true);
        this.rule_handling = 0;
        this.lastLinkFragment = "";
        this.specialized_rule = 0;
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equals("eloq") && stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equals(":")) {
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("/")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = "";
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = string2 + stringTokenizer.nextToken();
                        }
                        this.lastLinkFragment = string2;
                    } else {
                        this.lastLinkFragment = "";
                    }
                    this.specialized_rule = 0;
                    this.rule_handling = 1;
                    return true;
                }
                try {
                    this.specialized_rule = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.specialized_rule = 0;
                    return false;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("/")) {
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = "";
                            while (stringTokenizer.hasMoreTokens()) {
                                string2 = string2 + stringTokenizer.nextToken();
                            }
                            this.lastLinkFragment = string2;
                            this.rule_handling = 2;
                            return true;
                        }
                        this.rule_handling = 2;
                        this.lastLinkFragment = "";
                        return true;
                    }
                    return false;
                }
                this.rule_handling = 2;
                return true;
            }
            this.rule_handling = 1;
            return true;
        }
        return false;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (!this.handleEloqSchema(hyperlinkEvent)) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                ((AbstractDocument)jEditorPane.getDocument()).setAsynchronousLoadPriority(1);
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        this.url = hyperlinkEvent.getURL();
                        if (this.url != null) {
                            this.surl = this.url.toExternalForm();
                            jEditorPane.setPage(this.url);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.peer.setCursor(Cursor.getPredefinedCursor(this.lastCursor));
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.lastCursor = this.peer.getCursor().getType();
            this.htmlCtrl.setCursor(Cursor.getPredefinedCursor(12));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.htmlCtrl.setCursor(Cursor.getPredefinedCursor(this.lastCursor));
        }
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setContent(String string) {
        if (string.length() == 0) {
            if (!this.inClone) {
                this.setClear();
            }
            return;
        }
        this.content = string;
        this.surl = "";
        this.url = null;
        this.contentModified = true;
        this.isModified = true;
    }

    public String getContent() {
        if (this.content.length() > 0) {
            return this.content;
        }
        if (this.url != null && this.surl.length() > 0) {
            return this.htmlCtrl.getText();
        }
        return "";
    }

    public void setMimeType(String string) {
        this.mime_type = allowed_mimetypes.contains(string = string.toLowerCase()) ? string : "text/html";
        this.isModified = true;
    }

    public String getMimeType() {
        return this.mime_type;
    }

    public void setAdd(String string) {
        this.setContent(this.content + string);
    }

    public void setClear() {
        this.content = "";
        this.surl = "";
        this.url = null;
        this.contentModified = true;
        this.isModified = true;
    }

    public void setUrl(String string) {
        if (string == null || string.length() == 0) {
            if (!this.inClone) {
                this.setClear();
            }
            return;
        }
        this.surl = string;
        this.url = this.createExpandedURL(string);
        if (this.url == null) {
            this.surl = "";
        }
        this.content = "";
        this.contentModified = true;
        this.isModified = true;
    }

    public String getUrl() {
        if (this.surl.length() > 0 && this.content.length() == 0) {
            return this.surl;
        }
        return "";
    }

    public String getLastLinkFragment() {
        return this.lastLinkFragment;
    }

    public int getRuleDefault() {
        return this.ruleDefault;
    }

    public void setRuleDefault(int n) {
        this.ruleDefault = n;
    }

    public void setBorder(int n) {
        this.border = n;
        this.isModified = true;
    }

    public int getBorder() {
        return this.border;
    }

    private final String getDragContent() {
        return this.dragContent != null ? this.dragContent : "";
    }

    private final String getDropElement() {
        return this.dropElement != null ? this.dropElement : "";
    }

    private final int getDropCx() {
        return this.dropCx;
    }

    private final int getDropCy() {
        return this.dropCy;
    }

    private String findHtmlElement(Element element, int n) {
        if (n >= element.getStartOffset() && n < element.getEndOffset()) {
            if (element.isLeaf()) {
                Object object = element.getAttributes().getAttribute(HTML.Attribute.ID);
                return object != null ? object.toString().trim() : "";
            }
            int n2 = element.getElementCount();
            for (int i = 0; i < n2; ++i) {
                String string = this.findHtmlElement(element.getElement(i), n);
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    public void enableDragDrop() {
        this.setDragDropHandler(new DragDrop());
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    static {
        allowed_mimetypes = new TreeSet();
        allowed_mimetypes.add("text/html");
        allowed_mimetypes.add("text/plain");
        attributeList.put(CONTENT_ATTR_NAME, new Integer(0));
        attributeList.put(URL_ATTR_NAME, new Integer(1));
        attributeList.put(MIMETYPE_ATTR_NAME, new Integer(2));
        attributeList.put(ADD_ATTR_NAME, new Integer(3));
        attributeList.put(CLEAR_ATTR_NAME, new Integer(4));
        attributeList.put(LASTLINKFRAGMENT_ATTR_NAME, new Integer(5));
        attributeList.put(RULEDEFAULT_ATTR_NAME, new Integer(6));
        attributeList.put(BORDER_ATTR_NAME, new Integer(7));
        attributeList.put(DRAG_CONTENT_ATTR_NAME, new Integer(8));
        attributeList.put(DROP_CX_ATTR_NAME, new Integer(9));
        attributeList.put(DROP_CY_ATTR_NAME, new Integer(10));
        attributeList.put(DROP_ELEMENT_ATTR_NAME, new Integer(11));
    }

    class EJEditorPane
    extends JEditorPane {
        EJEditorPane() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (EHTMLViewer.this.ignoreEvent(aWTEvent)) {
                return;
            }
            super.processEvent(aWTEvent);
        }
    }

    private final class DragDrop
    implements DragDropHandler {
        private DragDrop() {
        }

        public void enableDrag(boolean bl) {
            ((JTextComponent)this.getDragComponent()).setDragEnabled(bl);
        }

        public JComponent getDragComponent() {
            return EHTMLViewer.this.htmlCtrl;
        }

        public void beginDrag() {
            EHTMLViewer.this.dragSaveSelectionStart = EHTMLViewer.this.htmlCtrl.getSelectionStart();
            EHTMLViewer.this.dragSaveSelectionEnd = EHTMLViewer.this.htmlCtrl.getSelectionEnd();
        }

        public void dragStarting(InputEvent inputEvent) {
            EHTMLViewer.this.dragContent = EHTMLViewer.this.htmlCtrl.getSelectedText();
        }

        public void dragFinished(int n) {
        }

        public void dragCanceled() {
            EHTMLViewer.this.dragContent = null;
        }

        public void endDrag() {
            if (EHTMLViewer.this.dragSaveSelectionStart != EHTMLViewer.this.dragSaveSelectionEnd) {
                EHTMLViewer.this.htmlCtrl.select(EHTMLViewer.this.dragSaveSelectionStart, EHTMLViewer.this.dragSaveSelectionEnd);
                try {
                    EHTMLViewer.this.htmlCtrl.scrollRectToVisible(EHTMLViewer.this.htmlCtrl.modelToView(EHTMLViewer.this.dragSaveSelectionStart).union(EHTMLViewer.this.htmlCtrl.modelToView(EHTMLViewer.this.dragSaveSelectionEnd)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public boolean acceptDrop(TransferHandler.TransferSupport transferSupport) {
            return true;
        }

        public boolean dropped(TransferHandler.TransferSupport transferSupport) {
            int n;
            int n2;
            JTextComponent.DropLocation dropLocation = (JTextComponent.DropLocation)transferSupport.getDropLocation();
            int n3 = dropLocation.getIndex();
            Document document = EHTMLViewer.this.htmlCtrl.getDocument();
            if (document instanceof HTMLDocument) {
                EHTMLViewer.this.dropElement = EHTMLViewer.this.findHtmlElement(((HTMLDocument)document).getDefaultRootElement(), n3);
            }
            EHTMLViewer.this.dropCx = n3;
            EHTMLViewer.this.dropCy = 0;
            String string = EHTMLViewer.this.getContent();
            int n4 = 0;
            while ((n2 = string.indexOf(10, n4)) >= 0 && (n = n2 - n4) < EHTMLViewer.this.dropCx) {
                EHTMLViewer.this.dropCx = EHTMLViewer.this.dropCx - (n + 1);
                EHTMLViewer.this.dropCy++;
                n4 = n2 + 1;
            }
            return true;
        }
    }
}

