/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.ControlConstants;
import com.eloquence.services.jdlg.controls.EMenuItem;
import com.eloquence.services.jdlg.controls.PositionInterface;
import com.eloquence.services.jdlg.controls.TextPositionSetter;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.HtmlTool;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

public class EMenu
extends AbstractControlContainer {
    private boolean isHelpMenu = false;
    private boolean isClonedHelpMenu = false;
    public static final String CLASS_ATTR_NAME = "Menu";
    protected String origTitle = "";
    protected int mnemonicKey = -1;
    public static final String ICON_ATTR_NAME = "icon";
    private String icon = "";
    private ImageIcon imageIcon = null;
    public static final String TEXTPOS_ATTR_NAME = "textpos";
    private String textpos = "";
    private static final int TITLE_ATTR_ID = 0;
    private static final int ICON_ATTR_ID = 1;
    private static final int TEXTPOS_ATTR_ID = 2;
    private static HashMap attributeList = new HashMap();

    public EMenu() {
        EJMenu eJMenu = new EJMenu();
        this.setTitle(CLASS_ATTR_NAME);
        this.peer = eJMenu;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            ((JMenu)this.peer).removeAll();
            this.title = null;
            this.imageIcon = null;
            this.textpos = null;
            super.dispose();
        }
    }

    public Object clone() {
        EMenu eMenu = new EMenu();
        this.cloneAttributes(eMenu);
        return eMenu;
    }

    public void copyState(EMenu eMenu) {
        ListIterator listIterator = this.children.listIterator();
        ListIterator listIterator2 = eMenu.children.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            AbstractControl abstractControl2 = (AbstractControl)listIterator2.next();
            if (!abstractControl.getClass().equals(abstractControl2.getClass()) || !abstractControl.getId().equalsIgnoreCase(abstractControl2.getId())) break;
            if (abstractControl instanceof EMenu) {
                ((EMenu)abstractControl).copyState((EMenu)abstractControl2);
                continue;
            }
            if (!(abstractControl instanceof EMenuItem)) break;
            ((EMenuItem)abstractControl).copyState((EMenuItem)abstractControl2);
        }
    }

    public void eloq2swing(boolean bl) {
        if (this.isModified) {
            JMenu jMenu = (JMenu)this.peer;
            if (this.title != null && !this.title.equals(jMenu.getText())) {
                try {
                    jMenu.setText(this.title);
                }
                catch (Throwable throwable) {
                    System.err.println("'" + this.getPath() + "' " + throwable + ": Menu = \"" + this.title + "\"");
                    jMenu.setText(HtmlTool.text(this.title));
                }
            }
            if (this.mnemonicKey != -1) {
                jMenu.setMnemonic(this.mnemonicKey);
            } else {
                jMenu.setMnemonic(0);
            }
            jMenu.setOpaque(this.bgc != null);
            if (this.imageIcon != null && !this.imageIcon.equals(jMenu.getIcon())) {
                jMenu.setIcon(this.imageIcon);
            }
            this.eloq2swingTextpos();
        }
        super.eloq2swing(bl);
    }

    private final void eloq2swingTextpos() {
        if (this.textpos.length() > 0) {
            if (this.imageIcon != null && this.textpos.equalsIgnoreCase("center")) {
                this.textpos = "right";
            }
            TextPositionSetter textPositionSetter = new TextPositionSetter((PositionInterface)((Object)this.peer), this.textpos);
            textPositionSetter.execute();
            textPositionSetter.dispose();
        }
    }

    public boolean ignoreEvent(AWTEvent aWTEvent) {
        if (this.contextControl != null) {
            return false;
        }
        return super.ignoreEvent(aWTEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.consumeRightMouseButtonEvent(mouseEvent);
    }

    protected boolean doContextMenu(AbstractControl abstractControl, MouseEvent mouseEvent) {
        return false;
    }

    public boolean add(Object object) {
        if (!(object instanceof EMenu) && !(object instanceof EMenuItem)) {
            return false;
        }
        AbstractControl abstractControl = (AbstractControl)object;
        ((JMenu)this.peer).add(abstractControl.getPeer());
        abstractControl.setFontReference(this.fontReference);
        return this.children.add(object);
    }

    public boolean remove(Object object) {
        if (this.peer != null && object != null) {
            ((JMenu)this.peer).remove(((AbstractControl)object).getPeer());
        }
        if (this.children != null) {
            return this.children.remove(object);
        }
        return true;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public void setId(String string) {
        this.isHelpMenu = string.equalsIgnoreCase("help");
        super.setId(string);
    }

    public boolean isHelpMenu() {
        return this.isHelpMenu || this.isClonedHelpMenu;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        c = this.getAcceleratorChar(string, stringBuffer);
        if (c == '\u0000') {
            this.title = string;
            this.origTitle = "";
            this.mnemonicKey = -1;
        } else {
            this.title = stringBuffer.toString();
            this.origTitle = string;
            this.mnemonicKey = c;
        }
        this.isModified = true;
    }

    public String getTitle() {
        if (this.origTitle.length() > 0) {
            return this.origTitle;
        }
        return this.title;
    }

    private void setIcon(String string) {
        URL uRL;
        if (string != null && string.length() > 0 && (uRL = this.createExpandedURL(string)) != null) {
            this.imageIcon = new ImageIcon(uRL);
            if (this.imageIcon != null) {
                this.icon = string;
                this.isModified = true;
                return;
            }
        }
        this.icon = "";
        this.imageIcon = null;
        this.isModified = true;
    }

    private String getIcon() {
        return this.icon;
    }

    private void setTextpos(String string) {
        if (ControlConstants.isPosition(string)) {
            this.textpos = string;
            this.isModified = true;
        }
    }

    private String getTextpos() {
        return this.textpos;
    }

    protected void cloneAttributes(EMenu eMenu) {
        super.cloneAttributes(eMenu);
        eMenu.setTitle(this.getTitle());
        eMenu.isClonedHelpMenu = this.isHelpMenu;
        eMenu.setIcon(this.getIcon());
        eMenu.setTextpos(this.getTextpos());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setTitle(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setIcon(sET.getValueString());
                    break;
                }
                case 2: {
                    this.setTextpos(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getTitle());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getIcon());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getTextpos());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    static {
        attributeList.put("title", new Integer(0));
        attributeList.put(ICON_ATTR_NAME, new Integer(1));
        attributeList.put(TEXTPOS_ATTR_NAME, new Integer(2));
    }

    class EJMenu
    extends JMenu
    implements PositionInterface {
        EJMenu() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EMenu.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

