/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.ControlConstants;
import com.eloquence.services.jdlg.controls.PositionInterface;
import com.eloquence.services.jdlg.controls.TextPositionSetter;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.HtmlTool;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class EMenuItem
extends AbstractControl
implements ActionListener,
ItemListener {
    private static HashMap attributeList = new HashMap();
    private static final int TITLE_ATTR_ID = 0;
    private static final int ACCELERATOR_ATTR_ID = 1;
    private static final int TYPE_ATTR_ID = 2;
    private static final int ACTIVE_ATTR_ID = 3;
    private static final int ACTIVEBTN_ATTR_ID = 4;
    private static final int ICON_ATTR_ID = 5;
    private static final int TEXTPOS_ATTR_ID = 6;
    public static final String CLASS_ATTR_NAME = "MenuItem";
    public static final String TITLE_ATTR_NAME = "title";
    protected String title = "";
    protected String orgTitle = "";
    protected int mnemonicKey = -1;
    public static final String ACCELERATOR_ATTR_NAME = "accelerator";
    protected String accelerator = "";
    protected KeyStroke keyStroke = null;
    boolean keyStrokeModified = false;
    public static final String TYPE_ATTR_NAME = "type";
    public static final String ITEM_TYPE = "item";
    public static final String CHECK_BOX_TYPE = "checkbox";
    public static final String RADIO_BUTTON_TYPE = "radiobutton";
    public static final String SEPARATOR_TYPE = "separator";
    protected String type = "item";
    public static final String ACTIVE_ATTR_NAME = "active";
    public static final String ACTIVEBTN_ATTR_NAME = "activebtn";
    protected boolean active = false;
    public static final String ICON_ATTR_NAME = "icon";
    private String icon = "";
    private ImageIcon imageIcon = null;
    public static final String TEXTPOS_ATTR_NAME = "textpos";
    private String textpos = "";

    public EMenuItem() {
        EJMenuItem eJMenuItem = new EJMenuItem();
        eJMenuItem.addActionListener(this);
        eJMenuItem.addItemListener(this);
        this.peer = eJMenuItem;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            if (this.peer instanceof JMenuItem) {
                ((JMenuItem)this.peer).removeActionListener(this);
                ((JMenuItem)this.peer).removeItemListener(this);
                ((JMenuItem)this.peer).setMnemonic(0);
            }
            if (this.peer instanceof JRadioButtonMenuItem) {
                this.getParent().getBoxGroup().remove((AbstractButton)this.peer);
            }
            super.dispose();
            this.title = null;
            this.type = null;
            this.accelerator = null;
            this.keyStroke = null;
            this.icon = null;
            this.imageIcon = null;
            this.textpos = null;
        }
    }

    public Object clone() {
        EMenuItem eMenuItem = new EMenuItem();
        this.cloneAttributes(eMenuItem);
        return eMenuItem;
    }

    protected void cloneAttributes(EMenuItem eMenuItem) {
        super.cloneAttributes(eMenuItem);
        eMenuItem.setTitle(this.getTitle());
        eMenuItem.setAccelerator(this.getAccelerator());
        eMenuItem.setType(this.getType());
        eMenuItem.setActive(this.getActive());
        eMenuItem.setIcon(this.getIcon());
        eMenuItem.setTextpos(this.getTextpos());
    }

    public void copyState(EMenuItem eMenuItem) {
        eMenuItem.active = this.active;
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setTitle(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setAccelerator(sET.getValueString());
                    break;
                }
                case 2: {
                    this.setType(sET.getValueString());
                    break;
                }
                case 3: {
                    this.setActive(sET.getValueInt());
                    break;
                }
                case 5: {
                    this.setIcon(sET.getValueString());
                    break;
                }
                case 6: {
                    this.setTextpos(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getTitle());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getAccelerator());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getType());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getActive());
                    break;
                }
                case 4: {
                    gET2.setValueString(this.return_ID(this.getActivebtn()));
                    break;
                }
                case 5: {
                    gET2.setValueString(this.getIcon());
                    break;
                }
                case 6: {
                    gET2.setValueString(this.getTextpos());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public boolean ignoreEvent(AWTEvent aWTEvent) {
        if (this.contextControl != null) {
            return false;
        }
        return super.ignoreEvent(aWTEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.consumeRightMouseButtonEvent(mouseEvent);
    }

    protected boolean doContextMenu(AbstractControl abstractControl, MouseEvent mouseEvent) {
        return false;
    }

    public void eloq2swing(boolean bl) {
        Serializable serializable;
        int n;
        Object object;
        Container container;
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        if (!this.typeMatchesPeer()) {
            container = this.peer.getParent();
            object = container.getComponents();
            for (n = 0; n < ((Component[])object).length && object[n] != this.peer; ++n) {
            }
            container.remove(n);
            Serializable serializable2 = serializable = this.peer instanceof JMenuItem ? (JMenuItem)this.peer : null;
            if (serializable != null) {
                ((AbstractButton)serializable).removeActionListener(this);
                ((AbstractButton)serializable).removeItemListener(this);
                ((AbstractButton)serializable).setMnemonic(0);
                ((JComponent)serializable).resetKeyboardActions();
            }
            if (this.peer instanceof JRadioButtonMenuItem) {
                this.getParent().getBoxGroup().remove((AbstractButton)this.peer);
            }
            serializable = null;
            Font font = null;
            if (this.type.equalsIgnoreCase(ITEM_TYPE)) {
                font = this.peer.getFont();
                serializable = new EJMenuItem();
            } else if (this.type.equalsIgnoreCase(CHECK_BOX_TYPE)) {
                font = this.peer.getFont();
                serializable = new EJCheckBoxMenuItem();
            } else if (this.type.equalsIgnoreCase(RADIO_BUTTON_TYPE)) {
                font = this.peer.getFont();
                serializable = new EJRadioButtonMenuItem();
                this.getParent().getBoxGroup().add((AbstractButton)serializable);
            } else if (this.type.equalsIgnoreCase(SEPARATOR_TYPE)) {
                this.peer = new JPopupMenu.Separator();
            }
            if (serializable != null) {
                this.peer = serializable;
                ((AbstractButton)serializable).addActionListener(this);
                ((AbstractButton)serializable).addItemListener(this);
                if (font != null) {
                    ((JComponent)serializable).setFont(font);
                }
                if (this.keyStroke != null) {
                    this.keyStrokeModified = true;
                }
            }
            container.add(this.peer, n);
        }
        if (!(this.peer instanceof JPopupMenu.Separator)) {
            container = (JMenuItem)this.peer;
            if (this.title != null && !this.title.equals(((AbstractButton)container).getText())) {
                try {
                    ((AbstractButton)container).setText(this.title);
                }
                catch (Throwable throwable) {
                    System.err.println("'" + this.getPath() + "' " + throwable + ": MenuItem = \"" + this.title + "\"");
                    ((AbstractButton)container).setText(HtmlTool.text(this.title));
                }
            }
            if (this.mnemonicKey > 0) {
                ((AbstractButton)container).setMnemonic(this.mnemonicKey);
            } else {
                ((AbstractButton)container).setMnemonic(0);
            }
            if (this.keyStrokeModified) {
                this.keyStrokeModified = false;
                ((JComponent)container).resetKeyboardActions();
                ((JMenuItem)container).setAccelerator(this.keyStroke);
                if (this.keyStroke != null) {
                    object = ((JComponent)container).getInputMap(2);
                    ((InputMap)object).put(this.keyStroke, "KEY_ACCELERATOR_ACTION_CMD");
                    n = this.keyStroke.getKeyCode();
                    if (n >= 48 && n <= 57) {
                        serializable = KeyStroke.getKeyStroke(n += 48, this.keyStroke.getModifiers());
                        ((InputMap)object).put((KeyStroke)serializable, "KEY_ACCELERATOR_ACTION_CMD");
                    }
                    ((JComponent)container).getActionMap().put("KEY_ACCELERATOR_ACTION_CMD", new AbstractControl.AccelAction());
                }
            }
            if (this.imageIcon != null && !this.imageIcon.equals(((AbstractButton)container).getIcon())) {
                ((AbstractButton)container).setIcon(this.imageIcon);
            }
            if (((AbstractButton)container).isSelected() != this.active) {
                ((AbstractButton)container).setSelected(this.active);
            }
            this.eloq2swingTextpos();
        }
        super.eloq2swing(bl);
    }

    private final void eloq2swingTextpos() {
        if (this.textpos.length() > 0) {
            if (this.imageIcon != null && this.textpos.equalsIgnoreCase("center")) {
                this.textpos = "right";
            }
            TextPositionSetter textPositionSetter = new TextPositionSetter((PositionInterface)((Object)this.peer), this.textpos);
            textPositionSetter.execute();
            textPositionSetter.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ((this.active || !(this.peer instanceof JRadioButtonMenuItem)) && this.getRule() != 0) {
            ControlsManager.RuleManager ruleManager = this.getRuleManager();
            if (this.contextControl != null) {
                ruleManager.prepareOverride(this);
                if (ruleManager.fireRule(this.contextControl)) {
                    ruleManager.fireRule(this);
                }
            } else {
                ruleManager.fireRule(this);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.active = itemEvent.getStateChange() == 1;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.getAcceleratorChar(string, stringBuffer);
        if (c != '\u0000') {
            this.orgTitle = string;
            this.title = stringBuffer.toString();
            this.mnemonicKey = c;
        } else {
            this.orgTitle = "";
            this.title = string;
            this.mnemonicKey = -1;
        }
        this.isModified = true;
    }

    public String getTitle() {
        if (this.orgTitle.length() == 0) {
            return this.title;
        }
        return this.orgTitle;
    }

    public void setAccelerator(String string) {
        if (string != null && string.length() > 0) {
            try {
                this.keyStroke = KeyStroke.getKeyStroke(string);
                this.accelerator = string;
                this.isModified = true;
                this.keyStrokeModified = true;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.keyStroke = null;
        this.accelerator = "";
        this.isModified = true;
        this.keyStrokeModified = true;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public boolean typeMatchesPeer() {
        if (this.type.equalsIgnoreCase(ITEM_TYPE)) {
            return this.peer instanceof JMenuItem;
        }
        if (this.type.equalsIgnoreCase(CHECK_BOX_TYPE)) {
            return this.peer instanceof JCheckBoxMenuItem;
        }
        if (this.type.equalsIgnoreCase(RADIO_BUTTON_TYPE)) {
            return this.peer instanceof JRadioButtonMenuItem;
        }
        if (this.type.equalsIgnoreCase(SEPARATOR_TYPE)) {
            return this.peer instanceof JPopupMenu.Separator;
        }
        return false;
    }

    public void setType(String string) {
        this.type = string.equalsIgnoreCase(CHECK_BOX_TYPE) || string.equalsIgnoreCase(RADIO_BUTTON_TYPE) || string.equalsIgnoreCase(SEPARATOR_TYPE) ? string : ITEM_TYPE;
        this.isModified = true;
    }

    public String getType() {
        return this.type;
    }

    public void setActive(int n) {
        this.active = n != 0;
        this.isModified = true;
    }

    public int getActive() {
        return this.active ? 1 : 0;
    }

    public String getActivebtn() {
        if (this.peer instanceof JRadioButtonMenuItem) {
            if (this.active) {
                return this.getPath();
            }
            if (this.parent != null) {
                ListIterator listIterator = this.parent.children.listIterator();
                while (listIterator.hasNext()) {
                    Component component;
                    AbstractControl abstractControl = (AbstractControl)listIterator.next();
                    if (abstractControl == this || !(abstractControl instanceof EMenuItem) || (component = abstractControl.getPeer()) == null || !(component instanceof JRadioButtonMenuItem) || !((EMenuItem)abstractControl).active) continue;
                    return abstractControl.getPath();
                }
            }
        }
        return "";
    }

    private void setIcon(String string) {
        URL uRL;
        if (string != null && string.length() > 0 && (uRL = this.createExpandedURL(string)) != null) {
            this.imageIcon = new ImageIcon(uRL);
            if (this.imageIcon != null) {
                this.icon = string;
                this.isModified = true;
                return;
            }
        }
        this.icon = "";
        this.imageIcon = null;
        this.isModified = true;
    }

    private String getIcon() {
        return this.icon;
    }

    private void setTextpos(String string) {
        if (ControlConstants.isPosition(string)) {
            this.textpos = string;
            this.isModified = true;
        }
    }

    private String getTextpos() {
        return this.textpos;
    }

    static {
        attributeList.put(TITLE_ATTR_NAME, new Integer(0));
        attributeList.put(ACCELERATOR_ATTR_NAME, new Integer(1));
        attributeList.put(TYPE_ATTR_NAME, new Integer(2));
        attributeList.put(ACTIVE_ATTR_NAME, new Integer(3));
        attributeList.put(ACTIVEBTN_ATTR_NAME, new Integer(4));
        attributeList.put(ICON_ATTR_NAME, new Integer(5));
        attributeList.put(TEXTPOS_ATTR_NAME, new Integer(6));
    }

    class EJRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements PositionInterface {
        public void processEvent(AWTEvent aWTEvent) {
            if (!EMenuItem.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }

    class EJCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements PositionInterface {
        public void processEvent(AWTEvent aWTEvent) {
            if (!EMenuItem.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }

    class EJMenuItem
    extends JMenuItem
    implements PositionInterface {
        public void processEvent(AWTEvent aWTEvent) {
            if (!EMenuItem.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

