/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.EGroupBox;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.SafeRunnable;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

public class ESplitter
extends AbstractControlContainer
implements PropertyChangeListener {
    private static HashMap attributeList = new HashMap();
    private static final int POSITION_ATTR_ID = 0;
    private static final int ORIENTATION_ATTR_ID = 1;
    private static final int QUICKEXPAND_ATTR_ID = 2;
    private static final int DIVIDERSIZE_ATTR_ID = 3;
    private static final int BORDER_ATTR_ID = 4;
    private boolean isPaneSet = true;
    private boolean ignorePropertyChange = true;
    private AbstractControl leftTopPanel = null;
    private AbstractControl bottomRightPanel = null;
    private Dimension minMax = null;
    public static final String CLASS_ATTR_NAME = "Splitter";
    private static final String POSITION_ATTR_NAME = "position";
    private int position = 0;
    private static final String ORIENTATION_ATTR_NAME = "orientation";
    private int orientation = 1;
    private static final String QUICKEXPAND_ATTR_NAME = "quickexpand";
    private boolean quickExpand = false;
    private static final String DIVIDERSIZE_ATTR_NAME = "dividersize";
    private int dividerSize = 0;
    private int defaultDividerSize;
    public static final String BORDER_ATTR_NAME = "border";
    private int border = 1;
    private int effectiveBorder = 1;
    private Border borderSplitPane = null;
    private Border borderSplitPaneEmpty = null;

    public ESplitter() {
        EJSplitPane eJSplitPane = new EJSplitPane();
        eJSplitPane.setOneTouchExpandable(false);
        eJSplitPane.setFocusTraversalKeysEnabled(false);
        eJSplitPane.addPropertyChangeListener("dividerLocation", this);
        this.defaultDividerSize = eJSplitPane.getDividerSize();
        this.peer = eJSplitPane;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.peer.removePropertyChangeListener(this);
            this.minMax = null;
            super.dispose();
        }
    }

    public Object clone() {
        ESplitter eSplitter = new ESplitter();
        this.cloneAttributes(eSplitter);
        return eSplitter;
    }

    protected void cloneAttributes(ESplitter eSplitter) {
        super.cloneAttributes(eSplitter);
        eSplitter.setPosition(this.getPosition());
        eSplitter.setOrientation(this.getOrientation());
        eSplitter.setQuickExpand(this.getQuickExpand());
        eSplitter.setDividerSize(this.getDividerSize());
        eSplitter.setBorder(this.getBorder());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setPosition(sET.getValueInt());
                    break;
                }
                case 1: {
                    this.setOrientation(sET.getValueInt());
                    break;
                }
                case 2: {
                    this.setQuickExpand(sET.getValueInt());
                    break;
                }
                case 3: {
                    this.setDividerSize(sET.getValueInt());
                    break;
                }
                case 4: {
                    this.setBorder(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueInt(this.getPosition());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getOrientation());
                    break;
                }
                case 2: {
                    gET2.setValueInt(this.getQuickExpand());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getDividerSize());
                    break;
                }
                case 4: {
                    gET2.setValueInt(this.getBorder());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        int n;
        this.ignorePropertyChange = true;
        JSplitPane jSplitPane = (JSplitPane)this.peer;
        if (this.border != this.effectiveBorder) {
            if (this.border > 0) {
                if (this.effectiveBorder != 1) {
                    if (this.borderSplitPane != null) {
                        jSplitPane.setBorder(this.borderSplitPane);
                    }
                    this.effectiveBorder = 1;
                }
            } else {
                if (this.borderSplitPane == null) {
                    this.borderSplitPane = jSplitPane.getBorder();
                }
                if (this.borderSplitPaneEmpty == null) {
                    this.borderSplitPaneEmpty = BorderFactory.createEmptyBorder();
                }
                if (this.effectiveBorder != 0) {
                    jSplitPane.setBorder(this.borderSplitPaneEmpty);
                    this.effectiveBorder = 0;
                }
            }
        }
        if (this.isModified) {
            if (jSplitPane.getOrientation() != this.orientation) {
                jSplitPane.setOrientation(this.orientation);
            }
            if (jSplitPane.isOneTouchExpandable() != this.quickExpand) {
                jSplitPane.setOneTouchExpandable(this.quickExpand);
            }
            n = jSplitPane.getDividerSize();
            if (this.dividerSize > 0) {
                if (n != this.dividerSize) {
                    jSplitPane.setDividerSize(this.dividerSize);
                }
            } else if (n != this.defaultDividerSize) {
                jSplitPane.setDividerSize(this.defaultDividerSize);
            }
        }
        if (this.isPaneSet) {
            n = this.position;
            if (this.useRasterSize) {
                Dimension dimension = this.getLayoutGrid();
                n = this.orientation == 0 ? (n *= dimension.height) : (n *= dimension.width);
            } else {
                Scaling scaling = this.getScaling();
                n = this.orientation == 0 ? (int)Math.round((double)n * scaling.y) : (int)Math.round((double)n * scaling.x);
            }
            jSplitPane.setDividerLocation(n);
            this.isPaneSet = false;
        }
        super.eloq2swing(bl);
        this.ignorePropertyChange = false;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public AbstractControl getNextFocusControl(boolean bl) {
        AbstractControl abstractControl = this.findNextFocusControl(null, bl, true);
        if (abstractControl == null) {
            abstractControl = this.getRootControl().findNextFocusControl(bl, false);
        }
        return abstractControl != null ? abstractControl : this.getRootControl();
    }

    public AbstractControl getPrevFocusControl(boolean bl) {
        AbstractControl abstractControl = this.findPrevFocusControl(null, bl, true);
        if (abstractControl == null) {
            abstractControl = this.getRootControl().findPrevFocusControl(bl, false);
        }
        return abstractControl != null ? abstractControl : this.getRootControl();
    }

    public AbstractControl findNextFocusControl(boolean bl, boolean bl2) {
        return this.findNextFocusControl(null, bl, bl2);
    }

    public AbstractControl ascendNextFocusControl(AbstractControl abstractControl, boolean bl) {
        if (abstractControl == this.leftTopPanel && this.bottomRightPanel != null) {
            return super.ascendNextFocusControl(abstractControl, bl);
        }
        return this.parent != null ? this.parent.ascendNextFocusControl(this, bl) : null;
    }

    public AbstractControl findPrevFocusControl(boolean bl, boolean bl2) {
        return this.findPrevFocusControl(null, bl, bl2);
    }

    public AbstractControl ascendPrevFocusControl(AbstractControl abstractControl, boolean bl) {
        if (abstractControl == this.bottomRightPanel && this.leftTopPanel != null) {
            return super.ascendPrevFocusControl(abstractControl, bl);
        }
        return this.parent != null ? this.parent.ascendPrevFocusControl(this, bl) : null;
    }

    private void setPanelMinMaxSize(AbstractControl abstractControl, Dimension dimension, Scaling scaling) {
        int n = abstractControl.getMinWidth();
        int n2 = abstractControl.getMinHeight();
        boolean bl = abstractControl.peer.isMinimumSizeSet();
        if (n > 0 || n2 > 0) {
            if (abstractControl.useRasterSize) {
                if (n != 0) {
                    n *= dimension.width;
                }
                if (n2 != 0) {
                    n2 *= dimension.height;
                }
            } else {
                if (n != 0) {
                    n = (int)Math.round((double)n * scaling.x);
                }
                if (n2 != 0) {
                    n2 = (int)Math.round((double)n2 * scaling.y);
                }
            }
            if (bl) {
                this.minMax = abstractControl.peer.getMinimumSize();
                if (this.minMax.getWidth() != (double)n || this.minMax.getHeight() != (double)n2) {
                    this.minMax.setSize(n, n2);
                    abstractControl.peer.setMinimumSize(this.minMax);
                }
            } else {
                if (this.minMax == null) {
                    this.minMax = new Dimension(n, n2);
                } else {
                    this.minMax.setSize(n, n2);
                }
                abstractControl.peer.setMinimumSize(this.minMax);
            }
        } else if (bl) {
            abstractControl.peer.setMinimumSize(null);
        }
        n = abstractControl.getMaxWidth();
        n2 = abstractControl.getMaxHeight();
        bl = abstractControl.peer.isMaximumSizeSet();
        if (n > 0 || n2 > 0) {
            if (abstractControl.useRasterSize) {
                if (n != 0) {
                    n *= dimension.width;
                }
                if (n2 != 0) {
                    n2 *= dimension.height;
                }
            } else {
                if (n != 0) {
                    n = (int)Math.round((double)n * scaling.x);
                }
                if (n2 != 0) {
                    n2 = (int)Math.round((double)n2 * scaling.y);
                }
            }
            if (bl) {
                this.minMax = abstractControl.peer.getMaximumSize();
                if (this.minMax.getWidth() != (double)n || this.minMax.getHeight() != (double)n2) {
                    this.minMax.setSize(n, n2);
                    abstractControl.peer.setMaximumSize(this.minMax);
                }
            } else {
                if (this.minMax == null) {
                    this.minMax = new Dimension(n, n2);
                } else {
                    this.minMax.setSize(n, n2);
                }
                abstractControl.peer.setMaximumSize(this.minMax);
            }
        } else if (bl) {
            abstractControl.peer.setMaximumSize(null);
        }
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        if (this.leftTopPanel != null && this.leftTopPanel.visible) {
            this.setPanelMinMaxSize(this.leftTopPanel, dimension2, scaling);
            this.leftTopPanel.layout(null, dimension2, scaling);
        }
        if (this.bottomRightPanel != null && this.bottomRightPanel.visible) {
            this.setPanelMinMaxSize(this.bottomRightPanel, dimension2, scaling);
            this.bottomRightPanel.layout(null, dimension2, scaling);
        }
        return false;
    }

    public boolean add(Object object) {
        AbstractControl abstractControl;
        boolean bl = object instanceof EGroupBox;
        boolean bl2 = object instanceof ESplitter;
        if (bl) {
            abstractControl = (EGroupBox)object;
            ((EGroupBox)abstractControl).setInPane();
        }
        if (bl || bl2) {
            abstractControl = (AbstractControl)object;
            abstractControl.setFontReference(this.fontReference);
            final JSplitPane jSplitPane = (JSplitPane)this.peer;
            final Component component = abstractControl.getPeer();
            if (this.leftTopPanel == null) {
                SafeRunnable.execute(new SafeRunnable(){

                    public void runSafe() {
                        jSplitPane.setLeftComponent(component);
                        if (component instanceof JComponent) {
                            ((JComponent)component).revalidate();
                        }
                    }
                });
                this.leftTopPanel = abstractControl;
                if (this.children.size() >= 1) {
                    if (this.children.get(0) == this.bottomRightPanel) {
                        this.children.add(0, object);
                    } else {
                        this.children.set(0, object);
                    }
                } else {
                    this.children.add(object);
                }
            } else if (this.bottomRightPanel == null) {
                SafeRunnable.execute(new SafeRunnable(){

                    public void runSafe() {
                        jSplitPane.setRightComponent(component);
                        if (component instanceof JComponent) {
                            ((JComponent)component).revalidate();
                        }
                    }
                });
                this.bottomRightPanel = abstractControl;
                if (this.children.size() < 2) {
                    this.children.add(object);
                } else {
                    this.children.set(1, object);
                }
            } else {
                return false;
            }
            this.setLayoutChanged();
            return true;
        }
        return false;
    }

    public boolean remove(Object object) {
        if (!(object instanceof AbstractControl)) {
            return false;
        }
        AbstractControl abstractControl = (AbstractControl)object;
        this.childRemoveChain(abstractControl);
        final JSplitPane jSplitPane = (JSplitPane)this.peer;
        if (abstractControl == this.leftTopPanel) {
            SafeRunnable.execute(new SafeRunnable(){

                public void runSafe() {
                    jSplitPane.setLeftComponent(null);
                }
            });
            this.leftTopPanel = null;
        } else if (abstractControl == this.bottomRightPanel) {
            SafeRunnable.execute(new SafeRunnable(){

                public void runSafe() {
                    jSplitPane.setRightComponent(null);
                }
            });
            this.bottomRightPanel = null;
        } else {
            return false;
        }
        this.children.remove(object);
        return true;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setPosition(int n) {
        this.position = n;
        this.isPaneSet = true;
    }

    public int getPosition() {
        return this.position;
    }

    public void setOrientation(int n) {
        this.orientation = n != 0 ? 0 : 1;
        this.isModified = true;
    }

    public int getOrientation() {
        return this.orientation == 0 ? 1 : 0;
    }

    public void setQuickExpand(int n) {
        this.quickExpand = n != 0;
        this.isModified = true;
    }

    public int getQuickExpand() {
        return this.quickExpand ? 1 : 0;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
        this.isModified = true;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public int getBorder() {
        return this.border;
    }

    private void updatePosition() {
        JSplitPane jSplitPane = (JSplitPane)this.peer;
        int n = jSplitPane.getDividerLocation();
        if (!this.useRasterSize) {
            Scaling scaling = this.getScaling();
            this.position = this.orientation == 0 ? (int)Math.round((double)n / scaling.y) : (int)Math.round((double)n / scaling.x);
        } else {
            Dimension dimension = this.getLayoutGrid();
            Dimension dimension2 = jSplitPane.getSize();
            int n2 = jSplitPane.getDividerSize();
            this.position = this.orientation == 0 ? (n >= dimension2.height - n2 - 1 ? (int)Math.round((double)(dimension2.height + dimension.height - 1) / (double)dimension.height) : (int)Math.round((double)n / (double)dimension.height)) : (n >= dimension2.width - n2 - 1 ? (int)Math.round((double)(dimension2.width + dimension.width - 1) / (double)dimension.width) : (int)Math.round((double)n / (double)dimension.width));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.ignorePropertyChange) {
            this.updatePosition();
            if (this.rule != 0 && this.isInDlgDo()) {
                this.getRuleManager().fireRule(this);
            }
        }
    }

    static {
        attributeList.put(POSITION_ATTR_NAME, new Integer(0));
        attributeList.put(ORIENTATION_ATTR_NAME, new Integer(1));
        attributeList.put(QUICKEXPAND_ATTR_NAME, new Integer(2));
        attributeList.put(DIVIDERSIZE_ATTR_NAME, new Integer(3));
        attributeList.put(BORDER_ATTR_NAME, new Integer(4));
    }

    class EJSplitPane
    extends JSplitPane {
        EJSplitPane() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!ESplitter.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

