/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractTextControl;
import com.eloquence.services.jdlg.controls.PositionInterface;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JLabel;

public class EStaticText
extends AbstractTextControl
implements ActionListener {
    private static HashMap attributeList = new HashMap();
    private static final int TEXTPOS_ATTR_ID = 0;
    public static final String CLASS_ATTR_NAME = "StaticText";
    public static final String TEXTPOS_ATTR_NAME = "textpos";
    public static final String ALIGN_ATTR_NAME = "align";
    protected String orgText = "";
    private String textpos = "left";

    public EStaticText() {
        EJLabel eJLabel = new EJLabel();
        eJLabel.setFocusTraversalKeysEnabled(false);
        eJLabel.setFont(StartUp.getDefaultFont());
        this.peer = eJLabel;
        this.setTextPos(this.getTextPos());
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
            this.orgText = null;
        }
    }

    public Object clone() {
        EStaticText eStaticText = new EStaticText();
        this.cloneAttributes(eStaticText);
        return eStaticText;
    }

    protected final void cloneAttributes(EStaticText eStaticText) {
        super.cloneAttributes(eStaticText);
        eStaticText.setTextPos(this.getTextPos());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setTextPos(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getTextPos());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public Dimension calcExtraSpace(Scaling scaling) {
        return this.initExtraSpace(1, 0);
    }

    public void eloq2swing(boolean bl) {
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        this.eloq2swingTextpos();
        super.eloq2swing(bl);
        ((JLabel)this.peer).setOpaque(this.bgc != null);
    }

    public void eloq2swingText() {
        JLabel jLabel = (JLabel)this.peer;
        if (!this.text.equals(jLabel.getText())) {
            try {
                jLabel.setText(this.text);
            }
            catch (Throwable throwable) {
                System.err.println("'" + this.getPath() + "' " + throwable + ": StaticText = \"" + this.text + "\"");
                jLabel.setText(HtmlTool.text(this.text));
            }
        }
    }

    private final void eloq2swingTextpos() {
        PositionInterface positionInterface = (PositionInterface)((Object)this.peer);
        if (this.textpos.equalsIgnoreCase("center")) {
            positionInterface.setHorizontalAlignment(0);
        } else if (this.textpos.equalsIgnoreCase("left")) {
            positionInterface.setHorizontalAlignment(2);
        } else if (this.textpos.equalsIgnoreCase("right")) {
            positionInterface.setHorizontalAlignment(4);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AbstractControl abstractControl = this.getNextFocusControl(false);
        if (this.getRuleManager().requestFocus(abstractControl)) {
            abstractControl.requestFocusInWindow(abstractControl.getFocusPeer());
        }
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public String getContent() {
        return super.getText();
    }

    public String getText() {
        return this.orgText;
    }

    public String getTextPos() {
        return this.textpos;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public void setText(String string) {
        this.orgText = string;
        string = this.filterASCIIHighlightChars(string);
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.getAcceleratorChar(string, stringBuffer);
        this.setKeyStroke(c);
        if (c != '\u0000') {
            super.setText(stringBuffer.toString());
        } else {
            super.setText(string);
        }
    }

    public void setTextPos(String string) {
        this.textpos = string;
        this.isModified = true;
    }

    static {
        attributeList.put(TEXTPOS_ATTR_NAME, new Integer(0));
        attributeList.put(ALIGN_ATTR_NAME, new Integer(0));
    }

    class EJLabel
    extends JLabel
    implements PositionInterface {
        EJLabel() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EStaticText.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

