/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.UnifiedData;
import com.eloquence.services.Application.ActiveDialogList;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.jdlg.controls.EPopupBox;
import com.eloquence.services.jdlg.controls.PluginControl;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.sessions.Session;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.SafeRunnable;
import com.eloquence.services.web.BrowserAccessor;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class ESystem
extends EDialog {
    private static final String ATOM_ATTR_NAME = "atom";
    private static final String ATOMS_ATTR_NAME = "atoms";
    private HashMap atomMap = null;
    private static final String RETURN_LCASE_ATTR_NAME = "returnlcase";
    private boolean returnLcase_ID = false;
    private boolean returnLcase_CLASS = false;
    private boolean returnLcaseSet = false;
    private static final String BEEP_ATTR_NAME = "beep";
    private static final String SOUND_ATTR_NAME = "sound";
    private static final String LOOKANDFEEL_ATTR_NAME = "lookandfeel";
    private static final String PRINTCOMMAND_ATTR_NAME = "printcommand";
    private static final String DEFAULTPRINTER_ATTR_NAME = "defaultprinter";
    private static final String PRINTERSCOMMAND_ATTR_NAME = "printerscommand";
    private static final String PRINTERSFILTER_ATTR_NAME = "printersfilter";
    private static final String NOTIFYBUSY_ATTR_NAME = "notifybusy";
    private int notifyBusy = -1;
    private static final String EDITMODE_ATTR_NAME = "editmode";
    private static final int EDITMODE_ALWAYS_INS = 0;
    private static final int EDITMODE_ALWAYS_OVR = 1;
    private static final int EDITMODE_STARTWITH_INS = 2;
    private static final int EDITMODE_STARTWITH_OVR = 3;
    private static final String EDITMODE_ALWAYS_INS_DESC = "insert-only";
    private static final String EDITMODE_ALWAYS_OVR_DESC = "overwrite-only";
    private static final String EDITMODE_STARTWITH_INS_DESC = "insert";
    private static final String EDITMODE_STARTWITH_OVR_DESC = "overwrite";
    private int editmode = 0;
    private boolean editmode_ovr = false;
    private boolean editmode_initialized = false;
    private static final String ACTIVATE_ATTR_NAME = "activate";
    private static final String KEEPALIVE_ATTR_NAME = "keepalive";
    private int keepalive = -1;
    private static final String TYPEAHEAD_ATTR_NAME = "typeahead";
    private boolean typeAheadEnabled = false;
    private boolean typeAheadSet = false;
    private static final String CLIPBOARDCONTEXTMENU_ATTR_NAME = "clipboardcontextmenu";
    private String clipboardContextMenu = null;
    public static final String START_ATTR_NAME = "start";
    private static final String PLUGIN_ATTR_NAME = "plugin";
    private static final String ENABLE_REFERENCE_ATTR_NAME = "enablereference";
    private boolean enableReference = false;
    private boolean enableReferenceSet = false;
    private static final String ENABLE_SCALEFACTOR_ATTR_NAME = "enablescalefactor";
    private boolean enableScaleFactor = false;
    private boolean enableScaleFactorSet = false;
    private static final String ENABLE_MAXIMIZE_ATTR_NAME = "enablemaximize";
    private boolean enableMaximize = false;
    private boolean enableMaximizeSet = false;
    private static final String ENABLE_SNAP_ATTR_NAME = "enablesnap";
    private boolean enableSnap = false;
    private boolean enableSnapSet = false;
    private static final String SNAP_ADJUST_SIZE_ATTR_NAME = "snapadjustsize";
    private boolean snapAdjustSize = false;
    private boolean snapAdjustSizeSet = false;
    private static final String SNAP_MARGIN_ATTR_NAME = "snapmargin";
    private int snapTop = 8;
    private int snapRight = 8;
    private int snapBottom = 8;
    private int snapLeft = 8;
    private static final String NOTIFY_ATTR_NAME = "notify";
    private static final String NOTIFY_ALL_ATTR_NAME = "notifyall";
    private static final String DIALOG_W_OVERLAP_ATTR_NAME = "dialog_w_overlap";
    private int dialogWOverlap = 0;
    private boolean dialogWOverlapSet = false;
    private static final String DIALOG_H_OVERLAP_ATTR_NAME = "dialog_h_overlap";
    private int dialogHOverlap = 0;
    private boolean dialogHOverlapSet = false;
    private static final String DIALOG_SCROLL_ATTR_NAME = "dialog_scroll";
    private boolean dialogScroll = false;
    private boolean dialogScrollSet = false;
    private static ESystem object = null;
    private static String baseURL = "";
    private static boolean baseURL_set = false;
    private static String helpBaseURL = "";
    private static boolean helpBaseURL_set = false;
    protected BrowserAccessor browserAccessor = null;
    protected static boolean popupboxwider = false;
    protected static boolean popupboxinversvideo = false;
    protected static boolean always_on_top = false;
    private static final String CLASS_ATTR_NAME = "System";
    private static final String DRIVER_ATTR_NAME = "driver";
    private static final String VERSION_ATTR_NAME = "version";
    private static final String JDLGVERSION_ATTR_NAME = "jdlgversion";
    private static final String IPADDRESS_ATTR_NAME = "ipaddress";
    private static final String DNSNAME_ATTR_NAME = "dnsname";
    private static final String DLGPORT_ATTR_NAME = "dlgport";
    private static final String BASEURL_ATTR_NAME = "baseurl";
    private static final String HELPBASEURL_ATTR_NAME = "helpbaseurl";
    private static final String SCRENNRESOLUTION_ATTR_NAME = "screenresolution";
    private static final String SCREENWIDTH_ATTR_NAME = "screenwidth";
    private static final String SCREENHEIGHT_ATTR_NAME = "screenheight";
    private static final String OSNAME_ATTR_NAME = "osname";
    private static final String OSVERSION_ATTR_NAME = "osversion";
    private static final String OSARCH_ATTR_NAME = "osarch";
    private static final String USERNAME_ATTR_NAME = "username";
    private static final String USERDIR_ATTR_NAME = "userdir";
    private static final String WORKINGDIR_ATTR_NAME = "workingdir";
    private static final String JAVAVERSION_ATTR_NAME = "javaversion";
    private static final String JAVAVENDOR_ATTR_NAME = "javavendor";
    private static final String JAVAHOME_ATTR_NAME = "javahome";
    private static final String POPUPBOXWIDER_ATTR_NAME = "popupboxwider";
    private static final String POPUPBOXINVERSVIDEO_ATTR_NAME = "popupboxinversvideo";
    private static final String CLIPBOARD_ATTR_NAME = "clipboard";
    private static final String MULTISCREEN_ATTR_NAME = "multiscreen";
    private static HashMap attributeList = new HashMap();
    private static final int CLASS_ATTR_ID = 0;
    private static final int RETURN_LCASE_ATTR_ID = 1;
    private static final int DRIVER_ATTR_ID = 2;
    private static final int VERSION_ATTR_ID = 3;
    private static final int JDLGVERSION_ATTR_ID = 4;
    private static final int IPADDRESS_ATTR_ID = 5;
    private static final int DNSNAME_ATTR_ID = 6;
    private static final int DLGPORT_ATTR_ID = 7;
    private static final int BASEURL_ATTR_ID = 8;
    private static final int HELPBASEURL_ATTR_ID = 9;
    private static final int SCREENRESOLUTION_ATTR_ID = 10;
    private static final int SCREENWIDTH_ATTR_ID = 11;
    private static final int SCREENHEIGHT_ATTR_ID = 12;
    private static final int OSNAME_ATTR_ID = 13;
    private static final int OSVERSION_ATTR_ID = 14;
    private static final int OSARCH_ATTR_ID = 15;
    private static final int USERNAME_ATTR_ID = 16;
    private static final int USERDIR_ATTR_ID = 17;
    private static final int WORKINGDIR_ATTR_ID = 18;
    private static final int JAVAVERSION_ATTR_ID = 19;
    private static final int JAVAVENDOR_ATTR_ID = 20;
    private static final int JAVAHOME_ATTR_ID = 21;
    private static final int POPUPBOXWIDER_ATTR_ID = 22;
    private static final int POPUPBOXINVERSVIDEO_ATTR_ID = 23;
    private static final int CLIPBOARD_ATTR_ID = 24;
    private static final int BEEP_ATTR_ID = 25;
    private static final int SOUND_ATTR_ID = 26;
    private static final int LOOKANDFEEL_ATTR_ID = 27;
    private static final int PRINTCOMMAND_ATTR_ID = 28;
    private static final int DEFAULTPRINTER_ATTR_ID = 29;
    private static final int PRINTERSCOMMAND_ATTR_ID = 30;
    private static final int PRINTERSFILTER_ATTR_ID = 31;
    private static final int NOTIFYBUSY_ATTR_ID = 32;
    private static final int MULTISCREEN_ATTR_ID = 33;
    private static final int EDITMODE_ATTR_ID = 34;
    private static final int ACTIVATE_ATTR_ID = 35;
    private static final int KEEPALIVE_ATTR_ID = 36;
    private static final int TYPEAHEAD_ATTR_ID = 37;
    private static final int CLIPBOARDCONTEXTMENU_ATTR_ID = 38;
    private static final int START_ATTR_ID = 39;
    private static final int ENABLE_REFERENCE_ATTR_ID = 40;
    private static final int ENABLE_SCALEFACTOR_ATTR_ID = 41;
    private static final int ENABLE_MAXIMIZE_ATTR_ID = 42;
    private static final int ENABLE_SNAP_ATTR_ID = 43;
    private static final int SNAP_ADJUST_SIZE_ATTR_ID = 44;
    private static final int SNAP_MARGIN_ATTR_ID = 45;
    private static final int ATOM_ATTR_ID = 46;
    private static final int ATOMS_ATTR_ID = 47;
    private static final int PLUGIN_ATTR_ID = 48;
    private static final int NOTIFY_ATTR_ID = 49;
    private static final int NOTIFY_ALL_ATTR_ID = 50;
    private static final int DIALOG_W_OVERLAP_ATTR_ID = 51;
    private static final int DIALOG_H_OVERLAP_ATTR_ID = 52;
    private static final int DIALOG_SCROLL_ATTR_ID = 53;
    public static final TypeAheadManager typeAhead;

    public String getClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAtom(String string, String string2) {
        ESystem eSystem = this;
        synchronized (eSystem) {
            if (string2.length() != 0) {
                if (this.atomMap == null) {
                    this.atomMap = new HashMap();
                }
                this.atomMap.put(string, new UnifiedData(string2));
            } else if (this.atomMap != null) {
                this.atomMap.remove(string);
                if (this.atomMap.isEmpty()) {
                    this.atomMap = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAtom(String string, int n) {
        ESystem eSystem = this;
        synchronized (eSystem) {
            if (this.atomMap == null) {
                this.atomMap = new HashMap();
            }
            this.atomMap.put(string, new UnifiedData(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnifiedData getAtom(String string) {
        ESystem eSystem = this;
        synchronized (eSystem) {
            Object var3_3 = this.atomMap != null ? this.atomMap.get(string) : null;
            return var3_3 != null ? (UnifiedData)var3_3 : new UnifiedData("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAtoms() {
        StringBuilder stringBuilder = new StringBuilder();
        ESystem eSystem = this;
        synchronized (eSystem) {
            Set set;
            Set set2 = set = this.atomMap != null ? this.atomMap.keySet() : null;
            if (set != null && set.size() != 0) {
                ArrayList arrayList = new ArrayList(set);
                Collections.sort(arrayList);
                ListIterator listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append((String)listIterator.next());
                }
            }
        }
        return stringBuilder.toString();
    }

    private void setReturnLcase(int n) {
        this.returnLcase_ID = (n & 1) != 0;
        this.returnLcase_CLASS = (n & 2) != 0;
        this.returnLcaseSet = true;
    }

    public int getReturnLcase() {
        if (!this.returnLcaseSet) {
            this.setReturnLcase(StartUp.getReturnLcase());
        }
        return (this.returnLcase_ID ? 1 : 0) | (this.returnLcase_CLASS ? 2 : 0);
    }

    public String return_ID(String string) {
        if (!this.returnLcaseSet) {
            this.setReturnLcase(StartUp.getReturnLcase());
        }
        return string != null && this.returnLcase_ID ? string.toLowerCase() : string;
    }

    public String return_CLASS(String string) {
        if (!this.returnLcaseSet) {
            this.setReturnLcase(StartUp.getReturnLcase());
        }
        return string != null && this.returnLcase_CLASS ? string.toLowerCase() : string;
    }

    private String getDriver() {
        return "JDLG";
    }

    private String getVersion() {
        return "Eloquence JDLG";
    }

    private String getJdlgversion() {
        return "2.0.20";
    }

    private Dlg getSession() {
        Thread thread = Thread.currentThread();
        return thread instanceof Dlg ? (Dlg)thread : null;
    }

    public String getIPAddress() {
        Dlg dlg = this.getSession();
        return dlg != null ? dlg.getLocalHostAddress() : "unknown";
    }

    private String getDnsname() {
        Dlg dlg = this.getSession();
        return dlg != null ? dlg.getLocalHostName() : "unknown";
    }

    private void setHelpBaseURL(String string) {
        helpBaseURL = string;
        helpBaseURL_set = true;
    }

    public String getHelpBaseURL() {
        if (!helpBaseURL_set) {
            helpBaseURL_set = true;
            helpBaseURL = StartUp.getHelpBaseURL();
        }
        return helpBaseURL;
    }

    private void setBaseURL(String string) {
        baseURL = string;
        baseURL_set = true;
    }

    public String getBaseURL() {
        if (!baseURL_set) {
            baseURL_set = true;
            baseURL = StartUp.getBaseURL();
        }
        if (baseURL != null) {
            return baseURL;
        }
        return "";
    }

    private int getScreenresolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    private int getScreenwidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    private int getScreenheight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    private String getOsname() {
        return this.getSystemProperty("os.name");
    }

    private String getOsversion() {
        return this.getSystemProperty("os.version");
    }

    private String getOsarch() {
        return this.getSystemProperty("os.arch");
    }

    private String getUsername() {
        return this.getSystemProperty("user.name");
    }

    private String getUserdir() {
        return this.getSystemProperty("user.home");
    }

    private String getJavaversion() {
        return this.getSystemProperty("java.version");
    }

    private String getJavavendor() {
        return this.getSystemProperty("java.vendor");
    }

    private String getJavahome() {
        return this.getSystemProperty("java.home");
    }

    private void setPopupboxwider(int n) {
        popupboxwider = n != 0;
    }

    public static int getPopupboxwider() {
        return popupboxwider ? 1 : 0;
    }

    private void setPopupboxinversvideo(int n) {
        popupboxinversvideo = n != 0;
    }

    public static int getPopupboxinversvideo() {
        return popupboxinversvideo ? 1 : 0;
    }

    private String getSystemProperty(String string) {
        try {
            String string2 = System.getProperty(string);
            if (string2 != null) {
                return string2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    void executeBrowserRequest(String string) {
        class WebExec
        implements Runnable {
            String url = null;

            public WebExec(String string) {
                this.url = string;
            }

            public void run() {
                ESystem.this.browserAccessor.showURL(this.url);
                this.url = null;
            }
        }
        Thread thread = new Thread(new WebExec(string));
        thread.start();
    }

    private void setBeep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private int setSound(String string) {
        try {
            URL uRL = this.createExpandedURL(string);
            if (uRL == null) {
                return 11;
            }
            Applet.newAudioClip(uRL).play();
        }
        catch (Exception exception) {
            return 11;
        }
        return 0;
    }

    private String getLookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel.getName();
    }

    private String getPrintCommand() {
        return StartUp.getPrintCommand();
    }

    private String getDefaultPrinter() {
        return StartUp.getDefaultPrinter();
    }

    private String getPrintersCommand() {
        return StartUp.getPrintersCommand();
    }

    private String getPrintersFilter() {
        return StartUp.getPrintersFilter();
    }

    private void setNotifyBusy(int n) {
        this.notifyBusy = n != 0 ? 1 : 0;
    }

    private int getNotifyBusy() {
        if (this.notifyBusy >= 0) {
            return this.notifyBusy;
        }
        return StartUp.getNotifyBusy() ? 1 : 0;
    }

    public void notifyBusy() {
        if (this.getNotifyBusy() > 0) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private int getMultiscreen() {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration;
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            if (graphicsDevice.getType() != 0 || (graphicsConfiguration = graphicsDevice.getDefaultConfiguration()) == null) continue;
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (rectangle.x == 0 && rectangle.y == 0) continue;
            return 1;
        }
        return 0;
    }

    public boolean restoreTopMostWindow() {
        return false;
    }

    private void initializeEditMode() {
        this.setEditMode(StartUp.getEditMode());
        this.editmode_initialized = true;
    }

    private int setEditMode(String string) {
        if (string.equalsIgnoreCase(EDITMODE_ALWAYS_INS_DESC)) {
            this.editmode = 0;
            this.editmode_ovr = false;
        } else if (string.equalsIgnoreCase(EDITMODE_ALWAYS_OVR_DESC)) {
            this.editmode = 1;
            this.editmode_ovr = true;
        } else if (string.equalsIgnoreCase(EDITMODE_STARTWITH_INS_DESC)) {
            this.editmode = 2;
            if (!this.editmode_initialized) {
                this.editmode_ovr = false;
            }
        } else if (string.equalsIgnoreCase(EDITMODE_STARTWITH_OVR_DESC)) {
            this.editmode = 3;
            if (!this.editmode_initialized) {
                this.editmode_ovr = true;
            }
        } else {
            return 11;
        }
        return 0;
    }

    private String getEditMode() {
        switch (this.editmode) {
            case 1: {
                return EDITMODE_ALWAYS_OVR_DESC;
            }
            case 2: {
                return EDITMODE_STARTWITH_INS_DESC;
            }
            case 3: {
                return EDITMODE_STARTWITH_OVR_DESC;
            }
        }
        return EDITMODE_ALWAYS_INS_DESC;
    }

    public void setOverwrite(boolean bl) {
        if (this.canToggleOverwrite()) {
            this.editmode_ovr = bl;
        }
    }

    public boolean isOverwrite() {
        if (!this.editmode_initialized) {
            this.initializeEditMode();
        }
        return this.editmode_ovr;
    }

    private boolean canToggleOverwrite() {
        return this.editmode != 0 && this.editmode != 1;
    }

    private void setActivate(String string) {
        ActiveDialogList.setToFront(string, false);
    }

    private void setKeepalive(int n) {
        this.keepalive = n > 0 ? n : 0;
    }

    public int getKeepalive() {
        if (this.keepalive >= 0) {
            return this.keepalive;
        }
        return StartUp.getKeepalive();
    }

    private void setTypeAhead(int n) {
        this.typeAheadEnabled = n != 0;
        this.typeAheadSet = true;
        typeAhead.enable(this.typeAheadEnabled);
    }

    private int getTypeAhead() {
        boolean bl = this.typeAheadSet ? this.typeAheadEnabled : StartUp.getTypeAheadEnabled();
        return bl ? 1 : 0;
    }

    public void setClipboardContextMenu(String string) {
        this.clipboardContextMenu = string;
    }

    public String getClipboardContextMenu() {
        if (this.clipboardContextMenu != null) {
            return this.clipboardContextMenu;
        }
        return StartUp.getClipboardContextMenu();
    }

    private int setStart(String string) {
        return Session.startByKey(string, null) ? 0 : 11;
    }

    private int getPlugin(String string) {
        return PluginControl.hasPlugin(string) ? 1 : 0;
    }

    private void setEnableReference(int n) {
        this.enableReference = n != 0;
        this.enableReferenceSet = true;
    }

    public boolean getEnableReference() {
        if (!this.enableReferenceSet) {
            this.enableReference = StartUp.getEnableReference();
            this.enableReferenceSet = true;
        }
        return this.enableReference;
    }

    private int getEnableReferenceAttr() {
        return this.getEnableReference() ? 1 : 0;
    }

    private void setEnableScaleFactor(int n) {
        this.enableScaleFactor = n != 0;
        this.enableScaleFactorSet = true;
    }

    public boolean getEnableScaleFactor() {
        if (!this.enableScaleFactorSet) {
            this.enableScaleFactor = StartUp.getEnableScaleFactor();
            this.enableScaleFactorSet = true;
        }
        return this.enableScaleFactor;
    }

    private int getEnableScaleFactorAttr() {
        return this.getEnableScaleFactor() ? 1 : 0;
    }

    private void setEnableMaximize(int n) {
        this.enableMaximize = n != 0;
        this.enableMaximizeSet = true;
    }

    public boolean getEnableMaximize() {
        if (!this.enableMaximizeSet) {
            this.enableMaximize = StartUp.getEnableMaximize();
            this.enableMaximizeSet = true;
        }
        return this.enableMaximize;
    }

    private int getEnableMaximizeAttr() {
        return this.getEnableMaximize() ? 1 : 0;
    }

    private void setEnableSnap(int n) {
        this.enableSnap = n != 0;
        this.enableSnapSet = true;
    }

    public boolean getEnableSnap() {
        if (!this.enableSnapSet) {
            this.enableSnap = StartUp.getEnableSnap();
            this.enableSnapSet = true;
        }
        return this.enableSnap;
    }

    private int getEnableSnapAttr() {
        return this.getEnableSnap() ? 1 : 0;
    }

    private void setSnapAdjustSize(int n) {
        this.snapAdjustSize = n != 0;
        this.snapAdjustSizeSet = true;
    }

    public boolean getSnapAdjustSize() {
        if (!this.snapAdjustSizeSet) {
            this.snapAdjustSize = StartUp.getSnapAdjustSize();
            this.snapAdjustSizeSet = true;
        }
        return this.snapAdjustSize;
    }

    private int getSnapAdjustSizeAttr() {
        return this.getSnapAdjustSize() ? 1 : 0;
    }

    private boolean setSnapMargin(String string) {
        int[] nArray = new int[4];
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            String string2 = (n3 = string.indexOf(44, n2)) >= 0 ? string.substring(n2, n3) : string.substring(n2);
            try {
                nArray[n++] = Integer.parseInt(string2.trim());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n3 < 0) break;
            n2 = n3 + 1;
        }
        if (n != 4) {
            return false;
        }
        this.snapTop = nArray[0];
        this.snapRight = nArray[1];
        this.snapBottom = nArray[2];
        this.snapLeft = nArray[3];
        return true;
    }

    private String getSnapMargin() {
        return this.snapTop + "," + this.snapRight + "," + this.snapBottom + "," + this.snapLeft;
    }

    public void setSnapTop(int n) {
        this.snapTop = n;
    }

    public void setSnapRight(int n) {
        this.snapRight = n;
    }

    public void setSnapBottom(int n) {
        this.snapBottom = n;
    }

    public void setSnapLeft(int n) {
        this.snapLeft = n;
    }

    public int getSnapTop() {
        return this.snapTop;
    }

    public int getSnapRight() {
        return this.snapRight;
    }

    public int getSnapBottom() {
        return this.snapBottom;
    }

    public int getSnapLeft() {
        return this.snapLeft;
    }

    private void setNotify(final String string, final String string2, final boolean bl) {
        final Thread thread = Thread.currentThread();
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                ActiveDialogList.notifyDialogs(thread, string, string2, bl);
            }
        });
    }

    private void setDialogWOverlap(int n) {
        this.dialogWOverlap = n;
        this.dialogWOverlapSet = true;
    }

    public int getDialogWOverlap() {
        if (!this.dialogWOverlapSet) {
            this.dialogWOverlap = StartUp.getDialogWOverlap();
            this.dialogWOverlapSet = true;
        }
        return this.dialogWOverlap;
    }

    private void setDialogHOverlap(int n) {
        this.dialogHOverlap = n;
        this.dialogHOverlapSet = true;
    }

    public int getDialogHOverlap() {
        if (!this.dialogHOverlapSet) {
            this.dialogHOverlap = StartUp.getDialogHOverlap();
            this.dialogHOverlapSet = true;
        }
        return this.dialogHOverlap;
    }

    private void setDialogScroll(int n) {
        this.dialogScroll = n != 0;
        this.dialogScrollSet = true;
    }

    private int getDialogScroll() {
        return this.dialogScroll() ? 1 : 0;
    }

    public boolean dialogScroll() {
        if (!this.dialogScrollSet) {
            this.dialogScroll = StartUp.getDialogScroll();
            this.dialogScrollSet = true;
        }
        return this.dialogScroll;
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 46: {
                        if (sET.v_type == 1) {
                            this.setAtom(sET.index, sET.getValueInt());
                            break;
                        }
                        this.setAtom(sET.index, sET.getValueString());
                        break;
                    }
                    case 49: {
                        this.setNotify(sET.index, sET.getValueString(), false);
                        break;
                    }
                    case 50: {
                        this.setNotify(sET.index, sET.getValueString(), true);
                        break;
                    }
                    case 39: {
                        return this.setStart(sET.getValueString());
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 1: {
                    this.setReturnLcase(sET.getValueInt());
                    break;
                }
                case 8: {
                    this.setBaseURL(sET.getValueString());
                    break;
                }
                case 9: {
                    this.setHelpBaseURL(sET.getValueString());
                    break;
                }
                case 22: {
                    this.setPopupboxwider(sET.getValueInt());
                    break;
                }
                case 23: {
                    this.setPopupboxinversvideo(sET.getValueInt());
                    break;
                }
                case 24: {
                    this.setClipboard(sET.getValueString());
                    break;
                }
                case 25: {
                    this.setBeep();
                    break;
                }
                case 32: {
                    this.setNotifyBusy(sET.getValueInt());
                    break;
                }
                case 26: {
                    return this.setSound(sET.getValueString());
                }
                case 27: {
                    return 11;
                }
                case 34: {
                    return this.setEditMode(sET.getValueString());
                }
                case 35: {
                    this.setActivate(sET.getValueString());
                    break;
                }
                case 36: {
                    this.setKeepalive(sET.getValueInt());
                    break;
                }
                case 37: {
                    this.setTypeAhead(sET.getValueInt());
                    break;
                }
                case 38: {
                    this.setClipboardContextMenu(sET.getValueString());
                    break;
                }
                case 39: {
                    return this.setStart(sET.getValueString());
                }
                case 40: {
                    this.setEnableReference(sET.getValueInt());
                    break;
                }
                case 41: {
                    this.setEnableScaleFactor(sET.getValueInt());
                    break;
                }
                case 42: {
                    this.setEnableMaximize(sET.getValueInt());
                    break;
                }
                case 43: {
                    this.setEnableSnap(sET.getValueInt());
                    break;
                }
                case 44: {
                    this.setSnapAdjustSize(sET.getValueInt());
                    break;
                }
                case 45: {
                    if (this.setSnapMargin(sET.getValueString())) break;
                    return 11;
                }
                case 51: {
                    this.setDialogWOverlap(sET.getValueInt());
                    break;
                }
                case 52: {
                    this.setDialogHOverlap(sET.getValueInt());
                    break;
                }
                case 53: {
                    this.setDialogScroll(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 46: {
                        UnifiedData unifiedData = this.getAtom(gET.index);
                        if (unifiedData.isStringData()) {
                            gET2.setValueString(unifiedData.getStringData());
                            break;
                        }
                        gET2.setValueInt(unifiedData.getIntData());
                        break;
                    }
                    case 48: {
                        gET2.setValueInt(this.getPlugin(gET.index));
                        break;
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 47: {
                    gET2.setValueString(this.getAtoms());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getReturnLcase());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getDriver());
                    break;
                }
                case 3: {
                    gET2.setValueString(this.getVersion());
                    break;
                }
                case 4: {
                    gET2.setValueString(this.getJdlgversion());
                    break;
                }
                case 5: {
                    gET2.setValueString(this.getIPAddress());
                    break;
                }
                case 6: {
                    gET2.setValueString(this.getDnsname());
                    break;
                }
                case 7: {
                    gET2.setValueInt(StartUp.getDlgPort());
                    break;
                }
                case 8: {
                    gET2.setValueString(this.getBaseURL());
                    break;
                }
                case 9: {
                    gET2.setValueString(this.getHelpBaseURL());
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getScreenresolution());
                    break;
                }
                case 11: {
                    gET2.setValueInt(this.getScreenwidth());
                    break;
                }
                case 12: {
                    gET2.setValueInt(this.getScreenheight());
                    break;
                }
                case 13: {
                    gET2.setValueString(this.getOsname());
                    break;
                }
                case 14: {
                    gET2.setValueString(this.getOsversion());
                    break;
                }
                case 15: {
                    gET2.setValueString(this.getOsarch());
                    break;
                }
                case 16: {
                    gET2.setValueString(this.getUsername());
                    break;
                }
                case 17: {
                    gET2.setValueString(this.getUserdir());
                    break;
                }
                case 18: {
                    gET2.setValueString(WORKINGDIR_ATTR_NAME);
                    break;
                }
                case 19: {
                    gET2.setValueString(this.getJavaversion());
                    break;
                }
                case 20: {
                    gET2.setValueString(this.getJavavendor());
                    break;
                }
                case 21: {
                    gET2.setValueString(this.getJavahome());
                    break;
                }
                case 22: {
                    gET2.setValueInt(ESystem.getPopupboxwider());
                    break;
                }
                case 23: {
                    gET2.setValueInt(ESystem.getPopupboxinversvideo());
                    break;
                }
                case 24: {
                    gET2.setValueString(this.getClipboard());
                    break;
                }
                case 27: {
                    gET2.setValueString(this.getLookAndFeel());
                    break;
                }
                case 28: {
                    gET2.setValueString(this.getPrintCommand());
                    break;
                }
                case 29: {
                    gET2.setValueString(this.getDefaultPrinter());
                    break;
                }
                case 30: {
                    gET2.setValueString(this.getPrintersCommand());
                    break;
                }
                case 31: {
                    gET2.setValueString(this.getPrintersFilter());
                    break;
                }
                case 32: {
                    gET2.setValueInt(this.getNotifyBusy());
                    break;
                }
                case 33: {
                    gET2.setValueInt(this.getMultiscreen());
                    break;
                }
                case 34: {
                    gET2.setValueString(this.getEditMode());
                    break;
                }
                case 36: {
                    gET2.setValueInt(this.getKeepalive());
                    break;
                }
                case 37: {
                    gET2.setValueInt(this.getTypeAhead());
                    break;
                }
                case 38: {
                    gET2.setValueString(this.getClipboardContextMenu());
                    break;
                }
                case 40: {
                    gET2.setValueInt(this.getEnableReferenceAttr());
                    break;
                }
                case 41: {
                    gET2.setValueInt(this.getEnableScaleFactorAttr());
                    break;
                }
                case 42: {
                    gET2.setValueInt(this.getEnableMaximizeAttr());
                    break;
                }
                case 43: {
                    gET2.setValueInt(this.getEnableSnapAttr());
                    break;
                }
                case 44: {
                    gET2.setValueInt(this.getSnapAdjustSizeAttr());
                    break;
                }
                case 45: {
                    gET2.setValueString(this.getSnapMargin());
                    break;
                }
                case 51: {
                    gET2.setValueInt(this.getDialogWOverlap());
                    break;
                }
                case 52: {
                    gET2.setValueInt(this.getDialogHOverlap());
                    break;
                }
                case 53: {
                    gET2.setValueInt(this.getDialogScroll());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    protected ESystem() {
        this.setId("system");
        this.browserAccessor = new BrowserAccessor();
        int n = "eloquence.config.atom.".length();
        Enumeration<?> enumeration = StartUp.SysConfig.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() <= n || !string.startsWith("eloquence.config.atom.")) continue;
            if (this.atomMap == null) {
                this.atomMap = new HashMap();
            }
            this.atomMap.put(string.substring(n).toLowerCase(), new UnifiedData(StartUp.SysConfig.getProperty(string)));
        }
    }

    public static ESystem getObject() {
        if (object == null) {
            object = new ESystem();
        }
        return object;
    }

    public void dispose() {
    }

    static {
        attributeList.put(CLASS_ATTR_NAME, new Integer(0));
        attributeList.put(RETURN_LCASE_ATTR_NAME, new Integer(1));
        attributeList.put(DRIVER_ATTR_NAME, new Integer(2));
        attributeList.put(VERSION_ATTR_NAME, new Integer(3));
        attributeList.put(JDLGVERSION_ATTR_NAME, new Integer(4));
        attributeList.put(IPADDRESS_ATTR_NAME, new Integer(5));
        attributeList.put(DNSNAME_ATTR_NAME, new Integer(6));
        attributeList.put(DLGPORT_ATTR_NAME, new Integer(7));
        attributeList.put(BASEURL_ATTR_NAME, new Integer(8));
        attributeList.put(HELPBASEURL_ATTR_NAME, new Integer(9));
        attributeList.put(SCRENNRESOLUTION_ATTR_NAME, new Integer(10));
        attributeList.put(SCREENWIDTH_ATTR_NAME, new Integer(11));
        attributeList.put(SCREENHEIGHT_ATTR_NAME, new Integer(12));
        attributeList.put(OSNAME_ATTR_NAME, new Integer(13));
        attributeList.put(OSVERSION_ATTR_NAME, new Integer(14));
        attributeList.put(OSARCH_ATTR_NAME, new Integer(15));
        attributeList.put(USERNAME_ATTR_NAME, new Integer(16));
        attributeList.put(USERDIR_ATTR_NAME, new Integer(17));
        attributeList.put(WORKINGDIR_ATTR_NAME, new Integer(18));
        attributeList.put(JAVAVERSION_ATTR_NAME, new Integer(19));
        attributeList.put(JAVAVENDOR_ATTR_NAME, new Integer(20));
        attributeList.put(JAVAHOME_ATTR_NAME, new Integer(21));
        attributeList.put(POPUPBOXWIDER_ATTR_NAME, new Integer(22));
        attributeList.put(POPUPBOXINVERSVIDEO_ATTR_NAME, new Integer(23));
        attributeList.put(CLIPBOARD_ATTR_NAME, new Integer(24));
        attributeList.put(BEEP_ATTR_NAME, new Integer(25));
        attributeList.put(SOUND_ATTR_NAME, new Integer(26));
        attributeList.put(LOOKANDFEEL_ATTR_NAME, new Integer(27));
        attributeList.put(PRINTCOMMAND_ATTR_NAME, new Integer(28));
        attributeList.put(PRINTERSCOMMAND_ATTR_NAME, new Integer(30));
        attributeList.put(PRINTERSFILTER_ATTR_NAME, new Integer(31));
        attributeList.put(DEFAULTPRINTER_ATTR_NAME, new Integer(29));
        attributeList.put(NOTIFYBUSY_ATTR_NAME, new Integer(32));
        attributeList.put(MULTISCREEN_ATTR_NAME, new Integer(33));
        attributeList.put(EDITMODE_ATTR_NAME, new Integer(34));
        attributeList.put(ACTIVATE_ATTR_NAME, new Integer(35));
        attributeList.put(KEEPALIVE_ATTR_NAME, new Integer(36));
        attributeList.put(TYPEAHEAD_ATTR_NAME, new Integer(37));
        attributeList.put(CLIPBOARDCONTEXTMENU_ATTR_NAME, new Integer(38));
        attributeList.put(START_ATTR_NAME, new Integer(39));
        attributeList.put(ENABLE_REFERENCE_ATTR_NAME, new Integer(40));
        attributeList.put(ENABLE_SCALEFACTOR_ATTR_NAME, new Integer(41));
        attributeList.put(ENABLE_MAXIMIZE_ATTR_NAME, new Integer(42));
        attributeList.put(ENABLE_SNAP_ATTR_NAME, new Integer(43));
        attributeList.put(SNAP_ADJUST_SIZE_ATTR_NAME, new Integer(44));
        attributeList.put(SNAP_MARGIN_ATTR_NAME, new Integer(45));
        attributeList.put(ATOM_ATTR_NAME, new Integer(46));
        attributeList.put(ATOMS_ATTR_NAME, new Integer(47));
        attributeList.put(PLUGIN_ATTR_NAME, new Integer(48));
        attributeList.put(NOTIFY_ATTR_NAME, new Integer(49));
        attributeList.put(NOTIFY_ALL_ATTR_NAME, new Integer(50));
        attributeList.put(DIALOG_W_OVERLAP_ATTR_NAME, new Integer(51));
        attributeList.put(DIALOG_H_OVERLAP_ATTR_NAME, new Integer(52));
        attributeList.put(DIALOG_SCROLL_ATTR_NAME, new Integer(53));
        typeAhead = new TypeAheadManager();
    }

    public static final class TypeAheadManager
    extends EventQueue {
        private boolean enabled = false;
        private boolean allowEvents = false;
        private boolean blocked = false;
        private LinkedList items;
        private Frame topWindow = null;
        private Object currentSession = null;
        private LinkedList activeWindows;
        private Watchdog watchdog = new Watchdog();
        private static final int watchdogTimeout = 10;
        private static final int DISPATCH_FILTER_COUNT_THRESHOLD = 30;
        private static final int DISPATCH_FILTER_TIME_THRESHOLD = 50;
        private int dispatchFilterCount = 0;
        private int dispatchFilterLastHash = 0;
        private long dispatchFilterLastTime = 0L;
        private static final int TIMEOUT = 10000;
        private javax.swing.Timer timeout = null;

        public TypeAheadManager() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TypeAheadManager.this.watchdog.setEventDispatchingThread(Thread.currentThread());
                }
            });
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)this.watchdog, 2500L, 2500L);
            this.items = new LinkedList();
            this.activeWindows = new LinkedList();
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
        }

        protected void finalize() throws Throwable {
            this.items = null;
            this.topWindow = null;
            this.currentSession = null;
            this.activeWindows = null;
            super.finalize();
        }

        public final void enable(boolean bl) {
            if (bl) {
                this.enabled = true;
            } else {
                this.enabled = false;
                this.clear();
            }
        }

        public final synchronized void setTopWindow(Frame frame, Object object) {
            if (frame != this.topWindow) {
                this.topWindow = frame;
                this.allowEvents = this.activeWindows.contains(this.topWindow);
            }
            if (object != this.currentSession) {
                this.currentSession = object;
                this.clear();
            }
        }

        public final synchronized void allowEvents(boolean bl, Frame frame) {
            boolean bl2;
            if (bl) {
                if (!this.activeWindows.contains(frame)) {
                    this.activeWindows.add(frame);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            } else {
                bl2 = this.activeWindows.remove(frame);
            }
            if (bl2) {
                this.allowEvents = this.activeWindows.contains(this.topWindow);
            }
        }

        public final void clear() {
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.items.size() != 0) {
                    this.stopTimeout();
                    this.items.clear();
                    TypeAheadManager.notifyBusy();
                }
                this.blocked = false;
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (TypeAheadManager.this.items.size() != 0) {
                                TypeAheadManager.this.stopTimeout();
                                TypeAheadManager.this.items.clear();
                                TypeAheadManager.notifyBusy();
                            }
                            TypeAheadManager.this.blocked = false;
                        }
                    });
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }

        private final boolean enqueue(KeyEvent keyEvent) {
            if (!this.blocked) {
                switch (keyEvent.getID()) {
                    case 401: {
                        if (keyEvent.isActionKey()) break;
                        int n = keyEvent.getKeyCode();
                        if (n == 9 || n == 10) {
                            if (keyEvent.getModifiers() != 0) break;
                            TypeAheadItem typeAheadItem = this.itemToEnqueue();
                            typeAheadItem.termChar = n;
                            return true;
                        }
                        if (n < 32 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) break;
                        return true;
                    }
                    case 400: {
                        char c = keyEvent.getKeyChar();
                        if (c != '\uffff' && c >= ' ') {
                            TypeAheadItem typeAheadItem = this.itemToEnqueue();
                            if (typeAheadItem.chars == null) {
                                typeAheadItem.chars = new StringBuilder();
                            }
                            typeAheadItem.chars.append(c);
                        }
                        return true;
                    }
                    default: {
                        return true;
                    }
                }
                this.blocked = true;
            }
            return false;
        }

        private final TypeAheadItem itemToEnqueue() {
            TypeAheadItem typeAheadItem;
            this.startTimeout();
            if (this.items.size() != 0) {
                typeAheadItem = (TypeAheadItem)this.items.getLast();
                if (typeAheadItem.termChar == 0) {
                    return typeAheadItem;
                }
            }
            typeAheadItem = new TypeAheadItem();
            this.items.addLast(typeAheadItem);
            return typeAheadItem;
        }

        public final void pushItem(TypeAheadItem typeAheadItem) {
            this.items.addFirst(typeAheadItem);
            this.startTimeout();
        }

        public final TypeAheadItem nextItem() {
            int n = this.items.size();
            if (n <= 1) {
                this.blocked = false;
            }
            if (n != 0) {
                return (TypeAheadItem)this.items.removeFirst();
            }
            return null;
        }

        public final void processPendingEvents(AbstractControl abstractControl) {
            this.stopTimeout();
            TypeAheadItem typeAheadItem = this.nextItem();
            if (typeAheadItem != null && !abstractControl.acceptTypeAhead(typeAheadItem)) {
                this.clear();
            }
            if (this.items.size() != 0) {
                this.startTimeout();
            }
        }

        protected void dispatchEvent(AWTEvent aWTEvent) {
            int n = aWTEvent.getID();
            if (n == 1200 && aWTEvent.paramString().indexOf(",runnable=sun.awt.windows.WInputMethod$1@") > 0) {
                int n2;
                long l = System.currentTimeMillis();
                Object object = aWTEvent.getSource();
                int n3 = n2 = object != null ? object.hashCode() : 0;
                if (n2 != this.dispatchFilterLastHash) {
                    this.dispatchFilterCount = 0;
                    this.dispatchFilterLastHash = n2;
                } else if (this.dispatchFilterLastTime != 0L && l - this.dispatchFilterLastTime <= 50L) {
                    if (++this.dispatchFilterCount >= 30) {
                        if (Debug.isLog(2, 1)) {
                            Debug.log(2, 1, "NOTE: event filtered: " + aWTEvent.paramString());
                        }
                        this.dispatchFilterLastTime = l;
                        return;
                    }
                } else {
                    this.dispatchFilterCount = 0;
                }
                this.dispatchFilterLastTime = l;
            }
            this.watchdog.begin();
            if (this.enabled && aWTEvent instanceof InputEvent) {
                Component component;
                InputEvent inputEvent = (InputEvent)aWTEvent;
                for (component = inputEvent.getComponent(); component != null && !(component instanceof Window); component = component.getParent()) {
                }
                if (component == null || !(component instanceof EDialog.DialogWindow) && !(component instanceof EPopupBox.PopupBoxWindow)) {
                    super.dispatchEvent(aWTEvent);
                    this.watchdog.end();
                    return;
                }
                if (inputEvent instanceof KeyEvent) {
                    boolean bl;
                    if (this.blocked) {
                        bl = true;
                    } else if (!this.allowEvents || this.items.size() != 0) {
                        if (this.enqueue((KeyEvent)aWTEvent)) {
                            inputEvent.consume();
                            this.watchdog.end();
                            return;
                        }
                        bl = true;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        inputEvent.consume();
                        TypeAheadManager.notifyBusy();
                        this.watchdog.end();
                        return;
                    }
                } else if (inputEvent instanceof MouseEvent && n == 501) {
                    this.clear();
                }
            }
            super.dispatchEvent(aWTEvent);
            this.watchdog.end();
        }

        private static void notifyBusy() {
            ESystem.getObject().notifyBusy();
        }

        private final void startTimeout() {
            if (this.timeout == null) {
                this.timeout = new javax.swing.Timer(10000, new Timeout());
                this.timeout.setRepeats(false);
                this.timeout.start();
            } else {
                this.timeout.restart();
            }
        }

        private final void stopTimeout() {
            if (this.timeout != null) {
                this.timeout.stop();
                this.timeout = null;
            }
        }

        private final class Watchdog
        extends TimerTask {
            private final Object lock = new Object();
            private long timestamp = -1L;
            private boolean timestampModified;
            private Thread edt;

            private Watchdog() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setEventDispatchingThread(Thread thread) {
                Object object = this.lock;
                synchronized (object) {
                    this.edt = thread;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void begin() {
                if (StartUp.isInitialized()) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.timestamp = System.currentTimeMillis();
                        this.timestampModified = true;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void end() {
                Object object = this.lock;
                synchronized (object) {
                    this.timestamp = -1L;
                    this.timestampModified = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long l;
                long l2;
                Thread thread;
                Object object = this.lock;
                synchronized (object) {
                    thread = this.edt;
                    l2 = this.timestamp;
                    this.timestampModified = false;
                }
                if (thread != null && l2 != -1L && (l = System.currentTimeMillis()) - l2 >= 10000L) {
                    Object object2;
                    int n;
                    System.err.println("Java Event Dispatch Thread blocked for more than 10 seconds - signaling");
                    StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                    for (n = 0; n < stackTraceElementArray.length; ++n) {
                        object2 = stackTraceElementArray[n].toString();
                        System.err.println("  at " + (String)object2);
                    }
                    try {
                        n = 0;
                        do {
                            thread.interrupt();
                            Thread.sleep(20L);
                            object2 = this.lock;
                            synchronized (object2) {
                                thread = this.edt;
                                l2 = this.timestamp;
                                n = this.timestampModified ? 1 : 0;
                            }
                        } while (thread != null && n == 0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private final class Timeout
        implements ActionListener {
            private Timeout() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (TypeAheadManager.this.timeout != null) {
                    TypeAheadManager.this.timeout = null;
                    TypeAheadManager.this.clear();
                }
            }
        }
    }

    public static final class TypeAheadItem {
        public StringBuilder chars = null;
        public int termChar = 0;
    }
}

