/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.EListBox;
import com.eloquence.services.jdlg.controls.PositionInterface;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.table.TableColumn;

public class ETableHeader
extends AbstractControl {
    private static HashMap attributeList = new HashMap();
    private static final int TITLE_ATTR_ID = 0;
    private static final int COLTYPE_ATTR_ID = 1;
    private static final int RESIZABLE_ATTR_ID = 2;
    private static final int INDEX_ATTR_ID = 3;
    private static final int VINDEX_ATTR_ID = 4;
    private static final int ALIGN_ATTR_ID = 5;
    private static final int AUTOWIDTH_ATTR_ID = 6;
    private static final int SORTTEMPLATE_ATTR_ID = 7;
    private static final int FILTERHTML_ATTR_ID = 8;
    private static final int FORMAT_ATTR_ID = 9;
    private static final int VISIBLE_ATTR_ID = 10;
    private static final int LINE_ATTR_ID = 11;
    private static final int LINE_BUF_ATTR_ID = 12;
    private static final int VLINE_ATTR_ID = 13;
    private static final int VLINE_BUF_ATTR_ID = 14;
    private static final int MARGIN_ATTR_ID = 15;
    private static final int USERHIDE_ATTR_ID = 16;
    public static final String CLASS_ATTR_NAME = "ListBoxHeader";
    private static final String INDEX_ATTR_NAME = "index";
    private static final String VINDEX_ATTR_NAME = "vindex";
    private static final String COLTYPE_ATTR_NAME = "coltype";
    public static final int COLTYPE_STRING = 0;
    public static final int COLTYPE_NUMERIC = 1;
    public static final int COLTYPE_BOOLEAN = 2;
    public static final int COLTYPE_PROGRESS = 3;
    public static final int COLTYPE_SELECT = 4;
    public static final int COLTYPE_FOLDED = 5;
    public static final int COLTYPE_DATE = 6;
    private int colType = 0;
    private static final String SORTTEMPLATE_ATTR_NAME = "sorttemplate";
    private static final String FILTERHTML_ATTR_NAME = "filterhtml";
    private boolean enableFilter = false;
    private static final String TEXTPOS_ATTR_NAME = "textpos";
    private static final String ALIGN_ATTR_NAME = "align";
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private int textpos = 0;
    private static final String TITLE_ATTR_NAME = "title";
    private String title = "";
    private static final int DEFAULT_WIDTH = 8;
    private boolean widthModified = false;
    private static final String RESIZABLE_ATTR_NAME = "resizable";
    private boolean resizable = true;
    private boolean resizableModified = true;
    private static final String LINE_ATTR_NAME = "line";
    private static final String VLINE_ATTR_NAME = "vline";
    private static final String AUTOWIDTH_ATTR_NAME = "autowidth";
    private boolean autoWidth = false;
    private static final String FORMAT_ATTR_NAME = "format";
    private String formatString = null;
    private Format inFormat = null;
    private Format outFormat = null;
    private static final String MARGIN_ATTR_NAME = "margin";
    private int marginAttr = 0;
    private boolean marginAttrSet = false;
    private int cellMargin = 0;
    private static final String USERHIDE_ATTR_NAME = "userhide";
    private boolean userHide = true;
    private int viewSortKey = 0;
    protected TableColumn hiddenColumn = null;
    private boolean layoutInvoked = false;
    private int layoutCellWidth = 0;

    public ETableHeader() {
        this.peer = new EJTableHeader();
        this.isModified = true;
    }

    public void postConstruction() {
        super.postConstruction();
        this.peer.removeMouseListener(this);
    }

    public Object clone() {
        ETableHeader eTableHeader = new ETableHeader();
        this.cloneAttributes(eTableHeader);
        return eTableHeader;
    }

    protected final void cloneAttributes(ETableHeader eTableHeader) {
        super.cloneAttributes(eTableHeader);
        eTableHeader.setColType(this.getColType());
        eTableHeader.setResizable(this.getResizable());
        eTableHeader.setTextposCode(this.getTextposCode());
        eTableHeader.setTitle(this.getTitle());
        eTableHeader.setAutoWidth(this.autoWidth ? 1 : 0);
        if (this.formatString != null) {
            eTableHeader.setFormat(this.getFormat());
        }
        if (this.marginAttrSet) {
            eTableHeader.setMarginAttr(this.marginAttr);
        }
        eTableHeader.userHide = this.userHide;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
        }
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 11: {
                        return this.setLine(sET.getValueString(), this.getInt(sET.index));
                    }
                }
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setTitle(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setColType(sET.getValueInt());
                    break;
                }
                case 2: {
                    this.setResizable(sET.getValueInt());
                    break;
                }
                case 5: {
                    this.setTextpos(sET.getValueString());
                    break;
                }
                case 6: {
                    this.setAutoWidth(sET.getValueInt());
                    break;
                }
                case 9: {
                    this.setFormat(sET.getValueString());
                    break;
                }
                case 10: {
                    this.setColumnVisible(sET.getValueInt());
                    break;
                }
                case 11: {
                    return this.setLine(sET.getValueString(), 0);
                }
                case 15: {
                    this.setMarginAttr(sET.getValueInt());
                    break;
                }
                case 16: {
                    this.setUserHide(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 11: {
                        if (gET2.setValueString(this.getLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    case 13: {
                        if (gET2.setValueString(this.getVLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getTitle());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getColType());
                    break;
                }
                case 2: {
                    gET2.setValueInt(this.getResizable());
                    break;
                }
                case 5: {
                    gET2.setValueString(this.getTextpos());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getIndex());
                    break;
                }
                case 4: {
                    gET2.setValueInt(this.getVIndex());
                    break;
                }
                case 9: {
                    gET2.setValueString(this.getFormat());
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getColumnVisible());
                    break;
                }
                case 11: {
                    if (gET2.setValueString(this.getLine(0))) break;
                    return 11;
                }
                case 12: {
                    gET2.setValueString(this.getLineBuf());
                    break;
                }
                case 13: {
                    if (gET2.setValueString(this.getVLine(0))) break;
                    return 11;
                }
                case 14: {
                    gET2.setValueString(this.getVLineBuf());
                    break;
                }
                case 15: {
                    gET2.setValueInt(this.getMarginAttr());
                    break;
                }
                case 16: {
                    gET2.setValueInt(this.getUserHide());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public int setParent(AbstractControlContainer abstractControlContainer) {
        if (!(abstractControlContainer instanceof EListBox)) {
            return 9;
        }
        return super.setParent(abstractControlContainer);
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public int getIndex() {
        return ((EListBox)this.parent).getColumnModelID(this);
    }

    public int getVIndex() {
        return ((EListBox)this.parent).getColumnViewID(this);
    }

    public final int setColType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return 11;
            }
        }
        this.colType = n;
        return 0;
    }

    public final int getColType() {
        return this.colType;
    }

    public int setSortTemplate(String string) {
        return 0;
    }

    public String getSortTemplate() {
        return "";
    }

    public void setFilterHTML(int n) {
        this.enableFilter = n != 0;
    }

    public int getFilterHTML() {
        return this.enableFilter ? 1 : 0;
    }

    public int getSensitive() {
        return 0;
    }

    public final int setTextpos(String string) {
        if (string.equalsIgnoreCase("left")) {
            this.textpos = 0;
        } else if (string.equalsIgnoreCase("center")) {
            this.textpos = 1;
        } else if (string.equalsIgnoreCase("right")) {
            this.textpos = 2;
        } else {
            return 11;
        }
        this.isModified = true;
        return 0;
    }

    public final int setTextposCode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return 11;
            }
        }
        this.textpos = n;
        this.isModified = true;
        return 0;
    }

    public final String getTextpos() {
        switch (this.textpos) {
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return "left";
    }

    public final int getTextposCode() {
        return this.textpos;
    }

    public final int setTitle(String string) {
        this.title = string;
        this.isModified = true;
        return 0;
    }

    public final String getTitle() {
        return this.title;
    }

    public void setWidth(int n) {
        super.setWidth(n);
        this.widthModified = true;
        this.autoWidth = false;
    }

    private final int pixelWidth(int n, Scaling scaling) {
        int n2 = this.getWidth();
        if (this.useRasterSize) {
            int n3 = this.getLayoutCellWidth();
            n2 *= n3;
            if (n > 0) {
                return n2 + n * n3;
            }
        } else {
            n2 = (int)Math.round((double)n2 * scaling.x);
        }
        return n2;
    }

    private final int dlgWidth(int n, int n2, Scaling scaling) {
        if (this.useRasterSize) {
            int n3 = (int)Math.ceil((double)n / (double)this.getLayoutCellWidth());
            return n3 > n2 ? n3 - n2 : 0;
        }
        if (scaling == null) {
            scaling = this.getScaling();
        }
        int n4 = (int)Math.round((double)n / scaling.x);
        return n4;
    }

    public void setResizable(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl != this.resizable) {
            this.resizable = bl;
            this.resizableModified = true;
            this.isModified = true;
        }
    }

    public int getResizable() {
        return this.resizable ? 1 : 0;
    }

    public String getLine(int n) {
        EListBox eListBox = (EListBox)this.parent;
        n = n < 1 ? eListBox.getCy() : --n;
        EListBox.EJTableModel eJTableModel = eListBox.tmodel;
        if (n > eJTableModel.getRowCount()) {
            return null;
        }
        return eJTableModel.getValueAt(n, eListBox.getColumnModelID(this)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLine(String string, int n) {
        EListBox eListBox = (EListBox)this.parent;
        n = n < 1 ? eListBox.getCy() : --n;
        eListBox.cn.safeCommit();
        EListBox.EJTableModel eJTableModel = eListBox.tmodel;
        if (n > eJTableModel.getRowCount()) {
            return 11;
        }
        EListBox eListBox2 = eListBox;
        synchronized (eListBox2) {
            eJTableModel.setValueAt(string, n, eListBox.getColumnModelID(this));
        }
        return 0;
    }

    private String getLineBuf() {
        EListBox eListBox = (EListBox)this.parent;
        eListBox.cn.safeCommit();
        EListBox.EJTableModel eJTableModel = eListBox.tmodel;
        int n = eListBox.getColumnModelID(this);
        StringBuilder stringBuilder = new StringBuilder();
        String string = eListBox.newline ? "\r\n" : "\n";
        int n2 = eJTableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(eJTableModel.getValueAt(i, n).toString());
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getVLine(int n) {
        EListBox eListBox = (EListBox)this.parent;
        n = n < 1 ? eListBox.getCy() : --n;
        eListBox.cn.safeCommit();
        EListBox.EJTableModel eJTableModel = eListBox.tmodel;
        if (n > eJTableModel.getRowCount()) {
            return null;
        }
        return eJTableModel.getValueAt(eListBox.tsorter.modelIndex(n), eListBox.getColumnModelID(this)).toString();
    }

    private String getVLineBuf() {
        EListBox eListBox = (EListBox)this.parent;
        eListBox.cn.safeCommit();
        EListBox.EJTableModel eJTableModel = eListBox.tmodel;
        int n = eListBox.getColumnModelID(this);
        StringBuilder stringBuilder = new StringBuilder();
        String string = eListBox.newline ? "\r\n" : "\n";
        int n2 = eJTableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(eJTableModel.getValueAt(eListBox.tsorter.modelIndex(i), n).toString());
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void setAutoWidth(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl != this.autoWidth) {
            this.autoWidth = bl;
            if (bl) {
                this.setLayoutChanged();
            }
        }
    }

    private void setFormat(String string) {
        this.formatString = string != null && string.length() > 0 ? string : null;
        this.outFormat = null;
    }

    private String getFormat() {
        return this.formatString != null ? this.formatString : "";
    }

    public String getFormattedValue(String string) {
        if (string.length() == 0) {
            return string;
        }
        String string2 = this.formatString;
        if (string2 != null) {
            try {
                if (this.colType == 1 || this.colType == 6) {
                    String string3 = HtmlTool.text(string);
                    if (string3 == string) {
                        string3 = null;
                    }
                    if (this.colType == 1) {
                        int n;
                        DecimalFormat decimalFormat;
                        if (this.inFormat != null) {
                            this.inFormat = null;
                        }
                        if (this.outFormat instanceof DecimalFormat) {
                            decimalFormat = (DecimalFormat)this.outFormat;
                        } else {
                            decimalFormat = new DecimalFormat(string2);
                            this.outFormat = decimalFormat;
                        }
                        if (string3 != null && (n = string.indexOf(string3)) >= 0) {
                            return string.substring(0, n).concat(decimalFormat.format(Double.parseDouble(string3))).concat(string.substring(n + string3.length()));
                        }
                        return decimalFormat.format(Double.parseDouble(string));
                    }
                    if (this.colType == 6 && !(string3 == null ? string.length() != 8 : string3.length() != 8)) {
                        int n;
                        SimpleDateFormat simpleDateFormat;
                        SimpleDateFormat simpleDateFormat2;
                        if (this.inFormat instanceof SimpleDateFormat) {
                            simpleDateFormat2 = (SimpleDateFormat)this.inFormat;
                        } else {
                            simpleDateFormat2 = new SimpleDateFormat("yyyyMMdd");
                            this.inFormat = simpleDateFormat2;
                        }
                        if (this.outFormat instanceof SimpleDateFormat) {
                            simpleDateFormat = (SimpleDateFormat)this.outFormat;
                        } else {
                            simpleDateFormat = new SimpleDateFormat(string2);
                            this.outFormat = simpleDateFormat;
                        }
                        if (string3 != null && (n = string.indexOf(string3)) >= 0) {
                            return string.substring(0, n).concat(simpleDateFormat.format(simpleDateFormat2.parse(string3))).concat(string.substring(n + string3.length()));
                        }
                        return simpleDateFormat.format(simpleDateFormat2.parse(string));
                    }
                }
            }
            catch (Throwable throwable) {
                Debug.log(0, 2, this.getPath() + " ListBoxHeader.format error: " + throwable.getLocalizedMessage());
                string2 = null;
            }
        }
        if (string2 == null && this.colType == 6 && string.length() == 8) {
            return string.substring(6, 8) + "." + string.substring(4, 6) + "." + string.substring(0, 4);
        }
        return string;
    }

    public void setMarginAttr(int n) {
        this.marginAttr = n;
        this.marginAttrSet = true;
    }

    public int getMarginAttr() {
        return this.marginAttr;
    }

    public int getCellMargin() {
        return this.cellMargin;
    }

    public void setUserHide(int n) {
        this.userHide = n != 0;
    }

    public int getUserHide() {
        return this.userHide ? 1 : 0;
    }

    public boolean userHide() {
        return this.userHide;
    }

    public void setColumnVisible(int n) {
        this.visible = n != 0;
        this.parent.isModified = true;
    }

    public int getColumnVisible() {
        return this.visible ? 1 : 0;
    }

    public void setViewSortKey(int n) {
        this.viewSortKey = n;
    }

    public int getViewSortKey() {
        return this.viewSortKey;
    }

    public void setHiddenColumn(TableColumn tableColumn) {
        this.hiddenColumn = tableColumn;
    }

    public TableColumn getHiddenColumn() {
        return this.hiddenColumn;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public void fontModified(Font font) {
        super.fontModified(font);
        this.layoutCellWidth = 0;
        this.widthModified = true;
        this.setLayoutChanged();
    }

    public void eloq2swing(boolean bl) {
        if (this.resizableModified) {
            this.resizableModified = false;
            EListBox eListBox = (EListBox)this.parent;
            int n = eListBox.getColumnViewID(this);
            TableColumn tableColumn = n >= 0 ? eListBox.table.getColumnModel().getColumn(n) : this.getHiddenColumn();
            if (tableColumn != null) {
                tableColumn.setResizable(this.resizable);
            }
        }
        if (this.widthModified || this.autoWidth) {
            this.setLayoutChanged();
        }
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        EListBox eListBox;
        int n;
        if (!this.widthModified && this.visible && this.parent.getPeer().isShowing() && (n = (eListBox = (EListBox)this.parent).getColumnViewID(this)) >= 0) {
            TableColumn tableColumn = eListBox.table.getColumnModel().getColumn(n);
            this.width = this.dlgWidth(tableColumn.getWidth(), 2, null);
        }
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        int n;
        this.layoutCellWidth = 0;
        EListBox eListBox = (EListBox)this.parent;
        int n2 = n = this.marginAttrSet ? this.marginAttr : eListBox.getColMargin();
        if (n > 0) {
            if (n == 1) {
                n = 50;
            }
            this.cellMargin = (int)Math.round((double)dimension2.width * (double)n / 100.0);
        } else {
            this.cellMargin = 0;
        }
        if (this.autoWidth) {
            int n3;
            this.autoWidth = false;
            switch (this.colType) {
                case 2: {
                    n3 = this.getHeaderWidth();
                    break;
                }
                case 3: {
                    n3 = this.pixelWidth(0, scaling);
                    break;
                }
                default: {
                    n3 = this.getWidestContent();
                }
            }
            n3 = this.dlgWidth(n3 + eListBox.getHlines() + (this.cellMargin << 1), 1, scaling);
            if (n3 != this.width) {
                this.width = n3;
                this.widthModified = true;
            }
        } else if (!this.layoutInvoked && !this.isWidthSet()) {
            this.width = this.useRasterSize ? 8 : 10 * this.fontReference.getCharWidth(1.0, 'X');
            this.widthModified = true;
        }
        if (this.widthModified) {
            this.widthModified = false;
            this.layoutWidth(eListBox, scaling);
        }
        this.layoutInvoked = true;
        return false;
    }

    public void layoutWidth(EListBox eListBox, Scaling scaling) {
        int n = eListBox.getColumnViewID(this);
        TableColumn tableColumn = n >= 0 ? eListBox.table.getColumnModel().getColumn(n) : this.getHiddenColumn();
        if (tableColumn != null) {
            int n2 = this.pixelWidth(2, scaling);
            tableColumn.setWidth(n2);
            tableColumn.setPreferredWidth(n2);
        }
    }

    private int getLayoutCellWidth() {
        if (this.layoutCellWidth == 0) {
            this.layoutCellWidth = this.fontReference.getCharWidth(this, 'X');
        }
        return this.layoutCellWidth;
    }

    public int getHeaderWidth() {
        int n = this.fontReference.getStringWidth(this, this.title);
        if (this.useRasterSize) {
            return n + 2 * this.getLayoutCellWidth();
        }
        return n;
    }

    public int getWidestContent() {
        int n;
        int n2 = 0;
        EListBox eListBox = (EListBox)this.parent;
        int n3 = eListBox.getColumnModelID(this);
        EListBox.EJTableModel eJTableModel = eListBox.tmodel;
        int n4 = eJTableModel.getRowCount();
        for (n = 0; n < n4; ++n) {
            int n5 = this.fontReference.getStringWidth(this, HtmlTool.text(this.getFormattedValue(eJTableModel.getValueAt(n, n3).toString())));
            if (n5 <= n2) continue;
            n2 = n5;
        }
        n = this.getHeaderWidth();
        return n > n2 ? n : n2;
    }

    public boolean layoutAsChild() {
        return false;
    }

    static {
        attributeList.put(TITLE_ATTR_NAME, new Integer(0));
        attributeList.put(COLTYPE_ATTR_NAME, new Integer(1));
        attributeList.put(RESIZABLE_ATTR_NAME, new Integer(2));
        attributeList.put(TEXTPOS_ATTR_NAME, new Integer(5));
        attributeList.put(ALIGN_ATTR_NAME, new Integer(5));
        attributeList.put(INDEX_ATTR_NAME, new Integer(3));
        attributeList.put(VINDEX_ATTR_NAME, new Integer(4));
        attributeList.put(AUTOWIDTH_ATTR_NAME, new Integer(6));
        attributeList.put(SORTTEMPLATE_ATTR_NAME, new Integer(7));
        attributeList.put(FILTERHTML_ATTR_NAME, new Integer(8));
        attributeList.put(FORMAT_ATTR_NAME, new Integer(9));
        attributeList.put("visible", new Integer(10));
        attributeList.put(LINE_ATTR_NAME, new Integer(11));
        attributeList.put(VLINE_ATTR_NAME, new Integer(13));
        attributeList.put(MARGIN_ATTR_NAME, new Integer(15));
        attributeList.put(USERHIDE_ATTR_NAME, new Integer(16));
    }

    class EJTableHeader
    extends JLabel
    implements PositionInterface {
        EJTableHeader() {
        }

        public void processEvents(AWTEvent aWTEvent) {
            if (!ETableHeader.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

