/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public final class TextComponentClipboardManager
implements CaretListener {
    private JTextComponent tc = null;
    private UndoManager undoBuffer = new UndoManager();
    private boolean inSelection = false;

    public TextComponentClipboardManager(JTextComponent jTextComponent) {
        this.setTextComponent(jTextComponent);
    }

    public void setTextComponent(JTextComponent jTextComponent) {
        this.tc = jTextComponent;
        jTextComponent.addCaretListener(this);
        jTextComponent.getDocument().addUndoableEditListener(this.undoBuffer);
        this.undoBuffer.discardAllEdits();
        this.inSelection = jTextComponent.getSelectedText() != null;
    }

    public void showContextMenu(String string, Point point) {
        new ContextMenu(string, point);
    }

    public void resetUndoBuffer() {
        this.undoBuffer.discardAllEdits();
    }

    public void undo() {
        block3: {
            block2: {
                if (!this.undoBuffer.canUndo()) break block2;
                while (this.undoBuffer.canUndo()) {
                    this.undoBuffer.undo();
                }
                break block3;
            }
            if (!this.undoBuffer.canRedo()) break block3;
            while (this.undoBuffer.canRedo()) {
                this.undoBuffer.redo();
            }
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        boolean bl;
        boolean bl2 = bl = caretEvent.getDot() != caretEvent.getMark();
        if (bl || this.inSelection) {
            this.undoBuffer.discardAllEdits();
        }
        this.inSelection = bl;
    }

    public static boolean isContextMenuConfigured(String string) {
        return string == null || string.length() <= 0 || !StartUp.isFalse(string);
    }

    private final class ContextMenu
    extends JPopupMenu {
        private ContextItem undoItem = null;
        private ContextItem cutItem = null;
        private ContextItem copyItem = null;
        private ContextItem pasteItem = null;
        private ContextItem deleteItem = null;
        private ContextItem selectAllItem = null;

        public ContextMenu(String string, Point point) {
            if (!this.createMenu(string)) {
                return;
            }
            this.add(this.undoItem);
            this.addSeparator();
            this.add(this.cutItem);
            this.add(this.copyItem);
            this.add(this.pasteItem);
            this.add(this.deleteItem);
            this.addSeparator();
            this.add(this.selectAllItem);
            if (TextComponentClipboardManager.this.tc.getText().length() > 0) {
                if (!TextComponentClipboardManager.this.undoBuffer.canUndoOrRedo()) {
                    this.undoItem.setEnabled(false);
                }
                if (TextComponentClipboardManager.this.tc.getSelectedText() == null) {
                    this.cutItem.setEnabled(false);
                    this.copyItem.setEnabled(false);
                    this.deleteItem.setEnabled(false);
                }
                if (!TextComponentClipboardManager.this.tc.isEditable() || !TextComponentClipboardManager.this.tc.isEnabled()) {
                    this.undoItem.setEnabled(false);
                    this.cutItem.setEnabled(false);
                    this.pasteItem.setEnabled(false);
                    this.deleteItem.setEnabled(false);
                }
            } else {
                this.selectAllItem.setEnabled(false);
            }
            boolean bl = false;
            try {
                Clipboard clipboard = TextComponentClipboardManager.this.tc.getToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(TextComponentClipboardManager.this.tc);
                if (transferable != null && transferable.getTransferData(DataFlavor.stringFlavor) != null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                this.pasteItem.setEnabled(false);
            }
            this.show(TextComponentClipboardManager.this.tc, point.x, point.y);
        }

        private void onAction(ContextItem contextItem) {
            if (contextItem == this.undoItem) {
                TextComponentClipboardManager.this.undo();
            } else if (contextItem == this.cutItem) {
                TextComponentClipboardManager.this.tc.cut();
            } else if (contextItem == this.copyItem) {
                TextComponentClipboardManager.this.tc.copy();
            } else if (contextItem == this.pasteItem) {
                TextComponentClipboardManager.this.tc.paste();
            } else if (contextItem == this.deleteItem) {
                TextComponentClipboardManager.this.tc.replaceSelection(null);
            } else if (contextItem == this.selectAllItem) {
                TextComponentClipboardManager.this.tc.selectAll();
            }
        }

        private boolean createMenu(String string) {
            if (string != null && string.length() > 0) {
                int n;
                if (StartUp.isFalse(string)) {
                    return false;
                }
                int n2 = 0;
                int n3 = 0;
                while ((n = string.indexOf(124, n3)) >= n3 && this.createItem(string.substring(n3, n), n2++)) {
                    n3 = n + 1;
                }
                this.createItem(string.substring(n3), n2);
            }
            if (this.undoItem == null) {
                this.undoItem = new ContextItem("Undo", 85);
            }
            if (this.cutItem == null) {
                this.cutItem = new ContextItem("Cut", 116);
            }
            if (this.copyItem == null) {
                this.copyItem = new ContextItem("Copy", 67);
            }
            if (this.pasteItem == null) {
                this.pasteItem = new ContextItem("Paste", 80);
            }
            if (this.deleteItem == null) {
                this.deleteItem = new ContextItem("Delete", 68);
            }
            if (this.selectAllItem == null) {
                this.selectAllItem = new ContextItem("Select All", 65);
            }
            return true;
        }

        private boolean createItem(String string, int n) {
            ContextItem contextItem = null;
            if (string.length() > 0) {
                int n2 = string.indexOf(38);
                if (n2 >= 0) {
                    char c = string.charAt(n2 + 1);
                    String string2 = string.substring(n2 + 1);
                    string = n2 > 0 ? string.substring(0, n2).concat(string2) : string2;
                    contextItem = new ContextItem(string, c);
                } else {
                    contextItem = new ContextItem(string);
                }
            }
            switch (n) {
                case 0: {
                    this.undoItem = contextItem;
                    return true;
                }
                case 1: {
                    this.cutItem = contextItem;
                    return true;
                }
                case 2: {
                    this.copyItem = contextItem;
                    return true;
                }
                case 3: {
                    this.pasteItem = contextItem;
                    return true;
                }
                case 4: {
                    this.deleteItem = contextItem;
                    return true;
                }
                case 5: {
                    this.selectAllItem = contextItem;
                    return true;
                }
            }
            return false;
        }

        private final class ContextItem
        extends JMenuItem
        implements ActionListener {
            ContextItem(String string) {
                super(string);
                this.addActionListener(this);
            }

            ContextItem(String string, int n) {
                super(string, n);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ContextMenu.this.onAction(this);
            }
        }
    }
}

