/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.protocols.dlg;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.protocols.dlg.Dmdrv;
import com.eloquence.services.tools.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class Dmdrv_V2
extends Dmdrv {
    private CharsetDecoder csDecoder;
    private CharsetEncoder csEncoder;
    private boolean exec = true;
    private boolean statusPending;
    private int rqIdx;
    private int rqCnt;
    private int rqOff;
    private static final int V2_STATUS = 32;
    private static final int V2_STATUS_CACHE = 40;
    private static final int V2_STATUS_UNCACHE = 47;
    private static final int V2_GET_CACHE = 48;
    private int seq;
    private byte[] rbf;
    private int rbf_used;
    private int rbf_off;
    private byte[] sbf;
    private int sbf_off;
    private static final int VARINT_MAX = 5;
    private static final int BF_BLOCKSIZE = 20480;
    private Inflater inflater = null;
    private static final int SBF_PREFIX = 22;
    private Deflater deflater = null;
    private Paths paths;
    private Attrs attrs;

    Dmdrv_V2() {
        Charset charset = Charset.forName("UTF-8");
        this.csDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.csEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.rs_DO.cache = new Dlg.Rs.DO.Cache();
    }

    void dispose() {
        super.dispose();
        this.csDecoder = null;
        this.csEncoder = null;
        this.rbf = null;
        this.sbf = null;
        if (this.paths != null) {
            this.paths.dispose();
            this.paths = null;
        }
        if (this.attrs != null) {
            this.attrs.dispose();
            this.attrs = null;
        }
        this.inflater = null;
        this.deflater = null;
    }

    boolean exec(Dlg dlg) throws IOException, InterruptedException {
        if (!this.exec) {
            throw new RuntimeException("Duplicate invocation of DLG protocol handler");
        }
        InputStream inputStream = dlg.sck.getInputStream();
        OutputStream outputStream = dlg.sck.getOutputStream();
        while (this.exec) {
            if (!this.rqRecv(inputStream)) {
                dlg.connectionReset(null);
                dlg.stopSession();
                this.exec = false;
                return false;
            }
            int n = this.rbf_off;
            int n2 = this.decodeUint();
            int n3 = this.decodeUint();
            this.checkTag(n2, 1, n);
            n = this.rbf_off;
            this.decodePaths();
            this.checkTagSize(n2, n, n3);
            n = this.rbf_off;
            n2 = this.decodeUint();
            n3 = this.decodeUint();
            this.checkTag(n2, 2, n);
            n = this.rbf_off;
            this.decodeAttrs();
            this.checkTagSize(n2, n, n3);
            n = this.rbf_off;
            n2 = this.decodeUint();
            n3 = this.decodeUint();
            this.checkTag(n2, 3, n);
            n = this.rbf_off;
            this.rqCnt = this.decodeUint();
            this.encodeInit();
            this.statusPending = false;
            this.rqIdx = 0;
            while (this.rqIdx < this.rqCnt && !this.statusPending) {
                this.rqOff = this.rbf_off;
                Dlg.Rq rq = this.rq(this.decodeUint());
                if (rq == null || !rq.exec(dlg)) {
                    if (rq != null) {
                        rq.dispose();
                    }
                    this.protocolFailed(outputStream);
                    this.exec = false;
                    return false;
                }
                rq.dispose();
                ++this.rqIdx;
            }
            if (this.rqIdx == this.rqCnt) {
                this.checkTagSize(n2, n, n3);
            }
            this.rsSend(outputStream, 0);
        }
        return false;
    }

    private void protocolFailed(OutputStream outputStream) {
        try {
            this.rsSend(outputStream, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkTag(int n, int n2, int n3) {
        if (n != n2) {
            throw new RuntimeException("DLG client request not recognized, offset: " + n3 + ", received tag: #" + n + ", expected: #" + n2);
        }
    }

    private void checkTagSize(int n, int n2, int n3) {
        if (this.rbf_off != n2 + n3) {
            throw new RuntimeException("DLG client tag #" + n + " size mismatch, offset: " + this.rbf_off + ", received: " + n3 + ", expected: " + (this.rbf_off - n2));
        }
    }

    void stopReceived() {
        this.exec = false;
    }

    private void assertLastRequest(Dlg.Rq rq) {
        if (this.rqIdx != this.rqCnt - 1) {
            throw new RuntimeException("DLG client request '" + rq.getClass().getName() + "' unexpectedly followed by " + (this.rqCnt - this.rqIdx - 1) + " more requests, offset: " + this.rqOff);
        }
    }

    boolean decode(Dlg.Rq.STOP sTOP) {
        this.assertLastRequest(sTOP);
        return true;
    }

    boolean decode(Dlg.Rq.LOAD lOAD) {
        this.assertLastRequest(lOAD);
        this.decodeSkipString();
        return true;
    }

    boolean decode(Dlg.Rq.NEW nEW) {
        nEW.path = this.getPath(this.decodeUint());
        nEW.classnm = this.decodeString();
        return true;
    }

    boolean decode(Dlg.Rq.DEL dEL) {
        dEL.path = this.getPath(this.decodeUint());
        return true;
    }

    private String index(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 0 && string.charAt(n2 - 1) == ']' && (n = string.indexOf(91)) != -1) {
            return string.substring(n + 1, n2 - 1);
        }
        return null;
    }

    boolean decode(Dlg.Rq.SET sET) {
        int n = this.decodeUint();
        sET.path = n != 0 ? this.getPath(n) : null;
        sET.attr = this.getAttr(this.decodeUint());
        sET.index = this.index(sET.attr);
        if (sET.index != null) {
            sET.attr = sET.attr.substring(0, sET.attr.length() - sET.index.length() - 2);
        }
        sET.v_type = this.decodeUint();
        switch (sET.v_type) {
            case 0: {
                sET.v_iv = 0;
                sET.v_sv = null;
                sET.v_bv = null;
                sET.v_bv_len = 0;
                sET.v_bv_off = 0;
                break;
            }
            case 1: {
                sET.v_iv = this.decodeInt();
                sET.v_sv = null;
                sET.v_bv = null;
                sET.v_bv_len = 0;
                sET.v_bv_off = 0;
                break;
            }
            case 2: {
                sET.v_sv = this.decodeString();
                sET.v_iv = 0;
                sET.v_bv = null;
                sET.v_bv_len = 0;
                sET.v_bv_off = 0;
                break;
            }
            case 3: {
                sET.v_bv_len = this.decodeUint();
                sET.v_bv_off = this.rbf_off;
                this.rbf_off += sET.v_bv_len;
                if (this.rbf_off > this.rbf_used) {
                    throw new RuntimeException("DLG buffer offset exceeded: " + this.rbf_off + ", max: " + this.rbf_used);
                }
                sET.v_bv = this.rbf;
                sET.v_iv = 0;
                sET.v_sv = null;
                break;
            }
            default: {
                throw new RuntimeException("DLG client invalid value type: " + sET.v_type);
            }
        }
        return true;
    }

    boolean decode(Dlg.Rq.GET gET) {
        this.assertLastRequest(gET);
        int n = this.decodeUint();
        gET.path = n != 0 ? this.getPath(n) : null;
        gET.attr = this.getAttr(this.decodeUint());
        gET.index = this.index(gET.attr);
        if (gET.index != null) {
            gET.attr = gET.attr.substring(0, gET.attr.length() - gET.index.length() - 2);
        }
        return true;
    }

    boolean decode(Dlg.Rq.DO dO) {
        this.assertLastRequest(dO);
        dO.path = this.getPath(this.decodeUint());
        return true;
    }

    boolean decode(Dlg.Rq.DRAW dRAW) {
        this.assertLastRequest(dRAW);
        dRAW.path = this.getPath(this.decodeUint());
        return true;
    }

    boolean decode(Dlg.Rq.POPUP pOPUP) {
        this.assertLastRequest(pOPUP);
        pOPUP.x = this.decodeInt();
        pOPUP.y = this.decodeInt();
        pOPUP.title = this.decodeString();
        pOPUP.text = this.decodeString().split("\n");
        pOPUP.def_btn = this.decodeInt();
        int n = this.decodeInt();
        if (n > 0) {
            pOPUP.btn = new String[n];
            for (int i = 0; i < n; ++i) {
                pOPUP.btn[i] = this.decodeString();
            }
        } else {
            pOPUP.btn = new String[0];
        }
        return true;
    }

    boolean decode(Dlg.Rq.HELP hELP) {
        hELP.tag = this.decodeString();
        return true;
    }

    boolean decode(Dlg.Rq.ASYNC aSYNC) {
        aSYNC.mode = this.decodeInt();
        return true;
    }

    boolean encode(Dlg.Rs.STATUS sTATUS) {
        if (sTATUS.attrMode < 0 || sTATUS.attrMode > 5) {
            throw new RuntimeException("BUG: rs.attrMode=" + sTATUS.attrMode);
        }
        switch (sTATUS.cacheMode) {
            case 0: {
                this.encodeUint(sTATUS.attrMode != 0 ? 0x20 | sTATUS.attrMode : 12);
                break;
            }
            case 1: {
                this.encodeUint(0x28 | sTATUS.attrMode);
                break;
            }
            case 2: {
                if (sTATUS.attrMode != 0) {
                    throw new RuntimeException("BUG: UNCACHE rs.attrMode=" + sTATUS.attrMode);
                }
                this.encodeUint(47);
                break;
            }
            default: {
                throw new RuntimeException("BUG: rs.cacheMode=" + sTATUS.cacheMode);
            }
        }
        this.encodeInt(sTATUS.status);
        if (!sTATUS.isAsync && sTATUS.status != 0) {
            this.statusPending = true;
        }
        sTATUS.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.LOAD lOAD) {
        this.encodeUint(8);
        this.encodeInt(lOAD.status);
        lOAD.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.GET gET) {
        if (gET.attrMode < 0 || gET.attrMode > 5) {
            throw new RuntimeException("BUG: rs.attrMode=" + gET.attrMode);
        }
        switch (gET.cacheMode) {
            case 0: {
                if (gET.attrMode != 0) {
                    throw new RuntimeException("BUG: NOCACHE rs.attrMode=" + gET.attrMode);
                }
                this.encodeUint(7);
                break;
            }
            case 1: {
                this.encodeUint(0x30 | gET.attrMode);
                break;
            }
            default: {
                throw new RuntimeException("BUG: rs.cacheMode=" + gET.cacheMode);
            }
        }
        if (gET.status != 0) {
            gET.v_type = 0;
        }
        this.encodeInt(gET.status);
        this.encodeUint(gET.v_type);
        switch (gET.v_type) {
            case 1: {
                this.encodeInt(gET.v_iv);
                break;
            }
            case 2: {
                this.encodeString(gET.v_sv);
                break;
            }
            case 3: {
                this.encodeData(gET.v_bv, gET.v_bv_len);
            }
        }
        gET.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.DO dO) {
        Object object;
        int n;
        this.encodeUint(10);
        this.encodeInt(dO.status);
        this.encodeInt(dO.rule);
        this.encodeString(dO.path);
        int n2 = dO.cache.nObj;
        this.encodeUint(n2);
        Dlg.Rs.DO.Cache.Obj obj = dO.cache.obj;
        while (obj != null) {
            for (n = 0; n < obj.used; ++n) {
                object = obj.c[n];
                this.encodeStringData(((AbstractControl)object).getId());
                AbstractControlContainer abstractControlContainer = ((AbstractControl)object).getParent();
                this.encodeUint(abstractControlContainer != null ? abstractControlContainer.cacheId : 0);
            }
            n2 -= obj.used;
            obj = obj.next;
        }
        if (n2 != 0) {
            throw new RuntimeException("BUG: nObj=" + n2);
        }
        n = dO.cache.nAttr;
        this.encodeUint(n);
        object = dO.cache.attr;
        while (object != null) {
            this.encodeStringData(((Dlg.Rs.DO.Cache.Attr)object).name);
            this.encodeUint(((Dlg.Rs.DO.Cache.Attr)object).mode);
            --n;
            object = ((Dlg.Rs.DO.Cache.Attr)object).next;
        }
        if (n != 0) {
            throw new RuntimeException("BUG: nAttr=" + n);
        }
        int n3 = dO.cache.nVal;
        this.encodeUint(n3);
        Dlg.Rs.DO.Cache.Val val = dO.cache.val;
        while (val != null) {
            Dlg.Rs.DO.Cache.Val val2;
            this.encodeUint(val.idObj);
            this.encodeUint(val.idAttr);
            if (val instanceof Dlg.Rs.DO.Cache.Val_INT) {
                this.encodeUint(1);
                val2 = (Dlg.Rs.DO.Cache.Val_INT)val;
                this.encodeInt(val2.iv);
            } else if (val instanceof Dlg.Rs.DO.Cache.Val_STRING) {
                this.encodeUint(2);
                val2 = (Dlg.Rs.DO.Cache.Val_STRING)val;
                this.encodeString(((Dlg.Rs.DO.Cache.Val_STRING)val2).sv);
            } else if (val instanceof Dlg.Rs.DO.Cache.Val_BINARY) {
                this.encodeUint(2);
                val2 = (Dlg.Rs.DO.Cache.Val_BINARY)val;
                this.encodeData(((Dlg.Rs.DO.Cache.Val_BINARY)val2).bv, ((Dlg.Rs.DO.Cache.Val_BINARY)val2).bv_len);
            } else {
                this.encodeUint(0);
            }
            --n3;
            val = val.next;
        }
        if (n3 != 0) {
            throw new RuntimeException("BUG: nVal=" + n3);
        }
        dO.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.POPUP pOPUP) {
        this.encodeUint(13);
        this.encodeInt(pOPUP.status);
        this.encodeInt(pOPUP.btn);
        pOPUP.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.ASYNC aSYNC) {
        this.encodeUint(16);
        this.encodeInt(aSYNC.mode);
        aSYNC.dispose();
        return true;
    }

    private static int bfSize(int n) {
        return (n + 20480 - 1) / 20480 * 20480;
    }

    private boolean rqRecv(InputStream inputStream) throws IOException {
        int n;
        if (this.rbf == null) {
            this.rbf = new byte[5];
        }
        if (!this.recv(inputStream, 0, 5)) {
            return false;
        }
        this.rbf_used = 5;
        this.rbf_used = this.decodeUi32();
        if (this.rbf_used < 9) {
            throw new RuntimeException("DLG client request size invalid: " + this.rbf_used);
        }
        int n2 = 0;
        int n3 = Dmdrv_V2.bfSize(this.rbf_used);
        if (n3 != this.rbf.length) {
            byte[] byArray = new byte[n3];
            while (this.rbf_off < 5) {
                byArray[n2++] = this.rbf[this.rbf_off++];
            }
            this.rbf = byArray;
        } else {
            while (this.rbf_off < 5) {
                this.rbf[n2++] = this.rbf[this.rbf_off++];
            }
        }
        if (this.rbf_used > n2 && !this.recv(inputStream, n2, this.rbf_used - n2)) {
            return false;
        }
        int n4 = this.decodeUint();
        if (n4 != 0) {
            if (n4 >= StartUp.dlg_log_threshold && Debug.isLog(1, 2)) {
                Debug.log(1, 2, "rqRecv: " + n4 + " (compressed " + this.rbf_used + ") bytes");
            }
            try {
                byte[] byArray = new byte[Dmdrv_V2.bfSize(n4)];
                if (this.inflater == null) {
                    this.inflater = new Inflater();
                }
                this.inflater.setInput(this.rbf, this.rbf_off, this.rbf_used - this.rbf_off);
                int n5 = this.inflater.inflate(byArray);
                if (n5 != n4) {
                    throw new RuntimeException("Failed to inflate DLG client request, data size: " + n5 + ", expected: " + n4);
                }
                if (!this.inflater.finished()) {
                    throw new RuntimeException("Failed to inflate DLG client request, compressed data is inconsistent");
                }
                this.rbf = byArray;
                this.rbf_used = n4;
                this.rbf_off = 0;
                this.inflater.reset();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to inflate DLG client request: " + throwable.toString());
            }
        } else if (this.rbf_used >= StartUp.dlg_log_threshold && Debug.isLog(1, 2)) {
            Debug.log(1, 2, "rqRecv: " + this.rbf_used + " bytes");
        }
        if (++this.seq < 0) {
            this.seq = 1;
        }
        if ((n = this.decodeUint()) != this.seq) {
            throw new RuntimeException("DLG client unexpected request sequence: " + n + ", expected: " + this.seq);
        }
        return true;
    }

    private boolean recv(InputStream inputStream, int n, int n2) throws IOException {
        if (n + n2 > this.rbf.length) {
            throw new RuntimeException("DLG buffer size exceeded: " + (n + n2) + ", max: " + this.rbf.length);
        }
        while (n2 > 0) {
            int n3 = inputStream.read(this.rbf, n, n2);
            if (n3 == -1) {
                return false;
            }
            n += n3;
            n2 -= n3;
        }
        this.rbf_off = 0;
        return true;
    }

    private void rsSend(OutputStream outputStream, int n) throws IOException {
        int n2;
        if (++this.seq < 0) {
            this.seq = 1;
        }
        if (n != 0) {
            int n3 = this.sizeUint(this.seq) + this.sizeInt(n) + 5;
            n3 = this.encodeUint(this.sbf, 0, n3);
            n3 = this.encodeUint(this.sbf, n3, 0);
            n3 = this.encodeUint(this.sbf, n3, this.seq);
            n3 = this.encodeInt(this.sbf, n3, n);
            n3 = this.encodeUint(this.sbf, n3, 1);
            n3 = this.encodeUint(this.sbf, n3, 1);
            n3 = this.encodeUint(this.sbf, n3, 0);
            n3 = this.encodeUint(this.sbf, n3, 0);
            outputStream.write(this.sbf, 0, n3);
            outputStream.flush();
            return;
        }
        int n4 = this.sizeUint(this.seq);
        int n5 = this.sizeUint(this.rqIdx) + this.sbf_off - 22;
        int n6 = this.sizeUint(n5);
        int n7 = n4 + 1 + 1 + n6 + n5 + 1;
        this.encodeUint(0);
        if (StartUp.dlg_compression_threshold > 0 && n7 > StartUp.dlg_compression_threshold) {
            n2 = n7 + (n7 + 7 >> 3) + (n7 + 63 >> 6) + 11;
            byte[] byArray = new byte[n2 + 10];
            if (this.deflater == null) {
                this.deflater = new Deflater();
            }
            int n8 = this.sbf_off - n7;
            int n9 = this.encodeUint(this.sbf, n8, this.seq);
            n9 = this.encodeInt(this.sbf, n9, 0);
            n9 = this.encodeUint(this.sbf, n9, 1);
            n9 = this.encodeUint(this.sbf, n9, n5);
            this.encodeUint(this.sbf, n9, this.rqIdx);
            this.deflater.setInput(this.sbf, n8, n7);
            this.deflater.finish();
            n2 = this.deflater.deflate(byArray, 10, n2);
            if (!this.deflater.finished()) {
                throw new RuntimeException("Failed to deflate DLG server response, buffer size is inconsistent");
            }
            this.deflater.reset();
            n9 = this.sizeUint(n7);
            n8 = 10 - n9 - this.sizeUint(n2 + n9);
            n9 = this.encodeUint(byArray, n8, n2 + n9);
            this.encodeUint(byArray, n9, n7);
            if (n7 >= StartUp.dlg_log_threshold && Debug.isLog(1, 2)) {
                Debug.log(1, 2, "rsSend: " + n7 + " (compressed " + (n2 + 10 - n8) + ") bytes");
            }
            outputStream.write(byArray, n8, n2 + 10 - n8);
        } else {
            if (n7 >= StartUp.dlg_log_threshold && Debug.isLog(1, 2)) {
                Debug.log(1, 2, "rsSend: " + n7 + " bytes");
            }
            n2 = this.sbf_off - ++n7 - this.sizeUint(n7);
            n7 = this.encodeUint(this.sbf, n2, n7);
            n7 = this.encodeUint(this.sbf, n7, 0);
            n7 = this.encodeUint(this.sbf, n7, this.seq);
            n7 = this.encodeInt(this.sbf, n7, 0);
            n7 = this.encodeUint(this.sbf, n7, 1);
            n7 = this.encodeUint(this.sbf, n7, n5);
            this.encodeUint(this.sbf, n7, this.rqIdx);
            outputStream.write(this.sbf, n2, this.sbf_off - n2);
        }
        outputStream.flush();
        n2 = Dmdrv_V2.bfSize(this.sbf_off);
        if (n2 < this.sbf.length) {
            this.sbf = new byte[n2];
        }
        this.paths.dispose();
        this.paths = null;
        this.attrs.dispose();
        this.attrs = null;
    }

    void sendNopResponse(Dlg dlg) {
        if (++this.seq < 0) {
            this.seq = 1;
        }
        int n = this.sizeUint(this.seq) + 7;
        n = this.encodeUint(this.sbf, 0, n);
        n = this.encodeUint(this.sbf, n, 0);
        n = this.encodeUint(this.sbf, n, this.seq);
        n = this.encodeUint(this.sbf, n, 0);
        n = this.encodeUint(this.sbf, n, 1);
        n = this.encodeUint(this.sbf, n, 2);
        n = this.encodeUint(this.sbf, n, 1);
        n = this.encodeUint(this.sbf, n, 18);
        n = this.encodeUint(this.sbf, n, 0);
        try {
            OutputStream outputStream = dlg.sck.getOutputStream();
            outputStream.write(this.sbf, 0, n);
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int decodeUi32() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (this.rbf_off >= this.rbf_used) {
                throw new RuntimeException("DLG buffer offset exceeded: " + (this.rbf_off + 1) + ", max: " + this.rbf_used);
            }
            if (++n3 > 5) {
                throw new RuntimeException("DLG buffer varint overflow, offset: " + this.rbf_off);
            }
            byte by = this.rbf[this.rbf_off];
            if ((by & 0x80) == 0) break;
            n |= (by & 0x7F) << n2;
            ++this.rbf_off;
            n2 += 7;
        }
        return n | this.rbf[this.rbf_off++] << n2;
    }

    private int decodeUint() {
        int n = this.rbf_off;
        int n2 = this.decodeUi32();
        if (n2 < 0) {
            throw new RuntimeException("DLG buffer UINT out of range: " + n2 + ", offset: " + n);
        }
        return n2;
    }

    private int decodeInt() {
        int n = this.decodeUi32();
        return (n & 1) != 0 ? ~(n >>> 1) : n >>> 1;
    }

    private String decodeString() {
        int n = this.decodeUint();
        int n2 = this.rbf_off;
        this.rbf_off += n;
        if (this.rbf_off > this.rbf_used) {
            throw new RuntimeException("DLG buffer offset exceeded: " + this.rbf_off + ", max: " + this.rbf_used);
        }
        if (n < 1 || this.rbf[this.rbf_off - 1] != 0) {
            throw new RuntimeException("DLG buffer invalid STRING encoding, offset: " + n2);
        }
        if (n > 1) {
            try {
                return this.csDecoder.decode(ByteBuffer.wrap(this.rbf, n2, n - 1)).toString();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return "";
    }

    private void decodeSkipString() {
        int n = this.decodeUint();
        int n2 = this.rbf_off;
        this.rbf_off += n;
        if (this.rbf_off > this.rbf_used) {
            throw new RuntimeException("DLG buffer offset exceeded: " + this.rbf_off + ", max: " + this.rbf_used);
        }
        if (n < 1 || this.rbf[this.rbf_off - 1] != 0) {
            throw new RuntimeException("DLG buffer invalid STRING encoding, offset: " + n2);
        }
    }

    private void encodeInit() {
        if (this.sbf == null) {
            this.sbf = new byte[20480];
        }
        this.sbf_off = 22;
    }

    private void encodeGrow(int n) {
        int n2 = Dmdrv_V2.bfSize(this.sbf_off + n);
        if (n2 > this.sbf.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.sbf, 22, byArray, 22, this.sbf_off - 22);
            this.sbf = byArray;
        }
    }

    private void encodeUint(int n) {
        if (this.sbf_off > this.sbf.length) {
            throw new RuntimeException("DLG buffer offset exceeded: " + this.sbf_off + ", max: " + this.sbf.length);
        }
        while (true) {
            if (this.sbf_off == this.sbf.length) {
                this.encodeGrow(1);
            }
            if ((n & 0xFFFFFF80) == 0) break;
            this.sbf[this.sbf_off++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.sbf[this.sbf_off++] = (byte)n;
    }

    private int sizeUint(int n) {
        int n2 = 1;
        while ((n & 0xFFFFFF80) != 0) {
            ++n2;
            n >>>= 7;
        }
        return n2;
    }

    private void encodeInt(int n) {
        this.encodeUint(n < 0 ? ~(n << 1) : n << 1);
    }

    private int sizeInt(int n) {
        return this.sizeUint(n < 0 ? ~(n << 1) : n << 1);
    }

    private int encodeUint(byte[] byArray, int n, int n2) {
        while (true) {
            if (n >= byArray.length) {
                throw new RuntimeException("DLG buffer offset exceeded: " + (n + 1) + ", max: " + byArray.length);
            }
            if ((n2 & 0xFFFFFF80) == 0) break;
            byArray[n++] = (byte)(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
        byArray[n++] = (byte)n2;
        return n;
    }

    private int encodeInt(byte[] byArray, int n, int n2) {
        return this.encodeUint(byArray, n, n2 < 0 ? ~(n2 << 1) : n2 << 1);
    }

    private void encodeData(byte[] byArray, int n) {
        this.encodeUint(n);
        if (n > 0) {
            if (n > this.sbf.length - this.sbf_off) {
                this.encodeGrow(n);
            }
            System.arraycopy(byArray, 0, this.sbf, this.sbf_off, n);
            this.sbf_off += n;
        }
    }

    private void encodeString(String string) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.csEncoder.encode(CharBuffer.wrap(string));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        int n = byteBuffer.limit() + 1;
        this.encodeUint(n);
        if (n > this.sbf.length - this.sbf_off) {
            this.encodeGrow(n);
        }
        byteBuffer.get(this.sbf, this.sbf_off, n - 1);
        this.sbf_off += n - 1;
        this.encodeUint(0);
    }

    private void encodeStringData(String string) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.csEncoder.encode(CharBuffer.wrap(string));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        int n = byteBuffer.limit();
        this.encodeUint(n);
        if (n > this.sbf.length - this.sbf_off) {
            this.encodeGrow(n);
        }
        byteBuffer.get(this.sbf, this.sbf_off, n);
        this.sbf_off += n;
    }

    private void decodePaths() {
        int n = this.decodeUint();
        int n2 = 0;
        this.paths = new Paths(n);
        for (int i = 0; i < n; ++i) {
            int n3 = this.decodeUint();
            int n4 = this.rbf_off;
            this.rbf_off += n3;
            if (this.rbf_off > this.rbf_used) {
                throw new RuntimeException("DLG buffer offset exceeded: " + this.rbf_off + ", max: " + this.rbf_used);
            }
            int n5 = this.rbf_off;
            int n6 = this.decodeUint();
            if (n6 != 0) {
                if (n6 > i) {
                    throw new RuntimeException("DLG buffer invalid parent: " + n6 + ", offset: " + n5);
                }
                this.paths.parent[i] = n6;
                int n7 = n3;
                while (n6 != 0) {
                    n7 += this.paths.len[n6 - 1] + 1;
                    n6 = this.paths.parent[n6 - 1];
                }
                if (n7 > n2) {
                    n2 = n7;
                }
            } else if (n3 > n2) {
                n2 = n3;
            }
            this.paths.off[i] = n4;
            this.paths.len[i] = n3;
        }
        this.paths.tmp = new byte[n2];
    }

    private String getPath(int n) {
        if (n < 1 || n > this.paths.off.length) {
            throw new RuntimeException("DLG object id out of range: " + n);
        }
        int n2 = this.paths.len[n - 1];
        int n3 = this.paths.tmp.length - n2;
        System.arraycopy(this.rbf, this.paths.off[n - 1], this.paths.tmp, n3, n2);
        while ((n = this.paths.parent[n - 1]) != 0) {
            this.paths.tmp[--n3] = 46;
            n2 = this.paths.len[n - 1];
            System.arraycopy(this.rbf, this.paths.off[n - 1], this.paths.tmp, n3 -= n2, n2);
        }
        try {
            return this.csDecoder.decode(ByteBuffer.wrap(this.paths.tmp, n3, this.paths.tmp.length - n3)).toString();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private void decodeAttrs() {
        int n = this.decodeUint();
        this.attrs = new Attrs(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.decodeUint();
            int n3 = this.rbf_off;
            this.rbf_off += n2;
            if (this.rbf_off > this.rbf_used) {
                throw new RuntimeException("DLG buffer offset exceeded: " + this.rbf_off + ", max: " + this.rbf_used);
            }
            try {
                this.attrs.name[i] = this.csDecoder.decode(ByteBuffer.wrap(this.rbf, n3, n2)).toString().toLowerCase();
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    private String getAttr(int n) {
        if (n < 1 || n > this.attrs.name.length) {
            throw new RuntimeException("DLG attr id out of range: " + n);
        }
        return this.attrs.name[n - 1];
    }

    static String getDriverProperties() {
        return Dlg.getDriverProperties("utf-8", true);
    }

    private static final class Attrs {
        String[] name;

        Attrs(int n) {
            this.name = new String[n];
        }

        void dispose() {
            this.name = null;
        }
    }

    private static final class Paths {
        int[] off;
        int[] len;
        int[] parent;
        byte[] tmp;

        Paths(int n) {
            this.off = new int[n];
            this.len = new int[n];
            this.parent = new int[n];
        }

        void dispose() {
            this.off = null;
            this.len = null;
            this.parent = null;
            this.tmp = null;
        }
    }
}

