/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.protocols.eloqsd;

import com.eloquence.services.protocols.eloqsd.Conversions;
import com.eloquence.services.protocols.eloqsd.ProtocolAction;
import com.eloquence.services.protocols.eloqsd.eloqsd;

final class InitialRequest
extends ProtocolAction {
    private static final String MAGIC = "EQ.ELOQD";
    private static final byte REVISION = 5;
    private static final int BYTE_ORDER = 4321;
    private static final String PLATFORM = "Linux/Ix86";
    private static final String ENCODING = "ISO8859/1";
    private String challenge = null;

    void sendRequest() {
        this.conn.sendBytes(this.getNetworkPresentation());
    }

    byte[] getNetworkPresentation() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = MAGIC.getBytes(this.cs_ascii);
        byte[] byArray3 = Conversions.createInt16(5);
        byte[] byArray4 = Conversions.createInt16(4321);
        byte[] byArray5 = Conversions.createFromString(PLATFORM, this.cs_latin1);
        byte[] byArray6 = Conversions.createFromString(ENCODING, this.cs_latin1);
        byte[] byArray7 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length + byArray5.length + byArray6.length];
        byte[] byArray8 = Conversions.createInt32(byArray7.length - 4);
        int n = 0;
        System.arraycopy(byArray8, 0, byArray7, n, byArray8.length);
        System.arraycopy(byArray2, 0, byArray7, n += byArray8.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray7, n += byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray7, n += byArray3.length, byArray4.length);
        System.arraycopy(byArray5, 0, byArray7, n += byArray4.length, byArray5.length);
        System.arraycopy(byArray6, 0, byArray7, n += byArray5.length, byArray6.length);
        return byArray7;
    }

    void setFromNetworkPresentation(byte[] byArray) {
        if (this.handleStatus(byArray)) {
            this.challenge = Conversions.createString(byArray, 2, this.cs_latin1);
        }
    }

    void receiveRequest() {
        this.setFromNetworkPresentation(this.conn.receiveBytes());
    }

    public byte[] getChallenge() {
        if (this.challenge == null || this.challenge.length() != 32) {
            return null;
        }
        return this.challenge.getBytes(this.cs_ascii);
    }

    public InitialRequest(eloqsd eloqsd2) {
        super(eloqsd2);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.challenge = null;
    }
}

