/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.protocols.eloqsd;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.protocols.eloqsd.AuthorizeRequest;
import com.eloquence.services.protocols.eloqsd.EloqcoreDebugRequest;
import com.eloquence.services.protocols.eloqsd.EloqcoreRequest;
import com.eloquence.services.protocols.eloqsd.EqRDlgRequest;
import com.eloquence.services.protocols.eloqsd.InitialRequest;
import com.eloquence.services.protocols.eloqsd.ProtocolAction;
import com.eloquence.services.protocols.eloqsd.RemoteDebugContinueOperation;
import com.eloquence.services.protocols.eloqsd.StartTLSRequest;
import com.eloquence.services.sessions.Session;
import com.eloquence.services.sessions.SessionView;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.InetTool;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class eloqsd
implements Runnable {
    private int protocol = 0;
    private Socket socket = null;
    private DataInputStream reader = null;
    private OutputStream writer = null;
    protected Session session = null;
    private HashMap startAtoms = null;
    private boolean cont = true;
    private boolean sessionStarted = false;

    public eloqsd(int n) {
        this.protocol = n;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private void dispose() {
        try {
            this.session = null;
            this.startAtoms = null;
            this.reader = null;
            if (this.writer != null) {
                this.writer.flush();
                this.writer = null;
            }
            if (this.socket != null) {
                if (!this.sessionStarted) {
                    this.socket.close();
                }
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        Thread thread = new Thread(StartUp.systemThreadGroup, this, "eloqsd");
        thread.start();
    }

    public boolean doProtocol() {
        if (!this.initializeSocket()) {
            return false;
        }
        this.session.setHostIpString(InetTool.getHostAddress(this.socket.getLocalAddress()));
        this.session.substituteMacros();
        InitialRequest initialRequest = new InitialRequest(this);
        if (!this.handleAction(initialRequest)) {
            this.showMessage(initialRequest);
            return false;
        }
        if (this.session.useTLS() && !this.startTLS()) {
            return false;
        }
        if (!this.authorize(initialRequest.getChallenge())) {
            return false;
        }
        return this.startEloqcore();
    }

    public void run() {
        if (this.doProtocol()) {
            Session.started(this.session);
        } else {
            SessionView.cancelSessionTimer = true;
            StartUp.sessionFinished();
        }
    }

    private boolean handleAction(ProtocolAction protocolAction) {
        protocolAction.sendRequest();
        protocolAction.receiveRequest();
        return this.cont;
    }

    private void showMessage(ProtocolAction protocolAction) {
        switch (protocolAction.getReturnCode()) {
            case 1: {
                Session.setError(protocolAction.getErrorMessage());
                this.session.setLoginName("");
                break;
            }
            case 2: {
                Session.setWarning(protocolAction.getWarningMessage());
                this.session.setLoginName("");
            }
        }
        this.dispose();
    }

    private boolean startTLS() {
        StartTLSRequest startTLSRequest = new StartTLSRequest(this);
        if (!this.handleAction(startTLSRequest)) {
            this.showMessage(startTLSRequest);
            return false;
        }
        try {
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, this.session.getServer(), this.session.getPort(), true);
            this.socket = sSLSocket;
            sSLSocket.setUseClientMode(true);
            sSLSocket.startHandshake();
            InetTool.verifyHostName(this.session.getServer(), sSLSocket.getSession(), 2);
            this.reader = null;
            if (this.writer != null) {
                this.writer.flush();
                this.writer = null;
            }
            this.reader = new DataInputStream(this.socket.getInputStream());
            this.writer = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (Throwable throwable) {
            Session.setError(throwable.toString());
            this.dispose();
            return false;
        }
        return true;
    }

    private boolean authorize(byte[] byArray) {
        AuthorizeRequest authorizeRequest = new AuthorizeRequest(this);
        authorizeRequest.setChallenge(byArray);
        if (!this.handleAction(authorizeRequest)) {
            this.showMessage(authorizeRequest);
            return false;
        }
        return true;
    }

    private boolean startEloqcore() {
        if (this.startAtoms != null) {
            this.protocol = 1;
        }
        if (this.protocol == 0) {
            EloqcoreRequest eloqcoreRequest = new EloqcoreRequest(this);
            if (!this.handleAction(eloqcoreRequest)) {
                this.showMessage(eloqcoreRequest);
                return false;
            }
        } else if (this.protocol == 1) {
            EqRDlgRequest eqRDlgRequest = new EqRDlgRequest(this);
            eqRDlgRequest.sendRequest();
            Dlg dlg = new Dlg(this.socket, true, this.session.getKey(), this.startAtoms);
            this.startAtoms = null;
            if (Debug.isLog(1, 1)) {
                Debug.log(1, 1, "RDLG connection from " + dlg.getName() + " session '" + HtmlTool.text(this.session.getName()) + "'");
            }
            dlg.start();
            this.sessionStarted = true;
        } else if (this.protocol == 2) {
            EloqcoreDebugRequest eloqcoreDebugRequest = new EloqcoreDebugRequest(this);
            if (!this.handleAction(eloqcoreDebugRequest)) {
                this.showMessage(eloqcoreDebugRequest);
                return false;
            }
            RemoteDebugContinueOperation remoteDebugContinueOperation = new RemoteDebugContinueOperation(this);
            remoteDebugContinueOperation.setFilename(eloqcoreDebugRequest.fileName);
            if (!this.handleAction(remoteDebugContinueOperation)) {
                this.showMessage(remoteDebugContinueOperation);
                return false;
            }
        }
        return true;
    }

    private boolean initializeSocket() {
        try {
            this.socket = new Socket(this.session.getServer(), this.session.getPort());
            this.socket.setTcpNoDelay(true);
            this.reader = new DataInputStream(this.socket.getInputStream());
            this.writer = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (Throwable throwable) {
            Session.setError(throwable.toString());
            this.dispose();
            return false;
        }
        return true;
    }

    public boolean sendBytes(byte[] byArray) {
        try {
            this.writer.write(byArray);
            this.writer.flush();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public byte[] receiveBytes() {
        byte[] byArray = null;
        try {
            int n = this.reader.readInt();
            if (n < 1) {
                return null;
            }
            byArray = new byte[n];
            this.reader.readFully(byArray);
        }
        catch (Throwable throwable) {
            return null;
        }
        return byArray;
    }

    public void setSession(Session session, HashMap hashMap) {
        this.session = session;
        this.startAtoms = hashMap;
    }

    public Session getSession() {
        return this.session;
    }

    public void setContinue(boolean bl) {
        this.cont = bl;
    }
}

