/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.sessions;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.protocols.eloqsd.eloqsd;
import com.eloquence.services.sessions.PasswordDialog;
import com.eloquence.services.sessions.SessionView;
import com.eloquence.services.tools.HtmlTool;
import java.awt.Dialog;
import java.awt.Window;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class Session {
    private String key;
    private String name = "";
    private String server = "";
    private int port = 8100;
    public static final String DEFAULT_LOGIN_NAME = "JDLG";
    private String loginName = "";
    private String currentLoginName = null;
    private String password = "";
    private String currentPassword = null;
    private boolean debug_start = false;
    private String startDirectory = "";
    private String driverEnvName = "JDLGHOST";
    private String outputDevice = "";
    private List orgParameters = new LinkedList();
    private List parameters = new LinkedList();
    private List orgEnvironment = new LinkedList();
    private List environment = new LinkedList();
    private String hostipstring = null;
    private ImageIcon icon;
    public static final int SESSION_PROTOCOL_DLG = 0;
    public static final int SESSION_PROTOCOL_RDLG = 1;
    public static final int SESSION_PROTOCOL_DEBUG = 2;
    public int protocol = 0;
    private boolean autoStart = false;
    private boolean visible = true;
    private boolean useTLS = false;
    private static List sessions = new LinkedList();
    private static List cachedConnections = new LinkedList();
    public int startIndicatorTimeout = 0;
    public int currProgress = 0;

    public static void init() {
        sessions.clear();
        cachedConnections.clear();
    }

    public static void add(Session session) {
        Session session2 = null;
        Iterator iterator = sessions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session3 = (Session)iterator.next();
            if (session3 == session || session3.getKey().equalsIgnoreCase(session.getKey())) {
                session2 = session3;
                break;
            }
            ++n;
        }
        if (session2 == null) {
            sessions.add(session);
        } else if (session2 != session) {
            sessions.remove(n);
            sessions.add(n, session);
            System.err.println("Note: Duplicate session [" + session.getKey() + "] - previous session deleted");
        }
    }

    private void create_setAttr(String string, String string2, String string3) {
        int n;
        if (string3.length() > 0 && (n = this.setAttr(string2, string3, false)) != 0) {
            System.err.println((n < 0 ? "Failed to set" : "Unknown") + " session configuration [" + string + "] " + string2);
        }
    }

    public static Session create(String string, Map map) {
        Session session = new Session(string);
        Session.add(session);
        for (Map.Entry entry : map.entrySet()) {
            int n;
            String string2 = (String)entry.getValue();
            int n2 = 0;
            while ((n = string2.indexOf(10, n2)) >= n2) {
                session.create_setAttr(string, (String)entry.getKey(), string2.substring(n2, n));
                n2 = n + 1;
            }
            session.create_setAttr(string, (String)entry.getKey(), string2.substring(n2));
        }
        return session;
    }

    public void start(HashMap hashMap) {
        this.resubstituteMacros();
        eloqsd eloqsd2 = new eloqsd(this.protocol);
        eloqsd2.setSession(this, hashMap);
        eloqsd2.start();
    }

    public static void start(Session session, HashMap hashMap) {
        Object object;
        boolean bl = StartUp.isTrue(StartUp.getSessionLoginCache());
        if (bl && session.getLoginName().length() == 0) {
            object = session.getServer();
            int n = session.getPort();
            for (CachedConnection cachedConnection : cachedConnections) {
                if (!cachedConnection.server.equalsIgnoreCase((String)object) || cachedConnection.port != n) continue;
                session.setLoginName(cachedConnection.loginName);
                session.setPassword(cachedConnection.password);
                break;
            }
        }
        if (session.getLoginName().length() > 0) {
            session.setCurrentLoginName(session.getLoginName());
            session.setCurrentPassword(session.getPassword());
        } else {
            object = new PasswordDialog(StartUp.MasterFrame, HtmlTool.text(session.getName()));
            ((Window)object).setLocation(StartUp.MasterFrame.getLocation());
            ((Window)object).setIconImage(StartUp.MasterFrame.getIconImage());
            ((Window)object).pack();
            ((PasswordDialog)object).name.requestFocus();
            ((Dialog)object).setVisible(true);
            if (!((PasswordDialog)object).isOkState()) {
                StartUp.sessionFinished();
                return;
            }
            session.setCurrentLoginName(((PasswordDialog)object).getName());
            session.setCurrentPassword(((PasswordDialog)object).getPassword());
        }
        if (session.isVisible()) {
            SessionView.startSessionTimer(session);
        }
        session.start(hashMap);
    }

    public static void started(Session session) {
        if (StartUp.isTrue(StartUp.getSessionLoginCache())) {
            session.setLoginName(session.getCurrentLoginName());
            session.setPassword(session.getCurrentPassword());
            CachedConnection cachedConnection = null;
            String string = session.getServer();
            int n = session.getPort();
            for (CachedConnection cachedConnection2 : cachedConnections) {
                if (!cachedConnection2.server.equalsIgnoreCase(string) || cachedConnection2.port != n) continue;
                cachedConnection = cachedConnection2;
                break;
            }
            if (cachedConnection == null) {
                cachedConnection = new CachedConnection();
                cachedConnections.add(cachedConnection);
                cachedConnection.server = string;
                cachedConnection.port = n;
            }
            cachedConnection.loginName = session.getLoginName();
            cachedConnection.password = session.getPassword();
        }
    }

    public static boolean startByKey(String string, HashMap hashMap) {
        for (Session session : sessions) {
            if (!session.getKey().equalsIgnoreCase(string)) continue;
            Session.start(session, hashMap);
            return true;
        }
        return false;
    }

    public static void autoStart() {
        for (Session session : sessions) {
            if (!session.isAutoStart()) continue;
            Session.start(session, null);
        }
    }

    public int setAttr(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("name")) {
            this.name = this.resolveMacro(Session.trimQuotes(string2), true);
        } else if (string.equalsIgnoreCase("server")) {
            this.server = this.resolveMacro(Session.trimQuotes(string2), true);
        } else if (string.equalsIgnoreCase("serverport")) {
            string2 = Session.trimQuotes(string2);
            try {
                int n;
                this.port = n = Integer.valueOf(this.resolveMacro(string2, true)).intValue();
            }
            catch (Throwable throwable) {
                System.err.println(string2 + ": Invalid port number");
                return -1;
            }
        } else if (string.equalsIgnoreCase("login")) {
            this.loginName = (string2 = Session.trimQuotes(string2)).equalsIgnoreCase("default") ? DEFAULT_LOGIN_NAME : this.resolveMacro(string2, true);
        } else if (string.equalsIgnoreCase("password")) {
            this.password = this.resolveMacro(Session.trimQuotes(string2), true);
        } else if (string.equalsIgnoreCase("debugmode")) {
            this.debug_start = StartUp.isTrue(this.resolveMacro(Session.trimQuotes(string2), true));
        } else if (string.equalsIgnoreCase("startdir")) {
            this.startDirectory = this.resolveMacro(Session.trimQuotes(string2), true);
        } else if (string.equalsIgnoreCase("drivervarname")) {
            this.driverEnvName = this.resolveMacro(Session.trimQuotes(string2), true);
        } else if (string.equalsIgnoreCase("tty")) {
            this.outputDevice = this.resolveMacro(Session.trimQuotes(string2), true);
        } else if (string.equalsIgnoreCase("icon")) {
            string2 = this.resolveMacro(Session.trimQuotes(string2), true);
            try {
                this.icon = new ImageIcon(StartUp.uriFromString(string2).toURL());
            }
            catch (Throwable throwable) {
                this.icon = new ImageIcon(string2);
            }
        } else if (string.equalsIgnoreCase("autostart")) {
            this.autoStart = StartUp.isTrue(this.resolveMacro(Session.trimQuotes(string2), true));
        } else if (string.equalsIgnoreCase("protocol")) {
            this.protocol = (string2 = this.resolveMacro(Session.trimQuotes(string2), true)).equalsIgnoreCase("rdlg") ? 1 : (string2.equalsIgnoreCase("debug") ? 2 : 0);
        } else if (string.equalsIgnoreCase("parameter") || string.equalsIgnoreCase("command")) {
            if (bl) {
                this.orgParameters.add(Session.trimQuotes(string2));
            } else {
                ArrayList arrayList = Session.parseCommandLine(string2);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.orgParameters.add((String)iterator.next());
                }
            }
        } else if (string.equalsIgnoreCase("environment")) {
            this.orgEnvironment.add(Session.trimQuotes(string2));
        } else if (string.equalsIgnoreCase("visible")) {
            this.visible = StartUp.isTrue(this.resolveMacro(Session.trimQuotes(string2), true));
        } else if (string.equalsIgnoreCase("tls")) {
            this.useTLS = StartUp.isTrue(this.resolveMacro(Session.trimQuotes(string2), true));
        } else {
            return 1;
        }
        return 0;
    }

    private static final String trimQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static final ArrayList parseCommandLine(String string) {
        char c;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = null;
        char c2 = '\u0000';
        while ((c = stringCharacterIterator.current()) != '\uffff') {
            block11: {
                switch (c) {
                    case '\t': 
                    case ' ': {
                        if (c2 != '\u0000' || stringBuffer == null) break;
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = null;
                        break block11;
                    }
                    case '\\': {
                        char c3 = stringCharacterIterator.next();
                        if (c3 == '\"' || c3 == '\'') {
                            c = c3;
                            break;
                        }
                        stringCharacterIterator.previous();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (c == c2) {
                            c2 = '\u0000';
                        } else {
                            if (c2 != '\u0000') break;
                            c2 = c;
                        }
                        break block11;
                    }
                    default: {
                        if (stringBuffer != null) break;
                        stringBuffer = new StringBuffer();
                    }
                }
                if (stringBuffer != null) {
                    stringBuffer.append(c);
                }
            }
            stringCharacterIterator.next();
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public void substituteMacros() {
        int n;
        String string = null;
        for (n = 0; n < this.parameters.size(); ++n) {
            string = (String)this.parameters.get(n);
            this.substituteMacro(string, this.parameters, n);
        }
        for (n = 0; n < this.environment.size(); ++n) {
            string = (String)this.environment.get(n);
            this.substituteMacro(string, this.environment, n);
        }
    }

    private String substituteMacro(String string, List list, int n) {
        String string2 = this.resolveMacro(string, false);
        list.remove(n);
        list.add(n, string2);
        return string2;
    }

    private String resolveMacro(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            if (cArray[i] != '$') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            int n2 = n = ++i;
            int n3 = 0;
            while (i < cArray.length) {
                if (i == n && cArray[i] == '(') {
                    ++n3;
                    n2 = ++i;
                    continue;
                }
                if (n3 != 0 && cArray[i] == ')') {
                    ++n3;
                    ++n;
                    n2 = i;
                    break;
                }
                if (cArray[i] >= 'A' && cArray[i] <= 'Z' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] == '_') {
                    n2 = ++i;
                    continue;
                }
                --i;
                break;
            }
            if (n2 > n) {
                String string2 = String.copyValueOf(cArray, n, n2 - n);
                if (!bl && string2.equalsIgnoreCase("login")) {
                    stringBuffer.append(this.getCurrentLoginName());
                    continue;
                }
                if (!bl && string2.equalsIgnoreCase("host")) {
                    stringBuffer.append(this.hostipstring);
                    continue;
                }
                if (!bl && string2.equalsIgnoreCase("port")) {
                    stringBuffer.append(StartUp.getDlgPort());
                    continue;
                }
                if (n3 == 2) {
                    String string3 = null;
                    try {
                        string3 = StartUp.getProperty(string2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (string3 == null) {
                        try {
                            string3 = System.getenv(string2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (string3 == null) continue;
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append("$" + string2);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private void resubstituteMacros() {
        int n;
        this.environment.clear();
        for (n = 0; n < this.orgEnvironment.size(); ++n) {
            this.environment.add(n, this.orgEnvironment.get(n));
        }
        this.parameters.clear();
        for (n = 0; n < this.orgParameters.size(); ++n) {
            this.parameters.add(n, this.orgParameters.get(n));
        }
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void setLoginName(String string) {
        this.loginName = string;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setCurrentLoginName(String string) {
        this.currentLoginName = string;
    }

    public String getCurrentLoginName() {
        return this.currentLoginName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCurrentPassword(String string) {
        this.currentPassword = string;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public boolean getDebug_start() {
        return this.debug_start;
    }

    public String getStartDirectory() {
        return this.startDirectory;
    }

    public String getDriverenvname() {
        return this.driverEnvName;
    }

    public String getOutputDevice() {
        return this.outputDevice;
    }

    public List getParameters() {
        return this.parameters;
    }

    public List getEnvironment() {
        return this.environment;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean useTLS() {
        return this.useTLS;
    }

    public static boolean hasVisibleSession() {
        for (Session session : sessions) {
            if (!session.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void setHostIpString(String string) {
        this.hostipstring = string;
    }

    public static List getSessions() {
        return sessions;
    }

    public static void setWarning(String string) {
        SessionView.showWarning(string);
    }

    public static void setError(String string) {
        SessionView.showError(string);
    }

    public Session(String string) {
        this.key = string;
    }

    protected void finalize() throws Throwable {
        sessions.remove(this);
    }

    private static final class CachedConnection {
        String server;
        int port;
        String loginName;
        String password;

        private CachedConnection() {
        }
    }
}

