/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    public static final int ERROR = 0;
    public static final int INFO = 1;
    public static final int DEBUG = 2;
    public static final int VDEBUG = 3;
    public static final int CONFIG = 0;
    public static final int PROTOCOL = 1;
    public static final int UI = 2;
    public static final int FOCUS = 3;
    public static final int FORMAT = 4;
    private static final String[] facilities = new String[]{"config", "protocol", "ui", "focus", "format"};
    private static int[] level = new int[facilities.length];
    private static ConsoleHandler systemLogHandler = null;
    private static Logger focusLogger = null;

    public static void setup(String string) {
        for (int i = 0; i < facilities.length; ++i) {
            Debug.level[i] = 0;
        }
        String[] stringArray = string.split(",");
        block3: for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2;
            block6: {
                String[] stringArray2 = stringArray[i].split(":");
                if (stringArray2.length < 1 || stringArray2.length > 2) continue;
                string2 = stringArray2[0].trim().toLowerCase();
                n = 1;
                if (stringArray2.length == 2) {
                    try {
                        String string3 = stringArray2[1].trim();
                        if (string3.length() <= 0) break block6;
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
            }
            for (int j = 0; j < facilities.length; ++j) {
                if (!string2.equals(facilities[j])) continue;
                Debug.level[j] = n;
                continue block3;
            }
        }
        Debug.enableFocusLogging();
    }

    public static boolean isLog(int n, int n2) {
        return n >= 0 && n < facilities.length && n2 <= level[n];
    }

    public static void log(int n, int n2, String string) {
        if (n >= 0 && n < facilities.length && n2 <= level[n]) {
            System.err.println(facilities[n] + "." + n2 + " " + string);
        }
    }

    private static void enableSystemLogging() {
        if (systemLogHandler == null) {
            systemLogHandler = new ConsoleHandler();
            systemLogHandler.setLevel(Level.ALL);
        }
    }

    private static void enableFocusLogging() {
        Level level = null;
        int n = Debug.level[3];
        if (n > 3) {
            level = Level.ALL;
        } else if (n == 3) {
            level = Level.FINEST;
        } else if (n == 2) {
            level = Level.FINE;
        }
        if (level != null) {
            if (focusLogger == null) {
                Debug.enableSystemLogging();
                focusLogger = Logger.getLogger("java.awt.focus.Component");
                focusLogger.setLevel(level);
                focusLogger.addHandler(systemLogHandler);
            }
        } else if (focusLogger != null) {
            focusLogger.removeHandler(systemLogHandler);
            focusLogger = null;
        }
    }
}

