/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.tools.FontListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FontReference {
    public static final int minFontHeight = 6;
    private static HashMap fontReferences = new HashMap();
    private String fontFamily;
    private int fontStyle;
    private int fontSize;
    private boolean modified = true;
    private Font baseFont = null;
    private FontMetrics baseFontMetrics = null;
    private Font scaledFont = null;
    private FontMetrics scaledFontMetrics = null;
    private int scaledSize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateFonts(AbstractControl abstractControl, boolean bl) {
        double d = abstractControl.getFontScaling();
        boolean bl2 = false;
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            for (Map.Entry entry : fontReferences.entrySet()) {
                FontReference fontReference = null;
                Font font = null;
                boolean bl3 = false;
                for (FontListener fontListener : (Vector)entry.getValue()) {
                    if (abstractControl != fontListener.getRootControl()) continue;
                    boolean bl4 = fontListener.inMenuBar();
                    if (bl4) {
                        bl2 = true;
                        if (!bl) {
                            continue;
                        }
                    } else if (bl) continue;
                    if (fontReference == null) {
                        fontReference = (FontReference)entry.getKey();
                        font = fontReference.getScaledFont(d);
                        bl3 = fontReference.modified;
                    }
                    if (bl4) {
                        fontListener.fontModified(font);
                        continue;
                    }
                    boolean bl5 = fontListener.testAndSetFontUpdated();
                    if (!bl3 && bl5) continue;
                    fontReference.modified = false;
                    fontListener.fontModified(font);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMenuFonts(AbstractControl abstractControl) {
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            for (Map.Entry entry : fontReferences.entrySet()) {
                for (FontListener fontListener : (Vector)entry.getValue()) {
                    if (abstractControl != fontListener.getRootControl() || !fontListener.inMenuBar()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontReference(Font font) {
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            this.fontFamily = font.getFamily();
            this.fontStyle = font.getStyle();
            this.fontSize = font.getSize();
            fontReferences.put(this, new Vector());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontReference(FontReference fontReference) {
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            this.fontFamily = fontReference.getFamily();
            this.fontStyle = fontReference.getStyle();
            this.fontSize = fontReference.getPointSize();
            fontReferences.put(this, new Vector());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontReference(String string, int n, int n2) {
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            this.fontFamily = string;
            this.fontSize = n;
            this.fontStyle = n2;
            fontReferences.put(this, new Vector());
        }
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
        this.baseFont = null;
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
        this.baseFont = null;
    }

    public void setFontStyle(String string) {
        this.fontStyle = string.equalsIgnoreCase("italic") ? 2 : (string.equalsIgnoreCase("bold") ? 1 : 0);
        this.baseFont = null;
    }

    public void setFontPointSize(int n) {
        this.fontSize = n;
        this.baseFont = null;
    }

    public Font getFontObject(FontListener fontListener) {
        return this.getScaledFont(fontListener.getFontScaling());
    }

    public Font getFontObject(double d) {
        return this.getScaledFont(d);
    }

    public String getFamily() {
        return this.fontFamily;
    }

    public int getPointSize() {
        return this.fontSize;
    }

    public int getStyle() {
        return this.fontStyle;
    }

    public static final String styleName(int n) {
        switch (n) {
            case 2: {
                return "italic";
            }
            case 1: {
                return "bold";
            }
        }
        return "plain";
    }

    public String getStyleName() {
        return FontReference.styleName(this.fontStyle);
    }

    public double getFontScaling(int n) {
        FontMetrics fontMetrics = this.getBaseFontMetrics();
        if (fontMetrics == null) {
            return 1.0;
        }
        if (n < 6) {
            n = 6;
        }
        return Math.ceil((double)n * 100.0 / (double)fontMetrics.getHeight()) / 100.0;
    }

    public int getHeight(FontListener fontListener) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(fontListener.getFontScaling());
        return fontMetrics != null ? fontMetrics.getHeight() : 1;
    }

    public int getHeight(double d) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(d);
        return fontMetrics != null ? fontMetrics.getHeight() : 1;
    }

    public int getCharWidth(FontListener fontListener, char c) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(fontListener.getFontScaling());
        return fontMetrics != null ? fontMetrics.charWidth(c) : 0;
    }

    public int getCharWidth(double d, char c) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(d);
        return fontMetrics != null ? fontMetrics.charWidth(c) : 0;
    }

    public int getStringWidth(FontListener fontListener, String string) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(fontListener.getFontScaling());
        return fontMetrics != null ? fontMetrics.stringWidth(string) : 0;
    }

    public Dimension getCharSize(FontListener fontListener, char c) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(fontListener.getFontScaling());
        if (fontMetrics != null) {
            return new Dimension(fontMetrics.charWidth(c), fontMetrics.getHeight());
        }
        return new Dimension(0, 1);
    }

    public Dimension getCharSize(double d, char c) {
        FontMetrics fontMetrics = this.getScaledFontMetrics(d);
        if (fontMetrics != null) {
            return new Dimension(fontMetrics.charWidth(c), fontMetrics.getHeight());
        }
        return new Dimension(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(FontListener fontListener) {
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            Object v = fontReferences.get(this);
            if (v != null) {
                ((Vector)v).add(fontListener);
                this.modified = true;
                fontListener.resetFontUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(FontListener fontListener) {
        HashMap hashMap = fontReferences;
        synchronized (hashMap) {
            Object v = fontReferences.get(this);
            if (v != null) {
                Vector vector = (Vector)v;
                vector.remove(fontListener);
                if (vector.size() == 0) {
                    fontReferences.remove(this);
                }
            }
        }
    }

    private final void updateBaseFont() {
        this.baseFont = new Font(this.fontFamily, this.fontStyle, this.fontSize);
        this.baseFontMetrics = null;
        this.scaledFont = null;
        this.modified = true;
    }

    private final Font getScaledFont(double d) {
        if (this.baseFont == null) {
            this.updateBaseFont();
        }
        int n = (int)Math.ceil(d * (double)this.fontSize);
        if (this.scaledFont == null || n != this.scaledSize) {
            this.scaledFont = new Font(this.fontFamily, this.fontStyle, n);
            this.scaledFontMetrics = null;
            this.scaledSize = n;
            this.modified = true;
        }
        return this.scaledFont;
    }

    private final FontMetrics getBaseFontMetrics() {
        Component component;
        Graphics graphics;
        if (this.baseFont == null) {
            this.updateBaseFont();
        }
        if (this.baseFontMetrics == null && (graphics = (component = StartUp.getMainFrameComponent()).getGraphics()) != null) {
            this.baseFontMetrics = graphics.getFontMetrics(this.baseFont);
        }
        return this.baseFontMetrics;
    }

    private final FontMetrics getScaledFontMetrics(double d) {
        Component component;
        Graphics graphics;
        Font font = this.getScaledFont(d);
        if (this.scaledFontMetrics == null && (graphics = (component = StartUp.getMainFrameComponent()).getGraphics()) != null) {
            this.scaledFontMetrics = graphics.getFontMetrics(font);
        }
        return this.scaledFontMetrics;
    }
}

