/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class IniFile {
    private BufferedReader reader = null;
    private String lastSection = null;
    private String lastValue = null;
    private boolean fileTypeChecked = false;
    private boolean fileTypeRecognized = false;

    public IniFile(InputStream inputStream) throws UnsupportedEncodingException {
        this.close();
        this.reader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
    }

    public void close() {
        this.reader = null;
        this.lastValue = null;
        this.lastSection = null;
        this.fileTypeRecognized = false;
        this.fileTypeChecked = false;
    }

    public boolean isIniFile() {
        if (!this.fileTypeChecked) {
            this.nextLine();
        }
        return this.fileTypeRecognized;
    }

    public String nextSection() {
        while (this.lastSection == null) {
            if (this.nextLine() != null) continue;
            return null;
        }
        String string = this.lastSection;
        this.lastSection = null;
        return string;
    }

    public String nextEntry() {
        this.lastValue = null;
        String string = null;
        while (this.lastSection == null) {
            string = this.nextLine();
            if (string == null) {
                return null;
            }
            if (this.lastSection != null) break;
            int n = string.indexOf("=");
            if (n < 0) continue;
            String string2 = string.substring(0, n).trim();
            this.lastValue = string.substring(n + 1).trim();
            return string2;
        }
        return null;
    }

    public String getValue() {
        return this.lastValue;
    }

    private String nextLine() {
        String string = null;
        try {
            if (!this.fileTypeChecked) {
                this.fileTypeChecked = true;
                this.fileTypeRecognized = false;
            }
            while ((string = this.reader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
                if (string.startsWith("[") && string.endsWith("]")) {
                    this.lastSection = string.substring(1, string.length() - 1);
                    this.fileTypeRecognized = true;
                } else {
                    this.lastSection = null;
                }
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lastSection = null;
        return null;
    }
}

