/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.tools.RawPrinter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RawPrinterPipeLp
implements RawPrinter {
    private Process lpPipe = null;
    private OutputStream lpStream = null;
    private String lpName = null;
    private String printerName = null;
    private String errMsg = null;
    private int errCode = 0;
    private static final int ERR_OK = 0;
    private static final int ERR_FAILED = 1;
    private static final int ERR_NOT_OPEN = 2;
    private static final int ERR_ALREADY_OPEN = 3;

    public boolean open(String string) {
        this.errMsg = null;
        if (this.lpPipe != null) {
            this.errCode = 3;
            return false;
        }
        if ((string == null || string.length() == 0) && this.printerName != null && this.printerName.length() > 0) {
            string = this.printerName;
        }
        try {
            this.lpName = string != null && string.length() > 0 ? string : StartUp.getDefaultPrinter();
            this.lpPipe = Runtime.getRuntime().exec(this.composeCommandLine());
            this.lpStream = this.lpPipe.getOutputStream();
        }
        catch (Throwable throwable) {
            this.setLastErrorFromStderr(this.lpPipe, throwable, 0);
            return false;
        }
        this.errCode = 0;
        return true;
    }

    public boolean print(byte[] byArray, int n, int n2) {
        this.errMsg = null;
        if (this.lpPipe == null) {
            this.errCode = 2;
            return false;
        }
        try {
            this.lpStream.write(byArray, n, n2);
            this.lpStream.flush();
        }
        catch (Throwable throwable) {
            this.setLastErrorFromStderr(this.lpPipe, throwable, 0);
            return false;
        }
        this.errCode = 0;
        return true;
    }

    public boolean close() {
        this.errMsg = null;
        if (this.lpPipe == null) {
            this.errCode = 2;
            return false;
        }
        try {
            this.lpStream.flush();
            this.lpStream.close();
            this.lpStream = null;
            Process process = this.lpPipe;
            this.lpPipe = null;
            this.lpName = null;
            int n = process.waitFor();
            if (n != 0) {
                this.setLastErrorFromStderr(process, null, n);
                return false;
            }
        }
        catch (Throwable throwable) {
            this.setLastErrorFromStderr(this.lpPipe, throwable, 0);
            return false;
        }
        this.errCode = 0;
        return true;
    }

    public String printerName() {
        return this.lpName;
    }

    public void setPrinterName(String string) {
        this.printerName = string;
    }

    public String lastError() {
        switch (this.errCode) {
            case 1: {
                return this.errMsg != null ? this.errMsg : "";
            }
            case 2: {
                return "Printer has not been opened";
            }
            case 3: {
                return "Printer is already open";
            }
        }
        return "";
    }

    public String printers() {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(StartUp.getPrintersCommand());
            int n = process.waitFor();
            if (n == 0) {
                InputStream inputStream = process.getInputStream();
                String string = this.fromStream(inputStream);
                inputStream.close();
                Pattern pattern = Pattern.compile(StartUp.getPrintersFilter());
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                String string2 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    Matcher matcher = pattern.matcher(stringTokenizer.nextToken());
                    if (!matcher.find()) continue;
                    if (matcher.groupCount() > 0) {
                        string2 = string2 + matcher.group(1) + '\n';
                        continue;
                    }
                    string2 = string2 + matcher.group() + '\n';
                }
                return string2;
            }
            this.setLastErrorFromStderr(process, null, n);
        }
        catch (Throwable throwable) {
            this.setLastErrorFromStderr(process, throwable, 0);
            return "";
        }
        return "";
    }

    protected void finalize() {
        if (this.lpPipe != null) {
            try {
                this.lpStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final String composeCommandLine() {
        String string = StartUp.getPrintCommand();
        int n = string.indexOf("$p");
        if (n >= 0) {
            if (this.lpName != null && this.lpName.length() > 0) {
                string = string.substring(0, n).concat(this.lpName).concat(string.substring(n + 2));
            } else {
                int n2 = string.lastIndexOf(" -", n);
                if (n2 >= 0) {
                    string = string.substring(0, n2).concat(string.substring(n + 2));
                }
            }
        }
        return string;
    }

    private final void setLastErrorFromStderr(Process process, Throwable throwable, int n) {
        if (process != null) {
            this.errMsg = this.fromStream(process.getErrorStream());
        }
        if (this.errMsg.length() == 0) {
            this.errMsg = throwable != null ? throwable.toString() : "Subprocess exit code: " + n;
        }
        this.errCode = 1;
    }

    private final String fromStream(InputStream inputStream) {
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[256];
            while (inputStreamReader.ready() && (n = inputStreamReader.read(cArray, 0, 256)) > 0) {
                stringWriter.write(cArray, 0, n);
            }
            return stringWriter.toString();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

