/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.web;

import com.eloquence.services.Application.StartUp;
import java.net.URI;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;

public class BrowserAccessor {
    private static boolean initialized = false;
    private static boolean hasJnlpBrowser = false;
    private static String systemCallPrefix = null;
    private static String systemCallPostfix = null;

    public boolean showURL(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!initialized) {
            initialized = true;
            if (!StartUp.running_on_windows) {
                try {
                    object = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                    if (object.isWebBrowserSupported()) {
                        hasJnlpBrowser = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!hasJnlpBrowser) {
                systemCallPrefix = " " + (String)StartUp.HelpConfig.get("eloquence.help.cmdpre");
                systemCallPostfix = (String)StartUp.HelpConfig.get("eloquence.help.cmdpost");
            }
        }
        try {
            if (hasJnlpBrowser) {
                object = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                return object.showDocument(new URL(string));
            }
            object = Runtime.getRuntime().exec(systemCallPrefix + string + systemCallPostfix);
            ((Process)object).waitFor();
            return ((Process)object).exitValue() == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static URI jnlpCodeBase() {
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            return basicService.getCodeBase().toURI();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

