/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.api;

import com.eloquence.api.EqOvrCaret;
import com.eloquence.api.EqTextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class EqTextArea
extends JTextArea {
    protected Caret insCaret = this.getCaret();
    protected Caret ovrCaret;
    protected static Keymap sharedKeymap;
    protected static final String keymapName = "InsOvrMap";
    protected static final Action[] defaultActions;
    protected static JTextComponent.KeyBinding[] bindings;

    public EqTextArea() {
        this(null, null, 0, 0);
    }

    public EqTextArea(String string) {
        this(null, string, 0, 0);
    }

    public EqTextArea(int n, int n2) {
        this(null, null, n, n2);
    }

    public EqTextArea(String string, int n, int n2) {
        this(null, string, n, n2);
    }

    public EqTextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
        if (EqTextArea.isOverwrite()) {
            this.checkOverwriteCaret();
            super.setCaret(this.ovrCaret);
        }
    }

    public void setKeymap(Keymap keymap) {
        if (keymap == null) {
            super.setKeymap(null);
            sharedKeymap = null;
            return;
        }
        if (this.getKeymap() == null) {
            if (sharedKeymap == null) {
                EqTextArea.removeKeymap(keymapName);
                sharedKeymap = EqTextArea.addKeymap(keymapName, keymap);
                EqTextArea.loadKeymap(sharedKeymap, bindings, defaultActions);
            }
            keymap = sharedKeymap;
        }
        super.setKeymap(keymap);
    }

    private void ovrSubstring(Document document, String string, int n, int n2) {
        int n3 = document.getLength() - n2;
        if (n3 > n) {
            n3 = n;
        }
        try {
            String string2 = document.getText(n2, n3);
            int n4 = string2.indexOf(10);
            if (n4 >= 0) {
                n3 = n4;
            }
            if (n3 > 0) {
                document.remove(n2, n3);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        super.replaceSelection(string);
    }

    public void replaceSelection(String string) {
        Document document;
        if (EqTextArea.isOverwrite() && (document = this.getDocument()) != null && this.getSelectionStart() == this.getSelectionEnd()) {
            int n;
            int n2 = this.getCaretPosition();
            int n3 = string.length();
            int n4 = 0;
            while ((n = string.indexOf(10, n4)) >= 0) {
                int n5 = n - n4;
                if (n5 > 0) {
                    this.ovrSubstring(document, string.substring(n4, n), n5, n2);
                }
                super.replaceSelection("\n");
                n4 += ++n5;
                n2 += n5;
                n3 -= n5;
            }
            if (n3 > 0) {
                this.ovrSubstring(document, string.substring(n4), n3, n2);
            }
            return;
        }
        super.replaceSelection(string);
    }

    public static void setOverwrite(boolean bl) {
        EqTextField.setOverwrite(bl);
    }

    public static boolean isOverwrite() {
        return EqTextField.isOverwrite();
    }

    public void setCaret(Caret caret) {
        this.insCaret = caret;
        super.setCaret(caret);
    }

    private void checkOverwriteCaret() {
        if (this.ovrCaret == null) {
            this.ovrCaret = new EqOvrCaret();
            if (this.insCaret != null) {
                this.ovrCaret.setBlinkRate(this.insCaret.getBlinkRate());
            }
        }
    }

    public void setOverwriteCaret(Caret caret) {
        this.ovrCaret = caret;
    }

    public Caret getOverwriteCaret() {
        this.checkOverwriteCaret();
        return this.ovrCaret;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004) {
            this.selectCaret();
        }
        super.processFocusEvent(focusEvent);
    }

    protected void selectCaret() {
        Caret caret;
        if (EqTextArea.isOverwrite()) {
            this.checkOverwriteCaret();
            caret = this.ovrCaret;
        } else {
            caret = this.insCaret;
        }
        Caret caret2 = this.getCaret();
        if (caret != caret2) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            this.select(0, 0);
            int n3 = caret2.getMark();
            int n4 = caret2.getDot();
            caret2.setVisible(false);
            super.setCaret(caret);
            caret.setDot(n3);
            caret.moveDot(n4);
            caret.setVisible(true);
            this.select(n, n2);
        }
    }

    static {
        defaultActions = new Action[]{new ToggleInsOvrAction()};
        bindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 0), "toggle-ins-ovr")};
    }

    public static class ToggleInsOvrAction
    extends TextAction {
        ToggleInsOvrAction() {
            super("toggle-ins-ovr");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EqTextArea.setOverwrite(!EqTextArea.isOverwrite());
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof EqTextArea) {
                EqTextArea eqTextArea = (EqTextArea)jTextComponent;
                eqTextArea.selectCaret();
            }
        }
    }
}

