/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.Application;

import com.eloquence.api.ConfigurationHook;
import com.eloquence.api.MainHook;
import com.eloquence.services.Application.AboutDialog;
import com.eloquence.services.Application.ActiveDialogList;
import com.eloquence.services.Application.ActiveDialogView;
import com.eloquence.services.Application.ConfigurableTheme;
import com.eloquence.services.Application.ImagePanel;
import com.eloquence.services.Application.ThreadDialog;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.sessions.Session;
import com.eloquence.services.sessions.SessionView;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.ErrLog;
import com.eloquence.services.tools.ErrStream;
import com.eloquence.services.tools.GraphicsTool;
import com.eloquence.services.tools.IniFile;
import com.eloquence.services.tools.PropFile;
import com.eloquence.services.tools.SafeRunnable;
import com.eloquence.services.tools.Strings;
import com.eloquence.services.web.BrowserAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;

public final class StartUp
extends JApplet
implements ActionListener {
    private static int sessionCount = 0;
    private static boolean javaVersion1_6 = false;
    private static boolean javaVersion1_7 = false;
    private static boolean windows2k = false;
    private static boolean windowsXP = false;
    private static boolean windowsVista = false;
    private static boolean windows7 = false;
    private File errorLogTempFile = null;
    private Object trayIcon = null;
    private boolean trayUsed = false;
    private static URI jnlpCodeBase = null;
    private InputStream propInput = null;
    public static ThreadGroup systemThreadGroup = null;
    public static ThreadGroup dlgThreadGroup = null;
    private static Dlg.Listener dlgListener = null;
    private static final int DEFAULT_DLG_PORT = 8011;
    public static int dlg_port = 0;
    private static final int DEFAULT_DLG_COMPRESSION_THRESHOLD = 500;
    public static int dlg_compression_threshold = 0;
    public static int dlg_log_threshold = 0;
    public static JFrame MasterFrame = null;
    private static AboutDialog aboutDialog = null;
    protected static ThreadDialog threadDialog = null;
    private static final int ICONIFIED = 1;
    private static final int DEICONIFIED = 2;
    private static int masterFrameIconified = 0;
    public static Font DefaultFont = new Font("DialogInput", 0, 12);
    private static final String CMD_OPENCONSOLE = "OPENCONSOLE";
    private static final String CMD_SHOWSESSIONS = "SHOWSESSIONS";
    private static final String CMD_ACTIVEDIALOGS = "ACTIVEDIALOGS";
    private static final String CMD_SHOWLOG = "SHOWLOG";
    private static final String CMD_REREADCONFIG = "REREADCONFIG";
    private static final String CMD_ABOUT = "ABOUT";
    private static final String CMD_EXIT = "EXIT";
    public static Properties SysConfig = null;
    private static final String logo_icon_16x16 = "/com/eloquence/resources/eqlogo-icon16x16.gif";
    private static final String logo_icon_24x24 = "/com/eloquence/resources/eqlogo-icon24x24.gif";
    private static final String logo_icon_32x32 = "/com/eloquence/resources/eqlogo-icon32x32.gif";
    private static final String logo_icon_48x48 = "/com/eloquence/resources/eqlogo-icon48x48.gif";
    private static final String logo_icon_64x64 = "/com/eloquence/resources/eqlogo-icon64x64.gif";
    private static MainHook mainHook = null;
    private static ConfigurationHook configurationHook = null;
    private static URL logoIconUrl;
    private static boolean getKeepalive_note;
    public static SessionView sessionView;
    private static ActiveDialogView actDlgView;
    static StartUp application;
    public static Properties HelpConfig;
    public static boolean running_on_windows;
    public static String data_model;
    private static boolean initialized;
    public static PrintStream stderr;
    public static Delay delay;

    public static void incSessionCount() {
        ++sessionCount;
    }

    public static void decSessionCount() {
        --sessionCount;
    }

    public static int getSessionCount() {
        return sessionCount;
    }

    public static void main(String[] stringArray) {
        if (mainHook != null) {
            mainHook.beforeInit(stringArray);
        }
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                try {
                    application = new StartUp();
                    application.init();
                    application.startMasterFrame();
                    StartUp.setInitialized();
                }
                catch (Throwable throwable) {
                    System.err.println("JDLG Runtime error: " + throwable.toString());
                    throwable.printStackTrace(System.err);
                    StartUp.exit();
                }
            }
        });
        if (mainHook != null) {
            mainHook.afterInit(stringArray);
        }
    }

    public void init() {
        try {
            this.initErrorLog();
            StartUp.initJavaVersion();
            StartUp.initPlatformVersion();
            this.initConfiguration();
            this.initLookAndFeel();
            this.setUpTheme();
            this.initSystemFrames();
        }
        catch (Throwable throwable) {
            System.err.println("JDLG Runtime error: " + throwable.toString());
            throwable.printStackTrace(System.err);
            StartUp.exit();
        }
    }

    public static void exit() {
        System.err.println("JDLG terminating");
        System.exit(1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MasterFrame.getJMenuBar().getSelectionModel().clearSelection();
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OPENCONSOLE)) {
            MasterFrame.setVisible(true);
            MasterFrame.setExtendedState(0);
            MasterFrame.toFront();
        } else if (string.equals(CMD_SHOWSESSIONS)) {
            if (threadDialog == null) {
                threadDialog = new ThreadDialog(MasterFrame, dlgThreadGroup);
            }
            if (!threadDialog.isVisible()) {
                threadDialog.setLocation(MasterFrame.getX() + MasterFrame.getWidth(), MasterFrame.getY());
                threadDialog.setVisible(true);
            }
            if (actDlgView != null) {
                actDlgView.setVisible(false);
            }
        } else if (string.equals(CMD_ACTIVEDIALOGS)) {
            if (actDlgView == null) {
                actDlgView = new ActiveDialogView();
                ActiveDialogList.addListener(actDlgView);
            }
            if (!actDlgView.isVisible()) {
                actDlgView.setLocation(MasterFrame.getX() + MasterFrame.getWidth(), MasterFrame.getY());
                actDlgView.setVisible(true);
            }
            if (threadDialog != null) {
                threadDialog.setVisible(false);
            }
        } else if (string.equals(CMD_SHOWLOG)) {
            int n = 0;
            int n2 = 0;
            if (MasterFrame.isVisible() && (MasterFrame.getExtendedState() & 1) == 0) {
                n = MasterFrame.getX() + MasterFrame.getWidth();
                n2 = MasterFrame.getY();
            }
            ErrLog.show(n, n2);
        } else if (string.equals(CMD_REREADCONFIG)) {
            initialized = false;
            this.initConfiguration();
            MasterFrame.setResizable(true);
            MasterFrame.pack();
            MasterFrame.setResizable(false);
            StartUp.setInitialized();
        } else if (string.equals(CMD_ABOUT)) {
            this.aboutDialog();
        } else if (string.equals(CMD_EXIT)) {
            StartUp.destroyMasterFrame();
        }
        StartUp.repaintMasterFrame();
    }

    public static void shutdownSystem(String string) {
        System.err.println(string);
        StartUp.destroyMasterFrame();
    }

    public static void sessionFinished() {
        if (threadDialog != null) {
            threadDialog.update();
        }
        if (StartUp.isTrue((String)SysConfig.get("eloquence.config.exitonlastsession")) && StartUp.getSessionCount() == 0) {
            StartUp.destroyMasterFrame();
        }
    }

    private static void initJavaVersion() {
        String string;
        try {
            string = System.getProperty("java.version");
        }
        catch (Exception exception) {
            return;
        }
        int[] nArray = new int[3];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = string.indexOf(46, n);
            if (n2 < 0 && (n2 = string.indexOf(95, n)) < 0) {
                n2 = string.length();
            }
            try {
                nArray[i] = Integer.parseInt(string.substring(n, n2));
            }
            catch (Exception exception) {
                break;
            }
            n = n2 + 1;
        }
        if (nArray[0] > 1 || nArray[0] == 1 && nArray[1] >= 6) {
            javaVersion1_6 = true;
        }
        if (nArray[0] > 1 || nArray[0] == 1 && nArray[1] >= 7) {
            javaVersion1_7 = true;
        }
    }

    public static boolean isJavaVersion1_6() {
        return javaVersion1_6;
    }

    public static boolean isJavaVersion1_7() {
        return javaVersion1_7;
    }

    private static void initPlatformVersion() {
        double d;
        String string;
        try {
            string = System.getProperty("os.name");
            String string2 = System.getProperty("os.version");
            d = new Double(string2);
        }
        catch (Exception exception) {
            return;
        }
        if (string.startsWith("Windows") && d >= 5.0) {
            windows2k = true;
            if (d >= 5.1) {
                windowsXP = true;
                if (d >= 6.0) {
                    windowsVista = true;
                    if (d >= 7.0) {
                        windows7 = true;
                    }
                }
            }
        }
    }

    public static boolean isWindows2k() {
        return windows2k;
    }

    public static boolean isWindowsXP() {
        return windowsXP;
    }

    public static boolean isWindowsVista() {
        return windowsVista;
    }

    public static boolean isWindows7() {
        return windows7;
    }

    public static boolean isTrue(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") || string.equals("1");
    }

    public static boolean isFalse(String string) {
        return string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off") || string.equals("0");
    }

    private void initConfiguration() {
        block15: {
            String string;
            String string2;
            Session.init();
            if (configurationHook != null) {
                configurationHook.init();
            }
            if ((string2 = StartUp.getProperty("eloquence.config.debug")) != null && string2.length() > 0) {
                Debug.setup(string2);
            }
            if ((jnlpCodeBase = BrowserAccessor.jnlpCodeBase()) == null) {
                try {
                    int n;
                    string = System.getProperty("jnlp.codebase");
                    if (string == null && (n = (string = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString()).lastIndexOf(47)) >= 0) {
                        string = string.substring(0, n + 1);
                    }
                    jnlpCodeBase = new URI(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (jnlpCodeBase != null) {
                Debug.log(0, 1, "JNLP codebase: '" + jnlpCodeBase.toString() + "'");
            }
            logoIconUrl = null;
            string = "eloquence.config";
            String string3 = StartUp.getProperty(string);
            if (string3 == null) {
                string = "eloquence.config.file";
                string3 = StartUp.getProperty(string);
            }
            if (string3 == null) {
                string = "eloquence.config.url";
                string3 = StartUp.getProperty(string);
            }
            if (string3 == null) {
                string = null;
                string3 = "jdlg.cfg";
            }
            try {
                this.propInput = StartUp.openFileOrURL(string3);
                if (string != null) {
                    Debug.log(0, 1, string + ": '" + string3 + "'");
                } else {
                    Debug.log(0, 1, "default JDLG configuration: '" + string3 + "'");
                }
                this.setParameters(this.propInput);
            }
            catch (Throwable throwable) {
                if (string == null) break block15;
                System.err.println("Failed to load JDLG configuration '" + string3 + "': " + throwable.toString());
            }
        }
        this.setParametersFromApplications();
        this.setupConfigurationVariables();
        if (configurationHook != null) {
            configurationHook.done();
        }
        this.initConsoleSessionView();
    }

    private void setParameters(InputStream inputStream) {
        String string;
        Object object;
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        Enumeration<Object> enumeration = SysConfig.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = (String)properties.get(object);
            if (string == null) continue;
            SysConfig.setProperty((String)object, this.resolvePropsOrEnv(string));
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (!string.startsWith("eloquence.config.atom.")) continue;
            SysConfig.setProperty(string, this.resolvePropsOrEnv((String)properties.get(string)));
        }
        enumeration = HelpConfig.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            if (string2 == null) continue;
            HelpConfig.setProperty(string, this.resolvePropsOrEnv(string2));
        }
    }

    private void setParametersFromApplications() {
        Properties[] propertiesArray = new Properties[]{SysConfig, HelpConfig};
        for (int i = 0; i < propertiesArray.length; ++i) {
            Enumeration<Object> enumeration = propertiesArray[i].keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = StartUp.getProperty(string);
                if (string2 == null) continue;
                propertiesArray[i].setProperty(string, string2);
            }
        }
    }

    private void setupConfigurationVariables() {
        this.configureSystemVariables();
        String string = (String)SysConfig.get("eloquence.config.dlg.port");
        if (string != null && string.length() > 0) {
            string.trim();
            try {
                dlg_port = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                dlg_port = 8011;
                System.err.println("Invalid dlg.port '" + string + "', using " + dlg_port);
            }
        }
        if ((string = (String)SysConfig.get("eloquence.config.dlg.compression_threshold")) != null && string.length() > 0) {
            string.trim();
            try {
                dlg_compression_threshold = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                dlg_compression_threshold = 500;
                System.err.println("Invalid dlg.compression_threshold '" + string + "', using " + dlg_compression_threshold);
            }
        }
        if ((string = (String)SysConfig.get("eloquence.config.dlg.log_threshold")) != null && string.length() > 0) {
            string.trim();
            try {
                dlg_log_threshold = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                dlg_log_threshold = 0;
            }
        }
        this.initThreads();
        StartUp.loadSessions();
        String string2 = (String)SysConfig.get("eloquence.config.strings");
        if (string2 != null && string2.length() > 0) {
            try {
                Strings.load(string2);
                Debug.log(0, 1, "eloquence.config.strings: '" + string2 + "'");
            }
            catch (Throwable throwable) {
                System.err.println("Failed to load eloquence.config.strings '" + string2 + "': " + throwable.toString());
            }
        }
    }

    private static void loadSessions() {
        String string = (String)SysConfig.get("eloquence.config.sessions");
        if (string != null && string.length() > 0) {
            try {
                IniFile iniFile = new IniFile(StartUp.openFileOrURL(string));
                if (iniFile.isIniFile()) {
                    Debug.log(0, 1, "eloquence.config.sessions: '" + string + "'");
                    StartUp.loadSessionsFromIniFile(iniFile);
                    iniFile.close();
                } else {
                    iniFile.close();
                    PropFile propFile = new PropFile(StartUp.openFileOrURL(string));
                    if (propFile.isPropFile()) {
                        Debug.log(0, 1, "eloquence.config.sessions: '" + string + "'");
                        StartUp.loadSessionsFromPropFile(propFile);
                    } else {
                        System.err.println("Failed to load session configuration '" + string + "': File format not recognized");
                    }
                    propFile.close();
                }
            }
            catch (Throwable throwable) {
                System.err.println("Failed to load session configuration '" + string + "': " + throwable.toString());
                return;
            }
        }
    }

    private static void loadSessionsFromIniFile(IniFile iniFile) {
        String string;
        while ((string = iniFile.nextSection()) != null) {
            String string2;
            Session session = new Session(string);
            Session.add(session);
            while ((string2 = iniFile.nextEntry()) != null) {
                int n = session.setAttr(string2, iniFile.getValue(), false);
                if (n == 0) continue;
                System.err.println((n < 0 ? "Failed to set" : "Unknown") + " session configuration [" + string + "] " + string2);
            }
        }
    }

    private static void loadSessionsFromPropFile(PropFile propFile) {
        String[] stringArray;
        HashMap<String, Session> hashMap = new HashMap<String, Session>();
        while ((stringArray = propFile.nextEntry()) != null) {
            int n;
            if (stringArray.length < 2 || stringArray.length > 3) continue;
            String string = stringArray[0].toLowerCase();
            Session session = (Session)hashMap.get(string);
            if (session == null) {
                session = new Session(stringArray[0]);
                Session.add(session);
                hashMap.put(string, session);
            }
            if ((n = session.setAttr(stringArray[1], propFile.getValue(), stringArray.length == 3)) == 0) continue;
            System.err.println((n < 0 ? "Failed to set" : "Unknown") + " session configuration " + stringArray[0] + "." + stringArray[1]);
        }
    }

    private void setUpTheme() {
        String string = (String)SysConfig.get("eloquence.config.theme");
        if (string == null || string.length() == 0) {
            string = (String)SysConfig.get("theme");
        }
        String string2 = (String)SysConfig.get("eloquence.config.themeclass");
        if (string == null || string.length() == 0) {
            if (string2 != null && string2.length() > 0) {
                try {
                    Debug.log(0, 1, "eloquence.config.themeclass: '" + string2 + "'");
                    ConfigurableTheme.installTheme(string2);
                }
                catch (Throwable throwable) {
                    System.err.println("Theme installation failed: " + throwable.toString());
                }
            }
            return;
        }
        String string3 = "load";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(StartUp.openFileOrURL(string)));
            Debug.log(0, 1, "eloquence.config.theme: '" + string + "'");
            if (string2 != null && string2.length() > 0) {
                Debug.log(0, 1, "eloquence.config.themeclass: '" + string2 + "'");
            }
            ConfigurableTheme configurableTheme = new ConfigurableTheme(string2);
            while (true) {
                ++n;
                String string4 = bufferedReader.readLine();
                if (string4 == null) break;
                String string5 = string4.trim();
                if (string5.length() == 0 || string5.startsWith("#")) continue;
                int n2 = string4.indexOf(61);
                if (n2 == -1) {
                    throw new Exception("syntax error");
                }
                configurableTheme.setResource(string4.substring(0, n2).trim(), string4.substring(n2 + 1));
            }
            n = 0;
            bufferedReader.close();
            string3 = "install";
            configurableTheme.installTheme();
        }
        catch (Throwable throwable) {
            String string6 = "Failed to " + string3 + " theme configuration '" + string + "'";
            if (n > 0) {
                string6 = string6 + ", line " + n;
            }
            System.err.println(string6 + ": " + throwable.toString());
        }
    }

    private void initErrorLog() {
        try {
            this.errorLogTempFile = File.createTempFile("jdlg-", null);
            this.errorLogTempFile.deleteOnExit();
            new ErrLog();
            this.redirectStderr(this.errorLogTempFile, false);
        }
        catch (Throwable throwable) {
            System.err.println("Failed to create log window: " + throwable.toString());
        }
    }

    private void setupLogging() {
        Object object;
        String string = (String)SysConfig.get("eloquence.config.errorlog");
        if (string != null && string.length() > 0) {
            string.trim();
            try {
                object = new File(string);
                boolean bl = false;
                if (this.errorLogTempFile != null) {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream(this.errorLogTempFile);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object, true);
                    byte[] byArray = new byte[8192];
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                        bl = true;
                    }
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                this.redirectStderr((File)object, bl);
                if (this.errorLogTempFile != null) {
                    this.errorLogTempFile.delete();
                    this.errorLogTempFile = null;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Failed to open log file '" + string + "': " + throwable.toString());
            }
        }
        if ((object = (String)SysConfig.get("eloquence.config.debug")) != null && ((String)object).length() > 0) {
            Debug.setup((String)object);
        }
    }

    private void redirectStderr(File file, boolean bl) {
        try {
            System.setErr(new ErrStream((OutputStream)new FileOutputStream(file, true), true, bl));
        }
        catch (Throwable throwable) {
            System.err.println("Failed to redirect standard error output: " + throwable.toString());
        }
    }

    private void configureSystemVariables() {
        String string;
        this.setupLogging();
        String string2 = (String)SysConfig.get("eloquence.config.defaultfont.name");
        int n = 0;
        try {
            n = Integer.valueOf((String)SysConfig.get("eloquence.config.defaultfont.size"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 12;
            System.err.println("Invalid eloquence.config.defaultfont.size value( '" + SysConfig.get("eloquence.config.defaultfont.size") + "' - ignored, using 12pt.");
        }
        string2.trim();
        try {
            StartUp.setDefaultFont(new Font(string2, 0, n));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        try {
            string = (String)SysConfig.get("eloquence.config.imagequality");
            GraphicsTool.setAntialiasing(Integer.parseInt(string.trim()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = (String)SysConfig.get("eloquence.config.syswin");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        string.trim();
        if (string.equals("iconified")) {
            masterFrameIconified = 1;
        } else if (string.equals("deiconified")) {
            masterFrameIconified = 2;
        }
        ESystem.typeAhead.enable(StartUp.getTypeAheadEnabled());
        StartUp.delay.singleClick = 0;
        try {
            String string3 = (String)SysConfig.get("eloquence.config.delay.singleclick");
            StartUp.delay.singleClick = Integer.parseInt(string3.trim());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void aboutDialog() {
        aboutDialog.setLocation(MasterFrame.getX() + MasterFrame.getWidth(), MasterFrame.getY());
        aboutDialog.setVisible(true);
    }

    private static void initAboutDialog() {
        aboutDialog = new AboutDialog(MasterFrame);
        aboutDialog.pack();
    }

    private void initThreads() {
        if (systemThreadGroup == null) {
            systemThreadGroup = new ThreadGroup("System");
        }
        if (dlgThreadGroup == null) {
            dlgThreadGroup = new ThreadGroup("DLG");
        }
        if (dlgListener != null) {
            dlgListener.stop();
            dlgListener = null;
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (dlg_port >= 0) {
            dlgListener = new Dlg.Listener(dlg_port);
            dlgListener.start();
        }
    }

    private void initLookAndFeel() {
        String string = (String)SysConfig.get("eloquence.config.lookandfeel");
        if (string == null || string.length() == 0) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable) {
                System.err.println("Failed to install default look-and-feel: " + throwable.toString());
            }
            return;
        }
        Debug.log(0, 1, "eloquence.config.lookandfeel: '" + string + "'");
        String string2 = null;
        string2 = string.equalsIgnoreCase("system") ? UIManager.getSystemLookAndFeelClassName() : (string.equalsIgnoreCase("java") ? UIManager.getCrossPlatformLookAndFeelClassName() : (string.equalsIgnoreCase("motif") ? "com.sun.java.swing.plaf.motif.MotifLookAndFeel" : (string.equalsIgnoreCase("gtk") ? "com.sun.java.swing.plaf.gtk.GTKLookAndFeel" : (string.equalsIgnoreCase("windows") ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (string.equalsIgnoreCase("metal") ? "javax.swing.plaf.metal.MetalLookAndFeel" : (string.equalsIgnoreCase("nimbus") ? "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel" : string))))));
        try {
            UIManager.setLookAndFeel(string2);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Failed to install look-and-feel: " + throwable.toString());
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable2) {
                System.err.println("Failed to install fallback look-and-feel: " + throwable2.toString());
            }
            return;
        }
    }

    private void initSystemFrames() {
        this.initConsole();
        StartUp.initAboutDialog();
    }

    public Object getTrayIcon() {
        return this.trayIcon;
    }

    public boolean isTrayUsed() {
        return this.trayUsed;
    }

    private static void repaintMasterFrame() {
        if (MasterFrame != null) {
            MasterFrame.setVisible(true);
            MasterFrame.repaint();
            Container container = MasterFrame.getContentPane();
            container.repaint();
            if (container instanceof JComponent) {
                ((JComponent)container).revalidate();
            }
        }
    }

    private static boolean destroyMasterFrame() {
        if (StartUp.getSessionCount() > 0 && JOptionPane.showConfirmDialog(MasterFrame, Strings.get("console.window.close.message"), Strings.get("console.window.close.title"), 0, 2) != 0) {
            return false;
        }
        System.exit(0);
        return true;
    }

    private void initConsole() {
        Serializable serializable;
        Accessible accessible;
        Accessible accessible2;
        Object object;
        MasterFrame = new JFrame(Strings.get("console.window.title"));
        MasterFrame.setFont(StartUp.getDefaultFont());
        try {
            MasterFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(StartUp.getLogoIconUrl()));
        }
        catch (Throwable throwable) {
            System.err.println(throwable.toString());
        }
        try {
            object = this.getClass().getResource("/com/eloquence/resources/eqlogo-150.gif");
            AboutDialog.setImage(Toolkit.getDefaultToolkit().getImage((URL)object));
        }
        catch (Throwable throwable) {
            System.err.println(throwable.toString());
        }
        if (StartUp.isJavaVersion1_6() && StartUp.getTrayEnabled() && SystemTray.isSupported()) {
            try {
                object = SystemTray.getSystemTray();
                accessible2 = new PopupMenu();
                accessible = new MenuItem(Strings.get("tray.menu.openconsole"));
                ((MenuItem)accessible).setActionCommand(CMD_OPENCONSOLE);
                ((MenuItem)accessible).addActionListener(this);
                ((Menu)accessible2).add((MenuItem)accessible);
                ((Menu)accessible2).addSeparator();
                accessible = new MenuItem(Strings.get("tray.menu.showsessions"));
                ((MenuItem)accessible).setActionCommand(CMD_SHOWSESSIONS);
                ((MenuItem)accessible).addActionListener(this);
                ((Menu)accessible2).add((MenuItem)accessible);
                accessible = new MenuItem(Strings.get("tray.menu.activedialogs"));
                ((MenuItem)accessible).setActionCommand(CMD_ACTIVEDIALOGS);
                ((MenuItem)accessible).addActionListener(this);
                ((Menu)accessible2).add((MenuItem)accessible);
                accessible = new MenuItem(Strings.get("tray.menu.showlogmessages"));
                ((MenuItem)accessible).setActionCommand(CMD_SHOWLOG);
                ((MenuItem)accessible).addActionListener(this);
                ((Menu)accessible2).add((MenuItem)accessible);
                ErrLog.setPopupMenuItem((MenuItem)accessible);
                ((Menu)accessible2).addSeparator();
                accessible = new MenuItem(Strings.get("tray.menu.about"));
                ((MenuItem)accessible).setActionCommand(CMD_ABOUT);
                ((MenuItem)accessible).addActionListener(this);
                ((Menu)accessible2).add((MenuItem)accessible);
                ((Menu)accessible2).addSeparator();
                accessible = new MenuItem(Strings.get("tray.menu.exit"));
                ((MenuItem)accessible).setActionCommand(CMD_EXIT);
                ((MenuItem)accessible).addActionListener(this);
                ((Menu)accessible2).add((MenuItem)accessible);
                serializable = ((SystemTray)object).getTrayIconSize();
                String string = ((Dimension)serializable).height > 56 ? logo_icon_64x64 : (((Dimension)serializable).height > 40 ? logo_icon_48x48 : (((Dimension)serializable).height > 28 ? logo_icon_32x32 : (((Dimension)serializable).height > 20 ? logo_icon_24x24 : logo_icon_16x16)));
                this.trayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(string)));
                ((TrayIcon)this.trayIcon).setToolTip("Eloquence JDLG");
                ((TrayIcon)this.trayIcon).setImageAutoSize(true);
                ((TrayIcon)this.trayIcon).setPopupMenu((PopupMenu)accessible2);
                ((TrayIcon)this.trayIcon).addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (!(mouseEvent.getButton() != 1 || mouseEvent.getClickCount() < 2 && ESystem.getObject().restoreTopMostWindow())) {
                            if (!MasterFrame.isVisible()) {
                                MasterFrame.setExtendedState(0);
                                MasterFrame.toFront();
                                MasterFrame.setVisible(true);
                            } else {
                                MasterFrame.setExtendedState(1);
                            }
                        }
                    }
                });
                ((SystemTray)object).add((TrayIcon)this.trayIcon);
                this.trayUsed = true;
            }
            catch (Throwable throwable) {
                System.err.println("Failed to setup tray icon: " + throwable.toString());
            }
        }
        MasterFrame.setDefaultCloseOperation(0);
        class MasterFrameListener
        extends WindowAdapter {
            MasterFrameListener() {
            }

            public final void windowIconified(WindowEvent windowEvent) {
                if (StartUp.this.isTrayUsed()) {
                    MasterFrame.setVisible(false);
                }
            }

            public final void windowClosing(WindowEvent windowEvent) {
                if (StartUp.this.isTrayUsed() && !StartUp.isTrue((String)SysConfig.get("eloquence.config.sessionview.quitonclose"))) {
                    MasterFrame.setState(1);
                } else {
                    StartUp.destroyMasterFrame();
                }
            }

            public final void windowDeiconified(WindowEvent windowEvent) {
                StartUp.repaintMasterFrame();
            }
        }
        object = new MasterFrameListener();
        MasterFrame.addWindowListener((WindowListener)object);
        MasterFrame.addWindowStateListener((WindowStateListener)object);
        MasterFrame.setBackground(Color.lightGray);
        accessible2 = new JMenuBar();
        accessible = new JMenu(Strings.get("console.menu.1.title"));
        serializable = new JMenuItem(Strings.get("console.menu.1.item.showsessions"));
        ((AbstractButton)serializable).setActionCommand(CMD_SHOWSESSIONS);
        ((AbstractButton)serializable).addActionListener(this);
        ((JMenu)accessible).add((JMenuItem)serializable);
        serializable = new JMenuItem(Strings.get("console.menu.1.item.activedialogs"));
        ((AbstractButton)serializable).setActionCommand(CMD_ACTIVEDIALOGS);
        ((AbstractButton)serializable).addActionListener(this);
        ((JMenu)accessible).add((JMenuItem)serializable);
        serializable = new JMenuItem(Strings.get("console.menu.1.item.showlogmessages"));
        ((AbstractButton)serializable).setActionCommand(CMD_SHOWLOG);
        ((AbstractButton)serializable).addActionListener(this);
        ((JMenu)accessible).add((JMenuItem)serializable);
        ErrLog.setMainMenuItem((JMenuItem)serializable);
        serializable = new JMenuItem(Strings.get("console.menu.1.item.rereadconfiguration"));
        ((AbstractButton)serializable).setActionCommand(CMD_REREADCONFIG);
        ((AbstractButton)serializable).addActionListener(this);
        ((JMenu)accessible).add((JMenuItem)serializable);
        ((JMenu)accessible).addSeparator();
        serializable = new JMenuItem(Strings.get("console.menu.1.item.aboutjdlg"));
        ((AbstractButton)serializable).setActionCommand(CMD_ABOUT);
        ((AbstractButton)serializable).addActionListener(this);
        ((JMenu)accessible).add((JMenuItem)serializable);
        ((JMenu)accessible).addSeparator();
        serializable = new JMenuItem(Strings.get("console.menu.1.item.exit"));
        ((AbstractButton)serializable).setActionCommand(CMD_EXIT);
        ((JMenu)accessible).add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(this);
        ((JMenuBar)accessible2).add((JMenu)accessible);
        MasterFrame.setJMenuBar((JMenuBar)accessible2);
        this.initConsoleSessionView();
    }

    private void initConsoleSessionView() {
        if (Session.hasVisibleSession()) {
            if (sessionView == null) {
                sessionView = new SessionView();
            }
            sessionView.setView();
        } else {
            sessionView = null;
        }
        if (MasterFrame != null) {
            MasterFrame.getContentPane().removeAll();
            if (sessionView != null) {
                MasterFrame.getContentPane().add((Component)sessionView, "Center");
            } else {
                Serializable serializable;
                ImagePanel imagePanel = new ImagePanel(108, 64);
                try {
                    serializable = this.getClass().getResource("/com/eloquence/resources/eqlogo-150.gif");
                    imagePanel.setImage(MasterFrame.getToolkit().getImage((URL)serializable));
                }
                catch (Throwable throwable) {
                    System.err.println(throwable.toString());
                }
                serializable = new JPanel();
                ((Container)serializable).add(imagePanel);
                ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(10, 11, 5, 11));
                MasterFrame.getContentPane().add((Component)serializable, "Center");
            }
        }
    }

    private void startMasterFrame() {
        MasterFrame.pack();
        MasterFrame.setLocation(1, 1);
        MasterFrame.setResizable(false);
        boolean bl = false;
        switch (masterFrameIconified) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (sessionView != null) break;
                bl = true;
            }
        }
        if (this.isTrayUsed()) {
            if (!bl) {
                MasterFrame.setState(0);
                MasterFrame.setVisible(true);
                MasterFrame.toFront();
            } else {
                MasterFrame.setVisible(false);
            }
        } else {
            if (bl) {
                MasterFrame.setState(1);
            } else {
                MasterFrame.setState(0);
            }
            MasterFrame.setVisible(true);
        }
        Session.autoStart();
    }

    public static Font getDefaultFont() {
        return DefaultFont;
    }

    private static void setDefaultFont(Font font) {
        DefaultFont = font;
    }

    public String resolvePropsOrEnv(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                int n = string.indexOf("(", i);
                int n2 = string.indexOf(")", i);
                if (n > 0 && n2 > 0) {
                    String string3 = string.substring(n + 1, n2);
                    String string4 = null;
                    try {
                        string4 = StartUp.getProperty(string3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (string4 == null) {
                        try {
                            string4 = System.getenv(string3);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (string4 != null) {
                        string2 = string2 + string4;
                    }
                    i = n2;
                    continue;
                }
                string2 = string2 + "$";
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static int getDlgPort() {
        int n = Dlg.Listener.getLocalPort();
        return n >= 0 ? n : dlg_port;
    }

    public static Component getMainFrameComponent() {
        return MasterFrame;
    }

    public static URL getLogoIconUrl() {
        if (logoIconUrl != null) {
            return logoIconUrl;
        }
        String string = (String)SysConfig.get("eloquence.config.logoicon");
        if (string != null && string.length() > 0) {
            try {
                URI uRI = StartUp.uriFromString(string);
                URL uRL = uRI.toURL();
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.getInputStream().close();
                Debug.log(0, 1, "eloquence.config.logoicon: '" + uRI.toString() + "'");
                logoIconUrl = uRL;
                return logoIconUrl;
            }
            catch (Throwable throwable) {
                System.err.println("Failed to load eloquence.config.logoicon '" + string + "': " + throwable.toString());
            }
        }
        try {
            logoIconUrl = application.getClass().getResource(logo_icon_16x16);
            return logoIconUrl;
        }
        catch (Throwable throwable) {
            System.err.println("Failed to load default logoicon resource");
            throwable.printStackTrace(System.err);
            StartUp.exit();
            logoIconUrl = null;
            return logoIconUrl;
        }
    }

    public static String getBaseURL() {
        URI uRI;
        String string = (String)SysConfig.get("eloquence.config.baseurl");
        if (string != null && string.length() > 0 && (uRI = StartUp.uriFromString(string)) != null) {
            return uRI.toString();
        }
        return "";
    }

    public static String getHelpBaseURL() {
        URI uRI;
        String string = (String)SysConfig.get("eloquence.config.helpbaseurl");
        if (string != null && string.length() > 0 && (uRI = StartUp.uriFromString(string)) != null) {
            return uRI.toString();
        }
        return "";
    }

    public static boolean getTrayEnabled() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.tray"));
    }

    public static String getClipboardContextMenu() {
        return (String)SysConfig.get("eloquence.config.clipboardcontextmenu");
    }

    public static String getSessionLoginCache() {
        return (String)SysConfig.get("eloquence.config.sessionlogincache");
    }

    public static String getPrintCommand() {
        return SysConfig.getProperty("eloquence.config.printcommand");
    }

    public static String getDefaultPrinter() {
        return SysConfig.getProperty("eloquence.config.defaultprinter");
    }

    public static String getPrintersCommand() {
        return SysConfig.getProperty("eloquence.config.printerscommand");
    }

    public static String getPrintersFilter() {
        return SysConfig.getProperty("eloquence.config.printersfilter");
    }

    public static boolean getNotifyBusy() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.notifybusy"));
    }

    public static String getEditMode() {
        return SysConfig.getProperty("eloquence.config.editmode");
    }

    public static boolean getEditExpandWidth() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.editexpandwidth"));
    }

    public static int getKeepalive() {
        try {
            int n = Integer.valueOf((String)SysConfig.get("eloquence.config.keepalive"));
            if (n >= 0) {
                getKeepalive_note = false;
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!getKeepalive_note) {
            getKeepalive_note = true;
            System.err.println("Invalid eloquence.config.keepalive value '" + (String)SysConfig.get("eloquence.config.keepalive") + "' - ignored.");
        }
        return 0;
    }

    public static boolean getTypeAheadEnabled() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.typeahead"));
    }

    public static boolean getEnableReference() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.enablereference"));
    }

    public static boolean getEnableScaleFactor() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.enablescalefactor"));
    }

    public static boolean getEnableMaximize() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.enablemaximize"));
    }

    public static boolean getEnableSnap() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.enablesnap"));
    }

    public static boolean getSnapAdjustSize() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.snapadjustsize"));
    }

    public static boolean getImageScale() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.imagescale"));
    }

    public static int getReturnLcase() {
        try {
            String string = (String)SysConfig.get("eloquence.config.returnlcase");
            return Integer.parseInt(string.trim());
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    public static int getDialogWOverlap() {
        try {
            String string = (String)SysConfig.get("eloquence.config.dialog.w_overlap");
            return Integer.parseInt(string.trim());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static int getDialogHOverlap() {
        try {
            String string = (String)SysConfig.get("eloquence.config.dialog.h_overlap");
            return Integer.parseInt(string.trim());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static boolean getDialogScroll() {
        return StartUp.isTrue((String)SysConfig.get("eloquence.config.dialog.scroll"));
    }

    public static String getProperty(String string) {
        try {
            String string2 = System.getProperty(string);
            if (string2 == null) {
                string2 = System.getProperty("jnlp." + string);
            }
            return string2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static InputStream openFileOrURL(String string) throws Throwable {
        try {
            URI uRI = URI.create(string);
            if (!uRI.isAbsolute()) {
                File file = new File(string);
                if (file.exists() && !file.isDirectory()) {
                    return new FileInputStream(file);
                }
                if (jnlpCodeBase != null) {
                    uRI = jnlpCodeBase.resolve(uRI);
                }
            }
            return uRI.toURL().openStream();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new FileInputStream(new File(string));
    }

    public static URI uriFromString(String string) {
        try {
            URI uRI = URI.create(string);
            if (!uRI.isAbsolute() && jnlpCodeBase != null) {
                uRI = jnlpCodeBase.resolve(uRI);
            }
            return uRI;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void setInitialized() {
        Timer timer = new Timer(1000, new SetInitialized());
        timer.setRepeats(false);
        timer.start();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        try {
            mainHook = (MainHook)Thread.currentThread().getContextClassLoader().loadClass("com.eloquence.hook.Main").newInstance();
        }
        catch (Throwable throwable) {
            mainHook = null;
        }
        try {
            configurationHook = (ConfigurationHook)Thread.currentThread().getContextClassLoader().loadClass("com.eloquence.hook.Configuration").newInstance();
        }
        catch (Throwable throwable) {
            configurationHook = null;
        }
        SysConfig = new Properties();
        SysConfig.setProperty("eloquence.config.dlg.port", "8011");
        SysConfig.setProperty("eloquence.config.dlg.compression_threshold", "500");
        SysConfig.setProperty("eloquence.config.dlg.log_threshold", "0");
        SysConfig.setProperty("eloquence.config.defaultfont.name", "DialogInput");
        SysConfig.setProperty("eloquence.config.defaultfont.size", "12");
        SysConfig.setProperty("eloquence.config.syswin", "");
        SysConfig.setProperty("eloquence.config.tray", "true");
        SysConfig.setProperty("eloquence.config.errorlog", "");
        SysConfig.setProperty("eloquence.config.debug", "");
        SysConfig.setProperty("eloquence.config.sessions", "");
        SysConfig.setProperty("eloquence.config.helpbaseurl", "");
        SysConfig.setProperty("eloquence.config.baseurl", "");
        SysConfig.setProperty("eloquence.config.lookandfeel", "");
        SysConfig.setProperty("eloquence.config.logoicon", "");
        SysConfig.setProperty("eloquence.config.clipboardcontextmenu", "");
        SysConfig.setProperty("eloquence.config.exitonlastsession", "");
        SysConfig.setProperty("eloquence.config.sessionlogincache", "1");
        SysConfig.setProperty("eloquence.config.printcommand", "lp -d$p -oraw");
        SysConfig.setProperty("eloquence.config.defaultprinter", "");
        SysConfig.setProperty("eloquence.config.printerscommand", "lpstat -a");
        SysConfig.setProperty("eloquence.config.printersfilter", "^(\\S+)");
        SysConfig.setProperty("eloquence.config.notifybusy", "true");
        SysConfig.setProperty("eloquence.config.sessionview.quitonclose", "true");
        SysConfig.setProperty("eloquence.config.editmode", "");
        SysConfig.setProperty("eloquence.config.editexpandwidth", "true");
        SysConfig.setProperty("eloquence.config.keepalive", "0");
        SysConfig.setProperty("eloquence.config.typeahead", "true");
        SysConfig.setProperty("eloquence.config.imagescale", "false");
        SysConfig.setProperty("eloquence.config.imagequality", "2");
        SysConfig.setProperty("eloquence.config.enablereference", "true");
        SysConfig.setProperty("eloquence.config.enablescalefactor", "true");
        SysConfig.setProperty("eloquence.config.enablemaximize", "true");
        SysConfig.setProperty("eloquence.config.enablesnap", "false");
        SysConfig.setProperty("eloquence.config.snapadjustsize", "false");
        SysConfig.setProperty("eloquence.config.returnlcase", "1");
        SysConfig.setProperty("eloquence.config.dialog.w_overlap", "0");
        SysConfig.setProperty("eloquence.config.dialog.h_overlap", "0");
        SysConfig.setProperty("eloquence.config.dialog.scroll", "true");
        SysConfig.setProperty("eloquence.config.delay.singleclick", "0");
        SysConfig.setProperty("eloquence.config.strings", "");
        SysConfig.setProperty("eloquence.config.theme", "");
        SysConfig.setProperty("eloquence.config.themeclass", "");
        SysConfig.setProperty("theme", "");
        logoIconUrl = null;
        getKeepalive_note = false;
        sessionView = null;
        actDlgView = null;
        application = null;
        HelpConfig = null;
        running_on_windows = false;
        data_model = "";
        initialized = false;
        stderr = System.err;
        HelpConfig = new Properties();
        String string = System.getProperty("os.name");
        if (string.regionMatches(true, 0, "linux", 0, "linux".length())) {
            HelpConfig.setProperty("eloquence.help.cmdpre", "xdg-open ");
            HelpConfig.setProperty("eloquence.help.cmdpost", "");
        } else if (string.regionMatches(true, 0, "windows", 0, "windows".length())) {
            int n;
            running_on_windows = true;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = null;
            for (n = 0; stringTokenizer.hasMoreTokens() && n < 2; ++n) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2 != null && n == 2) {
                HelpConfig.setProperty("eloquence.help.cmdpre", "rundll32 url.dll,FileProtocolHandler ");
                HelpConfig.setProperty("eloquence.help.cmdpost", "");
            } else {
                System.err.println("Could not find a Windwos Version");
            }
        } else {
            HelpConfig.setProperty("eloquence.help.cmdpre", "open ");
            HelpConfig.setProperty("eloquence.help.cmdpost", "");
        }
        data_model = System.getProperty("sun.arch.data.model");
        delay = new Delay();
    }

    public static final class Delay {
        public int singleClick = 0;
        public Timer singleClickTimer = null;
        public long[] mousePressed = new long[2];
        public long[] mouseReleased = new long[2];
    }

    private static final class SetInitialized
    implements ActionListener {
        private SetInitialized() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            initialized = true;
        }
    }
}

