/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.Application;

import com.eloquence.services.Application.ActiveDialogList;
import com.eloquence.services.Application.ActiveDialogListener;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThreadDialog
extends JDialog
implements ActiveDialogListener {
    protected ThreadGroup threadGroup = null;
    private JScrollPane listPane = new JScrollPane();
    private JList list = new JList(new DefaultListModel());
    private JButton closeButton = new JButton();
    private JButton disconnectAction = new JButton();

    private void jbInit() throws Exception {
        Strings.setButtonText(this.closeButton, "showsessions.dismiss");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDialog.this.closeButton_actionPerformed(actionEvent);
            }
        });
        Strings.setButtonText(this.disconnectAction, "showsessions.disconnect");
        this.disconnectAction.setEnabled(false);
        this.disconnectAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDialog.this.disconnectAction_actionPerformed(actionEvent);
            }
        });
        this.list.setVisibleRowCount(5);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ThreadDialog.this.disconnectAction.setEnabled(ThreadDialog.this.list.getSelectedValue() != null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ThreadDialog.this.list_mouseReleased(mouseEvent);
            }
        });
        this.setTitle(Strings.get("showsessions.title"));
        this.listPane.getViewport().add((Component)this.list, null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.disconnectAction, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 10, 20), 0, 0));
        jPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 20, 10, 20), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)this.listPane, "Center");
        this.pack();
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    void disconnectAction_actionPerformed(ActionEvent actionEvent) {
        this.disconnectApplication();
    }

    void list_mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.disconnectApplication();
        }
    }

    void disconnectApplication() {
        String string = (String)this.list.getSelectedValue();
        if (string == null || string.length() < 1) {
            return;
        }
        String string2 = string;
        int n = string2.indexOf(" (", 1);
        string2 = n > 0 ? string2.substring(1, n).trim() : string2.substring(1).trim();
        Thread[] threadArray = new Thread[this.threadGroup.activeCount()];
        this.threadGroup.enumerate(threadArray, false);
        for (n = 0; n < threadArray.length; ++n) {
            String string3;
            Thread thread = threadArray[n];
            if (thread == null || !(string3 = thread.getName()).startsWith("DLG ") || !(string3 = string3.substring(string3.lastIndexOf(32) + 1)).equals(string2)) continue;
            try {
                thread.interrupt();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void update() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        defaultListModel.clear();
        Thread[] threadArray = new Thread[this.threadGroup.activeCount()];
        this.threadGroup.enumerate(threadArray, false);
        for (int i = 0; i < threadArray.length; ++i) {
            String string;
            Thread thread = threadArray[i];
            if (!(thread instanceof Dlg) || !(string = thread.getName()).startsWith("DLG ")) continue;
            string = string.substring(string.lastIndexOf(32) + 1);
            String string2 = ActiveDialogList.getTitleByThread(thread);
            if (string2.length() > 0) {
                defaultListModel.addElement(" " + string + " (" + string2 + ") ");
                continue;
            }
            defaultListModel.addElement(" " + string + " ");
        }
        this.list.setModel(defaultListModel);
        this.invalidate();
        this.pack();
    }

    public ThreadDialog(JFrame jFrame, ThreadGroup threadGroup) {
        super(jFrame);
        this.threadGroup = threadGroup;
        ActiveDialogList.addListener(this);
        this.update();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected ThreadDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.threadGroup = null;
    }
}

