/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractTextControl;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.protocols.dlg.Dlg;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;

public abstract class AbstractButtonControl
extends AbstractTextControl
implements ControlsManager.RuleOverride {
    private static HashMap attributeList = new HashMap();
    private static final int RULEOVERRIDE_ATTR_ID = 1;
    private static final int TRAVERSECR_ATTR_ID = 2;
    protected boolean inButton = false;
    public static final String RULEOVERRIDE_ATTR_NAME = "ruleoverride";
    protected boolean ruleOverride = false;
    public static final String TRAVERSECR_ATTR_NAME = "traversecr";
    private boolean traversecr = false;
    private boolean typeAheadAction = false;

    AbstractButtonControl() {
    }

    public void cloneAttributes(AbstractButtonControl abstractButtonControl) {
        abstractButtonControl.setRuleOverride(this.getRuleOverride());
        abstractButtonControl.setTraverseCr(this.getTraverseCr());
        super.cloneAttributes(abstractButtonControl);
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 1: {
                    this.setRuleOverride(sET.getValueInt());
                    break;
                }
                case 2: {
                    this.setTraverseCr(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 1: {
                    gET2.setValueInt(this.getRuleOverride());
                    break;
                }
                case 2: {
                    gET2.setValueInt(this.getTraverseCr());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public boolean isFocusable(boolean bl) {
        return this.inToolBar() ? false : super.isFocusable(bl);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.processRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        if (!this.consumeInputEvent(mouseEvent)) {
            this.getRuleManager().prepareOverride(this, mouseEvent);
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.consumeInputEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!this.inButton) {
            this.getRuleManager().cancelOverride();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.inButton = true;
        super.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.inButton = false;
        super.mouseExited(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this.traversecr) {
                this.getRuleManager().requestNextFocus();
            } else {
                ((AbstractButton)this.peer).doClick();
            }
            return;
        }
        super.keyPressed(keyEvent);
    }

    public void setRuleOverride(int n) {
        this.ruleOverride = n != 0;
    }

    public int getRuleOverride() {
        return this.ruleOverride ? 1 : 0;
    }

    public void setTraverseCr(int n) {
        this.traversecr = n != 0;
    }

    public int getTraverseCr() {
        return this.traversecr ? 1 : 0;
    }

    public boolean fireButtonRule() {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.fireButtonRule() && this.typeAheadAction) {
            ESystem.typeAhead.processPendingEvents(this);
        }
        this.typeAheadAction = false;
        super.actionPerformed(actionEvent);
    }

    public boolean acceptTypeAhead(ESystem.TypeAheadItem typeAheadItem) {
        StringBuilder stringBuilder = typeAheadItem.chars;
        if (stringBuilder != null) {
            if (stringBuilder.charAt(0) != ' ') {
                return false;
            }
            if (stringBuilder.deleteCharAt(0).length() == 0) {
                stringBuilder = null;
            }
            if (stringBuilder != null || typeAheadItem.termChar != 0) {
                typeAheadItem.chars = stringBuilder;
                ESystem.typeAhead.pushItem(typeAheadItem);
            }
            this.typeAheadAction = true;
            ((AbstractButton)this.peer).doClick();
            return true;
        }
        if (typeAheadItem.termChar == 10) {
            if (this.traversecr) {
                this.typeAheadNextFocus();
            } else {
                this.typeAheadAction = true;
                ((AbstractButton)this.peer).doClick();
            }
            return true;
        }
        if (typeAheadItem.termChar == 9) {
            this.typeAheadNextFocus();
            return true;
        }
        return typeAheadItem.termChar == 0;
    }

    static {
        attributeList.put(RULEOVERRIDE_ATTR_NAME, new Integer(1));
        attributeList.put(TRAVERSECR_ATTR_NAME, new Integer(2));
    }
}

