/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.DragDropHandler;
import com.eloquence.api.EqComboBox;
import com.eloquence.api.EqTextField;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.jdlg.controls.TextComponentClipboardManager;
import com.eloquence.services.protocols.dlg.Dlg;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class EComboBox
extends AbstractControl
implements DocumentListener,
ActionListener,
PopupMenuListener,
FocusListener,
ComponentListener {
    private static HashMap attributeList = new HashMap();
    private static final int CONTENT_ATTR_ID = 0;
    private static final int ITEMS_ATTR_ID = 1;
    private static final int ADD_ATTR_ID = 2;
    private static final int EDITABLE_ATTR_ID = 3;
    private static final int CLEAR_ATTR_ID = 4;
    private static final int MAXCHARS_ATTR_ID = 5;
    private static final int ALIGN_ATTR_ID = 7;
    private static final int BOXHEIGHT_ATTR_ID = 8;
    private static final int BOXWIDTH_ATTR_ID = 9;
    private static final int LINE_ATTR_ID = 10;
    private static final int OPEN_ATTR_ID = 11;
    private static final int DRAG_CONTENT_ATTR_ID = 12;
    private static final int DROP_CX_ATTR_ID = 13;
    private static final int TC_RULE_ATTR_ID = 14;
    private static final int TC_DELAY_ATTR_ID = 15;
    private static final int TC_MINCHARS_ATTR_ID = 16;
    private static Color peerPlafBgc = null;
    private static Color editorPlafBgc = null;
    private boolean mousePressed = false;
    private boolean popupOpen = false;
    private boolean contentModified = false;
    private int ignoreDocumentUpdate = 0;
    public static final String CLASS_ATTR_NAME = "ComboBox";
    private static final String CONTENT_ATTR_NAME = "content";
    private String content = "";
    private boolean contentSet = false;
    private boolean contentCached = false;
    private static final String ITEMS_ATTR_NAME = "items";
    private static final String LIST_ATTR_NAME = "list";
    private static final String LINE_BUF_ATTR_NAME = "line_buf";
    private List itemList = null;
    private boolean itemListModified = false;
    private static final String ADD_ATTR_NAME = "add";
    private static final String CLEAR_ATTR_NAME = "clear";
    private static final String LINE_ATTR_NAME = "line";
    private static final String EDITABLE_ATTR_NAME = "editable";
    private boolean editable = true;
    private static final String MAXCHARS_ATTR_NAME = "maxchars";
    private int maxChars = 0;
    private static final String ALIGN_ATTR_NAME = "align";
    private static final String LEFT_NAME = "LEFT";
    private static final String CENTER_NAME = "CENTER";
    private static final String RIGHT_NAME = "RIGHT";
    private int align = 2;
    private static final String BOXHEIGHT_ATTR_NAME = "boxheight";
    private int boxHeight = 8;
    private static final String BOXWIDTH_ATTR_NAME = "boxwidth";
    private int boxWidth = 0;
    private static final String OPEN_ATTR_NAME = "open";
    private boolean openOnFocus = false;
    private static final String TC_RULE_ATTR_NAME = "tcrule";
    private static final String TC_DELAY_ATTR_NAME = "tcdelay";
    private static final String TC_MINCHARS_ATTR_NAME = "tcminchars";
    private int textChangedRule = 0;
    private int textChangedDelay = 500;
    private int textChangedMinChars = 1;
    private boolean textChangedHasTimer = false;
    private static final String DRAG_CONTENT_ATTR_NAME = "dragcontent";
    private static final String DROP_CX_ATTR_NAME = "dropcx";
    private String dragContent = null;
    private int dropCx = -1;
    private int dragSaveSelectionStart = 0;
    private int dragSaveSelectionEnd = 0;
    private TextComponentClipboardManager clipboardManager = null;

    public EComboBox() {
        EJComboBox eJComboBox = new EJComboBox();
        JTextField jTextField = (JTextField)eJComboBox.getEditor().getEditorComponent();
        jTextField.addFocusListener(this);
        eJComboBox.setEditable(true);
        eJComboBox.setMaximumRowCount(this.boxHeight);
        eJComboBox.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        eJComboBox.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        eJComboBox.setFocusTraversalKeys(2, Collections.EMPTY_SET);
        eJComboBox.setFocusTraversalKeys(3, Collections.EMPTY_SET);
        jTextField.addKeyListener(this);
        EPlainDocument ePlainDocument = new EPlainDocument();
        jTextField.setDocument(ePlainDocument);
        ePlainDocument.addDocumentListener(this);
        eJComboBox.setFont(StartUp.getDefaultFont());
        eJComboBox.addActionListener(this);
        eJComboBox.addPopupMenuListener(this);
        eJComboBox.addComponentListener(this);
        if (peerPlafBgc == null) {
            peerPlafBgc = eJComboBox.getBackground();
            editorPlafBgc = jTextField.getBackground();
        }
        this.peer = eJComboBox;
        this.itemList = new LinkedList();
        this.clipboardManager = new TextComponentClipboardManager((JTextComponent)eJComboBox.getEditor().getEditorComponent());
    }

    private void setComponentMouseListener(boolean bl) {
        Component[] componentArray = ((EJComboBox)this.peer).getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (bl) {
                componentArray[i].addMouseListener(this);
                continue;
            }
            componentArray[i].removeMouseListener(this);
        }
    }

    public void postConstruction() {
        super.postConstruction();
        this.peer.removeMouseListener(this);
        this.setComponentMouseListener(true);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            EJComboBox eJComboBox = (EJComboBox)this.peer;
            JTextField jTextField = (JTextField)eJComboBox.getEditor().getEditorComponent();
            jTextField.removeKeyListener(this);
            jTextField.removeFocusListener(this);
            this.setComponentMouseListener(false);
            eJComboBox.removeComponentListener(this);
            eJComboBox.removePopupMenuListener(this);
            eJComboBox.removeActionListener(this);
            EPlainDocument ePlainDocument = (EPlainDocument)jTextField.getDocument();
            ePlainDocument.removeDocumentListener(this);
            super.dispose();
            this.content = null;
            if (this.itemList != null) {
                this.itemList.clear();
                this.itemList = null;
            }
            this.dragContent = null;
            this.clipboardManager = null;
        }
    }

    public Object clone() {
        EComboBox eComboBox = new EComboBox();
        this.cloneAttributes(eComboBox);
        return eComboBox;
    }

    private void cloneAttributes(EComboBox eComboBox) {
        super.cloneAttributes(eComboBox);
        eComboBox.setContent(this.getContent());
        eComboBox.setItems(this.getItems());
        eComboBox.setMaxChars(this.getMaxChars());
        eComboBox.setAlign(this.getAlign());
        eComboBox.setBoxHeight(this.getBoxHeight());
        eComboBox.setBoxWidth(this.getBoxWidth());
        eComboBox.setOpenOnFocus(this.getOpenOnFocus());
        eComboBox.setTextChangedRule(this.getTextChangedRule());
        eComboBox.setTextChangedDelay(this.getTextChangedDelay());
        eComboBox.setTextChangedMinChars(this.getTextChangedMinChars());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 10: {
                        sTATUS.attrMode = 5;
                        return this.setLine(sET.getValueString(), this.getInt(sET.index));
                    }
                }
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setContent(sET.getValueString());
                    sTATUS.attrMode = 5;
                    if (!this.contentCached) break;
                    sTATUS.cacheMode = 1;
                    break;
                }
                case 1: {
                    this.setItems(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 2: {
                    this.setAdd(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 3: {
                    this.setEditable(sET.getValueInt() != 0);
                    sTATUS.attrMode = 5;
                    break;
                }
                case 4: {
                    this.setClear();
                    sTATUS.attrMode = 5;
                    break;
                }
                case 5: {
                    this.setMaxChars(sET.getValueInt());
                    break;
                }
                case 7: {
                    this.setAlign(sET.getValueString());
                    break;
                }
                case 8: {
                    this.setBoxHeight(sET.getValueInt());
                    break;
                }
                case 9: {
                    this.setBoxWidth(sET.getValueInt());
                    break;
                }
                case 10: {
                    this.setLine(sET.getValueString(), 0);
                    sTATUS.attrMode = 5;
                    break;
                }
                case 11: {
                    this.setOpenOnFocus(sET.getValueInt());
                    break;
                }
                case 14: {
                    this.setTextChangedRule(sET.getValueInt());
                    break;
                }
                case 15: {
                    this.setTextChangedDelay(sET.getValueInt());
                    break;
                }
                case 16: {
                    this.setTextChangedMinChars(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 10: {
                        if (gET2.setValueString(this.getLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getContent());
                    gET2.cacheMode = 1;
                    this.contentCached = true;
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getItems());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getEditable() ? 1 : 0);
                    break;
                }
                case 5: {
                    gET2.setValueInt(this.getMaxChars());
                    break;
                }
                case 7: {
                    gET2.setValueString(this.getAlign());
                    break;
                }
                case 8: {
                    gET2.setValueInt(this.getBoxHeight());
                    break;
                }
                case 9: {
                    gET2.setValueInt(this.getBoxWidth());
                    break;
                }
                case 10: {
                    if (gET2.setValueString(this.getLine(0))) break;
                    return 11;
                }
                case 11: {
                    gET2.setValueInt(this.getOpenOnFocus());
                    break;
                }
                case 12: {
                    gET2.setValueString(this.getDragContent());
                    break;
                }
                case 13: {
                    gET2.setValueInt(this.getDropCx());
                    break;
                }
                case 14: {
                    gET2.setValueInt(this.getTextChangedRule());
                    break;
                }
                case 15: {
                    gET2.setValueInt(this.getTextChangedDelay());
                    break;
                }
                case 16: {
                    gET2.setValueInt(this.getTextChangedMinChars());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        boolean bl2;
        if (bl) {
            this.dragContent = null;
            this.dropCx = -1;
        }
        this.textChangedHasTimer = false;
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        boolean bl3 = bl2 = ruleManager != null && ruleManager.getFocus() == this;
        if (!this.isModified) {
            if (bl2) {
                this.checkOpenOnFocus();
            }
            super.eloq2swing(bl);
            return;
        }
        ++this.ignoreDocumentUpdate;
        JComboBox jComboBox = (JComboBox)this.peer;
        jComboBox.setEditable(this.editable);
        jComboBox.setMaximumRowCount(this.boxHeight);
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.setHorizontalAlignment(this.align);
        ListCellRenderer listCellRenderer = jComboBox.getRenderer();
        if (listCellRenderer instanceof BasicComboBoxRenderer) {
            ((BasicComboBoxRenderer)listCellRenderer).setHorizontalAlignment(this.align);
        }
        if (this.itemListModified) {
            this.itemListModified = false;
            int n = jComboBox.getItemCount();
            jComboBox.removeAllItems();
            boolean bl4 = false;
            for (String string : this.itemList) {
                Object object = this.makeObj(string);
                jComboBox.addItem(object);
                if (bl4 || !string.toString().equals(this.content)) continue;
                bl4 = true;
                jComboBox.setSelectedItem(object);
            }
            if (n < this.boxHeight && n < jComboBox.getItemCount()) {
                jComboBox.hidePopup();
            }
            if (!bl4 && this.editable) {
                jComboBox.setSelectedItem(this.makeObj(this.content));
            }
        } else if (this.contentSet) {
            int n;
            int n2 = jComboBox.getItemCount();
            for (n = 0; n < n2; ++n) {
                Object e = jComboBox.getItemAt(n);
                if (!e.toString().equals(this.content)) continue;
                jComboBox.setSelectedItem(e);
                break;
            }
            if (n == n2 && this.editable) {
                jComboBox.setSelectedItem(this.makeObj(this.content));
            }
        }
        this.overrideBackground = false;
        if (bl2) {
            if (this.focusColor != null) {
                this.overrideBackground = true;
                jComboBox.setBackground(this.focusColor);
                jTextField.setBackground(this.focusColor);
            }
            this.requestFocusInWindow(jTextField);
            this.checkOpenOnFocus();
        }
        super.eloq2swing(bl);
        if (!this.overrideBackground) {
            if (this.bgc != null) {
                this.peer.setBackground(this.bgc);
                jTextField.setBackground(this.bgc);
            } else {
                this.peer.setBackground(peerPlafBgc);
                jTextField.setBackground(editorPlafBgc);
            }
        }
        if (this.contentSet) {
            this.contentSet = false;
            if (bl2 && this.editable && (!(jTextField instanceof EqTextField) || !EqTextField.isOverwrite())) {
                jTextField.selectAll();
            } else {
                jTextField.select(0, 0);
                jTextField.setCaretPosition(0);
            }
        }
        --this.ignoreDocumentUpdate;
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        Object[] objectArray;
        super.swing2eloq(dO);
        JComboBox jComboBox = (JComboBox)this.peer;
        String string = null;
        if (jComboBox.isEditable() && (objectArray = jComboBox.getEditor()) != null) {
            string = objectArray.getItem().toString();
        }
        if (string == null && (objectArray = jComboBox.getSelectedObjects()) != null && objectArray.length != 0) {
            string = objectArray[0].toString();
        }
        String string2 = this.content = string != null ? string : "";
        if (dO != null && this.contentModified) {
            dO.cache((AbstractControl)this, CONTENT_ATTR_NAME, 0, this.content);
            this.contentCached = true;
            this.contentModified = false;
        }
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.clipboardManager.resetUndoBuffer();
        super.actionPerformed(actionEvent);
        if (this.textChangedRule != 0 && this.getRule() != 0 && (actionEvent.getModifiers() & 0x10) != 0) {
            this.getRuleManager().fireRule(this);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.consumeInputEvent(keyEvent)) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 38: 
            case 40: 
            case 224: 
            case 225: {
                break;
            }
            case 10: {
                if (this.checkForFunctionKey(keyEvent)) {
                    return;
                }
                if (this.popupOpen && (!this.openOnFocus || !((EJComboBox)this.peer).isEditable())) break;
                this.getRuleManager().requestNextFocus();
                break;
            }
            case 90: {
                if (!keyEvent.isMetaDown() && !keyEvent.isControlDown()) break;
                keyEvent.consume();
                this.clipboardManager.undo();
                break;
            }
            default: {
                if (this.checkForFunctionKey(keyEvent)) {
                    return;
                }
                super.keyPressed(keyEvent);
            }
        }
    }

    public boolean checkForFunctionKey(KeyEvent keyEvent) {
        if (super.checkForFunctionKey(keyEvent)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        String string;
        if (this.isNativeRightMouseButtonEvent(mouseEvent) && !this.isRightMouseButtonEvent(mouseEvent) && ((EJComboBox)this.peer).getEditor().getEditorComponent().hasFocus() && TextComponentClipboardManager.isContextMenuConfigured(string = this.getClipboardContextMenu())) {
            mouseEvent.consume();
            this.clipboardManager.showContextMenu(string, mouseEvent.getPoint());
            return;
        }
        if (this.processRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        this.mousePressed = true;
        this.getRuleManager().requestFocus(this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.consumeRightMouseButtonEvent(mouseEvent)) {
            this.mousePressed = false;
        }
    }

    protected boolean doContextMenu(AbstractControl abstractControl, MouseEvent mouseEvent) {
        String string;
        if (this.contextMenu.length() == 0 && ((EJComboBox)this.peer).getEditor().getEditorComponent().hasFocus() && TextComponentClipboardManager.isContextMenuConfigured(string = this.getClipboardContextMenu())) {
            this.clipboardManager.showContextMenu(string, mouseEvent.getPoint());
            return true;
        }
        return super.doContextMenu(abstractControl, mouseEvent);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.popupOpen = true;
        if (this.getRuleManager().getFocus() != this) {
            this.getRuleManager().requestFocus(this, true);
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.popupOpen = false;
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.popupOpen = false;
    }

    public void focusReceived(AbstractControl abstractControl) {
        JTextField jTextField = (JTextField)((EJComboBox)this.peer).getEditor().getEditorComponent();
        if (abstractControl != this) {
            this.clipboardManager.resetUndoBuffer();
            if (!this.mousePressed) {
                if (!(jTextField instanceof EqTextField) || !EqTextField.isOverwrite()) {
                    jTextField.selectAll();
                } else {
                    jTextField.select(0, 0);
                    jTextField.setCaretPosition(0);
                }
            }
        }
        if (this.focusColor != null) {
            this.overrideBackground = true;
            this.peer.setBackground(this.focusColor);
            jTextField.setBackground(this.focusColor);
        }
        super.focusReceived(abstractControl);
    }

    public void focusLost(AbstractControl abstractControl) {
        this.mousePressed = false;
        if (this.getRule() != 0 && this.isInDlgDo()) {
            this.getRuleManager().fireRule(this);
        }
        JTextField jTextField = null;
        if (this.peer != null) {
            jTextField = (JTextField)((JComboBox)this.peer).getEditor().getEditorComponent();
            if (this.bgc != null) {
                this.peer.setBackground(this.bgc);
                jTextField.setBackground(this.bgc);
            } else {
                this.peer.setBackground(peerPlafBgc);
                jTextField.setBackground(editorPlafBgc);
            }
        }
        this.overrideBackground = false;
        if (jTextField != null && abstractControl != this) {
            jTextField.select(0, 0);
            jTextField.setCaretPosition(0);
        }
        super.focusLost(abstractControl);
        EDialog eDialog = this.getDialog();
        if (eDialog != null) {
            eDialog.cancelRuleTimer(this);
        }
    }

    public boolean fireRuleOnLosingFocus() {
        return this.getRule() != 0;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.checkOpenOnFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (ruleManager != null && ruleManager.getFocus() == this) {
            this.checkOpenOnFocus();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        EDialog eDialog;
        this.contentModified = true;
        if (this.ignoreDocumentUpdate == 0 && (eDialog = this.getDialog()) != null && eDialog.eventsAllowed()) {
            this.textChangedOnDocumentUpdate(eDialog, false);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        EDialog eDialog;
        this.contentModified = true;
        if (this.ignoreDocumentUpdate == 0 && (eDialog = this.getDialog()) != null && eDialog.eventsAllowed()) {
            this.textChangedOnDocumentUpdate(eDialog, true);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    private void setContent(String string) {
        this.content = this.filterASCIIHighlightChars(string);
        this.contentSet = true;
        this.isModified = true;
    }

    private String getContent() {
        return this.content;
    }

    private void setItems(String string) {
        this.itemList.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.itemList.add(stringTokenizer.nextElement());
        }
        this.itemListModified = true;
        this.isModified = true;
    }

    private String getItems() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void setAdd(String string) {
        int n;
        string = this.filterASCIIHighlightChars(string);
        int n2 = 0;
        while ((n = string.indexOf(10, n2)) >= n2) {
            this.itemList.add(string.substring(n2, n));
            n2 = n + 1;
        }
        this.itemList.add(string.substring(n2));
        this.itemListModified = true;
        this.isModified = true;
    }

    private void setClear() {
        this.content = "";
        this.contentSet = true;
        this.itemList.clear();
        this.itemListModified = true;
        this.isModified = true;
    }

    private int setLine(String string, int n) {
        if (n < 1) {
            this.setContent(string);
            return 0;
        }
        string = this.filterASCIIHighlightChars(string);
        if (n > 0 && n <= this.itemList.size()) {
            this.itemList.set(n - 1, string);
        } else {
            this.itemList.add(string);
        }
        this.itemListModified = true;
        this.isModified = true;
        return 0;
    }

    private String getLine(int n) {
        if (n < 1) {
            return this.content;
        }
        if (n > 0 && n <= this.itemList.size()) {
            return (String)this.itemList.get(n - 1);
        }
        return null;
    }

    private int setEditable(boolean bl) {
        this.editable = bl;
        this.isModified = true;
        return 0;
    }

    private boolean getEditable() {
        return this.editable;
    }

    private void setMaxChars(int n) {
        this.maxChars = n;
    }

    private int getMaxChars() {
        return this.maxChars;
    }

    private void setAlign(String string) {
        this.align = string.equalsIgnoreCase(CENTER_NAME) ? 0 : (string.equalsIgnoreCase(RIGHT_NAME) ? 4 : 2);
        this.isModified = true;
    }

    private String getAlign() {
        switch (this.align) {
            case 0: {
                return CENTER_NAME;
            }
            case 4: {
                return RIGHT_NAME;
            }
        }
        return LEFT_NAME;
    }

    private void setBoxHeight(int n) {
        this.boxHeight = n;
        this.isModified = true;
    }

    private int getBoxHeight() {
        return this.boxHeight;
    }

    private void setBoxWidth(int n) {
        this.boxWidth = n > 0 ? n : 0;
    }

    private int getBoxWidth() {
        return this.boxWidth;
    }

    private void setOpenOnFocus(int n) {
        this.openOnFocus = n != 0;
    }

    private int getOpenOnFocus() {
        return this.openOnFocus ? 1 : 0;
    }

    private void checkOpenOnFocus() {
        EJComboBox eJComboBox;
        if (this.openOnFocus && this.isInDlgDo() && (eJComboBox = (EJComboBox)this.peer).isShowing() && eJComboBox.isEditable()) {
            if (eJComboBox.getItemCount() > 0) {
                eJComboBox.showPopup();
            } else {
                eJComboBox.hidePopup();
            }
        }
    }

    private void setTextChangedRule(int n) {
        this.textChangedRule = n;
    }

    private int getTextChangedRule() {
        return this.textChangedRule;
    }

    private void setTextChangedDelay(int n) {
        this.textChangedDelay = n;
    }

    private int getTextChangedDelay() {
        return this.textChangedDelay;
    }

    private void setTextChangedMinChars(int n) {
        this.textChangedMinChars = n;
    }

    private int getTextChangedMinChars() {
        return this.textChangedMinChars;
    }

    private void textChangedOnDocumentUpdate(EDialog eDialog, boolean bl) {
        if (this.textChangedRule != 0) {
            JTextField jTextField = (JTextField)((JComboBox)this.peer).getEditor().getEditorComponent();
            if (bl || jTextField.getText().length() >= this.textChangedMinChars) {
                eDialog.startRuleTimer(this, this.textChangedRule, this.textChangedDelay);
                this.textChangedHasTimer = true;
                return;
            }
        }
        if (this.textChangedHasTimer) {
            eDialog.cancelRuleTimer(this);
            this.textChangedHasTimer = false;
        }
    }

    public boolean acceptTypeAhead(ESystem.TypeAheadItem typeAheadItem) {
        Object object;
        if (typeAheadItem.chars != null) {
            object = (JTextField)((JComboBox)this.peer).getEditor().getEditorComponent();
            ((JTextComponent)object).replaceSelection(typeAheadItem.chars.toString());
        }
        if (!this.popupOpen && typeAheadItem.termChar == 10) {
            object = this.getDialog();
            if (object == null || ((EDialog)object).getCr() == 0) {
                this.typeAheadNextFocus();
                return true;
            }
        } else if (typeAheadItem.termChar == 9) {
            this.typeAheadNextFocus();
            return true;
        }
        return typeAheadItem.termChar == 0;
    }

    private final String getDragContent() {
        return this.dragContent != null ? this.dragContent : "";
    }

    private final int getDropCx() {
        return this.dropCx;
    }

    public void enableDragDrop() {
        this.setDragDropHandler(new DragDrop());
    }

    static {
        attributeList.put(CONTENT_ATTR_NAME, new Integer(0));
        attributeList.put(LIST_ATTR_NAME, new Integer(1));
        attributeList.put(ITEMS_ATTR_NAME, new Integer(1));
        attributeList.put(LINE_BUF_ATTR_NAME, new Integer(1));
        attributeList.put(ADD_ATTR_NAME, new Integer(2));
        attributeList.put(EDITABLE_ATTR_NAME, new Integer(3));
        attributeList.put(CLEAR_ATTR_NAME, new Integer(4));
        attributeList.put(MAXCHARS_ATTR_NAME, new Integer(5));
        attributeList.put(ALIGN_ATTR_NAME, new Integer(7));
        attributeList.put(BOXHEIGHT_ATTR_NAME, new Integer(8));
        attributeList.put(BOXWIDTH_ATTR_NAME, new Integer(9));
        attributeList.put(LINE_ATTR_NAME, new Integer(10));
        attributeList.put(OPEN_ATTR_NAME, new Integer(11));
        attributeList.put(DRAG_CONTENT_ATTR_NAME, new Integer(12));
        attributeList.put(DROP_CX_ATTR_NAME, new Integer(13));
        attributeList.put(TC_RULE_ATTR_NAME, new Integer(14));
        attributeList.put(TC_DELAY_ATTR_NAME, new Integer(15));
        attributeList.put(TC_MINCHARS_ATTR_NAME, new Integer(16));
    }

    class EPlainDocument
    extends PlainDocument {
        EPlainDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                super.insertString(n, string, attributeSet);
                return;
            }
            int n2 = EComboBox.this.getMaxChars();
            int n3 = this.getLength();
            int n4 = string.length();
            if (n2 == 0 || n2 >= n3 + n4) {
                super.insertString(n, string, attributeSet);
            } else if (n2 > n3) {
                super.insertString(n, string.substring(0, n2 - n3), attributeSet);
            }
        }
    }

    class EJComboBox
    extends EqComboBox {
        public boolean doingLayout = false;

        public void processEvent(AWTEvent aWTEvent) {
            if (!EComboBox.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401 && ((EJComboBox)EComboBox.this.peer).isEditable()) {
                switch (keyEvent.getKeyCode()) {
                    case 38: 
                    case 40: 
                    case 224: 
                    case 225: {
                        super.processKeyEvent(keyEvent);
                        break;
                    }
                    case 10: {
                        if (EComboBox.this.checkForFunctionKey(keyEvent)) {
                            return;
                        }
                        EComboBox.this.getRuleManager().requestNextFocus();
                        break;
                    }
                    case 9: {
                        if (keyEvent.isShiftDown()) {
                            EComboBox.this.getRuleManager().requestPrevFocus();
                            break;
                        }
                        EComboBox.this.getRuleManager().requestNextFocus();
                        break;
                    }
                    default: {
                        EComboBox.this.checkForFunctionKey(keyEvent);
                    }
                }
            }
        }

        public void setSelectedItem(Object object) {
            EComboBox.this.ignoreDocumentUpdate++;
            super.setSelectedItem(object);
            EComboBox.this.ignoreDocumentUpdate--;
        }

        public void doLayout() {
            try {
                this.doingLayout = true;
                super.doLayout();
            }
            finally {
                this.doingLayout = false;
            }
        }

        public Dimension getSize() {
            Dimension dimension = super.getSize();
            if (!this.doingLayout && EComboBox.this.boxWidth > 0) {
                int n = EComboBox.this.boxWidth;
                if (EComboBox.this.useRasterPos) {
                    n *= EComboBox.this.getLayoutGrid().width;
                }
                if (n > dimension.width) {
                    dimension.width = n;
                }
            }
            return dimension;
        }
    }

    private final class DragDrop
    implements DragDropHandler {
        private DragDrop() {
        }

        public void enableDrag(boolean bl) {
            ((JTextComponent)this.getDragComponent()).setDragEnabled(bl);
        }

        public JComponent getDragComponent() {
            return (JComponent)((JComboBox)EComboBox.this.peer).getEditor().getEditorComponent();
        }

        public void beginDrag() {
            JTextComponent jTextComponent = (JTextComponent)this.getDragComponent();
            EComboBox.this.dragSaveSelectionStart = jTextComponent.getSelectionStart();
            EComboBox.this.dragSaveSelectionEnd = jTextComponent.getSelectionEnd();
        }

        public void dragStarting(InputEvent inputEvent) {
            EComboBox.this.dragContent = ((JTextComponent)this.getDragComponent()).getSelectedText();
        }

        public void dragFinished(int n) {
        }

        public void dragCanceled() {
            EComboBox.this.dragContent = null;
        }

        public void endDrag() {
            JTextComponent jTextComponent = (JTextComponent)this.getDragComponent();
            if (EComboBox.this.dragSaveSelectionStart != EComboBox.this.dragSaveSelectionEnd) {
                jTextComponent.select(EComboBox.this.dragSaveSelectionStart, EComboBox.this.dragSaveSelectionEnd);
                try {
                    jTextComponent.scrollRectToVisible(jTextComponent.modelToView(EComboBox.this.dragSaveSelectionStart).union(jTextComponent.modelToView(EComboBox.this.dragSaveSelectionEnd)));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public boolean acceptDrop(TransferHandler.TransferSupport transferSupport) {
            return true;
        }

        public boolean dropped(TransferHandler.TransferSupport transferSupport) {
            JTextComponent.DropLocation dropLocation = (JTextComponent.DropLocation)transferSupport.getDropLocation();
            EComboBox.this.dropCx = dropLocation.getIndex();
            return true;
        }
    }
}

