/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.GraphicsTool;
import com.eloquence.services.tools.Scaling;
import com.eloquence.services.tools.UiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class EGroupBox
extends AbstractControlContainer
implements ControlsManager.RuleOverride,
ComponentListener {
    private static HashMap attributeList = new HashMap();
    private static final int ICON_ATTR_ID = 0;
    private static final int ACCELERATOR_ATTR_ID = 1;
    private static final int BORDERSTYLE_ATTR_ID = 2;
    private static final int VX_ATTR_ID = 3;
    private static final int VY_ATTR_ID = 4;
    private static final int VWIDTH_ATTR_ID = 5;
    private static final int VHEIGHT_ATTR_ID = 6;
    private static final int MARGIN_ATTR_ID = 7;
    private static final int MARGIN_TOP_ATTR_ID = 8;
    private static final int MARGIN_RIGHT_ATTR_ID = 9;
    private static final int MARGIN_BOTTOM_ATTR_ID = 10;
    private static final int MARGIN_LEFT_ATTR_ID = 11;
    private static final int BGIMAGE_ATTR_ID = 12;
    private static final int BGFILL_ATTR_ID = 13;
    private Timer vPosTimer = null;
    private static final int VPOS_TIMEOUT = 10;
    private boolean inPane = false;
    private Dimension scrollPaneSize = null;
    private Dimension vWindow = null;
    private Timer resizeTimer = null;
    private static final int RESIZE_TIMEOUT = 5;
    private Font lastFont;
    public static final String CLASS_ATTR_NAME = "GroupBox";
    public static final String ICON_ATTR_NAME = "icon";
    protected String icon = "";
    public static final String ACCELERATOR_ATTR_NAME = "accelerator";
    protected String accelerator = "";
    private static final String BORDERSTYLE_ATTR_NAME = "borderstyle";
    private static final String SOLID_STYLE_NAME = "solid";
    private static final String ETCHED_STYLE_NAME = "etched";
    private static final String RAISED_STYLE_NAME = "raised";
    private static final String LOWERED_STYLE_NAME = "lowered";
    private static final int SOLID_STYLE_ID = 0;
    private static final int ETCHED_STYLE_ID = 1;
    private static final int RAISED_STYLE_ID = 2;
    private static final int LOWERED_STYLE_ID = 3;
    private boolean borderModified = true;
    private int borderStyle = 0;
    private static final String VX_ATTR_NAME = "vx";
    private int vx = 0;
    private boolean vxSet = false;
    private static final String VY_ATTR_NAME = "vy";
    private int vy = 0;
    private boolean vySet = false;
    private static final String VWIDTH_ATTR_NAME = "vwidth";
    private int vWidth = 0;
    private static final String VHEIGHT_ATTR_NAME = "vheight";
    private int vHeight = 0;
    private static final String MARGIN_ATTR_NAME = "margin";
    private static final String MARGIN_TOP_ATTR_NAME = "margintop";
    private static final String MARGIN_RIGHT_ATTR_NAME = "marginright";
    private static final String MARGIN_BOTTOM_ATTR_NAME = "marginbottom";
    private static final String MARGIN_LEFT_ATTR_NAME = "marginleft";
    private boolean marginTop = false;
    private boolean marginRight = false;
    private boolean marginBottom = false;
    private boolean marginLeft = false;
    private static final String BGIMAGE_ATTR_NAME = "bgimage";
    private String bgimageUrl = "";
    private boolean bgimageModified = false;
    private static final String BGFILL_ATTR_NAME = "bgfill";
    private int bgFillMode = 2;
    private ImageIcon imageIcon = null;
    private KeyStroke keyStroke = null;
    private GroupBoxPanel peerPanel = new GroupBoxPanel();
    private GroupBoxScrollPane scrollPane;

    public EGroupBox() {
        this.peerPanel.setFont(StartUp.getDefaultFont());
        this.peerPanel.setOpaque(false);
        this.peerPanel.setFocusTraversalKeysEnabled(false);
        this.scrollPane = new GroupBoxScrollPane(this.peerPanel);
        this.scrollPane.addComponentListener(this);
        this.peer = this.scrollPane;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.scrollPane.removeComponentListener(this);
            this.scrollPane = null;
            this.peerPanel = null;
            this.icon = null;
            this.imageIcon = null;
            this.accelerator = null;
            this.keyStroke = null;
            this.vPosTimer = null;
            this.resizeTimer = null;
            super.dispose();
        }
    }

    public Object clone() {
        EGroupBox eGroupBox = new EGroupBox();
        this.cloneAttributes(eGroupBox);
        return eGroupBox;
    }

    protected void cloneAttributes(EGroupBox eGroupBox) {
        super.cloneAttributes(eGroupBox);
        eGroupBox.setIcon(this.getIcon());
        eGroupBox.setAccelerator(this.getAccelerator());
        eGroupBox.setBorderStyle(this.getBorderStyle());
        eGroupBox.setVx(this.getVx());
        eGroupBox.setVy(this.getVy());
        eGroupBox.setVWidth(this.getVWidth());
        eGroupBox.setVHeight(this.getVHeight());
        eGroupBox.setMarginTop(this.getMarginTop());
        eGroupBox.setMarginRight(this.getMarginRight());
        eGroupBox.setMarginBottom(this.getMarginBottom());
        eGroupBox.setMarginLeft(this.getMarginLeft());
        eGroupBox.setBgimage(this.getBgimage());
        eGroupBox.setBgfill(this.getBgfill());
    }

    public void eloq2swing(boolean bl) {
        if (this.isModified) {
            boolean bl2;
            boolean bl3 = bl2 = this.getSensitive() != 0;
            if (bl2 != this.peer.isEnabled()) {
                this.borderModified = true;
            }
            if (this.borderModified) {
                this.borderModified = false;
                if (!this.inPane && this.border > 0) {
                    Border border;
                    switch (this.borderStyle) {
                        case 1: {
                            border = BorderFactory.createEtchedBorder();
                            break;
                        }
                        case 2: {
                            border = BorderFactory.createBevelBorder(0);
                            break;
                        }
                        case 3: {
                            border = BorderFactory.createBevelBorder(1);
                            break;
                        }
                        default: {
                            border = BorderFactory.createLineBorder(bl2 ? this.fgc : UiUtil.getFgcDisabled(this.fgc), this.border > 2 ? 2 : this.border);
                        }
                    }
                    if (this.title.length() > 0) {
                        border = BorderFactory.createTitledBorder(border, this.title);
                        TitledBorder titledBorder = (TitledBorder)border;
                        titledBorder.setTitleColor(bl2 ? this.fgc : UiUtil.getFgcDisabled(this.fgc));
                        if (this.lastFont != null) {
                            titledBorder.setTitleFont(this.lastFont);
                        }
                    }
                    this.peerPanel.setBorder(border);
                } else if (this.peerPanel.getBorder() != null) {
                    this.peerPanel.setBorder(null);
                }
            }
            this.peerPanel.setOpaque(this.bgc != null);
            if (this.bgimageModified) {
                this.bgimageModified = false;
                this.peerPanel.setFillMode(this.bgFillMode);
                this.peerPanel.setImageUrl(this.createExpandedURL(this.bgimageUrl));
            }
            this.peerPanel.revalidate();
        }
        super.eloq2swing(bl);
        EDialog eDialog = this.getDialog();
        if (!eDialog.layoutChanged) {
            this.eloq2swingVPos(eDialog);
        }
    }

    protected final void eloq2swingToolhelp() {
    }

    private final void eloq2swingVPos(EDialog eDialog) {
        if (this.vxSet || this.vySet) {
            int n;
            if (eDialog == null && (eDialog = this.getDialog()) == null) {
                return;
            }
            if (eDialog.willResize() || !this.scrollPane.isShowing()) {
                this.startVPosTimer();
                return;
            }
            Dimension dimension = null;
            Scaling scaling = null;
            if (this.vxSet) {
                this.vxSet = false;
                if (this.vWidth > this.getWidth()) {
                    if (this.useRasterSize) {
                        dimension = this.getLayoutGrid();
                        n = (int)Math.round((double)this.vx * (double)dimension.width);
                    } else {
                        scaling = this.getScaling();
                        n = (int)Math.round((double)this.vx * scaling.x);
                    }
                    this.scrollPane.getHorizontalScrollBar().setValue(n);
                }
            }
            if (this.vySet) {
                this.vySet = false;
                if (this.vHeight > this.getHeight()) {
                    if (this.useRasterSize) {
                        if (dimension == null) {
                            dimension = this.getLayoutGrid();
                        }
                        n = (int)Math.round((double)this.vy * (double)dimension.height);
                    } else {
                        if (scaling == null) {
                            scaling = this.getScaling();
                        }
                        n = (int)Math.round((double)this.vy * scaling.y);
                    }
                    this.scrollPane.getVerticalScrollBar().setValue(n);
                }
            }
        }
        this.stopVPosTimer();
    }

    private final void startVPosTimer() {
        if (this.vPosTimer == null) {
            this.vPosTimer = new Timer(10, new VPosTimer());
            this.vPosTimer.setRepeats(false);
            this.vPosTimer.start();
        } else if (!this.vPosTimer.isRunning()) {
            this.vPosTimer.restart();
        }
    }

    private final void stopVPosTimer() {
        if (this.vPosTimer != null) {
            this.vPosTimer.stop();
            this.vPosTimer = null;
        }
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        Dimension dimension = null;
        Scaling scaling = null;
        this.vySet = false;
        this.vxSet = false;
        int n = this.getHorzScrollOffset();
        if (n > 0) {
            if (this.useRasterSize) {
                dimension = this.getLayoutGrid();
                this.vx = (int)Math.round((double)n / (double)dimension.width);
            } else {
                scaling = this.getScaling();
                this.vx = (int)Math.round((double)n / scaling.x);
            }
        } else {
            this.vx = 0;
        }
        n = this.getVertScrollOffset();
        if (n > 0) {
            if (this.useRasterSize) {
                if (dimension == null) {
                    dimension = this.getLayoutGrid();
                }
                this.vy = (int)Math.round((double)n / (double)dimension.height);
            } else {
                if (scaling == null) {
                    scaling = this.getScaling();
                }
                this.vy = (int)Math.round((double)n / scaling.y);
            }
        } else {
            this.vy = 0;
        }
        super.swing2eloq(dO);
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setIcon(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setAccelerator(sET.getValueString());
                    break;
                }
                case 2: {
                    this.setBorderStyle(sET.getValueString());
                    break;
                }
                case 3: {
                    this.setVx(sET.getValueInt());
                    break;
                }
                case 4: {
                    this.setVy(sET.getValueInt());
                    break;
                }
                case 5: {
                    this.setVWidth(sET.getValueInt());
                    break;
                }
                case 6: {
                    this.setVHeight(sET.getValueInt());
                    break;
                }
                case 7: {
                    this.setMargin(sET.getValueInt());
                    break;
                }
                case 8: {
                    this.setMarginTop(sET.getValueInt());
                    break;
                }
                case 9: {
                    this.setMarginRight(sET.getValueInt());
                    break;
                }
                case 10: {
                    this.setMarginBottom(sET.getValueInt());
                    break;
                }
                case 11: {
                    this.setMarginLeft(sET.getValueInt());
                    break;
                }
                case 12: {
                    this.setBgimage(sET.getValueString());
                    break;
                }
                case 13: {
                    return this.setBgfill(sET.getValueString());
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getIcon());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getAccelerator());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getBorderStyle());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getVx());
                    break;
                }
                case 4: {
                    gET2.setValueInt(this.getVy());
                    break;
                }
                case 5: {
                    gET2.setValueInt(this.getVWidth());
                    break;
                }
                case 6: {
                    gET2.setValueInt(this.getVHeight());
                    break;
                }
                case 7: {
                    gET2.setValueInt(this.getMargin());
                    break;
                }
                case 8: {
                    gET2.setValueInt(this.getMarginTop());
                    break;
                }
                case 9: {
                    gET2.setValueInt(this.getMarginRight());
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getMarginBottom());
                    break;
                }
                case 11: {
                    gET2.setValueInt(this.getMarginLeft());
                    break;
                }
                case 12: {
                    gET2.setValueString(this.getBgimage());
                    break;
                }
                case 13: {
                    gET2.setValueString(this.getBgfill());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public Container getContainerPeer() {
        return this.peerPanel;
    }

    public Component getTargetPeer() {
        return this.peerPanel;
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.borderModified = true;
    }

    public void childFocusChain(AbstractControl abstractControl, AbstractControl abstractControl2) {
        int n;
        int n2;
        Cloneable cloneable;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (AbstractControl abstractControl3 = abstractControl2; abstractControl3 != this; abstractControl3 = abstractControl3.getParent()) {
            cloneable = abstractControl3.getPeer().getLocation();
            n3 += cloneable.x;
            n4 += cloneable.y;
            n5 += abstractControl3.getHorzScrollOffset();
            n6 += abstractControl3.getVertScrollOffset();
        }
        n3 -= n5;
        n4 -= n6;
        cloneable = abstractControl2.getPeer().getSize();
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = this.scrollPane.getVerticalScrollBar();
        int n7 = jScrollBar.getValue();
        int n8 = jScrollBar2.getValue();
        if (this.vWidth > this.getWidth()) {
            n2 = n7 - n3;
            n = n7 + jScrollBar.getVisibleAmount() - (n3 + ((Dimension)cloneable).width);
            if (n2 > 0) {
                if (n2 >= n) {
                    if (n > 0) {
                        jScrollBar.setValue(n7 - n);
                    }
                } else {
                    jScrollBar.setValue(n7 - n2);
                }
            } else if (n < 0) {
                if (n2 >= n) {
                    if (n2 < 0) {
                        jScrollBar.setValue(n7 - n2);
                    }
                } else {
                    jScrollBar.setValue(n7 - n);
                }
            }
        }
        if (this.vHeight > this.getHeight()) {
            n2 = n8 - n4;
            n = n8 + jScrollBar2.getVisibleAmount() - (n4 + ((Dimension)cloneable).height);
            if (n2 > 0) {
                if (n2 >= n) {
                    if (n > 0) {
                        jScrollBar2.setValue(n8 - n);
                    }
                } else {
                    jScrollBar2.setValue(n8 - n2);
                }
            } else if (n < 0) {
                if (n2 >= n) {
                    if (n2 < 0) {
                        jScrollBar2.setValue(n8 - n2);
                    }
                } else {
                    jScrollBar2.setValue(n8 - n);
                }
            }
        }
        super.childFocusChain(abstractControl, abstractControl2);
    }

    public AbstractControl getNextFocusControl(boolean bl) {
        AbstractControl abstractControl = this.findNextFocusControl(null, bl, true);
        if (abstractControl == null) {
            abstractControl = this.getRootControl().findNextFocusControl(bl, false);
        }
        return abstractControl != null ? abstractControl : this.getRootControl();
    }

    public AbstractControl getPrevFocusControl(boolean bl) {
        AbstractControl abstractControl = this.findPrevFocusControl(null, bl, true);
        if (abstractControl == null) {
            abstractControl = this.getRootControl().findPrevFocusControl(bl, false);
        }
        return abstractControl != null ? abstractControl : this.getRootControl();
    }

    public AbstractControl findNextFocusControl(boolean bl, boolean bl2) {
        return this.findNextFocusControl(null, bl, bl2);
    }

    public AbstractControl findPrevFocusControl(boolean bl, boolean bl2) {
        return this.findPrevFocusControl(null, bl, bl2);
    }

    public void setInPane() {
        this.inPane = true;
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        int n;
        int n2;
        if (this.inPane) {
            if (this.scrollPaneSize == null) {
                return true;
            }
            dimension = this.scrollPaneSize;
            n2 = dimension.width;
            n = dimension.height;
            if (this.useRasterSize) {
                n2 = (int)Math.round((double)n2 / (double)dimension2.width);
                n = (int)Math.round((double)n / (double)dimension2.height);
            } else {
                n2 = (int)Math.round((double)n2 / scaling.x);
                n = (int)Math.round((double)n / scaling.y);
            }
            this.width = n2;
            this.height = n;
        } else {
            this.scrollPaneSize = null;
        }
        if (this.vWindow == null) {
            this.vWindow = new Dimension();
        }
        this.vWindow.width = this.vWidth > 0 ? (this.useRasterSize ? this.vWidth * dimension2.width : (int)Math.round((double)this.vWidth * scaling.x)) : 0;
        this.vWindow.height = this.vHeight > 0 ? (this.useRasterSize ? this.vHeight * dimension2.height : (int)Math.round((double)this.vHeight * scaling.y)) : 0;
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (this.vWindow.width != 0 && this.vWindow.width > n3) {
            n4 -= this.showHorizontalScrollBar(dimension2);
            n2 = 1;
        } else {
            n2 = 0;
        }
        if (this.vWindow.height != 0 && this.vWindow.height > n4) {
            n = 1;
            if (n2 == 0 && this.vWindow.width != 0 && this.vWindow.width > (n3 -= this.showVerticalScrollBar(dimension2))) {
                n4 -= this.showHorizontalScrollBar(dimension2);
                n2 = 1;
            }
        } else {
            n = 0;
        }
        if (n2 == 0) {
            this.vWindow.width = n3;
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        }
        if (n == 0) {
            this.vWindow.height = n4;
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        this.peerPanel.setPreferredSize(this.vWindow);
        this.peerPanel.revalidate();
        super.layout(this.vWindow, dimension2, scaling);
        if (this.vxSet || this.vySet) {
            this.startVPosTimer();
        }
        return false;
    }

    private final int showHorizontalScrollBar(Dimension dimension) {
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        jScrollBar.setUnitIncrement(dimension.width);
        return jScrollBar.getPreferredSize().height;
    }

    private final int showVerticalScrollBar(Dimension dimension) {
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(dimension.height);
        return jScrollBar.getPreferredSize().width;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.vxSet || this.vySet) {
            this.startVPosTimer();
        }
        if (this.inPane) {
            Dimension dimension = this.scrollPane.getSize();
            if (dimension.width > 0 && dimension.height > 0) {
                if (this.scrollPaneSize == null || dimension.width != this.scrollPaneSize.width || dimension.height != this.scrollPaneSize.height) {
                    if (this.scrollPaneSize == null) {
                        this.scrollPaneSize = new Dimension(dimension);
                    } else {
                        this.scrollPaneSize.width = dimension.width;
                        this.scrollPaneSize.height = dimension.height;
                    }
                    if (!this.getDialog().willResize()) {
                        this.startResizeTimer();
                    } else {
                        this.stopResizeTimer();
                    }
                }
                return;
            }
        }
        this.scrollPaneSize = null;
    }

    private final void startResizeTimer() {
        if (this.resizeTimer == null) {
            this.resizeTimer = new Timer(5, new ResizeTimer());
            this.resizeTimer.setRepeats(false);
            this.resizeTimer.start();
        } else if (!this.resizeTimer.isRunning()) {
            this.resizeTimer.restart();
        }
    }

    private final void stopResizeTimer() {
        if (this.resizeTimer != null) {
            this.resizeTimer.stop();
        }
    }

    public void fontModified(Font font) {
        Border border;
        if (!this.inPane && (border = this.peerPanel.getBorder()) != null && border instanceof TitledBorder) {
            ((TitledBorder)border).setTitleFont(font);
        }
        this.lastFont = font;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public int getBorder() {
        return this.border;
    }

    public void setIcon(String string) {
        URL uRL;
        if (string != null && string.length() > 0 && (uRL = this.createExpandedURL(string)) != null) {
            this.imageIcon = new ImageIcon(uRL);
            this.icon = string;
            this.isModified = true;
            return;
        }
        if (this.icon.length() > 0) {
            this.imageIcon = null;
            this.icon = "";
            this.isModified = true;
        }
    }

    public String getIcon() {
        return this.icon;
    }

    ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public void setAccelerator(String string) {
        if (string != null && string.length() > 0) {
            try {
                this.keyStroke = KeyStroke.getKeyStroke(string);
            }
            catch (Exception exception) {
                return;
            }
            this.accelerator = string;
            this.isModified = true;
            return;
        }
        if (this.accelerator.length() > 0) {
            this.keyStroke = null;
            this.accelerator = "";
            this.isModified = true;
        }
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    KeyStroke getKeyAccelerator() {
        return this.keyStroke;
    }

    public void setRuleOverride(int n) {
    }

    public int getRuleOverride() {
        if (this.parent != null && this.parent instanceof ControlsManager.RuleOverride) {
            return ((ControlsManager.RuleOverride)((Object)this.parent)).getRuleOverride();
        }
        return 0;
    }

    public void setBorderStyle(String string) {
        this.borderStyle = string.equalsIgnoreCase(ETCHED_STYLE_NAME) ? 1 : (string.equalsIgnoreCase(RAISED_STYLE_NAME) ? 2 : (string.equalsIgnoreCase(LOWERED_STYLE_NAME) ? 3 : 0));
        this.borderModified = true;
        this.isModified = true;
    }

    public String getBorderStyle() {
        switch (this.borderStyle) {
            case 1: {
                return ETCHED_STYLE_NAME;
            }
            case 2: {
                return RAISED_STYLE_NAME;
            }
            case 3: {
                return LOWERED_STYLE_NAME;
            }
        }
        return SOLID_STYLE_NAME;
    }

    private final void setVx(int n) {
        if (n != this.vx) {
            this.vx = n;
            this.vxSet = true;
        }
    }

    private final int getVx() {
        return this.vx;
    }

    private final void setVy(int n) {
        if (n != this.vy) {
            this.vy = n;
            this.vySet = true;
        }
    }

    private final int getVy() {
        return this.vy;
    }

    public void setVWidth(int n) {
        if (n != this.vWidth) {
            this.vWidth = n;
            this.setLayoutChanged();
        }
    }

    public int getVWidth() {
        return this.vWidth;
    }

    public void setVHeight(int n) {
        if (n != this.vHeight) {
            this.vHeight = n;
            this.setLayoutChanged();
        }
    }

    public int getVHeight() {
        return this.vHeight;
    }

    public void setMargin(int n) {
        boolean bl = n != 0;
        if (bl != (this.marginTop && this.marginRight && this.marginBottom && this.marginLeft)) {
            this.marginBottom = this.marginLeft = bl;
            this.marginRight = this.marginLeft;
            this.marginTop = this.marginLeft;
            this.setLayoutChanged();
        }
    }

    public int getMargin() {
        return this.marginTop && this.marginRight && this.marginBottom && this.marginLeft ? 1 : 0;
    }

    public void setMarginTop(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl != this.marginTop) {
            this.marginTop = bl;
            this.setLayoutChanged();
        }
    }

    public int getMarginTop() {
        return this.marginTop ? 1 : 0;
    }

    public boolean useMarginTop() {
        return this.marginTop;
    }

    public void setMarginRight(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl != this.marginRight) {
            this.marginRight = bl;
            this.setLayoutChanged();
        }
    }

    public int getMarginRight() {
        return this.marginRight ? 1 : 0;
    }

    public boolean useMarginRight() {
        return this.marginRight;
    }

    public void setMarginBottom(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl != this.marginBottom) {
            this.marginBottom = bl;
            this.setLayoutChanged();
        }
    }

    public int getMarginBottom() {
        return this.marginBottom ? 1 : 0;
    }

    public boolean useMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginLeft(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl != this.marginLeft) {
            this.marginLeft = bl;
            this.setLayoutChanged();
        }
    }

    public int getMarginLeft() {
        return this.marginLeft ? 1 : 0;
    }

    public boolean useMarginLeft() {
        return this.marginLeft;
    }

    public void setBgimage(String string) {
        this.bgimageUrl = string;
        this.bgimageModified = true;
        this.isModified = true;
    }

    public String getBgimage() {
        return this.bgimageUrl;
    }

    public int setBgfill(String string) {
        if (string.length() == 0) {
            this.bgFillMode = 2;
        } else if (string.equalsIgnoreCase("none")) {
            this.bgFillMode = 0;
        } else if (string.equalsIgnoreCase("center")) {
            this.bgFillMode = 1;
        } else if (string.equalsIgnoreCase("tile")) {
            this.bgFillMode = 2;
        } else if (string.equalsIgnoreCase("scale")) {
            this.bgFillMode = 3;
        } else {
            return 11;
        }
        this.bgimageModified = true;
        this.isModified = true;
        return 0;
    }

    public String getBgfill() {
        if (this.bgFillMode == 1) {
            return "center";
        }
        if (this.bgFillMode == 2) {
            return "tile";
        }
        if (this.bgFillMode == 3) {
            return "scale";
        }
        return "none";
    }

    public int getHorzScrollOffset() {
        if (this.vWidth > this.getWidth()) {
            return this.scrollPane.getHorizontalScrollBar().getValue();
        }
        return 0;
    }

    public int getVertScrollOffset() {
        if (this.vHeight > this.getHeight()) {
            return this.scrollPane.getVerticalScrollBar().getValue();
        }
        return 0;
    }

    public void enableDragDrop() {
        this.setDragDropHandler(new AbstractControl.DefaultDragDrop());
    }

    static {
        attributeList.put(ICON_ATTR_NAME, new Integer(0));
        attributeList.put(ACCELERATOR_ATTR_NAME, new Integer(1));
        attributeList.put(BORDERSTYLE_ATTR_NAME, new Integer(2));
        attributeList.put(VX_ATTR_NAME, new Integer(3));
        attributeList.put(VY_ATTR_NAME, new Integer(4));
        attributeList.put(VWIDTH_ATTR_NAME, new Integer(5));
        attributeList.put(VHEIGHT_ATTR_NAME, new Integer(6));
        attributeList.put(MARGIN_ATTR_NAME, new Integer(7));
        attributeList.put(MARGIN_TOP_ATTR_NAME, new Integer(8));
        attributeList.put(MARGIN_RIGHT_ATTR_NAME, new Integer(9));
        attributeList.put(MARGIN_BOTTOM_ATTR_NAME, new Integer(10));
        attributeList.put(MARGIN_LEFT_ATTR_NAME, new Integer(11));
        attributeList.put(BGIMAGE_ATTR_NAME, new Integer(12));
        attributeList.put(BGFILL_ATTR_NAME, new Integer(13));
    }

    class GroupBoxScrollPane
    extends JScrollPane {
        public GroupBoxScrollPane(Component component) {
            super(component);
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
            this.setAutoscrolls(true);
            this.setBorder(null);
            this.getViewport().setOpaque(false);
            this.setOpaque(false);
        }

        public void setBorder(Border border) {
            super.setBorder(null);
        }

        protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
            boolean bl = (mouseWheelEvent.getModifiersEx() & 0x40) != 0;
            JScrollPane jScrollPane = this;
            while (bl && !jScrollPane.getHorizontalScrollBar().isVisible() || !bl && !jScrollPane.getVerticalScrollBar().isVisible()) {
                Container container;
                for (container = jScrollPane.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
                }
                if (container == null) {
                    return;
                }
                jScrollPane = (JScrollPane)container;
            }
            if (jScrollPane == this) {
                super.processMouseWheelEvent(mouseWheelEvent);
            } else {
                jScrollPane.dispatchEvent(SwingUtilities.convertMouseEvent(this, mouseWheelEvent, jScrollPane));
            }
        }
    }

    class GroupBoxPanel
    extends JPanel {
        public static final int FILL_NONE = 0;
        public static final int FILL_CENTER = 1;
        public static final int FILL_TILE = 2;
        public static final int FILL_SCALE = 3;
        int fillMode;
        Image image;

        public GroupBoxPanel() {
            super(null);
            this.fillMode = 2;
            this.image = null;
        }

        public void setImageUrl(URL uRL) {
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            if (uRL != null) {
                this.image = this.getToolkit().getImage(uRL);
            }
            if (this.isVisible()) {
                this.repaint();
            }
        }

        public void setFillMode(int n) {
            this.fillMode = n;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.repaint();
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics graphics) {
            if (this.ui != null) {
                Graphics graphics2 = graphics.create();
                try {
                    this.ui.update(graphics2, this);
                    if (this.image != null) {
                        Object object;
                        int n;
                        int n2;
                        boolean bl = false;
                        if (this.fillMode == 3) {
                            n2 = 0;
                            n = 0;
                        } else {
                            n = this.image.getWidth(this);
                            n2 = this.image.getHeight(this);
                            object = EGroupBox.this.getScaling();
                            if (((Scaling)object).x != 1.0) {
                                bl = true;
                                n = (int)Math.round((double)n * ((Scaling)object).x);
                            }
                            if (((Scaling)object).y != 1.0) {
                                bl = true;
                                n2 = (int)Math.round((double)n2 * ((Scaling)object).y);
                            }
                        }
                        GraphicsTool.setRenderingHints(graphics2);
                        if (this.fillMode == 1) {
                            object = this.getSize();
                            int n3 = n < ((Dimension)object).width ? (((Dimension)object).width - n) / 2 : 0;
                            int n4 = n2 < ((Dimension)object).height ? (((Dimension)object).height - n2) / 2 : 0;
                            if (bl) {
                                graphics2.drawImage(this.image, n3, n4, n, n2, this);
                            } else {
                                graphics2.drawImage(this.image, n3, n4, this);
                            }
                        } else if (this.fillMode == 2) {
                            object = this.getSize();
                            if (n > 0 && n2 > 0) {
                                for (int i = 0; i < ((Dimension)object).height; i += n2) {
                                    for (int j = 0; j < ((Dimension)object).width; j += n) {
                                        if (bl) {
                                            graphics2.drawImage(this.image, j, i, n, n2, this);
                                            continue;
                                        }
                                        graphics2.drawImage(this.image, j, i, this);
                                    }
                                }
                            }
                        } else if (this.fillMode == 3) {
                            object = this.getSize();
                            graphics2.drawImage(this.image, 0, 0, ((Dimension)object).width, ((Dimension)object).height, this);
                        } else if (bl) {
                            graphics2.drawImage(this.image, 0, 0, n, n2, this);
                        } else {
                            graphics2.drawImage(this.image, 0, 0, this);
                        }
                    }
                }
                finally {
                    graphics2.dispose();
                }
            }
        }
    }

    private final class ResizeTimer
    implements ActionListener {
        private ResizeTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EGroupBox.this.resizeTimer != null && EGroupBox.this.inPane && !EGroupBox.this.getDialog().willResize()) {
                EGroupBox.this.layout(null, EGroupBox.this.getLayoutGrid(), EGroupBox.this.getScaling());
            }
        }
    }

    private final class VPosTimer
    implements ActionListener {
        private VPosTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EGroupBox.this.eloq2swingVPos(null);
        }
    }
}

