/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractButtonControl;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.GraphicsTool;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RescaleOp;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JPanel;

public class EImage
extends AbstractButtonControl
implements MouseListener {
    public static final String CLASS_ATTR_NAME = "Image";
    public static final String URL_ATTR_NAME = "url";
    private String url = "";
    private String urlExpanded = "";
    private boolean urlModified = false;
    private boolean sizeOrScaleModified = false;
    public static final String SW_ATTR_NAME = "sw";
    public static final String SH_ATTR_NAME = "sh";
    public static final String SCALE_ATTR_NAME = "scale";
    private static final int URL_ATTR_ID = 0;
    private static final int SH_ATTR_ID = 1;
    private static final int SW_ATTR_ID = 2;
    private static final int SCALE_ATTR_ID = 3;
    private static HashMap attributeList = new HashMap();

    public EImage() {
        ImageCanvas imageCanvas = new ImageCanvas();
        imageCanvas.setOpaque(false);
        imageCanvas.scale = StartUp.getImageScale();
        this.peer = imageCanvas;
        this.ruleOverride = true;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.peer.removeMouseListener(this);
            super.dispose();
            this.url = null;
            this.urlExpanded = null;
        }
    }

    public Object clone() {
        EImage eImage = new EImage();
        this.cloneAttributes(eImage);
        return eImage;
    }

    public void cloneAttributes(EImage eImage) {
        super.cloneAttributes(eImage);
        eImage.setSh(this.getSh());
        eImage.setSw(this.getSw());
        eImage.setImgScale(this.getImgScale());
        eImage.setUrl(this.getUrl());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setUrl(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setSh(sET.getValueInt());
                    break;
                }
                case 2: {
                    this.setSw(sET.getValueInt());
                    break;
                }
                case 3: {
                    this.setImgScale(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getUrl());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getSh());
                    break;
                }
                case 2: {
                    gET2.setValueInt(this.getSw());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getImgScale());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        ImageCanvas imageCanvas = (ImageCanvas)this.peer;
        if (this.urlModified || !imageCanvas.getUrl().equals(this.urlExpanded)) {
            imageCanvas.setUrl(this.urlExpanded);
        } else if (this.sizeOrScaleModified) {
            imageCanvas.resetImage();
        }
        this.urlModified = false;
        this.sizeOrScaleModified = false;
        super.eloq2swing(bl);
        imageCanvas.revalidate();
        this.peer.repaint(0L);
    }

    private final Image getDarkerImage() {
        ImageCanvas imageCanvas = (ImageCanvas)this.peer;
        if (imageCanvas.image == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(imageCanvas.image.getWidth(null), imageCanvas.image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GraphicsTool.setRenderingHints(graphics2D);
        graphics2D.drawImage(imageCanvas.image, 0, 0, null);
        graphics2D.dispose();
        return new RescaleOp(0.75f, 0.0f, null).filter(bufferedImage, null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Image image;
        boolean bl;
        if (this.processRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        boolean bl2 = bl = this.rule > 0 && this.getSensitive() != 0;
        if (bl && this.parent != null && (image = this.getDarkerImage()) != null) {
            ImageCanvas imageCanvas = (ImageCanvas)this.peer;
            PaintingStrategy paintingStrategy = this.createPaintingStrategy(imageCanvas.sw, imageCanvas.sh, image, imageCanvas);
            paintingStrategy.paintImage(imageCanvas.getGraphics());
            paintingStrategy.dispose();
        }
        super.mousePressed(mouseEvent);
        if (bl && this.ruleOverride) {
            this.getRuleManager().forceOverride();
        } else {
            this.getRuleManager().cancelOverride();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ImageCanvas imageCanvas;
        boolean bl;
        if (this.consumeRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        boolean bl2 = bl = this.rule > 0 && this.getSensitive() != 0;
        if (bl && this.parent != null && (imageCanvas = (ImageCanvas)this.peer).image != null) {
            PaintingStrategy paintingStrategy = this.createPaintingStrategy(imageCanvas.sw, imageCanvas.sh, imageCanvas.image, imageCanvas);
            paintingStrategy.paintImage(imageCanvas.getGraphics());
            paintingStrategy.dispose();
        }
        super.mouseReleased(mouseEvent);
        if (bl && this.inButton) {
            this.getRuleManager().fireRule(this);
        }
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setUrl(String string) {
        this.url = string;
        this.urlExpanded = this.expandBaseUrl(string);
        this.isModified = true;
        this.urlModified = true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setSw(int n) {
        ((ImageCanvas)this.peer).sw = n;
        this.isModified = true;
        this.sizeOrScaleModified = true;
    }

    public int getSw() {
        return ((ImageCanvas)this.peer).sw;
    }

    public void setSh(int n) {
        ((ImageCanvas)this.peer).sh = n;
        this.isModified = true;
        this.sizeOrScaleModified = true;
    }

    public int getSh() {
        return ((ImageCanvas)this.peer).sh;
    }

    public void setImgScale(int n) {
        ((ImageCanvas)this.peer).scale = n != 0;
        this.isModified = true;
        this.sizeOrScaleModified = true;
    }

    public int getImgScale() {
        return ((ImageCanvas)this.peer).scale ? 1 : 0;
    }

    public void setWidth(int n) {
        super.setWidth(n);
        this.sizeOrScaleModified = true;
    }

    public void setHeight(int n) {
        super.setHeight(n);
        this.sizeOrScaleModified = true;
    }

    private final PaintingStrategy createPaintingStrategy(int n, int n2, Image image, Component component) {
        if (n == 0 && n2 == 0) {
            return new PaintingCenterStrategy(n, n2, image, component);
        }
        if (n == -1 && n2 == -1) {
            return new PaintingFittingStrategy(n, n2, image, component);
        }
        if (n == -2 && n2 == -2) {
            return new PaintingCenteredScaledInAspectRatioStrategy(n, n2, image, component);
        }
        if (n > 0 && n2 > 0) {
            return new PaintingUserSizeStrategy(n, n2, image, component);
        }
        return new PaintingStrategy(n, n2, image, component);
    }

    static {
        attributeList.put(URL_ATTR_NAME, new Integer(0));
        attributeList.put(SH_ATTR_NAME, new Integer(1));
        attributeList.put(SW_ATTR_NAME, new Integer(2));
        attributeList.put(SCALE_ATTR_NAME, new Integer(3));
    }

    class PaintingUserSizeStrategy
    extends PaintingStrategy {
        private Dimension size;

        public PaintingUserSizeStrategy(int n, int n2, Image image, Component component) {
            super(n, n2, image, component);
            this.size = null;
        }

        public Dimension scaledSize() {
            int n;
            int n2 = 2 * this.border;
            int n3 = this.sw > n2 ? this.sw - n2 : this.sw;
            int n4 = n = this.sh > n2 ? this.sh - n2 : this.sh;
            if (this.size == null) {
                this.size = new Dimension(n3, n);
            } else {
                this.size.width = n3;
                this.size.height = n;
            }
            return this.size;
        }

        public void paintImage(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = 2 * this.border;
            if (this.sw > n5) {
                n4 = this.border;
                n3 = this.sw - n5;
            } else {
                n4 = 0;
                n3 = this.sw;
            }
            if (this.sh > n5) {
                n2 = this.border;
                n = this.sh - n5;
            } else {
                n2 = 0;
                n = this.sh;
            }
            GraphicsTool.setRenderingHints(graphics);
            graphics.drawImage(this.image, n4, n2, n3, n, this.observer);
        }

        public void dispose() {
            this.size = null;
            super.dispose();
        }
    }

    class PaintingCenteredScaledInAspectRatioStrategy
    extends PaintingStrategy {
        private Dimension size;
        private Rectangle bounds;

        public PaintingCenteredScaledInAspectRatioStrategy(int n, int n2, Image image, Component component) {
            super(n, n2, image, component);
            this.size = null;
            this.bounds = null;
        }

        public Dimension scaledSize() {
            Rectangle rectangle = this.calculateBounds();
            if (this.size == null) {
                this.size = new Dimension(rectangle.width, rectangle.height);
            } else {
                this.size.width = rectangle.width;
                this.size.height = rectangle.height;
            }
            return this.size;
        }

        public void paintImage(Graphics graphics) {
            Rectangle rectangle = this.calculateBounds();
            GraphicsTool.setRenderingHints(graphics);
            graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.observer);
        }

        private final Rectangle calculateBounds() {
            int n;
            int n2;
            int n3;
            int n4;
            Scaling scaling = EImage.this.getScaling();
            int n5 = this.image.getWidth(this.observer);
            int n6 = this.image.getHeight(this.observer);
            if (scaling.x != 1.0) {
                n5 = (int)Math.round((double)n5 * scaling.x);
            }
            if (scaling.y != 1.0) {
                n6 = (int)Math.round((double)n6 * scaling.y);
            }
            if (n5 <= 0 || n6 <= 0) {
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
            } else {
                Dimension dimension = this.observer.getSize();
                int n7 = 2 * this.border;
                n3 = dimension.width - n7;
                int n8 = n3 - n5;
                n4 = dimension.height - n7;
                int n9 = n4 - n6;
                if (n8 <= n9) {
                    n4 = (int)Math.round((double)(n3 * n6) / (double)n5);
                    if (n4 < 1) {
                        n4 = 1;
                    }
                } else {
                    n3 = (int)Math.round((double)(n4 * n5) / (double)n6);
                    if (n3 < 1) {
                        n3 = 1;
                    }
                }
                n = dimension.width > n3 ? (dimension.width - n3) / 2 : 0;
                n2 = dimension.height > n4 ? (dimension.height - n4) / 2 : 0;
            }
            if (this.bounds == null) {
                this.bounds = new Rectangle(n, n2, n3, n4);
            } else {
                this.bounds.x = n;
                this.bounds.y = n2;
                this.bounds.width = n3;
                this.bounds.height = n4;
            }
            return this.bounds;
        }

        public void dispose() {
            this.size = null;
            this.bounds = null;
            super.dispose();
        }
    }

    class PaintingFittingStrategy
    extends PaintingStrategy {
        private Dimension size;

        public PaintingFittingStrategy(int n, int n2, Image image, Component component) {
            super(n, n2, image, component);
            this.size = null;
        }

        public Dimension scaledSize() {
            int n;
            Dimension dimension = this.observer.getSize();
            int n2 = 2 * this.border;
            int n3 = dimension.width > n2 ? dimension.width - n2 : dimension.width;
            int n4 = n = dimension.height > n2 ? dimension.height - n2 : dimension.height;
            if (this.size == null) {
                this.size = new Dimension(n3, n);
            } else {
                this.size.width = n3;
                this.size.height = n;
            }
            return this.size;
        }

        public void paintImage(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            Dimension dimension = this.observer.getSize();
            int n5 = 2 * this.border;
            if (dimension.width > n5) {
                n4 = this.border;
                n3 = dimension.width - n5;
            } else {
                n4 = 0;
                n3 = dimension.width;
            }
            if (dimension.height > n5) {
                n2 = this.border;
                n = dimension.height - n5;
            } else {
                n2 = 0;
                n = dimension.height;
            }
            GraphicsTool.setRenderingHints(graphics);
            graphics.drawImage(this.image, n4, n2, n3, n, this.observer);
        }

        public void dispose() {
            this.size = null;
            super.dispose();
        }
    }

    class PaintingCenterStrategy
    extends PaintingStrategy {
        public PaintingCenterStrategy(int n, int n2, Image image, Component component) {
            super(n, n2, image, component);
        }

        public void paintImage(Graphics graphics) {
            Scaling scaling = EImage.this.getScaling();
            int n = this.image.getWidth(this.observer);
            int n2 = this.image.getHeight(this.observer);
            boolean bl = false;
            if (scaling.x != 1.0) {
                n = (int)Math.round((double)n * scaling.x);
                bl = true;
            }
            if (scaling.y != 1.0) {
                n2 = (int)Math.round((double)n2 * scaling.y);
                bl = true;
            }
            Dimension dimension = this.observer.getSize();
            int n3 = dimension.width > n ? (dimension.width - n) / 2 : 0;
            int n4 = dimension.height > n2 ? (dimension.height - n2) / 2 : 0;
            GraphicsTool.setRenderingHints(graphics);
            if (bl) {
                graphics.drawImage(this.image, n3, n4, n, n2, this.observer);
            } else {
                graphics.drawImage(this.image, n3, n4, this.observer);
            }
        }
    }

    class PaintingStrategy {
        protected int sw = 0;
        protected int sh = 0;
        protected int border = 2;
        protected Image image = null;
        protected Component observer = null;

        public PaintingStrategy(int n, int n2, Image image, Component component) {
            this.sw = n;
            this.sh = n2;
            this.image = image;
            this.observer = component;
        }

        public Dimension scaledSize() {
            return null;
        }

        public void paintImage(Graphics graphics) {
            boolean bl;
            int n;
            int n2;
            Scaling scaling = EImage.this.getScaling();
            if (scaling.x != 1.0) {
                n2 = (int)Math.round((double)this.image.getWidth(this.observer) * scaling.x);
                n = scaling.y != 1.0 ? (int)Math.round((double)this.image.getHeight(this.observer) * scaling.y) : this.image.getHeight(this.observer);
                bl = true;
            } else if (scaling.y != 1.0) {
                n = (int)Math.round((double)this.image.getHeight(this.observer) * scaling.y);
                n2 = scaling.x != 1.0 ? (int)Math.round((double)this.image.getWidth(this.observer) * scaling.x) : this.image.getWidth(this.observer);
                bl = true;
            } else {
                n2 = this.image.getWidth(this.observer);
                n = this.image.getHeight(this.observer);
                bl = false;
            }
            Dimension dimension = this.observer.getSize();
            int n3 = dimension.width > n2 ? (dimension.width - n2) / 2 : 0;
            int n4 = dimension.height > n ? (dimension.height - n) / 2 : 0;
            GraphicsTool.setRenderingHints(graphics);
            if (bl) {
                graphics.drawImage(this.image, n3, n4, n2, n, this.observer);
            } else {
                graphics.drawImage(this.image, n3, n4, this.observer);
            }
        }

        protected void finalize() throws Throwable {
            this.dispose();
        }

        public void dispose() {
            this.image = null;
            this.observer = null;
        }
    }

    class ImageCanvas
    extends JPanel
    implements ImageObserver {
        private String url = "";
        private Image image = null;
        private int sw = 0;
        private int sh = 0;
        private boolean scale = false;
        private static final int LOADING = 1;
        private static final int LOADED = 2;
        private static final int SCALING = 3;
        private static final int SCALED = 4;
        private int loadState = 0;

        public ImageCanvas() {
        }

        public ImageCanvas(String string) {
            this.url = string;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.updateImage()) {
                PaintingStrategy paintingStrategy = EImage.this.createPaintingStrategy(this.sw, this.sh, this.image, this);
                paintingStrategy.paintImage(graphics);
                paintingStrategy.dispose();
            }
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public void setUrl(String string) {
            this.resetImage();
            this.url = string;
            this.repaint(0L);
        }

        public String getUrl() {
            return this.url;
        }

        public void resetImage() {
            this.loadState = 0;
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
        }

        private boolean loadImage(Image image) {
            boolean bl = true;
            if (image.getWidth(this) == -1) {
                bl = false;
            }
            if (image.getHeight(this) == -1) {
                bl = false;
            }
            return bl;
        }

        private boolean updateImage() {
            Object object;
            Object object2;
            if (this.image == null && this.loadState == 0 && this.url != null && this.url.length() > 0) {
                try {
                    object2 = new URL(this.url);
                    if (object2 != null && (object = Toolkit.getDefaultToolkit().getImage((URL)object2)) != null) {
                        this.loadState = 1;
                        if (this.loadImage((Image)object)) {
                            this.image = object;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.image != null && this.loadState == 1) {
                this.loadState = 2;
                if (this.imageIsScaled()) {
                    Image image;
                    object2 = EImage.this.createPaintingStrategy(this.sw, this.sh, this.image, this);
                    object = ((PaintingStrategy)object2).scaledSize();
                    ((PaintingStrategy)object2).dispose();
                    if ((((Dimension)object).width < this.image.getWidth(this) || ((Dimension)object).height < this.image.getHeight(this)) && (image = this.image.getScaledInstance(((Dimension)object).width, ((Dimension)object).height, 1)) != null) {
                        this.loadState = 3;
                        if (this.loadImage(image)) {
                            this.loadState = 4;
                        }
                    }
                }
            }
            return this.image != null;
        }

        boolean imageIsScaled() {
            if (this.scale) {
                if (this.sw == -1 && this.sh == -1) {
                    return true;
                }
                if (this.sw == -2 && this.sh == -2) {
                    return true;
                }
                if (this.sw > 0 && this.sh > 0) {
                    return true;
                }
            }
            return false;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            int n6 = 3;
            if ((n & n6) == n6) {
                if (this.image == null) {
                    if (this.loadState == 1) {
                        this.image = image;
                        this.repaint(0L);
                    }
                } else if (image != this.image && this.loadState == 3) {
                    this.resetImage();
                    this.image = image;
                    this.loadState = 4;
                }
            }
            if ((n & (n6 = 32)) == n6 && (this.loadState == 2 || this.loadState == 4)) {
                this.repaint(0L);
                return false;
            }
            n6 = 128;
            if ((n & n6) == n6 && image == this.image && this.loadState == 2) {
                this.repaint(0L);
            }
            return true;
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EImage.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }

        protected void finalize() throws Throwable {
            this.dispose();
        }

        public void dispose() {
            this.resetImage();
            this.url = null;
        }
    }
}

