/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EJScrollPaneListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.UIResource;

public class EJScrollPane
extends JScrollPane {
    private EScrollBar hsb = null;
    private EScrollBar vsb = null;
    private AbstractControl control = null;
    public int fixedWidth = 0;
    public int fixedHeight = 0;

    public EJScrollPane(Component component) {
        super(component);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.hsb = new EScrollBar(0);
        this.setHorizontalScrollBar(this.hsb);
        this.vsb = new EScrollBar(1);
        this.setVerticalScrollBar(this.vsb);
        this.updateUI();
    }

    public EJScrollPane(Component component, AbstractControl abstractControl) {
        this(component);
        this.setControl(abstractControl);
    }

    protected void finalize() throws Throwable {
        this.hsb = null;
        this.vsb = null;
        super.finalize();
    }

    void setControl(AbstractControl abstractControl) {
        if (abstractControl != this.control) {
            if (this.control instanceof EJScrollPaneListener) {
                this.hsb.resetListener();
                this.vsb.resetListener();
            }
            if (abstractControl != null) {
                this.control = abstractControl;
                if (this.control instanceof EJScrollPaneListener) {
                    this.hsb.setListener((EJScrollPaneListener)((Object)this.control));
                    this.vsb.setListener((EJScrollPaneListener)((Object)this.control));
                }
            } else {
                this.removeAll();
                this.control = null;
            }
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (this.control == null || !this.control.ignoreEvent(aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }

    private class EScrollBar
    extends JScrollBar
    implements ComponentListener,
    UIResource {
        private EJScrollPaneListener listener;
        private boolean unitIncrementSet;
        private boolean blockIncrementSet;

        public EScrollBar(int n) {
            super(n);
            this.listener = null;
            this.unitIncrementSet = false;
            this.blockIncrementSet = false;
        }

        protected void finalize() throws Throwable {
            this.listener = null;
            super.finalize();
        }

        public void setListener(EJScrollPaneListener eJScrollPaneListener) {
            this.listener = eJScrollPaneListener;
            this.addComponentListener(this);
        }

        public void resetListener() {
            this.removeComponentListener(this);
            this.listener = null;
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (EJScrollPane.this.control == null || !EJScrollPane.this.control.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }

        public void setUnitIncrement(int n) {
            this.unitIncrementSet = true;
            super.setUnitIncrement(n);
        }

        public int getUnitIncrement(int n) {
            Component component;
            JViewport jViewport = EJScrollPane.this.getViewport();
            if (!this.unitIncrementSet && jViewport != null && (component = jViewport.getView()) instanceof Scrollable) {
                return ((Scrollable)((Object)component)).getScrollableUnitIncrement(jViewport.getViewRect(), this.getOrientation(), n);
            }
            return super.getUnitIncrement(n);
        }

        public void setBlockIncrement(int n) {
            this.blockIncrementSet = true;
            super.setBlockIncrement(n);
        }

        public int getBlockIncrement(int n) {
            JViewport jViewport = EJScrollPane.this.getViewport();
            if (this.blockIncrementSet || jViewport == null) {
                return super.getBlockIncrement(n);
            }
            Component component = jViewport.getView();
            if (component instanceof Scrollable) {
                return ((Scrollable)((Object)component)).getScrollableBlockIncrement(jViewport.getViewRect(), this.getOrientation(), n);
            }
            if (this.getOrientation() == 1) {
                return jViewport.getExtentSize().height;
            }
            return jViewport.getExtentSize().width;
        }

        public final void componentShown(ComponentEvent componentEvent) {
            if (this.listener != null) {
                if (this.getOrientation() == 1) {
                    this.listener.verticalScrollBarVisible(this, true);
                } else {
                    this.listener.horizontalScrollBarVisible(this, true);
                }
            }
        }

        public final void componentHidden(ComponentEvent componentEvent) {
            if (this.listener != null) {
                if (this.getOrientation() == 1) {
                    this.listener.verticalScrollBarVisible(this, false);
                } else {
                    this.listener.horizontalScrollBarVisible(this, false);
                }
            }
        }

        public final void componentMoved(ComponentEvent componentEvent) {
        }

        public final void componentResized(ComponentEvent componentEvent) {
        }
    }
}

