/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.DragDropHandler;
import com.eloquence.api.UnifiedData;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.ETableHeader;
import com.eloquence.services.jdlg.controls.ScrollablePopupMenu;
import com.eloquence.services.jdlg.controls.TableSorter;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.HexTool;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.SafeRunnable;
import com.eloquence.services.tools.Scaling;
import com.eloquence.services.tools.UiUtil;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EListBox
extends AbstractControlContainer
implements KeyListener,
ActionListener,
ControlsManager.RuleOverride {
    private JTableHeader defaultHeader = null;
    private int releases = 0;
    private JMenuItem[] popupItems = null;
    private MouseListener popupListener;
    private boolean structChanged = false;
    private int nextViewSortKey = 0;
    protected ScrollablePopupMenu popup = null;
    protected JScrollPane sp = null;
    public TableSorter tsorter = null;
    public ChangeNotifier cn = null;
    public EJTableModel tmodel = null;
    public EJTable table = null;
    private static final String ACTIVEITEM_ATTR_NAME = "activeitem";
    private boolean activeItemCached = false;
    private static final String ACTIVELINE_ATTR_NAME = "activeline";
    protected int activeLine = 0;
    private boolean activeLineCached = false;
    private static final String ADD_ATTR_NAME = "add";
    private static final String BORDER_ATTR_NAME = "border";
    private int border = 1;
    public static final String CLASS_ATTR_NAME = "ListBox";
    private static final String CLEAR_ATTR_NAME = "clear";
    private static final String CONTENT_ATTR_NAME = "content";
    private static final String LINE_BUF_ATTR_NAME = "line_buf";
    private static final String CX_ATTR_NAME = "cx";
    private static final String CY_ATTR_NAME = "cy";
    private int cy = 0;
    private boolean cyCached = false;
    private boolean cyModified = true;
    private boolean cySet = false;
    private static final String DELIM_ATTR_NAME = "delim";
    private String delimiter = "\t";
    private static final String DELLN_ATTR_NAME = "delln";
    private static final String GRIDCOLOR_ATTR_NAME = "gridcolor";
    protected Color gridCol = Color.BLACK;
    private static final String HLINES_ATTR_NAME = "hlines";
    protected boolean gridHor = false;
    private static final String HSB_ATTR_NAME = "hsb";
    private static final String INS_ATTR_NAME = "ins";
    private static final String LENGTH_ATTR_NAME = "length";
    private static final String LINE_ATTR_NAME = "line";
    private static final String MULTILINE_ATTR_NAME = "multiline";
    protected boolean multiline = true;
    private static final String RULEOVERRIDE_ATTR_NAME = "ruleoverride";
    protected boolean ruleOverride = false;
    private static final String SINGLECLICK_ATTR_NAME = "singleclick";
    protected int singleclick = 0;
    private static final String TOPITEM_ATTR_NAME = "topitem";
    int topItem = -1;
    boolean topItemModified = false;
    boolean topItemCached = false;
    private static final String VHEIGHT_ATTR_NAME = "vheight";
    private static final String VLINES_ATTR_NAME = "vlines";
    protected boolean gridVer = false;
    private static final String VSB_ATTR_NAME = "vsb";
    private static final String VWIDTH_ATTR_NAME = "vwidth";
    private static final String COLUMN_ATTR_NAME = "column";
    private static final String VCOLUMN_ATTR_NAME = "vcolumn";
    private static final String COLUMNS_ATTR_NAME = "columns";
    private static final String VCOLUMNS_ATTR_NAME = "vcolumns";
    private static final String VLINE_ATTR_NAME = "vline";
    private static final String VCONTENT_ATTR_NAME = "vcontent";
    private static final String VLINE_BUF_ATTR_NAME = "vline_buf";
    private static final String MOVABLE_ATTR_NAME = "movable";
    private boolean movable = true;
    private static final String SIZABLE_ATTR_NAME = "sizable";
    private boolean sizable = true;
    private static final String NEWLINE_ATTR_NAME = "newline";
    public boolean newline = false;
    private static final String RESETORDER_ATTR_NAME = "resetorder";
    private static final String COLUMNORDER_ATTR_NAME = "columnorder";
    private int setColumnOrder_rc;
    private static final String SORTSEQUENCE_ATTR_NAME = "sortsequence";
    private int setSortSequence_rc;
    private static final String STATUS_ATTR_NAME = "status";
    private int setStatus_rc;
    private static final String ROWHEIGHT_ATTR_NAME = "rowheight";
    private int rowHeight = 0;
    private boolean rowHeightModified = false;
    private static final String SPACING_ATTR_NAME = "spacing";
    private static final String BGCOLOR2_ATTR_NAME = "bgcolor2";
    protected Color bgColor2 = null;
    private static final String FGCOLOR2_ATTR_NAME = "fgcolor2";
    protected Color fgColor2 = null;
    private static final String VACTIVELINE_ATTR_NAME = "vactiveline";
    private static final String VIEWORDER_ATTR_NAME = "vieworder";
    private static final String ROWDATA_ATTR_NAME = "rowdata";
    private static final String ROWDATA_BUF_ATTR_NAME = "rowdata_buf";
    private static final String MODELORDER_ATTR_NAME = "modelorder";
    private static final String ACTIVECOLUMN_ATTR_NAME = "activecolumn";
    private int activeColumn = -1;
    private static final String COLCONTEXTMENU_ATTR_NAME = "colcontextmenu";
    boolean colContextMenu = true;
    private static final String COLMARGIN_ATTR_NAME = "colmargin";
    private int colMargin = 0;
    private int cellMargin = 0;
    private static final String VC_RULE_ATTR_NAME = "vcrule";
    private static final String SORTRULE_ATTR_NAME = "sortrule";
    private int vcRule = 0;
    private boolean vcRuleFired = false;
    private static final String RULEKEY_ATTR_NAME = "rulekey";
    private int ruleKey = 0;
    private boolean ruleKeyCached = false;
    private static final String DROP_MODE_ATTR_NAME = "dropmode";
    private static final String DROP_LINE_ATTR_NAME = "dropline";
    private static final String DROP_COLUMN_ATTR_NAME = "dropcolumn";
    private boolean acceptValidDropOnly = false;
    private int dropLine = 0;
    private int dropColumn = -1;
    private boolean inDrag = false;
    private int dragSaveSelectedRow = 0;
    private static final int rowPadding = 0;
    private static Defaults defaults = new Defaults();
    private static final int ACTIVEITEM_ATTR_ID = 0;
    private static final int ACTIVELINE_ATTR_ID = 1;
    private static final int ADD_ATTR_ID = 2;
    private static final int BORDER_ATTR_ID = 3;
    private static final int CLEAR_ATTR_ID = 4;
    private static final int COLUMN_ATTR_ID = 5;
    private static final int COLUMNORDER_ATTR_ID = 6;
    private static final int COLUMNS_ATTR_ID = 7;
    private static final int CONTENT_ATTR_ID = 8;
    private static final int CX_ATTR_ID = 9;
    private static final int CY_ATTR_ID = 10;
    private static final int DELIM_ATTR_ID = 11;
    private static final int DELLN_ATTR_ID = 12;
    private static final int GRIDCOLOR_ATTR_ID = 13;
    private static final int HLINES_ATTR_ID = 14;
    private static final int HSB_ATTR_ID = 15;
    private static final int INS_ATTR_ID = 16;
    private static final int LENGTH_ATTR_ID = 17;
    private static final int MULTILINE_ATTR_ID = 18;
    private static final int MODELORDER_ATTR_ID = 19;
    private static final int MOVABLE_ATTR_ID = 20;
    private static final int NEWLINE_ATTR_ID = 21;
    private static final int RESETORDER_ATTR_ID = 22;
    private static final int RULEOVERRIDE_ATTR_ID = 23;
    private static final int SINGLECLICK_ATTR_ID = 24;
    private static final int SIZABLE_ATTR_ID = 25;
    private static final int SORTSEQUENCE_ATTR_ID = 26;
    private static final int STATUS_ATTR_ID = 27;
    private static final int TOPITEM_ATTR_ID = 28;
    private static final int VCOLUMN_ATTR_ID = 29;
    private static final int VCOLUMNS_ATTR_ID = 30;
    private static final int VCONTENT_ATTR_ID = 31;
    private static final int VHEIGHT_ATTR_ID = 32;
    private static final int VIEWORDER_ATTR_ID = 33;
    private static final int VLINE_ATTR_ID = 34;
    private static final int VLINES_ATTR_ID = 35;
    private static final int VSB_ATTR_ID = 36;
    private static final int VWIDTH_ATTR_ID = 37;
    private static final int ROWHEIGHT_ATTR_ID = 38;
    private static final int SPACING_ATTR_ID = 39;
    private static final int BGCOLOR2_ATTR_ID = 40;
    private static final int FGCOLOR2_ATTR_ID = 41;
    private static final int VACTIVELINE_ATTR_ID = 42;
    private static final int ROWDATA_ATTR_ID = 43;
    private static final int ROWDATA_BUF_ATTR_ID = 44;
    private static final int TOOLHELP_ATTR_ID = 45;
    private static final int ACTIVECOLUMN_ATTR_ID = 46;
    private static final int LINE_ATTR_ID = 47;
    private static final int COLCONTEXTMENU_ATTR_ID = 48;
    private static final int COLMARGIN_ATTR_ID = 49;
    private static final int DROP_MODE_ATTR_ID = 50;
    private static final int DROP_LINE_ATTR_ID = 51;
    private static final int DROP_COLUMN_ATTR_ID = 52;
    private static final int VC_RULE_ATTR_ID = 53;
    private static final int RULEKEY_ATTR_ID = 54;
    private static HashMap attributeList = new HashMap();

    public EListBox() {
        this.setBgc(0xFFFFFF);
        this.cn = new ChangeNotifier();
        this.tmodel = new EJTableModel();
        this.tsorter = new TableSorter(this.tmodel);
        this.table = new EJTable(this.tsorter);
        this.defaultHeader = new TooltipHeader(this.table.getColumnModel());
        this.defaultHeader.setTable(this.table);
        this.table.setTableHeader(null);
        this.table.setVisible(true);
        this.table.addKeyListener(this);
        this.table.setDefaultRenderer(String.class, this.tmodel);
        this.table.setFocusTraversalKeysEnabled(false);
        this.sp = new JScrollPane(this.table);
        this.sp.setFocusable(true);
        this.sp.setAutoscrolls(true);
        this.peer = this.table;
        this.createPopupMenu();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.popup.removeAll();
            this.popup = null;
            this.popupListener = null;
            if (this.popupItems != null) {
                for (int i = 0; i < this.popupItems.length; ++i) {
                    this.popupItems[i] = null;
                }
                this.popupItems = null;
            }
            this.tmodel.dispose();
            this.tmodel = null;
            this.cn = null;
            this.tsorter = null;
            this.sp = null;
            this.defaultHeader = null;
            this.delimiter = null;
            this.gridCol = null;
            this.bgColor2 = null;
            this.fgColor2 = null;
            this.table.removeMouseListener(this);
            this.table.removeKeyListener(this);
            this.table.setModel(new DefaultTableModel());
            this.table = null;
            super.dispose();
        }
    }

    public Object clone() {
        EListBox eListBox = new EListBox();
        this.cloneAttributes(eListBox);
        return eListBox;
    }

    public void eloq2swing(boolean bl) {
        ETableHeader eTableHeader;
        ListIterator listIterator;
        JTableHeader jTableHeader = this.table.getTableHeader();
        if (this.structChanged) {
            this.tmodel.fireTableStructureChanged();
            this.structChanged = false;
            if (jTableHeader != null) {
                Scaling scaling = this.getScaling();
                listIterator = this.children.listIterator();
                while (listIterator.hasNext()) {
                    eTableHeader = (ETableHeader)listIterator.next();
                    eTableHeader.layoutWidth(this, scaling);
                }
            }
        }
        if (jTableHeader != null) {
            boolean bl2 = this.getSensitive() != 0;
            jTableHeader.setReorderingAllowed(this.movable && bl2);
            jTableHeader.setResizingAllowed(this.sizable && bl2);
        }
        this.setTitlesAndWidths();
        super.eloq2swing(bl);
        this.table.setBackground(new Color(this.getBgc()));
        this.sp.getViewport().setBackground(new Color(this.getBgc()));
        this.sp.setVisible(this.visible);
        this.table.setShowHorizontalLines(this.gridHor);
        this.table.setShowVerticalLines(this.gridVer);
        this.table.setIntercellSpacing(new Dimension(this.getVlines(), this.getHlines()));
        this.table.setGridColor(new Color(this.getGridColor()));
        if (this.rowHeightModified) {
            this.rowHeightModified = false;
            this.table.setRowHeight(this.effectiveRowHeight());
        }
        this.cn.commit();
        int n = 0;
        listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            eTableHeader = (ETableHeader)listIterator.next();
            if (eTableHeader.visible) {
                this.showColumn(eTableHeader);
            } else {
                int n2 = this.table.convertColumnIndexToView(n);
                if (n2 >= 0) {
                    this.hideColumn(eTableHeader, n2);
                }
            }
            ++n;
        }
        this.cySet = false;
        if (this.cyModified) {
            this.table.clearSelection();
            if (this.cy >= 0 && this.activeLine > 0) {
                this.tmodel.setSelectedRow(this.tsorter.viewIndex(this.cy));
            }
            this.cyModified = false;
        }
        if (this.topItemModified) {
            if (this.topItem >= 0 && this.topItem < this.table.getRowCount()) {
                this.sp.getViewport().setViewPosition(this.table.getCellRect(this.tsorter.viewIndex(this.topItem), 0, true).getLocation());
            }
            this.topItemModified = false;
        }
        if (n == 0 && this.peer.isShowing()) {
            this.setSingleColumnWidth(this.sp.getSize());
        }
        this.activeColumn = -1;
        if (bl) {
            this.dropLine = 0;
            this.dropColumn = -1;
            this.ruleKey = 0;
        }
    }

    protected void eloq2swingToolhelp() {
        if (this.toolhelp.length() != 0) {
            if (!this.toolhelp.equals(this.table.getToolTipText())) {
                this.table.setToolTipText(this.toolhelp);
            }
        } else if (this.tmodel.tableToolTipText != null) {
            this.table.setToolTipText("");
        } else {
            this.table.setToolTipText(null);
        }
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        super.swing2eloq(dO);
        if (this.peer.isShowing()) {
            int n = this.inDrag ? this.dragSaveSelectedRow : this.table.getSelectedRow();
            if (n >= 0) {
                this.cy = this.tsorter.modelIndex(n);
                this.activeLine = this.cy + 1;
            } else {
                this.activeLine = 0;
            }
            if (dO != null) {
                if (this.cyCached) {
                    dO.cache((AbstractControl)this, CY_ATTR_NAME, 4, this.cy);
                }
                if (this.activeLineCached) {
                    dO.cache((AbstractControl)this, ACTIVELINE_ATTR_NAME, 4, this.activeLine);
                }
                if (this.activeItemCached) {
                    dO.cache((AbstractControl)this, ACTIVEITEM_ATTR_NAME, 4, this.cy + 1);
                }
                if (this.topItemCached) {
                    dO.cache((AbstractControl)this, TOPITEM_ATTR_NAME, 4, this.topItem);
                }
                if (this.ruleKeyCached) {
                    dO.cache((AbstractControl)this, RULEKEY_ATTR_NAME, 0, this.ruleKey);
                }
            }
        } else if (dO != null) {
            if (this.cyCached) {
                dO.uncache(this, CY_ATTR_NAME);
                this.cyCached = false;
            }
            if (this.activeLineCached) {
                dO.uncache(this, ACTIVELINE_ATTR_NAME);
                this.activeLineCached = false;
            }
            if (this.activeItemCached) {
                dO.uncache(this, ACTIVEITEM_ATTR_NAME);
                this.activeItemCached = false;
            }
            if (this.topItemCached) {
                dO.uncache(this, TOPITEM_ATTR_NAME);
                this.topItemCached = false;
            }
            if (this.ruleKeyCached) {
                dO.uncache(this, RULEKEY_ATTR_NAME);
                this.ruleKeyCached = false;
            }
        }
    }

    private void showColumn(ETableHeader eTableHeader) {
        TableColumn tableColumn = eTableHeader.getHiddenColumn();
        if (tableColumn != null) {
            TableColumn tableColumn2;
            ETableHeader eTableHeader2;
            int n;
            eTableHeader.setHiddenColumn(null);
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n2 = tableColumnModel.getColumnCount();
            for (n = 0; n < n2 && (eTableHeader2 = (ETableHeader)this.children.get((tableColumn2 = tableColumnModel.getColumn(n)).getModelIndex())) != eTableHeader; ++n) {
                if (eTableHeader.getViewSortKey() >= eTableHeader2.getViewSortKey()) continue;
                this.table.addColumn(tableColumn);
                this.table.moveColumn(n2, n);
                break;
            }
            if (n == n2) {
                this.table.addColumn(tableColumn);
            }
            eTableHeader.visible = true;
        }
    }

    private void hideColumn(ETableHeader eTableHeader, int n) {
        this.table.getTableHeader().setDraggedColumn(null);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        eTableHeader.setHiddenColumn(tableColumn);
        this.table.removeColumn(tableColumn);
        eTableHeader.visible = false;
    }

    private void adjustColumnViewSortKeys() {
        int n;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int n3 = 0;
        block0: do {
            int n4 = n3;
            for (n = 0; n < n2; ++n) {
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                ETableHeader eTableHeader = (ETableHeader)this.children.get(tableColumn.getModelIndex());
                int n5 = eTableHeader.getViewSortKey();
                if (n3 > 0) {
                    if (n5 < n3) continue;
                    eTableHeader.setViewSortKey(n4);
                    if (n5 != n3) {
                        n4 = n5;
                        continue;
                    }
                    n3 = 0;
                    continue;
                }
                if (n5 < n4) {
                    n3 = n5;
                    continue block0;
                }
                n4 = n5;
            }
        } while (n != n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.popupItems != null) {
            int n;
            Object object = actionEvent.getSource();
            for (n = 0; n < this.popupItems.length; ++n) {
                if (object != this.popupItems[n]) continue;
                ETableHeader eTableHeader = null;
                int n2 = 0;
                ListIterator listIterator = this.children.listIterator();
                while (listIterator.hasNext()) {
                    ETableHeader eTableHeader2 = (ETableHeader)listIterator.next();
                    if (eTableHeader2.userHide()) {
                        if (n == 0) {
                            eTableHeader = eTableHeader2;
                            break;
                        }
                        --n;
                    }
                    ++n2;
                }
                if (eTableHeader == null) break;
                if (eTableHeader.getHiddenColumn() == null) {
                    int n3 = this.table.convertColumnIndexToView(n2);
                    if (n3 >= 0) {
                        this.hideColumn(eTableHeader, n3);
                    }
                } else {
                    this.showColumn(eTableHeader);
                }
                this.fireVcRule(n2);
                break;
            }
            for (n = 0; n < this.popupItems.length; ++n) {
                this.popupItems[n] = null;
            }
            this.popupItems = null;
        }
    }

    public int getColumnModelID(ETableHeader eTableHeader) {
        int n = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            ETableHeader eTableHeader2 = (ETableHeader)listIterator.next();
            if (eTableHeader2 == eTableHeader) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public int getColumnViewID(ETableHeader eTableHeader) {
        return this.table.convertColumnIndexToView(this.getColumnModelID(eTableHeader));
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 224) {
            n = 38;
        } else if (n == 225) {
            n = 40;
        }
        switch (n) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                if (this.rule != 0 && (this.singleclick == 2 || this.singleclick == 3) && this.tmodel.getRowCount() > 0) {
                    this.ruleKey = n;
                    this.getRuleManager().fireRule(this);
                }
                return;
            }
            case 32: {
                if (this.rule != 0 && this.tmodel.getRowCount() > 0) {
                    this.ruleKey = n;
                    this.getRuleManager().fireRule(this);
                }
                return;
            }
            case 10: {
                if (!this.parent.checkForFunctionKey(keyEvent) && this.rule != 0 && this.tmodel.getRowCount() > 0) {
                    this.ruleKey = n;
                    this.getRuleManager().fireRule(this);
                }
                keyEvent.consume();
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.setSelectedIndexByKey(keyEvent.getKeyChar());
        super.keyTyped(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.consumeInputEvent(keyEvent) || keyEvent.isConsumed()) {
            return;
        }
        super.keyReleased(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        StartUp.Delay delay = StartUp.delay;
        if (delay.singleClick > 0) {
            long l = System.nanoTime();
            StartUp.Delay delay2 = delay;
            synchronized (delay2) {
                delay.mousePressed[1] = delay.mousePressed[0];
                delay.mousePressed[0] = l;
            }
        }
        if (this.processRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        this.releases = 0;
        if (this.consumeInputEvent(mouseEvent)) {
            return;
        }
        if (this.getSensitive() == 0) {
            return;
        }
        if (this.rule != 0) {
            this.getRuleManager().prepareOverride(this, mouseEvent);
        }
        this.getRuleManager().requestFocus(this);
        super.mousePressed(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        StartUp.Delay delay = StartUp.delay;
        if (delay.singleClick > 0) {
            long l = System.nanoTime();
            StartUp.Delay delay2 = delay;
            synchronized (delay2) {
                delay.mouseReleased[0] = delay.mouseReleased[1];
                delay.mouseReleased[1] = l;
            }
        }
        if (this.consumeRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        if (++this.releases == 1) {
            if (this.consumeInputEvent(mouseEvent)) {
                return;
            }
            if (this.getSensitive() == 0) {
                return;
            }
            int n = 0;
            if (this.table.rowAtPoint(mouseEvent.getPoint()) >= 0 && (n = this.canFireMouseRule(mouseEvent)) > 0) {
                if (n == 1) {
                    this.mouseEventSetActiveLineColumn(mouseEvent);
                    if (this.rule != 0) {
                        this.getRuleManager().fireRule(this);
                    }
                }
            } else {
                this.getRuleManager().cancelOverride();
            }
            super.mouseReleased(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        StartUp.Delay delay = StartUp.delay;
        if (delay.singleClick > 0) {
            StartUp.Delay delay2 = delay;
            synchronized (delay2) {
                long l;
                if (mouseEvent.getClickCount() > 1 && (l = (delay.mousePressed[0] - delay.mouseReleased[0]) / 1000000L) > (long)delay.singleClick) {
                    delay.singleClick = (int)l;
                }
            }
        }
        super.mouseClicked(mouseEvent);
    }

    private final void mouseEventSetActiveLineColumn(MouseEvent mouseEvent) {
        this.activeLine = this.cy + 1;
        if (this.children.size() != 0) {
            this.activeColumn = this.table.convertColumnIndexToModel(this.table.columnAtPoint(mouseEvent.getPoint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int canFireMouseRule(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if (this.singleclick == 1 || this.singleclick == 3) {
            StartUp.Delay delay = StartUp.delay;
            if (delay.singleClick > 0) {
                StartUp.Delay delay2 = delay;
                synchronized (delay2) {
                    if (n > 1) {
                        if (delay.singleClickTimer != null) {
                            delay.singleClickTimer.stop();
                            delay.singleClickTimer = null;
                        }
                        return 1;
                    }
                    if (n == 1) {
                        if (delay.singleClickTimer != null) {
                            delay.singleClickTimer.stop();
                        }
                        delay.singleClickTimer = new Timer(delay.singleClick, new SingleClickTimer());
                        delay.singleClickTimer.setRepeats(false);
                        delay.singleClickTimer.start();
                        this.mouseEventSetActiveLineColumn(mouseEvent);
                        return 2;
                    }
                    return 0;
                }
            }
            return n >= 1 ? 1 : 0;
        }
        return n >= 2 ? 1 : 0;
    }

    private void createPopupMenu() {
        this.popup = new ScrollablePopupMenu();
        this.popupListener = new PopupListener(this.popup);
    }

    private boolean setupPopupMenu() {
        int n;
        this.popup.removeAll();
        if (this.popupItems != null) {
            for (n = 0; n < this.popupItems.length; ++n) {
                this.popupItems[n] = null;
            }
            this.popupItems = null;
        }
        if (this.table.getTableHeader() != null) {
            n = 0;
            ListIterator listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                ETableHeader eTableHeader = (ETableHeader)listIterator.next();
                if (!eTableHeader.userHide()) continue;
                ++n;
            }
            if (n <= 1) {
                return false;
            }
            this.popup.setTitle("Columns");
            this.popup.setTitleFont(this.table.getTableHeader().getFont());
            int n2 = 0;
            listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                ETableHeader eTableHeader = (ETableHeader)listIterator.next();
                if (!eTableHeader.userHide() || eTableHeader.getHiddenColumn() != null) continue;
                ++n2;
            }
            this.popupItems = new JMenuItem[n];
            int n3 = 0;
            listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                ETableHeader eTableHeader = (ETableHeader)listIterator.next();
                if (!eTableHeader.userHide()) continue;
                String string = eTableHeader.getTitle();
                if (string.length() == 0) {
                    string = "Column " + (n3 + 1);
                }
                boolean bl = eTableHeader.getHiddenColumn() == null;
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, bl);
                jCheckBoxMenuItem.addActionListener(this);
                if (bl && n2 <= 1) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
                jCheckBoxMenuItem.setFont(this.table.getTableHeader().getFont());
                int n4 = n3++;
                JCheckBoxMenuItem jCheckBoxMenuItem2 = jCheckBoxMenuItem;
                this.popupItems[n4] = jCheckBoxMenuItem2;
                this.popup.add(jCheckBoxMenuItem2);
            }
            return true;
        }
        return false;
    }

    public boolean add(final Object object) {
        if (object instanceof ETableHeader) {
            ETableHeader eTableHeader = (ETableHeader)object;
            eTableHeader.setViewSortKey(++this.nextViewSortKey);
            if (!super.add(object)) {
                return false;
            }
            SafeRunnable.execute(new SafeRunnable(){

                public void runSafe() {
                    EListBox.this.tmodel.addColumn(EListBox.this.children.indexOf(object));
                    if (EListBox.this.children.size() == 1) {
                        EListBox eListBox = EListBox.this;
                        EListBox.this.table.removeMouseListener(eListBox);
                        EListBox.this.table.removeKeyListener(eListBox);
                        EListBox.this.table = new EJTable(EListBox.this.tsorter);
                        EListBox.this.defaultHeader = new TooltipHeader(EListBox.this.table.getColumnModel());
                        EListBox.this.defaultHeader.setTable(EListBox.this.table);
                        EListBox.this.table.setTableHeader(EListBox.this.defaultHeader);
                        EListBox.this.table.setVisible(true);
                        EListBox.this.table.addKeyListener(eListBox);
                        EListBox.this.table.addMouseListener(eListBox);
                        EListBox.this.table.setDefaultRenderer(String.class, EListBox.this.tmodel);
                        EListBox.this.sp.setViewportView(EListBox.this.table);
                        EListBox.this.peer = EListBox.this.table;
                        EListBox.this.tsorter.setTableHeader(EListBox.this.defaultHeader, EListBox.this.tmodel);
                        EListBox.this.defaultHeader.addMouseListener(EListBox.this.popupListener);
                    }
                }
            });
            this.structChanged = true;
            if (this.cn != null) {
                this.cn.tableStructureChanged = true;
            }
            this.isModified = true;
            return true;
        }
        return false;
    }

    public boolean remove(final Object object) {
        if (object instanceof ETableHeader) {
            if (this.children != null) {
                SafeRunnable.execute(new SafeRunnable(){

                    public void runSafe() {
                        try {
                            EListBox.this.table.getTableHeader().setDraggedColumn(null);
                            int n = EListBox.this.children.indexOf(object);
                            if (n >= 0) {
                                EListBox.this.tmodel.removeColumn(n);
                            }
                            if (EListBox.this.children.size() == 1) {
                                EListBox eListBox = EListBox.this;
                                EListBox.this.defaultHeader.removeMouseListener(EListBox.this.popupListener);
                                EListBox.this.table.removeMouseListener(eListBox);
                                EListBox.this.table.removeKeyListener(eListBox);
                                EListBox.this.table = new EJTable(EListBox.this.tsorter);
                                EListBox.this.table.setTableHeader(null);
                                EListBox.this.table.setVisible(true);
                                EListBox.this.table.addKeyListener(eListBox);
                                EListBox.this.table.addMouseListener(eListBox);
                                EListBox.this.table.setDefaultRenderer(String.class, EListBox.this.tmodel);
                                EListBox.this.sp.setViewportView(EListBox.this.table);
                                EListBox.this.peer = EListBox.this.table;
                                EListBox.this.tsorter.setTableHeader(null, EListBox.this.tmodel);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.isModified = true;
            }
            this.structChanged = true;
            if (this.cn != null) {
                this.cn.tableStructureChanged = true;
            }
        }
        return super.remove(object);
    }

    private void setActiveitem(int n) {
        this.setCy(n - 1);
    }

    private int getActiveitem() {
        return this.cy + 1;
    }

    private int setActiveline(int n) {
        if (n > this.tmodel.getRowCount()) {
            return 11;
        }
        this.activeLine = n;
        if (this.activeLine > 0) {
            this.cy = this.activeLine - 1;
        }
        this.cyModified = true;
        return 0;
    }

    private int getActiveline() {
        return this.activeLine;
    }

    private void setAdd(String string) {
        int n;
        string = this.filterASCIIHighlightChars(string);
        int n2 = 0;
        while ((n = string.indexOf(10, n2)) >= n2) {
            this.setAdd_row(string.substring(n2, n), 0);
            n2 = n + 1;
        }
        String string2 = string.substring(n2);
        if (string2.length() > 0) {
            this.setAdd_row(string2, 0);
        }
        this.cyModified = true;
    }

    private final String filterWildcard(int n, int n2, String string) {
        if (string.compareTo("*") == 0) {
            return this.tmodel.getValueAt(n - 1, n2).toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setGeneric_row(String string, int n) {
        int n2;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string.indexOf(this.delimiter, n4)) >= n4) {
            vector.addElement(this.filterWildcard(n, n3, string.substring(n4, n2)));
            n4 = n2 + 1;
            ++n3;
        }
        vector.addElement(this.filterWildcard(n, n3, string.substring(n4)));
        EListBox eListBox = this;
        synchronized (eListBox) {
            if (n <= 0) {
                this.tmodel.addRow(vector);
            } else {
                this.tmodel.setRow(vector, --n);
            }
        }
    }

    private final void setAdd_row(String string, int n) {
        this.setGeneric_row(string, n);
        this.cn.setChanged(1, n, n);
    }

    private final void setSet_row(String string, int n) {
        this.setGeneric_row(string, n);
        this.cn.setChanged(2, n, n);
    }

    public void setBorder(int n) {
        this.border = n;
        this.isModified = true;
    }

    public int getBorder() {
        return this.border;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    private void setClear() {
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                EListBox.this.tmodel.setClear();
                EListBox.this.sp.getHorizontalScrollBar().setValue(0);
                EListBox.this.sp.getVerticalScrollBar().setValue(0);
                EListBox.this.activeLine = 0;
                EListBox.this.cy = 0;
                EListBox.this.cyModified = true;
                EListBox.this.table.clearSelection();
            }
        });
    }

    private void setContent(String string) {
        this.setClear();
        string = this.filterASCIIHighlightChars(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.newline ? "\r\n" : "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.setAdd(stringTokenizer.nextToken());
        }
        this.isModified = true;
    }

    private String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.newline ? "\r\n" : "\n";
        int n = this.table.getRowCount();
        for (int i = 1; i <= n; ++i) {
            stringBuilder.append(this.getLine(i));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private int setCy(int n) {
        if (n < 0 || n > this.getVheight()) {
            return 11;
        }
        this.cy = n;
        this.cyModified = true;
        this.cySet = true;
        this.activeLine = n + 1;
        return 0;
    }

    public int getCy() {
        return this.cy;
    }

    private void setDelim(String string) {
        this.delimiter = new String(string);
    }

    private String getDelim() {
        return this.delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDelln(int n) {
        int n2 = this.cy;
        int n3 = this.table.getRowCount();
        if (n2 >= 0 && n2 < n3) {
            int n4 = n3 - n2;
            if (n > n4) {
                n = n4;
            }
            int n5 = n2 + n - 1;
            EJTableModel eJTableModel = (EJTableModel)this.tsorter.getTableModel();
            EListBox eListBox = this;
            synchronized (eListBox) {
                while (n-- > 0) {
                    eJTableModel.deleteRow(n2);
                }
            }
            this.cn.setChanged(3, n2, n5);
            n3 = this.table.getRowCount();
            if (n2 >= n3) {
                n2 = n3 > 0 ? n3 - 1 : 0;
            }
            this.setCy(n2);
            if (n3 == 0) {
                this.activeLine = 0;
            }
        }
    }

    private void setGridColor(String string) {
        try {
            string.trim();
            int n = string.indexOf(35);
            if (n < 0) {
                return;
            }
            int n2 = Integer.parseInt(string.substring(n + 1), 16);
            this.setGridColor(n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setGridColor(int n) {
        this.gridCol = new Color(n);
    }

    private int getGridColor() {
        return this.gridCol.getRGB();
    }

    private void setHlines(int n) {
        this.gridHor = n != 0;
        this.isModified = true;
    }

    public int getHlines() {
        return this.gridHor ? 1 : 0;
    }

    private void setIns(String string) {
        int n;
        int n2 = this.cy;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.table.getRowCount()) {
            this.setAdd(string);
            return;
        }
        string = this.filterASCIIHighlightChars(string);
        int n3 = n2--;
        int n4 = 0;
        while ((n = string.indexOf(10, n4)) >= n4) {
            this.setIns_row(string.substring(n4, n), ++n2);
            n4 = n + 1;
        }
        String string2 = string.substring(n4);
        if (string2.length() > 0) {
            this.setIns_row(string2, ++n2);
        }
        if (n2 >= n3) {
            this.cn.setChanged(1, n3, n2);
            this.setCy(n2 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setIns_row(String string, int n) {
        int n2;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while ((n2 = string.indexOf(this.delimiter, n3)) >= n3) {
            vector.addElement(string.substring(n3, n2));
            n3 = n2 + 1;
        }
        vector.addElement(string.substring(n3));
        EJTableModel eJTableModel = (EJTableModel)this.tsorter.getTableModel();
        EListBox eListBox = this;
        synchronized (eListBox) {
            eJTableModel.insertRow(vector, n);
        }
    }

    private int getLength() {
        return this.getContent().length();
    }

    private int setLine(String string, int n) {
        if (n < 1 && (n = this.cy + 1) < 1) {
            n = 1;
        }
        if (n > this.table.getRowCount()) {
            n = 0;
        }
        this.setSet_row(this.filterASCIIHighlightChars(string), n);
        this.isModified = true;
        this.cyModified = true;
        return 0;
    }

    private String getLine(int n) {
        boolean bl;
        if (n > 0) {
            --n;
            bl = false;
        } else {
            n = this.cy;
            bl = true;
        }
        this.cn.safeCommit();
        try {
            Vector vector = (Vector)this.tmodel.tableRows.get(n);
            StringBuilder stringBuilder = new StringBuilder((String)vector.get(0));
            for (int i = 1; i < vector.size(); ++i) {
                stringBuilder.append(this.delimiter);
                stringBuilder.append((String)vector.get(i));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return bl ? "" : null;
        }
    }

    private void setMultiline(int n) {
        this.multiline = n != 0;
        this.isModified = true;
    }

    private int getMultiline() {
        return this.multiline ? 1 : 0;
    }

    public void setRuleOverride(int n) {
        this.ruleOverride = n != 0;
    }

    public int getRuleOverride() {
        return this.ruleOverride ? 1 : 0;
    }

    private final int setSingleclick(int n) {
        if (n < 0 || n > 3) {
            return 11;
        }
        this.singleclick = n;
        return 0;
    }

    private final int getSingleclick() {
        return this.singleclick;
    }

    private int setTopitem(int n) {
        if (n < 0 || n >= this.table.getRowCount()) {
            this.topItem = -1;
            this.topItemModified = false;
            return 11;
        }
        this.topItem = n;
        this.topItemModified = true;
        return 0;
    }

    private int getTopitem() {
        return this.topItem;
    }

    private int getVheight() {
        return this.table.getRowCount();
    }

    private void setVlines(int n) {
        this.gridVer = n != 0;
    }

    private int getVlines() {
        return this.gridVer ? 1 : 0;
    }

    private int getVwidth() {
        int n = 0;
        int n2 = this.table.getRowCount();
        for (int i = 1; i <= n2; ++i) {
            int n3 = this.getLine(i).length();
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    private String getColumn(int n) {
        if (n < 1 || n > this.children.size()) {
            return null;
        }
        return ((ETableHeader)this.children.get(n - 1)).getPath();
    }

    private String getVColumn(int n) {
        if (n < 1 || n > this.table.getColumnCount()) {
            return null;
        }
        return ((ETableHeader)this.children.get(this.table.getColumnModel().getColumn(n - 1).getModelIndex())).getPath();
    }

    private int getColumns() {
        return this.children.size() == 0 ? 0 : this.tmodel.getColumnCount();
    }

    private int getVColumns() {
        return this.table.getColumnCount();
    }

    private String getVLine(int n) {
        boolean bl;
        if (n > 0) {
            --n;
            bl = false;
        } else {
            n = this.cy;
            bl = true;
        }
        this.cn.safeCommit();
        try {
            int n2;
            Vector vector = (Vector)this.tmodel.tableRows.get(this.tsorter.modelIndex(n));
            int n3 = n2 = this.table.getColumnCount() > vector.size() ? vector.size() : this.table.getColumnCount();
            if (n2 > 0) {
                StringBuilder stringBuilder = new StringBuilder((String)vector.get(this.table.convertColumnIndexToModel(0)));
                for (int i = 1; i < n2; ++i) {
                    stringBuilder.append(this.delimiter);
                    stringBuilder.append((String)vector.get(this.table.convertColumnIndexToModel(i)));
                }
                return stringBuilder.toString();
            }
            return "";
        }
        catch (Exception exception) {
            return bl ? "" : null;
        }
    }

    private String getVContent() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.newline ? "\r\n" : "\n";
        int n = this.table.getRowCount();
        for (int i = 1; i <= n; ++i) {
            stringBuilder.append(this.getVLine(i));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void setMovable(int n) {
        this.movable = n != 0;
        this.isModified = true;
    }

    private int getMovable() {
        return this.movable ? 1 : 0;
    }

    private void setSizable(int n) {
        this.sizable = n != 0;
        this.isModified = true;
    }

    private int getSizable() {
        return this.sizable ? 1 : 0;
    }

    private void setNewline(int n) {
        this.newline = n != 0;
    }

    private int getNewline() {
        return this.newline ? 1 : 0;
    }

    private void setResetOrder(final int n) {
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                EListBox.this.table.ignoreColumnMoved = true;
                int n4 = 0;
                int n2 = 0;
                ListIterator listIterator = EListBox.this.children.listIterator();
                while (listIterator.hasNext()) {
                    int n3;
                    ETableHeader eTableHeader = (ETableHeader)listIterator.next();
                    if (n == 0) {
                        if (eTableHeader.getHiddenColumn() == null) {
                            n3 = EListBox.this.table.convertColumnIndexToView(n4);
                            if (n3 >= 0 && n3 != n2) {
                                EListBox.this.table.moveColumn(n3, n2);
                            }
                            ++n2;
                        }
                    } else {
                        EListBox.this.showColumn(eTableHeader);
                        n3 = EListBox.this.table.convertColumnIndexToView(n4);
                        if (n3 >= 0 && n3 != n2) {
                            EListBox.this.table.moveColumn(n3, n2);
                        }
                        ++n2;
                    }
                    ++n4;
                }
                EListBox.this.table.ignoreColumnMoved = false;
                EListBox.this.adjustColumnViewSortKeys();
            }
        });
    }

    private int setColumnOrder(final String string) {
        this.setColumnOrder_rc = 0;
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                int n;
                EListBox.this.eloq2swing(false);
                StringTokenizer stringTokenizer = new StringTokenizer(string, EListBox.this.delimiter);
                int[][] nArray = new int[EListBox.this.children.size()][2];
                int[] nArray2 = new int[EListBox.this.children.size()];
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < EListBox.this.children.size(); ++n) {
                    ETableHeader eTableHeader;
                    if (!stringTokenizer.hasMoreElements()) continue;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("!")) {
                        int n4;
                        eTableHeader = (ETableHeader)EListBox.this.children.get(n);
                        if (!eTableHeader.visible || (n4 = EListBox.this.table.convertColumnIndexToView(n)) < 0) continue;
                        EListBox.this.hideColumn(eTableHeader, n4);
                        continue;
                    }
                    if (string2.equals("v")) {
                        eTableHeader = (ETableHeader)EListBox.this.children.get(n);
                        if (eTableHeader.visible) continue;
                        EListBox.this.showColumn(eTableHeader);
                        continue;
                    }
                    if (string2.equals("*")) continue;
                    eTableHeader = (ETableHeader)EListBox.this.children.get(n);
                    if (!eTableHeader.visible) {
                        EListBox.this.showColumn(eTableHeader);
                    }
                    if (string2.equals(">")) {
                        nArray2[n3++] = n;
                        continue;
                    }
                    try {
                        nArray[n2][0] = n;
                        nArray[n2][1] = new Integer(string2);
                        ++n2;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        EListBox.this.setColumnOrder_rc = 11;
                        return;
                    }
                }
                EListBox.this.table.ignoreColumnMoved = true;
                if (n3 > 1) {
                    int n5;
                    int[] nArray3 = new int[n3];
                    for (n5 = 0; n5 < n3; ++n5) {
                        nArray3[n5] = EListBox.this.table.convertColumnIndexToView(nArray2[n5]);
                    }
                    for (n5 = 0; n5 < n3 - 1; ++n5) {
                        EListBox.this.table.moveColumn(EListBox.this.table.convertColumnIndexToView(nArray2[n5]), nArray3[n5 + 1]);
                    }
                    EListBox.this.table.moveColumn(EListBox.this.table.convertColumnIndexToView(nArray2[n3 - 1]), nArray3[0]);
                }
                if (n2 > 0) {
                    for (n = 0; n < EListBox.this.children.size(); ++n) {
                        for (int i = 0; i < n2; ++i) {
                            if (nArray[i][1] != n) continue;
                            if (nArray[i][1] >= EListBox.this.table.getColumnCount()) {
                                EListBox.this.setColumnOrder_rc = 11;
                                return;
                            }
                            if (EListBox.this.table.convertColumnIndexToView(nArray[i][0]) < 0) continue;
                            EListBox.this.table.moveColumn(EListBox.this.table.convertColumnIndexToView(nArray[i][0]), n);
                        }
                    }
                }
                EListBox.this.table.ignoreColumnMoved = false;
                EListBox.this.adjustColumnViewSortKeys();
            }
        });
        return this.setColumnOrder_rc;
    }

    private String getColumnOrder() {
        String string = "";
        int n = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            ETableHeader eTableHeader = (ETableHeader)listIterator.next();
            if (n > 0) {
                string = string + this.delimiter;
            }
            string = eTableHeader.getHiddenColumn() == null ? string + this.table.convertColumnIndexToView(n) : string + "!";
            ++n;
        }
        return string;
    }

    private int setSortSequence(final String string) {
        this.setSortSequence_rc = 0;
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                int n;
                StringTokenizer stringTokenizer = new StringTokenizer(string, EListBox.this.delimiter);
                int[][] nArray = new int[EListBox.this.children.size()][2];
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < EListBox.this.children.size(); ++n) {
                    if (!stringTokenizer.hasMoreElements()) continue;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("!")) {
                        EListBox.this.tmodel.setColumnSorting(n, false);
                        continue;
                    }
                    EListBox.this.tmodel.setColumnSorting(n, true);
                    if (string2.equals("*")) {
                        EListBox.this.tsorter.setSortingStatus(n, 0);
                        continue;
                    }
                    if (string2.charAt(0) == 'A') {
                        nArray[n3][1] = 1;
                        string2 = string2.substring(1);
                    } else if (string2.charAt(0) == 'D') {
                        nArray[n3][1] = -1;
                        string2 = string2.substring(1);
                    } else {
                        nArray[n3][1] = 1;
                    }
                    try {
                        int n4 = new Integer(string2);
                        if (n4 > n2) {
                            n2 = n4;
                        }
                        int[] nArray2 = nArray[n3];
                        nArray2[1] = nArray2[1] * n4;
                        nArray[n3][0] = n;
                        ++n3;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        EListBox.this.setSortSequence_rc = 11;
                        return;
                    }
                }
                if (n3 < n2) {
                    EListBox.this.setSortSequence_rc = 11;
                    return;
                }
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        if (Math.abs(nArray[i][1]) - 1 != n) continue;
                        EListBox.this.tsorter.setSortingStatus(nArray[i][0], nArray[i][1] > 0 ? 1 : -1);
                    }
                }
            }
        });
        return this.setSortSequence_rc;
    }

    private String getSortSequence() {
        String string = "";
        for (int i = 0; i < this.children.size(); ++i) {
            if (i > 0) {
                string = string + this.delimiter;
            }
            if (this.tsorter.getSortingEnabled(i)) {
                switch (this.tsorter.getSortingStatus(i)) {
                    case 1: {
                        string = string + "A";
                        string = string + (this.tsorter.getPriority(i) + 1);
                        break;
                    }
                    case 0: {
                        string = string + "*";
                        break;
                    }
                    case -1: {
                        string = string + "D";
                        string = string + (this.tsorter.getPriority(i) + 1);
                    }
                }
                continue;
            }
            string = string + "!";
        }
        return string;
    }

    private int setStatus(final String string) {
        this.setStatus_rc = 0;
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                StringTokenizer stringTokenizer = new StringTokenizer(string, EListBox.this.newline ? "\r\n" : "\n");
                if (!stringTokenizer.hasMoreTokens()) {
                    EListBox.this.setStatus_rc = 11;
                    return;
                }
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    EListBox.this.setStatus_rc = 11;
                    return;
                }
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    EListBox.this.setStatus_rc = 11;
                    return;
                }
                int n = 0;
                int n2 = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), EListBox.this.delimiter);
                while (stringTokenizer2.hasMoreTokens()) {
                    try {
                        n = new Integer(stringTokenizer2.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        EListBox.this.setStatus_rc = 11;
                        return;
                    }
                    if (n2 >= EListBox.this.children.size()) {
                        EListBox.this.setStatus_rc = 11;
                        return;
                    }
                    ((ETableHeader)EListBox.this.children.get(n2++)).setWidth(n);
                }
                if (EListBox.this.setColumnOrder(string3) != 0) {
                    EListBox.this.setStatus_rc = 11;
                    return;
                }
                if (EListBox.this.setSortSequence(string2) != 0) {
                    EListBox.this.setStatus_rc = 11;
                    return;
                }
            }
        });
        return this.setStatus_rc;
    }

    private String getStatus() {
        String string = this.newline ? "\r\n" : "\n";
        String string2 = this.getColumnOrder() + string;
        string2 = string2 + this.getSortSequence() + string;
        int n = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            ETableHeader eTableHeader = (ETableHeader)listIterator.next();
            if (n > 0) {
                string2 = string2 + this.delimiter;
            }
            string2 = string2 + eTableHeader.getWidth();
            ++n;
        }
        string2 = string2 + string;
        return string2;
    }

    private void setRowHeight(int n) {
        this.rowHeight = n > 0 ? n : 0;
        this.rowHeightModified = true;
        this.isModified = true;
    }

    private int getRowHeight() {
        return this.rowHeight;
    }

    private void setBGColor2(String string) {
        if (string.length() == 0) {
            this.bgColor2 = null;
            this.isModified = true;
            return;
        }
        string.trim();
        int n = string.indexOf(35);
        if (n == -1) {
            return;
        }
        string = string.substring(n + 1);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.bgColor2 = new Color(n2);
        this.isModified = true;
    }

    private void setBGColor2(int n) {
        this.bgColor2 = new Color(n);
        this.isModified = true;
    }

    private int getBGColor2() {
        return this.bgColor2 != null ? this.bgColor2.getRGB() : this.getFgc();
    }

    private void setFGColor2(String string) {
        if (string.length() == 0) {
            this.fgColor2 = null;
            this.isModified = true;
            return;
        }
        string.trim();
        int n = string.indexOf(35);
        if (n == -1) {
            return;
        }
        string = string.substring(n + 1);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.fgColor2 = new Color(n2);
        this.isModified = true;
    }

    private void setFGColor2(int n) {
        this.fgColor2 = new Color(n);
        this.isModified = true;
    }

    private int getFGColor2() {
        return this.fgColor2 != null ? this.fgColor2.getRGB() : this.getFgc();
    }

    private int setVActiveLine(int n) {
        if (n < 1) {
            this.activeLine = 0;
            return 0;
        }
        this.cn.safeCommit();
        if (n > this.tmodel.getRowCount()) {
            return 11;
        }
        this.cy = this.tsorter.modelIndex(n - 1);
        this.activeLine = this.cy + 1;
        this.cyModified = true;
        return 0;
    }

    private int getVActiveLine() {
        if (this.activeLine < 1) {
            return 0;
        }
        this.cn.safeCommit();
        return this.tsorter.viewIndex(this.cy) + 1;
    }

    private int getViewOrder(int n) {
        this.cn.safeCommit();
        return this.tsorter.viewIndex(n - 1) + 1;
    }

    private int setUnifiedData(UnifiedData unifiedData, int n) {
        if (n < 1) {
            n = this.cy + 1;
        }
        if (n < 1 || n > this.tmodel.getRowCount()) {
            return 11;
        }
        this.tmodel.setRowData(unifiedData, n - 1);
        return 0;
    }

    private int setRowData(String string, int n) {
        return this.setUnifiedData(new UnifiedData(string), n);
    }

    private int setRowData(int n, int n2) {
        return this.setUnifiedData(new UnifiedData(n), n2);
    }

    private int getRowData(Dlg.Rs.GET gET, int n) {
        if (n < 1) {
            n = this.cy + 1;
        }
        if (n < 1 || n > this.tmodel.getRowCount()) {
            return 11;
        }
        UnifiedData unifiedData = this.tmodel.getRowData(n - 1);
        if (unifiedData == null) {
            gET.setValueString(null);
        } else if (unifiedData.isStringData()) {
            gET.setValueString(unifiedData.getStringData());
        } else {
            gET.setValueInt(unifiedData.getIntData());
        }
        return 0;
    }

    private int setToolhelp(String string, int n) {
        if (n < 1) {
            n = this.cy + 1;
        }
        if (n < 1 || n > this.tmodel.getRowCount()) {
            return 11;
        }
        if (this.tmodel.setToolTipText(string, n - 1)) {
            this.isModified = true;
        }
        return 0;
    }

    private int getToolhelp(Dlg.Rs.GET gET, int n) {
        if (n < 1) {
            n = this.cy + 1;
        }
        if (n < 1 || n > this.tmodel.getRowCount()) {
            return 11;
        }
        String string = this.tmodel.getToolTipText(n - 1);
        gET.setValueString(string != null ? string : "");
        return 0;
    }

    private String getRowDataBuf() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.tmodel.getRowCount();
        for (int i = 0; i < n; ++i) {
            UnifiedData unifiedData = this.tmodel.getRowData(i);
            if (unifiedData == null) {
                stringBuilder.append("V");
                continue;
            }
            if (unifiedData.isStringData()) {
                String string = unifiedData.getStringData();
                stringBuilder.append("X");
                stringBuilder.append(String.valueOf(string.length()));
                stringBuilder.append("~");
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append("N");
            stringBuilder.append(String.valueOf(unifiedData.getIntData()));
        }
        stringBuilder.append("$");
        return stringBuilder.toString();
    }

    private int getModelOrder(int n) {
        this.cn.safeCommit();
        return this.tsorter.modelIndex(n - 1) + 1;
    }

    private int getActiveColumn() {
        return this.activeColumn;
    }

    private void setColContextMenu(int n) {
        this.colContextMenu = n != 0;
    }

    private int getColContextMenu() {
        return this.colContextMenu ? 1 : 0;
    }

    private void setColMargin(int n) {
        this.colMargin = n;
    }

    public int getColMargin() {
        return this.colMargin;
    }

    private void setVcRule(int n) {
        this.vcRule = n;
    }

    private int getVcRule() {
        return this.vcRule;
    }

    public void fireVcRule(int n) {
        if (this.vcRule != 0) {
            this.activeColumn = n;
            this.vcRuleFired = true;
            this.getRuleManager().fireRule(this);
        }
    }

    public int getRule() {
        return this.vcRuleFired ? this.vcRule : super.getRule();
    }

    public void ruleProcessed() {
        this.vcRuleFired = false;
        super.ruleProcessed();
    }

    private int getRuleKey() {
        return this.ruleKey;
    }

    private final void setDropMode(int n) {
        this.acceptValidDropOnly = n != 0;
    }

    private final int getDropMode() {
        return this.acceptValidDropOnly ? 1 : 0;
    }

    private final int getDropLine() {
        return this.dropLine;
    }

    private final int getDropColumn() {
        return this.dropColumn;
    }

    public void enableDragDrop() {
        this.table.setDropMode(DropMode.USE_SELECTION);
        this.setDragDropHandler(new DragDrop());
    }

    private void setTitlesAndWidths() {
        JTableHeader jTableHeader = this.table.getTableHeader();
        if (jTableHeader != null) {
            boolean bl = false;
            int n = 0;
            ListIterator listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                int n2;
                ETableHeader eTableHeader = (ETableHeader)listIterator.next();
                if (eTableHeader.isModified() && (n2 = this.table.convertColumnIndexToView(n)) >= 0) {
                    jTableHeader.getColumnModel().getColumn(n2).setHeaderValue(eTableHeader.getTitle());
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                jTableHeader.resizeAndRepaint();
            }
        }
    }

    public Component getPeer() {
        return this.sp;
    }

    public Component getFocusPeer() {
        return this.peer;
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        if (this.children.size() == 0) {
            if (this.colMargin > 0) {
                int n = this.colMargin;
                if (n == 1) {
                    n = 50;
                }
                this.cellMargin = (int)Math.round((double)dimension2.width * (double)n / 100.0);
            } else {
                this.cellMargin = 0;
            }
            this.setSingleColumnWidth(dimension);
        } else {
            this.cellMargin = 0;
            ListIterator listIterator = this.children.listIterator();
            while (listIterator.hasNext()) {
                ETableHeader eTableHeader = (ETableHeader)listIterator.next();
                eTableHeader.layout(null, dimension2, scaling);
            }
            this.sp.setHorizontalScrollBarPolicy(30);
            this.sp.setVerticalScrollBarPolicy(20);
        }
        return false;
    }

    private final void setSingleColumnWidth(Dimension dimension) {
        this.peer.validate();
        this.sp.validate();
        Insets insets = this.sp.getInsets();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        int n3 = 0;
        int n4 = 0;
        for (int i = this.tmodel.getRowCount() - 1; i >= 0; --i) {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(i, 0);
            Component component = tableCellRenderer.getTableCellRendererComponent(this.table, this.table.getModel().getValueAt(i, 0), false, false, i, 0);
            Dimension dimension2 = component.getPreferredSize();
            n3 = Math.max(n3, dimension2.width);
            n4 += dimension2.height + 0;
        }
        if (n4 > n2) {
            this.sp.setVerticalScrollBarPolicy(22);
            JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
            n -= jScrollBar.getPreferredSize().width;
        } else {
            this.sp.setVerticalScrollBarPolicy(21);
        }
        if (n3 > n) {
            this.sp.setHorizontalScrollBarPolicy(32);
        } else {
            this.sp.setHorizontalScrollBarPolicy(31);
            n3 = n;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setWidth(n3);
        tableColumn.setPreferredWidth(n3);
    }

    protected void setSelectedIndexByKey(char c) {
        int n = this.table.getSelectedRow();
        String string = null;
        int n2 = this.table.getRowCount();
        if (n2 > 0) {
            int n3 = (n + 1) % n2;
            for (int i = 0; n != -1 && n3 != n && i < n2; ++i) {
                try {
                    string = this.table.getValueAt(n3, 0).toString().trim();
                }
                catch (Throwable throwable) {
                    break;
                }
                if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == Character.toLowerCase(c)) {
                    this.table.changeSelection(n3, 0, false, false);
                    break;
                }
                n3 = (n3 + 1) % n2;
            }
        }
    }

    public void fontModified(Font font) {
        super.fontModified(font);
        this.table.setRowHeight(this.effectiveRowHeight());
        this.isModified = true;
    }

    private int effectiveRowHeight() {
        int n;
        int n2 = (int)Math.round((double)this.rowHeight * this.getFontScaling());
        return n2 > (n = this.fontReference.getHeight(this) + 0) ? n2 : n;
    }

    public void focusReceived(AbstractControl abstractControl) {
        super.focusReceived(abstractControl);
        defaults.setFocusBorder(this.sp);
    }

    public void focusLost(AbstractControl abstractControl) {
        defaults.setBorder(this.sp);
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 47: {
                        sTATUS.attrMode = 5;
                        return this.setLine(sET.getValueString(), this.getInt(sET.index));
                    }
                    case 43: {
                        if (sET.v_type == 1) {
                            return this.setRowData(sET.getValueInt(), this.getInt(sET.index));
                        }
                        return this.setRowData(sET.getValueString(), this.getInt(sET.index));
                    }
                    case 45: {
                        return this.setToolhelp(sET.getValueString(), this.getInt(sET.index));
                    }
                }
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setActiveitem(sET.getValueInt());
                    sTATUS.attrMode = 4;
                    break;
                }
                case 1: {
                    sTATUS.attrMode = 4;
                    return this.setActiveline(sET.getValueInt());
                }
                case 2: {
                    this.setAdd(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 3: {
                    this.setBorder(sET.getValueInt());
                    break;
                }
                case 4: {
                    this.setClear();
                    sTATUS.attrMode = 5;
                    break;
                }
                case 6: {
                    return this.setColumnOrder(sET.getValueString());
                }
                case 8: {
                    this.setContent(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 10: {
                    sTATUS.attrMode = 4;
                    return this.setCy(sET.getValueInt());
                }
                case 11: {
                    this.setDelim(sET.getValueString());
                    break;
                }
                case 12: {
                    this.setDelln(sET.getValueInt());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 13: {
                    if (sET.v_type != 2) break;
                    this.setGridColor(sET.getValueString());
                    break;
                }
                case 14: {
                    this.setHlines(sET.getValueInt());
                    break;
                }
                case 16: {
                    this.setIns(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 20: {
                    this.setMovable(sET.getValueInt());
                    break;
                }
                case 18: {
                    this.setMultiline(sET.getValueInt());
                    break;
                }
                case 21: {
                    this.setNewline(sET.getValueInt());
                    break;
                }
                case 22: {
                    this.setResetOrder(sET.getValueInt());
                    break;
                }
                case 23: {
                    this.setRuleOverride(sET.getValueInt());
                    break;
                }
                case 24: {
                    return this.setSingleclick(sET.getValueInt());
                }
                case 25: {
                    this.setSizable(sET.getValueInt());
                    break;
                }
                case 26: {
                    return this.setSortSequence(sET.getValueString());
                }
                case 27: {
                    return this.setStatus(sET.getValueString());
                }
                case 28: {
                    this.setTopitem(sET.getValueInt());
                    sTATUS.attrMode = 4;
                    break;
                }
                case 35: {
                    this.setVlines(sET.getValueInt());
                    break;
                }
                case 38: {
                    this.setRowHeight(sET.getValueInt());
                    break;
                }
                case 39: {
                    break;
                }
                case 40: {
                    this.setBGColor2(sET.getValueString());
                    break;
                }
                case 41: {
                    this.setFGColor2(sET.getValueString());
                    break;
                }
                case 42: {
                    this.setVActiveLine(sET.getValueInt());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 15: {
                    break;
                }
                case 36: {
                    break;
                }
                case 47: {
                    this.setLine(sET.getValueString(), 0);
                    sTATUS.attrMode = 5;
                    break;
                }
                case 43: {
                    if (sET.v_type == 1) {
                        return this.setRowData(sET.getValueInt(), 0);
                    }
                    return this.setRowData(sET.getValueString(), 0);
                }
                case 45: {
                    this.setToolhelp(sET.getValueString());
                    break;
                }
                case 48: {
                    this.setColContextMenu(sET.getValueInt());
                    break;
                }
                case 49: {
                    this.setColMargin(sET.getValueInt());
                    break;
                }
                case 50: {
                    this.setDropMode(sET.getValueInt());
                    break;
                }
                case 53: {
                    this.setVcRule(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 47: {
                        if (gET2.setValueString(this.getLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    case 34: {
                        if (gET2.setValueString(this.getVLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    case 5: {
                        if (gET2.setValueString(this.return_ID(this.getColumn(this.getInt(gET.index))))) break;
                        return 11;
                    }
                    case 29: {
                        if (gET2.setValueString(this.return_ID(this.getVColumn(this.getInt(gET.index))))) break;
                        return 11;
                    }
                    case 33: {
                        gET2.setValueInt(this.getViewOrder(this.getInt(gET.index)));
                        break;
                    }
                    case 19: {
                        gET2.setValueInt(this.getModelOrder(this.getInt(gET.index)));
                        break;
                    }
                    case 43: {
                        return this.getRowData(gET2, this.getInt(gET.index));
                    }
                    case 45: {
                        return this.getToolhelp(gET2, this.getInt(gET.index));
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 0: {
                    gET2.setValueInt(this.getActiveitem());
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    this.activeItemCached = true;
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getActiveline());
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    this.activeLineCached = true;
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getBorder());
                    break;
                }
                case 6: {
                    gET2.setValueString(this.getColumnOrder());
                    break;
                }
                case 7: {
                    gET2.setValueInt(this.getColumns());
                    break;
                }
                case 8: {
                    gET2.setValueString(this.getContent());
                    break;
                }
                case 9: {
                    gET2.setValueInt(0);
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.cy);
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    this.cyCached = true;
                    break;
                }
                case 11: {
                    gET2.setValueString(this.getDelim());
                    break;
                }
                case 13: {
                    gET2.setValueString('#' + HexTool.int2hexString(this.getGridColor(), 3));
                    break;
                }
                case 14: {
                    gET2.setValueInt(this.getHlines());
                    break;
                }
                case 15: {
                    gET2.setValueInt(0);
                    break;
                }
                case 17: {
                    gET2.setValueInt(this.getLength());
                    break;
                }
                case 20: {
                    gET2.setValueInt(this.getMovable());
                    break;
                }
                case 18: {
                    gET2.setValueInt(this.getMultiline());
                    break;
                }
                case 21: {
                    gET2.setValueInt(this.getNewline());
                    break;
                }
                case 23: {
                    gET2.setValueInt(this.getRuleOverride());
                    break;
                }
                case 24: {
                    gET2.setValueInt(this.getSingleclick());
                    break;
                }
                case 25: {
                    gET2.setValueInt(this.getSizable());
                    break;
                }
                case 26: {
                    gET2.setValueString(this.getSortSequence());
                    break;
                }
                case 27: {
                    gET2.setValueString(this.getStatus());
                    break;
                }
                case 28: {
                    gET2.setValueInt(this.getTopitem());
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    this.topItemCached = true;
                    break;
                }
                case 31: {
                    gET2.setValueString(this.getVContent());
                    break;
                }
                case 30: {
                    gET2.setValueInt(this.getVColumns());
                    break;
                }
                case 32: {
                    gET2.setValueInt(this.getVheight());
                    break;
                }
                case 35: {
                    gET2.setValueInt(this.getVlines());
                    break;
                }
                case 36: {
                    gET2.setValueInt(0);
                    break;
                }
                case 37: {
                    gET2.setValueInt(this.getVwidth());
                    break;
                }
                case 38: {
                    gET2.setValueInt(this.getRowHeight());
                    break;
                }
                case 39: {
                    gET2.setValueInt(0);
                    break;
                }
                case 40: {
                    gET2.setValueString('#' + HexTool.int2hexString(this.getBGColor2(), 3));
                    break;
                }
                case 41: {
                    gET2.setValueString('#' + HexTool.int2hexString(this.getFGColor2(), 3));
                    break;
                }
                case 42: {
                    gET2.setValueInt(this.getVActiveLine());
                    break;
                }
                case 46: {
                    gET2.setValueInt(this.getActiveColumn());
                    break;
                }
                case 47: {
                    gET2.setValueString(this.getLine(0));
                    break;
                }
                case 34: {
                    gET2.setValueString(this.getVLine(0));
                    break;
                }
                case 43: {
                    return this.getRowData(gET2, 0);
                }
                case 44: {
                    gET2.setValueString(this.getRowDataBuf());
                    break;
                }
                case 45: {
                    gET2.setValueString(this.getToolhelp());
                    break;
                }
                case 48: {
                    gET2.setValueInt(this.getColContextMenu());
                    break;
                }
                case 49: {
                    gET2.setValueInt(this.getColMargin());
                    break;
                }
                case 50: {
                    gET2.setValueInt(this.getDropMode());
                    break;
                }
                case 51: {
                    gET2.setValueInt(this.getDropLine());
                    break;
                }
                case 52: {
                    gET2.setValueInt(this.getDropColumn());
                    break;
                }
                case 53: {
                    gET2.setValueInt(this.getVcRule());
                    break;
                }
                case 54: {
                    gET2.setValueInt(this.getRuleKey());
                    gET2.cacheMode = 1;
                    this.ruleKeyCached = true;
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    protected void cloneAttributes(EListBox eListBox) {
        super.cloneAttributes(eListBox);
        eListBox.setBorder(this.getBorder());
        if (this.cySet) {
            eListBox.setCy(this.cy);
        }
        eListBox.setDelim(this.getDelim());
        eListBox.setGridColor(this.getGridColor());
        eListBox.setHlines(this.getHlines());
        eListBox.setMultiline(this.getMultiline());
        eListBox.setRuleOverride(this.getRuleOverride());
        eListBox.setSingleclick(this.getSingleclick());
        eListBox.setTopitem(this.getTopitem());
        eListBox.setVlines(this.getVlines());
        eListBox.tmodel.tableHeader = (Vector)this.tmodel.tableHeader.clone();
        eListBox.tmodel.tableRows = (Vector)this.tmodel.tableRows.clone();
        eListBox.tmodel.tableRowData = this.tmodel.tableRowData != null ? (Vector)this.tmodel.tableRowData.clone() : null;
        eListBox.tmodel.tableToolTipText = this.tmodel.tableToolTipText != null ? (Vector)this.tmodel.tableToolTipText.clone() : null;
        eListBox.setMovable(this.getMovable());
        eListBox.setNewline(this.getNewline());
        eListBox.setSizable(this.getSizable());
        eListBox.setRowHeight(this.getRowHeight());
        eListBox.setSortSequence(this.getSortSequence());
        eListBox.setColContextMenu(this.getColContextMenu());
        eListBox.setColMargin(this.getColMargin());
        eListBox.setDropMode(this.getDropMode());
        if (this.bgColor2 != null) {
            eListBox.setBGColor2(this.getBGColor2());
        }
        if (this.fgColor2 != null) {
            eListBox.setFGColor2(this.getFGColor2());
        }
        eListBox.setVcRule(this.getVcRule());
    }

    static {
        attributeList.put(ACTIVEITEM_ATTR_NAME, new Integer(0));
        attributeList.put(ACTIVELINE_ATTR_NAME, new Integer(1));
        attributeList.put(ADD_ATTR_NAME, new Integer(2));
        attributeList.put(BORDER_ATTR_NAME, new Integer(3));
        attributeList.put(CLEAR_ATTR_NAME, new Integer(4));
        attributeList.put(COLUMN_ATTR_NAME, new Integer(5));
        attributeList.put(COLUMNORDER_ATTR_NAME, new Integer(6));
        attributeList.put(COLUMNS_ATTR_NAME, new Integer(7));
        attributeList.put(CONTENT_ATTR_NAME, new Integer(8));
        attributeList.put(LINE_BUF_ATTR_NAME, new Integer(8));
        attributeList.put(CX_ATTR_NAME, new Integer(9));
        attributeList.put(CY_ATTR_NAME, new Integer(10));
        attributeList.put(DELIM_ATTR_NAME, new Integer(11));
        attributeList.put(DELLN_ATTR_NAME, new Integer(12));
        attributeList.put(GRIDCOLOR_ATTR_NAME, new Integer(13));
        attributeList.put(HLINES_ATTR_NAME, new Integer(14));
        attributeList.put(HSB_ATTR_NAME, new Integer(15));
        attributeList.put(INS_ATTR_NAME, new Integer(16));
        attributeList.put(LENGTH_ATTR_NAME, new Integer(17));
        attributeList.put(MULTILINE_ATTR_NAME, new Integer(18));
        attributeList.put(MODELORDER_ATTR_NAME, new Integer(19));
        attributeList.put(MOVABLE_ATTR_NAME, new Integer(20));
        attributeList.put(NEWLINE_ATTR_NAME, new Integer(21));
        attributeList.put(RESETORDER_ATTR_NAME, new Integer(22));
        attributeList.put(RULEOVERRIDE_ATTR_NAME, new Integer(23));
        attributeList.put(SINGLECLICK_ATTR_NAME, new Integer(24));
        attributeList.put(SIZABLE_ATTR_NAME, new Integer(25));
        attributeList.put(SORTSEQUENCE_ATTR_NAME, new Integer(26));
        attributeList.put(STATUS_ATTR_NAME, new Integer(27));
        attributeList.put(TOPITEM_ATTR_NAME, new Integer(28));
        attributeList.put(VCOLUMN_ATTR_NAME, new Integer(29));
        attributeList.put(VCOLUMNS_ATTR_NAME, new Integer(30));
        attributeList.put(VCONTENT_ATTR_NAME, new Integer(31));
        attributeList.put(VLINE_BUF_ATTR_NAME, new Integer(31));
        attributeList.put(VHEIGHT_ATTR_NAME, new Integer(32));
        attributeList.put(VIEWORDER_ATTR_NAME, new Integer(33));
        attributeList.put(VLINE_ATTR_NAME, new Integer(34));
        attributeList.put(VLINES_ATTR_NAME, new Integer(35));
        attributeList.put(VSB_ATTR_NAME, new Integer(36));
        attributeList.put(VWIDTH_ATTR_NAME, new Integer(37));
        attributeList.put(ROWHEIGHT_ATTR_NAME, new Integer(38));
        attributeList.put(SPACING_ATTR_NAME, new Integer(39));
        attributeList.put(BGCOLOR2_ATTR_NAME, new Integer(40));
        attributeList.put(FGCOLOR2_ATTR_NAME, new Integer(41));
        attributeList.put(VACTIVELINE_ATTR_NAME, new Integer(42));
        attributeList.put(ROWDATA_ATTR_NAME, new Integer(43));
        attributeList.put(ROWDATA_BUF_ATTR_NAME, new Integer(44));
        attributeList.put("toolhelp", new Integer(45));
        attributeList.put(ACTIVECOLUMN_ATTR_NAME, new Integer(46));
        attributeList.put(LINE_ATTR_NAME, new Integer(47));
        attributeList.put(COLCONTEXTMENU_ATTR_NAME, new Integer(48));
        attributeList.put(COLMARGIN_ATTR_NAME, new Integer(49));
        attributeList.put(DROP_MODE_ATTR_NAME, new Integer(50));
        attributeList.put(DROP_LINE_ATTR_NAME, new Integer(51));
        attributeList.put(DROP_COLUMN_ATTR_NAME, new Integer(52));
        attributeList.put(VC_RULE_ATTR_NAME, new Integer(53));
        attributeList.put(SORTRULE_ATTR_NAME, new Integer(53));
        attributeList.put(RULEKEY_ATTR_NAME, new Integer(54));
    }

    public final class ChangeNotifier {
        private int mode = 0;
        private static final int NONE = 0;
        private static final int INSERT = 1;
        private static final int UPDATE = 2;
        private static final int DELETE = 3;
        private int firstRow = 0;
        private int lastRow = 0;
        public boolean tableStructureChanged;

        public void setChanged(int n, int n2, int n3) {
            if (this.mode != 0) {
                if (n == this.mode) {
                    if (n == 1 && n2 >= this.firstRow && n2 <= this.lastRow + 1) {
                        int n4 = n3 - n2 + 1;
                        this.lastRow += n4;
                        return;
                    }
                    if (n == 2 && n2 <= this.lastRow + 1 && n3 >= this.firstRow - 1) {
                        if (n2 < this.firstRow) {
                            this.firstRow = n2;
                        }
                        if (n3 > this.lastRow) {
                            this.lastRow = n3;
                        }
                        return;
                    }
                    if (n == 3 && n2 <= this.firstRow && n3 >= this.firstRow - 1) {
                        int n5 = n3 - this.firstRow + 1;
                        if (n5 > 0) {
                            this.lastRow += n5;
                        }
                        if (n2 < this.firstRow) {
                            this.firstRow = n2;
                        }
                        return;
                    }
                }
                this.safeCommit();
            }
            this.firstRow = n2;
            this.lastRow = n3;
            this.mode = n;
        }

        public void commit() {
            if (this.tableStructureChanged) {
                this.tableStructureChanged = false;
                EListBox.this.tmodel.fireTableStructureChanged();
            }
            if (this.mode == 0) {
                return;
            }
            TableSorter tableSorter = EListBox.this.tsorter;
            EJTableModel eJTableModel = (EJTableModel)tableSorter.getTableModel();
            switch (this.mode) {
                case 1: {
                    eJTableModel.fireTableChanged(new TableModelEvent(tableSorter, this.firstRow, this.lastRow, -1, 1));
                    break;
                }
                case 2: {
                    eJTableModel.fireTableChanged(new TableModelEvent(tableSorter, this.firstRow, this.lastRow));
                    break;
                }
                case 3: {
                    eJTableModel.fireTableChanged(new TableModelEvent(tableSorter, this.firstRow, this.lastRow, -1, -1));
                }
            }
            this.mode = 0;
        }

        public void safeCommit() {
            if (this.tableStructureChanged || this.mode != 0) {
                SafeRunnable.execute(new SafeRunnable(){

                    public void runSafe() {
                        ChangeNotifier.this.commit();
                    }
                });
            }
        }
    }

    public final class PopupListener
    extends MouseAdapter {
        ScrollablePopupMenu popup;
        boolean popupSetup = false;

        PopupListener(ScrollablePopupMenu scrollablePopupMenu) {
            this.popup = scrollablePopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.popupSetup = EListBox.this.setupPopupMenu();
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (this.popupSetup) {
                EListBox eListBox = EListBox.this;
                if (eListBox.colContextMenu && eListBox.getSensitive() != 0 && mouseEvent.isPopupTrigger()) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public static class ETableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;

        public ETableCellRenderer(TableCellRenderer tableCellRenderer) {
            this.defaultRenderer = tableCellRenderer;
        }

        public TableCellRenderer getDefaultRenderer() {
            return this.defaultRenderer;
        }

        public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
            this.defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public final class TooltipHeader
    extends JTableHeader {
        public TooltipHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.getTable().convertColumnIndexToModel(this.columnAtPoint(mouseEvent.getPoint()));
            if (n < 0 || n >= EListBox.this.children.size()) {
                return null;
            }
            AbstractControl abstractControl = (AbstractControl)EListBox.this.children.get(n);
            if (abstractControl.toolhelp.length() != 0) {
                return abstractControl.toolhelp;
            }
            return EListBox.this.tmodel.getColumnName(n);
        }

        public void processEvents(AWTEvent aWTEvent) {
            if (!EListBox.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }

        public EListBox getListbox() {
            return EListBox.this;
        }

        public void updateUI() {
            ETableCellRenderer eTableCellRenderer = null;
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer();
            if (tableCellRenderer instanceof ETableCellRenderer) {
                eTableCellRenderer = (ETableCellRenderer)tableCellRenderer;
                this.setDefaultRenderer(eTableCellRenderer.getDefaultRenderer());
            }
            super.updateUI();
            if (eTableCellRenderer != null) {
                eTableCellRenderer.setDefaultRenderer(this.getDefaultRenderer());
                this.setDefaultRenderer(eTableCellRenderer);
                Debug.log(2, 1, "NOTE: ListBox '" + EListBox.this.getPath() + "' header UI updated");
            }
        }
    }

    public final class EJTable
    extends JTable {
        public boolean ignoreColumnMoved;
        private Value value;

        public EJTable(TableModel tableModel) {
            super(tableModel);
            this.ignoreColumnMoved = false;
            this.value = new Value();
            this.setSelectionMode(0);
            this.setBackground(Color.WHITE);
            this.setAutoResizeMode(0);
        }

        public boolean getScrollableTracksViewportHeight() {
            Container container = this.getParent();
            if (StartUp.isJavaVersion1_7()) {
                while (container instanceof JLayer) {
                    container = container.getParent();
                }
            }
            return container instanceof JViewport && container.getHeight() > this.getPreferredSize().height;
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EListBox.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            super.columnMoved(tableColumnModelEvent);
            if (!this.ignoreColumnMoved && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                EListBox.this.adjustColumnViewSortKeys();
                if (EListBox.this.vcRule != 0) {
                    EListBox.this.fireVcRule(EListBox.this.table.convertColumnIndexToModel(tableColumnModelEvent.getToIndex()));
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            Object object = super.getValueAt(n, n2);
            if (object instanceof String) {
                this.value.setValue((String)object);
                return this.value;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLayout() {
            EListBox eListBox = EListBox.this;
            synchronized (eListBox) {
                super.doLayout();
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Object object;
            int n = EListBox.this.table.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0 && (object = EListBox.this.tmodel.getToolTipText(EListBox.this.tsorter.modelIndex(n))) != null) {
                return object;
            }
            object = EListBox.this;
            return ((EListBox)object).toolhelp.length() != 0 ? ((EListBox)object).toolhelp : null;
        }

        private final class Value {
            private String value;

            private Value() {
            }

            public void setValue(String string) {
                this.value = string;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return HtmlTool.text(this.value);
            }
        }
    }

    public final class EJTableModel
    extends AbstractTableModel
    implements TableCellRenderer {
        private Vector tableHeader = new Vector();
        private Vector tableSorting = new Vector();
        private Vector tableRows = new Vector();
        private Vector tableSingleRow = new Vector();
        private Vector tableRowData = null;
        private Vector tableToolTipText = null;
        private JLabel cellLabel;
        private JCheckBox cellChecker = new JCheckBox();
        private JProgressBar cellProgress = new JProgressBar();
        private Color cellProgressFgc = null;
        private int margin = 0;

        EJTableModel() {
            this.cellLabel = new JLabel();
            this.cellLabel.setOpaque(true);
            this.cellLabel.setHorizontalAlignment(0);
            this.cellLabel.setBorder(new CellBorder());
            this.cellProgressFgc = this.cellProgress.getForeground();
        }

        protected void finalize() throws Throwable {
            this.dispose();
        }

        public void dispose() {
            if (this.tableHeader != null) {
                this.tableHeader.clear();
                this.tableHeader = null;
            }
            if (this.tableSorting != null) {
                this.tableSorting.clear();
                this.tableSorting = null;
            }
            if (this.tableRows != null) {
                this.tableRows.clear();
                this.tableRows = null;
            }
            if (this.tableSingleRow != null) {
                this.tableSingleRow.clear();
                this.tableSingleRow = null;
            }
            if (this.tableRowData != null) {
                this.tableRowData.clear();
                this.tableRowData = null;
            }
            if (this.tableToolTipText != null) {
                this.tableToolTipText.clear();
                this.tableToolTipText = null;
            }
            this.cellLabel = null;
            this.cellChecker = null;
            this.cellProgress = null;
            this.cellProgressFgc = null;
        }

        public ETableHeader getColumnHeader(int n) {
            if (EListBox.this.children.size() == 0) {
                return null;
            }
            if (n >= EListBox.this.children.size()) {
                return null;
            }
            return (ETableHeader)EListBox.this.children.get(n);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            EListBox eListBox = EListBox.this;
            int n3 = jTable.convertColumnIndexToModel(n2);
            this.cellLabel.setFont(EListBox.this.fontReference.getFontObject(eListBox));
            if (object instanceof EJTable.Value) {
                string = ((EJTable.Value)object).getValue();
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                string = null;
                this.setCellText("", n, n2);
            }
            if (string != null) {
                if (EListBox.this.children.size() == 0) {
                    Color color;
                    this.setCellText(string, n, n2);
                    this.cellLabel.setHorizontalAlignment(2);
                    this.margin = eListBox.cellMargin;
                    if (bl) {
                        if (EListBox.this.focusColor != null && bl2) {
                            this.cellLabel.setBackground(EListBox.this.focusColor);
                        } else {
                            this.cellLabel.setBackground(jTable.getSelectionBackground());
                        }
                        color = jTable.getSelectionForeground();
                    } else {
                        if (EListBox.this.bgColor2 != null && n % 2 == 1) {
                            this.cellLabel.setBackground(EListBox.this.bgColor2);
                        } else {
                            this.cellLabel.setBackground(jTable.getBackground());
                        }
                        color = EListBox.this.fgColor2 != null && n % 2 == 1 ? EListBox.this.fgColor2 : jTable.getForeground();
                    }
                    if (eListBox.getSensitive() == 0) {
                        this.cellLabel.setForeground(UiUtil.getFgcDisabled(color));
                    } else {
                        this.cellLabel.setForeground(color);
                    }
                } else {
                    if (n3 >= EListBox.this.children.size()) {
                        this.setCellText("", n, n2);
                        return this.cellLabel;
                    }
                    ETableHeader eTableHeader = (ETableHeader)EListBox.this.children.get(n3);
                    this.margin = eTableHeader.getCellMargin();
                    int n4 = eTableHeader.getColType();
                    if (n4 == 0 || n4 == 5 || n4 == 1 || n4 == 6) {
                        Color color;
                        this.setCellText(eTableHeader.getFormattedValue(string), n, n2);
                        switch (eTableHeader.getTextposCode()) {
                            case 0: {
                                this.cellLabel.setHorizontalAlignment(2);
                                break;
                            }
                            case 1: {
                                this.cellLabel.setHorizontalAlignment(0);
                                break;
                            }
                            case 2: {
                                this.cellLabel.setHorizontalAlignment(4);
                            }
                        }
                        if (bl) {
                            if (EListBox.this.focusColor != null && bl2) {
                                this.cellLabel.setBackground(EListBox.this.focusColor);
                            } else {
                                this.cellLabel.setBackground(jTable.getSelectionBackground());
                            }
                            color = jTable.getSelectionForeground();
                        } else {
                            if (EListBox.this.bgColor2 != null && n % 2 == 1) {
                                this.cellLabel.setBackground(EListBox.this.bgColor2);
                            } else {
                                this.cellLabel.setBackground(jTable.getBackground());
                            }
                            color = EListBox.this.fgColor2 != null && n % 2 == 1 ? EListBox.this.fgColor2 : jTable.getForeground();
                        }
                        if (eListBox.getSensitive() == 0) {
                            this.cellLabel.setForeground(UiUtil.getFgcDisabled(color));
                        } else {
                            this.cellLabel.setForeground(color);
                        }
                    } else {
                        if (n4 == 2) {
                            Color color;
                            this.cellChecker.setSelected(string.length() != 0 && !string.equals("0") && !string.equalsIgnoreCase("false"));
                            switch (eTableHeader.getTextposCode()) {
                                case 0: {
                                    this.cellChecker.setHorizontalAlignment(2);
                                    break;
                                }
                                case 1: {
                                    this.cellChecker.setHorizontalAlignment(0);
                                    break;
                                }
                                case 2: {
                                    this.cellChecker.setHorizontalAlignment(4);
                                }
                            }
                            if (bl) {
                                if (EListBox.this.focusColor != null && bl2) {
                                    this.cellChecker.setBackground(EListBox.this.focusColor);
                                } else {
                                    this.cellChecker.setBackground(jTable.getSelectionBackground());
                                }
                                color = jTable.getSelectionForeground();
                            } else {
                                if (EListBox.this.bgColor2 != null && n % 2 == 1) {
                                    this.cellChecker.setBackground(EListBox.this.bgColor2);
                                } else {
                                    this.cellChecker.setBackground(jTable.getBackground());
                                }
                                color = EListBox.this.fgColor2 != null && n % 2 == 1 ? EListBox.this.fgColor2 : jTable.getForeground();
                            }
                            if (eListBox.getSensitive() == 0) {
                                this.cellChecker.setForeground(UiUtil.getFgcDisabled(color));
                            } else {
                                this.cellChecker.setForeground(color);
                            }
                            return this.cellChecker;
                        }
                        if (n4 == 3) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                            try {
                                if (stringTokenizer.hasMoreTokens()) {
                                    int n5 = new Integer(stringTokenizer.nextToken());
                                    if (stringTokenizer.hasMoreTokens()) {
                                        int n6 = new Integer(stringTokenizer.nextToken());
                                        this.cellProgress.setMaximum(n6);
                                        this.cellProgress.setValue(n5);
                                        Color color = eListBox.getSensitive() == 0 ? UiUtil.getFgcDisabled(this.cellProgressFgc) : this.cellProgressFgc;
                                        this.cellProgress.setForeground(color);
                                        return this.cellProgress;
                                    }
                                }
                                this.setCellText("", n, n2);
                            }
                            catch (Exception exception) {
                                this.setCellText("####", n, n2);
                            }
                        }
                    }
                }
            }
            return this.cellLabel;
        }

        private void setCellText(String string, int n, int n2) {
            try {
                this.cellLabel.setText(string);
            }
            catch (Throwable throwable) {
                System.err.println("'" + EListBox.this.getPath() + "' " + throwable + ": ListBox[" + n + "," + EListBox.this.table.convertColumnIndexToModel(n2) + "] = \"" + string + "\"");
                this.cellLabel.setText(HtmlTool.text(string));
            }
        }

        public void setClear() {
            this.tableRows.clear();
            if (this.tableRowData != null) {
                this.tableRowData.clear();
                this.tableRowData = null;
            }
            if (this.tableToolTipText != null) {
                this.tableToolTipText.clear();
                this.tableToolTipText = null;
            }
        }

        public void addColumn(int n) {
            if (EListBox.this.children.size() == 0) {
                this.tableRows.removeElementAt(0);
            }
            for (int i = 0; i < this.tableRows.size(); ++i) {
                ((Vector)this.tableRows.get(i)).insertElementAt(new String(""), n);
            }
            this.tableSorting.insertElementAt(new Boolean(true), n);
        }

        public void removeColumn(int n) {
            if (n >= 0 && n < EListBox.this.children.size()) {
                for (int i = 0; i < this.tableRows.size(); ++i) {
                    ((Vector)this.tableRows.get(i)).removeElementAt(n);
                }
                this.tableSorting.removeElementAt(n);
                if (EListBox.this.children.size() == 0) {
                    this.tableRows.add(this.tableSingleRow);
                }
            }
        }

        public boolean getColumnSorting(int n) {
            return (Boolean)this.tableSorting.get(n);
        }

        public void setColumnSorting(int n, boolean bl) {
            this.tableSorting.set(n, new Boolean(bl));
        }

        public void clrHeader() {
            this.tableHeader = new Vector();
        }

        public void setRow(Vector vector, int n) {
            this.fitRow(vector);
            this.tableRows.setElementAt(vector, n);
        }

        public void setRowData(UnifiedData unifiedData, int n) {
            int n2;
            if (this.tableRowData == null) {
                this.tableRowData = new Vector();
                n2 = 0;
            } else {
                n2 = this.tableRowData.size();
            }
            if (n >= n2) {
                this.tableRowData.setSize(n + 1);
            }
            this.tableRowData.setElementAt(unifiedData, n);
        }

        public UnifiedData getRowData(int n) {
            return this.tableRowData != null && n < this.tableRowData.size() ? (UnifiedData)this.tableRowData.get(n) : null;
        }

        public boolean setToolTipText(String string, int n) {
            int n2;
            if (string != null && string.length() != 0) {
                int n3;
                if (this.tableToolTipText == null) {
                    this.tableToolTipText = new Vector();
                    n3 = 0;
                } else {
                    n3 = this.tableToolTipText.size();
                }
                if (n >= n3) {
                    this.tableToolTipText.setSize(n + 1);
                }
                this.tableToolTipText.setElementAt(string, n);
                return n3 == 0;
            }
            if (this.tableToolTipText != null && n < (n2 = this.tableToolTipText.size())) {
                int n4;
                for (n4 = 0; n4 < n2 && (n4 == n || this.tableToolTipText.get(n4) == null); ++n4) {
                }
                if (n4 == n2) {
                    this.tableToolTipText.clear();
                    this.tableToolTipText = null;
                    return true;
                }
                this.tableToolTipText.setElementAt(null, n);
            }
            return false;
        }

        public String getToolTipText(int n) {
            return this.tableToolTipText != null && n < this.tableToolTipText.size() ? (String)this.tableToolTipText.get(n) : null;
        }

        private void fitRow(Vector vector) {
            int n = EListBox.this.children.size();
            if (n == 0) {
                n = 1;
            }
            while (vector.size() > n) {
                vector.removeElementAt(vector.size() - 1);
            }
            while (vector.size() < n) {
                vector.add("");
            }
        }

        public void addRow(Vector vector) {
            this.fitRow(vector);
            this.tableRows.add(vector);
        }

        public void insertRow(Vector vector, int n) {
            this.fitRow(vector);
            this.tableRows.add(n, vector);
        }

        public void deleteRow(int n) {
            int n2;
            this.tableRows.removeElementAt(n);
            if (this.tableRowData != null && n < (n2 = this.tableRowData.size())) {
                this.tableRowData.removeElementAt(n);
                if (n2 == 1) {
                    this.tableRowData = null;
                }
            }
            if (this.tableToolTipText != null && n < (n2 = this.tableToolTipText.size())) {
                this.tableToolTipText.removeElementAt(n);
                if (n2 == 1) {
                    this.tableToolTipText = null;
                }
            }
        }

        public int getColumnCount() {
            int n = EListBox.this.children.size();
            return n == 0 ? 1 : n;
        }

        public String getColumnName(int n) {
            if (EListBox.this.children.size() > 0) {
                try {
                    return ((ETableHeader)EListBox.this.children.get(n)).getTitle();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "";
        }

        public int getRowCount() {
            return this.tableRows.size();
        }

        public int getSelectedRow() {
            return EListBox.this.tsorter.modelIndex(EListBox.this.table.getSelectedRow());
        }

        public void setSelectedRow(int n) {
            Point point = new Point(EListBox.this.sp.getHorizontalScrollBar().getValue(), 0);
            EListBox.this.table.changeSelection(n, EListBox.this.table.columnAtPoint(point), false, false);
        }

        public int getColumnType(int n) {
            return ((ETableHeader)EListBox.this.children.get(n)).getColType();
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            try {
                String string = (String)((Vector)this.tableRows.get(n)).get(n2);
                if (EListBox.this.border > 0 && EListBox.this.children.size() == 0) {
                    return " " + string;
                }
                return string;
            }
            catch (Exception exception) {
                return "";
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < this.tableRows.size() && n2 < this.getColumnCount()) {
                ((Vector)this.tableRows.get(n)).set(n2, object.toString());
            }
        }

        public EListBox listBox() {
            return EListBox.this;
        }

        private final class CellBorder
        implements Border {
            private CellBorder() {
            }

            public Insets getBorderInsets(Component component) {
                return new Insets(0, EJTableModel.this.margin, 0, EJTableModel.this.margin);
            }

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            }
        }
    }

    private static class Defaults {
        private boolean initialized = false;
        private Border border = null;
        private Border focusBorder = null;

        private Defaults() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(JScrollPane jScrollPane) {
            Defaults defaults = this;
            synchronized (defaults) {
                if (!this.initialized) {
                    this.initialized = true;
                    this.border = jScrollPane.getBorder();
                    if (this.border != null) {
                        this.focusBorder = new FocusBorder(this.border);
                    }
                }
            }
        }

        public void setBorder(JScrollPane jScrollPane) {
            if (!this.initialized) {
                this.initialize(jScrollPane);
            }
            if (this.border != null && this.focusBorder != null) {
                jScrollPane.setBorder(this.border);
            }
        }

        public void setFocusBorder(JScrollPane jScrollPane) {
            if (!this.initialized) {
                this.initialize(jScrollPane);
            }
            if (this.border != null && this.focusBorder != null) {
                jScrollPane.setBorder(this.focusBorder);
            }
        }

        private static class FocusBorder
        implements Border {
            Border border;
            Color focusColor;
            Stroke dottedStroke;

            public FocusBorder(Border border) {
                this.border = border;
                this.focusColor = UIManager.getColor("CheckBox.focus");
                if (this.focusColor == null) {
                    this.focusColor = Color.BLACK;
                }
                float[] fArray = new float[2];
                fArray[1] = 1.0f;
                fArray[0] = 1.0f;
                this.dottedStroke = new BasicStroke(1.0f, 0, 2, 1.0f, fArray, 0.0f);
            }

            public Insets getBorderInsets(Component component) {
                return this.border.getBorderInsets(component);
            }

            public boolean isBorderOpaque() {
                return this.border.isBorderOpaque();
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                this.border.paintBorder(component, graphics, n, n2, n3, n4);
                if (component instanceof JScrollPane) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.drawRect(n, n2, --n3, --n4);
                    graphics2D.setStroke(this.dottedStroke);
                    graphics2D.setColor(this.focusColor);
                    graphics2D.drawRect(n, n2, n3, n4);
                    graphics2D.dispose();
                }
            }
        }
    }

    private final class DragDrop
    implements DragDropHandler {
        private DragDrop() {
        }

        public void enableDrag(boolean bl) {
            EListBox.this.table.setDragEnabled(bl);
        }

        public JComponent getDragComponent() {
            return EListBox.this.table;
        }

        public void beginDrag() {
            EListBox.this.inDrag = true;
            EListBox.this.dragSaveSelectedRow = EListBox.this.table.getSelectedRow();
        }

        public void dragStarting(InputEvent inputEvent) {
            if (EListBox.this.children.size() != 0) {
                EListBox.this.activeColumn = EListBox.this.table.convertColumnIndexToModel(EListBox.this.table.getSelectedColumn());
            } else {
                EListBox.this.activeColumn = -1;
            }
        }

        public void dragFinished(int n) {
        }

        public void dragCanceled() {
            if (EListBox.this.getSensitive() != 0) {
                if (EListBox.this.singleclick == 1 || EListBox.this.singleclick == 3) {
                    if (EListBox.this.rule != 0) {
                        EListBox.this.getRuleManager().fireRule(EListBox.this);
                    }
                } else {
                    EListBox.this.getRuleManager().cancelOverride();
                }
            }
        }

        public void endDrag() {
            if (EListBox.this.dragSaveSelectedRow >= 0) {
                EListBox.this.table.setRowSelectionInterval(EListBox.this.dragSaveSelectedRow, EListBox.this.dragSaveSelectedRow);
                EListBox.this.table.scrollRectToVisible(EListBox.this.table.getCellRect(EListBox.this.dragSaveSelectedRow, 0, true));
            } else {
                EListBox.this.table.clearSelection();
            }
            EListBox.this.inDrag = false;
        }

        public boolean acceptDrop(TransferHandler.TransferSupport transferSupport) {
            if (EListBox.this.acceptValidDropOnly) {
                JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
                if (dropLocation.getRow() == -1) {
                    return false;
                }
                if (EListBox.this.children.size() != 0 && dropLocation.getColumn() == -1) {
                    return false;
                }
            }
            return true;
        }

        public boolean dropped(TransferHandler.TransferSupport transferSupport) {
            JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
            EListBox.this.dropLine = dropLocation.getRow();
            if (EListBox.this.acceptValidDropOnly && EListBox.this.dropLine == -1) {
                return false;
            }
            EListBox.this.dropLine = EListBox.this.tsorter.modelIndex(EListBox.this.dropLine) + 1;
            if (EListBox.this.children.size() != 0) {
                EListBox.this.dropColumn = dropLocation.getColumn();
                if (EListBox.this.acceptValidDropOnly && EListBox.this.dropColumn == -1) {
                    return false;
                }
                EListBox.this.dropColumn = EListBox.this.table.convertColumnIndexToModel(EListBox.this.dropColumn);
            } else {
                EListBox.this.dropColumn = -1;
            }
            return true;
        }
    }

    private final class SingleClickTimer
    implements ActionListener {
        private SingleClickTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StartUp.delay.singleClickTimer != null && EListBox.this.rule != 0) {
                EListBox.this.getRuleManager().fireRule(EListBox.this);
            }
        }
    }
}

