/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.EApplication;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.jdlg.controls.ESystem;
import com.eloquence.services.jdlg.controls.EWindow;
import com.eloquence.services.tools.FontReference;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.SafeRunnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EPopupBox
extends AbstractControl
implements EWindow,
Runnable,
WindowListener,
WindowFocusListener,
KeyListener {
    private EApplication eapplication = null;
    private ControlsManager cmgr = null;
    private String title = "Eloquence";
    private String[] bodyTextLines = null;
    private String[] buttonsTexts = null;
    private InverseButton[] buttons = null;
    private int defaultButtonNo = 0;
    private int selectedButtonNo = -1;
    private JButton requestButton = null;
    private final Insets textDefaultInsets = new Insets(3, 2, 3, 2);
    private final Insets buttonDefaultInsets = new Insets(2, 3, 2, 3);
    private Insets textinsets = (Insets)this.textDefaultInsets.clone();
    private Insets buttoninsets = (Insets)this.buttonDefaultInsets.clone();

    public EPopupBox() {
        this.setX(-1);
        this.setY(-1);
        SafeRunnable.execute(new SafeRunnable(){

            public void runSafe() {
                PopupBoxWindow popupBoxWindow = new PopupBoxWindow();
                popupBoxWindow.addWindowListener(EPopupBox.this);
                popupBoxWindow.addWindowFocusListener(EPopupBox.this);
                EPopupBox.this.peer = popupBoxWindow;
            }
        });
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            int n;
            JFrame jFrame = (JFrame)this.peer;
            Container container = jFrame.getContentPane();
            if (this.buttons != null) {
                for (n = 0; n < this.buttons.length; ++n) {
                    container.remove(this.buttons[n]);
                    this.buttons[n].resetKeyboardActions();
                    this.buttons[n].setMnemonic(0);
                    this.buttons[n].removeActionListener(this);
                    this.buttons[n].removeKeyListener(this);
                    this.buttons[n].dispose();
                    this.buttons[n] = null;
                }
            }
            if (this.bodyTextLines != null) {
                for (n = 0; n < this.bodyTextLines.length; ++n) {
                    this.bodyTextLines[n] = null;
                }
            }
            if (this.buttonsTexts != null) {
                for (n = 0; n < this.buttonsTexts.length; ++n) {
                    this.buttonsTexts[n] = null;
                }
            }
            container.setLayout(null);
            jFrame.removeWindowListener(this);
            jFrame.removeWindowFocusListener(this);
            jFrame.setIconImage(null);
            ESystem.typeAhead.allowEvents(false, jFrame);
            this.cmgr = null;
            this.eapplication = null;
            this.title = null;
            this.bodyTextLines = null;
            this.buttonsTexts = null;
            this.buttons = null;
            this.requestButton = null;
            super.dispose();
        }
    }

    public void eloq2swing(boolean bl) {
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        int n;
        int n2;
        Dimension dimension;
        Cloneable cloneable;
        this.fontReference = new FontReference(StartUp.getDefaultFont());
        Font font = this.fontReference.getFontObject(1.0);
        FontMetrics fontMetrics = null;
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        double d = ruleManager.getPopupBoxScaleFactor();
        Font font2 = this.fontReference.getFontObject(d);
        JFrame jFrame = (JFrame)this.peer;
        this.createControls(jFrame, font2);
        if (jFrame.getIconImage() == null) {
            try {
                EApplication eApplication = this.getEApplication();
                if (eApplication.defaultIcon != null) {
                    jFrame.setIconImage(jFrame.getToolkit().getImage(new URL(eApplication.defaultIcon)));
                } else {
                    jFrame.setIconImage(jFrame.getToolkit().getImage(StartUp.getLogoIconUrl()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        jFrame.pack();
        jFrame.setResizable(false);
        if (this.title != null && this.title.length() > 0 && (this.bodyTextLines == null || this.bodyTextLines.length == 0)) {
            if (fontMetrics == null) {
                fontMetrics = this.getFontMetrics(jFrame, font);
            }
            int n3 = fontMetrics.stringWidth(this.title);
            cloneable = jFrame.getSize();
            jFrame.setSize(((Dimension)cloneable).width + n3, ((Dimension)cloneable).height);
            jFrame.validate();
        }
        if ((cloneable = ruleManager.getRefPos()) == null) {
            dimension = null;
        } else {
            dimension = ruleManager.getRefSize();
            if (dimension == null) {
                cloneable = null;
            }
        }
        if (dimension != null) {
            Dimension dimension2 = jFrame.getSize();
            n2 = cloneable.x + (dimension.width - dimension2.width) / 2;
            n = cloneable.y + (dimension.height - dimension2.height) / 2;
            Point point = ruleManager.getRefPoint();
            if (point != null) {
                n2 += point.x;
                n += point.y;
            }
        } else if (this.xPos == 0 && this.yPos == 0 || this.xPos == -1 && this.yPos == -1) {
            Rectangle rectangle = this.getScreenBounds(jFrame);
            Dimension dimension3 = jFrame.getSize();
            n2 = rectangle.x + (rectangle.width - dimension3.width) / 2;
            n = rectangle.y + (rectangle.height - dimension3.height) / 2;
        } else {
            if (fontMetrics == null) {
                fontMetrics = this.getFontMetrics(jFrame, font);
            }
            int n4 = fontMetrics.stringWidth("X") + 1;
            int n5 = fontMetrics.getHeight() + 4;
            n2 = this.xPos * n4;
            n = this.yPos * n5;
            Point point = ruleManager.getRefPoint();
            if (point != null) {
                n2 += point.x;
                n += point.y;
            }
        }
        jFrame.setLocation(n2, n);
        ruleManager.requestTopMostWindow(this);
        ruleManager.validateTopMostWindow();
        ESystem.typeAhead.allowEvents(true, jFrame);
        jFrame.setVisible(true);
    }

    private final Rectangle getScreenBounds(JFrame jFrame) {
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = jFrame.getToolkit().getScreenInsets(graphicsConfiguration);
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }

    private final FontMetrics getFontMetrics(JFrame jFrame, Font font) {
        Graphics graphics = jFrame.getGraphics();
        if (graphics != null) {
            return graphics.getFontMetrics(font);
        }
        return null;
    }

    public void setEApplication(EApplication eApplication) {
        this.eapplication = eApplication;
    }

    protected EApplication getEApplication() {
        return this.eapplication;
    }

    public final boolean isVisible() {
        return this.peer.isVisible();
    }

    public final void windowToFront(boolean bl) {
        if (this.peer instanceof JFrame) {
            int n;
            JFrame jFrame = (JFrame)this.peer;
            if (!jFrame.isActive()) {
                jFrame.toFront();
            }
            if (bl && ((n = jFrame.getExtendedState()) & 1) == 1) {
                jFrame.setExtendedState(n &= 0xFFFFFFFE);
            }
        }
    }

    public final void onNotify(String string, String string2, boolean bl) {
        EDialog eDialog = this.getRuleManager().getTopDialog(!bl);
        if (eDialog != null) {
            eDialog.onNotify(string, string2, bl);
        }
    }

    private void createControls(JFrame jFrame, Font font) {
        JComponent jComponent;
        Object object;
        int n;
        jFrame.setFont(font);
        if (this.title != null && this.title.length() > 0) {
            jFrame.setTitle(this.title);
        } else {
            jFrame.setTitle("Eloquence");
        }
        Container container = jFrame.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = this.buttonsTexts.length > 0 ? this.buttonsTexts.length : 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = this.textinsets;
        gridBagConstraints.anchor = 17;
        int n2 = 0;
        for (n = 0; n < this.bodyTextLines.length; ++n) {
            if (n2 >= this.bodyTextLines[n].length()) continue;
            n2 = this.bodyTextLines[n].length();
        }
        for (n = 0; n < this.bodyTextLines.length; ++n) {
            gridBagConstraints.gridy = n;
            object = this.bodyTextLines[n];
            try {
                jComponent = new JLabel((String)object);
                jComponent.setFont(font);
                jComponent.setForeground(Color.black);
            }
            catch (Throwable throwable) {
                System.err.println(throwable.toString() + ": POPUP BOX line " + (n + 1) + " = \"" + (String)object + "\"");
                jComponent = new JLabel(HtmlTool.text((String)object));
                jComponent.setFont(font);
                jComponent.setForeground(Color.black);
            }
            gridBagLayout.addLayoutComponent(jComponent, gridBagConstraints);
            container.add((Component)jComponent, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = this.buttoninsets;
        gridBagConstraints.anchor = 10;
        this.buttons = new InverseButton[this.buttonsTexts.length];
        for (n = 0; n < this.buttonsTexts.length; ++n) {
            gridBagConstraints.gridx = n;
            object = this.buttonsTexts[n];
            boolean bl = ESystem.getPopupboxinversvideo() != 0;
            try {
                jComponent = new InverseButton((String)object, bl);
            }
            catch (Throwable throwable) {
                System.err.println(throwable.toString() + ": POPUP BOX button " + (n + 1) + " = \"" + (String)object + "\"");
                jComponent = new InverseButton(HtmlTool.text((String)object), bl);
            }
            this.buttons[n] = jComponent;
            ((AbstractButton)jComponent).setActionCommand((String)object);
            char[] cArray = HtmlTool.text((String)object).toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (!Character.isLetterOrDigit(c)) continue;
                ((AbstractButton)jComponent).setMnemonic(c);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
                InputMap inputMap = jComponent.getInputMap(2);
                inputMap.put(keyStroke, object);
                int n3 = keyStroke.getKeyCode();
                if (n3 >= 48 && n3 <= 57) {
                    keyStroke = KeyStroke.getKeyStroke(n3 += 48, 0);
                    inputMap.put(keyStroke, "KEY_ACCELERATOR_ACTION_CMD");
                }
                jComponent.getActionMap().put(object, new AccelAction((String)object));
                break;
            }
            gridBagLayout.addLayoutComponent(jComponent, gridBagConstraints);
            container.add((Component)jComponent, gridBagConstraints);
            ((AbstractButton)jComponent).addActionListener(this);
            jComponent.addKeyListener(this);
            if (n == this.defaultButtonNo || n == 0) {
                this.requestButton = jComponent;
                this.selectedButtonNo = n;
            }
            jComponent.setFont(font);
        }
        if (ESystem.getPopupboxwider() != 0 && this.title.length() > 0) {
            int n4 = n = this.bodyTextLines.length == 0 ? 1 : 0;
            if (n == 0) {
                for (int i = 0; n == 0 && i < this.bodyTextLines.length; ++i) {
                    if (this.bodyTextLines[i].length() > this.title.length()) continue;
                    n = 1;
                }
            }
            if (n != 0) {
                int n5 = 0;
                n5 = StartUp.running_on_windows ? this.title.length() + 10 : this.title.length();
                if (n5 >= 20) {
                    n5 = 10;
                }
                if (n5 % 2 != 0) {
                    ++n5;
                }
                object = new JPanel(new BorderLayout());
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n5 / 2; i >= 0; --i) {
                    stringBuffer.append('X');
                }
                JLabel jLabel = new JLabel(stringBuffer.toString());
                JLabel jLabel2 = new JLabel(stringBuffer.toString());
                ((Container)object).add((Component)jLabel, "West");
                ((Container)object).add((Component)jLabel2, "East");
                ((Container)object).add((Component)container, "Center");
                jFrame.setContentPane((Container)object);
                jLabel.setForeground(jLabel.getBackground());
                jLabel2.setForeground(jLabel2.getBackground());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        for (int i = 0; i < this.buttonsTexts.length; ++i) {
            if (!this.buttonsTexts[i].equals(string)) continue;
            this.selectedButtonNo = i + 1;
            break;
        }
        JFrame jFrame = (JFrame)this.peer;
        ESystem.typeAhead.allowEvents(false, jFrame);
        jFrame.setVisible(false);
        this.cmgr.continuePopupBoxOperation();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.peer.getToolkit().beep();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        JFrame jFrame;
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (this.peer instanceof JFrame) {
            jFrame = (JFrame)this.peer;
            ESystem.typeAhead.setTopWindow(jFrame, ruleManager);
            ESystem.typeAhead.clear();
        } else {
            jFrame = null;
        }
        if (ruleManager != null) {
            ruleManager.validateTopMostWindow();
        }
        if (this.requestButton != null && jFrame != null && jFrame.isFocused()) {
            this.requestFocusInWindow(this.requestButton);
            this.requestButton = null;
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        if (this.requestButton != null) {
            this.requestFocusInWindow(this.requestButton);
            this.requestButton = null;
        }
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private final boolean isToLeftNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 38: 
            case 224: 
            case 226: {
                return true;
            }
        }
        return false;
    }

    private final boolean isToRightNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: 
            case 40: 
            case 225: 
            case 227: {
                return true;
            }
        }
        return false;
    }

    private final int getButtonIndex(KeyEvent keyEvent) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (keyEvent.getSource() != this.buttons[i]) continue;
            return i;
        }
        return -1;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.buttons != null) {
            int n;
            if (this.isToRightNavigationKey(keyEvent)) {
                int n2 = this.getButtonIndex(keyEvent);
                if (n2 >= 0) {
                    if (++n2 == this.buttons.length) {
                        n2 = 0;
                    }
                    this.requestFocusInWindow(this.buttons[n2]);
                    return;
                }
            } else if (this.isToLeftNavigationKey(keyEvent) && (n = this.getButtonIndex(keyEvent)) >= 0) {
                if (--n == -1) {
                    n = this.buttons.length - 1;
                }
                this.requestFocusInWindow(this.buttons[n]);
                return;
            }
        }
        super.keyReleased(keyEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\n' && c != ' ') {
            char c2 = Character.toLowerCase(c);
            for (int i = 0; this.buttons != null && i < this.buttons.length; ++i) {
                char c3 = Character.toLowerCase((char)this.buttons[i].getMnemonic());
                if (c3 != c2) continue;
                this.buttons[i].doClick();
                return;
            }
            return;
        }
        try {
            JButton jButton = (JButton)keyEvent.getSource();
            if (jButton == null) return;
            jButton.doClick();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getClassName() {
        return null;
    }

    public void setTitle(String string) {
        this.title = this.filterASCIIHighlightChars(string);
    }

    public String getTitle() {
        return this.title;
    }

    public void setBodyTextLines(String[] stringArray) {
        this.bodyTextLines = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.bodyTextLines[i] = this.filterASCIIHighlightChars(stringArray[i]);
        }
    }

    public String[] getBodyTextLines() {
        return this.bodyTextLines;
    }

    public void setButtonsTexts(String[] stringArray) {
        this.buttonsTexts = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.buttonsTexts[i] = this.filterASCIIHighlightChars(stringArray[i]);
        }
    }

    public String[] getButtonsTexts() {
        return this.buttonsTexts;
    }

    public void setDefaultButtonNo(int n) {
        this.defaultButtonNo = n - 1;
    }

    public int getDefaultButtonNo() {
        return this.defaultButtonNo;
    }

    public int getSelectedButtonNo() {
        return this.selectedButtonNo;
    }

    public void setControlsManager(ControlsManager controlsManager) {
        this.cmgr = controlsManager;
    }

    public ControlsManager.RuleManager getRuleManager() {
        return this.cmgr != null ? this.cmgr.getRuleManager() : null;
    }

    class PopupBoxWindow
    extends JFrame {
        public PopupBoxWindow() {
            this.setDefaultCloseOperation(0);
        }
    }

    private class InverseButton
    extends JButton
    implements FocusListener {
        private boolean inverse;

        public void focusGained(FocusEvent focusEvent) {
            if (this.inverse) {
                Color color = null;
                color = this.getForeground();
                this.setForeground(this.getBackground());
                this.setBackground(color);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }

        public InverseButton(String string, boolean bl) {
            super(string);
            this.inverse = false;
            this.inverse = bl;
            this.addFocusListener(this);
        }

        public void dispose() {
            this.removeFocusListener(this);
        }

        public void finalize() {
            this.dispose();
        }
    }

    class AccelAction
    extends AbstractAction {
        public AccelAction(String string) {
            this.putValue("ActionCommandKey", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EPopupBox.this.actionPerformed(actionEvent);
        }
    }
}

