/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.protocols.dlg.Dlg;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.JProgressBar;

public class EProgressBar
extends AbstractControl {
    private static HashMap attributeList = new HashMap();
    private static final int VALUE_ATTR_ID = 0;
    private static final int MIN_ATTR_ID = 1;
    private static final int MAX_ATTR_ID = 2;
    private static final int DIRECTION_ATTR_ID = 3;
    private static final int ORIENTATION_ATTR_ID = 4;
    private static final int TEXT_ATTR_ID = 5;
    private static final int INDETERMINATE_ATTR_ID = 6;
    public static final String CLASS_ATTR_NAME = "ProgressBar";
    public static final String VALUE_ATTR_NAME = "value";
    private int value = 0;
    public static final String MIN_ATTR_NAME = "min";
    private int minimum = 0;
    public static final String MAX_ATTR_NAME = "max";
    private int maximum = 100;
    public static final String DIRECTION_ATTR_NAME = "direction";
    private int orientation = 0;
    public static final String ORIENTATION_ATTR_NAME = "orientation";
    public static final String INDETERMINATE_ATTR_NAME = "indeterminate";
    private boolean indeterminate = false;
    public static final String TEXT_ATTR_NAME = "text";
    private String pattern = null;
    private boolean isPatternModified = false;

    public EProgressBar() {
        this.peer = new EJProgressBar();
        this.peer.setFont(StartUp.getDefaultFont());
        if (attributeList.isEmpty()) {
            attributeList.put(VALUE_ATTR_NAME, new Integer(0));
            attributeList.put(MIN_ATTR_NAME, new Integer(1));
            attributeList.put(MAX_ATTR_NAME, new Integer(2));
            attributeList.put(DIRECTION_ATTR_NAME, new Integer(3));
            attributeList.put(ORIENTATION_ATTR_NAME, new Integer(4));
            attributeList.put(TEXT_ATTR_NAME, new Integer(5));
            attributeList.put(INDETERMINATE_ATTR_NAME, new Integer(6));
        }
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setValue(sET.getValueInt());
                    break;
                }
                case 1: {
                    this.setMinimum(sET.getValueInt());
                    break;
                }
                case 2: {
                    this.setMaximum(sET.getValueInt());
                    break;
                }
                case 3: {
                    this.setDirection(sET.getValueInt());
                    break;
                }
                case 4: {
                    this.setOrientation(sET.getValueInt());
                    break;
                }
                case 5: {
                    this.setText(sET.getValueString());
                    break;
                }
                case 6: {
                    this.setIndeterminate(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueInt(this.getValue());
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getMinimum());
                    break;
                }
                case 2: {
                    gET2.setValueInt(this.getMaximum());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getDirection());
                    break;
                }
                case 4: {
                    gET2.setValueInt(this.getOrientation());
                    break;
                }
                case 5: {
                    gET2.setValueString(this.getText());
                    break;
                }
                case 6: {
                    gET2.setValueInt(this.getIndeterminate());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public Object clone() {
        EProgressBar eProgressBar = new EProgressBar();
        this.cloneAttributes(eProgressBar);
        return eProgressBar;
    }

    protected final void cloneAttributes(EProgressBar eProgressBar) {
        super.cloneAttributes(eProgressBar);
        eProgressBar.setValue(this.getValue());
        eProgressBar.setMinimum(this.getMinimum());
        eProgressBar.setMaximum(this.getMaximum());
        eProgressBar.setDirection(this.getDirection());
        eProgressBar.setIndeterminate(this.getIndeterminate());
        if (this.pattern != null) {
            eProgressBar.setText(this.getText());
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
        }
    }

    public void eloq2swing(boolean bl) {
        if (this.isModified || this.isPatternModified) {
            JProgressBar jProgressBar = (JProgressBar)this.peer;
            if (this.isModified) {
                if (this.indeterminate != jProgressBar.isIndeterminate()) {
                    jProgressBar.setIndeterminate(this.indeterminate);
                }
                if (this.minimum != jProgressBar.getValue()) {
                    jProgressBar.setMinimum(this.minimum);
                }
                if (this.maximum != jProgressBar.getMaximum()) {
                    jProgressBar.setMaximum(this.maximum);
                }
                if (this.value != jProgressBar.getValue()) {
                    jProgressBar.setValue(this.value);
                }
                if (this.orientation != jProgressBar.getOrientation()) {
                    jProgressBar.setOrientation(this.orientation);
                }
            }
            if (this.isPatternModified) {
                this.isPatternModified = false;
                jProgressBar.setString(jProgressBar.getString());
            }
        }
        super.eloq2swing(bl);
    }

    public void eloq2swingText() {
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public int getGenuineWidth() {
        return this.peer.getMinimumSize().width;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public String getContent() {
        return this.getText();
    }

    public void setContent(String string) {
        this.setText(string);
    }

    public void setValue(int n) {
        this.value = n;
        this.isModified = true;
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int n) {
        this.minimum = n;
        this.isModified = true;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int n) {
        this.maximum = n;
        this.isModified = true;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setDirection(int n) {
        this.orientation = n != 0 ? 0 : 1;
        this.isModified = true;
    }

    public int getDirection() {
        return this.orientation == 0 ? 1 : 0;
    }

    public void setOrientation(int n) {
        this.orientation = n != 0 ? 1 : 0;
        this.isModified = true;
    }

    public int getOrientation() {
        return this.orientation == 1 ? 1 : 0;
    }

    public void setIndeterminate(int n) {
        this.indeterminate = n != 0;
        this.isModified = true;
    }

    public int getIndeterminate() {
        return this.indeterminate ? 1 : 0;
    }

    public void setText(String string) {
        this.pattern = string.length() == 0 ? null : string;
        this.isPatternModified = true;
    }

    public String getText() {
        return this.pattern;
    }

    class EJProgressBar
    extends JProgressBar {
        public EJProgressBar() {
            this.setValue(0);
            this.setMinimum(0);
            this.setMaximum(100);
            this.setStringPainted(true);
        }

        public String getString() {
            if (EProgressBar.this.pattern == null) {
                return super.getString();
            }
            return EProgressBar.this.pattern.replaceAll("%%", new DecimalFormat("#0").format(100.0 * this.getPercentComplete()) + "%");
        }
    }
}

