/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractButtonControl;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.PositionInterface;
import com.eloquence.services.jdlg.controls.TextPositionSetter;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.GraphicsTool;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class EPushButton
extends AbstractButtonControl
implements ActionListener,
MouseListener {
    private static Color plafBgc = null;
    public static final String CLASS_ATTR_NAME = "PushButton";
    private String origText = "";
    private static final String BORDER_ATTR_NAME = "border";
    private static final String ICONURL_ATTR_NAME = "icon";
    private PushButtonIcon icon = null;
    private URL urlIcon = null;
    private boolean modifiedIcon = false;
    private static final String ICONPRESSED_ATTR_NAME = "iconpressed";
    private PushButtonIcon iconPressed = null;
    private URL urlIconPressed = null;
    private boolean modifiedIconPressed = false;
    private static final String TEXTPOS_ATTR_NAME = "textpos";
    private String textpos = "";
    private boolean modifiedTextPos = false;
    private static final int BORDER_ATTR_ID = 0;
    private static final int ICONURL_ATTR_ID = 1;
    private static final int ICONPRESSED_ATTR_ID = 2;
    private static final int TEXTPOS_ATTR_ID = 3;
    private static final String ADJUST_ATTR_NAME = "adjust";
    private static final int ADJUST_ATTR_ID = 4;
    private static HashMap attributeList = new HashMap();

    public EPushButton() {
        EJButton eJButton = new EJButton();
        eJButton.addActionListener(this);
        eJButton.addKeyListener(this);
        eJButton.setDefaultCapable(false);
        eJButton.setFont(StartUp.getDefaultFont());
        eJButton.setFocusTraversalKeysEnabled(false);
        if (plafBgc == null) {
            plafBgc = eJButton.getBackground();
        }
        this.peer = eJButton;
        this.setSensitive(1);
        this.ruleOverride = true;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            EJButton eJButton = (EJButton)this.peer;
            eJButton.removeActionListener(this);
            eJButton.removeKeyListener(this);
            eJButton.removeMouseListener(this);
            super.dispose();
            this.origText = null;
            this.textpos = null;
            if (this.icon != null) {
                this.icon.dispose();
                this.icon = null;
            }
            this.urlIcon = null;
            if (this.iconPressed != null) {
                this.iconPressed.dispose();
                this.iconPressed = null;
            }
            this.urlIconPressed = null;
        }
    }

    public Object clone() {
        EPushButton ePushButton = new EPushButton();
        this.cloneAttributes(ePushButton);
        return ePushButton;
    }

    public void cloneAttributes(EPushButton ePushButton) {
        super.cloneAttributes(ePushButton);
        ePushButton.setBorder(this.getBorder());
        ePushButton.setIconurl(this.getIconurl());
        ePushButton.setIconPressed(this.getIconPressed());
        ePushButton.setTextpos(this.getTextpos());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setBorder(sET.getValueInt());
                    break;
                }
                case 1: {
                    this.setIconurl(sET.getValueString());
                    break;
                }
                case 2: {
                    this.setIconPressed(sET.getValueString());
                    break;
                }
                case 3: {
                    this.setTextpos(sET.getValueString());
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueInt(this.getBorder());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getIconurl());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getIconPressed());
                    break;
                }
                case 3: {
                    gET2.setValueString(this.getTextpos());
                    break;
                }
                case 4: {
                    gET2.setValueInt(0);
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (ruleManager != null) {
            if (ruleManager.getFocus() == this) {
                if (this.focusColor != null) {
                    this.overrideBackground = true;
                    this.peer.setBackground(this.focusColor);
                }
                this.requestFocusInWindow(this.peer);
            } else {
                this.overrideBackground = false;
            }
        }
        if (this.isModified) {
            EJButton eJButton = (EJButton)this.peer;
            if (this.modifiedIcon) {
                eJButton.setIcon(this.icon);
                this.modifiedIcon = false;
            }
            if (this.modifiedIconPressed) {
                eJButton.setPressedIcon(this.iconPressed);
                this.modifiedIconPressed = false;
            }
            if (this.modifiedTextPos && this.icon != null && this.textpos.length() > 0) {
                new TextPositionSetter(eJButton, this.textpos).execute();
                this.modifiedTextPos = false;
            }
        }
        super.eloq2swing(bl);
    }

    public void eloq2swingText() {
        EJButton eJButton = (EJButton)this.peer;
        if (!this.text.equals(eJButton.getText())) {
            try {
                eJButton.setText(this.text);
            }
            catch (Throwable throwable) {
                System.err.println("'" + this.getPath() + "' " + throwable + ": PushButton = \"" + this.text + "\"");
                eJButton.setText(HtmlTool.text(this.text));
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.consumeRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        if (this.consumeInputEvent(mouseEvent)) {
            return;
        }
        super.mouseReleased(mouseEvent);
    }

    public void focusReceived(AbstractControl abstractControl) {
        if (this.focusColor != null) {
            this.overrideBackground = true;
            this.peer.setBackground(this.focusColor);
        }
        super.focusReceived(abstractControl);
    }

    public void focusLost(AbstractControl abstractControl) {
        if (this.peer != null) {
            this.peer.setBackground(this.bgc != null ? this.bgc : plafBgc);
        }
        this.overrideBackground = false;
        super.focusLost(abstractControl);
    }

    public boolean fireButtonRule() {
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (ruleManager.getFocus() != this) {
            if (this.isFocusable(false)) {
                ruleManager.prepareOverride(this);
                ruleManager.requestFocus(this);
            } else if (this.ruleOverride) {
                ruleManager.forceOverride();
            }
        }
        ruleManager.fireRule(this);
        return true;
    }

    public Dimension calcExtraSpace(Scaling scaling) {
        int n = 8;
        EJButton eJButton = (EJButton)this.peer;
        PushButtonIcon pushButtonIcon = (PushButtonIcon)eJButton.getIcon();
        if (pushButtonIcon != null) {
            pushButtonIcon.setScaling(scaling);
            n += pushButtonIcon.getIconWidth() + 4;
        }
        if ((pushButtonIcon = (PushButtonIcon)eJButton.getPressedIcon()) != null) {
            pushButtonIcon.setScaling(scaling);
        }
        return this.setExtraSpace(n, 4);
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setText(String string) {
        if (!this.origText.equals(string)) {
            this.origText = string;
            string = this.filterASCIIHighlightChars(string);
            StringBuffer stringBuffer = new StringBuffer();
            char c = this.getAcceleratorChar(string, stringBuffer);
            this.setKeyStroke(c);
            if (c != '\u0000') {
                super.setText(stringBuffer.toString());
            } else {
                super.setText(string);
            }
        }
    }

    public String getText() {
        return this.origText;
    }

    public void setBorder(int n) {
    }

    public int getBorder() {
        return 0;
    }

    public void setIconurl(String string) {
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
        if (string != null && string.length() > 0) {
            this.urlIcon = this.createExpandedURL(string);
            if (this.urlIcon != null) {
                this.icon = new PushButtonIcon(this.urlIcon, this.getScaling());
            }
            this.modifiedIcon = true;
            this.isModified = true;
        } else if (this.urlIcon != null) {
            this.urlIcon = null;
            this.modifiedIcon = true;
            this.isModified = true;
        }
        if (this.modifiedIcon && !this.isWidthSet()) {
            this.setLayoutChanged();
        }
    }

    public String getIconurl() {
        return this.urlIcon != null ? this.urlIcon.toExternalForm() : "";
    }

    public void setIconPressed(String string) {
        if (this.iconPressed != null) {
            this.iconPressed.dispose();
            this.iconPressed = null;
        }
        if (string != null && string.length() > 0) {
            this.urlIconPressed = this.createExpandedURL(string);
            if (this.urlIconPressed != null) {
                this.iconPressed = new PushButtonIcon(this.urlIconPressed, this.getScaling());
            }
            this.modifiedIconPressed = true;
            this.isModified = true;
        } else if (this.urlIconPressed != null) {
            this.urlIconPressed = null;
            this.modifiedIconPressed = true;
            this.isModified = true;
        }
        if (this.modifiedIconPressed && !this.isWidthSet()) {
            this.setLayoutChanged();
        }
    }

    public String getIconPressed() {
        return this.urlIconPressed != null ? this.urlIconPressed.toExternalForm() : "";
    }

    public void setTextpos(String string) {
        if (!this.textpos.equalsIgnoreCase(string)) {
            this.textpos = string;
            if (this.textpos.equalsIgnoreCase("center")) {
                this.textpos = "right";
            }
            this.modifiedTextPos = true;
            this.isModified = true;
            if (!this.isWidthSet()) {
                this.setLayoutChanged();
            }
        }
    }

    public String getTextpos() {
        return this.textpos;
    }

    static {
        attributeList.put(BORDER_ATTR_NAME, new Integer(0));
        attributeList.put(ICONURL_ATTR_NAME, new Integer(1));
        attributeList.put(ICONPRESSED_ATTR_NAME, new Integer(2));
        attributeList.put(TEXTPOS_ATTR_NAME, new Integer(3));
        attributeList.put(ADJUST_ATTR_NAME, new Integer(4));
    }

    class PushButtonIcon
    extends ImageIcon {
        Scaling scaling;

        public PushButtonIcon(URL uRL, Scaling scaling) {
            super(uRL);
            this.scaling = null;
            this.scaling = scaling;
        }

        public void setScaling(Scaling scaling) {
            this.scaling = scaling;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl = false;
            int n3 = 0;
            int n4 = 0;
            if (this.scaling != null) {
                if (this.scaling.x != 1.0) {
                    n3 = (int)Math.round((double)super.getIconWidth() * this.scaling.x);
                    n4 = this.scaling.y != 1.0 ? (int)Math.round((double)super.getIconHeight() * this.scaling.y) : super.getIconHeight();
                    bl = true;
                } else if (this.scaling.y != 1.0) {
                    n4 = (int)Math.round((double)super.getIconHeight() * this.scaling.y);
                    n3 = this.scaling.x != 1.0 ? (int)Math.round((double)super.getIconWidth() * this.scaling.x) : super.getIconWidth();
                    bl = true;
                }
            }
            GraphicsTool.setRenderingHints(graphics);
            Image image = this.getImage();
            ImageObserver imageObserver = this.getImageObserver();
            if (bl) {
                if (imageObserver != null) {
                    graphics.drawImage(image, n, n2, n3, n4, imageObserver);
                } else {
                    graphics.drawImage(image, n, n2, n3, n4, component);
                }
            } else if (imageObserver != null) {
                graphics.drawImage(image, n, n2, imageObserver);
            } else {
                graphics.drawImage(image, n, n2, component);
            }
        }

        public int getIconWidth() {
            int n = super.getIconWidth();
            if (this.scaling != null && this.scaling.x != 1.0) {
                n = (int)Math.round((double)n * this.scaling.x);
            }
            return n;
        }

        public int getIconHeight() {
            int n = super.getIconHeight();
            if (this.scaling != null && this.scaling.y != 1.0) {
                n = (int)Math.round((double)n * this.scaling.y);
            }
            return n;
        }

        public void dispose() {
            this.scaling = null;
        }
    }

    class EJButton
    extends JButton
    implements PositionInterface {
        EJButton() {
        }

        public Insets getInsets() {
            return new Insets(1, 0, 1, 0);
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EPushButton.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

