/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.EGroupBox;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.SafeRunnable;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ETabBox
extends AbstractControlContainer
implements ChangeListener,
ControlsManager.RuleOverride {
    private static HashMap attributeList = new HashMap();
    private static final int SELECTEDTAB_ATTR_ID = 0;
    private static final int TABS_ATTR_ID = 1;
    private static final int TABPLACEMENT_ATTR_ID = 2;
    private static final int RULEOVERRIDE_ATTR_ID = 3;
    private static final int SCROLLABLE_ATTR_ID = 4;
    private boolean inSetSelectedTab = true;
    public static final String CLASS_ATTR_NAME = "TabBox";
    private static final String SELECTEDTAB_ATTR_NAME = "selectedtab";
    private String selectedtab = "";
    private int selectedIndex = -1;
    private static final String TABS_ATTR_NAME = "tabs";
    private static final String TABPLACEMENT_ATTR_NAME = "tabplacement";
    private String tabplacement = "top";
    private static final String RULEOVERRIDE_ATTR_NAME = "ruleoverride";
    private boolean ruleOverride = false;
    private static final String SCROLLABLE_ATTR_NAME = "scrollable";
    private int scrollable = 0;

    public ETabBox() {
        EJTabbedPane eJTabbedPane = new EJTabbedPane();
        eJTabbedPane.addChangeListener(this);
        eJTabbedPane.addKeyListener(this);
        ((JComponent)eJTabbedPane).setFont(StartUp.getDefaultFont());
        eJTabbedPane.setFocusTraversalKeysEnabled(false);
        this.peer = eJTabbedPane;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.peer.removeKeyListener(this);
            this.peer.removeMouseListener(this);
            JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
            jTabbedPane.removeChangeListener(this);
            jTabbedPane.resetKeyboardActions();
            super.dispose();
            this.selectedtab = null;
            this.tabplacement = null;
        }
    }

    public Object clone() {
        ETabBox eTabBox = new ETabBox();
        this.cloneAttributes(eTabBox);
        return eTabBox;
    }

    protected void cloneAttributes(ETabBox eTabBox) {
        super.cloneAttributes(eTabBox);
        eTabBox.setSelectedTab(this.selectedtab);
        eTabBox.setTabplacement(this.getTabplacement());
        eTabBox.setRuleOverride(this.getRuleOverride());
        eTabBox.setScrollable(this.getScrollable());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setSelectedTab(sET.getValueString());
                    sTATUS.attrMode = 4;
                    break;
                }
                case 2: {
                    return this.setTabplacement(sET.getValueString());
                }
                case 3: {
                    this.setRuleOverride(sET.getValueInt());
                    break;
                }
                case 4: {
                    this.setScrollable(sET.getValueInt());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.return_ID(this.selectedtab));
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    break;
                }
                case 1: {
                    gET2.setValueInt(this.getTabs());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getTabplacement());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.getRuleOverride());
                    break;
                }
                case 4: {
                    gET2.setValueInt(this.getScrollable());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        super.eloq2swing(bl);
        this.eloq2swingScrollable();
        this.eloq2swingHeaderUpdate();
        this.eloq2swingSetTabplacement();
        this.inSetSelectedTab = true;
        int n = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            EGroupBox eGroupBox = (EGroupBox)listIterator.next();
            String string = eGroupBox.getId();
            if (string.equalsIgnoreCase(this.selectedtab)) {
                ((JTabbedPane)this.peer).setSelectedIndex(n);
                this.selectedtab = string;
                eGroupBox.peer.setVisible(true);
            } else {
                eGroupBox.peer.setVisible(false);
            }
            ++n;
        }
        this.inSetSelectedTab = false;
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        super.swing2eloq(dO);
        if (dO != null) {
            if (this.peer.isShowing()) {
                dO.cache((AbstractControl)this, SELECTEDTAB_ATTR_NAME, 4, this.return_ID(this.selectedtab));
            } else {
                dO.uncache(this, SELECTEDTAB_ATTR_NAME);
            }
        }
    }

    private final void eloq2swingHeaderUpdate() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
        jTabbedPane.resetKeyboardActions();
        int n = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            KeyStroke keyStroke;
            boolean bl;
            EGroupBox eGroupBox = (EGroupBox)listIterator.next();
            ((JComponent)eGroupBox.getPeer()).setOpaque(true);
            boolean bl2 = eGroupBox.getSensitive() != 0;
            boolean bl3 = bl = bl2 && eGroupBox.getVisible() != 0;
            if (bl != jTabbedPane.isEnabledAt(n)) {
                jTabbedPane.setEnabledAt(n, bl);
                eGroupBox.peer.setVisible(bl);
            }
            jTabbedPane.setTitleAt(n, eGroupBox.getTitle());
            jTabbedPane.setIconAt(n, eGroupBox.getImageIcon());
            if (bl2 && (keyStroke = eGroupBox.getKeyAccelerator()) != null) {
                String string = eGroupBox.getAccelerator();
                InputMap inputMap = jTabbedPane.getInputMap(2);
                inputMap.put(keyStroke, string);
                int n2 = keyStroke.getKeyCode();
                if (n2 >= 48 && n2 <= 57) {
                    keyStroke = KeyStroke.getKeyStroke(n2 += 48, keyStroke.getModifiers());
                    inputMap.put(keyStroke, string);
                }
                jTabbedPane.getActionMap().put(string, new TabAction(string));
            }
            if (eGroupBox.getToolhelp().length() == 0) {
                jTabbedPane.setToolTipTextAt(n, null);
            } else if (!eGroupBox.getToolhelp().equals(jTabbedPane.getToolTipTextAt(n))) {
                jTabbedPane.setToolTipTextAt(n, eGroupBox.getToolhelp());
            }
            ++n;
        }
        if (!jTabbedPane.isEnabled() && this.getSensitive() != 0) {
            jTabbedPane.setEnabled(true);
        }
    }

    private final void eloq2swingScrollable() {
        try {
            JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
            if (jTabbedPane.getTabLayoutPolicy() != this.scrollable) {
                jTabbedPane.setTabLayoutPolicy(this.scrollable);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void eloq2swingSetTabplacement() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
        int n = 1;
        if (this.tabplacement.equalsIgnoreCase("top")) {
            n = 1;
        } else if (this.tabplacement.equalsIgnoreCase("right")) {
            n = 4;
        } else if (this.tabplacement.equalsIgnoreCase("bottom")) {
            n = 3;
        } else if (this.tabplacement.equalsIgnoreCase("left")) {
            n = 2;
        }
        jTabbedPane.setTabPlacement(n);
    }

    public boolean add(Object object) {
        if (object instanceof EGroupBox) {
            final EGroupBox eGroupBox = (EGroupBox)object;
            final JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
            SafeRunnable.execute(new SafeRunnable(){

                public void runSafe() {
                    jTabbedPane.addTab(eGroupBox.getTitle(), eGroupBox.getImageIcon(), eGroupBox.getPeer());
                    if (ETabBox.this.children.size() == 0) {
                        jTabbedPane.setSelectedComponent(eGroupBox.getPeer());
                        ETabBox.this.selectedtab = eGroupBox.getId();
                        ETabBox.this.selectedIndex = 0;
                    }
                    ((JComponent)eGroupBox.getPeer()).setOpaque(true);
                    eGroupBox.setInPane();
                    eGroupBox.setFontReference(ETabBox.this.fontReference);
                }
            });
            return this.children.add(object);
        }
        return false;
    }

    public boolean remove(Object object) {
        if (object instanceof EGroupBox) {
            final JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
            final EGroupBox eGroupBox = (EGroupBox)object;
            EGroupBox eGroupBox2 = null;
            int n = -1;
            if (eGroupBox.getId().equalsIgnoreCase(this.selectedtab)) {
                if (this.children.size() == 1) {
                    this.selectedtab = "";
                    this.selectedIndex = -1;
                } else {
                    this.selectedIndex = 0;
                    EGroupBox eGroupBox3 = (EGroupBox)this.children.get(0);
                    if (eGroupBox3 != object) {
                        this.selectedtab = eGroupBox3.getId();
                        n = 0;
                    } else {
                        this.selectedtab = ((EGroupBox)this.children.get(1)).getId();
                        n = 1;
                    }
                }
            } else if (this.selectedIndex >= 0) {
                eGroupBox2 = (EGroupBox)this.children.get(this.selectedIndex);
            }
            final int n2 = n;
            SafeRunnable.execute(new SafeRunnable(){

                public void runSafe() {
                    if (n2 >= 0) {
                        jTabbedPane.setSelectedIndex(n2);
                    }
                    jTabbedPane.remove(eGroupBox.getPeer());
                }
            });
            boolean bl = this.children.remove(eGroupBox);
            if (eGroupBox2 != null) {
                int n3 = this.children.indexOf(eGroupBox2);
                if (n3 >= 0) {
                    this.selectedIndex = n3;
                } else if (eGroupBox == eGroupBox2) {
                    if (this.children.size() > 0) {
                        this.selectedtab = ((EGroupBox)this.children.get(0)).getId();
                        this.selectedIndex = 0;
                        SafeRunnable.execute(new SafeRunnable(){

                            public void runSafe() {
                                jTabbedPane.setSelectedIndex(0);
                            }
                        });
                    } else {
                        this.selectedtab = "";
                        this.selectedIndex = -1;
                    }
                } else {
                    System.err.println("Warning on removing TabBox child object " + eGroupBox.getPath() + ": Unable to obtain index of selected child object " + eGroupBox2.getPath());
                }
            }
            return bl;
        }
        return false;
    }

    public void onRenameChild(AbstractControl abstractControl, String string) {
        int n = this.children.indexOf(abstractControl);
        if (n < 0) {
            System.err.println("Warning on renaming TabBox child object " + abstractControl.getPath() + " (old id: " + string + ") : Unable to obtain index of child object");
            return;
        }
        if (this.selectedtab.equalsIgnoreCase(string)) {
            this.selectedtab = abstractControl.getId();
            this.selectedIndex = n;
        }
    }

    public void notifyTabChanges(int n) {
        EJTabbedPane eJTabbedPane;
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (n >= 0 && n != this.selectedIndex && n < (eJTabbedPane = (EJTabbedPane)this.peer).getTabCount()) {
            EGroupBox eGroupBox = (EGroupBox)this.children.get(n);
            if (eGroupBox.getSensitive() != 0 && eGroupBox.getVisible() != 0) {
                AbstractControlContainer abstractControlContainer = null;
                if (eGroupBox.getRule() != 0) {
                    abstractControlContainer = eGroupBox;
                } else if (this.getRule() != 0) {
                    abstractControlContainer = this;
                }
                this.selectedIndex = n;
                this.setSelectedTab(eGroupBox.getId());
                if (ruleManager.getFocus() != this) {
                    ruleManager.prepareOverride(abstractControlContainer);
                    ruleManager.requestFocus(this);
                }
                if (abstractControlContainer != null) {
                    ruleManager.modifyOverride(abstractControlContainer);
                    ruleManager.fireRule(abstractControlContainer);
                } else {
                    ruleManager.cancelOverride();
                }
            }
            return;
        }
        ruleManager.cancelOverride();
    }

    public void keyPressed(KeyEvent keyEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)this.peer;
        int n = this.selectedIndex;
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 226: {
                while (--n >= 0) {
                    EGroupBox eGroupBox = (EGroupBox)this.children.get(n);
                    if (eGroupBox.getSensitive() == 0 || eGroupBox.getVisible() == 0) continue;
                    jTabbedPane.setSelectedIndex(n);
                    this.notifyTabChanges(n);
                    break;
                }
                keyEvent.consume();
                return;
            }
            case 39: 
            case 227: {
                while (++n < this.children.size()) {
                    EGroupBox eGroupBox = (EGroupBox)this.children.get(n);
                    if (eGroupBox.getSensitive() == 0 || eGroupBox.getVisible() == 0) continue;
                    jTabbedPane.setSelectedIndex(n);
                    this.notifyTabChanges(n);
                    break;
                }
                keyEvent.consume();
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.consumeRightMouseButtonEvent(mouseEvent);
        if (!this.consumeInputEvent(mouseEvent)) {
            EGroupBox eGroupBox;
            AbstractControlContainer abstractControlContainer = this;
            int n = ((EJTabbedPane)this.peer).getSelectedIndex();
            if (n >= 0 && (eGroupBox = (EGroupBox)this.children.get(n)).getRule() != 0) {
                abstractControlContainer = eGroupBox;
            }
            this.getRuleManager().prepareOverride(abstractControlContainer, mouseEvent);
            super.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.consumeRightMouseButtonEvent(mouseEvent);
        this.notifyTabChanges(((EJTabbedPane)this.peer).getSelectedIndex());
        this.getRuleManager().requestFocus(this);
        this.requestFocusInWindow(this.peer);
        super.mouseReleased(mouseEvent);
    }

    public AbstractControl getNextFocusControl(boolean bl) {
        AbstractControl abstractControl = this.findNextFocusControl(bl, true);
        if (abstractControl == null) {
            abstractControl = this.getRootControl().findNextFocusControl(bl, false);
        }
        return abstractControl != null ? abstractControl : this.getRootControl();
    }

    public AbstractControl getPrevFocusControl(boolean bl) {
        AbstractControl abstractControl = this.parent.findPrevFocusControl(this, bl, true);
        if (abstractControl == null) {
            abstractControl = this.getRootControl().findPrevFocusControl(bl, false);
        }
        return abstractControl != null ? abstractControl : this.getRootControl();
    }

    public AbstractControl findNextFocusControl(boolean bl, boolean bl2) {
        int n = ((EJTabbedPane)this.peer).getSelectedIndex();
        if (n >= 0) {
            EGroupBox eGroupBox = (EGroupBox)this.children.get(n);
            return eGroupBox.findNextFocusControl(bl, bl2);
        }
        return null;
    }

    public AbstractControl ascendNextFocusControl(AbstractControl abstractControl, boolean bl) {
        return this.parent != null ? this.parent.ascendNextFocusControl(this, bl) : null;
    }

    public AbstractControl findPrevFocusControl(boolean bl, boolean bl2) {
        int n = ((EJTabbedPane)this.peer).getSelectedIndex();
        if (n >= 0) {
            EGroupBox eGroupBox = (EGroupBox)this.children.get(n);
            return eGroupBox.findPrevFocusControl(bl, bl2);
        }
        return null;
    }

    public AbstractControl ascendPrevFocusControl(AbstractControl abstractControl, boolean bl) {
        if (this.isFocusable(bl)) {
            return this;
        }
        return this.parent != null ? this.parent.ascendPrevFocusControl(this, bl) : null;
    }

    public boolean allowSiblings() {
        return false;
    }

    public void childFocusChain(AbstractControl abstractControl, AbstractControl abstractControl2) {
        super.childFocusChain(abstractControl, abstractControl2);
        this.setSelectedTab(abstractControl.getId());
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            EGroupBox eGroupBox = (EGroupBox)listIterator.next();
            if (!eGroupBox.visible) continue;
            eGroupBox.layout(null, dimension2, scaling);
        }
        return false;
    }

    public boolean isFocusable(boolean bl) {
        return this.children.size() > 0 && super.isFocusable(bl) && this.getSensitive() != 0;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        if (!this.inSetSelectedTab && (n = this.getSelectedIndex()) >= 0 && n < this.children.size()) {
            EGroupBox eGroupBox = (EGroupBox)this.children.get(n);
            this.selectedtab = eGroupBox.getId();
        }
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    private void setSelectedTab(String string) {
        Object object;
        EGroupBox eGroupBox;
        if (this.selectedIndex >= 0 && (eGroupBox = (EGroupBox)this.children.get(this.selectedIndex)).getId().equalsIgnoreCase(string)) {
            return;
        }
        this.selectedIndex = -1;
        int n = 0;
        ListIterator listIterator = this.children.listIterator();
        while (listIterator.hasNext()) {
            object = (EGroupBox)listIterator.next();
            if (((AbstractControl)object).getId().equalsIgnoreCase(string)) {
                this.selectedIndex = n;
                break;
            }
            ++n;
        }
        if (this.selectedIndex >= 0) {
            object = this.getRuleManager();
            AbstractControl abstractControl = ((ControlsManager.RuleManager)object).getFocus();
            if (abstractControl != null) {
                EGroupBox eGroupBox2;
                if (abstractControl.isChildOf(this) && !abstractControl.isChildOf(eGroupBox2 = (EGroupBox)this.children.get(this.selectedIndex))) {
                    ((ControlsManager.RuleManager)object).forceFocus(this, true);
                    this.requestFocusInWindow(this.peer);
                }
            } else {
                ((ControlsManager.RuleManager)object).forceFocus(this, true);
                this.requestFocusInWindow(this.peer);
            }
            this.selectedtab = string;
            this.isModified = true;
        }
    }

    private int getSelectedIndex() {
        return ((JTabbedPane)this.peer).getSelectedIndex();
    }

    private int getTabs() {
        return ((JTabbedPane)this.peer).getTabCount();
    }

    private int setTabplacement(String string) {
        if (!(string.equalsIgnoreCase("top") || string.equalsIgnoreCase("right") || string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("left"))) {
            return 11;
        }
        this.tabplacement = string;
        this.isModified = true;
        return 0;
    }

    private String getTabplacement() {
        return this.tabplacement;
    }

    public void setRuleOverride(int n) {
        this.ruleOverride = n != 0;
    }

    public int getRuleOverride() {
        return this.ruleOverride ? 1 : 0;
    }

    private void setScrollable(int n) {
        this.scrollable = n != 0 ? 1 : 0;
        this.isModified = true;
    }

    private int getScrollable() {
        return this.scrollable == 1 ? 1 : 0;
    }

    static {
        attributeList.put(SELECTEDTAB_ATTR_NAME, new Integer(0));
        attributeList.put(TABS_ATTR_NAME, new Integer(1));
        attributeList.put(TABPLACEMENT_ATTR_NAME, new Integer(2));
        attributeList.put(RULEOVERRIDE_ATTR_NAME, new Integer(3));
        attributeList.put(SCROLLABLE_ATTR_NAME, new Integer(4));
    }

    class EJTabbedPane
    extends JTabbedPane {
        public EJTabbedPane() {
            this.enableInputMethods(false);
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!ETabBox.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }

        public void setFont(Font font) {
            super.setFont(font);
            int n = 0;
            ListIterator listIterator = ETabBox.this.children.listIterator();
            while (listIterator.hasNext()) {
                EGroupBox eGroupBox = (EGroupBox)listIterator.next();
                String string = eGroupBox.getTitle();
                if (HtmlTool.isHtml(string)) {
                    this.setTitleAt(n, null);
                    this.setTitleAt(n, string);
                }
                ++n;
            }
        }
    }

    class TabAction
    extends AbstractAction {
        public TabAction(String string) {
            this.putValue("ActionCommandKey", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = 0;
            ListIterator listIterator = ETabBox.this.children.listIterator();
            while (listIterator.hasNext()) {
                EGroupBox eGroupBox = (EGroupBox)listIterator.next();
                if (eGroupBox.getAccelerator().equals(string)) {
                    if (eGroupBox.getSensitive() == 0 || eGroupBox.getVisible() == 0) break;
                    JTabbedPane jTabbedPane = (JTabbedPane)ETabBox.this.peer;
                    jTabbedPane.setSelectedIndex(n);
                    ETabBox.this.notifyTabChanges(n);
                    break;
                }
                ++n;
            }
        }
    }
}

