/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Scaling;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.JPanel;

public class EToolBar
extends AbstractControlContainer {
    private static final String POSITION_ATTR_NAME = "position";
    private String position = "top";
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final String CLASS_ATTR_NAME = "ToolBar";
    private static final int POSITION_ATTR_ID = 0;
    private static HashMap attributeList = new HashMap();

    public EToolBar() {
        this.peer = new ToolBarPanel();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
            this.position = null;
        }
    }

    public Object clone() {
        EToolBar eToolBar = new EToolBar();
        this.cloneAttributes(eToolBar);
        return eToolBar;
    }

    public boolean layout(Dimension dimension, Dimension dimension2, Scaling scaling) {
        Point point = new Point(0, 0);
        int n = this.getPositionId();
        ListIterator listIterator = this.children.listIterator();
        block3: while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            if (!abstractControl.visible) continue;
            int n2 = abstractControl.getWidth();
            int n3 = abstractControl.getHeight();
            if (abstractControl.useRasterSize) {
                n2 *= dimension2.width;
                n3 *= dimension2.height;
            } else {
                n2 = (int)Math.round((double)n2 * scaling.x);
                n3 = (int)Math.round((double)n3 * scaling.y);
            }
            Rectangle rectangle = new Rectangle(point.x, point.y, n2, n3);
            abstractControl.layout(rectangle.getSize(), dimension2, scaling);
            abstractControl.getPeer().setBounds(rectangle);
            switch (n) {
                case 0: 
                case 1: {
                    point.y += rectangle.height;
                    continue block3;
                }
            }
            point.x += rectangle.width;
        }
        return false;
    }

    public int getWidth() {
        Dimension dimension = null;
        Scaling scaling = null;
        int n = 0;
        int n2 = this.getPositionId();
        ListIterator listIterator = this.children.listIterator();
        block3: while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            int n3 = abstractControl.getWidth();
            if (abstractControl.useRasterSize) {
                if (dimension == null) {
                    dimension = this.getLayoutGrid();
                }
                n3 *= dimension.width;
            } else {
                if (scaling == null) {
                    scaling = this.getScaling();
                }
                n3 = (int)Math.round((double)n3 * scaling.x);
            }
            switch (n2) {
                case 0: 
                case 1: {
                    if (n3 <= n) continue block3;
                    n = n3;
                    continue block3;
                }
            }
            n += n3;
        }
        if (this.useRasterSize) {
            if (dimension == null) {
                dimension = this.getLayoutGrid();
            }
            n = (int)Math.round((double)n / (double)dimension.width);
        } else {
            if (scaling == null) {
                scaling = this.getScaling();
            }
            n = (int)Math.round((double)n / scaling.x);
        }
        return n;
    }

    public int getHeight() {
        Dimension dimension = null;
        Scaling scaling = null;
        int n = 0;
        int n2 = this.getPositionId();
        ListIterator listIterator = this.children.listIterator();
        block3: while (listIterator.hasNext()) {
            AbstractControl abstractControl = (AbstractControl)listIterator.next();
            int n3 = abstractControl.getHeight();
            if (abstractControl.useRasterSize) {
                if (dimension == null) {
                    dimension = this.getLayoutGrid();
                }
                n3 *= dimension.height;
            } else {
                if (scaling == null) {
                    scaling = this.getScaling();
                }
                n3 = (int)Math.round((double)n3 * scaling.y);
            }
            switch (n2) {
                case 0: 
                case 1: {
                    n += n3;
                    continue block3;
                }
            }
            if (n3 <= n) continue;
            n = n3;
        }
        if (this.useRasterSize) {
            if (dimension == null) {
                dimension = this.getLayoutGrid();
            }
            n = (int)Math.round((double)n / (double)dimension.height);
        } else {
            if (scaling == null) {
                scaling = this.getScaling();
            }
            n = (int)Math.round((double)n / scaling.y);
        }
        return n;
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setPosition(String string) {
        this.position = string.equalsIgnoreCase("top") || string.equalsIgnoreCase("right") || string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("left") ? string : "top";
        this.setLayoutChanged();
        this.isModified = true;
    }

    public int getPositionId() {
        if (this.position.equalsIgnoreCase("top")) {
            return 2;
        }
        if (this.position.equalsIgnoreCase("right")) {
            return 1;
        }
        if (this.position.equalsIgnoreCase("bottom")) {
            return 3;
        }
        if (this.position.equalsIgnoreCase("left")) {
            return 0;
        }
        return -1;
    }

    public String getPosition() {
        return this.position;
    }

    public boolean layoutAsChild() {
        return false;
    }

    public boolean inToolBar() {
        return true;
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public void enableDragDrop() {
        this.setDragDropHandler(new AbstractControl.DefaultDragDrop());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setPosition(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getPosition());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    protected void cloneAttributes(EToolBar eToolBar) {
        super.cloneAttributes(eToolBar);
        eToolBar.setPosition(this.position);
    }

    static {
        attributeList.put(POSITION_ATTR_NAME, new Integer(0));
    }

    class ToolBarPanel
    extends JPanel {
        public ToolBarPanel() {
            super(null);
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (EToolBar.this.ignoreEvent(aWTEvent)) {
                return;
            }
            super.processEvent(aWTEvent);
        }
    }
}

