/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.DragDropHandler;
import com.eloquence.api.UnifiedData;
import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.SafeRunnable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ETree
extends AbstractControl
implements TreeSelectionListener,
TreeWillExpandListener,
TreeExpansionListener,
ControlsManager.RuleOverride {
    private static HashMap attributeList = new HashMap();
    private static final int DELIMITER_ATTR_ID = 0;
    private static final int ADD_ATTR_ID = 1;
    private static final int CONTENT_ATTR_ID = 2;
    private static final int CY_ATTR_ID = 3;
    private static final int CLEAR_ATTR_ID = 4;
    private static final int ACTIVELINE_ATTR_ID = 5;
    private static final int LINE_ATTR_ID = 6;
    private static final int OPEN_ATTR_ID = 7;
    private static final int CHILDREN_ATTR_ID = 8;
    private static final int INS_ATTR_ID = 9;
    private static final int EMPTYNODE_ATTR_ID = 10;
    private static final int EMPTYNODEAUTO_ATTR_ID = 11;
    private static final int UDATA_ATTR_ID = 12;
    private static final int UDATA_BUF_ATTR_ID = 13;
    private static final int DEL_ATTR_ID = 14;
    private static final int PARENT_ATTR_ID = 15;
    private static final int SINGLECLICK_ATTR_ID = 16;
    private static final int USEICONS_ATTR_ID = 17;
    private static final int OPENALL_ATTR_ID = 18;
    private static final int LINES_ATTR_ID = 19;
    private static final int RULEOVERRIDE_ATTR_ID = 20;
    private static final int DROP_MODE_ATTR_ID = 21;
    private static final int DROP_LINE_ATTR_ID = 22;
    private static final int ADDCY_ATTR_ID = 23;
    EJTree tree;
    private ETreeModel treeModel = new ETreeModel();
    private CellRenderer cellRenderer;
    private int allowRule = 0;
    private LinkedList pendingItemCommands = new LinkedList();
    private boolean inCommit = false;
    private boolean triggerExpand = false;
    private Stack autoOpenItems = new Stack();
    boolean mouseDown = false;
    boolean mouseTriggerRule = false;
    boolean cancelOverride = false;
    public static final String CLASS_ATTR_NAME = "Tree";
    private static final String DELIMITER_ATTR_NAME = "delim";
    private String delimiter = "\t";
    private static final String ADD_ATTR_NAME = "add";
    private static final String INS_ATTR_NAME = "ins";
    private static final String CONTENT_ATTR_NAME = "content";
    private static final String LINE_BUF_ATTR_NAME = "line_buf";
    private static final String CY_ATTR_NAME = "cy";
    private int cy = 0;
    private boolean cySet = false;
    private boolean cyCached = false;
    private static final String ADDCY_ATTR_NAME = "addcy";
    private int addCy = 0;
    private static final String CLEAR_ATTR_NAME = "clear";
    private static final String ACTIVELINE_ATTR_NAME = "activeline";
    private int activeLine = 0;
    private boolean activeLineModified = false;
    private boolean activeLineCached = false;
    private static final String LINE_ATTR_NAME = "line";
    private static final String LINES_ATTR_NAME = "lines";
    private static final String OPEN_ATTR_NAME = "open";
    private static final String OPENALL_ATTR_NAME = "openall";
    private int applyExpandCollapseAll_Command = 0;
    private int applyExpandCollapseAll_Line = 0;
    private static final String CHILDREN_ATTR_NAME = "children";
    private static final String EMPTYNODE_ATTR_NAME = "emptynode";
    private int emptyNode = 0;
    private static final String EMPTYNODEAUTO_ATTR_NAME = "emptynodeauto";
    private boolean emptyNodeAuto = false;
    private static final String UDATA_ATTR_NAME = "udata";
    private static final String UDATA_BUF_ATTR_NAME = "udata_buf";
    private static final String DEL_ATTR_NAME = "del";
    private static final String PARENT_ATTR_NAME = "parent";
    private static final String SINGLECLICK_ATTR_NAME = "singleclick";
    protected int singleClick = 3;
    private static final String USEICONS_ATTR_NAME = "useicons";
    private boolean useIcons = true;
    private static final String RULEOVERRIDE_ATTR_NAME = "ruleoverride";
    private boolean ruleOverride = false;
    private static final String DROP_MODE_ATTR_NAME = "dropmode";
    private static final String DROP_LINE_ATTR_NAME = "dropline";
    private boolean acceptValidDropOnly = false;
    private int dropLine = 0;
    private boolean inDrag = false;
    private TreePath dragSaveSelectionPath = null;
    private int dragSaveAllowRule = 0;

    ETree() {
        this.tree = new EJTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.setFocusTraversalKeysEnabled(false);
        this.tree.addKeyListener(this);
        this.cellRenderer = new CellRenderer(this.tree.getCellRenderer());
        this.tree.setCellRenderer(this.cellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setFocusable(true);
        jScrollPane.setAutoscrolls(true);
        this.peer = jScrollPane;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            super.dispose();
            this.tree.removeTreeWillExpandListener(this);
            this.tree.removeTreeSelectionListener(this);
            this.tree.removeTreeExpansionListener(this);
            this.tree.removeKeyListener(this);
            this.treeModel = null;
            this.tree.setCellRenderer(this.cellRenderer.getDefaultRenderer());
            this.tree = null;
            this.cellRenderer.setDefaultRenderer(null);
            this.cellRenderer = null;
            if (this.pendingItemCommands != null) {
                this.pendingItemCommands.clear();
                this.pendingItemCommands = null;
            }
            if (this.autoOpenItems != null) {
                this.autoOpenItems.clear();
                this.autoOpenItems = null;
            }
        }
    }

    public Object clone() {
        ETree eTree = new ETree();
        this.cloneAttributes(eTree);
        return eTree;
    }

    protected final void cloneAttributes(ETree eTree) {
        ETreeItem eTreeItem;
        Object object;
        super.cloneAttributes(eTree);
        eTree.setDelimiter(this.getDelimiter());
        eTree.setEmptyNode(this.getEmptyNode());
        eTree.setEmptyNodeAuto(this.getEmptyNodeAuto());
        eTree.setSingleClick(this.getSingleClick());
        eTree.setUseIcons(this.getUseIcons());
        eTree.setContent(this.getContent());
        eTree.setCy(this.cy);
        eTree.setActiveLine(this.getActiveLine());
        eTree.setRuleOverride(this.getRuleOverride());
        eTree.setDropMode(this.getDropMode());
        eTree.safeCommit();
        ListIterator listIterator = this.treeModel.items.listIterator();
        ListIterator listIterator2 = eTree.treeModel.items.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator2.hasNext()) {
                throw new RuntimeException("BUG: " + this.getPath() + " : Cloned object has less lines than expected");
            }
            object = (ETreeItem)listIterator.next();
            eTreeItem = (ETreeItem)listIterator2.next();
            if (((ETreeItem)object).uData == null) {
                eTreeItem.uData = null;
                continue;
            }
            if (((ETreeItem)object).uData.isStringData()) {
                eTreeItem.uData = new UnifiedData(((ETreeItem)object).uData.getStringData());
                continue;
            }
            eTreeItem.uData = new UnifiedData(((ETreeItem)object).uData.getIntData());
        }
        if (listIterator2.hasNext()) {
            throw new RuntimeException("BUG: " + this.getPath() + " : Cloned object has more lines than expected");
        }
        eTree.applyExpandCollapseAll_Command = this.applyExpandCollapseAll_Command;
        eTree.applyExpandCollapseAll_Line = this.applyExpandCollapseAll_Line;
        if (!this.autoOpenItems.isEmpty()) {
            eTree.autoOpenItems.clear();
            object = this.autoOpenItems.listIterator();
            while (object.hasNext()) {
                eTreeItem = (ETreeItem)object.next();
                int n = this.treeModel.items.indexOf(eTreeItem);
                ETreeItem eTreeItem2 = (ETreeItem)eTree.treeModel.items.get(n);
                eTree.autoOpenItems.push(eTreeItem2);
            }
        }
        if (this.isModified) {
            eTree.isModified = true;
        }
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                switch (n) {
                    case 1: {
                        sTATUS.attrMode = 5;
                        return this.setAdd(sET.getValueString(), this.getInt(sET.index));
                    }
                    case 9: {
                        sTATUS.attrMode = 5;
                        return this.setIns(sET.getValueString(), this.getInt(sET.index));
                    }
                    case 14: {
                        sTATUS.attrMode = 5;
                        return this.setDel(sET.getValueInt(), this.getInt(sET.index));
                    }
                    case 6: {
                        sTATUS.attrMode = 5;
                        return this.setLine(sET.getValueString(), this.getInt(sET.index));
                    }
                    case 7: {
                        return this.setOpen(sET.getValueInt(), this.getInt(sET.index));
                    }
                    case 18: {
                        return this.setOpenAll(sET.getValueInt(), this.getInt(sET.index));
                    }
                    case 12: {
                        if (sET.v_type == 1) {
                            return this.setUData(sET.getValueInt(), this.getInt(sET.index));
                        }
                        return this.setUData(sET.getValueString(), this.getInt(sET.index));
                    }
                }
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setDelimiter(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setAdd(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 9: {
                    this.setIns(sET.getValueString(), 0);
                    sTATUS.attrMode = 5;
                    break;
                }
                case 14: {
                    this.setDel(sET.getValueInt(), 0);
                    sTATUS.attrMode = 5;
                    break;
                }
                case 2: {
                    this.setContent(sET.getValueString());
                    sTATUS.attrMode = 5;
                    break;
                }
                case 4: {
                    this.setClear();
                    sTATUS.attrMode = 5;
                    break;
                }
                case 3: {
                    this.setCy(sET.getValueInt());
                    sTATUS.attrMode = 4;
                    break;
                }
                case 5: {
                    this.setActiveLine(sET.getValueInt());
                    sTATUS.attrMode = 4;
                    break;
                }
                case 10: {
                    this.setEmptyNode(sET.getValueInt());
                    break;
                }
                case 11: {
                    this.setEmptyNodeAuto(sET.getValueInt());
                    break;
                }
                case 16: {
                    this.setSingleClick(sET.getValueInt());
                    break;
                }
                case 17: {
                    this.setUseIcons(sET.getValueInt());
                    break;
                }
                case 6: {
                    this.setLine(sET.getValueString(), 0);
                    sTATUS.attrMode = 5;
                    break;
                }
                case 7: {
                    this.setOpen(sET.getValueInt(), 0);
                    break;
                }
                case 18: {
                    this.setOpenAll(sET.getValueInt(), 0);
                    break;
                }
                case 20: {
                    this.setRuleOverride(sET.getValueInt());
                    break;
                }
                case 21: {
                    this.setDropMode(sET.getValueInt());
                    break;
                }
                case 12: {
                    if (sET.v_type == 1) {
                        return this.setUData(sET.getValueInt(), 0);
                    }
                    return this.setUData(sET.getValueString(), 0);
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                switch (n) {
                    case 6: {
                        if (gET2.setValueString(this.getLine(this.getInt(gET.index)))) break;
                        return 11;
                    }
                    case 7: {
                        gET2.setValueInt(this.getOpen(this.getInt(gET.index)));
                        break;
                    }
                    case 8: {
                        gET2.setValueInt(this.getChildren(this.getInt(gET.index)));
                        break;
                    }
                    case 15: {
                        gET2.setValueInt(this.getParent(this.getInt(gET.index)));
                        break;
                    }
                    case 12: {
                        return this.getUData(gET2, this.getInt(gET.index));
                    }
                    default: {
                        return 8;
                    }
                }
                return 0;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getDelimiter());
                    break;
                }
                case 3: {
                    gET2.setValueInt(this.cy);
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    this.cyCached = true;
                    break;
                }
                case 23: {
                    gET2.setValueInt(this.getAddCy());
                    break;
                }
                case 5: {
                    gET2.setValueInt(this.getActiveLine());
                    gET2.cacheMode = 1;
                    gET2.attrMode = 4;
                    this.activeLineCached = true;
                    break;
                }
                case 10: {
                    gET2.setValueInt(this.getEmptyNode());
                    break;
                }
                case 11: {
                    gET2.setValueInt(this.getEmptyNodeAuto());
                    break;
                }
                case 16: {
                    gET2.setValueInt(this.getSingleClick());
                    break;
                }
                case 17: {
                    gET2.setValueInt(this.getUseIcons());
                    break;
                }
                case 6: {
                    gET2.setValueString(this.getLine(0));
                    break;
                }
                case 7: {
                    gET2.setValueInt(this.getOpen(0));
                    break;
                }
                case 8: {
                    gET2.setValueInt(this.getChildren(0));
                    break;
                }
                case 15: {
                    gET2.setValueInt(this.getParent(0));
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getContent());
                    break;
                }
                case 19: {
                    gET2.setValueInt(this.getLines());
                    break;
                }
                case 20: {
                    gET2.setValueInt(this.getRuleOverride());
                    break;
                }
                case 21: {
                    gET2.setValueInt(this.getDropMode());
                    break;
                }
                case 22: {
                    gET2.setValueInt(this.getDropLine());
                    break;
                }
                case 12: {
                    return this.getUData(gET2, 0);
                }
                case 13: {
                    gET2.setValueString(this.getUDataBuf());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        Object object;
        if (bl) {
            this.dropLine = 0;
        }
        this.cySet = false;
        if (!this.isModified) {
            super.eloq2swing(bl);
            return;
        }
        super.eloq2swing(bl);
        this.tree.setEnabled(this.peer.isEnabled());
        this.cellRenderer.enableIcons(this.useIcons);
        this.commit();
        if (this.applyExpandCollapseAll_Command != 0) {
            this.inCommit = true;
            this.execExpandCollapseAll();
            this.inCommit = false;
        }
        while (!this.autoOpenItems.isEmpty()) {
            object = (ETreeItem)this.autoOpenItems.pop();
            TreePath treePath = this.treeModel.getPathByItem(object);
            if (treePath == null || !this.treeModel.hasChildren(object)) continue;
            this.inCommit = true;
            this.tree.expandPath(treePath);
            this.inCommit = false;
        }
        if (this.activeLineModified) {
            if (this.activeLine > 0) {
                this.inCommit = true;
                object = this.treeModel.getPathByIndex(this.activeLine);
                this.tree.setSelectionPath((TreePath)object);
                this.tree.scrollPathToVisible((TreePath)object);
                this.inCommit = false;
            } else if (this.tree.getSelectionCount() != 0) {
                this.inCommit = true;
                this.tree.clearSelection();
                this.inCommit = false;
            }
            this.activeLineModified = false;
        }
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        super.swing2eloq(dO);
        this.allowRule = 0;
        this.activeLine = this.getActiveLineSelection();
        if (!this.cySet) {
            this.cy = this.activeLine;
        }
        if (dO != null) {
            if (this.cyCached) {
                dO.cache((AbstractControl)this, CY_ATTR_NAME, 4, this.cy);
            }
            if (this.activeLineCached) {
                dO.cache((AbstractControl)this, ACTIVELINE_ATTR_NAME, 4, this.activeLine);
            }
        }
    }

    private void commit() {
        this.inCommit = true;
        while (!this.pendingItemCommands.isEmpty()) {
            ETreeItemCommand eTreeItemCommand = (ETreeItemCommand)this.pendingItemCommands.getFirst();
            switch (eTreeItemCommand.commandId) {
                case 0: {
                    this.treeModel.appendToNode(eTreeItemCommand.cy, eTreeItemCommand.itemRefs);
                    break;
                }
                case 1: {
                    this.treeModel.insertBefore(eTreeItemCommand.cy, eTreeItemCommand.itemRefs);
                    break;
                }
                case 2: {
                    int n = this.getSelection();
                    this.treeModel.modify(eTreeItemCommand.cy, eTreeItemCommand.itemRefs);
                    if (n < eTreeItemCommand.cy || n >= eTreeItemCommand.cy + eTreeItemCommand.count) break;
                    this.setSelection(n);
                    break;
                }
                case 3: {
                    int n = this.getSelection();
                    this.treeModel.remove(eTreeItemCommand.cy, eTreeItemCommand.count == 0);
                    if (n <= 0) break;
                    if (eTreeItemCommand.count == 0) {
                        if (n != eTreeItemCommand.cy) break;
                        this.setSelection(n);
                        break;
                    }
                    if (n >= eTreeItemCommand.cy) break;
                    this.setSelection(n);
                    break;
                }
                case 4: {
                    this.treeModel.clear();
                    break;
                }
                case 5: {
                    TreePath treePath = this.treeModel.getPathByIndex(eTreeItemCommand.cy);
                    ETreeItem eTreeItem = (ETreeItem)treePath.getLastPathComponent();
                    if (eTreeItem.leaf || !this.treeModel.hasChildren(eTreeItem)) break;
                    this.tree.expandPath(treePath);
                    break;
                }
                case 6: {
                    TreePath treePath = this.treeModel.getPathByIndex(eTreeItemCommand.cy);
                    ETreeItem eTreeItem = (ETreeItem)treePath.getLastPathComponent();
                    if (eTreeItem.leaf || !this.treeModel.hasChildren(eTreeItem)) break;
                    this.tree.collapsePath(treePath);
                    break;
                }
            }
            this.pendingItemCommands.removeFirst();
        }
        this.inCommit = false;
    }

    private void safeCommit() {
        if (!this.pendingItemCommands.isEmpty()) {
            SafeRunnable.execute(new SafeRunnable(){

                public void runSafe() {
                    ETree.this.commit();
                }
            });
        }
    }

    public Component getTargetPeer() {
        return this.tree;
    }

    public Component getFocusPeer() {
        return this.tree;
    }

    public int getRule() {
        if (this.triggerExpand) {
            return this.emptyNode;
        }
        return super.getRule();
    }

    public void ruleProcessed() {
        this.triggerExpand = false;
        super.ruleProcessed();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.inCommit && this.allowRule == 1 && this.rule > 0 && (this.mouseDown && this.mouseTriggerRule || !this.mouseDown && this.singleClick > 1)) {
            this.allowRule = 2;
            this.getRuleManager().fireRule(this);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        ETreeItem eTreeItem = (ETreeItem)treeExpansionEvent.getPath().getLastPathComponent();
        this.cy = this.treeModel.items.indexOf(eTreeItem);
        if (!eTreeItem.leaf && !this.treeModel.hasChildren(eTreeItem)) {
            if (this.emptyNode > 0) {
                this.autoOpenItems.push(eTreeItem);
                this.triggerExpand = true;
                if (!this.inCommit && this.allowRule == 1 && this.rule > 0) {
                    this.allowRule = 2;
                    this.getRuleManager().fireRule(this);
                    this.cySet = true;
                    if (this.emptyNodeAuto) {
                        eTreeItem.emptyNodeAuto = true;
                    }
                }
            }
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        ETreeItem eTreeItem = (ETreeItem)treeExpansionEvent.getPath().getLastPathComponent();
        if (eTreeItem.emptyNodeAuto && this.treeModel.hasChildren(eTreeItem)) {
            this.inCommit = true;
            int n = this.getSelection();
            int n2 = this.treeModel.items.indexOf(eTreeItem);
            this.treeModel.remove(n2, true);
            if (n == n2) {
                this.setSelection(n);
            }
            this.inCommit = false;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 224: 
            case 225: {
                return;
            }
            case 10: 
            case 32: {
                if (n == 10 && this.parent.checkForFunctionKey(keyEvent)) {
                    keyEvent.consume();
                    return;
                }
                if (this.allowRule == 1 && this.rule > 0 && this.treeModel.items.size() > 0 && this.tree.getSelectionCount() > 0) {
                    this.allowRule = 2;
                    this.getRuleManager().fireRule(this);
                }
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMousePressed(MouseEvent mouseEvent) {
        StartUp.Delay delay;
        StartUp.Delay delay2 = StartUp.delay;
        if (delay2.singleClick > 0) {
            long l = System.nanoTime();
            delay = delay2;
            synchronized (delay) {
                delay2.mousePressed[1] = delay2.mousePressed[0];
                delay2.mousePressed[0] = l;
            }
        }
        if (this.processRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        if (this.consumeInputEvent(mouseEvent)) {
            return;
        }
        this.mouseDown = true;
        this.mouseTriggerRule = this.allowRule == 1 && this.rule > 0;
        ControlsManager.RuleManager ruleManager = this.getRuleManager();
        if (this.mouseTriggerRule) {
            ruleManager.prepareOverride(this, mouseEvent);
            this.cancelOverride = true;
        }
        if (ruleManager.getFocus() != this) {
            ruleManager.requestFocus(this);
        }
        if (this.mouseTriggerRule) {
            int n = mouseEvent.getClickCount();
            if (this.singleClick == 1 || this.singleClick == 3) {
                if (n < 1) {
                    this.mouseTriggerRule = false;
                }
                if (delay2.singleClick > 0 && n == 1) {
                    this.mouseTriggerRule = false;
                    this.cancelOverride = false;
                    delay = delay2;
                    synchronized (delay) {
                        if (delay2.singleClickTimer != null) {
                            delay2.singleClickTimer.stop();
                        }
                        delay2.singleClickTimer = new Timer(delay2.singleClick, new SingleClickTimer());
                        delay2.singleClickTimer.setRepeats(false);
                        delay2.singleClickTimer.start();
                    }
                }
            } else {
                this.mouseTriggerRule = false;
            }
            if (n > 1) {
                if (delay2.singleClick > 0) {
                    delay = delay2;
                    synchronized (delay) {
                        if (delay2.singleClickTimer != null) {
                            delay2.singleClickTimer.stop();
                            delay2.singleClickTimer = null;
                        }
                    }
                }
                if (this.fireMouseRule(mouseEvent, false)) {
                    mouseEvent.consume();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseReleased(MouseEvent mouseEvent) {
        StartUp.Delay delay = StartUp.delay;
        if (delay.singleClick > 0) {
            long l = System.nanoTime();
            StartUp.Delay delay2 = delay;
            synchronized (delay2) {
                delay.mouseReleased[0] = delay.mouseReleased[1];
                delay.mouseReleased[1] = l;
            }
        }
        if (this.consumeRightMouseButtonEvent(mouseEvent)) {
            return;
        }
        if (this.consumeInputEvent(mouseEvent)) {
            return;
        }
        this.mouseDown = false;
        if (this.cancelOverride && this.allowRule == 1 && this.rule > 0) {
            this.getRuleManager().cancelOverride();
        }
        this.cancelOverride = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseClicked(MouseEvent mouseEvent) {
        StartUp.Delay delay = StartUp.delay;
        if (delay.singleClick > 0) {
            StartUp.Delay delay2 = delay;
            synchronized (delay2) {
                long l;
                if (mouseEvent.getClickCount() > 1 && (l = (delay.mousePressed[0] - delay.mouseReleased[0]) / 1000000L) > (long)delay.singleClick) {
                    delay.singleClick = (int)l;
                }
            }
        }
        if (!this.consumeRightMouseButtonEvent(mouseEvent)) {
            this.consumeInputEvent(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseTriggerRule && this.allowRule == 1 && this.rule > 0 && !mouseEvent.isConsumed() && mouseEvent.getClickCount() == 1) {
            this.fireMouseRule(mouseEvent, true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private boolean fireMouseRule(MouseEvent mouseEvent, boolean bl) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && treePath.getPathCount() > 0) {
            ETreeItem eTreeItem;
            if (bl && !(eTreeItem = (ETreeItem)treePath.getLastPathComponent()).leaf) {
                return false;
            }
            this.allowRule = 2;
            if (StartUp.delay.singleClickTimer == null) {
                this.getRuleManager().fireRule(this);
            }
            return true;
        }
        return false;
    }

    private int getSelection() {
        ETreeItem eTreeItem;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (eTreeItem = (ETreeItem)treePath.getLastPathComponent()) != null) {
            return this.treeModel.items.indexOf(eTreeItem);
        }
        return 0;
    }

    private void setSelection(int n) {
        if (n > 0 && n < this.treeModel.items.size()) {
            TreePath treePath = this.treeModel.getPathByIndex(n);
            this.tree.setSelectionPath(treePath);
        } else {
            this.tree.clearSelection();
        }
    }

    public void fontModified(Font font) {
        super.fontModified(font);
        Color color = this.tree.getBackground();
        this.tree.updateUI();
        this.tree.setBackground(color);
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    private int setAdd(String string) {
        return this.setAdd(string, 0);
    }

    private int parseLines(ETreeItemCommand eTreeItemCommand, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, this.delimiter);
            String string3 = "";
            boolean bl = true;
            boolean bl2 = false;
            int n = -1;
            if (!stringTokenizer2.hasMoreTokens()) continue;
            if (!string2.startsWith(this.delimiter)) {
                string3 = stringTokenizer2.nextToken();
            }
            try {
                if (string3.endsWith("+")) {
                    if (string3.length() > 1) {
                        n = new Integer(string3.substring(0, string3.length() - 1));
                    }
                    bl = false;
                    bl2 = true;
                } else if (string3.endsWith("-")) {
                    if (string3.length() > 1) {
                        n = new Integer(string3.substring(0, string3.length() - 1));
                    }
                    bl = false;
                } else if (string3.length() > 0) {
                    n = new Integer(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return 11;
            }
            if (!stringTokenizer2.hasMoreTokens()) {
                return 11;
            }
            String string4 = stringTokenizer2.nextToken();
            UnifiedData unifiedData = stringTokenizer2.hasMoreTokens() ? new UnifiedData(stringTokenizer2.nextToken()) : null;
            ETreeItem eTreeItem = new ETreeItem(n, string4, bl, unifiedData);
            if (bl2) {
                this.autoOpenItems.push(eTreeItem);
            }
            eTreeItemCommand.itemRefs.add(eTreeItem);
        }
        eTreeItemCommand.count = eTreeItemCommand.itemRefs.size();
        return 0;
    }

    private int setAdd(String string, int n) {
        ETreeItemCommand eTreeItemCommand = new ETreeItemCommand();
        eTreeItemCommand.commandId = 0;
        eTreeItemCommand.cy = n;
        int n2 = this.parseLines(eTreeItemCommand, string);
        if (n2 != 0) {
            return n2;
        }
        if (eTreeItemCommand.count > 0) {
            this.pendingItemCommands.addLast(eTreeItemCommand);
        }
        this.isModified = true;
        return n2;
    }

    private int setIns(String string, int n) {
        if (n == 0) {
            n = this.cy;
        }
        if (n < 1) {
            return 11;
        }
        ETreeItemCommand eTreeItemCommand = new ETreeItemCommand();
        eTreeItemCommand.commandId = 1;
        eTreeItemCommand.cy = n;
        int n2 = this.parseLines(eTreeItemCommand, string);
        if (n2 != 0) {
            return n2;
        }
        if (eTreeItemCommand.count > 0) {
            this.pendingItemCommands.addLast(eTreeItemCommand);
        }
        this.isModified = true;
        return n2;
    }

    private void setContent(String string) {
        this.setClear();
        this.setAdd(string, 0);
    }

    private String getContent() {
        this.safeCommit();
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.treeModel.items.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(this.getLine(i));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void setCy(int n) {
        this.safeCommit();
        if (n >= 1 && n < this.treeModel.items.size()) {
            this.cy = n;
        }
    }

    private int getAddCy() {
        this.safeCommit();
        return this.addCy;
    }

    private void setClear() {
        ETreeItemCommand eTreeItemCommand = new ETreeItemCommand();
        eTreeItemCommand.commandId = 4;
        this.pendingItemCommands.addLast(eTreeItemCommand);
        this.cy = 0;
        this.activeLine = 0;
        this.isModified = true;
    }

    private void setActiveLine(int n) {
        this.safeCommit();
        if (n >= 0 && n < this.treeModel.items.size()) {
            this.activeLine = n;
            this.activeLineModified = true;
            this.isModified = true;
        }
    }

    private int getActiveLine() {
        return this.activeLine;
    }

    private int setLine(String string, int n) {
        if (n == 0) {
            n = this.cy;
        }
        if (n < 1) {
            return 11;
        }
        ETreeItemCommand eTreeItemCommand = new ETreeItemCommand();
        eTreeItemCommand.commandId = 2;
        eTreeItemCommand.cy = n;
        int n2 = this.parseLines(eTreeItemCommand, string);
        if (n2 != 0) {
            return n2;
        }
        this.pendingItemCommands.addLast(eTreeItemCommand);
        this.isModified = true;
        return 0;
    }

    private String getLine(int n) {
        this.safeCommit();
        if (n == 0) {
            n = this.cy;
        }
        String string = "";
        if (n >= 1 && n < this.treeModel.items.size()) {
            ETreeItem eTreeItem = (ETreeItem)this.treeModel.items.get(n);
            String string2 = "";
            if (!eTreeItem.leaf) {
                string2 = this.autoOpenItems.contains(eTreeItem) || this.tree.isExpanded(this.treeModel.getPathByIndex(n)) ? "+" : "-";
            }
            string = eTreeItem.indent + string2 + this.delimiter + eTreeItem.label;
        }
        return string;
    }

    private int getLines() {
        this.safeCommit();
        int n = this.treeModel.items.size();
        return n > 0 ? n - 1 : 0;
    }

    private int setOpen(int n, int n2) {
        if (n2 == 0) {
            n2 = this.cy;
        }
        if (n2 < 1) {
            return 11;
        }
        if (n != 0 && this.applyExpandCollapseAll_Command == 6) {
            this.safeCommit();
            if (n2 >= 1 && n2 < this.treeModel.items.size()) {
                ETreeItem eTreeItem = (ETreeItem)this.treeModel.items.get(n2);
                this.autoOpenItems.push(eTreeItem);
                this.isModified = true;
            }
        } else {
            this.applyExpandCollapseAll_Command = 0;
            this.applyExpandCollapseAll_Line = 0;
            ETreeItemCommand eTreeItemCommand = new ETreeItemCommand();
            eTreeItemCommand.commandId = n == 0 ? 6 : 5;
            eTreeItemCommand.cy = n2;
            this.pendingItemCommands.addLast(eTreeItemCommand);
            if (n == 0 && this.tree.isValid()) {
                this.safeCommit();
            } else {
                this.isModified = true;
            }
        }
        return 0;
    }

    private int getOpen(int n) {
        ETreeItem eTreeItem;
        this.safeCommit();
        if (n == 0) {
            n = this.cy;
        }
        if (n >= 1 && n < this.treeModel.items.size() && !(eTreeItem = (ETreeItem)this.treeModel.items.get(n)).leaf && (this.autoOpenItems.contains(eTreeItem) || this.tree.isExpanded(this.treeModel.getPathByIndex(n)))) {
            return 1;
        }
        return 0;
    }

    private int setOpenAll(int n, int n2) {
        this.applyExpandCollapseAll_Command = n == 0 ? 6 : 5;
        this.applyExpandCollapseAll_Line = n2;
        if (this.tree.isValid()) {
            this.safeCommit();
            this.inCommit = true;
            this.execExpandCollapseAll();
            this.inCommit = false;
        } else {
            this.autoOpenItems.clear();
            this.isModified = true;
        }
        return 0;
    }

    private void execExpandCollapseAll() {
        block12: {
            boolean bl;
            int n;
            block11: {
                TreePath treePath;
                int n2 = this.applyExpandCollapseAll_Command;
                n = this.applyExpandCollapseAll_Line;
                this.applyExpandCollapseAll_Command = 0;
                this.applyExpandCollapseAll_Line = 0;
                switch (n2) {
                    case 5: {
                        bl = true;
                        break;
                    }
                    case 6: {
                        bl = false;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (n <= 0) break block11;
                TreePath treePath2 = treePath = this.treeModel.getPathByIndex(n);
                int n3 = -1;
                while (treePath2 != null && treePath.isDescendant(treePath2)) {
                    if (bl) {
                        this.tree.expandPath(treePath2);
                    }
                    n3 = n++;
                    treePath2 = this.treeModel.getPathByIndex(n);
                }
                if (bl || n3 < 0) break block12;
                n = n3;
                while ((treePath2 = this.treeModel.getPathByIndex(n)) != null && treePath.isDescendant(treePath2)) {
                    this.tree.collapsePath(treePath2);
                    --n;
                }
                break block12;
            }
            if (bl) {
                for (n = 0; n < this.tree.getRowCount(); ++n) {
                    this.tree.expandRow(n);
                }
            } else {
                n = this.tree.getRowCount();
                while (--n >= 0) {
                    this.tree.collapseRow(n);
                }
            }
        }
    }

    private int getChildren(int n) {
        this.safeCommit();
        if (n == 0) {
            n = this.cy;
        }
        if (n < 1 || n >= this.treeModel.items.size()) {
            return 0;
        }
        return this.treeModel.getChildCount(this.treeModel.items.get(n));
    }

    private void setEmptyNode(int n) {
        this.emptyNode = n;
    }

    private int getEmptyNode() {
        return this.emptyNode;
    }

    private void setEmptyNodeAuto(int n) {
        this.emptyNodeAuto = n != 0;
    }

    private int getEmptyNodeAuto() {
        return this.emptyNodeAuto ? 1 : 0;
    }

    private int setUnifiedData(UnifiedData unifiedData, int n) {
        this.safeCommit();
        if (n == 0) {
            n = this.cy;
        }
        if (n < 1 || n >= this.treeModel.items.size()) {
            return 11;
        }
        ((ETreeItem)this.treeModel.items.get(n)).uData = unifiedData;
        return 0;
    }

    private int setUData(String string, int n) {
        return this.setUnifiedData(new UnifiedData(string), n);
    }

    private int setUData(int n, int n2) {
        return this.setUnifiedData(new UnifiedData(n), n2);
    }

    private int getUData(Dlg.Rs.GET gET, int n) {
        this.safeCommit();
        if (n == 0) {
            n = this.cy;
        }
        if (n < 1 || n >= this.treeModel.items.size()) {
            return 11;
        }
        UnifiedData unifiedData = ((ETreeItem)this.treeModel.items.get(n)).uData;
        if (unifiedData == null) {
            gET.setValueString(null);
        } else if (unifiedData.isStringData()) {
            gET.setValueString(unifiedData.getStringData());
        } else {
            gET.setValueInt(unifiedData.getIntData());
        }
        return 0;
    }

    private String getUDataBuf() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.treeModel.items.size();
        for (int i = 1; i < n; ++i) {
            UnifiedData unifiedData = ((ETreeItem)this.treeModel.items.get(i)).uData;
            if (unifiedData == null) {
                stringBuilder.append("V");
                continue;
            }
            if (unifiedData.isStringData()) {
                String string = unifiedData.getStringData();
                stringBuilder.append("X");
                stringBuilder.append(String.valueOf(string.length()));
                stringBuilder.append("~");
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append("N");
            stringBuilder.append(String.valueOf(unifiedData.getIntData()));
        }
        stringBuilder.append("$");
        return stringBuilder.toString();
    }

    private int setDel(int n, int n2) {
        if (n2 == 0) {
            n2 = this.cy;
        }
        if (n2 < 1) {
            return 11;
        }
        ETreeItemCommand eTreeItemCommand = new ETreeItemCommand();
        eTreeItemCommand.commandId = 3;
        eTreeItemCommand.count = n;
        eTreeItemCommand.cy = n2;
        this.pendingItemCommands.addLast(eTreeItemCommand);
        this.isModified = true;
        return 0;
    }

    private int getParent(int n) {
        this.safeCommit();
        if (n == 0) {
            n = this.cy;
        }
        return this.treeModel.getParentIndex(n);
    }

    private int setSingleClick(int n) {
        if (n < 0 || n > 3) {
            return 11;
        }
        this.singleClick = n;
        return 0;
    }

    private int getSingleClick() {
        return this.singleClick;
    }

    private void setUseIcons(int n) {
        this.useIcons = n != 0;
        this.isModified = true;
    }

    private int getUseIcons() {
        return this.useIcons ? 1 : 0;
    }

    public void setRuleOverride(int n) {
        this.ruleOverride = n != 0;
    }

    public int getRuleOverride() {
        return this.ruleOverride ? 1 : 0;
    }

    private final void setDropMode(int n) {
        this.acceptValidDropOnly = n != 0;
    }

    private final int getDropMode() {
        return this.acceptValidDropOnly ? 1 : 0;
    }

    private final int getDropLine() {
        return this.dropLine;
    }

    public void enableDragDrop() {
        this.tree.setDropMode(DropMode.USE_SELECTION);
        this.setDragDropHandler(new DragDrop());
    }

    private int getActiveLineSelection() {
        ETreeItem eTreeItem;
        TreePath treePath = this.inDrag ? this.dragSaveSelectionPath : this.tree.getSelectionPath();
        if (treePath != null && (eTreeItem = (ETreeItem)treePath.getLastPathComponent()) != null) {
            return this.treeModel.items.indexOf(eTreeItem);
        }
        return 0;
    }

    static {
        attributeList.put(DELIMITER_ATTR_NAME, new Integer(0));
        attributeList.put(ADD_ATTR_NAME, new Integer(1));
        attributeList.put(CONTENT_ATTR_NAME, new Integer(2));
        attributeList.put(LINE_BUF_ATTR_NAME, new Integer(2));
        attributeList.put(CY_ATTR_NAME, new Integer(3));
        attributeList.put(CLEAR_ATTR_NAME, new Integer(4));
        attributeList.put(ACTIVELINE_ATTR_NAME, new Integer(5));
        attributeList.put(LINE_ATTR_NAME, new Integer(6));
        attributeList.put(OPEN_ATTR_NAME, new Integer(7));
        attributeList.put(CHILDREN_ATTR_NAME, new Integer(8));
        attributeList.put(INS_ATTR_NAME, new Integer(9));
        attributeList.put(EMPTYNODE_ATTR_NAME, new Integer(10));
        attributeList.put(EMPTYNODEAUTO_ATTR_NAME, new Integer(11));
        attributeList.put(UDATA_ATTR_NAME, new Integer(12));
        attributeList.put(UDATA_BUF_ATTR_NAME, new Integer(13));
        attributeList.put(DEL_ATTR_NAME, new Integer(14));
        attributeList.put(PARENT_ATTR_NAME, new Integer(15));
        attributeList.put(SINGLECLICK_ATTR_NAME, new Integer(16));
        attributeList.put(USEICONS_ATTR_NAME, new Integer(17));
        attributeList.put(OPENALL_ATTR_NAME, new Integer(18));
        attributeList.put(LINES_ATTR_NAME, new Integer(19));
        attributeList.put(RULEOVERRIDE_ATTR_NAME, new Integer(20));
        attributeList.put(DROP_MODE_ATTR_NAME, new Integer(21));
        attributeList.put(DROP_LINE_ATTR_NAME, new Integer(22));
        attributeList.put(ADDCY_ATTR_NAME, new Integer(23));
    }

    class EJTree
    extends JTree {
        EJTree(TreeModel treeModel) {
            super(treeModel);
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (ETree.this.ignoreEvent(aWTEvent)) {
                ETree.this.allowRule = 0;
                return;
            }
            if (ETree.this.allowRule == 0) {
                ETree.this.allowRule = 1;
            }
            super.processEvent(aWTEvent);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                ETree.this.onMousePressed(mouseEvent);
            } else if (mouseEvent.getID() == 500) {
                ETree.this.onMouseClicked(mouseEvent);
            } else if (mouseEvent.getID() == 502) {
                ETree.this.onMouseReleased(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                super.processMouseEvent(mouseEvent);
            }
        }

        public void updateUI() {
            CellRenderer cellRenderer = null;
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof CellRenderer) {
                cellRenderer = (CellRenderer)treeCellRenderer;
                this.setCellRenderer(cellRenderer.getDefaultRenderer());
            }
            super.updateUI();
            if (cellRenderer != null) {
                cellRenderer.setDefaultRenderer(this.getCellRenderer());
                this.setCellRenderer(cellRenderer);
                Debug.log(2, 2, "NOTE: Tree '" + ETree.this.getPath() + "' UI updated");
            }
        }
    }

    final class CellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer defaultRenderer;
        private boolean iconsEnabled = true;

        public CellRenderer(TreeCellRenderer treeCellRenderer) {
            this.setDefaultRenderer(treeCellRenderer);
        }

        public TreeCellRenderer getDefaultRenderer() {
            return this.defaultRenderer;
        }

        public void setDefaultRenderer(TreeCellRenderer treeCellRenderer) {
            this.defaultRenderer = treeCellRenderer;
            this.updateIcons();
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            ETreeItem eTreeItem = (ETreeItem)object;
            String string = eTreeItem.label;
            for (int i = 0; i < 2; ++i) {
                try {
                    Component component = this.defaultRenderer != null ? this.defaultRenderer.getTreeCellRendererComponent(jTree, string, bl, bl2, eTreeItem.leaf, n, bl4) : super.getTreeCellRendererComponent(jTree, string, bl, bl2, eTreeItem.leaf, n, bl4);
                    component.setFont(ETree.this.fontReference.getFontObject(ETree.this));
                    if (!bl) {
                        component.setBackground(jTree.getBackground());
                        component.setForeground(jTree.getForeground());
                    }
                    if (component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setOpaque(!bl);
                        if (HtmlTool.isHtml(string) && jComponent.getClientProperty("html") == null) {
                            BasicHTML.updateRenderer(jComponent, string);
                        }
                    }
                    return component;
                }
                catch (Throwable throwable) {
                    if (i != 0) {
                        throw new RuntimeException(throwable);
                    }
                    System.err.println("'" + ETree.this.getPath() + "' " + throwable + ": Tree[" + n + "] = \"" + string + "\"");
                    string = HtmlTool.text(string);
                    continue;
                }
            }
            return null;
        }

        public void enableIcons(boolean bl) {
            if (this.iconsEnabled != bl) {
                this.iconsEnabled = bl;
                this.updateIcons();
            }
        }

        private void updateIcons() {
            DefaultTreeCellRenderer defaultTreeCellRenderer = this.defaultRenderer instanceof DefaultTreeCellRenderer ? (DefaultTreeCellRenderer)this.defaultRenderer : this;
            if (this.iconsEnabled) {
                defaultTreeCellRenderer.setLeafIcon(defaultTreeCellRenderer.getDefaultLeafIcon());
                defaultTreeCellRenderer.setClosedIcon(defaultTreeCellRenderer.getDefaultClosedIcon());
                defaultTreeCellRenderer.setOpenIcon(defaultTreeCellRenderer.getDefaultOpenIcon());
            } else {
                defaultTreeCellRenderer.setLeafIcon(null);
                defaultTreeCellRenderer.setClosedIcon(null);
                defaultTreeCellRenderer.setOpenIcon(null);
            }
            if (ETree.this.tree != null) {
                ETree.this.tree.repaint();
                ETree.this.tree.revalidate();
            }
        }
    }

    private class ETreeModel
    implements TreeModel {
        private LinkedList items = new LinkedList();
        private ETreeItem root = new ETreeItem("Root");
        private LinkedList treeModelListener = new LinkedList();

        public ETreeModel() {
            this.items.add(this.root);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            ETreeItem eTreeItem = (ETreeItem)object;
            return eTreeItem.leaf;
        }

        public Object getChild(Object object, int n) {
            ETreeItem eTreeItem;
            ETreeItem eTreeItem2 = null;
            ListIterator listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!object.equals(e)) continue;
                eTreeItem2 = (ETreeItem)e;
                break;
            }
            if (eTreeItem2 == null) {
                return null;
            }
            int n2 = 0;
            while (listIterator.hasNext() && (eTreeItem = (ETreeItem)listIterator.next()).indent > eTreeItem2.indent) {
                if (eTreeItem.indent != eTreeItem2.indent + 1 || n2++ != n) continue;
                return eTreeItem;
            }
            return null;
        }

        public int getChildCount(Object object) {
            ETreeItem eTreeItem;
            ETreeItem eTreeItem2 = null;
            ListIterator listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!object.equals(e)) continue;
                eTreeItem2 = (ETreeItem)e;
                break;
            }
            if (eTreeItem2 == null) {
                return 0;
            }
            int n = 0;
            while (listIterator.hasNext() && (eTreeItem = (ETreeItem)listIterator.next()).indent > eTreeItem2.indent) {
                if (eTreeItem.indent != eTreeItem2.indent + 1) continue;
                ++n;
            }
            return n;
        }

        public int getIndexOfChild(Object object, Object object2) {
            ETreeItem eTreeItem;
            ETreeItem eTreeItem2 = null;
            ListIterator listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!object.equals(e)) continue;
                eTreeItem2 = (ETreeItem)e;
                break;
            }
            if (eTreeItem2 == null) {
                return -1;
            }
            int n = 0;
            while (listIterator.hasNext() && (eTreeItem = (ETreeItem)listIterator.next()).indent > eTreeItem2.indent) {
                if (eTreeItem.indent != eTreeItem2.indent + 1) continue;
                if (eTreeItem.equals(object2)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void clear() {
            this.items.clear();
            this.items.add(this.root);
            this.fireTreeStructureChanged();
        }

        public int appendToNode(int n, LinkedList linkedList) {
            int n2;
            ETreeItem eTreeItem;
            if (n < 0 || n >= this.items.size() || linkedList.size() == 0) {
                return 0;
            }
            ListIterator listIterator = this.items.listIterator(n);
            if (n == 0) {
                eTreeItem = null;
                n2 = -1;
            } else {
                eTreeItem = (ETreeItem)listIterator.next();
                n2 = eTreeItem.indent + 1;
            }
            ETreeItem eTreeItem2 = (ETreeItem)linkedList.getFirst();
            int n3 = 0;
            while (listIterator.hasNext()) {
                ETreeItem eTreeItem3 = (ETreeItem)listIterator.next();
                int n4 = eTreeItem3.indent - n2;
                if (n4 < 0) {
                    listIterator.previous();
                    break;
                }
                if (n2 == -1) {
                    n4 = eTreeItem2.indent - eTreeItem3.indent;
                    if (n4 == 1) {
                        eTreeItem = eTreeItem3;
                        n = listIterator.previousIndex();
                        n3 = 0;
                        continue;
                    }
                    if (n4 > 1) {
                        eTreeItem = null;
                    }
                }
                if (n4 != 0) continue;
                ++n3;
            }
            if (eTreeItem == null) {
                return 0;
            }
            n2 = n2 > 0 ? (n2 -= eTreeItem2.indent) : 0;
            int n5 = this.insertSub(linkedList, 0, n2, listIterator, n, n3);
            if (n5 != 0 && n > 0 && n3 == 0 && eTreeItem.leaf) {
                eTreeItem.leaf = false;
                listIterator = this.items.listIterator(n);
                n3 = 0;
                while (listIterator.hasPrevious()) {
                    ETreeItem eTreeItem4 = (ETreeItem)listIterator.previous();
                    --n;
                    int n6 = eTreeItem4.indent - eTreeItem.indent;
                    if (n6 == 0) {
                        ++n3;
                        continue;
                    }
                    if (n6 != -1) continue;
                    this.fireTreeNodesChanged(this.getPathByIndex(n), new int[]{n3}, new Object[]{eTreeItem});
                    break;
                }
            }
            return n5;
        }

        public int insertBefore(int n, LinkedList linkedList) {
            if (n < 1 || n >= this.items.size() || linkedList.size() == 0) {
                return 0;
            }
            ETreeItem eTreeItem = null;
            int n2 = 0;
            int n3 = 0;
            ListIterator listIterator = this.items.listIterator(n);
            ETreeItem eTreeItem2 = (ETreeItem)listIterator.next();
            int n4 = eTreeItem2.indent;
            listIterator.previous();
            int n5 = n;
            while (listIterator.hasPrevious()) {
                eTreeItem2 = (ETreeItem)listIterator.previous();
                --n;
                int n6 = eTreeItem2.indent - n4;
                if (n6 < 0) {
                    if (n6 != -1) break;
                    eTreeItem = eTreeItem2;
                    n2 = n;
                    break;
                }
                if (n6 != 0) continue;
                ++n3;
            }
            if (eTreeItem == null) {
                return 0;
            }
            while (n < n5) {
                if (!listIterator.hasNext()) {
                    throw new RuntimeException("BUG: index=" + n + ", !hasNext");
                }
                listIterator.next();
                ++n;
            }
            ETreeItem eTreeItem3 = (ETreeItem)linkedList.getFirst();
            return this.insertSub(linkedList, 0, n4 -= eTreeItem3.indent, listIterator, n2, n3);
        }

        public int insertSub(LinkedList linkedList, int n, int n2, ListIterator listIterator, int n3, int n4) {
            ETreeItem eTreeItem;
            int n5 = 0;
            int n6 = -1;
            ETreeItem eTreeItem2 = null;
            ListIterator listIterator2 = linkedList.listIterator(n);
            while (listIterator2.hasNext()) {
                int n7;
                ETreeItem eTreeItem3;
                ETreeItem eTreeItem4 = eTreeItem3 = (ETreeItem)listIterator2.next();
                eTreeItem4.indent = eTreeItem4.indent + n2;
                if (n6 >= 0) {
                    n7 = eTreeItem3.indent - n6;
                } else {
                    n6 = eTreeItem3.indent;
                    n7 = 0;
                }
                if (n7 == 0) {
                    if (n5 == 0) {
                        ETree.this.addCy = listIterator.nextIndex();
                    }
                    listIterator.add(eTreeItem3);
                    eTreeItem2 = eTreeItem3;
                    ++n5;
                    continue;
                }
                if (n7 == 1) {
                    if (eTreeItem2 != null) {
                        eTreeItem2.leaf = false;
                    }
                } else if (n7 < 0) break;
                eTreeItem2 = null;
            }
            if (n5 == 0) {
                return 0;
            }
            int n8 = n5;
            int[] nArray = new int[n8];
            Object[] objectArray = new Object[n8];
            int n9 = n8;
            while (--n9 >= 0) {
                if (!listIterator.hasPrevious()) {
                    throw new RuntimeException("BUG: siblingIndex=" + n9 + ", !hasPrevious");
                }
                eTreeItem = (ETreeItem)listIterator.previous();
                nArray[n9] = n9 + n4;
                objectArray[n9] = eTreeItem;
            }
            this.fireTreeNodesInserted(this.getPathByIndex(n3), nArray, objectArray);
            eTreeItem2 = null;
            listIterator2 = linkedList.listIterator(n);
            n9 = n;
            while (listIterator2.hasNext()) {
                eTreeItem = (ETreeItem)listIterator2.next();
                int n10 = eTreeItem.indent - n6;
                if (n10 == 0) {
                    if (n8 == 0) break;
                    eTreeItem2 = eTreeItem;
                    --n8;
                    if (!listIterator.hasNext()) {
                        throw new RuntimeException("BUG: siblingIndex=" + n8 + ", !hasNext");
                    }
                    listIterator.next();
                } else {
                    if (n10 == 1) {
                        if (eTreeItem2 != null) {
                            n5 += this.insertSub(linkedList, n9, 0, listIterator, listIterator.previousIndex(), 0);
                        }
                    } else if (n10 < 0) {
                        if (n8 == 0) break;
                        throw new RuntimeException("BUG: item.indent=" + eTreeItem.indent + " indent=" + n6);
                    }
                    eTreeItem2 = null;
                }
                ++n9;
            }
            if (n8 != 0) {
                throw new RuntimeException("BUG: siblingIndex=" + n8);
            }
            return n5;
        }

        public int modify(int n, LinkedList linkedList) {
            if (linkedList.size() == 0) {
                return 0;
            }
            if (n == 0 || n == this.items.size()) {
                return this.appendToNode(0, linkedList);
            }
            if (n < 1 || n >= this.items.size()) {
                return 0;
            }
            ETreeItem eTreeItem = null;
            int n2 = 0;
            int n3 = 0;
            ListIterator listIterator = this.items.listIterator(n);
            ETreeItem eTreeItem2 = (ETreeItem)listIterator.next();
            int n4 = eTreeItem2.indent;
            listIterator.previous();
            int n5 = n;
            while (listIterator.hasPrevious()) {
                eTreeItem2 = (ETreeItem)listIterator.previous();
                --n;
                int n6 = eTreeItem2.indent - n4;
                if (n6 < 0) {
                    if (n6 != -1) break;
                    eTreeItem = eTreeItem2;
                    n2 = n;
                    break;
                }
                if (n6 != 0) continue;
                ++n3;
            }
            if (eTreeItem == null) {
                return 0;
            }
            while (n < n5) {
                if (!listIterator.hasNext()) {
                    throw new RuntimeException("BUG: index=" + n + ", !hasNext");
                }
                listIterator.next();
                ++n;
            }
            ETreeItem eTreeItem3 = (ETreeItem)linkedList.getFirst();
            return this.modifySub(linkedList, 0, n4 -= eTreeItem3.indent, listIterator, n2, n3);
        }

        public int modifySub(LinkedList linkedList, int n, int n2, ListIterator listIterator, int n3, int n4) {
            ETreeItem eTreeItem;
            int n5 = 0;
            int n6 = -1;
            ListIterator listIterator2 = linkedList.listIterator(n);
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                int n7;
                ETreeItem eTreeItem2;
                ETreeItem eTreeItem3 = (ETreeItem)listIterator.next();
                eTreeItem = eTreeItem2 = (ETreeItem)listIterator2.next();
                eTreeItem.indent = eTreeItem.indent + n2;
                if (eTreeItem2.indent != eTreeItem3.indent) {
                    listIterator.previous();
                    break;
                }
                if (n6 >= 0) {
                    n7 = eTreeItem2.indent - n6;
                } else {
                    n6 = eTreeItem2.indent;
                    n7 = 0;
                }
                if (n7 == 0) {
                    if (eTreeItem2.leaf && !eTreeItem3.leaf) {
                        if (listIterator.hasNext()) {
                            ETreeItem eTreeItem4 = (ETreeItem)listIterator.next();
                            if (eTreeItem4.indent > eTreeItem3.indent) {
                                this.removeSub(this.items.indexOf(eTreeItem3), eTreeItem4, listIterator);
                            } else {
                                listIterator.previous();
                            }
                        }
                        listIterator.previous();
                        listIterator.next();
                        ETree.this.inCommit = true;
                        ETree.this.tree.collapsePath(this.getPathByItem(eTreeItem3));
                        ETree.this.inCommit = false;
                    }
                    listIterator.set(eTreeItem2);
                    ++n5;
                    continue;
                }
                if (n7 >= 0) continue;
                listIterator.previous();
                break;
            }
            if (n5 == 0) {
                return 0;
            }
            int n8 = n5;
            int[] nArray = new int[n8];
            Object[] objectArray = new Object[n8];
            int n9 = n8;
            while (n9 > 0) {
                if (!listIterator.hasPrevious()) {
                    throw new RuntimeException("BUG: siblingIndex=" + n9 + ", !hasPrevious");
                }
                eTreeItem = (ETreeItem)listIterator.previous();
                int n10 = eTreeItem.indent - n6;
                if (n10 == 0) {
                    nArray[--n9] = n9 + n4;
                    objectArray[n9] = eTreeItem;
                    continue;
                }
                if (n10 >= 0) continue;
                throw new RuntimeException("BUG: item.indent=" + eTreeItem.indent + " indent=" + n6);
            }
            this.fireTreeNodesChanged(this.getPathByIndex(n3), nArray, objectArray);
            eTreeItem = null;
            listIterator2 = linkedList.listIterator(n);
            n9 = n;
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                ETreeItem eTreeItem5 = (ETreeItem)listIterator.next();
                ETreeItem eTreeItem6 = (ETreeItem)listIterator2.next();
                if (eTreeItem6.indent != eTreeItem5.indent) {
                    listIterator.previous();
                    break;
                }
                int n11 = eTreeItem6.indent - n6;
                if (n11 == 0) {
                    if (n8 == 0) break;
                    eTreeItem = eTreeItem5;
                    --n8;
                } else {
                    if (n11 == 1) {
                        if (eTreeItem != null) {
                            listIterator.previous();
                            n5 += this.modifySub(linkedList, n9, 0, listIterator, listIterator.previousIndex(), 0);
                            while (listIterator2.hasNext()) {
                                eTreeItem6 = (ETreeItem)listIterator2.next();
                                if (eTreeItem6.indent != n6) continue;
                                listIterator2.previous();
                                break;
                            }
                        }
                    } else if (n11 < 0) {
                        if (n8 == 0) {
                            listIterator.previous();
                            break;
                        }
                        throw new RuntimeException("BUG: item.indent=" + eTreeItem5.indent + " indent=" + n6);
                    }
                    eTreeItem = null;
                }
                ++n9;
            }
            if (n8 != 0) {
                throw new RuntimeException("BUG: siblingIndex=" + n8);
            }
            return n5;
        }

        public int remove(int n, boolean bl) {
            int n2 = 0;
            if (n > 0 && n < this.items.size()) {
                Object object;
                Object object2;
                ETreeItem eTreeItem;
                boolean bl2;
                ListIterator listIterator = this.items.listIterator(n);
                ETreeItem eTreeItem2 = (ETreeItem)listIterator.next();
                if (listIterator.hasNext()) {
                    ETreeItem eTreeItem3 = (ETreeItem)listIterator.next();
                    if (eTreeItem3.indent > eTreeItem2.indent) {
                        n2 += this.removeSub(n, eTreeItem3, listIterator);
                    } else {
                        listIterator.previous();
                    }
                }
                boolean bl3 = bl2 = !bl;
                if (!bl2 && n2 == 0) {
                    return 0;
                }
                listIterator.previous();
                if (bl2) {
                    listIterator.remove();
                    ++n2;
                }
                int n3 = 0;
                if (bl2) {
                    eTreeItem = null;
                    while (listIterator.hasPrevious()) {
                        ETreeItem eTreeItem4 = (ETreeItem)listIterator.previous();
                        if (eTreeItem4.indent < eTreeItem2.indent) {
                            eTreeItem = eTreeItem4;
                            break;
                        }
                        if (eTreeItem4.indent != eTreeItem2.indent) continue;
                        ++n3;
                    }
                    if (eTreeItem == null) {
                        throw new RuntimeException("BUG: parent=null");
                    }
                } else {
                    eTreeItem = eTreeItem2;
                }
                boolean bl4 = false;
                if (!eTreeItem.leaf) {
                    listIterator.next();
                    if (listIterator.hasNext()) {
                        object2 = (ETreeItem)listIterator.next();
                        if (((ETreeItem)object2).indent > eTreeItem.indent) {
                            bl4 = true;
                        }
                        listIterator.previous();
                    }
                    listIterator.previous();
                }
                object2 = new LinkedList<ETreeItem>();
                ((LinkedList)object2).addFirst(eTreeItem);
                int n4 = eTreeItem.indent;
                boolean bl5 = false;
                int n5 = 0;
                while (listIterator.hasPrevious()) {
                    object = (ETreeItem)listIterator.previous();
                    if (((ETreeItem)object).indent < n4) {
                        ((LinkedList)object2).addFirst(object);
                        n4 = ((ETreeItem)object).indent;
                        bl5 = true;
                        continue;
                    }
                    if (bl5 || ((ETreeItem)object).indent != eTreeItem.indent) continue;
                    ++n5;
                }
                if (bl2) {
                    this.fireTreeNodesRemoved(new TreePath(((LinkedList)object2).toArray()), new int[]{n3}, new Object[]{eTreeItem2});
                }
                if (!eTreeItem.leaf && !bl4 && ((LinkedList)object2).size() > 1) {
                    ((LinkedList)object2).removeLast();
                    object = new TreePath(((LinkedList)object2).toArray());
                    ETreeItem eTreeItem5 = new ETreeItem(eTreeItem);
                    int n6 = this.items.indexOf(eTreeItem);
                    this.items.remove(n6);
                    this.fireTreeNodesRemoved((TreePath)object, new int[]{n5}, new Object[]{eTreeItem});
                    this.items.add(n6, eTreeItem5);
                    this.fireTreeNodesInserted((TreePath)object, new int[]{n5}, new Object[]{eTreeItem5});
                }
            }
            return n2;
        }

        private int removeSub(int n, ETreeItem object, ListIterator listIterator) {
            Object object2;
            int n2 = ((ETreeItem)object).indent;
            int n3 = 0;
            int n4 = 1;
            while (listIterator.hasNext()) {
                object2 = (ETreeItem)listIterator.next();
                if (((ETreeItem)object2).indent < n2) {
                    listIterator.previous();
                    break;
                }
                if (((ETreeItem)object2).indent > n2) {
                    n3 += this.removeSub(n + n4, (ETreeItem)object2, listIterator);
                    continue;
                }
                object = object2;
                ++n4;
            }
            object2 = new int[n4];
            Object[] objectArray = new Object[n4];
            while (n4 > 0 && listIterator.hasPrevious()) {
                object = (ETreeItem)listIterator.previous();
                if (((ETreeItem)object).indent != n2) {
                    throw new RuntimeException("BUG: child.indent=" + ((ETreeItem)object).indent + " indent=" + n2);
                }
                object2[--n4] = n4;
                objectArray[n4] = object;
                listIterator.remove();
                ++n3;
            }
            if (n4 != 0) {
                throw new RuntimeException("BUG: childIndex=" + n4);
            }
            this.fireTreeNodesRemoved(this.getPathByIndex(n), (int[])object2, objectArray);
            return n3;
        }

        public TreePath getPathByIndex(int n) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (n > 0 && n < this.items.size()) {
                ListIterator listIterator = this.items.listIterator(n + 1);
                ETreeItem eTreeItem = (ETreeItem)listIterator.previous();
                linkedList.addFirst(eTreeItem);
                int n2 = eTreeItem.indent;
                while (listIterator.hasPrevious()) {
                    eTreeItem = (ETreeItem)listIterator.previous();
                    if (eTreeItem.indent >= n2) continue;
                    linkedList.addFirst(eTreeItem);
                    n2 = eTreeItem.indent;
                }
            } else {
                linkedList.addFirst(this.getRoot());
            }
            return new TreePath(linkedList.toArray());
        }

        public TreePath getPathByItem(Object object) {
            Object object2;
            ETreeItem eTreeItem = null;
            ListIterator listIterator = this.items.listIterator(this.items.size());
            while (listIterator.hasPrevious()) {
                object2 = listIterator.previous();
                if (!object.equals(object2)) continue;
                eTreeItem = (ETreeItem)object2;
                break;
            }
            object2 = new LinkedList();
            if (eTreeItem != null) {
                ((LinkedList)object2).addFirst(eTreeItem);
                int n = eTreeItem.indent;
                while (listIterator.hasPrevious()) {
                    ETreeItem eTreeItem2 = (ETreeItem)listIterator.previous();
                    if (eTreeItem2.indent >= n) continue;
                    ((LinkedList)object2).addFirst(eTreeItem2);
                    n = eTreeItem2.indent;
                }
            } else {
                ((LinkedList)object2).addFirst(this.getRoot());
            }
            return new TreePath(((LinkedList)object2).toArray());
        }

        public int getParentIndex(int n) {
            if (n >= 0 && n < this.items.size()) {
                ListIterator listIterator = this.items.listIterator(n + 1);
                ETreeItem eTreeItem = (ETreeItem)listIterator.previous();
                int n2 = eTreeItem.indent;
                while (listIterator.hasPrevious()) {
                    eTreeItem = (ETreeItem)listIterator.previous();
                    --n;
                    if (eTreeItem.indent >= n2) continue;
                    return n;
                }
            }
            return 0;
        }

        public boolean hasChildren(Object object) {
            Object object2;
            ETreeItem eTreeItem = null;
            ListIterator listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                object2 = listIterator.next();
                if (!object.equals(object2)) continue;
                eTreeItem = (ETreeItem)object2;
                break;
            }
            if (eTreeItem == null) {
                return false;
            }
            while (listIterator.hasNext() && ((ETreeItem)(object2 = (ETreeItem)listIterator.next())).indent > eTreeItem.indent) {
                if (((ETreeItem)object2).indent != eTreeItem.indent + 1) continue;
                return true;
            }
            return false;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (!this.treeModelListener.contains(treeModelListener)) {
                this.treeModelListener.add(treeModelListener);
            }
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (this.treeModelListener.contains(treeModelListener)) {
                this.treeModelListener.remove(treeModelListener);
            }
        }

        private void fireTreeNodesChanged(TreePath treePath, int[] nArray, Object[] objectArray) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            for (TreeModelListener treeModelListener : this.treeModelListener) {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }

        private void fireTreeNodesInserted(TreePath treePath, int[] nArray, Object[] objectArray) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            for (TreeModelListener treeModelListener : this.treeModelListener) {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        private void fireTreeNodesRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            for (TreeModelListener treeModelListener : this.treeModelListener) {
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }

        private void fireTreeStructureChanged() {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.root});
            for (TreeModelListener treeModelListener : this.treeModelListener) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }
    }

    private class ETreeItemCommand {
        public static final int ETICMD_ADD = 0;
        public static final int ETICMD_INSERT = 1;
        public static final int ETICMD_MODIFY = 2;
        public static final int ETICMD_REMOVE = 3;
        public static final int ETICMD_CLEAR = 4;
        public static final int ETICMD_OPEN = 5;
        public static final int ETICMD_CLOSE = 6;
        public int commandId;
        public int cy;
        public int count;
        public LinkedList itemRefs = new LinkedList();

        private ETreeItemCommand() {
        }
    }

    private class ETreeItem {
        private int indent;
        private String label;
        private UnifiedData uData;
        private boolean leaf;
        private boolean emptyNodeAuto;

        public ETreeItem(String string) {
            this.indent = -1;
            this.label = string;
            this.uData = null;
            this.leaf = false;
            this.emptyNodeAuto = false;
        }

        public ETreeItem(int n, String string, boolean bl, UnifiedData unifiedData) {
            this.indent = n;
            this.label = string;
            this.uData = unifiedData;
            this.leaf = bl;
            this.emptyNodeAuto = false;
        }

        public ETreeItem(ETreeItem eTreeItem) {
            this.indent = eTreeItem.indent;
            this.label = eTreeItem.label;
            this.leaf = eTreeItem.leaf;
            this.emptyNodeAuto = false;
            this.uData = eTreeItem.uData == null ? null : (eTreeItem.uData.isStringData() ? new UnifiedData(eTreeItem.uData.getStringData()) : new UnifiedData(eTreeItem.uData.getIntData()));
        }

        public String toString() {
            return HtmlTool.text(this.label);
        }
    }

    private final class DragDrop
    implements DragDropHandler {
        private DragDrop() {
        }

        public void enableDrag(boolean bl) {
            ETree.this.tree.setDragEnabled(bl);
        }

        public JComponent getDragComponent() {
            return ETree.this.tree;
        }

        public void beginDrag() {
            ETree.this.inDrag = true;
            ETree.this.dragSaveSelectionPath = ETree.this.tree.getSelectionPath();
            ETree.this.dragSaveAllowRule = ETree.this.allowRule;
            ETree.this.allowRule = 2;
        }

        public void dragStarting(InputEvent inputEvent) {
        }

        public void dragFinished(int n) {
        }

        public void dragCanceled() {
        }

        public void endDrag() {
            ETree.this.inCommit = true;
            if (ETree.this.dragSaveSelectionPath != null) {
                ETree.this.tree.setSelectionPath(ETree.this.dragSaveSelectionPath);
                ETree.this.tree.scrollPathToVisible(ETree.this.dragSaveSelectionPath);
            } else {
                ETree.this.tree.clearSelection();
            }
            ETree.this.dragSaveSelectionPath = null;
            ETree.this.allowRule = ETree.this.dragSaveAllowRule;
            ETree.this.inCommit = false;
            ETree.this.inDrag = false;
        }

        public boolean acceptDrop(TransferHandler.TransferSupport transferSupport) {
            if (ETree.this.acceptValidDropOnly) {
                JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
                TreePath treePath = dropLocation.getPath();
                if (treePath == null) {
                    return false;
                }
                ETreeItem eTreeItem = (ETreeItem)treePath.getLastPathComponent();
                if (eTreeItem == null || ETree.this.treeModel.items.indexOf(eTreeItem) < 1) {
                    return false;
                }
            }
            return true;
        }

        public boolean dropped(TransferHandler.TransferSupport transferSupport) {
            ETreeItem eTreeItem;
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            TreePath treePath = dropLocation.getPath();
            ETree.this.dropLine = 0;
            if (treePath != null && (eTreeItem = (ETreeItem)treePath.getLastPathComponent()) != null) {
                ETree.this.dropLine = ETree.this.treeModel.items.indexOf(eTreeItem);
            }
            return ETree.this.acceptValidDropOnly ? ETree.this.dropLine > 0 : true;
        }
    }

    private final class SingleClickTimer
    implements ActionListener {
        private SingleClickTimer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StartUp.delay.singleClickTimer != null && ETree.this.rule != 0 && ETree.this.getSelection() > 0) {
                ETree.this.getRuleManager().fireRule(ETree.this);
            }
        }
    }
}

