/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.Application.ActiveDialogList;
import com.eloquence.services.Application.ActiveDialogListener;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.ControlConstants;
import com.eloquence.services.jdlg.controls.PositionInterface;
import com.eloquence.services.jdlg.controls.TextPositionSetter;
import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.tools.HtmlTool;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class EWindowMenu
extends AbstractControl
implements ActiveDialogListener,
ActionListener {
    public static final String CLASS_ATTR_NAME = "WindowMenu";
    public static final String TITLE_ATTR_NAME = "title";
    protected String title = "&Window";
    protected String origTitle = "";
    protected int mnemonicKey = -1;
    public static final String ICON_ATTR_NAME = "icon";
    private String icon = "";
    private ImageIcon imageIcon = null;
    public static final String TEXTPOS_ATTR_NAME = "textpos";
    private String textpos = "";
    private static final int TITLE_ATTR_ID = 0;
    private static final int ICON_ATTR_ID = 1;
    private static final int TEXTPOS_ATTR_ID = 2;
    private static HashMap attributeList = new HashMap();

    public EWindowMenu() {
        this.setTitle(this.title);
        this.peer = new EJMenu();
        ActiveDialogList.addListener(this);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            ActiveDialogList.removeListener(this);
            ((JMenu)this.peer).removeAll();
            this.title = null;
            this.imageIcon = null;
            this.textpos = null;
            super.dispose();
        }
    }

    public Object clone() {
        EWindowMenu eWindowMenu = new EWindowMenu();
        this.cloneAttributes(eWindowMenu);
        return eWindowMenu;
    }

    public void cloneAttributes(EWindowMenu eWindowMenu) {
        super.cloneAttributes(eWindowMenu);
        eWindowMenu.setTitle(this.getTitle());
        eWindowMenu.setIcon(this.getIcon());
        eWindowMenu.setTextpos(this.getTextpos());
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        Integer n = (Integer)attributeList.get(sET.attr);
        if (n != null) {
            if (sET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    this.setTitle(sET.getValueString());
                    break;
                }
                case 1: {
                    this.setIcon(sET.getValueString());
                    break;
                }
                case 2: {
                    this.setTextpos(sET.getValueString());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.setAttributeValue(sET, sTATUS);
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        Integer n = (Integer)attributeList.get(gET.attr);
        if (n != null) {
            if (gET.index != null) {
                return 8;
            }
            switch (n) {
                case 0: {
                    gET2.setValueString(this.getTitle());
                    break;
                }
                case 1: {
                    gET2.setValueString(this.getIcon());
                    break;
                }
                case 2: {
                    gET2.setValueString(this.getTextpos());
                    break;
                }
                default: {
                    return 1;
                }
            }
            return 0;
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        if (this.isModified) {
            JMenu jMenu = (JMenu)this.peer;
            if (this.title != null && !this.title.equals(jMenu.getText())) {
                try {
                    jMenu.setText(this.title);
                }
                catch (Throwable throwable) {
                    System.err.println("'" + this.getPath() + "' " + throwable + ": WindowMenu = \"" + this.title + "\"");
                    jMenu.setText(HtmlTool.text(this.title));
                }
            }
            if (this.mnemonicKey != -1) {
                jMenu.setMnemonic(this.mnemonicKey);
            } else {
                jMenu.setMnemonic(0);
            }
            if (this.imageIcon != null && !this.imageIcon.equals(jMenu.getIcon())) {
                jMenu.setIcon(this.imageIcon);
            }
            this.eloq2swingTextpos();
        }
        super.eloq2swing(bl);
    }

    private final void eloq2swingTextpos() {
        if (this.textpos.length() > 0) {
            if (this.imageIcon != null && this.textpos.equalsIgnoreCase("center")) {
                this.textpos = "right";
            }
            TextPositionSetter textPositionSetter = new TextPositionSetter((PositionInterface)((Object)this.peer), this.textpos);
            textPositionSetter.execute();
            textPositionSetter.dispose();
        }
    }

    public void update() {
        final String[] stringArray = ActiveDialogList.getPresentationOfEntries();
        Runnable runnable = new Runnable(){

            public void run() {
                JMenu jMenu = (JMenu)EWindowMenu.this.peer;
                if (jMenu != null) {
                    jMenu.removeAll();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = stringArray[i];
                            JMenuItem jMenuItem = jMenu.add(string);
                            jMenuItem.setFont(EWindowMenu.this.fontReference.getFontObject(EWindowMenu.this));
                            jMenuItem.setBackground(jMenu.getBackground());
                            jMenuItem.setForeground(jMenu.getForeground());
                            jMenuItem.addActionListener(EWindowMenu.this);
                            jMenuItem.setActionCommand(string);
                        }
                    }
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception exception) {
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            runnable.run();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActiveDialogList.setToFront(actionEvent.getActionCommand(), true);
    }

    public void fontModified(Font font) {
        JMenu jMenu = (JMenu)this.peer;
        if (jMenu != null) {
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem == null) continue;
                jMenuItem.setFont(font);
            }
        }
        super.fontModified(font);
    }

    public boolean isFocusable(boolean bl) {
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.consumeRightMouseButtonEvent(mouseEvent);
    }

    public String getClassName() {
        return CLASS_ATTR_NAME;
    }

    public void setTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        c = this.getAcceleratorChar(string, stringBuffer);
        if (c == '\u0000') {
            this.title = string;
            this.origTitle = "";
            this.mnemonicKey = -1;
        } else {
            this.title = stringBuffer.toString();
            this.origTitle = string;
            this.mnemonicKey = c;
        }
        this.isModified = true;
    }

    public String getTitle() {
        if (this.origTitle.length() > 0) {
            return this.origTitle;
        }
        return this.title;
    }

    private void setIcon(String string) {
        URL uRL;
        if (string != null && string.length() > 0 && (uRL = this.createExpandedURL(string)) != null) {
            this.imageIcon = new ImageIcon(uRL);
            if (this.imageIcon != null) {
                this.icon = string;
                this.isModified = true;
                return;
            }
        }
        this.icon = "";
        this.imageIcon = null;
        this.isModified = true;
    }

    private String getIcon() {
        return this.icon;
    }

    private void setTextpos(String string) {
        if (ControlConstants.isPosition(string)) {
            this.textpos = string;
            this.isModified = true;
        }
    }

    private String getTextpos() {
        return this.textpos;
    }

    static {
        attributeList.put(TITLE_ATTR_NAME, new Integer(0));
        attributeList.put(ICON_ATTR_NAME, new Integer(1));
        attributeList.put(TEXTPOS_ATTR_NAME, new Integer(2));
    }

    class EJMenu
    extends JMenu
    implements PositionInterface {
        EJMenu() {
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (!EWindowMenu.this.ignoreEvent(aWTEvent)) {
                super.processEvent(aWTEvent);
            }
        }
    }
}

