/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.api.DummyPlugin;
import com.eloquence.api.Jdlg;
import com.eloquence.api.Plugin;
import com.eloquence.api.UnifiedData;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.protocols.dlg.Dlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.util.LinkedList;

public class PluginControl
extends AbstractControl
implements Jdlg {
    private Plugin plugin = null;
    private String pluginName = null;
    private String pluginClassName = null;
    private boolean isDummyPlugin = false;
    private boolean defaultKeyboard = true;
    public static final String RULEOVERRIDE_ATTR_NAME = "ruleoverride";
    protected boolean ruleOverride = false;
    private static final int API_MAJOR_VERSION = 1;
    private static final int API_MINOR_VERSION = 3;
    private int plugin_major_version = 0;
    private int plugin_minor_version = 0;

    public boolean loadPlugin(String string) {
        String string2 = this.pluginClassName = string;
        this.pluginName = string;
        try {
            int n = string.lastIndexOf(46) + 1;
            string2 = this.pluginClassName = string.substring(0, n).toLowerCase() + string.substring(n, n + 1).toUpperCase() + string.substring(n + 1);
            this.plugin = (Plugin)Thread.currentThread().getContextClassLoader().loadClass("com.eloquence." + string2).newInstance();
            if (this.plugin instanceof KeyListener) {
                this.defaultKeyboard = false;
            }
            this.peer = this.plugin.onCreate(this);
            if (this.peer == null) {
                return false;
            }
            if (this.defaultKeyboard) {
                this.peer.addKeyListener(this);
                this.peer.setFocusTraversalKeysEnabled(false);
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Plugin '" + string2 + "' not found");
            this.plugin = new DummyPlugin(this.pluginClassName);
            this.peer = this.plugin.onCreate(this);
            this.isDummyPlugin = true;
            return this.peer != null;
        }
        catch (ClassCastException classCastException) {
            System.err.println("'" + string2 + "' does not implement the com.eloquence.api.Plugin interface");
        }
        catch (Throwable throwable) {
            System.err.println("Failed to load plugin '" + string2 + "'");
            throwable.printStackTrace(System.err);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void dispose() {
        if (!this.isDisposed) {
            if (this.plugin != null) {
                this.plugin.onDispose();
            }
            super.dispose();
        }
    }

    public Object clone() {
        if (this.plugin != null && this.pluginName != null) {
            try {
                PluginControl pluginControl = new PluginControl();
                if (!pluginControl.loadPlugin(this.pluginName)) {
                    return null;
                }
                this.cloneAttributes(pluginControl);
                this.plugin.onClone(pluginControl.plugin);
                return pluginControl;
            }
            catch (Throwable throwable) {
                System.err.println("Failed to clone plugin '" + this.pluginName + "'");
                throwable.printStackTrace(System.err);
            }
        }
        return null;
    }

    public void cloneAttributes(PluginControl pluginControl) {
        pluginControl.ruleOverride = this.ruleOverride;
        super.cloneAttributes(pluginControl);
    }

    private final int makeIndex(LinkedList linkedList, String string) {
        int n = 0;
        while (true) {
            int n2 = string.indexOf(93, n);
            int n3 = string.indexOf(91, n);
            if (n3 == -1 ? n2 != -1 : n2 == -1 || n3 != n2 + 1) {
                return 8;
            }
            String string2 = n2 == -1 ? (n != 0 ? string.substring(n) : string) : string.substring(n, n2);
            try {
                linkedList.add(new UnifiedData(Integer.parseInt(string2)));
            }
            catch (NumberFormatException numberFormatException) {
                linkedList.add(new UnifiedData(string2));
            }
            if (n3 == -1) break;
            n = n3 + 1;
        }
        return 0;
    }

    public int setAttributeValue(Dlg.Rq.SET sET, Dlg.Rs.STATUS sTATUS) throws Dlg.Status {
        if (sET.attr.equals(RULEOVERRIDE_ATTR_NAME)) {
            this.setRuleOverride(sET.getValueInt());
            return 0;
        }
        if (this.plugin != null) {
            int n;
            LinkedList linkedList = null;
            if (sET.index != null && (n = this.makeIndex(linkedList = new LinkedList(), sET.index)) != 0) {
                return n;
            }
            UnifiedData unifiedData = sET.v_type == 1 ? new UnifiedData(sET.getValueInt()) : new UnifiedData(sET.getValueString());
            if (this.plugin.onSet(sET.attr, linkedList, unifiedData)) {
                return 0;
            }
        }
        int n = super.setAttributeValue(sET, sTATUS);
        if (this.isDummyPlugin) {
            n = 0;
        }
        return n;
    }

    public int getAttributeValue(Dlg.Rq.GET gET, Dlg.Rs.GET gET2) {
        if (gET.attr.equals(RULEOVERRIDE_ATTR_NAME)) {
            gET2.setValueInt(this.getRuleOverride());
            return 0;
        }
        if (this.plugin != null) {
            int n;
            LinkedList linkedList = null;
            if (gET.index != null && (n = this.makeIndex(linkedList = new LinkedList(), gET.index)) != 0) {
                return n;
            }
            UnifiedData unifiedData = this.plugin.onGet(gET.attr, linkedList);
            if (unifiedData != null) {
                if (unifiedData.isStringData()) {
                    gET2.setValueString(unifiedData.getStringData());
                } else {
                    gET2.setValueInt(unifiedData.getIntData());
                }
                return 0;
            }
        }
        return super.getAttributeValue(gET, gET2);
    }

    public void eloq2swing(boolean bl) {
        if (this.plugin != null) {
            this.plugin.onEloq2Swing();
        }
        super.eloq2swing(bl);
    }

    public void swing2eloq(Dlg.Rs.DO dO) {
        super.swing2eloq(dO);
        if (this.plugin != null) {
            this.plugin.onSwing2Eloq();
        }
    }

    public void focusReceived(AbstractControl abstractControl) {
        super.focusReceived(abstractControl);
        if (this.plugin != null) {
            this.plugin.onFocusReceived();
        }
    }

    public void focusLost(AbstractControl abstractControl) {
        if (this.plugin != null) {
            this.plugin.onFocusLost();
        }
        super.focusLost(abstractControl);
    }

    public boolean fireRuleOnLosingFocus() {
        if (this.plugin != null && this.pluginHasApiVersion(1, 1)) {
            return this.plugin.fireRuleOnLosingFocus();
        }
        return false;
    }

    public boolean isFocusable(boolean bl) {
        if (this.plugin != null) {
            return this.plugin.isFocusable();
        }
        return false;
    }

    public void onTabFocus(boolean bl) {
        if (this.plugin != null) {
            this.plugin.onTabFocus(bl);
        }
    }

    public Component getFocusPeer() {
        Component component;
        if (this.plugin != null && (component = this.plugin.onGetFocusPeer()) != null) {
            return component;
        }
        return this.peer;
    }

    public void fontModified(Font font) {
        super.fontModified(font);
        if (this.plugin != null) {
            this.plugin.onFontModified(font);
        }
    }

    public String getClassName() {
        return this.plugin != null ? this.plugin.getClass().getName() : "";
    }

    public void triggerRule() {
        if (this.rule != 0) {
            this.getRuleManager().fireRule(this);
        }
    }

    public void triggerRule(int n) {
    }

    public void obtainFocus() {
        this.getRuleManager().requestFocus(this);
    }

    public void defaultKeyboardHandler(boolean bl) {
        if (bl != this.defaultKeyboard) {
            this.defaultKeyboard = bl;
            if (this.peer != null) {
                if (bl) {
                    this.peer.addKeyListener(this);
                } else {
                    this.peer.removeKeyListener(this);
                }
            }
        }
    }

    public KeyListener getKeyboardListener() {
        return this;
    }

    public Dimension getGridDimension() {
        return this.getLayoutGrid();
    }

    public void setRuleOverride(int n) {
        if (this.plugin == null) {
            return;
        }
        this.ruleOverride = n != 0;
    }

    public int getRuleOverride() {
        if (this.plugin == null) {
            return 0;
        }
        return this.ruleOverride ? (this.plugin.onRuleOverride() ? 1 : 0) : 0;
    }

    public int apiMajorVersion() {
        return 1;
    }

    public int apiMinorVersion() {
        return 3;
    }

    public boolean requiresApiVersion(int n, int n2) {
        if (1 < n || 1 == n && 3 < n2) {
            System.err.println("Plugin '" + this.pluginClassName + "' requires api version " + n + "." + n2 + " (available: " + 1 + "." + 3 + ")");
            return false;
        }
        this.plugin_major_version = n;
        this.plugin_minor_version = n2;
        return true;
    }

    private boolean pluginHasApiVersion(int n, int n2) {
        return this.plugin_major_version > n || this.plugin_major_version == n && this.plugin_minor_version >= n2;
    }

    public static boolean hasPlugin(String string) {
        try {
            int n = string.lastIndexOf(46);
            n = n >= 0 ? ++n : 0;
            String string2 = "com.eloquence.plugin." + string.substring(0, n).toLowerCase() + string.substring(n, n + 1).toUpperCase() + string.substring(n + 1);
            Object obj = Thread.currentThread().getContextClassLoader().loadClass(string2).newInstance();
            if (obj instanceof Plugin) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

