/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ScrollablePopupMenu
extends JPopupMenu
implements WindowListener,
ChangeListener {
    private JLabel title = null;
    private JScrollPane pane = null;
    private JComponent menu = null;
    private Window invokerWindow = null;

    public ScrollablePopupMenu() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.title = new JLabel();
        this.title.setBorder(BorderFactory.createEtchedBorder());
        this.title.setHorizontalAlignment(0);
        this.title.setVisible(false);
        this.menu = new Box(1);
        this.pane = new JScrollPane(this.menu);
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "North");
        this.add((Component)this.pane, "Center");
    }

    public void setTitle(String string) {
        if (string != null && string.length() > 0) {
            this.title.setText(string);
            this.title.setVisible(true);
        } else {
            this.title.setVisible(false);
        }
    }

    public void setTitleFont(Font font) {
        this.title.setFont(font);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        jMenuItem.addChangeListener(this);
        this.menu.add(jMenuItem);
        return jMenuItem;
    }

    public void removeAll() {
        Component[] componentArray = this.menu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem)) continue;
            ((JMenuItem)componentArray[i]).removeChangeListener(this);
        }
        this.menu.removeAll();
    }

    public void show(Component component, int n, int n2) {
        Serializable serializable;
        Point point = component.getLocationOnScreen();
        n += point.x;
        n2 += point.y;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        int n3 = rectangle.width / 8 * 7;
        int n4 = rectangle.height / 8 * 7;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Component[] componentArray = this.menu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            serializable = componentArray[i].getPreferredSize();
            if (((Dimension)serializable).width > n5 && (n5 = ((Dimension)serializable).width) > n3) {
                bl = true;
            }
            if (n6 + ((Dimension)serializable).height <= n4) {
                n6 += ((Dimension)serializable).height;
            } else {
                bl2 = true;
            }
            if (n7 != 0 && n7 <= ((Dimension)serializable).height) continue;
            n7 = ((Dimension)serializable).height;
        }
        Insets insets = this.pane.getInsets();
        if (insets != null) {
            n5 += insets.left + insets.right;
            n6 += insets.top + insets.bottom;
        }
        if (bl) {
            this.pane.setHorizontalScrollBarPolicy(32);
            serializable = this.pane.getHorizontalScrollBar();
            if (serializable != null) {
                n6 += ((JComponent)serializable).getPreferredSize().height;
            }
        } else {
            this.pane.setHorizontalScrollBarPolicy(31);
        }
        if (bl2) {
            this.pane.setVerticalScrollBarPolicy(22);
            serializable = this.pane.getVerticalScrollBar();
            if (serializable != null) {
                n5 += ((JComponent)serializable).getPreferredSize().width;
                if (n7 != 0) {
                    ((JScrollBar)serializable).setUnitIncrement(n7);
                }
            }
        } else {
            this.pane.setVerticalScrollBarPolicy(21);
        }
        this.pane.setPreferredSize(new Dimension(n5, n6));
        serializable = this.pane.getPreferredSize();
        int n8 = n + ((Dimension)serializable).width;
        int n9 = n2 + ((Dimension)serializable).height;
        if (n8 > rectangle.x + n3) {
            n = rectangle.x + (rectangle.width - ((Dimension)serializable).width) / 2;
        }
        if (n < rectangle.x) {
            n = rectangle.x;
        }
        if (n9 > rectangle.y + n4) {
            n2 = rectangle.y + (rectangle.height - ((Dimension)serializable).height) / 2;
        }
        if (n2 < rectangle.y) {
            n2 = rectangle.y;
        }
        this.invokerWindow = ScrollablePopupMenu.getWindow(component);
        if (this.invokerWindow != null) {
            this.invokerWindow.addWindowListener(this);
        }
        super.show(component, n - point.x, n2 - point.y);
    }

    protected void firePopupMenuWillBecomeInvisible() {
        if (this.invokerWindow != null) {
            this.invokerWindow.removeWindowListener(this);
            this.invokerWindow = null;
        }
        super.firePopupMenuWillBecomeInvisible();
    }

    public MenuElement[] getSubElements() {
        Component[] componentArray = this.menu.getComponents();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof MenuElement)) continue;
            ++n;
        }
        MenuElement[] menuElementArray = new MenuElement[n];
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof MenuElement)) continue;
            menuElementArray[i] = (MenuElement)((Object)componentArray[i]);
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this.menu;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JMenuItem jMenuItem;
        Object object = changeEvent.getSource();
        if (object instanceof JMenuItem && (jMenuItem = (JMenuItem)object).isArmed()) {
            JViewport jViewport = this.pane.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            int n = jMenuItem.getY();
            if (jMenuItem.getY() < rectangle.y) {
                jViewport.setViewPosition(new Point(rectangle.x, n));
            } else {
                int n2 = jMenuItem.getHeight();
                if (n + n2 > rectangle.y + rectangle.height) {
                    jViewport.setViewPosition(new Point(rectangle.x, n + n2 - rectangle.height));
                }
            }
        }
    }

    private static Window getWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }
}

