/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.jdlg.controls;

import com.eloquence.services.jdlg.controls.EListBox;
import com.eloquence.services.jdlg.controls.ETableHeader;
import com.eloquence.services.tools.HtmlTool;
import com.eloquence.services.tools.UiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends AbstractTableModel {
    protected EListBox.EJTableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    private static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return HtmlTool.text(object.toString()).compareTo(HtmlTool.text(object2.toString()));
        }
    };
    private static final Comparator NUMERICAL_COMPARATOR = new Comparator(){

        /*
         * Enabled aggressive block sorting
         */
        public int compare(Object object, Object object2) {
            char c;
            String string = HtmlTool.text(object.toString()).trim();
            String string2 = HtmlTool.text(object2.toString()).trim();
            boolean bl = false;
            int n = 0;
            int n2 = string.length();
            int n3 = string2.length();
            if (n2 > 0 && string.charAt(0) == '-') {
                if (n3 <= 0) return -1;
                if (string2.charAt(0) != '-') return -1;
                bl = true;
                n = 1;
            } else if (n3 > 0 && string2.charAt(0) == '-') {
                return 1;
            }
            int n4 = n2 < n3 ? n2 : n3;
            int n5 = 0;
            while (n < n4) {
                block14: {
                    int n6;
                    char c2;
                    block13: {
                        c = string.charAt(n);
                        c2 = string2.charAt(n);
                        if (c < '0' || c > '9') break block13;
                        if (c2 >= '0' && c2 <= '9') {
                            if (n5 == 0) {
                                n5 = bl ? c2 - c : c - c2;
                            }
                            break block14;
                        } else {
                            if (!bl) return 1;
                            return -1;
                        }
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        if (!bl) return -1;
                        return 1;
                    }
                    if (n5 != 0) {
                        return n5;
                    }
                    if (bl) {
                        n6 = string2.substring(n).compareTo(string.substring(n));
                        return n6;
                    }
                    n6 = string.substring(n).compareTo(string2.substring(n));
                    return n6;
                }
                ++n;
            }
            if (n2 == n3) return n5;
            if (n2 > n3) {
                c = string.charAt(n);
                if (c < '0' || c > '9') {
                    if (n5 != 0) return n5;
                }
                if (!bl) return 1;
                return -1;
            }
            c = string2.charAt(n);
            if (c < '0' || c > '9') {
                if (n5 != 0) return n5;
            }
            if (!bl) return -1;
            return 1;
        }
    };
    private static final Comparator BOOLEAN_COMPARATOR = new Comparator(){

        private boolean toBoolean(Object object) {
            String string = HtmlTool.text(object.toString());
            return string.length() != 0 && !string.equals("0") && !string.equalsIgnoreCase("false");
        }

        public int compare(Object object, Object object2) {
            boolean bl;
            boolean bl2 = this.toBoolean(object);
            if (bl2 == (bl = this.toBoolean(object2))) {
                return 0;
            }
            return bl ? 1 : -1;
        }
    };
    private static final Comparator PROGRESS_COMPARATOR = new Comparator(){

        private double toPercent(Object object) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(HtmlTool.text(object.toString()), ";");
                int n = new Integer(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    int n2 = new Integer(stringTokenizer.nextToken());
                    return (double)n / (double)n2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return 0.0;
        }

        public int compare(Object object, Object object2) {
            double d;
            double d2 = this.toPercent(object);
            if (d2 == (d = this.toPercent(object2))) {
                return 0;
            }
            return d2 > d ? 1 : -1;
        }
    };
    private static final Comparator FOLDED_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            String string;
            String string2 = HtmlTool.text(object.toString());
            int n = string2.compareToIgnoreCase(string = HtmlTool.text(object2.toString()));
            if (n == 0) {
                return string2.compareTo(string);
            }
            return n;
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private List sortingColumns = new ArrayList();
    private SelectedRow selectedRow = new SelectedRow();

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public TableSorter(EListBox.EJTableModel eJTableModel) {
        this();
        this.setTableModel(eJTableModel);
    }

    public TableSorter(EListBox.EJTableModel eJTableModel, JTableHeader jTableHeader) {
        this();
        this.setTableHeader(jTableHeader, eJTableModel);
        this.setTableModel(eJTableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(EListBox.EJTableModel eJTableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = eJTableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader, EListBox.EJTableModel eJTableModel) {
        if (this.tableHeader != null) {
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            this.tableHeader.removeMouseListener(this.mouseListener);
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).getDefaultRenderer());
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer(), eJTableModel));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int n) {
        int n2 = this.sortingColumns.size();
        for (int i = 0; i < n2; ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != n) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getPriority(int n) {
        int n2 = this.sortingColumns.size();
        for (int i = 0; i < n2; ++i) {
            if (((Directive)this.sortingColumns.get(i)).column != n) continue;
            return i;
        }
        return 0;
    }

    public int getSortingStatus(int n) {
        return this.getDirective(n).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        this.tableHeader.repaint();
    }

    public void setSortingEnabled(int n, boolean bl) {
        this.setSortingStatus(n, 0);
        this.tableModel.setColumnSorting(n, bl);
    }

    public boolean getSortingEnabled(int n) {
        return this.tableModel.getColumnSorting(n);
    }

    public void setSortingStatus(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (n2 != 0) {
            this.sortingColumns.add(new Directive(n, n2));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int n, int n2) {
        Directive directive = this.getDirective(n);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, n2, this.sortingColumns.indexOf(directive));
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    protected Comparator getComparator(int n) {
        switch (this.tableModel.getColumnType(n)) {
            case 0: {
                return LEXICAL_COMPARATOR;
            }
            case 1: 
            case 6: {
                return NUMERICAL_COMPARATOR;
            }
            case 2: {
                return BOOLEAN_COMPARATOR;
            }
            case 3: {
                return PROGRESS_COMPARATOR;
            }
            case 5: {
                return FOLDED_COMPARATOR;
            }
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int n = this.tableModel.getRowCount();
            this.viewToModel = new Row[n];
            for (int i = 0; i < n; ++i) {
                this.viewToModel[i] = new Row(i);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int n) {
        try {
            if (this.getViewToModel()[n] != null) {
                return this.getViewToModel()[n].modelIndex;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getRowCount();
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public int viewIndex(int n) {
        try {
            return this.getModelToView()[n];
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public int getRowCount() {
        if (this.tableModel != null) {
            return this.tableModel.getRowCount();
        }
        return 0;
    }

    public int getColumnCount() {
        if (this.tableModel != null) {
            return this.tableModel.getColumnCount();
        }
        return 0;
    }

    public String getColumnName(int n) {
        if (this.tableModel != null) {
            return this.tableModel.getColumnName(n);
        }
        return "";
    }

    public Class getColumnClass(int n) {
        if (this.tableModel != null) {
            return this.tableModel.getColumnClass(n);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.tableModel != null) {
            return this.tableModel.isCellEditable(this.modelIndex(n), n2);
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        if (this.tableModel != null) {
            return this.tableModel.getValueAt(this.modelIndex(n), n2);
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.tableModel != null) {
            this.tableModel.setValueAt(object, this.modelIndex(n), n2);
        }
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int n, int n2) {
            this.column = n;
            this.direction = n2;
        }
    }

    private class SortableHeaderRenderer
    extends EListBox.ETableCellRenderer {
        private EListBox.EJTableModel model;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer, EListBox.EJTableModel eJTableModel) {
            super(tableCellRenderer);
            this.model = eJTableModel;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable != null) {
                Serializable serializable;
                int n3 = jTable.convertColumnIndexToModel(n2);
                ETableHeader eTableHeader = this.model.getColumnHeader(n3);
                if (eTableHeader == null || object.toString().length() == 0) {
                    if (component instanceof JLabel) {
                        ((JLabel)component).setText("");
                    }
                    return component;
                }
                if (component instanceof JLabel) {
                    serializable = (JLabel)component;
                    ((JLabel)serializable).setHorizontalTextPosition(4);
                    ((JComponent)serializable).setFont(eTableHeader.fontReference.getFontObject(eTableHeader));
                    ((JLabel)serializable).setIcon(TableSorter.this.getHeaderRendererIcon(n3, ((Component)serializable).getFont().getSize()));
                }
                component.setBackground(new Color(eTableHeader.getBgc()));
                serializable = new Color(eTableHeader.getFgc());
                if (this.model.listBox().getSensitive() == 0) {
                    serializable = UiUtil.getFgcDisabled((Color)serializable);
                }
                component.setForeground((Color)serializable);
            }
            return component;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean bl, int n, int n2) {
            this.descending = bl;
            this.size = n;
            this.priority = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component != null ? component.getForeground().brighter() : Color.GRAY;
            int n3 = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int n4 = this.descending ? n3 : -n3;
            n2 = n2 + 5 * this.size / 6 + (this.descending ? -n4 : 0);
            int n5 = this.descending ? 1 : -1;
            graphics.translate(n, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n3 / 2, n4, 0, 0);
            graphics.drawLine(n3 / 2, n4 + n5, 0, n5);
            graphics.setColor(color.brighter());
            graphics.drawLine(n3 / 2, n4, n3, 0);
            graphics.drawLine(n3 / 2, n4 + n5, n3, n5);
            if (this.descending) {
                graphics.setColor(color.darker().darker());
            } else {
                graphics.setColor(color.brighter().brighter());
            }
            graphics.drawLine(n3, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            EListBox eListBox = ((EListBox.TooltipHeader)jTableHeader).getListbox();
            if (eListBox.getSensitive() == 0) {
                return;
            }
            int n = -1;
            EListBox eListBox2 = eListBox;
            synchronized (eListBox2) {
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n2 != -1) {
                    TableSorter.this.selectedRow.save();
                    int n3 = tableColumnModel.getColumn(n2).getModelIndex();
                    if (n3 != -1 && (mouseEvent.getModifiers() & 0x10) == 16 && TableSorter.this.getSortingEnabled(n3)) {
                        int n4 = TableSorter.this.getSortingStatus(n3);
                        if (!mouseEvent.isControlDown()) {
                            TableSorter.this.cancelSorting();
                        }
                        n4 += mouseEvent.isShiftDown() ? -1 : 1;
                        n4 = (n4 + 1) % 3 - 1;
                        TableSorter.this.setSortingStatus(n3, n4);
                        n = n3;
                    }
                    TableSorter.this.selectedRow.restore();
                }
            }
            if (n >= 0) {
                eListBox.fireVcRule(n);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n;
            if (!TableSorter.this.isSorting()) {
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            int n2 = tableModelEvent.getFirstRow();
            if (n2 == -1) {
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            if (TableSorter.this.modelToView != null && n2 == tableModelEvent.getLastRow() && (n = tableModelEvent.getColumn()) != -1 && TableSorter.this.getSortingStatus(n) == 0) {
                int n3;
                EListBox eListBox = TableSorter.this.tableModel.listBox();
                synchronized (eListBox) {
                    n3 = TableSorter.this.getModelToView()[n2];
                }
                TableSorter.this.fireTableChanged(new TableModelEvent(TableSorter.this, n3, n3, n, tableModelEvent.getType()));
                return;
            }
            EListBox eListBox = TableSorter.this.tableModel.listBox();
            synchronized (eListBox) {
                TableSorter.this.clearSortingState();
            }
            TableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int n) {
            this.modelIndex = n;
        }

        public int compareTo(Object object) {
            int n = this.modelIndex;
            int n2 = ((Row)object).modelIndex;
            for (Directive directive : TableSorter.this.sortingColumns) {
                int n3 = directive.column;
                Object object2 = TableSorter.this.tableModel.getValueAt(n, n3);
                Object object3 = TableSorter.this.tableModel.getValueAt(n2, n3);
                int n4 = 0;
                n4 = object2 == null && object3 == null ? 0 : (object2 == null ? -1 : (object3 == null ? 1 : TableSorter.this.getComparator(n3).compare(object2, object3)));
                if (n4 == 0) continue;
                return directive.direction == -1 ? -n4 : n4;
            }
            return 0;
        }
    }

    private class SelectedRow {
        private int selectedRow = -1;

        private SelectedRow() {
        }

        private void save() {
            this.selectedRow = TableSorter.this.tableModel.getSelectedRow();
        }

        private void restore() {
            int n = TableSorter.this.viewIndex(this.selectedRow);
            if (n >= 0) {
                TableSorter.this.tableModel.setSelectedRow(n);
            } else {
                TableSorter.this.tableModel.setSelectedRow(this.selectedRow);
            }
        }
    }
}

