/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.protocols.dlg;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.jdlg.ControlsManager;
import com.eloquence.services.jdlg.controls.AbstractControl;
import com.eloquence.services.jdlg.controls.AbstractControlContainer;
import com.eloquence.services.jdlg.controls.EDialog;
import com.eloquence.services.protocols.dlg.Dmdrv;
import com.eloquence.services.protocols.dlg.Dmdrv_V1;
import com.eloquence.services.protocols.dlg.Dmdrv_V2;
import com.eloquence.services.sessions.SessionView;
import com.eloquence.services.tools.Debug;
import com.eloquence.services.tools.InetTool;
import com.eloquence.services.tools.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Dlg
extends Thread {
    public static final int OK = 0;
    public static final int FAILED = 1;
    public static final int NOFILE = 2;
    public static final int NOMEM = 5;
    public static final int DUPL = 6;
    public static final int BADPATH = 7;
    public static final int BADATTR = 8;
    public static final int BADCHILD = 9;
    public static final int INVAL = 11;
    public static final int FOCUS = 12;
    public static final int MEMOFL = 34;
    public static final int V_VOID = 0;
    public static final int V_INT = 1;
    public static final int V_STRING = 2;
    public static final int V_BINARY = 3;
    public static final int NOCACHE = 0;
    public static final int CACHE = 1;
    public static final int UNCACHE = 2;
    public static final int ATTR_ROOT = 1;
    public static final int ATTR_PARENT = 2;
    public static final int ATTR_SIBLING = 3;
    public static final int ATTR_STATE = 4;
    public static final int ATTR_OTHER = 5;
    public static final int ATTR_MAXMODE = 5;
    final boolean isRdlg;
    Socket sck;
    Dmdrv drv;
    ControlsManager cmgr;
    private int asyncMode;
    private static final int ASYNC_OFF = 0;
    private static final int ASYNC_ON = 1;
    private static final int ASYNC_BULK = 2;
    private String localHostAddress = null;
    private String localHostName = null;
    private boolean connectionReset = false;
    private boolean sessionVisible = false;
    private boolean stopReceived = false;

    public Dlg(Socket socket, boolean bl, String string, HashMap hashMap) {
        super(StartUp.dlgThreadGroup, "DLG Session " + Dlg.getSessionName(socket, bl));
        this.sck = socket;
        this.isRdlg = bl;
        this.drv = new Dmdrv_V1();
        this.cmgr = new ControlsManager(this, string, hashMap);
    }

    private void dispose() {
        this.setName("Disconnected");
        if (this.cmgr != null) {
            this.stopSession();
            this.cmgr.dispose();
            this.cmgr = null;
        }
        if (this.drv != null) {
            this.drv.dispose();
            this.drv = null;
        }
        if (this.sck != null) {
            try {
                OutputStream outputStream = this.sck.getOutputStream();
                if (outputStream != null) {
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.sck.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sck = null;
        }
        this.localHostAddress = null;
        this.localHostName = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void start() {
        try {
            super.start();
        }
        catch (Throwable throwable) {
            System.err.println(this.getSessionName() + " Failed to start DLG protocol thread: " + throwable.toString());
            this.dispose();
        }
    }

    void stopSession() {
        Rs.STATUS sTATUS = this.drv.rs_STATUS;
        sTATUS.isAsync = true;
        this.cmgr.handleStop((Rq.STOP)this.drv.rq(2), sTATUS);
        this.stopReceived();
    }

    public void run() {
        try {
            this.sck.setTcpNoDelay(true);
            StartUp.incSessionCount();
            boolean bl = true;
            while (bl) {
                bl = this.drv.exec(this);
            }
            if (!this.connectionReset && Debug.isLog(1, 1)) {
                Debug.log(1, 1, (this.isRdlg ? "RDLG" : "DLG") + " connection " + this.getSessionName() + " closed");
            }
        }
        catch (IOException iOException) {
            this.stopSession();
            System.err.println(this.getSessionName() + " Network i/o failure: " + iOException.getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {
            this.stopSession();
        }
        catch (Throwable throwable) {
            this.stopSession();
            System.err.println(this.getSessionName() + " Internal failure: " + throwable.toString());
            throwable.printStackTrace(System.err);
        }
        SessionView.cancelSessionTimer = true;
        StartUp.decSessionCount();
        this.dispose();
        System.runFinalization();
        System.gc();
        StartUp.sessionFinished();
    }

    public String getSessionName() {
        return Dlg.getSessionName(this.sck, this.isRdlg);
    }

    public static String getSessionName(Socket socket, boolean bl) {
        return InetTool.getHostAddress(socket.getInetAddress()) + ":" + (bl ? socket.getLocalPort() : socket.getPort());
    }

    public String getLocalHostAddress() {
        if (this.localHostAddress == null) {
            this.localHostAddress = InetTool.getHostAddress(this.sck.getLocalAddress());
        }
        return this.localHostAddress;
    }

    public String getLocalHostName() {
        if (this.localHostName == null) {
            this.localHostName = this.sck.getLocalAddress().getHostName();
        }
        return this.localHostName;
    }

    static String getDriverProperties(String string, boolean bl) {
        return "driver=JDLG;printer=1;charset=" + string + ";bulk=" + (bl ? "1" : "0") + ";zip=" + StartUp.dlg_compression_threshold + ";";
    }

    public void sendNopResponse() {
        this.drv.sendNopResponse(this);
    }

    void connectionReset(String string) {
        try {
            boolean bl;
            SessionView.cancelSessionTimer = true;
            boolean bl2 = this.stopReceived ? false : (bl = !this.sessionVisible);
            if (!bl && !this.cmgr.hasDialogs()) {
                return;
            }
            JFrame jFrame = null;
            EDialog eDialog = this.cmgr.getLastUsedDialog();
            if (eDialog != null && eDialog.getVisible() != 0) {
                jFrame = eDialog.getFrame();
                if (jFrame != null && jFrame.isVisible()) {
                    eDialog.allowEvents(true);
                } else {
                    jFrame = null;
                }
            }
            if (jFrame == null && !bl) {
                return;
            }
            System.err.println(this.getSessionName() + " " + (string != null ? string.replace('\n', ' ') : "Client has closed DLG connection"));
            this.connectionReset = true;
            ConnectionReset_Message connectionReset_Message = new ConnectionReset_Message(string, jFrame);
            ConnectionReset_Timer connectionReset_Timer = new ConnectionReset_Timer(connectionReset_Message, 10);
            connectionReset_Message.setTimer(connectionReset_Timer);
            connectionReset_Message.start();
            connectionReset_Timer.start();
            connectionReset_Message.join();
            connectionReset_Timer.join();
            if (jFrame != null) {
                eDialog.allowEvents(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sessionVisible() {
        if (!this.sessionVisible) {
            this.sessionVisible = true;
            SessionView.cancelSessionTimer = true;
        }
    }

    private void stopReceived() {
        this.stopReceived = true;
        this.drv.stopReceived();
        StopReceived_Timer stopReceived_Timer = new StopReceived_Timer(2500);
        stopReceived_Timer.start();
    }

    public static final class Listener
    implements Runnable {
        private static Listener self;
        private volatile ServerSocket lsck;

        public Listener(int n) {
            if (self != null) {
                throw new RuntimeException("BUG: duplicate DLG listener creation");
            }
            self = this;
            try {
                this.lsck = new ServerSocket(n);
                this.lsck.setReuseAddress(true);
            }
            catch (Throwable throwable) {
                System.err.println("Failed to create DLG listener, port " + n + ": " + throwable.getLocalizedMessage());
                StartUp.exit();
            }
        }

        public void start() {
            try {
                Thread thread = new Thread(StartUp.systemThreadGroup, this, "DLG Listener, Port " + this.lsck.getLocalPort());
                thread.start();
            }
            catch (Throwable throwable) {
                System.err.println("Failed to start DLG listener: " + throwable.toString());
                StartUp.exit();
            }
        }

        public void stop() {
            self = null;
            if (this.lsck != null) {
                try {
                    ServerSocket serverSocket = this.lsck;
                    this.lsck = null;
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void run() {
            while (this.lsck != null) {
                Socket socket;
                block3: {
                    try {
                        socket = this.lsck.accept();
                        if (!Debug.isLog(1, 1)) break block3;
                        Debug.log(1, 1, "DLG connection from " + InetTool.getHostAddress(socket.getInetAddress()) + ":" + socket.getPort());
                    }
                    catch (Throwable throwable) {
                        if (this.lsck == null) continue;
                        System.err.println("Failed to accept DLG connection: " + throwable.getLocalizedMessage());
                        continue;
                    }
                }
                Dlg dlg = new Dlg(socket, false, null, null);
                dlg.start();
            }
        }

        public static int getLocalPort() {
            if (self != null && Listener.self.lsck != null) {
                return Listener.self.lsck.getLocalPort();
            }
            return -1;
        }
    }

    public static final class Status
    extends Exception {
        private int status;

        public Status(int n) {
            this.status = n;
        }

        public int getStatus() {
            return this.status;
        }
    }

    private final class StopReceived_Timer
    extends Thread {
        private int milliseconds = 0;

        public StopReceived_Timer(int n) {
            this.milliseconds = n;
        }

        public void run() {
            try {
                Thread.sleep(this.milliseconds);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Dlg.this.stopReceived = false;
        }
    }

    private static final class ConnectionReset_Timer
    extends Thread {
        private Thread message = null;
        private int seconds = 0;

        public ConnectionReset_Timer(Thread thread, int n) {
            this.message = thread;
            this.seconds = n;
        }

        public void run() {
            try {
                Thread.sleep(this.seconds * 1000);
                this.message.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.message = null;
        }
    }

    private static final class ConnectionReset_Message
    extends Thread {
        private String message = null;
        private JFrame parent = null;
        private Thread timer = null;

        public ConnectionReset_Message(String string, JFrame jFrame) {
            this.message = string != null ? string : Strings.get("message.text.connectionclosed");
            this.parent = jFrame;
        }

        public void setTimer(Thread thread) {
            this.timer = thread;
        }

        public void run() {
            try {
                JOptionPane.showMessageDialog(this.parent, this.message, Strings.get("message.error.title"), 0);
                this.timer.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.message = null;
            this.parent = null;
            this.timer = null;
        }
    }

    public static abstract class Rs {
        void dispose() {
        }

        public static final class ASYNC
        extends Rs {
            int mode;
        }

        public static final class POPUP
        extends Rs {
            public int status;
            public int btn;
        }

        public static final class DO
        extends Rs {
            Cache cache;
            public long cacheGeneration;
            public int status;
            public int rule;
            public String path;

            void dispose() {
                if (this.cache != null) {
                    this.cache.cleanup();
                }
                this.path = null;
            }

            void disposeCache() {
                if (this.cache != null) {
                    this.cache.cleanup();
                    this.cache.obj = null;
                    this.cache.attrHash = null;
                    this.cache = null;
                }
            }

            public boolean canCache() {
                return this.cache != null;
            }

            private void cache(AbstractControl abstractControl) {
                if (abstractControl.cacheId == 0) {
                    AbstractControlContainer abstractControlContainer = abstractControl.getParent();
                    if (abstractControlContainer != null) {
                        this.cache(abstractControlContainer);
                    }
                    if (((Cache)this.cache).lastObj.used == ((Cache)this.cache).lastObj.c.length) {
                        ((Cache)this.cache).lastObj.next = new Cache.Obj();
                        this.cache.lastObj = ((Cache)this.cache).lastObj.next;
                    }
                    ((Cache)this.cache).lastObj.c[((Cache)this.cache).lastObj.used++] = abstractControl;
                    abstractControl.cacheId = ++this.cache.nObj;
                }
            }

            private void cache(AbstractControl abstractControl, String string, int n, Cache.Val val) {
                this.cache(abstractControl);
                Cache.Attr attr = (Cache.Attr)this.cache.attrHash.get(string);
                if (attr == null) {
                    attr = new Cache.Attr();
                    attr.name = string;
                    attr.cacheId = ++this.cache.nAttr;
                    this.cache.attrHash.put(string, attr);
                    if (this.cache.lastAttr != null) {
                        ((Cache)this.cache).lastAttr.next = attr;
                        this.cache.lastAttr = ((Cache)this.cache).lastAttr.next;
                    } else {
                        this.cache.attr = attr;
                        this.cache.lastAttr = this.cache.attr;
                    }
                }
                attr.mode = n;
                val.idObj = abstractControl.cacheId;
                val.idAttr = attr.cacheId;
                ++this.cache.nVal;
                if (this.cache.lastVal != null) {
                    ((Cache)this.cache).lastVal.next = val;
                    this.cache.lastVal = ((Cache)this.cache).lastVal.next;
                } else {
                    this.cache.val = val;
                    this.cache.lastVal = this.cache.val;
                }
            }

            public void cache(AbstractControl abstractControl, String string, int n, int n2) {
                Cache.Val_INT val_INT = new Cache.Val_INT();
                val_INT.iv = n2;
                this.cache(abstractControl, string, n, val_INT);
            }

            public void cache(AbstractControl abstractControl, String string, int n, String string2) {
                Cache.Val_STRING val_STRING = new Cache.Val_STRING();
                val_STRING.sv = string2;
                this.cache(abstractControl, string, n, val_STRING);
            }

            public void cache(AbstractControl abstractControl, String string, int n, byte[] byArray, int n2) {
                Cache.Val_BINARY val_BINARY = new Cache.Val_BINARY();
                val_BINARY.bv = byArray;
                val_BINARY.bv_len = n2;
                this.cache(abstractControl, string, n, val_BINARY);
            }

            public void uncache(AbstractControl abstractControl, String string) {
                this.cache(abstractControl, string, 0, new Cache.Val());
            }

            static final class Cache {
                Obj obj;
                private Obj lastObj;
                Attr attr;
                private Attr lastAttr;
                Val val;
                private Val lastVal;
                private HashMap attrHash;
                int nObj;
                int nAttr;
                int nVal;

                Cache() {
                    this.lastObj = this.obj = new Obj();
                    this.attrHash = new HashMap();
                }

                private void cleanup() {
                    Object object;
                    this.lastObj = this.obj;
                    while (this.lastObj != null) {
                        object = this.lastObj.next;
                        this.lastObj.cleanup();
                        this.lastObj = object;
                    }
                    this.lastObj = this.obj;
                    this.attrHash.clear();
                    this.lastAttr = null;
                    while (this.attr != null) {
                        object = this.attr.next;
                        this.attr.cleanup();
                        this.attr = object;
                    }
                    this.lastVal = null;
                    while (this.val != null) {
                        object = this.val.next;
                        this.val.cleanup();
                        this.val = object;
                    }
                    this.nVal = 0;
                    this.nAttr = 0;
                    this.nObj = 0;
                }

                static final class Val_BINARY
                extends Val {
                    byte[] bv;
                    int bv_len;

                    Val_BINARY() {
                    }

                    protected void cleanup() {
                        this.bv = null;
                        super.cleanup();
                    }
                }

                static final class Val_STRING
                extends Val {
                    String sv;

                    Val_STRING() {
                    }

                    protected void cleanup() {
                        this.sv = null;
                        super.cleanup();
                    }
                }

                static final class Val_INT
                extends Val {
                    int iv;

                    Val_INT() {
                    }
                }

                static class Val {
                    Val next;
                    int idObj;
                    int idAttr;

                    Val() {
                    }

                    protected void cleanup() {
                        this.next = null;
                    }
                }

                static final class Attr {
                    Attr next;
                    String name;
                    int mode;
                    private int cacheId;

                    Attr() {
                    }

                    private void cleanup() {
                        this.next = null;
                        this.name = null;
                    }
                }

                static final class Obj {
                    Obj next;
                    AbstractControl[] c = new AbstractControl[208];
                    int used;

                    Obj() {
                    }

                    private void cleanup() {
                        this.next = null;
                        for (int i = 0; i < this.used; ++i) {
                            this.c[i] = null;
                        }
                        this.used = 0;
                    }
                }
            }
        }

        public static final class GET
        extends Rs {
            public int cacheMode;
            public int status;
            public int v_type;
            public int v_iv;
            public String v_sv;
            public byte[] v_bv;
            public int v_bv_len;
            public int attrMode;

            public void setValueInt(int n) {
                this.v_type = 1;
                this.v_iv = n;
                this.v_sv = null;
                this.v_bv = null;
                this.v_bv_len = 0;
            }

            public boolean setValueString(String string) {
                this.v_iv = 0;
                this.v_bv = null;
                this.v_bv_len = 0;
                if (string == null) {
                    this.v_type = 0;
                    this.v_sv = null;
                    return false;
                }
                this.v_type = 2;
                this.v_sv = string;
                return true;
            }

            void dispose() {
                this.v_sv = null;
                this.v_bv = null;
            }
        }

        public static final class LOAD
        extends Rs {
            public int status;
        }

        public static final class STATUS
        extends Rs {
            boolean isAsync;
            public int cacheMode;
            public int attrMode;
            public int status;
        }
    }

    public static abstract class Rq {
        abstract boolean exec(Dlg var1) throws InterruptedException;

        void dispose() {
        }

        public static final class ASYNC
        extends Rq {
            int mode;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.ASYNC aSYNC = dmdrv.rs_ASYNC;
                    aSYNC.mode = (this.mode & 0xFFFFFFFC) == 0 ? (dlg.asyncMode = this.mode) : (dlg.asyncMode = 0);
                    return dmdrv.encode(aSYNC);
                }
                return false;
            }
        }

        public static final class HELP
        extends Rq {
            public String tag;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.STATUS sTATUS = dmdrv.rs_STATUS;
                    sTATUS.isAsync = (dlg.asyncMode & 1) != 0;
                    dlg.cmgr.handleHelp(this, sTATUS);
                    sTATUS.cacheMode = 0;
                    sTATUS.attrMode = 0;
                    return dmdrv.encode(sTATUS);
                }
                return false;
            }

            void dispose() {
                this.tag = null;
            }
        }

        public static final class POPUP
        extends Rq {
            public int x;
            public int y;
            public String title;
            public String[] text;
            public String[] btn;
            public int def_btn;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.POPUP pOPUP = dmdrv.rs_POPUP;
                    dlg.sessionVisible();
                    dlg.cmgr.handlePopupBox(this, pOPUP);
                    return dmdrv.encode(pOPUP);
                }
                return false;
            }

            void dispose() {
                int n;
                this.title = null;
                if (this.text != null) {
                    for (n = 0; n < this.text.length; ++n) {
                        this.text[n] = null;
                    }
                    this.text = null;
                }
                if (this.btn != null) {
                    for (n = 0; n < this.btn.length; ++n) {
                        this.btn[n] = null;
                    }
                    this.btn = null;
                }
            }
        }

        public static final class DRAW
        extends Rq {
            public String path;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.STATUS sTATUS = dmdrv.rs_STATUS;
                    sTATUS.isAsync = (dlg.asyncMode & 1) != 0;
                    dlg.sessionVisible();
                    dlg.cmgr.handleDraw(this, sTATUS);
                    sTATUS.cacheMode = 0;
                    sTATUS.attrMode = 0;
                    return dmdrv.encode(sTATUS);
                }
                return false;
            }

            void dispose() {
                this.path = null;
            }
        }

        public static final class DO
        extends Rq {
            public String path;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.DO dO = dmdrv.rs_DO;
                    if (++dO.cacheGeneration < 1L) {
                        dO.cacheGeneration = 1L;
                    }
                    dlg.sessionVisible();
                    do {
                        dlg.cmgr.handleDo(this, dO);
                        if (dO.status == 0) continue;
                        dO.rule = 0;
                        dO.path = this.path;
                    } while (dO.path == null);
                    return dmdrv.encode(dO);
                }
                return false;
            }

            void dispose() {
                this.path = null;
            }
        }

        public static final class GET
        extends Rq {
            public String path;
            public String attr;
            public String index;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.GET gET = dmdrv.rs_GET;
                    gET.cacheMode = 0;
                    gET.attrMode = 0;
                    if (this.path == null) {
                        if (this.attr.equals("async")) {
                            gET.status = 0;
                            gET.v_type = 1;
                            if (dmdrv instanceof Dmdrv_V1) {
                                gET.v_iv = dlg.asyncMode & 1;
                            } else if (dmdrv instanceof Dmdrv_V2) {
                                gET.v_iv = dlg.asyncMode;
                            } else {
                                throw new RuntimeException("drv unknown");
                            }
                            return dmdrv.encode(gET);
                        }
                        if (this.attr.equals("driver_properties")) {
                            gET.status = 0;
                            gET.v_type = 2;
                            if (dmdrv instanceof Dmdrv_V1) {
                                gET.v_sv = Dmdrv_V1.getDriverProperties();
                            } else if (dmdrv instanceof Dmdrv_V2) {
                                gET.v_sv = Dmdrv_V2.getDriverProperties();
                            } else {
                                throw new RuntimeException("drv unknown");
                            }
                            return dmdrv.encode(gET);
                        }
                    }
                    dlg.cmgr.handleGet(this, gET);
                    return dmdrv.encode(gET);
                }
                return false;
            }

            void dispose() {
                this.path = null;
                this.attr = null;
                this.index = null;
            }
        }

        public static final class SET
        extends Rq {
            public String path;
            public String attr;
            public String index;
            public int v_type;
            public int v_iv;
            public String v_sv;
            public byte[] v_bv;
            public int v_bv_off;
            public int v_bv_len;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.STATUS sTATUS = dmdrv.rs_STATUS;
                    sTATUS.isAsync = (dlg.asyncMode & 1) != 0;
                    sTATUS.cacheMode = 0;
                    sTATUS.attrMode = 0;
                    if (this.path == null && this.attr.equals("driver_properties")) {
                        if (this.v_type == 2) {
                            String string = this.v_sv.replaceAll("\\s+", "");
                            if (dmdrv instanceof Dmdrv_V1) {
                                if (string.equalsIgnoreCase(Dmdrv_V1.getDriverProperties().replaceAll("\\s+", ""))) {
                                    sTATUS.status = 0;
                                    return dmdrv.encode(sTATUS);
                                }
                                if (string.equalsIgnoreCase(Dmdrv_V2.getDriverProperties().replaceAll("\\s+", "")) && !sTATUS.isAsync) {
                                    dlg.drv = new Dmdrv_V2();
                                    sTATUS.status = 0;
                                    return dmdrv.encode(sTATUS);
                                }
                            } else if (dmdrv instanceof Dmdrv_V2) {
                                if (string.equalsIgnoreCase(Dmdrv_V2.getDriverProperties().replaceAll("\\s+", ""))) {
                                    sTATUS.status = 0;
                                    return dmdrv.encode(sTATUS);
                                }
                            } else {
                                throw new RuntimeException("drv unknown");
                            }
                        }
                        sTATUS.status = 11;
                        return dmdrv.encode(sTATUS);
                    }
                    dlg.cmgr.handleSet(this, sTATUS);
                    return dmdrv.encode(sTATUS);
                }
                return false;
            }

            public int getValueInt() throws Status {
                if (this.v_type != 1) {
                    throw new Status(11);
                }
                return this.v_iv;
            }

            public String getValueString() throws Status {
                if (this.v_type != 2) {
                    throw new Status(11);
                }
                return this.v_sv;
            }

            void dispose() {
                this.path = null;
                this.attr = null;
                this.index = null;
                this.v_sv = null;
                this.v_bv = null;
            }
        }

        public static final class DEL
        extends Rq {
            public String path;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.STATUS sTATUS = dmdrv.rs_STATUS;
                    sTATUS.isAsync = (dlg.asyncMode & 1) != 0;
                    dlg.cmgr.handleDelete(this, sTATUS);
                    sTATUS.cacheMode = 0;
                    sTATUS.attrMode = 0;
                    return dmdrv.encode(sTATUS);
                }
                return false;
            }

            void dispose() {
                this.path = null;
            }
        }

        public static final class NEW
        extends Rq {
            public String path;
            public String classnm;

            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.STATUS sTATUS = dmdrv.rs_STATUS;
                    sTATUS.isAsync = (dlg.asyncMode & 1) != 0;
                    dlg.cmgr.handleNew(this, sTATUS);
                    sTATUS.cacheMode = 0;
                    sTATUS.attrMode = 0;
                    return dmdrv.encode(sTATUS);
                }
                return false;
            }

            void dispose() {
                this.path = null;
                this.classnm = null;
            }
        }

        public static final class LOAD
        extends Rq {
            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.LOAD lOAD = dmdrv.rs_LOAD;
                    lOAD.status = 2;
                    return dmdrv.encode(lOAD);
                }
                return false;
            }
        }

        public static final class STOP
        extends Rq {
            boolean exec(Dlg dlg) throws InterruptedException {
                Dmdrv dmdrv = dlg.drv;
                if (dmdrv.decode(this)) {
                    Rs.STATUS sTATUS = dmdrv.rs_STATUS;
                    sTATUS.isAsync = (dlg.asyncMode & 1) != 0;
                    dlg.stopReceived();
                    dlg.cmgr.handleStop(this, sTATUS);
                    sTATUS.cacheMode = 0;
                    sTATUS.attrMode = 0;
                    return dmdrv.encode(sTATUS);
                }
                return false;
            }
        }
    }
}

